#!/bin/bash
# This is a script which will be launched by the software-packages plugin just
# after the RPM install transaction complete, and just before the rest of
# patching scripts get called.

chgrp cis /usr/java/jre-vmware/bin
chmod 755 /usr/java/jre-vmware/bin
chgrp cis /usr/java/jre-vmware/bin/java
chmod 755 /usr/java/jre-vmware/bin/java

# enforce HTTPS for the Content Library service
perl -pi -e 's/allow\s+allow/redirect allow/' /etc/vmware-rhttpproxy/endpoints.conf.d/cls.conf

# Reload the firewall in case there were new services added as the rpms were installed
/usr/lib/applmgmt/networking/bin/firewall-reload

# Remove vsphere-client vmon configuration file
if [ -f "$1/vsphere_ui/uninstall-vshpere-client.txt" ]; then
   rm -f /etc/vmware/vmware-vmon/svcCfgfiles/vsphere-client.json
fi

# Remove prepare_for_restore script
if [ -f "/usr/lib/restore/prepare_for_restore.sh" ]; then
   rm -f /usr/lib/restore/prepare_for_restore.sh
fi

# Relink all the java launchers to point to $VMWARE_JAVA_HOME/bin/java
SCRIPT=$(readlink -f "$0")
SCRIPTPATH=$(dirname "$SCRIPT")
python ${SCRIPTPATH}/patches/payload/components-script/first_component/relink_launchers.py

usr_sbin_dir="/usr/sbin"
# The presence of this file in the vCSA indicates the OpenSSL that
# it must boot in FIPS mode.
FIPS_MODE_SWITCH_FILE2="/etc/vmware/system_fips"

# OpenSSL FIPS mode depends on FSS: VC_FIPS
# Do not enable on Cloud Gateway
if grep -q "VC_FIPS" /usr/lib/vmware/site-packages/featureState.py &&
   ! grep -q "VMware-vCenter-Cloud-Gateway" /etc/vmware/.buildInfo
then
    source ${usr_sbin_dir}/bash-feature-state-wrapper.sh
    if isFeatureEnabled VC_FIPS ; then
       # Enabling FPS mode. Creating the FIPS switch file. It will be used by:
       # https://github.com/vmware/photon/blob/master/SPECS/openssl/openssl-drbg-default-read-system-fips.patch
       touch ${FIPS_MODE_SWITCH_FILE2}
       echo "$(date): OpenSSL FIPS mode is enabled."
    else
       # Remove the whole else branch once the FSS is removed from vsphereFeatures.h file.
       # Disabling FIPS mode. Deleting the FIPS switch file.
       rm -rf ${FIPS_MODE_SWITCH_FILE2}
       echo "$(date): OpenSSL FIPS mode is disabled."
    fi
else
    echo "$(date): VC_FIPS is not present or running in Cloud Gateway."
fi

# workaround to re-image initrd after rpm installation. more details in PR-2884898
mkinitrd
true
