# Copyright 2015 VMware, Inc.  All rights reserved. -- VMware Confidential
#
'''Global resource provider.'''

import os
import logging

logger = logging.getLogger(__name__)

_rootDir = None

def setRootDirectory(directory):
    '''Sets the root directory. Thus the module would know where to
    look for payload, libs and config directories.

    @param directory: Directory where PatchRunner is located
    @type directory: str
    '''
    global _rootDir
    if _rootDir:
        raise ValueError("The resource provider has been already initialized")
    _rootDir = directory

def getRootDirectory():
    '''Returns root directory.

    @rtype: str
    '''
    if not _rootDir:
        raise ValueError('resource_utils module is not properly setup.')
    return _rootDir

def getPayloadFilePath(resourcePath):
    '''Finds a file path to the given resource from payload directory.

    @param resourcePath: Relative path to the resource
    '''
    return os.path.join(getRootDirectory(), 'payload', resourcePath)

def getLibFilePath(resourcePath):
    '''Finds a file path to the given resource from libs directory.

    @param resourcePath: Relative path to the resource
    '''
    return os.path.join(getRootDirectory(), 'libs', resourcePath)

def getConfigFilePath(resourcePath):
    '''Finds a file path to the given resource from config directory.

    @param resourcePath: Relative path to the resource
    '''
    return os.path.join(getRootDirectory(), 'config', resourcePath)