# Copyright 2020 VMware, Inc.  All rights reserved. -- VMware Confidential
#
'''
Script responsible to setup environment and execute the Expand hook of vCSA
components. The script calls only those components which have been discovered
in prior discovery phase.
'''

import logging
from extensions import Hook

from vmware_b2b.patching.utils.phase_utils import executeHook, setupStatusAggregator
from vmware_b2b.patching.data.model import PatchPhaseContext

logger = logging.getLogger(__name__)


def expand(stageDir, userData, outputFile):
    '''The entry point of expand CPO phase.

    The Expand  phase is responsible to setup the environment and execute the
    expand hook of vCSA components. The expand hook is executed only
    on those components which have been discovered in prior discovery phase.

    @param stageDir: global CPO stage directory. All components stage
      directories will be created as sub-directories of global stage directory.
    @type stageDir: str

    @param userData: Customer input, as result of component questions raised
      in @Discovery patching hook.
    @type userData: dict

    @param outputFile: File where the output of the command needs to be written
      to
    @type outputFile: str

    @return: True if the Expand phase succeed and False otherwise
    @rtype: bool
    '''
    ctx = PatchPhaseContext.load(stageDir)

    with setupStatusAggregator(ctx, outputFile, [Hook.Expand]) as statusAggregator:
        logger.info("Running %s phase", Hook.Expand)
        return executeHook(Hook.Expand, ctx, userData, statusAggregator)
