# Copyright 2015 VMware, Inc.  All rights reserved. -- VMware Confidential
#
'''
Module responsible to create an executor based on defined execution policy.
'''

from vmware_b2b.patching.config import settings
from vmware_b2b.patching.executor import hook_executor, hook_executor_process

def getExecutor():
    '''Creates a patching hook executor based on defined execution policy.

    @return: A object having following function signature:
        def executeHook(patchModulePath, hook, args):
            Executes a component patch hook in current python process.

            @param patchModulePath: Python module where component patching hooks are defined at
            @type patchModulePath: str

            @param hook: The patching hook which has to be executed. Allowed values are
              defined at extensions.Hook structure.
            @type hook: str

            @param args: The patching hooks input. The object will be passed to the
              the component patching hook.
            @type args: Serializable

            @return: The result of the patching hook
            @rtype: Serializable

            @raise: patch_errors.BaseError: If the component fails to be executed in
              the provided contract.
    @rtype: object
    '''
    if settings.executionPolicy == "oneProcess":
        return hook_executor
    else:
        return hook_executor_process
