# Copyright 2019 VMware, Inc.  All rights reserved. -- VMware Confidential
#
''' Module responsible to load global settings from <root_dir>/config/settings.json
'''
import os
import json
import logging

from vmware_b2b.patching.utils import resource_utils

class ConfigParsingError(ValueError):
    '''Thrown if configuration cannot be parsed or mandatory settings are omitted.
    '''

class LoggingData(object):
    '''Holder of logging settings
    '''
    def __init__(self, **kwargs):
        directory = kwargs.get('dir')
        if not directory:
            raise ConfigParsingError("logging.dir is not specified")
        self.directory = os.path.abspath(directory)
        self.rootName = kwargs.get('name', "patcher.log")

        self.level = kwargs.get('level', "INFO")
        if not hasattr(logging, self.level):
            raise ConfigParsingError("Improper logging.level argument '%s'" % self.level)

# Load the program setting in the module, so everyone can access them later.
configFile = resource_utils.getConfigFilePath("settings.json")
with open(configFile) as fp:
    configData = json.load(fp)

    loggingData = LoggingData(**configData['logging'])
    stageDir = configData['stagedir']
    executionPolicy = configData['executionPolicy']
    outputFile = configData['outputfile']