"""
Copyright 2020-2021 VMware, Inc.  All rights reserved. -- VMware Confidential
Utility Module
"""
import logging
from vstats import utils

logger = logging.getLogger(__name__)
PATCH_VERSION=3

sttdb_patch_script_02 = '/usr/lib/vmware-vstats/scripts/sttdb_patch02.sql'


def doPatching(ctx):
    logger.info("Applying patch_02 on vstats service")
    utils.runStateDBScript(sttdb_patch_script_02)

def is_patch_needed(current_version):
    return utils.is_patch_needed(current_version, PATCH_VERSION)

def doExpand(ctx):
    logger.info("No expand for version 2 on vstats service")

def doContract(ctx):
    logger.info("No contract for version 2 on vstats service")


