"""
Copyright 2020-2021 VMware, Inc.  All rights reserved. -- VMware Confidential
Utility Module
"""
import logging
import os
from vstats import utils

logger = logging.getLogger(__name__)
PATCH_VERSION=2

coredb_patch_script = '/usr/lib/vmware-vstats/scripts/coredb_patch01.sql'
sttdb_patch_script = '/usr/lib/vmware-vstats/scripts/sttdb_patch01.sql'
SQL_FOLDER = os.path.abspath(os.path.join(os.path.dirname(__file__), "db_scripts"))
coredb_expand_script = os.path.join(SQL_FOLDER, "coredb_expand01.sql")
coredb_contract_script = os.path.join(SQL_FOLDER, "coredb_contract01.sql")

def doPatching(ctx):
    logger.info("Applying patch_01 on vstats service")
    utils.runCoreDBScript(coredb_patch_script)
    utils.runStateDBScript(sttdb_patch_script)

def is_patch_needed(current_version):
    return utils.is_patch_needed(current_version, PATCH_VERSION)

def doExpand(ctx):
    logger.info("Applying expand patch_01 on vstats service")
    utils.runCoreDBScript(coredb_expand_script)

def doContract(ctx):
    logger.info("Applying contract for version 1 on vstats service")
    utils.runCoreDBScript(coredb_contract_script)