# -*- coding: utf-8 -*-
#---------------------------------------------------------------------------
# Copyright 2019 VMware, Inc.  All rights reserved.

# AUTO GENERATED FILE -- DO NOT MODIFY!
#
# vAPI stub file for package com.vmware.vcenter.trust.
#---------------------------------------------------------------------------

"""
The ``com.vmware.vcenter.trust_client`` module provides classes to manage
VcTrusts.

"""

__author__ = 'VMware, Inc.'
__docformat__ = 'restructuredtext en'

import sys

from vmware.vapi.bindings import type
from vmware.vapi.bindings.converter import TypeConverter
from vmware.vapi.bindings.enum import Enum
from vmware.vapi.bindings.error import VapiError
from vmware.vapi.bindings.struct import VapiStruct
from vmware.vapi.bindings.stub import (
    ApiInterfaceStub, StubFactoryBase, VapiInterface)
from vmware.vapi.bindings.common import raise_core_exception
from vmware.vapi.data.validator import (UnionValidator, HasFieldsOfValidator)
from vmware.vapi.exception import CoreException
from vmware.vapi.lib.constants import TaskType
from vmware.vapi.lib.rest import OperationRestMetadata


class VcTrusts(VapiInterface):
    """
    The ``VcTrusts`` interface provides methods to create, modify, delete and
    read vCenter trusts. **Warning:** This class is part of a new feature in
    development. It may be changed at any time and may not have all supported
    functionality implemented.
    **Note:** This class is restricted for **VMware internal use only**.
    """

    _VAPI_SERVICE_ID = 'com.vmware.vcenter.trust.vc_trusts'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _VcTrustsStub)

    class CreateSpec(VapiStruct):
        """
        The ``VcTrusts.CreateSpec`` class contains information to create a trust.
        **Warning:** This class is part of a new feature in development. It may be
        changed at any time and may not have all supported functionality
        implemented.
        **Note:** This class is restricted for **VMware internal use only**.

        .. tip::
            The arguments are used to initialize data attributes with the same
            names.
        """




        def __init__(self,
                     domain=None,
                     label=None,
                     type=None,
                     signing_cert_chains=None,
                     group_map=None,
                     upn_suffixes=None,
                    ):
            """
            :type  domain: :class:`str`
            :param domain: Domain identifier. **Warning:** This attribute is part of a new
                feature in development. It may be changed at any time and may not
                have all supported functionality implemented.
            :type  label: :class:`str`
            :param label: Label of the trust. A non-unique, user-readable label. **Warning:**
                This attribute is part of a new feature in development. It may be
                changed at any time and may not have all supported functionality
                implemented.
            :type  type: :class:`str` or ``None``
            :param type: Type of trust, used to distinguish between different types of
                domains such as cloud or on-prem. **Warning:** This attribute is
                part of a new feature in development. It may be changed at any time
                and may not have all supported functionality implemented.
                Type will only be added if provided.
            :type  signing_cert_chains: :class:`list` of :class:`com.vmware.vcenter.certificate_management_client.X509CertChain`
            :param signing_cert_chains: List of signing certificate chains. At least one cert chain is
                required. Private key is not included. **Warning:** This attribute
                is part of a new feature in development. It may be changed at any
                time and may not have all supported functionality implemented.
            :type  group_map: (:class:`dict` of :class:`str` and :class:`list` of :class:`str`) or ``None``
            :param group_map: Maps a group in an existing token to a list of local SSO groups in
                the local domain. Map key is expected to be in UPN/email address
                format. Example is group name and domain name separated by '\\\\@':
                <group-name>\\\\@<domain-name> Map value is the name of an existing
                group. **Warning:** This attribute is part of a new feature in
                development. It may be changed at any time and may not have all
                supported functionality implemented.
                group map will only be added if provided.
            :type  upn_suffixes: :class:`list` of :class:`str`
            :param upn_suffixes: List of the UPN suffixes used in this trust relationship. Must
                contain at least one entry for the trusted domain. **Warning:**
                This attribute is part of a new feature in development. It may be
                changed at any time and may not have all supported functionality
                implemented.
            """
            self.domain = domain
            self.label = label
            self.type = type
            self.signing_cert_chains = signing_cert_chains
            self.group_map = group_map
            self.upn_suffixes = upn_suffixes
            VapiStruct.__init__(self)


    CreateSpec._set_binding_type(type.StructType(
        'com.vmware.vcenter.trust.vc_trusts.create_spec', {
            'domain': type.StringType(),
            'label': type.StringType(),
            'type': type.OptionalType(type.StringType()),
            'signing_cert_chains': type.ListType(type.ReferenceType('com.vmware.vcenter.certificate_management_client', 'X509CertChain')),
            'group_map': type.OptionalType(type.MapType(type.StringType(), type.ListType(type.StringType()))),
            'upn_suffixes': type.ListType(type.StringType()),
        },
        CreateSpec,
        False,
        None))


    class UpdateSpec(VapiStruct):
        """
        The ``VcTrusts.UpdateSpec`` class contains data to update a VcTrusts spec.
        **Warning:** This class is part of a new feature in development. It may be
        changed at any time and may not have all supported functionality
        implemented.
        **Note:** This class is restricted for **VMware internal use only**.

        .. tip::
            The arguments are used to initialize data attributes with the same
            names.
        """




        def __init__(self,
                     label=None,
                     type=None,
                     signing_cert_chains=None,
                     group_map=None,
                     upn_suffixes=None,
                    ):
            """
            :type  label: :class:`str` or ``None``
            :param label: Label of the trust. A non-unique, user-readable label. **Warning:**
                This attribute is part of a new feature in development. It may be
                changed at any time and may not have all supported functionality
                implemented.
                If unspecified, leaves value unchanged.
            :type  type: :class:`str` or ``None``
            :param type: Type of trust, used to distinguish between different types of
                domains such as cloud or on-prem. **Warning:** This attribute is
                part of a new feature in development. It may be changed at any time
                and may not have all supported functionality implemented.
                If unspecified, leaves value unchanged.
            :type  signing_cert_chains: :class:`list` of :class:`com.vmware.vcenter.certificate_management_client.X509CertChain` or ``None``
            :param signing_cert_chains: List of signing certificate chains which will replace existing
                chain. **Warning:** This attribute is part of a new feature in
                development. It may be changed at any time and may not have all
                supported functionality implemented.
                If unspecified, leaves value unchanged.
            :type  group_map: (:class:`dict` of :class:`str` and :class:`list` of :class:`str`) or ``None``
            :param group_map: Mapping of group in existing token to a list of local SSO groups in
                the local domain for new token. If empty, deletes all existing
                mappings. **Warning:** This attribute is part of a new feature in
                development. It may be changed at any time and may not have all
                supported functionality implemented.
                If unspecified, leaves value unchanged.
            :type  upn_suffixes: :class:`list` of :class:`str` or ``None``
            :param upn_suffixes: Lists the UPN suffixes used in this trust relationship.
                **Warning:** This attribute is part of a new feature in
                development. It may be changed at any time and may not have all
                supported functionality implemented.
                If unspecified, leaves value unchanged.
            """
            self.label = label
            self.type = type
            self.signing_cert_chains = signing_cert_chains
            self.group_map = group_map
            self.upn_suffixes = upn_suffixes
            VapiStruct.__init__(self)


    UpdateSpec._set_binding_type(type.StructType(
        'com.vmware.vcenter.trust.vc_trusts.update_spec', {
            'label': type.OptionalType(type.StringType()),
            'type': type.OptionalType(type.StringType()),
            'signing_cert_chains': type.OptionalType(type.ListType(type.ReferenceType('com.vmware.vcenter.certificate_management_client', 'X509CertChain'))),
            'group_map': type.OptionalType(type.MapType(type.StringType(), type.ListType(type.StringType()))),
            'upn_suffixes': type.OptionalType(type.ListType(type.StringType())),
        },
        UpdateSpec,
        False,
        None))


    class Info(VapiStruct):
        """
        The ``VcTrusts.Info`` class contains data that represents a trust.
        **Warning:** This class is part of a new feature in development. It may be
        changed at any time and may not have all supported functionality
        implemented.
        **Note:** This class is restricted for **VMware internal use only**.

        .. tip::
            The arguments are used to initialize data attributes with the same
            names.
        """




        def __init__(self,
                     label=None,
                     type=None,
                     signing_cert_chains=None,
                     group_map=None,
                     upn_suffixes=None,
                    ):
            """
            :type  label: :class:`str`
            :param label: Label of the trust. **Warning:** This attribute is part of a new
                feature in development. It may be changed at any time and may not
                have all supported functionality implemented.
            :type  type: :class:`str`
            :param type: Type of trust. **Warning:** This attribute is part of a new feature
                in development. It may be changed at any time and may not have all
                supported functionality implemented.
            :type  signing_cert_chains: :class:`list` of :class:`com.vmware.vcenter.certificate_management_client.X509CertChain`
            :param signing_cert_chains: List of signing certificate chains. **Warning:** This attribute is
                part of a new feature in development. It may be changed at any time
                and may not have all supported functionality implemented.
            :type  group_map: :class:`dict` of :class:`str` and :class:`list` of :class:`str`
            :param group_map: Mapping of group in existing token to a list of local SSO groups in
                the local domain for new token. If empty, no group mappings have
                been configured. **Warning:** This attribute is part of a new
                feature in development. It may be changed at any time and may not
                have all supported functionality implemented.
            :type  upn_suffixes: :class:`list` of :class:`str`
            :param upn_suffixes: Lists the UPN suffixes used in this trust relationship.
                **Warning:** This attribute is part of a new feature in
                development. It may be changed at any time and may not have all
                supported functionality implemented.
            """
            self.label = label
            self.type = type
            self.signing_cert_chains = signing_cert_chains
            self.group_map = group_map
            self.upn_suffixes = upn_suffixes
            VapiStruct.__init__(self)


    Info._set_binding_type(type.StructType(
        'com.vmware.vcenter.trust.vc_trusts.info', {
            'label': type.StringType(),
            'type': type.StringType(),
            'signing_cert_chains': type.ListType(type.ReferenceType('com.vmware.vcenter.certificate_management_client', 'X509CertChain')),
            'group_map': type.MapType(type.StringType(), type.ListType(type.StringType())),
            'upn_suffixes': type.ListType(type.StringType()),
        },
        Info,
        False,
        None))


    class Summary(VapiStruct):
        """
        The ``VcTrusts.Summary`` class contains a trust summary suitable for UI
        presentation. **Warning:** This class is part of a new feature in
        development. It may be changed at any time and may not have all supported
        functionality implemented.
        **Note:** This class is restricted for **VMware internal use only**.

        .. tip::
            The arguments are used to initialize data attributes with the same
            names.
        """




        def __init__(self,
                     domain=None,
                     label=None,
                     type=None,
                    ):
            """
            :type  domain: :class:`str`
            :param domain: Domain identifier. **Warning:** This attribute is part of a new
                feature in development. It may be changed at any time and may not
                have all supported functionality implemented.
            :type  label: :class:`str`
            :param label: Label of the trust. **Warning:** This attribute is part of a new
                feature in development. It may be changed at any time and may not
                have all supported functionality implemented.
            :type  type: :class:`str`
            :param type: Type of trust. **Warning:** This attribute is part of a new feature
                in development. It may be changed at any time and may not have all
                supported functionality implemented.
            """
            self.domain = domain
            self.label = label
            self.type = type
            VapiStruct.__init__(self)


    Summary._set_binding_type(type.StructType(
        'com.vmware.vcenter.trust.vc_trusts.summary', {
            'domain': type.StringType(),
            'label': type.StringType(),
            'type': type.StringType(),
        },
        Summary,
        False,
        None))



    def list(self):
        """
        Returns summary information for each trust of the local node.
        **Warning:** This method is part of a new feature in development. It
        may be changed at any time and may not have all supported functionality
        implemented.


        :rtype: :class:`list` of :class:`VcTrusts.Summary`
        :return: List of trust summaries.
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            if authorization is not given to caller.
        """
        return self._invoke('list', None)

    def create(self,
               spec,
               ):
        """
        Creates a new trust for domain in given spec. **Warning:** This method
        is part of a new feature in development. It may be changed at any time
        and may not have all supported functionality implemented.

        :type  spec: :class:`VcTrusts.CreateSpec`
        :param spec: The information needed to create a trust.
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            if authorization is not given to caller.
        :raise: :class:`com.vmware.vapi.std.errors_client.AlreadyExists` 
            if trust exists for domain in given spec.
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidArgument` 
            if groupMap key is not in UPN format, if group value is not found
            or if at least one upn suffix is not given.
        """
        return self._invoke('create',
                            {
                            'spec': spec,
                            })

    def get(self,
            domain,
            ):
        """
        Retrieve trust for given domain. **Warning:** This method is part of a
        new feature in development. It may be changed at any time and may not
        have all supported functionality implemented.

        :type  domain: :class:`str`
        :param domain: Unique identifier for a domain.
        :rtype: :class:`VcTrusts.Info`
        :return: Trust information.
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            if authorization is not given to caller.
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            if a trust does not exist for given domain.
        """
        return self._invoke('get',
                            {
                            'domain': domain,
                            })

    def delete(self,
               domain,
               ):
        """
        Deletes a trust for given domain. **Warning:** This method is part of a
        new feature in development. It may be changed at any time and may not
        have all supported functionality implemented.

        :type  domain: :class:`str`
        :param domain: Unique identifier for a domain.
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            if authorization is not given to caller.
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            if a trust does not exist for given domain.
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidArgument` 
            if the local domain is specified.
        """
        return self._invoke('delete',
                            {
                            'domain': domain,
                            })

    def update(self,
               domain,
               spec,
               ):
        """
        Update a trust for given domain with data in given UpdateSpec.
        **Warning:** This method is part of a new feature in development. It
        may be changed at any time and may not have all supported functionality
        implemented.

        :type  domain: :class:`str`
        :param domain: Unique identifier for a domain.
        :type  spec: :class:`VcTrusts.UpdateSpec`
        :param spec: Trust update spec which contains the data to be updated.
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            if authorization is not given to caller.
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            if a VcTrusts does not exist for given domain.
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidArgument` 
            if no arguments are provided in update spec.
        """
        return self._invoke('update',
                            {
                            'domain': domain,
                            'spec': spec,
                            })
class _VcTrustsStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for list operation
        list_input_type = type.StructType('operation-input', {})
        list_error_dict = {
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),

        }
        list_input_value_validator_list = [
        ]
        list_output_validator_list = [
        ]
        list_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/vcenter/trust/vc-trusts',
            path_variables={
            },
            query_parameters={
            }
        )

        # properties for create operation
        create_input_type = type.StructType('operation-input', {
            'spec': type.ReferenceType(__name__, 'VcTrusts.CreateSpec'),
        })
        create_error_dict = {
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.already_exists':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'AlreadyExists'),
            'com.vmware.vapi.std.errors.invalid_argument':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidArgument'),

        }
        create_input_value_validator_list = [
        ]
        create_output_validator_list = [
        ]
        create_rest_metadata = OperationRestMetadata(
            http_method='POST',
            url_template='/vcenter/trust/vc-trusts',
            path_variables={
            },
            query_parameters={
            }
        )

        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'domain': type.StringType(),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/vcenter/trust/vc-trusts/{domain-id}',
            path_variables={
                'domain': 'domain-id',
            },
            query_parameters={
            }
        )

        # properties for delete operation
        delete_input_type = type.StructType('operation-input', {
            'domain': type.StringType(),
        })
        delete_error_dict = {
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),
            'com.vmware.vapi.std.errors.invalid_argument':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidArgument'),

        }
        delete_input_value_validator_list = [
        ]
        delete_output_validator_list = [
        ]
        delete_rest_metadata = OperationRestMetadata(
            http_method='DELETE',
            url_template='/vcenter/trust/vc-trusts/{domain-id}',
            path_variables={
                'domain': 'domain-id',
            },
            query_parameters={
            }
        )

        # properties for update operation
        update_input_type = type.StructType('operation-input', {
            'domain': type.StringType(),
            'spec': type.ReferenceType(__name__, 'VcTrusts.UpdateSpec'),
        })
        update_error_dict = {
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),
            'com.vmware.vapi.std.errors.invalid_argument':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidArgument'),

        }
        update_input_value_validator_list = [
        ]
        update_output_validator_list = [
        ]
        update_rest_metadata = OperationRestMetadata(
            http_method='PATCH',
            url_template='/vcenter/trust/vc-trusts/{domain-id}',
            path_variables={
                'domain': 'domain-id',
            },
            query_parameters={
            }
        )

        operations = {
            'list': {
                'input_type': list_input_type,
                'output_type': type.ListType(type.ReferenceType(__name__, 'VcTrusts.Summary')),
                'errors': list_error_dict,
                'input_value_validator_list': list_input_value_validator_list,
                'output_validator_list': list_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'create': {
                'input_type': create_input_type,
                'output_type': type.VoidType(),
                'errors': create_error_dict,
                'input_value_validator_list': create_input_value_validator_list,
                'output_validator_list': create_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType(__name__, 'VcTrusts.Info'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'delete': {
                'input_type': delete_input_type,
                'output_type': type.VoidType(),
                'errors': delete_error_dict,
                'input_value_validator_list': delete_input_value_validator_list,
                'output_validator_list': delete_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'update': {
                'input_type': update_input_type,
                'output_type': type.VoidType(),
                'errors': update_error_dict,
                'input_value_validator_list': update_input_value_validator_list,
                'output_validator_list': update_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'list': list_rest_metadata,
            'create': create_rest_metadata,
            'get': get_rest_metadata,
            'delete': delete_rest_metadata,
            'update': update_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.vcenter.trust.vc_trusts',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=True)


class StubFactory(StubFactoryBase):
    _attrs = {
        'VcTrusts': VcTrusts,
    }

