#!/usr/bin/env python

#
# Copyright 2021 VMware, Inc.  All rights reserved. -- VMware Confidential
#

import logging
import os

from .path_constants import H5C_CONFIG_DIR

logger = logging.getLogger(__name__)


def remove_user_compatibility_matrix():
    """
    Removes the vSphere UI user compatibility matrix.
    """
    user_compatibility_matrix_file = os.path.join(H5C_CONFIG_DIR, "compatibility-matrix.xml")

    logger.info("Removing the user-defined plugin compatibility matrix.")
    if os.path.exists(user_compatibility_matrix_file):
        os.remove(user_compatibility_matrix_file)
        logger.info(
            "File %s was deleted successfully." % user_compatibility_matrix_file)
    else:
        logger.info("File %s does not exist." % user_compatibility_matrix_file)
