#
# Copyright 2019-2021 VMware, Inc.  All rights reserved. -- VMware Confidential
#
import os

CONFIG_DIR = '/etc/vmware'
BUILD_INFO_FILE = os.path.join(CONFIG_DIR, '.buildInfo')
H5C_CONFIG_DIR = os.path.join(CONFIG_DIR, 'vsphere-ui')
H5C_PATCH_VERSION_FILE = os.path.join(H5C_CONFIG_DIR, 'patch_version.txt')
VSPHERE_UI_CISREG_FILE = os.path.join(H5C_CONFIG_DIR, 'firstboot', 'cisreg.prop')
VSPHERE_UI_UPGRADE_MARKER_FILE = os.path.join(H5C_CONFIG_DIR, 'upgrade.marker')
VSPHERE_UI_UPGRADE_MARKER_FILE_TEMPLATE = 'vsphere_ui_upgrade_marker.template'

VSPHERE_UI_ROOT_DIR = '/usr/lib/vmware-vsphere-ui'

VIRGO_SERVER_HOME_DIR = '/usr/lib/vmware-virgo'

VIRGO_INSTANCE_BASE_DIR = os.path.join(VSPHERE_UI_ROOT_DIR, 'server')
VIRGO_INSTANCE_CONFIG_DIR = os.path.join(VIRGO_INSTANCE_BASE_DIR, 'configuration')
VIRGO_INSTANCE_REPOSITORY_DIR = os.path.join(VIRGO_INSTANCE_BASE_DIR, 'repository')
VIRGO_INSTANCE_WRAPPER_DIR = os.path.join(VIRGO_INSTANCE_BASE_DIR, 'wrapper')
