/* *************************************************************************
 * Copyright 2021 VMware, Inc.   All rights reserved. -- VMware Confidential
 * *************************************************************************/

\set ON_ERROR_STOP on

\set SEARCH_PATH TO vc, cns, pg_catalog


/* Begin 53 */
/*=======================================================================================================================*/
/*  Add new column static_provision to the table volume_info                                                             */
/*  This is the new column added in 7u1 release                                                                          */
/*=======================================================================================================================*/
SELECT vc.vcdb_ndu_cln_processor(
$$INSERT INTO vc.VPX_VCDB_NDU_EXP (CLN_ID, RELEASE, CLN_STATUS) VALUES (53, 701, '') ON CONFLICT (CLN_ID) DO NOTHING;$$,
$$CALL vc.vcdb_ndu_add_column(53,'smi-dev',701,'cns','volume_info', 'static_provision', 'BOOLEAN DEFAULT FALSE');$$
);
/* End 53 */

/* Begin 54 */
/*=======================================================================================================================*/
/*  Add new column capacity  to the table volume_info                                                                    */
/*  This is the new column added in 7u2 release                                                                          */
/*=======================================================================================================================*/
SELECT vc.vcdb_ndu_cln_processor(
$$INSERT INTO vc.VPX_VCDB_NDU_EXP (CLN_ID, RELEASE, CLN_STATUS) VALUES (54, 702, '') ON CONFLICT (CLN_ID) DO NOTHING;$$,
$$CALL vc.vcdb_ndu_add_column(54,'smi-dev',702,'cns','volume_info', 'capacity', 'INT DEFAULT 0');$$
);
/* End 54 */

/* Begin 55 */
/*===========================================================================================================================*/
/*  Add new columns vclock,is_cns_volume,disk_path,backing_object_id,used_capacity and create_time  to the table volume_info.*/
/*  These are the new columns added in main (70u3) release                                                                   */
/*===========================================================================================================================*/
SELECT vc.vcdb_ndu_cln_processor(
$$INSERT INTO vc.VPX_VCDB_NDU_EXP (CLN_ID, RELEASE, CLN_STATUS) VALUES (55, 703, '') ON CONFLICT (CLN_ID) DO NOTHING;$$,
$$CALL vc.vcdb_ndu_add_column(55,'smi-dev',703,'cns','volume_info','vclock', 'BIGINT DEFAULT -1');$$,
$$CALL vc.vcdb_ndu_add_column(55,'smi-dev',703,'cns','volume_info','is_cns_volume', 'BOOLEAN DEFAULT TRUE');$$,
$$CALL vc.vcdb_ndu_add_column(55,'smi-dev',703,'cns','volume_info','disk_path', 'TEXT NULL');$$,
$$CALL vc.vcdb_ndu_add_column(55,'smi-dev',703,'cns','volume_info','backing_object_id', 'VARCHAR(60)');$$,
$$CALL vc.vcdb_ndu_add_column(55,'smi-dev',703,'cns','volume_info','used_capacity', 'BIGINT DEFAULT -1');$$,
$$CALL vc.vcdb_ndu_add_column(55,'smi-dev',703,'cns','volume_info','create_time', 'TIMESTAMP DEFAULT CURRENT_TIMESTAMP');$$
);
/* End 55 */

/*==============================END OF FILE================================*/

/*=========================================================================*/
/*                                                                         */
/*               DO NOT ADD CHANGES AFTER THIS COMMENT BOX                 */
/*                                                                         */
/*=========================================================================*/
