#!/usr/bin/env python
#
# Copyright (c) 2020-2022 VMware, Inc.  All rights reserved.
# -- VMware Confidential
#

import logging
import os
import sys
from cis.utils import readprop, write_props_to_file, replace_properties_in_file

vmware_python_path = os.getenv('VMWARE_PYTHON_PATH')
if vmware_python_path and os.path.exists(vmware_python_path):
    sys.path.append(vmware_python_path)

hvc_prop = '/usr/lib/vmware-hvc/config/hvc.properties'

logger = logging.getLogger(__name__)


def is_vmc_gateway():
    is_gateway_str = readprop(hvc_prop, "hvc.link.v2")
    if is_gateway_str is None:
        return False
    if is_gateway_str.lower() == 'true':
        logger.info("Gateway appliance detected")
        return True
    else:
        return False


def add_or_update_property(prop_file, prop_key, prop_new_val):
    prop_val_from_file = readprop(prop_file, prop_key)
    prop = [(prop_key, prop_new_val)]
    if prop_val_from_file is None:
        write_props_to_file(prop_file, prop, mode='a')
    if prop_val_from_file != prop_new_val:
        new_prop = {prop_key: prop_new_val}
        replace_properties_in_file(prop_file, new_prop)
