# Copyright (c) 2022 VMware, Inc.  All rights reserved. -- VMware Confidential

import os
import sys
import logging
from l10n import msgMetadata as _T, localizedString as _

VPXD_SVCS_PATCHES_DIR = os.path.dirname(os.path.dirname(__file__))
sys.path.append(VPXD_SVCS_PATCHES_DIR)
sys.path.append(os.environ['VMWARE_PYTHON_PATH'])
sys.path.append(os.path.dirname("/usr/lib/vmware-cm/bin/"))
from cis.utils import replace_properties_in_file
from constants import DATASERVICES_PROP, VERSION
from utils import add_or_update_property

logger = logging.getLogger(__name__)


def getChanges():
    return _(_T("vpxd-svcs.patch.summary",
                "Rotate access log"))


def doPatching(ctx):
    logger.info("vpxd-svcs.patch: being executed %s", ctx)
    """
    Add variables for rotating the access log.
    """
    add_or_update_property(DATASERVICES_PROP, 'dataservice.access.logging.prefix', 'vpxd-svcs-access')
    add_or_update_property(DATASERVICES_PROP, 'dataservice.access.logging.maxDays', '0')
    add_or_update_property(DATASERVICES_PROP, 'dataservice.access.logging.checkExists', 'true')
    add_or_update_property(DATASERVICES_PROP, 'dataservice.access.logging.maxSize', '1048576')
    add_or_update_property(DATASERVICES_PROP, 'dataservice.access.logging.frequencySeconds', '600')
    replace_properties_in_file(DATASERVICES_PROP, {VERSION: 12})
