# Copyright (c) 2022 VMware, Inc.  All rights reserved. -- VMware Confidential

import os
import sys
import logging
from l10n import msgMetadata as _T, localizedString as _

VPXD_SVCS_PATCHES_DIR = os.path.dirname(os.path.dirname(__file__))
sys.path.append(VPXD_SVCS_PATCHES_DIR)
sys.path.append(os.environ['VMWARE_PYTHON_PATH'])
sys.path.append(os.path.dirname("/usr/lib/vmware-cm/bin/"))
from cis.utils import write_props_to_file, replace_properties_in_file
from constants import (DATASERVICES_PROP, VERSION,
                        VPXD_SVCS_CONFIG_DIR)
from utils import is_vmc_gateway, add_or_update_property

logger = logging.getLogger(__name__)

def getChanges():
    return _(_T("vpxd-svcs.patch.summary",
                "Disable PerfmonReportServlet by default"))

def doPatching(ctx):
    logger.info("vpxd-svcs.patch: being executed %s", ctx)
    """
    This patch needs to disable a servlet that publishes
    metrics details where vpxd-svcs service is running.
    """
    PERF_REPORT = 'dataservice.perfmonreport.enabled'
    PERF_REPORT_FALSE_VALUE = 'false'
    add_or_update_property(DATASERVICES_PROP, PERF_REPORT, PERF_REPORT_FALSE_VALUE)
    replace_properties_in_file(DATASERVICES_PROP, {VERSION: 11})
