#!/usr/bin/env python

#
# Copyright 2019 VMware, Inc.  All rights reserved. -- VMware Confidential
#
"""
Patch script that does the following:
Fixes grpc endpoint registration if it is incorrect
"""
import patch_05
import logging
import os
import sys

from l10n import msgMetadata as _T, localizedString as _

VPXD_SVCS_PATCHES_DIR = os.path.dirname(os.path.dirname(__file__))
sys.path.append(VPXD_SVCS_PATCHES_DIR)

vmware_python_path = os.getenv('VMWARE_PYTHON_PATH')
if vmware_python_path and os.path.exists(vmware_python_path):
    sys.path.append(vmware_python_path)

from cis.utils import replace_properties_in_file
from constants import DATASERVICES_PROP, VERSION
from fss_utils import getTargetFSS


logger = logging.getLogger(__name__)

def getChanges():
    return _(_T("vpxd-svcs.patch.summary",
                "Register GRPC endpoints for tagging service"))

def doPatching(ctx):
    if getTargetFSS("HybridVC_SyncaaS"):
        logger.info("vpxd-svcs patch: being executed %s", ctx)
        patch_05.doPatching(ctx)
        replace_properties_in_file(DATASERVICES_PROP, {VERSION: 6})

