# Copyright (c) 2017-2020 VMware, Inc.  All rights reserved. -- VMware Confidential

import os
import sys
import logging
from l10n import msgMetadata as _T, localizedString as _

VPXD_SVCS_PATCHES_DIR = os.path.dirname(os.path.dirname(__file__))
sys.path.append(VPXD_SVCS_PATCHES_DIR)
sys.path.append(os.environ['VMWARE_PYTHON_PATH'])
from constants import *
from cis.utils import read_properties
from utils import is_vmc_gateway

logger = logging.getLogger(__name__)


def getChanges():
    return _(_T("vpxd-svcs.patch.summary",
                "Updates dataservices.properties file with Compute Policy "
                "related properties."))


def doPatching(ctx):
    """
    Updates the dataservices.properties file with the following properties:
    computepolicy.vcdb.config.extraProperties.key1 and
    computepolicy.vcdb.config.extraProperties.value1.
    """
    if is_vmc_gateway():
       return
    logger.info("vpxd-svcs.patch: being executed %s", ctx)
    write_cp_props(DATASERVICES_PROP)
    logger.info("vpxd-svcs.patch: dataservices properties file updated")


def write_cp_props(a_file):
    """
    Updates the dataservices.properties file with the following compute policy
    related properties:
    computepolicy.vcdb.config.extraProperties.key1 and
    computepolicy.vcdb.config.extraProperties.value1.
    """
    cp_props = read_properties(DATASERVICES_PROP_NEW, CP_PROP_KEYS)
    with open(a_file, "a") as prop_file:
        prop_file.write("# Compute policy specific vcdb properties\n")
        for key, value in list(cp_props.items()):
            prop_file.write("{}={}\n".format(key, value))
