# Copyright 2020 VMware, Inc.
# All rights reserved. -- VMware Confidential

import logging
import xml.etree.ElementTree as ET

SSL_PROTOCOLS = "TLSv1.2"
SERVER_XML_FILE = "/usr/lib/vmware-sso/vmware-sts/conf/server.xml"

logger = logging.getLogger(__name__)


def do_patching(ctx):
    tree = ET.parse(SERVER_XML_FILE)
    root = tree.getroot()
    for entry in root:
        if entry.tag == 'Service' and entry.attrib['name'] == 'Catalina':
            for child in entry:
                if child.tag == 'Connector' and child.get("SSLEnabled") != None:
                    for ch in child:
                        if ch.tag == 'SSLHostConfig':
                            ch.set('protocols', SSL_PROTOCOLS)
                            break
    tree.write(SERVER_XML_FILE)