# Copyright 2017 VMware, Inc.
# All rights reserved. -- VMware Confidential
''' Module to validate vmdir password. If exit code is not 0 password is not valid
'''
import sys
import os

sys.path.append(os.path.dirname(__file__))

from utils import PatchUtilsLin

def main(args):
    password=  sys.stdin.read()
    if not PatchUtilsLin()._validatePassword(password):
        return 1
    return 0

if __name__ == "__main__":
    try:
        sys.exit(main(sys.argv))
    except Exception as ex: # pylint: disable=W0702
        # Generic exception handler
        sys.stderr.write('Exception %s' % ex)
        sys.exit(2)