/* **********************************************************
 * Copyright 2021 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

BEGIN;

/*
 * Holds information for Cancellation Policy
 */
CREATE TABLE IF NOT EXISTS NduCancellationPolicy (
  UUID UUID REFERENCES NduUpgrade(UUID),
  AUTO_CANCEL BOOLEAN,
  CANCEL_METHODS TEXT[],
  HAS_SOURCE_CONNECTION BOOLEAN,

  /* SourceConnection */
  CONNECTION_TYPE VARCHAR(64),
  IP_ADDRESS VARCHAR(64),
  SOURCE_PASSWORD VARCHAR(256),
  CONNECTIONS Json,
  PRIMARY KEY (UUID)
);

ALTER TABLE NduUpgradeParameters
    ADD SHUTDOWN_SOURCE VARCHAR(64);

INSERT INTO UpgradeTracking VALUES(:ndu_id, :ndu_operation);

COMMIT;