/* **********************************************************
 * Copyright 2020 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

/*==============================================================*/
/* vLCM_PostgreSQL.sql                                          */
/* DBMS name:      PostgreSQL Version                           */
/*==============================================================*/

/*==============================================================*/
/* Table: vLCM_task                                             */
/*==============================================================*/

BEGIN;

CREATE TABLE IF NOT EXISTS vLCM_task (
	ID TEXT NOT NULL,
	spec_type TEXT NOT NULL,
	scheduled_start TIMESTAMPTZ NULL,
	delay_tolerance BIGINT NULL,
	task TEXT NULL,
	task_status TEXT NOT NULL,
	spec TEXT NULL,
	display_spec TEXT NOT NULL,
	version TEXT NOT NULL,
	service_id TEXT NOT NULL,
	operation_id TEXT NOT NULL,
	description TEXT NOT NULL,
	log_dir TEXT NOT NULL,
	CONSTRAINT PK_vLCM_task PRIMARY KEY (ID)
);


/*==============================================================*/
/* Table: manual_discovery_products                             */
/*==============================================================*/

CREATE TABLE IF NOT EXISTS manual_discovery_products (

  id VARCHAR(255) NOT NULL,
  name VARCHAR(255) NOT NULL,
  version VARCHAR(255) NOT NULL,
  internal_name VARCHAR(255) NOT NULL,
  deployments VARCHAR(4000),
  PRIMARY KEY (id)
);

INSERT INTO UpgradeTracking(ID, Operation) VALUES(:ndu_id, :ndu_operation);
COMMIT;
