/* *************************************************************************
 * Copyright 2020-2021 VMware, Inc.   All rights reserved. -- VMware Confidential
 * *************************************************************************/

/*==============================================================================*/
/* VCDB_NDU_PROCEDURES.sql                                                      */
/*==============================================================================*/
/*                                                                              */
/* Description:                                                                 */
/*                                                                              */
/* The purpose of this file is to compile the NDU procedure library, holding    */
/* all the pre-defined Expand&Contract procs and functions.                     */
/*                                                                              */
/*==============================================================================*/

/* ON_ERROR_STOP- when set to true, the psql would stop on the first error and exit with status code 3*/
\set ON_ERROR_STOP on

/*============================================================================================*/
/*  Creates all NDU pre-defined procedure                                                     */
/*============================================================================================*/
BEGIN;
  \ir vcdb_ndu_clean_up_process.sql;
  \ir vcdb_ndu_db_schema_permissions.sql;
  \ir vcdb_ndu_CNT_add_check_const.sql;
  \ir vcdb_ndu_CNT_add_foreign_key_const.sql;
  \ir vcdb_ndu_CNT_add_unique_key_const.sql;
  \ir vcdb_ndu_CNT_drop_column.sql;
  \ir vcdb_ndu_CNT_drop_constraint.sql;
  \ir vcdb_ndu_CNT_drop_def_val.sql;
  \ir vcdb_ndu_CNT_drop_index.sql;
  \ir vcdb_ndu_CNT_drop_table.sql;
  \ir vcdb_ndu_EXP_add_col_def_val.sql;
  \ir vcdb_ndu_EXP_add_column.sql;
  \ir vcdb_ndu_EXP_add_column_comment.sql;
  \ir vcdb_ndu_EXP_add_table.sql;
  \ir vcdb_ndu_EXP_add_table_comment.sql;
  \ir vcdb_ndu_EXP_col_data_type.sql;
  \ir vcdb_ndu_EXP_crt_idx.sql;
  \ir vcdb_ndu_EXP_rnm_col.sql;
  \ir vcdb_ndu_exp_wrapper.sql;
  \ir vcdb_ndu_RVT_drop_col_cmt.sql;
  \ir vcdb_ndu_RVT_drop_col_def_val.sql;
  \ir vcdb_ndu_RVT_drop_column.sql;
  \ir vcdb_ndu_RVT_drop_index.sql;
  \ir vcdb_ndu_RVT_drop_tab_cmt.sql;
  \ir vcdb_ndu_RVT_drop_table.sql;
  \ir vcdb_ndu_rvt_generate_execute_statements.sql;
  \ir vcdb_ndu_track_table.sql;
  \ir vcdb_ndu_mig_b2b_chg_65167.sql;
  \ir vcdb_ndu_mig_b2b_chg_65173.sql;
  \ir vcdb_ndu_rnm_b2b_chg_65181.sql;
COMMIT;

-----------------------------------------------------------------------------
-- END OF FILE
-----------------------------------------------------------------------------
