/*USAGE

SELECT vcdb_ndu_cln_processor(
$$INSERT INTO VPX_VCDB_NDU_EXP (CLN_ID, RELEASE, CLN_STATUS) VALUES (2, 702, '') ON CONFLICT (CLN_ID) DO NOTHING;$$,
$$call vcdb_ndu_add_table('vcdb_team',702,'
CREATE TABLE VPX_FCD_SNAPSHOT_INFO (
   ID                            VARCHAR(50)   NOT NULL,
   SNAPSHOT_BACKING_OBJECT_ID    VARCHAR(60),
   SNAPSHOT_DESCRIPTION          VARCHAR(60),
   SNAPSHOT_ID                   VARCHAR(60),
   SNAPSHOT_DISK_PATH            VARCHAR(80),
   CONSTRAINT PK_VPX_FCD_SNAPSHOT PRIMARY KEY (ID, SNAPSHOT_BACKING_OBJECT_ID) )');$$,
$$call vcdb_ndu_add_column('vcdb_team',702,'VPX_FCD_SNAPSHOT_INFO', 'my_xyz_col', 'varchar(32)');$$,
$$call vcdb_ndu_add_table_comment('vcdb_team',702,'VPX_FCD_SNAPSHOT_INFO', 'This is VCDB table comment');$$,
$$call vcdb_ndu_add_column_comment('vcdb_team',702,'VPX_FCD_SNAPSHOT_INFO', 'my_xyz_col', 'This is VCDB column my_xyz_col comment');$$,
$$call vcdb_ndu_crt_idx('vcdb_team',702,'VPX_FDC_TEST_INDEX', 'VPX_FCD_SNAPSHOT_INFO', '(my_xyz_col)');$$,
$$call vcdb_ndu_rename_col('vcdb_team',702,'VPX_FCD_SNAPSHOT_INFO', 'SNAPSHOT_DISK_PATH', 'NEW_DISK_PATH');$$
);

*/
CREATE OR REPLACE FUNCTION vcdb_ndu_cln_processor(ndu_procs variadic text[])
RETURNS VOID
AS $procedure$
DECLARE
  l_statements text;
  l_errnum  VARCHAR(10);
  l_errmsg  VARCHAR(1000);
BEGIN
  l_errnum = '00000';
  BEGIN
    FOREACH l_statements in array ndu_procs loop

    /* execute everything passed as input parameter */
     EXECUTE l_statements;
    end loop;

  EXCEPTION
      WHEN OTHERS THEN
               l_errnum := sqlstate;
               l_errmsg := SQLERRM;
         RAISE LOG '%,%', l_errnum, l_errmsg;
  END;
END; $procedure$
LANGUAGE plpgsql;