/* Revert procedure for already commited change
   REMOVING TABLE FROM SCHEMA */
CREATE OR REPLACE PROCEDURE vcdb_ndu_RVT_drop_table_proc(
tab_name varchar(50))
language plpgsql
AS $vcdb_ndu_RVT_drop_table_proc$
DECLARE
l_schema_name text;
l_tab_name    text;
BEGIN
 /* do we need to track this as this is not a change it is a tool provided
    to services to remove a change that was already !!!SUCCESSFUL!!!
    performed but client wants it removed */

   SELECT split_part(tab_name,'.', 1) into l_schema_name;
   SELECT split_part(tab_name,'.', 2) into l_tab_name;

  IF EXISTS (SELECT table_name
               FROM information_schema.tables
              WHERE table_name = lower(l_tab_name)
                AND table_schema = lower(l_schema_name)
             ) THEN
     BEGIN
     SET LOCAL statement_timeout = 2000;
     SET LOCAL lock_timeout = '2s';

        EXECUTE 'DROP TABLE ' || l_schema_name ||'.'|| l_tab_name || ' CASCADE ';
     EXCEPTION WHEN OTHERS THEN RAISE LOG 'Removing table % failed', l_tab_name;
                                RAISE LOG '%,%',SQLSTATE,SQLERRM;
     END;
  ELSE
     RAISE LOG 'Invalid table name';
  END IF;

END;
$vcdb_ndu_RVT_drop_table_proc$;