CREATE OR REPLACE PROCEDURE vcdb_ndu_RVT_drop_tab_cmt_proc(
schema_name varchar(50),
tab_name    varchar(50)
)
language plpgsql
AS $vcdb_ndu_RVT_drop_tab_cmt_proc$
DECLARE
T_comment int :=0;
BEGIN

    SELECT count(obj_description(format('%s.%s',isc.table_schema,isc.table_name)::regclass::oid, 'pg_class')) into T_comment
      FROM information_schema.columns isc
     WHERE isc.table_name = lower(tab_name)
       AND isc.table_schema = lower(schema_name);
   /* if we use IF EXISTS we will end up comparing NULL VALUE if it is true
     which leads to false possitive results */
   IF (T_comment != 0 AND T_comment IS NOT NULL) THEN
      BEGIN
        EXECUTE 'COMMENT ON TABLE ' || schema_name || '.' || tab_name || ' IS NULL';
      EXCEPTION WHEN OTHERS THEN RAISE LOG 'Operation remove comment from table % failed', tab_name;
                                 RAISE LOG '%,%',SQLSTATE,SQLERRM;
      END;
   ELSE
      RAISE LOG 'Table % has not comment', tab_name;
   END IF;
END;
$vcdb_ndu_RVT_drop_tab_cmt_proc$;

/* USAGE
call vcdb_ndu_RVT_drop_tab_cmt_proc('vc','vpx_vcdb_test');
*/
