/* *************************************************************************
 * Copyright 2020 VMware, Inc.   All rights reserved. -- VMware Confidential
 * *************************************************************************/

/*============================================================================================================================*/
/* VCDB_NDU_RVT_DROP_COL_DEF_VAL.sql                                                                                          */
/*============================================================================================================================*/
/* Execution Instructions & Examples:                                                                                         */
/*                                                                                                                            */
/* call vcdb_ndu_rvt_drop_col_def_val(3,'vcdb_team','vpx_vcdb_test', 'second_column');                                        */
/*                                                                                                                            */
/* For additional detail visit confluence page:                                                                               */
/*============================================================================================================================*/

CREATE OR REPLACE PROCEDURE vcdb_ndu_rvt_drop_col_def_val
(
tab_schema varchar(50),
tab_name VARCHAR(50),
col_name VARCHAR(50)
)
 LANGUAGE plpgsql
AS $vcdb_ndu_drop_col_def_val$

DECLARE
   is_default INT :=0;
BEGIN

   SET LOCAL statement_timeout = 2000;
   SET LOCAL lock_timeout = '1s';

   BEGIN
      SET LOCAL statement_timeout = 2000;
      SET LOCAL lock_timeout = '2s';
      SELECT COUNT(column_default) INTO is_default
        FROM information_schema.columns
       WHERE table_name = lower(tab_name)
         AND table_schema = lower(tab_schema)
         AND column_name = lower(col_name);

      IF (is_default IS NULL OR 0) THEN
         RAISE LOG 'Column does not have default value';

      ELSE
         EXECUTE 'ALTER TABLE '|| tab_schema || '.' || tab_name || ' ALTER COLUMN ' || col_name || ' DROP DEFAULT';
      END IF;
   EXCEPTION
       WHEN OTHERS THEN
          RAISE LOG 'Operation drop default value failed';
   END;

END;
$vcdb_ndu_drop_col_def_val$;

----------------------------------------------------
-- END OF FUNCTION
----------------------------------------------------
