CREATE OR REPLACE PROCEDURE vcdb_ndu_RVT_drop_col_cmt_proc(
schema_name varchar(50),
tab_name    varchar(50),
col_name    varchar(50))
language plpgsql
AS $vcdb_ndu_RVT_drop_col_cmt_proc$
DECLARE
C_comment int :=0;
BEGIN

   SELECT count(pg_catalog.col_description(format('%s.%s',isc.table_schema,isc.table_name)::regclass::oid,isc.ordinal_position))
     into C_comment
     FROM information_schema.columns isc
    WHERE isc.table_name = lower(tab_name)
      and isc.table_schema = lower(schema_name)
      AND isc.column_name = lower(col_name);

   IF (C_comment != 0 AND C_comment IS NOT NULL) THEN
         BEGIN
            EXECUTE 'COMMENT ON COLUMN ' || schema_name || '.' || tab_name ||'.'||col_name ||' IS NULL';
         EXCEPTION WHEN OTHERS THEN RAISE LOG 'Operation remove comment from column % failed', col_name;
            RAISE LOG '%,%',SQLSTATE,SQLERRM;
         END;
   ELSE
     RAISE LOG 'Column % has no comment', col_name;
   END IF;
END;
$vcdb_ndu_RVT_drop_col_cmt_proc$;

/*
call vcdb_ndu_RVT_drop_col_cmt_proc('vc','vpx_vcdb_test','first_column');

*/
