/* ******************************************************************************
 * Copyright 2020-2021 VMware, Inc.   All rights reserved. -- VMware Confidential
 * *****************************************************************************/

/*=========================================================================*/
/* VCDB_CONTRACT.sql                                                       */
/*=========================================================================*/
/*                                                                         */
/* Description:                                                            */
/*                                                                         */
/* The purpose of this file is to be used in the Contract phase of the     */
/* Non-Disruptive Upgrade process handling all DDL operations performed    */
/* in the VC schema after the upgrade from source to target. The           */
/* operations added to this file only affect the final state of the VC.    */
/*                                                                         */
/* Instructions:                                                           */
/*                                                                         */
/* The way a change is going to be added to this file depends on its DDL   */
/* operation. To perform a change to VC schema for certain DDL operations  */
/* strict guidelines must be followed, in addition to know in which file   */
/* to add those changes same guideline must be reviewed. Please refer to   */
/* the link below to identify where your change must reside and how to     */
/* added it correctly.                                                     */
/*                                                                         */
/* https://confluence.eng.vmware.com/display/VCDB/VC+Schema+Changes+Guide  */
/*                                                                         */
/*=========================================================================*/

/* ON_ERROR_STOP- when set to true, the psql would stop on the first error and exit with status code 3*/
\set ON_ERROR_STOP on

/*==========================================================================================================*/
/*  DROP constraint VPX_SNAPSHOT_ID_U1 on table VPX_FCD_SNAPSHOT_INFO and ADD constraint VPX_SNAPSHOT_ID_U2 */
/*==========================================================================================================*/
CALL vcdb_ndu_cnt_drop_constraint('vc', 'VPX_FCD_SNAPSHOT_INFO', 'VPX_SNAPSHOT_ID_U1');

/*==========================================================================================================*/
/*  ADD constraint VPX_SNAPSHOT_ID_U2 on table VPX_FCD_SNAPSHOT_INFO                                        */
/*==========================================================================================================*/
CALL vcdb_ndu_add_unique_key_const('vc','VPX_FCD_SNAPSHOT_INFO', 'VPX_SNAPSHOT_ID', 'VPX_SNAPSHOT_ID_U2');

/*==========================================================================================================*/
/*  DROP columns MASTER_GEN and MASTER_SPEC_GEN on table VPX_HOST                                           */
/*==========================================================================================================*/
CALL vcdb_ndu_cnt_drop_column('vc','VPX_HOST', 'MASTER_GEN');
CALL vcdb_ndu_cnt_drop_column('vc','VPX_HOST', 'MASTER_SPEC_GEN');

/*==========================================================================================================*/
/*  DROP columns LAST_PERF_TIME and PERF_REFRESH_RATE on table VPX_HOST                                     */
/*==========================================================================================================*/
CALL vcdb_ndu_cnt_drop_column('vc','VPX_HOST', 'LAST_PERF_TIME');
CALL vcdb_ndu_cnt_drop_column('vc','VPX_HOST', 'PERF_REFRESH_RATE');

/*==========================================================================================================*/
/*  DROP column IS_RESTRICTED_USER on table VPX_EXP                                                         */
/*==========================================================================================================*/
CALL vcdb_ndu_cnt_drop_column('vc','VPX_EXT', 'IS_RESTRICTED_USER');

/*==========================================================================================================*/
/*  DROP column NETWORK_OFFLOAD_ALLOWED on table VPX_DVS                                                    */
/*==========================================================================================================*/
CALL vcdb_ndu_cnt_drop_column('vc','VPX_DVS', 'NETWORK_OFFLOAD_ALLOWED');

/*==========================================================================================================*/
/*  DROP table VPX_VM_OP_NOTIFICATION_CFG                                                                   */
/*==========================================================================================================*/
CALL vcdb_ndu_cnt_drop_table('vc', 'VPX_VM_OP_NOTIFICATION_CFG');

/*==========================================================================================================*/
/*  DROP table VPX_CALLBACK_WHITELIST                                                                       */
/*==========================================================================================================*/
CALL vcdb_ndu_cnt_drop_table('vc', 'VPX_CALLBACK_WHITELIST');

/*==========================================================================================================*/
/*  DROP table VPX_CALLBACK_SERVICE                                                                         */
/*==========================================================================================================*/
CALL vcdb_ndu_cnt_drop_table('vc', 'VPX_CALLBACK_SERVICE');

/*=========================================================================*/
/*                                                                         */
/*               DO NOT ADD CHANGES AFTER THIS COMMENT BOX                 */
/*                                                                         */
/*=========================================================================*/

/*=========================================================================*/
/*Initiation of clean-up process for NDU track tables + their dependencies */
/*=========================================================================*/

CALL vcdb_ndu_clean_up_process();

---------------------------------------------------------------------------
-- END OF FILE
---------------------------------------------------------------------------
