/* *************************************************************************
 * Copyright 2020-2021 VMware, Inc.   All rights reserved. -- VMware Confidential
 * *************************************************************************/

/*==============================================================================*/
/* VCDB_SYSTEM_PROCEDURES.sql                                                   */
/*==============================================================================*/
/*                                                                              */
/* Description:                                                                 */
/*                                                                              */
/* The purpose of this file is to re-compile the system procedures to their     */
/* latest version.                                                              */
/*                                                                              */
/*==============================================================================*/

/* ON_ERROR_STOP- when set to true, the psql would stop on the first error and exit with status code 3*/
\set ON_ERROR_STOP on

/*============================================================================================*/
/*  Recompiles existing system procedure                                                      */
/*============================================================================================*/

BEGIN;
  \ir VCDB_views_PostgreSQL.sql
  \ir stats_rollup1_proc_PostgreSQL.sql
  \ir stats_rollup2_proc_PostgreSQL.sql
  \ir stats_rollup3_proc_PostgreSQL.sql
  \ir purge_stat2_proc_PostgreSQL.sql
  \ir purge_stat3_proc_PostgreSQL.sql
  \ir purge_usage_stats_proc_PostgreSQL.sql
  \ir l_stats_rollup1_proc_PostgreSQL.sql
  \ir l_stats_rollup2_proc_PostgreSQL.sql
  \ir l_stats_rollup3_proc_PostgreSQL.sql
  \ir l_purge_stat2_proc_PostgreSQL.sql
  \ir l_purge_stat3_proc_PostgreSQL.sql
  \ir job_schedule1_PostgreSQL.sql
  \ir job_schedule2_PostgreSQL.sql
  \ir job_schedule3_PostgreSQL.sql
  \ir cleanup_events_PostgreSQL.sql
  \ir job_cleanup_events_PostgreSQL.sql
  \ir upsert_last_event_proc_PostgreSQL.sql
  \ir calc_topn1_proc_PostgreSQL.sql
  \ir calc_topn2_proc_PostgreSQL.sql
  \ir calc_topn3_proc_PostgreSQL.sql
  \ir calc_topn4_proc_PostgreSQL.sql
  \ir clear_topn1_proc_PostgreSQL.sql
  \ir clear_topn2_proc_PostgreSQL.sql
  \ir clear_topn3_proc_PostgreSQL.sql
  \ir clear_topn4_proc_PostgreSQL.sql
  \ir rule_topn1_proc_PostgreSQL.sql
  \ir rule_topn2_proc_PostgreSQL.sql
  \ir rule_topn3_proc_PostgreSQL.sql
  \ir rule_topn4_proc_PostgreSQL.sql
  \ir job_topn_past_day_PostgreSQL.sql
  \ir job_topn_past_month_PostgreSQL.sql
  \ir job_topn_past_week_PostgreSQL.sql
  \ir job_topn_past_year_PostgreSQL.sql
  \ir process_performance_data_PostgreSQL.sql
  \ir job_dbm_performance_data_PostgreSQL.sql
COMMIT;

-----------------------------------------------------------------------------
-- END OF FILE
-----------------------------------------------------------------------------
