create or replace function upsert_last_event_proc
(
p_entity_id_in in numeric,
p_event_type_in varchar(255),
p_last_event_id_in in numeric
)
RETURNS void AS $$
begin
   UPDATE VPX_ENTITY_LAST_EVENT
   SET last_event_id = p_last_event_id_in
   WHERE entity_id = p_entity_id_in
   AND event_type = p_event_type_in;

   IF NOT FOUND THEN
      INSERT INTO VPX_ENTITY_LAST_EVENT(entity_id, event_type, last_event_id)
      VALUES(p_entity_id_in, p_event_type_in, p_last_event_id_in);
   END IF;
End;
$$ LANGUAGE plpgsql;
