-- ==============================================================================
-- Copyright 2018-2021 VMware, Inc.   All rights reserved. -- VMware Confidential
-- ==============================================================================

-- DO NOT EDIT THIS FILE UNLESS REQUIRED BY YOUR SOFTWARE VENDOR

-- query:kUpsertStatsBulk
INSERT INTO VPX_HIST_STAT1_%1 (COUNTER_ID, TIME_ID, STAT_VAL)
VALUES (?,?,?) ON CONFLICT DO NOTHING

-- query:kRollupJob1Status
select case
           when date_part('day', (timezone('UTC', now()) - min(sample_time)))*24 + date_part('hour', (timezone('UTC', now())- min(sample_time))) + date_part('minute', (timezone('UTC', now())- min(sample_time)))/60 > 3
                and exists
                  (select 1
                   from vpx_stat_interval_def
                   where rollup_enabled_flg = 1
                     and interval_seq_num = 2) then 1
           else 0
       end
from vpx_sample_time1
where rollup_counter is null

-- query:kRollupJob2Status
select case
           when date_part('day', (timezone('UTC', now()) - min(sample_time)))*24 + date_part('hour', (timezone('UTC', now())- min(sample_time))) + date_part('minute', (timezone('UTC', now())- min(sample_time)))/60 > 6
                and exists
                  (select 1
                   from vpx_stat_interval_def
                   where rollup_enabled_flg = 1
                     and interval_seq_num = 3) then 1
           else 0
       end
from vpx_sample_time2
where rollup_counter is null

-- query:kRollupJob3Status
select case
           when date_part('day', (timezone('UTC', now()) - min(sample_time)))*24 + date_part('hour', (timezone('UTC', now())- min(sample_time))) + date_part('minute', (timezone('UTC', now())- min(sample_time)))/60 > 72
                and exists
                  (select 1
                   from vpx_stat_interval_def
                   where rollup_enabled_flg = 1
                     and interval_seq_num = 4) then 1
           else 0
       end
from vpx_sample_time3
where rollup_counter is null

-- query:kDeleteOrphanedDevices
delete
from vpx_device d
where not exists
    (select 0
     from vpx_stat_counter sc
     where sc.device_id = d.device_id)
  and device_name <> '';

-- query:kDeleteOrphanedStatsID
DELETE
FROM VPX_STAT_ID si
WHERE NOT EXISTS (SELECT 1
                    FROM VPX_ENTITY ve
                  WHERE CAST(substring(si.MOID FROM '[0-9]+') AS BIGINT) = ve.ID);

-- query:kTruncateStatsPartition
truncate table vpx_hist_stat1_%d

-- query:kUpdateOptimizerForStatsPartition
vacuum (analyze) vpx_hist_stat1_%d

-- query:kRollupStats1
select l_stats_rollup1_proc()

-- query:kRollupStats2
select l_stats_rollup2_proc()

-- query:kRollupStats3
select l_stats_rollup3_proc()

-- query:kPurgeStats2
select l_purge_stat2_proc()

-- query:kPurgeStats3
select l_purge_stat3_proc()

-- query:kRule_topn1_proc
select rule_topn1_proc()

-- query:kRule_topn2_proc
select rule_topn2_proc()

-- query:kRule_topn3_proc
select rule_topn3_proc()

-- query:kRule_topn4_proc
select rule_topn4_proc()

-- query:kVcResourcePurgeStats
select purge_usage_stat_proc()

-- query:kQueryProviderId
SELECT id
FROM vpx_stat_id
WHERE moid = ?

-- query:kQueryStatsStatIdDeviceId1
SELECT sc.stat_id, d.device_name, sm.sample_time, sm.sample_interval, st.stat_val
FROM vpx_stat_counter sc, vpx_sample_time1 sm, vpx_device d, vpx_hist_stat1 st
WHERE sc.entity_id = ?
  AND sc.stat_id = ?
  AND coalesce(sc.device_id,1) = coalesce(d.device_id,1)
  AND d.device_name = ?
  AND sm.sample_time > ?
  AND sm.sample_time <= ?
  AND st.counter_id = sc.counter_id
  and st.time_id = sm.time_id
ORDER BY sm.sample_time

-- query:kQueryStatsStatIdDeviceId1Part
SELECT sc.stat_id, d.device_name, sm.sample_time, sm.sample_interval, st.stat_val
FROM vpx_stat_counter sc, vpx_sample_time1 sm, vpx_device d, (%1) st
WHERE sc.entity_id = ?
  AND sc.stat_id = ?
  AND coalesce(sc.device_id,1) = coalesce(d.device_id,1)
  AND d.device_name = ?
  AND sm.sample_time > ?
  AND sm.sample_time <= ?
  AND st.counter_id = sc.counter_id
  and st.time_id = sm.time_id
ORDER BY sm.sample_time

-- query:kQueryStatsStatIdDeviceId2
SELECT sc.stat_id, d.device_name, sm.sample_time, sm.sample_interval, st.stat_val
FROM vpx_stat_counter sc, vpx_sample_time2 sm, vpx_device d, vpx_hist_stat2 st
WHERE sc.entity_id = ?
  AND sc.stat_id = ?
  AND coalesce(sc.device_id,1) = coalesce(d.device_id,1)
  AND d.device_name = ?
  AND sm.sample_time > ?
  AND sm.sample_time <= ?
  AND st.counter_id = sc.counter_id
  and st.time_id = sm.time_id
ORDER BY sm.sample_time

-- query:kQueryStatsStatIdDeviceId3
SELECT sc.stat_id, d.device_name, sm.sample_time, sm.sample_interval, st.stat_val
FROM vpx_stat_counter sc, vpx_sample_time3 sm, vpx_device d, vpx_hist_stat3 st
WHERE sc.entity_id = ?
  AND sc.stat_id = ?
  AND coalesce(sc.device_id,1) = coalesce(d.device_id,1)
  AND d.device_name = ?
  AND sm.sample_time > ?
  AND sm.sample_time <= ?
  AND st.counter_id = sc.counter_id
  and st.time_id = sm.time_id
ORDER BY sm.sample_time

-- query:kQueryStatsStatIdDeviceId4
SELECT sc.stat_id, d.device_name, sm.sample_time, sm.sample_interval, st.stat_val
FROM vpx_stat_counter sc, vpx_sample_time4 sm, vpx_device d, vpx_hist_stat4 st
WHERE sc.entity_id = ?
  AND sc.stat_id = ?
  AND coalesce(sc.device_id,1) = coalesce(d.device_id,1)
  AND d.device_name = ?
  AND sm.sample_time > ?
  AND sm.sample_time <= ?
  AND st.counter_id = sc.counter_id
  and st.time_id = sm.time_id
ORDER BY sm.sample_time

-- query:kQueryStatsStatId1
SELECT sc.stat_id, d.device_name, sm.sample_time, sm.sample_interval, st.stat_val
FROM vpx_stat_counter sc, vpx_sample_time1 sm, vpx_device d, vpx_hist_stat1 st
WHERE sc.entity_id = ?
  AND sc.stat_id = ?
  AND coalesce(sc.device_id,1) = coalesce(d.device_id,1)
  and sm.sample_time > ?
  AND sm.sample_time <= ?
  AND sc.counter_id = st.counter_id
  AND sm.time_id = st.time_id
ORDER BY d.device_name, sm.sample_time

-- query:kQueryStatsStatId1Part
SELECT sc.stat_id, d.device_name, sm.sample_time, sm.sample_interval, st.stat_val
FROM vpx_stat_counter sc, vpx_sample_time1 sm, vpx_device d, (%1) st
WHERE sc.entity_id = ?
  AND sc.stat_id = ?
  AND coalesce(sc.device_id,1) = coalesce(d.device_id,1)
  and sm.sample_time > ?
  AND sm.sample_time <= ?
  AND sc.counter_id = st.counter_id
  AND sm.time_id = st.time_id
ORDER BY d.device_name, sm.sample_time

-- query:kQueryStatsStatId2
SELECT sc.stat_id, d.device_name, sm.sample_time, sm.sample_interval, st.stat_val
FROM vpx_stat_counter sc, vpx_sample_time2 sm, vpx_device d, vpx_hist_stat2 st
WHERE sc.entity_id = ?
  AND sc.stat_id = ?
  AND coalesce(sc.device_id,1) = coalesce(d.device_id,1)
  and sm.sample_time > ?
  AND sm.sample_time <= ?
  AND sc.counter_id = st.counter_id
  AND sm.time_id = st.time_id
ORDER BY d.device_name, sm.sample_time

-- query:kQueryStatsStatId3
SELECT sc.stat_id, d.device_name, sm.sample_time, sm.sample_interval, st.stat_val
FROM vpx_stat_counter sc, vpx_sample_time3 sm, vpx_device d, vpx_hist_stat3 st
WHERE sc.entity_id = ?
  AND sc.stat_id = ?
  AND coalesce(sc.device_id,1) = coalesce(d.device_id,1)
  and sm.sample_time > ?
  AND sm.sample_time <= ?
  AND sc.counter_id = st.counter_id
  AND sm.time_id = st.time_id
ORDER BY d.device_name, sm.sample_time

-- query:kQueryStatsStatId4
SELECT sc.stat_id, d.device_name, sm.sample_time, sm.sample_interval, st.stat_val
FROM vpx_stat_counter sc, vpx_sample_time4 sm, vpx_device d, vpx_hist_stat4 st
WHERE sc.entity_id = ?
  AND sc.stat_id = ?
  AND coalesce(sc.device_id,1) = coalesce(d.device_id,1)
  and sm.sample_time > ?
  AND sm.sample_time <= ?
  AND sc.counter_id = st.counter_id
  AND sm.time_id = st.time_id
ORDER BY d.device_name, sm.sample_time

-- query:kQueryStats1
SELECT sc.stat_id, d.device_name, sm.sample_time, sm.sample_interval, st.stat_val
FROM vpx_stat_counter sc, vpx_sample_time1 sm, vpx_device d, vpx_hist_stat1 st
WHERE sc.entity_id = ?
  AND sc.counter_id = st.counter_id
  AND coalesce(sc.device_id,1) = coalesce(d.device_id,1)
  AND st.time_id = sm.time_id
  AND sm.sample_time > ?
  AND sm.sample_time <= ?
ORDER BY sc.stat_id, d.device_name, sm.sample_time

-- query:kQueryStats1Part
SELECT sc.stat_id, d.device_name, sm.sample_time, sm.sample_interval, st.stat_val
FROM vpx_stat_counter sc, vpx_sample_time1 sm, vpx_device d, (%1) st
WHERE sc.entity_id = ?
  AND sc.counter_id = st.counter_id
  AND coalesce(sc.device_id,1) = coalesce(d.device_id,1)
  AND st.time_id = sm.time_id
  AND sm.sample_time > ?
  AND sm.sample_time <= ?
ORDER BY sc.stat_id, d.device_name, sm.sample_time

-- query:kQueryStats2
SELECT sc.stat_id, d.device_name, sm.sample_time, sm.sample_interval, st.stat_val
FROM vpx_stat_counter sc, vpx_sample_time2 sm, vpx_device d, vpx_hist_stat2 st
WHERE sc.entity_id = ?
  AND sc.counter_id = st.counter_id
  AND coalesce(sc.device_id,1) = coalesce(d.device_id,1)
  AND st.time_id = sm.time_id
  AND sm.sample_time > ?
  AND sm.sample_time <= ?
ORDER BY sc.stat_id, d.device_name, sm.sample_time

-- query:kQueryStats3
SELECT sc.stat_id, d.device_name, sm.sample_time, sm.sample_interval, st.stat_val
FROM vpx_stat_counter sc, vpx_sample_time3 sm, vpx_device d, vpx_hist_stat3 st
WHERE sc.entity_id = ?
  AND sc.counter_id = st.counter_id
  AND coalesce(sc.device_id,1) = coalesce(d.device_id,1)
  AND st.time_id = sm.time_id
  AND sm.sample_time > ?
  AND sm.sample_time <= ?
ORDER BY sc.stat_id, d.device_name, sm.sample_time

-- query:kQueryStats4
SELECT sc.stat_id, d.device_name, sm.sample_time, sm.sample_interval, st.stat_val
FROM vpx_stat_counter sc, vpx_sample_time4 sm, vpx_device d, vpx_hist_stat4 st
WHERE sc.entity_id = ?
  AND sc.counter_id = st.counter_id
  AND coalesce(sc.device_id,1) = coalesce(d.device_id,1)
  AND st.time_id = sm.time_id
  AND sm.sample_time > ?
  AND sm.sample_time <= ?
ORDER BY sc.stat_id, d.device_name, sm.sample_time

-- query:kQueryStatsStatIdNullDevice
SELECT st.stat_id, st.device_id, sm.sample_time, sm.sample_interval, st.stat_value
FROM vpx_hist_stat st, vpx_sample sm
WHERE st.sample_id = sm.id
  AND st.stat_id = ?
  AND st.device_id is null
  AND sm.sample_time > ?
  AND sm.sample_time <= ?
  AND st.entity_id = ?
  AND sm.sample_interval <= ?
ORDER BY sm.sample_time

-- query:kQueryStatsStatIdNullDevice1
SELECT sc.stat_id, d.device_name, sm.sample_time, sm.sample_interval, st.stat_val
FROM vpx_stat_counter sc, vpx_sample_time1 sm, vpx_device d, vpx_hist_stat1 st
WHERE sc.entity_id = ?
  AND sc.stat_id = ?
  AND (d.device_name = '' OR d.device_name IS NULL)
  AND sc.counter_id = st.counter_id
  AND coalesce(sc.device_id,1) = coalesce(d.device_id,1)
  AND st.time_id = sm.time_id
  AND sm.sample_time > ?
  AND sm.sample_time <= ?
ORDER BY sm.sample_time

-- query:kQueryStatsStatIdNullDevice1Part
SELECT sc.stat_id, d.device_name, sm.sample_time, sm.sample_interval, st.stat_val
FROM vpx_stat_counter sc, vpx_sample_time1 sm, vpx_device d, (%1) st
WHERE sc.entity_id = ?
  AND sc.stat_id = ?
  AND (d.device_name = '' OR d.device_name IS NULL)
  AND sc.counter_id = st.counter_id
  AND coalesce(sc.device_id,1) = coalesce(d.device_id,1)
  AND st.time_id = sm.time_id
  AND sm.sample_time > ?
  AND sm.sample_time <= ?
ORDER BY sm.sample_time

-- query:kQueryStatsStatIdNullDevice1Condition
SELECT sc.stat_id, d.device_name, sm.sample_time, sm.sample_interval, st.stat_val
FROM vpx_stat_counter sc, vpx_sample_time1 sm, vpx_device d, (%1) st
WHERE sc.counter_id = st.counter_id
  AND coalesce(sc.device_id,1) = coalesce(d.device_id,1)
  AND st.time_id = sm.time_id
ORDER BY sm.sample_time

-- query:kQueryStatsStatIdNullDevice2
SELECT sc.stat_id, d.device_name, sm.sample_time, sm.sample_interval, st.stat_val
FROM vpx_stat_counter sc, vpx_sample_time2 sm, vpx_device d, vpx_hist_stat2 st
WHERE sc.entity_id = ?
  AND sc.stat_id = ?
  AND (d.device_name = '' OR d.device_name IS NULL)
  AND sc.counter_id = st.counter_id
  AND coalesce(sc.device_id,1) = coalesce(d.device_id,1)
  AND st.time_id = sm.time_id
  AND sm.sample_time > ?
  AND sm.sample_time <= ?
ORDER BY sm.sample_time

-- query:kQueryStatsStatIdNullDevice3
SELECT sc.stat_id, d.device_name, sm.sample_time, sm.sample_interval, st.stat_val
FROM vpx_stat_counter sc, vpx_sample_time3 sm, vpx_device d, vpx_hist_stat3 st
WHERE sc.entity_id = ?
  AND sc.stat_id = ?
  AND (d.device_name = '' OR d.device_name IS NULL)
  AND sc.counter_id = st.counter_id
  AND coalesce(sc.device_id,1) = coalesce(d.device_id,1)
  AND st.time_id = sm.time_id
  AND sm.sample_time > ?
  AND sm.sample_time <= ?
ORDER BY sm.sample_time

-- query:kQueryStatsStatIdNullDevice4
SELECT sc.stat_id, d.device_name, sm.sample_time, sm.sample_interval, st.stat_val
FROM vpx_stat_counter sc, vpx_sample_time4 sm, vpx_device d, vpx_hist_stat4 st
WHERE sc.entity_id = ?
  AND sc.stat_id = ?
  AND (d.device_name = '' OR d.device_name IS NULL)
  AND sc.counter_id = st.counter_id
  AND coalesce(sc.device_id,1) = coalesce(d.device_id,1)
  AND st.time_id = sm.time_id
  AND sm.sample_time > ?
  AND sm.sample_time <= ?
ORDER BY sm.sample_time

-- query:kQueryAvailableMetric1
SELECT sc.stat_id, d.device_name
FROM vpx_stat_counter sc, vpx_sample_time1 sm, vpx_device d, vpx_hist_stat1 st
WHERE sc.entity_id = ?
  and coalesce(sc.device_id,1) = coalesce(d.device_id,1)
  and sc.counter_id = st.counter_id
  and st.time_id = sm.time_id
  AND sm.sample_time > ?
  AND sm.sample_time <= ?
GROUP BY sc.stat_id, d.device_name
ORDER BY sc.stat_id, d.device_name

-- query:kQueryAvailableMetric2
SELECT sc.stat_id, d.device_name
FROM vpx_stat_counter sc, vpx_sample_time2 sm, vpx_device d, vpx_hist_stat2 st
WHERE sc.entity_id = ?
  and coalesce(sc.device_id,1) = coalesce(d.device_id,1)
  and sc.counter_id = st.counter_id
  and st.time_id = sm.time_id
  AND sm.sample_time > ?
  AND sm.sample_time <= ?
GROUP BY sc.stat_id, d.device_name
ORDER BY sc.stat_id, d.device_name

-- query:kQueryAvailableMetric3
SELECT sc.stat_id, d.device_name
FROM vpx_stat_counter sc, vpx_sample_time3 sm, vpx_device d, vpx_hist_stat3 st
WHERE sc.entity_id = ?
  and coalesce(sc.device_id,1) = coalesce(d.device_id,1)
  and sc.counter_id = st.counter_id
  and st.time_id = sm.time_id
  AND sm.sample_time > ?
  AND sm.sample_time <= ?
GROUP BY sc.stat_id, d.device_name
ORDER BY sc.stat_id, d.device_name

-- query:kQueryAvailableMetric4
SELECT sc.stat_id, d.device_name
FROM vpx_stat_counter sc, vpx_sample_time4 sm, vpx_device d, vpx_hist_stat4 st
WHERE sc.entity_id = ?
  and coalesce(sc.device_id,1) = coalesce(d.device_id,1)
  and sc.counter_id = st.counter_id
  and st.time_id = sm.time_id
  AND sm.sample_time > ?
  AND sm.sample_time <= ?
GROUP BY sc.stat_id, d.device_name
ORDER BY sc.stat_id, d.device_name

-- query:kQueryAllAvailableMetric
SELECT sc.stat_id, d.device_name
FROM vpx_stat_counter sc, vpx_device d
WHERE sc.entity_id = ?
  and coalesce(sc.device_id,1) = coalesce(d.device_id,1)
GROUP BY sc.stat_id, d.device_name
ORDER BY sc.stat_id, d.device_name

-- query:kGetDatastoresInVmChain
WITH RECURSIVE FileBacking(backing_id, datastore_id, file_backing_parent_id) AS
  (SELECT backing_id, datastore_id, file_backing_parent_id
   FROM vpx_vdevice_file_backing
   WHERE backing_id = ?
     UNION ALL
     SELECT I.backing_id, I.datastore_id, I.file_backing_parent_id
     FROM vpx_vdevice_file_backing AS I, FileBacking AS O where O.file_backing_parent_id = I.backing_id )
SELECT distinct datastore_id
FROM FileBacking

-- query:kGetDatastoresInSnChain
WITH RECURSIVE SnFileBacking(backing_id, datastore_id, file_backing_parent_id) AS
  (SELECT backing_id, datastore_id, file_backing_parent_id
   FROM vpx_sn_vdevice_file_backing
   WHERE backing_id = ?
     UNION ALL
     SELECT I.backing_id, I.datastore_id, I.file_backing_parent_id
     FROM vpx_sn_vdevice_file_backing AS I, SnFileBacking AS O where O.file_backing_parent_id = I.backing_id )
SELECT distinct datastore_id
FROM SnFileBacking

-- query:kGetUrlAndContentIdForAllVmParentBackings
WITH RECURSIVE FileBacking(backing_id, backing_content_id, backing_filename, file_backing_parent_id) AS
  (SELECT backing_id, file_backing_content_id, hard_device_backing_file_name,
          file_backing_parent_id
   FROM vpx_vdevice_file_backing
   WHERE backing_id = ?
     UNION ALL
     SELECT I.backing_id, I.file_backing_content_id, I.hard_device_backing_file_name,
            I.file_backing_parent_id
     FROM vpx_vdevice_file_backing AS I, FileBacking AS O WHERE O.file_backing_parent_id = I.backing_id )
SELECT backing_filename, backing_content_id
FROM FileBacking

-- query:kGetUrlAndContentIdForAllSnParentBackings
WITH RECURSIVE SnFileBacking(backing_id, backing_content_id, backing_filename, file_backing_parent_id) AS
  (SELECT backing_id, file_backing_content_id, hard_device_backing_file_name,
          file_backing_parent_id
   FROM vpx_sn_vdevice_file_backing
   WHERE backing_id = ?
     UNION ALL
     SELECT I.backing_id, I.file_backing_content_id, I.hard_device_backing_file_name,
            I.file_backing_parent_id
     FROM vpx_sn_vdevice_file_backing AS I, SnFileBacking AS O WHERE O.file_backing_parent_id = I.backing_id )
SELECT backing_filename, backing_content_id
FROM SnFileBacking

-- query:kUpsertLastEvent
BEGIN;

select upsert_last_event_proc(?, ?, ?);

END;

-- query:kDoEventTaskCleanup
select cleanup_events_tasks_proc()

-- query:kLoadEventsQueryLimit
SELECT EVENT_ID, CHAIN_ID, EVENT_TYPE, EXTENDED_CLASS, CREATE_TIME, USERNAME, CATEGORY, VM_ID,
       VM_NAME, HOST_ID, HOST_NAME, COMPUTERESOURCE_ID, COMPUTERESOURCE_TYPE,
       COMPUTERESOURCE_NAME, DATACENTER_ID, DATACENTER_NAME, DATASTORE_ID, DATASTORE_NAME, NETWORK_ID,
       NETWORK_NAME, NETWORK_TYPE, DVS_ID, DVS_NAME, STORAGEPOD_ID, STORAGEPOD_NAME, CHANGE_TAG_ID
FROM %1 %%1%% LIMIT %%2%%;

-- query:kLoadTasksQueryLimit
SELECT TASK_ID, NAME, DESCRIPTIONID, ENTITY_ID, ENTITY_TYPE, ENTITY_NAME, LOCKED_DATA,
       COMPLETE_STATE, CANCELLED, CANCELLABLE, ERROR_DATA, RESULT_DATA, REASON_DATA, QUEUE_TIME,
       START_TIME, COMPLETE_TIME, EVENT_CHAIN_ID, USERNAME, VM_ID, HOST_ID, COMPUTERESOURCE_ID,
       DATACENTER_ID, RESOURCEPOOL_ID, FOLDER_ID, ALARM_ID, SCHEDULEDTASK_ID, CHANGE_TAG_ID,
       PARENT_TASK_ID, ROOT_TASK_ID, DESCRIPTION, ACTIVATION_ID
FROM VPX_TASK %1 LIMIT %2;

-- query:kFindSingleFreePortgroupPort
select t1.DVPORT_KEY
from VPX_DVPORT_MEMBERSHIP t1
left outer join VPX_DVPORT t2 on t1.DVS_ID = t2.DVS_ID
and t1.DVPORT_KEY = t2.DVPORT_KEY
where t1.DVPORTGROUP_ID = ?
  and t1.HOST_ID = 0
  and t2.CONNECTEE is NULL LIMIT 1

-- query:kFindDvsConnectionOnHost
SELECT T1.DVS_ID, T1.DVPORT_KEY, T1.CONNECTEE_TYPE, T1.CONNECTEE_NIC_KEY,
       T1.CONNECTION_COOKIE, T1.PROXY_HOST, T2.DVPORTGROUP_ID
FROM VPX_DVPORT T1, VPX_DVPORT_MEMBERSHIP T2
WHERE T1.DVS_ID = T2.DVS_ID
  AND T1.DVPORT_KEY = T2.DVPORT_KEY
  AND T1.CONNECTEE = ?
  AND T1.RESERVED_TIME IS NULL

-- query:kGetDBVersion
select substring(version() from 'PostgreSQL \w+.\w+.\w+');

-- query:kSelectHistStat1Conditioned
SELECT i_st.counter_id, i_st.time_id, i_st.stat_val
FROM VPX_HIST_STAT1_%1 i_st JOIN VPX_STAT_COUNTER i_sc on i_st.counter_id = i_sc.counter_id LEFT JOIN (SELECT time_id
    FROM vpx_sample_time1
    WHERE sample_time >= %2
       AND sample_time <= %3) t ON t.time_id = i_st.time_id

-- query:kSelectDeviceID
SELECT device_id
from VPX_DEVICE
WHERE DEVICE_NAME = %1;

-- query:kDropOpJournals
TRUNCATE TABLE VPX_JOURNAL CASCADE

