
 
 
 
 
 
 delete from vpx_version;
 /
 
 INSERT INTO vpx_version VALUES (
         703,
         'VirtualCenter Database 7.0'
 );
 /
 
 SELECT force_checkpoint();
 /
 
 
 
 
 
 CREATE TABLE IF NOT EXISTS VPX_HCI_CONFIG_INFO(
    CLUSTER_ID           BIGINT          NOT NULL,
    LOCKDOWN_MODE        INTEGER         NULL,
    DATETIME_CONFIG      TEXT            NULL,
    HCI_WORKFLOW_STATE   VARCHAR(64)     NOT NULL,
    CONFIGURED_HOSTS     TEXT            NULL,
    MIN_ESX_VERSION      VARCHAR(255)    NULL,
    CONSTRAINT PK_VPX_HCI_CONFIG_INFO PRIMARY KEY (CLUSTER_ID),
    CONSTRAINT FK_VPX_HCI_CONFIG_INFO FOREIGN KEY (CLUSTER_ID)
       REFERENCES VPX_COMPUTE_RESOURCE(ID) ON DELETE CASCADE
 );
 /
 
 
 
 
 
 CREATE TABLE IF NOT EXISTS VPX_HCI_DVS_SETTINGS(
    DVS_ID               BIGINT          NOT NULL,
    PHYSICAL_NICS        TEXT            NOT NULL,
    CLUSTER_ID           BIGINT          NOT NULL,
    CONSTRAINT PK_VPX_HCI_DVS_SETTINGS PRIMARY KEY (DVS_ID, CLUSTER_ID),
    CONSTRAINT FK_VPX_HCI_DVS_SETTINGS FOREIGN KEY (CLUSTER_ID)
       REFERENCES VPX_HCI_CONFIG_INFO(CLUSTER_ID) ON DELETE CASCADE
 );
 /
 
 CREATE INDEX IF NOT EXISTS VPX_HCI_DVS_SETTINGS_CID_IDX ON VPX_HCI_DVS_SETTINGS(CLUSTER_ID);
 /
 
 
 
 
 
 CREATE TABLE IF NOT EXISTS VPX_HCI_NW_SETTINGS(
    DVPG_ID              BIGINT          NOT NULL,
    SERVICE_TYPE         VARCHAR(64)     NOT NULL,
    DVS_ID               BIGINT          NOT NULL,
    CLUSTER_ID           BIGINT          NOT NULL,
    CONSTRAINT PK_VPX_HCI_NW_SETTINGS PRIMARY KEY (DVPG_ID, SERVICE_TYPE, CLUSTER_ID),
    CONSTRAINT FK_VPX_HCI_NW_SETTINGS FOREIGN KEY (DVS_ID, CLUSTER_ID)
       REFERENCES VPX_HCI_DVS_SETTINGS(DVS_ID, CLUSTER_ID) ON DELETE CASCADE
 );
 /
 
 CREATE INDEX IF NOT EXISTS VPX_HCI_NW_SETTINGS_DC_IDX ON VPX_HCI_NW_SETTINGS(DVS_ID, CLUSTER_ID);
 /
 
 
 
 
 
 
 CREATE TABLE VPX_TAG_DEF(
    ID          BIGINT      NOT NULL,
    TAG_UUID    CHAR(36)    NOT NULL,
    TYPE_ID     INTEGER     NOT NULL,
    CONSTRAINT PK_VPX_TAG_DEF PRIMARY KEY (ID)
 )
 ;
 /
 
 CREATE SEQUENCE VPX_TAG_DEF_SEQ INCREMENT BY 100;
 /
 
 CREATE UNIQUE INDEX VPXI_TAG_DEF_UUID_TYPE ON VPX_TAG_DEF (TAG_UUID, TYPE_ID);
 /
 
 
 
 
 
 CREATE TABLE VPX_ENTITY_TAG_XREF(
    ENTITY_ID   BIGINT      NOT NULL,
    TAG_ID      BIGINT      NOT NULL,
    CONSTRAINT PK_VPX_ENTITY_TAG_XREF PRIMARY KEY (ENTITY_ID, TAG_ID),
    CONSTRAINT FK_VPX_ETX_REF_VPX_ENTITY FOREIGN KEY (ENTITY_ID)
       REFERENCES VPX_ENTITY (ID) ON DELETE CASCADE,
    CONSTRAINT FK_VPX_ETX_REF_VPX_TAG_DEF FOREIGN KEY (TAG_ID)
       REFERENCES VPX_TAG_DEF (ID) ON DELETE CASCADE
 )
 ;
 /
 
 
 
 
 
 create table VPX_AUTH_TENANT_INFO (
    ID            INTEGER           not null,
    NAME          VARCHAR(255)      not null,
    constraint PK_VPX_AUTH_TENANT_INFO primary key (ID)
 );
 /
 
 CREATE UNIQUE INDEX VPX_AUTH_TENANT_INFO_U ON VPX_AUTH_TENANT_INFO(NAME);
 /
 
 
 
 
 create table VPX_AUTH_TENANT_MGMT_RS (
    ENTITY_ID     BIGINT            not null,
    constraint PK_VPX_AUTH_TENANT_MGMT_RS primary key (ENTITY_ID),
    constraint FK_VPX_AUTH_TENANT_MGMT_RS_ENT foreign key (ENTITY_ID)
       references VPX_ENTITY (ID) on delete cascade
 );
 /
 
 
 
 
 
 
 
 
 CREATE TABLE VPX_PATCH_CONTENT(
     PATCH_VERSION VARCHAR(10) NOT NULL,
     PATCH_TYPE VARCHAR(5) NOT NULL,
     CONSTRAINT PK_VPX_PATCH_CONTENT PRIMARY KEY (PATCH_VERSION));
 /
 
 
 
 
  DELETE FROM VPX_PARAMETER
  WHERE name = 'vpxd.event.features.VC_Events_Retention';
  /
 
 
 
 
 ALTER TABLE VPX_VM ADD HARDWARE_VERSION VARCHAR(20) null;
 /
 
 
 
 
 ALTER TABLE VPX_NON_ORM_VM_CONFIG_INFO ADD HARDWARE_CORES_AUTO NUMERIC(1) default 0;
 /
 UPDATE VPX_NON_ORM_VM_CONFIG_INFO
  SET HARDWARE_CORES_AUTO = 0;
 /
 
 
 
 
 ALTER TABLE VPX_NON_ORM_VM_CONFIG_INFO ADD CONTENT_LIB_ITEM_ID VARCHAR(255) null;
 /
 
 
 
 
 ALTER TABLE VPX_VM_VIRTUAL_DEVICE
       ALTER COLUMN DEVICE_INFO_SUMMARY TYPE VARCHAR(512);
 /
 
 ALTER TABLE VPX_VM_SN_VIRTUAL_DEVICE
       ALTER COLUMN DEVICE_INFO_SUMMARY TYPE VARCHAR(512);
 /
 
 
 
 
 ALTER TABLE VPX_NON_ORM_VM_CONFIG_INFO ADD FT_ENCRYPTION_MODE VARCHAR(30);
 /
 
 
 
 
 ALTER TABLE VPX_NON_ORM_VM_CONFIG_INFO ADD CONTENT_LIB_ITEM_VERSION VARCHAR(255) null;
 /
 
 
 
 
 ALTER TABLE VPX_NON_ORM_VM_CONFIG_INFO ADD GUEST_MONITORING_MODE_INFO_ENABLED NUMERIC(1) default 0;
 ALTER TABLE VPX_NON_ORM_VM_CONFIG_INFO ADD GUEST_MONITORING_MODE_INFO_GMMFILE VARCHAR(255) null;
 ALTER TABLE VPX_NON_ORM_VM_CONFIG_INFO ADD GUEST_MONITORING_MODE_INFO_APPLIANCE VARCHAR(255) null;
 /
 
 
 
 
 CREATE TABLE IF NOT EXISTS VPX_HOST_SGXINFO (
    HOST_ID               BIGINT                        NOT NULL,
    SGX_EPC_MEMORY_BYTES  BIGINT                            NULL,
    SGX_FLC_MODE          VARCHAR(16)                       NULL,
    SGX_LE_PUB_KEY_HASH   VARCHAR(64)                       NULL,
    CONSTRAINT PK_VPX_HOST_SGXINFO PRIMARY KEY (HOST_ID),
    CONSTRAINT FK_VPX_HOST_SGXINFO FOREIGN KEY (HOST_ID)
       REFERENCES VPX_HOST (ID) ON DELETE CASCADE
 );
 /
 
 
 
 
 CREATE TABLE IF NOT EXISTS VPX_VM_SGXINFO (
         ID                              BIGINT NOT NULL,
         VM_ID                           BIGINT NOT NULL,
         SGX_EPC_MEMORY_MB               BIGINT NULL,
         SGX_FLC_MODE                    VARCHAR(16) NULL,
         SGX_LE_PUB_KEY_HASH             VARCHAR(64) NULL,
         CONSTRAINT PK_VPX_VM_SGXINFO PRIMARY KEY (ID),
         CONSTRAINT FK_VPX_VM_SGXINFO FOREIGN KEY (VM_ID)
             REFERENCES VPX_VM (ID) ON DELETE CASCADE
 );
 
 
 
 
 ALTER TABLE VPX_EXT ADD IS_RESTRICTED_USER NUMERIC(1) default 0 NOT NULL;
 /
 
 
 
 
 
 ALTER TABLE VPX_CRYPTO_KMIP_CLUSTER ADD CLUSTER_TYPE INTEGER DEFAULT 0 NOT NULL;
 /
 
 
 
 
 
 ALTER TABLE VPX_CRYPTO_SERVER ADD CLUSTER_TYPE INTEGER DEFAULT 0 NOT NULL;
 /
 
 
 
 
 
 CREATE TABLE VPX_CRYPTO_DEFAULT_KMS_CLUSTER(
    ENTITY_ID                  BIGINT             NOT NULL,
    CLUSTER_ID                 VARCHAR(255)       NOT NULL,
    CLUSTER_TYPE               INTEGER  DEFAULT 0 NOT NULL,
    CONSTRAINT PK_VPX_CRYPTO_DEFAULT_KMS_CLUSTER PRIMARY KEY (ENTITY_ID),
    CONSTRAINT FK_VPX_CRYPTO_DEFAULT_KMS_ENTITY FOREIGN KEY (ENTITY_ID)
       REFERENCES VPX_ENTITY (ID) ON DELETE CASCADE,
    CONSTRAINT FK_VPX_CRYPTO_DEFAULT_KMS_CLUSTER FOREIGN KEY (CLUSTER_ID)
       REFERENCES VPX_CRYPTO_KMIP_CLUSTER (CLUSTER_ID) ON DELETE CASCADE
 );
 /
 
 
 
 
 
 ALTER TABLE VPX_HOST_CRYPTO_KEYS DROP CONSTRAINT PK_VPX_HOST_CRYPTO_KEYS;
 ALTER TABLE VPX_HOST_CRYPTO_KEYS RENAME CONSTRAINT PK_VPX_HOST_CRYPTO_KEYS_REF TO FK_VPX_HOST_CRYPTO_KEYS_REF;
 ALTER TABLE VPX_HOST_CRYPTO_KEYS ADD COLUMN KEY_ID SERIAL CONSTRAINT PK_VPX_HOST_CRYPTO_KEYS PRIMARY KEY;
 CREATE UNIQUE INDEX VPX_HOST_CRYPTO_KEYS_UN_KEY on VPX_HOST_CRYPTO_KEYS (
    HOST_ID,
    CRYPTO_KEY_ID,
    CRYPTO_KEY_PROVIDER_ID
 );
 CREATE TABLE VPX_CRYPTO_TAG (
    CRYPTO_TAG_ID              INTEGER           NOT NULL,
    CRYPTO_TAG                 VARCHAR(255)      NOT NULL,
    CONSTRAINT PK_VPX_CRYPTO_TAG PRIMARY key (CRYPTO_TAG_ID)
 );
 CREATE SEQUENCE VPX_CRYPTO_TAG_SEQ INCREMENT BY 10;
 CREATE TABLE VPX_HOST_CRYPTO_TAG_KEYS (
    KEY_ID                     INTEGER           NOT NULL,
    CRYPTO_TAG_ID              INTEGER           NOT NULL,
    CONSTRAINT PK_VPX_HOST_CRYPTO_TAG_KEYS PRIMARY key (KEY_ID, CRYPTO_TAG_ID),
    CONSTRAINT FK_VPX_HOST_CRYPTO_TAG_KEYS FOREIGN KEY (KEY_ID)
       REFERENCES VPX_HOST_CRYPTO_KEYS (KEY_ID)
          ON DELETE CASCADE,
    CONSTRAINT FK_VPX_HOST_CTK_CRYPTO_TAG_REF FOREIGN KEY (CRYPTO_TAG_ID)
       REFERENCES VPX_CRYPTO_TAG (CRYPTO_TAG_ID)
          ON DELETE CASCADE
 );
 /
 
 
 
 
 
 ALTER TABLE VPX_COMPUTE_RESOURCE ADD CRYPTO_MODE INTEGER NULL;
 /
 
 
 
 
 
 ALTER TABLE VPX_COMPUTE_RESOURCE ADD TRUSTED_CLUSTER_STATE INTEGER DEFAULT 0 NOT NULL;
 /
 
 
 
 
 
 ALTER TABLE VPX_DVPORT_SETTING ADD VNI INTEGER NULL;
 /
 
 
 
 
 
 ALTER TABLE VPX_DVPORTGROUP ADD TRANSPORTZONE_UUID VARCHAR(128);
 /
 
 
 
 
 
 ALTER TABLE VPX_DVPORTGROUP ADD LOGICALSWITCH_UUID VARCHAR(128);
 /
 
 
 
 
 ALTER TABLE VPX_RESOURCE_POOL ADD NAMESPACE_ID VARCHAR(255) NULL;
 /
 
 
 
 
 CREATE TABLE VPX_FOLDER_NAMESPACE  (
    ID                   BIGINT                          NOT NULL,
    NAMESPACE_ID         VARCHAR(255)                    NOT NULL,
    CONSTRAINT PK_VPX_FOLDER_NAMESPACE PRIMARY KEY (ID),
    CONSTRAINT FK_VPX_FOLDER_NAMESPACE FOREIGN KEY (ID)
          REFERENCES VPX_ENTITY (ID)
          ON DELETE CASCADE
 );
 /
 
 
 
 
 
 CREATE TABLE VPX_KMXD_SERVICES(
    ID                         SERIAL,
    UUID                       VARCHAR(64)       NOT NULL,
    HOSTNAME                   VARCHAR(255)      NOT NULL,
    PORT                       INTEGER           NOT NULL,
    CERT                       TEXT              NOT NULL,
    GROUP_ID                   VARCHAR(255)      NOT NULL,
    TRUSTED_CLS_ID             VARCHAR(255)      NOT NULL,
    CONSTRAINT PK_VPX_KMXD_SERVICES PRIMARY KEY (ID),
    CONSTRAINT KMXD_UNIQUE_UUID UNIQUE (UUID),
    CONSTRAINT KMXD_UNIQUE_HOSTNAME_PORT UNIQUE (HOSTNAME, PORT),
    CONSTRAINT KMXD_UNIQUE_GROUP_ID UNIQUE (GROUP_ID)
 );
 /
 
 
 
 
 
 CREATE TABLE VPX_ATTESTD_SERVICES(
    ID                         SERIAL,
    UUID                       VARCHAR(64)       NOT NULL,
    HOSTNAME                   VARCHAR(255)      NOT NULL,
    PORT                       INTEGER           NOT NULL,
    CERT                       TEXT              NOT NULL,
    GROUP_ID                   VARCHAR(255)      NOT NULL,
    TRUSTED_CLS_ID             VARCHAR(255)      NOT NULL,
    CONSTRAINT PK_VPX_ATTESTD_SERVICES PRIMARY KEY (ID),
    CONSTRAINT ATTESTD_UNIQUE_UUID UNIQUE (UUID),
    CONSTRAINT ATTESTD_UNIQUE_HOSTNAME_PORT UNIQUE (HOSTNAME, PORT),
    CONSTRAINT ATTESTD_UNIQUE_GROUP_ID UNIQUE (GROUP_ID)
 );
 /
 
 
 
 
 
 ALTER TABLE VPX_DVPORT ADD EXTERNAL_ID VARCHAR(48);
 /
 
 
 
 
 
 ALTER TABLE VPX_DVPORT ADD SEGMENT_PORT_ID VARCHAR(256);
 /
 
 
 
 
 
 ALTER TABLE VPX_DVPORTGROUP ADD BACKING_TYPE VARCHAR(255) default 'standard' NOT NULL;
 /
 
 
 
 
 
 ALTER TABLE VPX_DVHOST ADD NSXT_ENABLED NUMERIC(1) CHECK (NSXT_ENABLED IN (0, 1));
 /
 
 
 
 
 
 ALTER TABLE VPX_DVHOST ADD ENS_ENABLED NUMERIC(1) CHECK (ENS_ENABLED IN (0, 1));
 /
 
 
 
 
 ALTER TABLE VPX_DVHOST ADD TRANSPORT_ZONE_ID_ARRAY TEXT;
 /
 
 
 
 
 ALTER TABLE VPX_DVHOST ADD NSXT_USED_UPLINK_NAME_ARRAY TEXT;
 /
 
 
 
 
 
 ALTER TABLE VPX_ALARM_STATE ADD DISABLED NUMERIC(1) DEFAULT 0 NOT NULL;
 /
 
 
 
 
 
 CREATE TABLE VPX_CLUSTER_KMXD_SERVICES(
    CLUSTER_ID                         BIGINT            NOT NULL,
    SERVICE_ID                         INT               NOT NULL,
    CONSTRAINT PK_VPX_CLUSTER_KMXD_SERVICES PRIMARY KEY (CLUSTER_ID, SERVICE_ID),
    CONSTRAINT FK_VPX_CLUSTER_KMXD_SERVICES_CLUSTER_ID FOREIGN KEY (CLUSTER_ID)
       REFERENCES VPX_COMPUTE_RESOURCE (ID) ON DELETE CASCADE,
    CONSTRAINT FK_VPX_CLUSTER_KMXD_SERVICES_SERVICE_ID FOREIGN KEY (SERVICE_ID)
       REFERENCES VPX_KMXD_SERVICES (ID)
 );
 /
 
 
 
 
 
 CREATE TABLE VPX_CLUSTER_ATTESTD_SERVICES(
    CLUSTER_ID                         BIGINT            NOT NULL,
    SERVICE_ID                         INT               NOT NULL,
    CONSTRAINT PK_VPX_CLUSTER_ATTESTD_SERVICES PRIMARY KEY (CLUSTER_ID, SERVICE_ID),
    CONSTRAINT FK_VPX_CLUSTER_ATTESTD_SERVICES_CLUSTER_ID FOREIGN KEY (CLUSTER_ID)
       REFERENCES VPX_COMPUTE_RESOURCE (ID) ON DELETE CASCADE,
    CONSTRAINT FK_VPX_CLUSTER_ATTESTD_SERVICES_SERVICE_ID FOREIGN KEY (SERVICE_ID)
       REFERENCES VPX_ATTESTD_SERVICES (ID)
 );
 /
 
 
 
 
 
 ALTER TABLE VPX_NON_ORM_VM_CONFIG_INFO DROP COLUMN VFLASH_CACHE_RESERVATION;
 /
 
 
 
 
 create table VPX_CLUSTER_DATASTORE_CONF (
    CLUSTER_ID       BIGINT not null,
    DATASTORE_SPECS  TEXT,
    VERSION          BIGINT,
    CAN_CHANGE_CONFIG       BOOLEAN,
    CONSTRAINT PK_VPX_CLUS_DDC PRIMARY KEY (CLUSTER_ID),
    CONSTRAINT FK_VPX_CLUS_DDC FOREIGN KEY (CLUSTER_ID)
          REFERENCES VPX_COMPUTE_RESOURCE (ID)
          ON DELETE CASCADE
 );
 /
 
 
 
 
 
 ALTER TABLE VPX_DVPORTGROUP ADD TRANSPORTZONE_NAME VARCHAR(256);
 /
 
 
 
 
 
 ALTER TABLE VPX_DVPORTGROUP ADD SEGMENT_ID VARCHAR(256);
 /
 
 
 
 
 
 ALTER TABLE VPX_COMPUTE_RESOURCE ADD LIFECYCLE_MANAGED NUMERIC(1) DEFAULT 0 NOT NULL;
 /
 
 
 
 
 ALTER SEQUENCE IF EXISTS VPX_DEVICE_SEQ INCREMENT BY 1000;
 /
 
 ALTER SEQUENCE IF EXISTS VPX_STAT_COUNTER_SEQ INCREMENT BY 1000;
 /
 
 ALTER SEQUENCE IF EXISTS VPX_ENTITY_SEQ INCREMENT BY 1000;
 /
 
 ALTER SEQUENCE IF EXISTS VPX_EVENT_SEQ INCREMENT BY 1000;
 /
 
 ALTER SEQUENCE IF EXISTS VPX_TASK_SEQ INCREMENT BY 1000;
 /
 
 ALTER SEQUENCE IF EXISTS VPX_VDEVICE_BACKING_REL_SEQ INCREMENT BY 1000;
 /
 
 ALTER SEQUENCE IF EXISTS VPX_SN_VDEVICE_BACKING_REL_SEQ INCREMENT BY 1000;
 /
 
 
 
 
 
 ALTER TABLE VPX_DVPORT ADD BACKING_TYPE VARCHAR(16) DEFAULT 'standard' not NULL;
 /
 
 
 
 
 CREATE TABLE IF NOT EXISTS VPX_FCD_DATASTORE_INFO(
    ID                 VARCHAR(50)     NOT NULL,
    STORAGE_URL        VARCHAR(255)            ,
    CONSTRAINT PK_VPX_FCD_DATASTORE_INFO PRIMARY KEY (ID)
 );
 /
 
 
 
 
 
 CREATE TABLE IF NOT EXISTS VPX_STORAGE_OBJECT_MD(
    ID               VARCHAR(50)   NOT NULL,
    KEY              VARCHAR(256)  NOT NULL,
    VALUE            VARCHAR(4096)         ,
    CONSTRAINT PK_VPX_MD PRIMARY KEY (ID, KEY)
 );
 /
 
 
 
 
 CREATE TABLE IF NOT EXISTS VPX_LICENSE_DISCONNECTED_HOSTS (
     HOST_ENTITY_ID BIGINT NOT NULL
 );
 /
 
 
 
 
 
 CREATE TABLE IF NOT EXISTS VPX_STORAGE_OBJECT_INFO(
    ID              VARCHAR(50)   NOT NULL,
    NAME            VARCHAR(255)          ,
    CAPACITY        BIGINT                ,
    DATASTORE_ID    VARCHAR(50)           ,
    CREATE_TIME     TIMESTAMP             ,
    V_CLOCK         BIGINT                ,
    CONSTRAINT PK_VPX_STORAGE_OBJECT_INFO PRIMARY KEY (ID)
 );
 /
 
 
 CREATE TABLE IF NOT EXISTS VPX_STORAGE_OBJECT_INFO_673 (
    ID                VARCHAR(50)   NOT NULL,
    NAME              VARCHAR(255)          ,
    CAPACITY          BIGINT                ,
    DATASTORE_URL     VARCHAR(255)          ,
    CREATE_TIME       TIMESTAMP             ,
    V_CLOCK           BIGINT                ,
    BACKING_OBJECT_ID VARCHAR(60)           ,
    CONSTRAINT PK_VPX_STORAGE_OBJECT_INFO_673 PRIMARY KEY (ID)
 );
 /
 
 INSERT INTO VPX_STORAGE_OBJECT_INFO_673
        SELECT *
          FROM VPX_STORAGE_OBJECT_INFO;
 /
 
 DROP TABLE IF EXISTS VPX_STORAGE_OBJECT_INFO;
 /
 
 ALTER TABLE VPX_STORAGE_OBJECT_INFO_673 RENAME TO VPX_STORAGE_OBJECT_INFO;
 /
 
 ALTER TABLE VPX_STORAGE_OBJECT_INFO RENAME CONSTRAINT PK_VPX_STORAGE_OBJECT_INFO_673 TO PK_VPX_STORAGE_OBJECT_INFO;
 /
 
 CREATE INDEX IF NOT EXISTS VPX_FCD_DSURL_IDX ON VPX_STORAGE_OBJECT_INFO(DATASTORE_URL);
 /
 
 CREATE INDEX IF NOT EXISTS VPX_FCD_NAME_IDX ON VPX_STORAGE_OBJECT_INFO(NAME);
 /
 
 
 
 
 
 
 ALTER TABLE VPX_DVHOST ADD NSXT_STATUS VARCHAR(16);
 /
 
 
 
 
 
 ALTER TABLE VPX_DVHOST ADD NSXT_STATUS_DETAIL VARCHAR(256);
 /
 
 
 
 
 
 CREATE TABLE IF NOT EXISTS VPX_FCD_SNAPSHOT_INFO(
    ID                         VARCHAR(50) NOT NULL,
    SNAPSHOT_BACKING_OBJECT_ID VARCHAR(60) NOT NULL,
    CONSTRAINT pk_vpx_fcd_snapshot PRIMARY KEY (id, snapshot_backing_object_id)
 );
 /
 
 
 
 
 
 ALTER TABLE VPX_DVHOST ADD TRANSPORT_ZONE_TYPE_ARRAY TEXT;
 /
 
 
 
 
 
 CREATE TABLE VPX_MODULE_DEF(
    ID          BIGINT      NOT NULL,
    MODULE_UUID CHAR(36)    NOT NULL,
    CLUSTER_ID  BIGINT      NOT NULL,
    CONSTRAINT PK_VPX_MODULE_DEF PRIMARY KEY (ID),
    CONSTRAINT FK_VPX_MODULE_CLUSTER FOREIGN KEY (CLUSTER_ID)
       REFERENCES VPX_COMPUTE_RESOURCE(ID) ON DELETE CASCADE
 );
 /
 
 CREATE SEQUENCE VPX_MODULE_DEF_SEQ INCREMENT BY 100;
 /
 
 CREATE INDEX VPXI_MODULE_DEF_UUID ON VPX_MODULE_DEF (MODULE_UUID);
 /
 
 
 
 
 
 CREATE TABLE VPX_ENTITY_MODULE_XREF(
    ENTITY_ID   BIGINT      NOT NULL,
    MODULE_ID   BIGINT      NOT NULL,
    CONSTRAINT PK_VPX_ENTITY_MODULE_XREF PRIMARY KEY (ENTITY_ID, MODULE_ID),
    CONSTRAINT FK_VPX_ETX_REF_VPX_ENTITY FOREIGN KEY (ENTITY_ID)
       REFERENCES VPX_ENTITY (ID) ON DELETE CASCADE,
    CONSTRAINT FK_VPX_ETX_REF_VPX_MODULE_DEF FOREIGN KEY (MODULE_ID)
       REFERENCES VPX_MODULE_DEF (ID) ON DELETE CASCADE,
    CONSTRAINT UK_VPX_ETX_REF_ENTITY_ID UNIQUE (ENTITY_ID)
 );
 /
 
 
 
 
 
 ALTER TABLE VPX_DVHOST ADD ENS_INTERRUPT_ENABLED NUMERIC(1) default 0;
 /
 
 
 
 
 
 DROP TABLE IF EXISTS VPX_PATCH_RECON;
 /
 
 CREATE TABLE IF NOT EXISTS VPX_PATCH_RECON
 (
 patch VARCHAR(10)
 );
 /
 
 
 INSERT INTO VPX_PATCH_RECON (patch)
 SELECT '65052'
   FROM information_schema.tables
  WHERE NOT EXISTS (SELECT 1
                      FROM information_schema.tables
                     WHERE table_name = 'vpx_hci_config_info')
  LIMIT 1;
 /
 
 
 INSERT INTO VPX_PATCH_RECON (patch)
 SELECT '65053'
   FROM information_schema.tables
  WHERE EXISTS (SELECT 1
                  FROM information_schema.tables
                 WHERE table_name = 'vpx_hci_config_info')
  LIMIT 1;
 /
 
 INSERT INTO VPX_PATCH_VERSION
 SELECT *
   FROM VPX_PATCH_RECON
  WHERE NOT EXISTS ( SELECT 1
                       FROM
                      (
                       SELECT ROW_NUMBER() OVER ( ORDER BY INITIAL_VERSION ) AS rnum
                         FROM VPX_PATCH_VERSION
                       ) AS rc
                     WHERE rc.rnum = 1);
 /
 
 
 
 
 
 
 DROP FUNCTION IF EXISTS cleanup_events_tasks_proc ();
 /
 
 DROP FUNCTION IF EXISTS calc_topn1_proc (p_last_run timestamp, p_last_stat timestamp);
 /
 
 DROP FUNCTION IF EXISTS calc_topn2_proc (p_last_run timestamp, p_last_stat timestamp);
 /
 
 DROP FUNCTION IF EXISTS calc_topn3_proc (p_last_run timestamp, p_last_stat timestamp);
 /
 
 DROP FUNCTION IF EXISTS calc_topn4_proc (p_last_run timestamp, p_last_stat timestamp);
 /
 
 DROP FUNCTION IF EXISTS rule_topn1_proc ();
 /
 
 DROP FUNCTION IF EXISTS rule_topn2_proc ();
 /
 
 DROP FUNCTION IF EXISTS rule_topn3_proc ();
 /
 
 DROP FUNCTION IF EXISTS rule_topn4_proc ();
 /
 
 
 
 
 ALTER TABLE VPX_NON_ORM_VM_CONFIG_INFO ADD TOOLS_SYNC_TIME_WITH_HOST_ALLOWED_FLG NUMERIC(1) default 0;
 /
 
 
 
 
 
 ALTER TABLE VPX_COMPUTE_RESOURCE ADD EVC_GRAPHICS_MODE TEXT;
 /
 
 
 
 
 ALTER TABLE VPX_TASK RESET (
    autovacuum_analyze_scale_factor,
    autovacuum_analyze_threshold,
    autovacuum_vacuum_cost_delay,
    toast.autovacuum_vacuum_cost_delay,
    autovacuum_vacuum_cost_limit,
    toast.autovacuum_vacuum_cost_limit,
    autovacuum_vacuum_scale_factor,
    toast.autovacuum_vacuum_scale_factor,
    autovacuum_vacuum_threshold,
    toast.autovacuum_vacuum_threshold
 );
 /
 
 ALTER TABLE VPX_ENTITY RESET (
    autovacuum_analyze_scale_factor,
    autovacuum_analyze_threshold,
    autovacuum_vacuum_cost_delay,
    toast.autovacuum_vacuum_cost_delay,
    autovacuum_vacuum_cost_limit,
    toast.autovacuum_vacuum_cost_limit,
    autovacuum_vacuum_scale_factor,
    toast.autovacuum_vacuum_scale_factor,
    autovacuum_vacuum_threshold,
    toast.autovacuum_vacuum_threshold
 );
 /
 
 ALTER TABLE VPX_VM RESET (
    autovacuum_analyze_scale_factor,
    autovacuum_analyze_threshold,
    autovacuum_vacuum_cost_delay,
    toast.autovacuum_vacuum_cost_delay,
    autovacuum_vacuum_cost_limit,
    toast.autovacuum_vacuum_cost_limit,
    autovacuum_vacuum_scale_factor,
    toast.autovacuum_vacuum_scale_factor,
    autovacuum_vacuum_threshold,
    toast.autovacuum_vacuum_threshold
 );
 /
 
 ALTER TABLE VPX_DVPORT RESET (
    autovacuum_analyze_scale_factor,
    autovacuum_analyze_threshold,
    autovacuum_vacuum_cost_delay,
    toast.autovacuum_vacuum_cost_delay,
    autovacuum_vacuum_cost_limit,
    toast.autovacuum_vacuum_cost_limit,
    autovacuum_vacuum_scale_factor,
    toast.autovacuum_vacuum_scale_factor,
    autovacuum_vacuum_threshold,
    toast.autovacuum_vacuum_threshold
 );
 /
 
 ALTER TABLE VPX_HOST RESET (
    autovacuum_analyze_scale_factor,
    autovacuum_analyze_threshold,
    autovacuum_vacuum_cost_delay,
    toast.autovacuum_vacuum_cost_delay,
    autovacuum_vacuum_cost_limit,
    toast.autovacuum_vacuum_cost_limit,
    autovacuum_vacuum_scale_factor,
    toast.autovacuum_vacuum_scale_factor,
    autovacuum_vacuum_threshold,
    toast.autovacuum_vacuum_threshold
 );
 /
 
 ALTER TABLE VPX_HOST_VM_CONFIG_OPTION RESET (
    autovacuum_analyze_scale_factor,
    autovacuum_analyze_threshold,
    autovacuum_vacuum_cost_delay,
    toast.autovacuum_vacuum_cost_delay,
    autovacuum_vacuum_cost_limit,
    toast.autovacuum_vacuum_cost_limit,
    autovacuum_vacuum_scale_factor,
    toast.autovacuum_vacuum_scale_factor,
    autovacuum_vacuum_threshold,
    toast.autovacuum_vacuum_threshold
 );
 /
 
 ALTER TABLE VPX_GUEST_DISK RESET (
    autovacuum_analyze_scale_factor,
    autovacuum_analyze_threshold,
    autovacuum_vacuum_cost_delay,
    toast.autovacuum_vacuum_cost_delay,
    autovacuum_vacuum_cost_limit,
    toast.autovacuum_vacuum_cost_limit,
    autovacuum_vacuum_scale_factor,
    toast.autovacuum_vacuum_scale_factor,
    autovacuum_vacuum_threshold,
    toast.autovacuum_vacuum_threshold
 );
 /
 
 ALTER TABLE VPX_NIC RESET (
    autovacuum_analyze_scale_factor,
    autovacuum_analyze_threshold,
    autovacuum_vacuum_cost_delay,
    toast.autovacuum_vacuum_cost_delay,
    autovacuum_vacuum_cost_limit,
    toast.autovacuum_vacuum_cost_limit,
    autovacuum_vacuum_scale_factor,
    toast.autovacuum_vacuum_scale_factor,
    autovacuum_vacuum_threshold,
    toast.autovacuum_vacuum_threshold
 );
 /
 
 ALTER TABLE VPX_IP_ADDRESS RESET (
    autovacuum_analyze_scale_factor,
    autovacuum_analyze_threshold,
    autovacuum_vacuum_cost_delay,
    toast.autovacuum_vacuum_cost_delay,
    autovacuum_vacuum_cost_limit,
    toast.autovacuum_vacuum_cost_limit,
    autovacuum_vacuum_scale_factor,
    toast.autovacuum_vacuum_scale_factor,
    autovacuum_vacuum_threshold,
    toast.autovacuum_vacuum_threshold
 );
 /
 
 ALTER TABLE VPX_VM_TEXT RESET (
    autovacuum_analyze_scale_factor,
    autovacuum_analyze_threshold,
    autovacuum_vacuum_cost_delay,
    toast.autovacuum_vacuum_cost_delay,
    autovacuum_vacuum_cost_limit,
    toast.autovacuum_vacuum_cost_limit,
    autovacuum_vacuum_scale_factor,
    toast.autovacuum_vacuum_scale_factor,
    autovacuum_vacuum_threshold,
    toast.autovacuum_vacuum_threshold
 );
 /
 
 ALTER TABLE VPX_VM_VIRTUAL_DEVICE RESET (
    autovacuum_analyze_scale_factor,
    autovacuum_analyze_threshold,
    autovacuum_vacuum_cost_delay,
    toast.autovacuum_vacuum_cost_delay,
    autovacuum_vacuum_cost_limit,
    toast.autovacuum_vacuum_cost_limit,
    autovacuum_vacuum_scale_factor,
    toast.autovacuum_vacuum_scale_factor,
    autovacuum_vacuum_threshold,
    toast.autovacuum_vacuum_threshold
 );
 /
 
 
 
 
 ALTER TABLE VPX_JOURNAL_ENTRY SET (
    autovacuum_analyze_scale_factor = 0,
    autovacuum_analyze_threshold = 0,
    autovacuum_vacuum_cost_delay = 0,
    toast.autovacuum_vacuum_cost_delay = 0,
    autovacuum_vacuum_cost_limit = 1000,
    toast.autovacuum_vacuum_cost_limit = 1000,
    autovacuum_vacuum_scale_factor = 0,
    toast.autovacuum_vacuum_scale_factor = 0,
    autovacuum_vacuum_threshold = 1000,
    toast.autovacuum_vacuum_threshold = 1000
 );
 /
 
 
 
 
 
 ALTER TABLE VPX_COMPUTE_RESOURCE ADD EDRS_MAINTENANCE_MODE_STATUS INTEGER DEFAULT 0 NOT NULL;
 /
 
 
 
 
 
 ALTER TABLE VPX_COMPUTE_RESOURCE ADD EVC_PARTIAL INTEGER DEFAULT -1 NOT NULL;
 /
 
 
 
 
 
 
 create table VPX_HOST_SEVINFO (
    HOST_ID               BIGINT                        not null,
    SEV_STATE             VARCHAR(32)                   not null,
    SEV_MAX_GUESTS        INTEGER                       not null,
    constraint PK_VPX_HOST_SEVINFO primary key (HOST_ID),
    constraint FK_VPX_HOST_SEVINFO foreign key (HOST_ID)
       references VPX_HOST (ID) on delete cascade
 );
 
 ALTER TABLE VPX_NON_ORM_VM_CONFIG_INFO ADD SEV_ENABLED NUMERIC(1) default 0;
 /
 
 
 
 
 ALTER TABLE VPX_DS_INFO ADD CONTAINER_ID VARCHAR(33);
 /
 ALTER TABLE VPX_DS_INFO ADD ALIAS_OF     VARCHAR(33);
 
 
 
 
 
 ALTER TABLE VPX_HOST_PCI_DEVICE ADD NUMA_ID INTEGER;
 /
 
 
 
 
 
 ALTER TABLE VPX_STORAGE_OBJECT_INFO ADD COLUMN DISK_PATH TEXT null;
 /
 ALTER TABLE VPX_STORAGE_OBJECT_INFO ADD COLUMN USED_CAPACITY BIGINT DEFAULT -1;
 /
 
 
 
 
 
 ALTER TABLE VPX_DVS_LAG ADD LAG_TIMEOUT_MODE VARCHAR(255);
 /
 
 
 
 
 
 ALTER TABLE VPX_FCD_DATASTORE_INFO ADD COLUMN VCLOCK BIGINT DEFAULT -1;
 /
 
 
 
 
 CREATE INDEX VPX_STAT_COUNTER_D1 on VPX_STAT_COUNTER(DEVICE_ID);
 /
 
 
 
 
 CREATE TABLE VPX_ATTESTD_SIGNING_INFO(
    SERVICE_ID                 BIGINT            NOT NULL,
    CERT                       TEXT,
    PUBKEY                     TEXT,
    CONSTRAINT PK_VPX_ATTESTD_SIGNING_INFO PRIMARY KEY (SERVICE_ID),
    CONSTRAINT FK_VPX_ATTESTD_SIGNING_INFO FOREIGN KEY (SERVICE_ID)
       REFERENCES VPX_ATTESTD_SERVICES(ID) ON DELETE CASCADE
 );
 
 
 
 
 ALTER TABLE VPX_NON_ORM_VM_CONFIG_INFO ADD VNUMA_CORES_PER_NODE      INTEGER    default 0;
 ALTER TABLE VPX_NON_ORM_VM_CONFIG_INFO ADD VNUMA_AUTO_CORES_PER_NODE NUMERIC(1) default 0;
 /
 
 
 
 
 CREATE TABLE IF NOT EXISTS VPX_HOST_VSAN_RUNTIME (
    ID                   BIGINT  NOT NULL,
    VSAN_RUNTIME_INFO    TEXT,
    CONSTRAINT PK_VPX_HOST_VSAN_RUNTIME PRIMARY KEY (ID),
    CONSTRAINT FK_VPX_HOST_VSAN_RUNTIME_REF_VPX_HOST FOREIGN KEY (ID)
       REFERENCES VPX_HOST (ID) ON DELETE CASCADE
 );
 /
 
 
 
 
 
 ALTER TABLE VPX_CRYPTO_KMIP_CLUSTER ADD BACKUP_COUNT INTEGER DEFAULT 0 NOT NULL;
 CREATE TABLE IF NOT EXISTS VPX_CRYPTO_NATIVE_KEY_PROVIDER(
    CLUSTER_ID     VARCHAR(255) NOT NULL,
    KEY_ID         VARCHAR(255) NOT NULL,
    ENC_KDK        VARCHAR(255) NOT NULL,
    KEY_ID_LAST_UPDATE TIMESTAMP,
    PERSIST_TOKEN  TEXT,
    CONSTRAINT PK_VPX_CRYPTO_NATIVE_KEY_PROVIDER PRIMARY KEY (CLUSTER_ID),
    CONSTRAINT FK_VPX_CRYPTO_NATIVE_KEY_PROVIDER FOREIGN KEY (CLUSTER_ID)
       REFERENCES VPX_CRYPTO_KMIP_CLUSTER (CLUSTER_ID) ON DELETE CASCADE
 );
 /
 
 
 
 
 INSERT INTO VPX_DVS_INFRA_RES_POOL
    SELECT
       ID as DVS_ID,
       'backupNfc' as NRP_KEY,
       'vSphere Backup NFC Traffic Type' as DESCRIPTION,
       -1 as ALLOCATION_LIMIT,
       50 as ALLOCATION_SHARES_SHARES,
       'normal' as ALLOCATION_SHARES_LEVEL,
       0 as ALLOCATION_RESERVATION
    FROM VPX_DVS
    WHERE NETWORK_RESOURCE_CTRL_VERSION='version3' AND
          PRODUCT_VERSION='7.0.0' AND
          ID NOT IN (SELECT
                        DVS_ID
                     FROM VPX_DVS_INFRA_RES_POOL
                     WHERE NRP_KEY = 'backupNfc');
 /
 
 
 
 
 ALTER TABLE VPX_HOST_X ADD HA_ATTRIBUTES INTEGER NULL;
 /
 
 
 
 
 ALTER TABLE VPX_VM ADD ENABLE_PMEM_FAILOVER int NULL;
 /
 
 
 
 
 ALTER TABLE IF EXISTS VPX_VM ADD COLUMN IF NOT EXISTS PMEM_SNAPSHOT_MODE VARCHAR(26) NULL;
 /
 
 
 
 
 ALTER TABLE VPX_CRYPTO_KMIP_CLUSTER ADD TPM_REQUIRED INTEGER DEFAULT 0 NOT NULL;
 ALTER TABLE VPX_CRYPTO_KMIP_CLUSTER ADD AUTO_REMEDIATE INTEGER DEFAULT 0 NOT NULL;
 /
 
 
 
 
 
 CREATE TABLE VPX_HOST_SYNC_GEN (
    HOST_ID              BIGINT                  NOT NULL,
    MASTER_GEN           INTEGER DEFAULT 0       NOT NULL,
    MASTER_SPEC_GEN      INTEGER DEFAULT 0       NOT NULL,
    CONSTRAINT PK_HOST_SYNC_GEN PRIMARY KEY (HOST_ID),
    CONSTRAINT FK_HOST_SYNC_GEN_REF_VPX_HOST FOREIGN KEY (HOST_ID)
       REFERENCES VPX_HOST(ID) ON DELETE CASCADE
 );
 /
 INSERT INTO VPX_HOST_SYNC_GEN (HOST_ID, MASTER_GEN, MASTER_SPEC_GEN)
    SELECT t.ID AS HOST_ID,
       CAST(t.MASTER_GEN AS INTEGER) AS MASTER_GEN,
       CAST(t.MASTER_SPEC_GEN AS INTEGER) AS MASTER_SPEC_GEN
       FROM VPX_HOST t;
 /
 ALTER TABLE VPX_HOST DROP COLUMN MASTER_GEN;
 /
 ALTER TABLE VPX_HOST DROP COLUMN MASTER_SPEC_GEN;
 /
 
 
 
 
 ALTER TABLE VPX_NON_ORM_VM_CONFIG_INFO ADD CHIPSET_MOTHERBOARDLAYOUT VARCHAR(56) null;
 /
 
 
 
 
 
 ALTER TABLE VPX_VM ADD COLUMN APPHEARTBEAT_STATUS VARCHAR(64) null;
 /
 
 
 
 
 CREATE TABLE VPX_HOST_SERVICE_MODE_STATE(
    HOST_ID              BIGINT  NOT NULL,
    SERVICE_MODE_STATES  TEXT NOT NULL,
    CONSTRAINT PK_VPX_HOST_SERVICE_MODE_STATE PRIMARY KEY (HOST_ID),
    CONSTRAINT FK_VPX_HOST_SERVICE_MODE_STATE FOREIGN KEY (HOST_ID)
       REFERENCES VPX_HOST (ID) ON DELETE CASCADE
 );
 /
 
 
 
 
 CREATE TABLE VPX_VCS_VM(
    VM_ID              BIGINT  NOT NULL,
    VM_VCS_STATE       NUMERIC(1) DEFAULT 1   NOT NULL,
    CONSTRAINT PK_VPX_VCS_VM PRIMARY KEY (VM_ID),
    CONSTRAINT FK_VPX_VCS_VM FOREIGN KEY (VM_ID)
       REFERENCES VPX_VM (ID) ON DELETE CASCADE
 );
 /
 
 
 
 
 
 CREATE TABLE VPX_HOST_PERFINFO (
    HOST_ID              BIGINT                  NOT NULL,
    LAST_PERF_TIME       TIMESTAMP,
    PERF_REFRESH_RATE    INTEGER,
    CONSTRAINT PK_HOST_PERFINFO PRIMARY KEY (HOST_ID),
    CONSTRAINT FK_HOST_PERFINFO FOREIGN KEY (HOST_ID)
       REFERENCES VPX_HOST(ID) ON DELETE CASCADE
 );
 /
 INSERT INTO VPX_HOST_PERFINFO (HOST_ID, LAST_PERF_TIME, PERF_REFRESH_RATE)
    SELECT t.ID AS HOST_ID,
       t.LAST_PERF_TIME AS LAST_PERF_TIME,
       t.PERF_REFRESH_RATE AS PERF_REFRESH_RATE
       FROM VPX_HOST t;
 /
 ALTER TABLE VPX_HOST DROP COLUMN LAST_PERF_TIME;
 /
 ALTER TABLE VPX_HOST DROP COLUMN PERF_REFRESH_RATE;
 /
 
 
 
 
 ALTER TABLE VPX_DATACENTER ADD MAXIMUM_HW_VERSION VARCHAR(255) null;
 /
 ALTER TABLE VPX_COMPUTE_RESOURCE ADD MAXIMUM_HW_VERSION VARCHAR(255) null;
 /
 
 
 
 
 
 
 ALTER TABLE VPX_FCD_SNAPSHOT_INFO ADD IF NOT EXISTS SNAPSHOT_DESCRIPTION VARCHAR(255);
 /
 
 ALTER TABLE VPX_FCD_SNAPSHOT_INFO ADD IF NOT EXISTS SNAPSHOT_ID VARCHAR(60);
 /
 
 ALTER TABLE VPX_FCD_SNAPSHOT_INFO ADD IF NOT EXISTS SNAPSHOT_DISK_PATH VARCHAR(255);
 /
 
 CREATE UNIQUE INDEX IF NOT EXISTS VPX_SNAPSHOT_ID ON VPX_FCD_SNAPSHOT_INFO(SNAPSHOT_ID);
 /
 
 ALTER TABLE VPX_FCD_SNAPSHOT_INFO DROP CONSTRAINT IF EXISTS VPX_SNAPSHOT_ID_U1;
 /
 
 ALTER TABLE VPX_FCD_SNAPSHOT_INFO ADD CONSTRAINT VPX_SNAPSHOT_ID_U2 UNIQUE USING INDEX VPX_SNAPSHOT_ID;
 /
 
 
 
 
 
 CREATE TABLE VPX_HOST_NFC_CONFIG (
    HOST_ID           BIGINT       NOT NULL,
    TOTAL_MEMORY      INTEGER      NOT NULL,
    STREAMING_MEMORY  INTEGER      NOT NULL,
    CONSTRAINT PK_VPX_HOST_NFC_CONFIG PRIMARY KEY (HOST_ID),
    CONSTRAINT FK_VPX_HOST_NFC_CONFIG FOREIGN KEY (HOST_ID)
       REFERENCES VPX_HOST (ID) ON DELETE CASCADE
 );
 /
 
 
 
 
 
 ALTER TABLE VPX_COMPUTE_RESOURCE
       ADD COLUMN PMEM_ADMISSION_CTRL_ENABLED BOOLEAN,
       ADD COLUMN FAILOVER_PMEM_RESOURCES INTEGER,
       ADD COLUMN FAILOVER_PMEM_RESOURCE_AUTO_COMPUTE BOOLEAN;
 /
 
 
 
 
 
 
 
 ALTER TABLE IF EXISTS VPX_HOST_SERVICE_MODE_STATE RENAME TO VPX_HOST_PARTIAL_MM_STATUS;
 
 DO $$
 BEGIN
   IF EXISTS(SELECT *
               FROM information_schema.columns
              WHERE table_name = lower('VPX_HOST_PARTIAL_MM_STATUS')
                AND column_name = lower('SERVICE_MODE_STATES'))
   THEN
       ALTER TABLE VPX_HOST_PARTIAL_MM_STATUS RENAME COLUMN SERVICE_MODE_STATES TO PARTIAL_MM_STATUS;
   END IF;
 END $$;
 
 DO $$
 BEGIN
   IF EXISTS (SELECT constraint_name
                FROM information_schema.table_constraints
               WHERE table_schema='vc'
                 AND table_name = lower('VPX_HOST_PARTIAL_MM_STATUS')
                 AND constraint_name = lower('PK_VPX_HOST_SERVICE_MODE_STATE'))
   THEN
       ALTER TABLE VPX_HOST_PARTIAL_MM_STATUS RENAME CONSTRAINT PK_VPX_HOST_SERVICE_MODE_STATE TO PK_VPX_HOST_PARTIAL_MM_STATUS;
   END IF;
 END $$;
 
 DO $$
 BEGIN
   IF EXISTS (SELECT constraint_name
                FROM information_schema.table_constraints
               WHERE table_schema='vc'
                 AND table_name = lower('VPX_HOST_PARTIAL_MM_STATUS')
                 AND constraint_name = lower('FK_VPX_HOST_SERVICE_MODE_STATE'))
   THEN
       ALTER TABLE VPX_HOST_PARTIAL_MM_STATUS RENAME CONSTRAINT FK_VPX_HOST_SERVICE_MODE_STATE TO FK_VPX_HOST_PARTIAL_MM_STATUS;
   END IF;
 END $$;
 /
 
 
 
 
 CREATE TABLE IF NOT EXISTS VSAN_HISTORICAL_CLUSTER (
    CLUSTER_ID             SERIAL,
    CLUSTER_NAME           VARCHAR(256),
    constraint PK_VSAN_HISTORICAL_CLUSTER primary key (
      CLUSTER_ID) using index TABLESPACE hs4,
    constraint UK_VSAN_HISTORICAL_CLUSTER unique (
       CLUSTER_NAME) using index TABLESPACE hs4
 ) TABLESPACE hs4;
 
 
 
 
 CREATE TABLE IF NOT EXISTS VSAN_HISTORICAL_GROUP (
    GROUP_ID             SERIAL,
    GROUP_NAME           VARCHAR(64),
    constraint PK_VSAN_HISTORICAL_GROUP primary key (
      GROUP_ID) using index TABLESPACE hs4,
    constraint UK_VSAN_HISTORICAL_GROUP unique (
      GROUP_NAME) using index TABLESPACE hs4
 ) TABLESPACE hs4;
 
 
 
 
 CREATE TABLE IF NOT EXISTS VSAN_HISTORICAL_TEST (
    TEST_ID             SERIAL,
    TEST_NAME           VARCHAR(64),
    constraint PK_VSAN_HISTORICAL_TEST primary key (
      TEST_ID) using index TABLESPACE hs4,
    constraint UK_VSAN_HISTORICAL_TEST unique (
      TEST_NAME) using index TABLESPACE hs4
 ) TABLESPACE hs4;
 
 
 
 
 CREATE TABLE IF NOT EXISTS VSAN_HISTORICAL_HEALTH_CHECK (
    HEALTH_ID           INT   NOT NULL,
    HEALTH_DESC         VARCHAR(15),
    constraint PK_VSAN_HISTORICAL_HEALTH_CHECK primary key (
      HEALTH_ID) using index TABLESPACE hs4,
    constraint UK_VSAN_HISTORICAL_HEALTH_CHECK unique (
      HEALTH_DESC) using index TABLESPACE hs4
 ) TABLESPACE hs4;
 
 
 
 
 DROP TABLE IF EXISTS VSAN_HISTORICAL_HEALTH;
 CREATE TABLE VSAN_HISTORICAL_HEALTH (
    CLUSTER_ID          INT,
    GROUP_ID            INT,
    TEST_ID             INT,
    CREATION_TIME       TIMESTAMP   NOT NULL,
    HEALTH_ID           INT         NOT NULL,
    DETAILS             TEXT,
    TAGS                TEXT,
    constraint FK_CLUSTER_VHH_CLUSTERID foreign key(CLUSTER_ID)
                REFERENCES VSAN_HISTORICAL_CLUSTER (CLUSTER_ID),
    constraint FK_GROUP_VHH_GROUPID foreign key(GROUP_ID)
                REFERENCES VSAN_HISTORICAL_GROUP (GROUP_ID),
    constraint FK_TEST_VHH_TESTID foreign key(TEST_ID)
                REFERENCES VSAN_HISTORICAL_TEST (TEST_ID),
    constraint FK_HEALTH_VHH_HEALTHID foreign key(HEALTH_ID)
                REFERENCES VSAN_HISTORICAL_HEALTH_CHECK (HEALTH_ID)
 ) PARTITION BY RANGE (CREATION_TIME) TABLESPACE hs4;
 
 
 
 
 CREATE UNIQUE INDEX UK_VSAN_HISTORICAL_HEALTH on VSAN_HISTORICAL_HEALTH (
             CLUSTER_ID,
             GROUP_ID,
             TEST_ID,
             CREATION_TIME
 ) TABLESPACE hs4;
 /
 
 
 
 
 
 ALTER TABLE IF EXISTS VPX_EXT RENAME COLUMN IS_RESTRICTED_USER TO IS_ONLY_MANAGED_BY_SP_USER;
 /
 
 
 
 
 CREATE TABLE IF NOT EXISTS VPX_EXT_UPGRADE(
    STATUS   NUMERIC(1)   DEFAULT 0 not null
 );
 /
 
 INSERT INTO VPX_EXT_UPGRADE (STATUS) VALUES (0);
 /
 
 
 
 
 CREATE TABLE IF NOT EXISTS VPX_HOST_MEMORY_TIER_INFO(
    HOST_ID             BIGINT         NOT NULL,
    MEMORY_TIERING_TYPE VARCHAR(56)    NOT NULL,
    MEMORY_TIER_INFO    TEXT           NOT NULL,
    CONSTRAINT PK_VPX_HOST_MEMORY_TIER_INFO PRIMARY KEY (HOST_ID),
    CONSTRAINT FK_VPX_HOST_MEMORY_TIER_INFO FOREIGN KEY (HOST_ID)
       REFERENCES VPX_HOST (ID) ON DELETE CASCADE
 );
 /
 
 
 
 
 DO
 $$ BEGIN
 IF NOT EXISTS (SELECT 1
            FROM information_schema.data_type_privileges
            WHERE object_schema = 'vc'
            AND object_name = 'vc_stat_agg_state'
            )
 THEN
    CREATE TYPE vc_stat_agg_state AS (val1 numeric, val2 numeric, type numeric);
 END IF;
 END $$ LANGUAGE plpgsql;
 /
 
 CREATE OR REPLACE FUNCTION vc_stat_agg_transition(agg_state   vc_stat_agg_state,
                                                   val         numeric,
                                                   type        numeric,
                                                   sample_time timestamp)
   RETURNS vc_stat_agg_state
   LANGUAGE plpgsql
   IMMUTABLE
 AS $$
 BEGIN
   IF agg_state.type <> type THEN
     raise exception 'type must have a consistent value for each group';
   END IF;
   IF val IS NULL THEN
     RETURN agg_state;
   END IF;
   IF type < 0 or type > 4 THEN
     RETURN agg_state;
   END IF;
   agg_state.type = type;
   CASE type
     WHEN 0 THEN
       agg_state.val2 := agg_state.val2 + 1;
       agg_state.val1 := coalesce(agg_state.val1, 0) + val;
     WHEN 1 THEN
       IF agg_state.val1 IS NULL OR val > agg_state.val1 THEN agg_state.val1 := val; END IF;
     WHEN 2 THEN
       IF agg_state.val1 IS NULL OR val < agg_state.val1 then agg_state.val1 := val; END IF;
     WHEN 3 THEN
       IF sample_time IS NULL THEN
         RETURN agg_state;
       END IF;
       DECLARE
         etime numeric;
       BEGIN
         etime := extract(epoch FROM sample_time)::numeric;
         IF agg_state.val1 IS NULL OR etime > agg_state.val2 THEN
           agg_state.val1 := val;
           agg_state.val2 := etime;
         END IF;
       END;
     WHEN 4 then
       agg_state.val1 := coalesce(agg_state.val1, 0) + val;
   END case;
   RETURN agg_state;
 END;
 $$;
 /
 
 CREATE OR REPLACE FUNCTION vc_stat_agg_final(agg_state vc_stat_agg_state)
   RETURNS numeric
   LANGUAGE plpgsql
   IMMUTABLE
 AS $$
 BEGIN
   RETURN
     case agg_state.type
       WHEN 0 THEN case when agg_state.val2 >= 1 THEN agg_state.val1 / agg_state.val2 ELSE NULL::numeric END
       WHEN 1 THEN agg_state.val1
       WHEN 2 THEN agg_state.val1
       WHEN 3 THEN agg_state.val1
       WHEN 4 THEN agg_state.val1
       ELSE NULL::numeric
     END;
 End;
 $$;
 /
 
 DO
 $$ BEGIN
 IF NOT EXISTS (SELECT 1
            FROM information_schema.routines
            WHERE routine_schema = 'vc'
            AND routine_name = 'vc_stat_agg'
            )
 THEN
     CREATE AGGREGATE vc_stat_agg(val numeric, type numeric, sample_time timestamp)
     (
       sfunc = vc_stat_agg_transition,
       stype = vc_stat_agg_state,
       finalfunc = vc_stat_agg_final,
       initcond = '(,0,)'
     );
 END IF;
 END $$ LANGUAGE plpgsql;
 /
 
 DROP FUNCTION IF EXISTS stats_rollup1_proc();
 /
 
 DROP FUNCTION IF EXISTS stats_rollup2_proc();
 /
 
 DROP FUNCTION IF EXISTS stats_rollup3_proc();
 /
 
 
 
 
 CREATE TABLE IF NOT EXISTS VPX_VCLS_DRS_WF_COUNTERS(
    EVENT_ID             BIGINT         NOT NULL,
    CLUSTER_ID           BIGINT         NOT NULL,
    INIT_PLACE_COUNT     INT,
    PLACE_MULTIVM_COUNT  INT,
    LB_COUNT             INT,
    HOST_EMM_COUNT       INT,
    CLUSTER_EMM_COUNT    INT,
    XDRS_REC_COUNT       INT,
    RPE_REC_COUNT        INT,
    FIX_VIO_COUNT        INT,
    QUERY_WHATIF_COUNT   INT,
    CONSTRAINT PK_VPX_VCLS_DRS_WF_COUNTERS PRIMARY KEY (EVENT_ID),
    CONSTRAINT FK_VPX_VCLS_DRS_WF_COUNTERS FOREIGN KEY (CLUSTER_ID)
       REFERENCES VPX_ENTITY (ID) ON DELETE CASCADE
 );
 /
 
 
 
 
 ALTER TABLE VPX_TABLE
       ALTER COLUMN TABLE_NAME TYPE VARCHAR(63);
 /
 
 ALTER TABLE VPX_TABLE
       ALTER COLUMN COL_NAME TYPE VARCHAR(63);
 /
 
 
 
 
 ALTER TABLE VPX_DVS ADD NETWORK_OFFLOAD_ALLOWED NUMERIC(1) DEFAULT 0 NOT NULL;
 /
 
 
 
 
 CREATE TABLE IF NOT EXISTS VPX_VM_OP_NOTIFICATION_CFG (
    CLUSTER_ID                    BIGINT   NOT NULL,
    NOTIFICATION_TIMEOUT          INTEGER,
    CONSTRAINT PK_VPX_VM_OP_NOTIFICATION_CFG PRIMARY KEY (CLUSTER_ID),
    CONSTRAINT FK_VPX_VM_OP_NOTIFICATION_CFG_REF_VPX_ENTITY FOREIGN KEY (CLUSTER_ID)
       REFERENCES VPX_ENTITY (ID)
          ON DELETE CASCADE
 );
 /
 
 
 
 
 ALTER TABLE VPX_DVHOST ADD NETWORK_OFFLOADING_ENABLED NUMERIC(1) DEFAULT 0;
 /
 
 
 
 
 CREATE TABLE IF NOT EXISTS VPX_HOST_STATE_ENCRYPTION_INFO(
    HOST_ID                       BIGINT         NOT NULL,
    PROTECTION_MODE               VARCHAR(8)     NOT NULL,
    REQUIRE_SECURE_BOOT           NUMERIC(1),
    REQUIRE_EXEC_INSTALLED_ONLY   NUMERIC(1),
    CONSTRAINT PK_VPX_HOST_STATE_ENCRYPTION_INFO PRIMARY KEY (HOST_ID),
    CONSTRAINT FK_VPX_HOST_STATE_ENCRYPTION_INFO FOREIGN KEY (HOST_ID)
       REFERENCES VPX_HOST (ID) ON DELETE CASCADE
 );
 /
 
 
 
 
 ALTER TABLE VPX_DVS ADD PREV_VERSION VARCHAR(255);
 /
 
 
 
 
 ALTER TABLE VPX_NON_ORM_VM_CONFIG_INFO ADD CPUID_NUMSMT INTEGER DEFAULT 1 NOT NULL;
 
 
 
 
 ALTER TABLE VPX_NON_ORM_VM_CONFIG_INFO ADD CRYPTO_INTEGRITY_PROTECTION_TYPE INTEGER default 0;
 /
 
 
 
 
 ALTER TABLE VPX_VDEVICE_FILE_BACKING ADD CRYPTO_INTEGRITY_PROTECTION_TYPE INTEGER default 0;
 /
 
 
 
 
 ALTER TABLE VPX_DVS ADD NETWORK_OFFLOAD_SPEC_ID VARCHAR(255) NULL;
 /
 
 
 
 
 CREATE TABLE IF NOT EXISTS VPX_CLUSTER_VCLS_DATASTORE (
    CLUSTER_ID       BIGINT                 NOT NULL,
    DATASTORE_ID     BIGINT                 NOT NULL,
    ALLOWMENT        NUMERIC(1)   DEFAULT 0 NOT NULL,
    CONSTRAINT PK_VPX_CLUS_VCLS_DS PRIMARY KEY (DATASTORE_ID, CLUSTER_ID),
    CONSTRAINT FK_VPX_CLUS_VCLS_DS_REF_VPX_COMP_RES FOREIGN KEY (CLUSTER_ID)
          REFERENCES VPX_COMPUTE_RESOURCE (ID)
          ON DELETE CASCADE,
    CONSTRAINT FK_VPX_CLUS_VCLS_DS_REF_VPX_DS FOREIGN KEY (DATASTORE_ID)
          REFERENCES VPX_DATASTORE (ID)
          ON DELETE CASCADE
 );
 /
 
 
 
 
 ALTER TABLE VPX_DVS DROP COLUMN NETWORK_OFFLOAD_ALLOWED;
 /
 
 DROP TABLE IF EXISTS VPX_VM_OP_NOTIFICATION_CFG;
 /
 
 
 
 
 ALTER TABLE IF EXISTS VPX_HOST_SGXINFO ADD IF NOT EXISTS SGX_REGISTRATION_INFO TEXT NULL;
 
 
 
 
 
 ALTER TABLE IF EXISTS VPX_VM_SGXINFO ADD IF NOT EXISTS SGX_REQUIRE_ATTESTATION BOOLEAN NULL;
 
 
 
 
 ALTER TABLE VPX_COMPUTE_RESOURCE ADD CONFIG_MANAGER_ENABLED NUMERIC(1) DEFAULT 0 NOT NULL;
 
 
 
 
 DROP SEQUENCE IF EXISTS VPX_CALLBACK_SERVICE_SEQ;
 /
 DROP INDEX IF EXISTS VPXI_CBK_SERV_UNIQUE_KEY;
 /
 DROP TABLE IF EXISTS VPX_CALLBACK_WHITELIST;
 /
 DROP TABLE IF EXISTS VPX_CALLBACK_SERVICE;
 /
 
 
 
 
 ALTER TABLE IF EXISTS VPX_NON_ORM_VM_CONFIG_INFO
       ADD IF NOT EXISTS BOOT_OPTION_NETWORK_PROTOCOL VARCHAR(5) NULL;
 /
 
 
 
 
 CREATE TABLE IF NOT EXISTS VPX_AUTHZ_PRIVILEGES (
    PRIV_ID              INT            NOT NULL,
    PRIV_NAME            VARCHAR(255)   UNIQUE  NOT NULL,
    PRIV_GROUP           VARCHAR(255)   NOT NULL,
    PRIV_VERSION         BIGINT         NOT NULL,
    PRIV_ON_PARENT       BOOLEAN        NOT NULL,
    CONSTRAINT PK_VPX_AUTHZ_PRIVILEGES PRIMARY KEY (PRIV_ID)
 );
 /
 
 
 
 
 CREATE TABLE IF NOT EXISTS VPX_AUTHZ_ROLES (
    ROLE_ID              BIGINT            NOT NULL,
    ROLE_NAME            VARCHAR(255)      NOT NULL,
    ROLE_VERSION         BIGINT            NOT NULL,
    CONSTRAINT PK_VPX_AUTHZ_ROLES PRIMARY KEY (ROLE_ID)
 );
 /
 
 
 
 
 CREATE TABLE IF NOT EXISTS VPX_AUTHZ_ROLES_PRIVILEGES  (
    ROLE_ID              BIGINT                NOT NULL,
    PRIV_ID              INT                   NOT NULL,
    CONSTRAINT PK_VPX_AUTHZ_ROLES_PRIVILEGES PRIMARY KEY (ROLE_ID, PRIV_ID),
    CONSTRAINT FK_VPX_AUTHZ_ROLES_PRIVILEGES_ROLE FOREIGN KEY (ROLE_ID)
        REFERENCES VPX_AUTHZ_ROLES (ROLE_ID),
    CONSTRAINT FK_VPX_AUTHZ_ROLES_PRIVILEGES_PRIV FOREIGN KEY (PRIV_ID)
        REFERENCES VPX_AUTHZ_PRIVILEGES (PRIV_ID)
 );
 /
 
 
 
 
 CREATE TABLE IF NOT EXISTS VPX_AUTHZ_GLOBAL_PERMISSIONS (
    PRINCIPAL            VARCHAR(255)      NOT NULL,
    IS_GROUP             BOOLEAN           NOT NULL,
    VERSION              BIGINT            NOT NULL,
    ROLE_ID              BIGINT            NOT NULL,
    CONSTRAINT PK_VPX_AUTHZ_GLOBAL_PERMISSIONS PRIMARY KEY (PRINCIPAL, IS_GROUP),
    CONSTRAINT FK_VPX_AUTHZ_GLOBAL_PERMISSIONS FOREIGN KEY (ROLE_ID)
        REFERENCES VPX_AUTHZ_ROLES (ROLE_ID)
 );
 /
 
 
 
 
 ALTER TABLE IF EXISTS VPX_VM ADD COLUMN IF NOT EXISTS
    GUEST_HEARTBEAT_STATUS NUMERIC(1) default 0 not null
    CONSTRAINT vm_ghb_status_valid_check CHECK (GUEST_HEARTBEAT_STATUS IN (0, 1, 2, 3));
 /
 
 
 
 
 ALTER TABLE VPX_VM ADD INTEGRITY_CHECK_STATE NUMERIC(1) NULL;
 /
