create or replace FUNCTION l_purge_stat3_proc()
 RETURNS VOID
 
 
 
 
     
    AS $procedure$
    DECLARE
     v_err_log  CHAR(3);
    v_errnum  VARCHAR(10);
    v_errmsg  VARCHAR(1000);
 
 BEGIN
 
    v_errnum := '00000';
 
    select COALESCE(value,'OFF') into v_err_log
    from vpx_parameter
    where name = 'DBProc.Log.Debug.Info';
 
    if v_err_log = 'ON' then
        INSERT INTO VPX_PROC_LOG (PROC_NAME, EVENT, EVENT_DT, ERR_FLAG, DESCRIPTION)
             VALUES ('PURGE_STAT3_PROC','START', TIMEZONE('UTC',clock_timestamp()), 0, 'Start procedure');
    end if;
 
    BEGIN
       PERFORM PURGE_STAT3_PROC();
       EXCEPTION WHEN OTHERS THEN
          v_errnum := sqlstate;
          v_errmsg := SQLERRM;
          if v_err_log = 'ON' then
              INSERT INTO VPX_PROC_LOG (PROC_NAME, EVENT, EVENT_DT, ERR_FLAG, DESCRIPTION)
                VALUES ('PURGE_STAT3_PROC','ERR', TIMEZONE('UTC',clock_timestamp()), -1, SUBSTR(v_errmsg, 1, 1000));
          end if;
    END;
 
    if v_err_log = 'ON' then
        INSERT INTO VPX_PROC_LOG (PROC_NAME, EVENT, EVENT_DT, ERR_FLAG, DESCRIPTION)
             VALUES ('PURGE_STAT3_PROC','END', TIMEZONE('UTC',clock_timestamp()), 0, 'End procedure');
    end if;
 END; $procedure$
 LANGUAGE plpgsql;
 
