
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 <65052/>
 
 
 
 
 
 
 
 
 
 CREATE TABLE IF NOT EXISTS VPX_HCI_CONFIG_INFO(
    CLUSTER_ID           BIGINT          NOT NULL,
    LOCKDOWN_MODE        INTEGER         NULL,
    DATETIME_CONFIG      TEXT            NULL,
    HCI_WORKFLOW_STATE   INTEGER         NOT NULL,
    CONFIGURED_HOSTS     TEXT            NULL,
    MIN_ESX_VERSION      VARCHAR(255)    NULL,
    CONSTRAINT PK_VPX_HCI_CONFIG_INFO PRIMARY KEY (CLUSTER_ID),
    CONSTRAINT FK_VPX_HCI_CONFIG_INFO FOREIGN KEY (CLUSTER_ID)
       REFERENCES VPX_COMPUTE_RESOURCE(ID) ON DELETE CASCADE
 );
 /
 
 CREATE TABLE IF NOT EXISTS VPX_HCI_DVS_SETTINGS(
    DVS_ID               BIGINT          NOT NULL,
    PHYSICAL_NICS        TEXT            NOT NULL,
    CLUSTER_ID           BIGINT          NOT NULL,
    CONSTRAINT PK_VPX_HCI_DVS_SETTINGS PRIMARY KEY (DVS_ID),
    CONSTRAINT FK_VPX_HCI_DVS_SETTINGS FOREIGN KEY (CLUSTER_ID)
       REFERENCES VPX_HCI_CONFIG_INFO(CLUSTER_ID) ON DELETE CASCADE
 );
 /
 
 CREATE INDEX IF NOT EXISTS VPX_HCI_DVS_SETTINGS_FK ON VPX_HCI_DVS_SETTINGS(CLUSTER_ID);
 /
 
 CREATE TABLE IF NOT EXISTS VPX_HCI_NW_SETTINGS(
    DVPG_ID              BIGINT          NOT NULL,
    SERVICE_TYPE         INTEGER         NOT NULL,
    DVS_ID               BIGINT          NOT NULL,
    CONSTRAINT PK_VPX_HCI_NW_SETTINGS PRIMARY KEY (DVPG_ID, SERVICE_TYPE),
    CONSTRAINT FK_VPX_HCI_NW_SETTINGS FOREIGN KEY (DVS_ID)
       REFERENCES VPX_HCI_DVS_SETTINGS(DVS_ID) ON DELETE CASCADE
 );
 /
 
 CREATE INDEX IF NOT EXISTS VPX_HCI_NW_SETTINGS_FK ON VPX_HCI_NW_SETTINGS(DVS_ID);
 /
 
 
 
 
 
 <65053/>
 
 
 
 
 
 
 
 
 
 delete from vpx_version;
 /
 
 INSERT INTO vpx_version VALUES (664, 'VirtualCenter Database 6.6');
 /
 
 
 
 
 <65054/>
 
 
 
 
 
 
 
 
 
 
 ALTER TABLE IF EXISTS VPX_HCI_CONFIG_INFO
       ALTER COLUMN HCI_WORKFLOW_STATE TYPE VARCHAR(64);
 /
 
 ALTER TABLE IF EXISTS VPX_HCI_NW_SETTINGS
       ALTER COLUMN SERVICE_TYPE TYPE VARCHAR(64);
 /
 
 
 
 
 <65055/>
 
 
 
 
 
 
 
 
 
 
 CREATE TABLE IF NOT EXISTS VPX_TAG_ID(
    ID          BIGINT      NOT NULL,
    TAG_UUID    CHAR(36)    NOT NULL,
    CONSTRAINT PK_VPX_TAG_ID PRIMARY KEY (ID)
 )
 ;
 /
 
 CREATE SEQUENCE IF NOT EXISTS VPX_TAG_ID_SEQ INCREMENT BY 100;
 /
 
 CREATE INDEX IF NOT EXISTS VPXI_TAG_ID_TAGUUID ON VPX_TAG_ID (TAG_UUID);
 /
 
 
 
 
 
 CREATE TABLE IF NOT EXISTS VPX_ENTITY_TAG_XREF(
    ENTITY_ID   BIGINT      NOT NULL,
    TAG_ID      BIGINT      NOT NULL,
    CONSTRAINT PK_VPX_ENTITY_TAG_XREF PRIMARY KEY (ENTITY_ID, TAG_ID),
    CONSTRAINT FK_VPX_ETX_REF_VPX_ENTITY FOREIGN KEY (ENTITY_ID)
       REFERENCES VPX_ENTITY (ID) ON DELETE CASCADE,
    CONSTRAINT FK_VPX_ETX_REF_VPX_TAG_ID FOREIGN KEY (TAG_ID)
       REFERENCES VPX_TAG_ID (ID) ON DELETE CASCADE
 )
 ;
 /
 
 
 
 
 <65056/>
 
 
 
 
 
 
 
 
 
 
 ALTER TABLE IF EXISTS VPX_NON_ORM_VM_CONFIG_INFO DROP COLUMN IF EXISTS MANAGED_BY_EXT_KEY;
 ALTER TABLE IF EXISTS VPX_NON_ORM_VM_CONFIG_INFO DROP COLUMN IF EXISTS MANAGED_BY_TYPE;
 
 
 
 
 <65057/>
 
 
 
 
 
 
 
 
 create table if not exists VPX_AUTH_TENANT_INFO (
    ID            INTEGER           not null,
    NAME          VARCHAR(255)      not null,
    constraint PK_VPX_AUTH_TENANT_INFO primary key (ID)
 );
 /
 
 
 
 
 create table if not exists VPX_AUTH_TENANT_MGMT_RS (
    ENTITY_ID     BIGINT            not null,
    constraint PK_VPX_AUTH_TENANT_MGMT_RS primary key (ENTITY_ID),
    constraint FK_VPX_AUTH_TENANT_MGMT_RS_ENT foreign key (ENTITY_ID)
       references VPX_ENTITY (ID) on delete cascade
 );
 /
 
 
 
 
 create table if not exists VPX_AUTH_TENANT_DOMAINS (
    DOMAIN_ID     INTEGER           not null,
    TENANT_ID     INTEGER           not null,
    NAME          VARCHAR(255)      not null,
    ALIAS         VARCHAR(255)      null,
    constraint PK_VPX_AUTH_TENANT_DOMAINS primary key (DOMAIN_ID),
    constraint FK_VPX_AUTH_TENANT_DOMAINS_T foreign key (TENANT_ID)
       references VPX_AUTH_TENANT_INFO (ID) on delete cascade
 );
 /
 
 
 
 
 create table if not exists VPX_AUTH_TENANT_PRINCIPALS (
    PRINCIPAL_ID  INTEGER           not null,
    TENANT_ID     INTEGER           not null,
    NAME          VARCHAR(300)      not null,
    constraint PK_VPX_AUTH_TENANT_PRINCIPALS primary key (PRINCIPAL_ID),
    constraint FK_VPX_AUTH_TENANT_PRINCIP_T foreign key (TENANT_ID)
       references VPX_AUTH_TENANT_INFO (ID) on delete cascade
 );
 /
 
 
 
 
 
 <65063/>
 
 
 
 
 
 
 CREATE SEQUENCE if not exists VPX_AUTH_TENANT_SEQ           INCREMENT BY 1;
 CREATE SEQUENCE if not exists VPX_AUTH_TENANT_DOMAIN_SEQ    INCREMENT BY 1;
 CREATE SEQUENCE if not exists VPX_AUTH_TENANT_PRINCIPAL_SEQ INCREMENT BY 1;
 
 
 
 
 <65064/>
 
 
 
 
 
 DROP SEQUENCE IF EXISTS VPX_AUTH_TENANT_DOMAIN_SEQ;
 /
 
 DROP SEQUENCE IF EXISTS VPX_AUTH_TENANT_PRINCIPAL_SEQ;
 /
 
 CREATE UNIQUE INDEX IF NOT EXISTS VPX_AUTH_TENANT_INFO_U ON VPX_AUTH_TENANT_INFO(NAME);
 /
 
 ALTER TABLE VPX_AUTH_TENANT_DOMAINS DROP CONSTRAINT IF EXISTS PK_VPX_AUTH_TENANT_DOMAINS;
 /
 
 ALTER TABLE VPX_AUTH_TENANT_DOMAINS DROP COLUMN IF EXISTS DOMAIN_ID;
 /
 
 ALTER TABLE VPX_AUTH_TENANT_DOMAINS DROP COLUMN IF EXISTS ALIAS;
 /
 
 DO
 $$ BEGIN
 IF NOT EXISTS (select constraint_name
                from information_schema.table_constraints
                where table_schema='vc'
                  AND table_name = lower('VPX_AUTH_TENANT_DOMAINS')
                  and constraint_name = lower('PK_VPX_AUTH_TENANT_DOMAINS'))
 THEN
 
    ALTER TABLE VPX_AUTH_TENANT_DOMAINS ADD CONSTRAINT PK_VPX_AUTH_TENANT_DOMAINS primary key (NAME);
 
 END IF;
 END$$;
 /
 
 DROP TABLE IF EXISTS VPX_AUTH_TENANT_PRINCIPALS;
 /
 
 create table IF NOT EXISTS VPX_AUTH_TENANT_USERS (
    TENANT_ID     INTEGER           not null,
    NAME          VARCHAR(300)      not null,
    constraint PK_VPX_AUTH_TENANT_USERS primary key (NAME),
    constraint FK_VPX_AUTH_TENANT_USERS_T foreign key (TENANT_ID)
       references VPX_AUTH_TENANT_INFO (ID) on delete cascade
 );
 /
 
 
 
 
 <65065/>
 
 
 
 
 DROP VIEW IF EXISTS VPXV_VMS;
 /
 DROP VIEW IF EXISTS VPXV_TEMPLATES;
 /
 
 
 
 
 
 ALTER TABLE VPX_VM DROP COLUMN IF EXISTS VBS_ENABLED;
 ALTER TABLE VPX_VM DROP COLUMN IF EXISTS ANNOTATION;
 ALTER TABLE VPX_VM DROP COLUMN IF EXISTS TOOLS_VERSION;
 
 
 
 
 <65066/>
 
 
 
 
 
 
 
 CREATE TABLE IF NOT EXISTS VPX_PATCH_CONTENT(
     PATCH_VERSION VARCHAR(10) NOT NULL,
     PATCH_TYPE VARCHAR(5) NOT NULL);
 /
 
 INSERT INTO VPX_PATCH_CONTENT (PATCH_VERSION,PATCH_TYPE)
 SELECT a, 'FI' from (
 values
 ('65001'),
 ('65002'),
 ('65003'),
 ('65004'),
 ('65005'),
 ('65006'),
 ('65007'),
 ('65008'),
 ('65009'),
 ('65010'),
 ('65011'),
 ('65013'),
 ('65016'),
 ('65017'),
 ('65018'),
 ('65019'),
 ('65020'),
 ('65021'),
 ('65022'),
 ('65023'),
 ('65024'),
 ('65025'),
 ('65026'),
 ('65027'),
 ('65028'),
 ('65029'),
 ('65030'),
 ('65031'),
 ('65032'),
 ('65033'),
 ('65034'),
 ('65035'),
 ('65036'),
 ('65037'),
 ('65038'),
 ('65039'),
 ('65040'),
 ('65041'),
 ('65042'),
 ('65043'),
 ('65044'),
 ('65045'),
 ('65046'),
 ('65047'),
 ('65048'),
 ('65049'),
 ('65050'),
 ('65051'),
 ('65052'),
 ('65053'),
 ('65054'),
 ('65055'),
 ('65056'),
 ('65060'),
 ('65063'),
 ('65064'),
 ('65065'),
 ('65066'),
 ('65068')
 ) s(a)
 WHERE a <= (SELECT max(INITIAL_VERSION) FROM VPX_PATCH_VERSION);
 /
 
 INSERT INTO VPX_PATCH_CONTENT (PATCH_VERSION,PATCH_TYPE)
 SELECT a, 'BB' from (
 values
 ('65001'),
 ('65002'),
 ('65003'),
 ('65004'),
 ('65005'),
 ('65006'),
 ('65007'),
 ('65008'),
 ('65009'),
 ('65010'),
 ('65011'),
 ('65013'),
 ('65016'),
 ('65017'),
 ('65018'),
 ('65019'),
 ('65020'),
 ('65021'),
 ('65022'),
 ('65023'),
 ('65024'),
 ('65025'),
 ('65026'),
 ('65027'),
 ('65028'),
 ('65029'),
 ('65030'),
 ('65031'),
 ('65032'),
 ('65033'),
 ('65034'),
 ('65035'),
 ('65036'),
 ('65037'),
 ('65038'),
 ('65039'),
 ('65040'),
 ('65041'),
 ('65042'),
 ('65043'),
 ('65044'),
 ('65045'),
 ('65046'),
 ('65047'),
 ('65048'),
 ('65049'),
 ('65050'),
 ('65051'),
 ('65052'),
 ('65053'),
 ('65054'),
 ('65055'),
 ('65056'),
 ('65060'),
 ('65063'),
 ('65064'),
 ('65065'),
 ('65066'),
 ('65068')
 ) s(a)
 WHERE a > (SELECT max(INITIAL_VERSION) FROM VPX_PATCH_VERSION);
 /
 
 
 
 
 <65068/>
 
 
 
 
 
 
 
 ALTER TABLE VPX_ENTITY_TAG_XREF DROP CONSTRAINT IF EXISTS FK_VPX_ETX_REF_VPX_TAG_ID;
 /
 DROP INDEX IF EXISTS VPXI_TAG_ID_TAGUUID;
 /
 ALTER TABLE IF EXISTS VPX_TAG_ID RENAME TO VPX_TAG_DEF;
 /
 ALTER TABLE IF EXISTS VPX_TAG_DEF ADD COLUMN IF NOT EXISTS TYPE_ID INTEGER NOT NULL;
 /
 ALTER TABLE VPX_ENTITY_TAG_XREF ADD
    CONSTRAINT FK_VPX_ETX_REF_VPX_TAG_DEF FOREIGN KEY (TAG_ID)
       REFERENCES VPX_TAG_DEF (ID) ON DELETE CASCADE;
 /
 CREATE INDEX IF NOT EXISTS VPXI_TAG_DEF_TAGUUID ON VPX_TAG_DEF (TAG_UUID);
 /
 CREATE INDEX INDEX IF NOT EXISTS VPXI_TAG_DEF_TYPEID ON VPX_TAG_DEF (TYPE_ID);
 /
 ALTER SEQUENCE IF EXISTS VPX_TAG_ID_SEQ RENAME TO VPX_TAG_DEF_SEQ;
 /
 
 
 
 
 <65069/>
 
 
 
 
 
 DROP SEQUENCE IF EXISTS VPX_AUTH_TENANT_SEQ;
 /
 
 DROP TABLE IF EXISTS VPX_AUTH_TENANT_USERS;
 /
 
 DROP TABLE IF EXISTS VPX_AUTH_TENANT_DOMAINS;
 /
 
 DROP TABLE IF EXISTS VPX_AUTH_TENANT_INFO;
 /
 
 
 
 
 <65070/>
 
 
 
 
 
 
 
 
  DELETE FROM VPX_PARAMETER
  WHERE name = 'vpxd.event.features.VC_Events_Retention';
  /
 
 
 
 
 <65071/>
 
 
 
 
 
 
 
 
 
 
 
 
 delete from vpx_version WHERE VER_ID < 680;
 INSERT INTO vpx_version
 SELECT 680, 'VirtualCenter Database 6.8'
 WHERE NOT EXISTS (SELECT 1 FROM vpx_version);
 INSERT INTO VPX_PATCH_CONTENT VALUES('65072', 'BB');
 /
 
 
 
 
 <65072/>
 
 
 
 
 
 
 
 
 
 DROP INDEX IF EXISTS VPXI_TAG_DEF_TAGUUID;
 DROP INDEX IF EXISTS VPXI_TAG_DEF_TYPEID;
 CREATE UNIQUE INDEX IF NOT EXISTS VPXI_TAG_DEF_UUID_TYPE ON VPX_TAG_DEF (TAG_UUID, TYPE_ID);
 INSERT INTO VPX_PATCH_CONTENT VALUES('65073', 'BB');
 /
 
 
 
 
 <65073/>
 
 
 
 
 
 
 
 
 
 
 ALTER TABLE IF EXISTS VPX_VM ADD IF NOT EXISTS HARDWARE_VERSION VARCHAR(20) null;
 INSERT INTO VPX_PATCH_CONTENT VALUES('65075', 'BB');
 /
 
 
 
 
 <65075/>
 
 
 
 
 
 
 
 
 
 
 ALTER TABLE IF EXISTS VPX_NON_ORM_VM_CONFIG_INFO ADD IF NOT EXISTS CONTENT_LIB_ITEM_ID VARCHAR(255) null;
 INSERT INTO VPX_PATCH_CONTENT VALUES('65076', 'BB');
 /
 
 
 
 
 <65076/>
 
 
 
 
 
 
 
 
 
 
 ALTER TABLE IF EXISTS VPX_NON_ORM_VM_CONFIG_INFO ADD IF NOT EXISTS HARDWARE_CORES_AUTO NUMERIC(1) default 0;
 UPDATE VPX_NON_ORM_VM_CONFIG_INFO
  SET HARDWARE_CORES_AUTO = 0;
 INSERT INTO VPX_PATCH_CONTENT VALUES('65077', 'BB');
 /
 
 
 
 
 <65077/>
 
 
 
 
 
 
 
 
 
 delete from vpx_version;
 INSERT INTO vpx_version VALUES (681, 'VirtualCenter Database 6.8');
 INSERT INTO VPX_PATCH_CONTENT VALUES('65078', 'BB');
 /
 
 
 
 
 <65078/>
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 DO $$
 
 BEGIN
 IF NOT EXISTS(
    SELECT 1 FROM information_schema.columns
    WHERE  UPPER(TABLE_NAME) = 'VPX_HCI_NW_SETTINGS'
       AND UPPER(COLUMN_NAME) = 'CLUSTER_ID')
 
 THEN
 
 ALTER TABLE IF EXISTS VPX_HCI_NW_SETTINGS DROP CONSTRAINT IF EXISTS PK_VPX_HCI_NW_SETTINGS;
 ALTER TABLE IF EXISTS VPX_HCI_NW_SETTINGS ADD COLUMN IF NOT EXISTS CLUSTER_ID BIGINT NULL;
 
 UPDATE VPX_HCI_NW_SETTINGS
 SET CLUSTER_ID = (SELECT CLUSTER_ID FROM VPX_HCI_DVS_SETTINGS WHERE VPX_HCI_NW_SETTINGS.DVS_ID = VPX_HCI_DVS_SETTINGS.DVS_ID);
 
 ALTER TABLE IF EXISTS VPX_HCI_NW_SETTINGS ALTER COLUMN CLUSTER_ID SET NOT NULL;
 
 DO
 $$ BEGIN
 IF NOT EXISTS (select constraint_name
                from information_schema.table_constraints
                where table_schema='vc'
                  AND table_name = lower('VPX_HCI_NW_SETTINGS')
                  AND constraint_name = lower('PK_VPX_HCI_NW_SETTINGS'))
 THEN
 
    ALTER TABLE IF EXISTS VPX_HCI_NW_SETTINGS ADD CONSTRAINT PK_VPX_HCI_NW_SETTINGS PRIMARY KEY (DVPG_ID, SERVICE_TYPE, CLUSTER_ID);
 
 END IF;
 END$$;
 
 ALTER TABLE IF EXISTS VPX_HCI_NW_SETTINGS DROP CONSTRAINT IF EXISTS FK_VPX_HCI_NW_SETTINGS;
 
 ALTER TABLE IF EXISTS VPX_HCI_DVS_SETTINGS DROP CONSTRAINT IF EXISTS PK_VPX_HCI_DVS_SETTINGS;
 
 DO
 $$ BEGIN
 IF NOT EXISTS (select constraint_name
                from information_schema.table_constraints
                where table_schema='vc'
                  AND table_name = lower('VPX_HCI_DVS_SETTINGS')
                  AND constraint_name = lower('PK_VPX_HCI_DVS_SETTINGS'))
 THEN
 
    ALTER TABLE IF EXISTS VPX_HCI_DVS_SETTINGS ADD CONSTRAINT PK_VPX_HCI_DVS_SETTINGS PRIMARY KEY (DVS_ID, CLUSTER_ID);
 
 END IF;
 END$$;
 
 DO
 $$ BEGIN
 IF NOT EXISTS (select constraint_name
                from information_schema.table_constraints
                where table_schema='vc'
                  AND table_name = lower('VPX_HCI_NW_SETTINGS')
                  AND constraint_name = lower('FK_VPX_HCI_NW_SETTINGS'))
 THEN
 
    ALTER TABLE IF EXISTS VPX_HCI_NW_SETTINGS ADD CONSTRAINT FK_VPX_HCI_NW_SETTINGS FOREIGN KEY (DVS_ID, CLUSTER_ID) REFERENCES VPX_HCI_DVS_SETTINGS(DVS_ID, CLUSTER_ID) ON DELETE CASCADE;
 
 END IF;
 END$$;
 
 DROP INDEX IF EXISTS VPX_HCI_NW_SETTINGS_FK;
 
 CREATE INDEX IF NOT EXISTS VPX_HCI_NW_SETTINGS_DC_IDX ON VPX_HCI_NW_SETTINGS(DVS_ID, CLUSTER_ID);
 
 END IF;
 END$$;
 INSERT INTO VPX_PATCH_CONTENT VALUES('65079', 'BB');
 /
 
 
 
 
 
 <65079/>
 
 
 
 
 
 
 
 
 
 delete from vpx_version;
 INSERT INTO vpx_version VALUES (682, 'VirtualCenter Database 6.8');
 INSERT INTO VPX_PATCH_CONTENT VALUES('65080', 'BB');
 /
 
 
 
 
 <65080/>
 
 
 
 
 
 
 
 
 
 
 ALTER TABLE IF EXISTS VPX_VM_VIRTUAL_DEVICE
       ALTER COLUMN DEVICE_INFO_SUMMARY TYPE VARCHAR(512);
 ALTER TABLE IF EXISTS VPX_VM_SN_VIRTUAL_DEVICE
       ALTER COLUMN DEVICE_INFO_SUMMARY TYPE VARCHAR(512);
 INSERT INTO VPX_PATCH_CONTENT VALUES('65081', 'BB');
 /
 
 
 
 
 
 <65081/>
 
 
 
 
 
 
 
 
 
 
 ALTER INDEX IF EXISTS VPX_HCI_DVS_SETTINGS_FK RENAME TO VPX_HCI_DVS_SETTINGS_CID_IDX;
 INSERT INTO VPX_PATCH_CONTENT VALUES('65082', 'BB');
 /
 
 
 
 
 <65082/>
 
 
 
 
 
 
 
 
 
 
 ALTER TABLE IF EXISTS VPX_NON_ORM_VM_CONFIG_INFO ADD IF NOT EXISTS FT_ENCRYPTION_MODE VARCHAR(30);
 INSERT INTO VPX_PATCH_CONTENT VALUES('65083', 'BB');
 /
 
 
 
 
 <65083/>
 
 
 
 
 
 
 
 
 
 
 ALTER TABLE IF EXISTS VPX_NON_ORM_VM_CONFIG_INFO ADD IF NOT EXISTS CONTENT_LIB_ITEM_VERSION VARCHAR(255) null;
 INSERT INTO VPX_PATCH_CONTENT VALUES('65084', 'BB');
 /
 
 
 
 
 <65084/>
 
 
 
 
 
 
 
 
 
 CREATE TABLE IF NOT EXISTS VPX_HOST_SGXINFO (
    HOST_ID               BIGINT                        NOT NULL,
    SGX_EPC_MEMORY_BYTES  BIGINT                            NULL,
    SGX_FLC_MODE          VARCHAR(16)                       NULL,
    SGX_LE_PUB_KEY_HASH   VARCHAR(64)                       NULL,
    CONSTRAINT PK_VPX_HOST_SGXINFO PRIMARY KEY (HOST_ID),
    CONSTRAINT FK_VPX_HOST_SGXINFO FOREIGN KEY (HOST_ID)
       REFERENCES VPX_HOST (ID) ON DELETE CASCADE
 );
 INSERT INTO VPX_PATCH_CONTENT VALUES('65085', 'BB');
 /
 
 
 
 
 <65085/>
 
 
 
 
 
 
 
 
 
 CREATE TABLE IF NOT EXISTS VPX_VM_SGXINFO (
         ID                              BIGINT NOT NULL,
         VM_ID                           BIGINT NOT NULL,
         SGX_EPC_MEMORY_MB               BIGINT NULL,
         SGX_FLC_MODE                    VARCHAR(16) NULL,
         SGX_LE_PUB_KEY_HASH             VARCHAR(64) NULL,
         CONSTRAINT PK_VPX_VM_SGXINFO PRIMARY KEY (ID),
         CONSTRAINT FK_VPX_VM_SGXINFO FOREIGN KEY (VM_ID)
             REFERENCES VPX_VM (ID) ON DELETE CASCADE
 );
 INSERT INTO VPX_PATCH_CONTENT VALUES('65086', 'BB');
 /
 
 
 
 
 <65086/>
 
 
 
 
 
 
 
 
 
 
 ALTER TABLE IF EXISTS VPX_EXT ADD IF NOT EXISTS IS_RESTRICTED_USER NUMERIC(1) default 0 NOT NULL;
 INSERT INTO VPX_PATCH_CONTENT VALUES('65087', 'BB');
 /
 
 
 
 
 <65087/>
 
 
 
 
 
 
 
 
 
 
 
 
 ALTER TABLE IF EXISTS VPX_CRYPTO_KMIP_CLUSTER DROP CONSTRAINT IF EXISTS PK_VPX_CRYPTO_KMIP_CLUSTER CASCADE;
 ALTER TABLE IF EXISTS VPX_CRYPTO_KMIP_CLUSTER ADD IF NOT EXISTS CLUSTER_TYPE INTEGER DEFAULT 0 NOT NULL;
 DO
 $$ BEGIN
 IF NOT EXISTS (select constraint_name
                from information_schema.table_constraints
                where table_schema='vc'
                  AND table_name = lower('VPX_CRYPTO_KMIP_CLUSTER')
                  AND constraint_name = lower('PK_VPX_CRYPTO_KMIP_CLUSTER'))
 THEN
 
    ALTER TABLE IF EXISTS VPX_CRYPTO_KMIP_CLUSTER ADD CONSTRAINT PK_VPX_CRYPTO_KMIP_CLUSTER PRIMARY KEY (CLUSTER_ID, CLUSTER_TYPE);
 
 
 END IF;
 END$$;
 ALTER TABLE IF EXISTS VPX_CRYPTO_SERVER DROP CONSTRAINT IF EXISTS FK_VPX_CRYPTO_KMIP_CLUSTER CASCADE;
 ALTER TABLE IF EXISTS VPX_CRYPTO_SERVER DROP CONSTRAINT IF EXISTS PK_VPX_CRYPTO_SERVER CASCADE;
 ALTER TABLE IF EXISTS VPX_CRYPTO_SERVER ADD IF NOT EXISTS CLUSTER_TYPE INTEGER DEFAULT 0 NOT NULL;
 DO
 $$ BEGIN
 IF NOT EXISTS (select constraint_name
                from information_schema.table_constraints
                where table_schema='vc'
                  AND table_name = lower('VPX_CRYPTO_SERVER')
                  AND constraint_name = lower('PK_VPX_CRYPTO_SERVER'))
 THEN
 
    ALTER TABLE IF EXISTS VPX_CRYPTO_SERVER ADD CONSTRAINT PK_VPX_CRYPTO_SERVER PRIMARY KEY (CLUSTER_ID, CLUSTER_TYPE, NAME);
 
 END IF;
 END$$;
 DO
 $$ BEGIN
 IF NOT EXISTS (select constraint_name
                from information_schema.table_constraints
                where table_schema='vc'
                  AND table_name = lower('VPX_CRYPTO_SERVER')
                  AND constraint_name = lower('FK_VPX_CRYPTO_KMIP_CLUSTER'))
 THEN
 
    ALTER TABLE IF EXISTS VPX_CRYPTO_SERVER ADD CONSTRAINT FK_VPX_CRYPTO_KMIP_CLUSTER FOREIGN KEY (CLUSTER_ID, CLUSTER_TYPE) REFERENCES VPX_CRYPTO_KMIP_CLUSTER(CLUSTER_ID, CLUSTER_TYPE);
 
 
 END IF;
 END$$;
 ALTER TABLE IF EXISTS VPX_CRYPTO_SERVER ADD IF NOT EXISTS CLUSTER_TYPE INTEGER DEFAULT 0 NOT NULL;
 CREATE TABLE IF NOT EXISTS VPX_CRYPTO_DEFAULT_KMS_CLUSTER(
    ENTITY_ID                  BIGINT             NOT NULL,
    CLUSTER_ID                 VARCHAR(255)       NOT NULL,
    CLUSTER_TYPE               INTEGER  DEFAULT 0 NOT NULL,
    CONSTRAINT PK_VPX_CRYPTO_DEFAULT_KMS_CLUSTER PRIMARY KEY (ENTITY_ID),
    CONSTRAINT FK_VPX_CRYPTO_DEFAULT_KMS_ENTITY FOREIGN KEY (ENTITY_ID)
       REFERENCES VPX_ENTITY (ID) ON DELETE CASCADE,
    CONSTRAINT FK_VPX_CRYPTO_DEFAULT_KMS_CLUSTER FOREIGN KEY (CLUSTER_ID, CLUSTER_TYPE)
       REFERENCES VPX_CRYPTO_KMIP_CLUSTER (CLUSTER_ID, CLUSTER_TYPE) ON DELETE CASCADE
 );
 INSERT INTO VPX_PATCH_CONTENT VALUES('65088', 'BB');
 /
 
 
 
 
 <65088/>
 
 
 
 
 
 
 
 
 
 delete from vpx_version;
 INSERT INTO vpx_version VALUES (683, 'VirtualCenter Database 6.8');
 INSERT INTO VPX_PATCH_CONTENT VALUES('65089', 'BB');
 /
 
 
 
 
 <65089/>
 
 
 
 
 
 
 
 
 delete from vpx_version;
 INSERT INTO vpx_version VALUES (684, 'VirtualCenter Database 6.8');
 INSERT INTO VPX_PATCH_CONTENT VALUES('65093', 'BB');
 /
 
 
 
 
 <65093/>
 
 
 
 
 
 
 
 
 
 
 ALTER TABLE IF EXISTS VPX_COMPUTE_RESOURCE ADD IF NOT EXISTS CRYPTO_MODE INTEGER NULL;
 INSERT INTO VPX_PATCH_CONTENT VALUES('65094', 'BB');
 /
 
 
 
 
 <65094/>
 
 
 
 
 
 
 
 
 
 ALTER TABLE IF EXISTS VPX_COMPUTE_RESOURCE ADD IF NOT EXISTS TRUSTED_CLUSTER_STATE INTEGER DEFAULT 0 NOT NULL;
 INSERT INTO VPX_PATCH_CONTENT VALUES('65095', 'BB');
 /
 
 
 
 
 <65095/>
 
 
 
 
 
 
 
 
 
 
 ALTER TABLE IF EXISTS VPX_CRYPTO_KMIP_CLUSTER DROP CONSTRAINT IF EXISTS PK_VPX_CRYPTO_KMIP_CLUSTER CASCADE;
 DO
 $$ BEGIN
 IF NOT EXISTS (select constraint_name
                from information_schema.table_constraints
                where table_schema='vc'
                  AND table_name = lower('VPX_CRYPTO_KMIP_CLUSTER')
                  AND constraint_name = lower('PK_VPX_CRYPTO_KMIP_CLUSTER'))
 THEN
 
    ALTER TABLE IF EXISTS VPX_CRYPTO_KMIP_CLUSTER ADD CONSTRAINT PK_VPX_CRYPTO_KMIP_CLUSTER PRIMARY KEY (CLUSTER_ID);
 
 END IF;
 END$$;
 ALTER TABLE IF EXISTS VPX_CRYPTO_SERVER DROP CONSTRAINT IF EXISTS FK_VPX_CRYPTO_KMIP_CLUSTER CASCADE;
 ALTER TABLE IF EXISTS VPX_CRYPTO_SERVER DROP CONSTRAINT IF EXISTS PK_VPX_CRYPTO_SERVER CASCADE;
 DO
 $$ BEGIN
 IF NOT EXISTS (select constraint_name
                from information_schema.table_constraints
                where table_schema='vc'
                  AND table_name = lower('VPX_CRYPTO_SERVER')
                  AND constraint_name = lower('PK_VPX_CRYPTO_SERVER'))
 THEN
 
    ALTER TABLE IF EXISTS VPX_CRYPTO_SERVER ADD CONSTRAINT PK_VPX_CRYPTO_SERVER PRIMARY KEY (CLUSTER_ID, NAME);
 
 END IF;
 END$$;
 DO
 $$ BEGIN
 IF NOT EXISTS (select constraint_name
                from information_schema.table_constraints
                where table_schema='vc'
                  AND table_name = lower('VPX_CRYPTO_SERVER')
                  AND constraint_name = lower('FK_VPX_CRYPTO_KMIP_CLUSTER'))
 THEN
 
    ALTER TABLE IF EXISTS VPX_CRYPTO_SERVER ADD CONSTRAINT FK_VPX_CRYPTO_KMIP_CLUSTER FOREIGN KEY (CLUSTER_ID) REFERENCES VPX_CRYPTO_KMIP_CLUSTER(CLUSTER_ID);
 
 END IF;
 END$$;
 ALTER TABLE IF EXISTS VPX_CRYPTO_DEFAULT_KMS_CLUSTER DROP CONSTRAINT IF EXISTS FK_VPX_CRYPTO_DEFAULT_KMS_CLUSTER CASCADE;
 DO
 $$ BEGIN
 IF NOT EXISTS (select constraint_name
                from information_schema.table_constraints
                where table_schema='vc'
                  AND table_name = lower('VPX_CRYPTO_DEFAULT_KMS_CLUSTER')
                  AND constraint_name = lower('FK_VPX_CRYPTO_DEFAULT_KMS_CLUSTER'))
 THEN
 
    ALTER TABLE IF EXISTS VPX_CRYPTO_DEFAULT_KMS_CLUSTER ADD CONSTRAINT FK_VPX_CRYPTO_DEFAULT_KMS_CLUSTER FOREIGN KEY (CLUSTER_ID) REFERENCES VPX_CRYPTO_KMIP_CLUSTER(CLUSTER_ID) ON DELETE CASCADE;
 
 END IF;
 END$$;
 INSERT INTO VPX_PATCH_CONTENT VALUES('65097', 'BB');
 /
 
 
 
 
 <65097/>
 
 
 
 
 
 
 
 
 
 ALTER TABLE IF EXISTS VPX_HOST_CRYPTO_KEYS DROP CONSTRAINT IF EXISTS PK_VPX_HOST_CRYPTO_KEYS CASCADE;
 DO
 $$ BEGIN
 IF NOT EXISTS (select constraint_name
                from information_schema.table_constraints
                where table_schema='vc'
                  AND table_name = lower('VPX_HOST_CRYPTO_KEYS')
                  AND constraint_name = lower('FK_VPX_HOST_CRYPTO_KEYS_REF'))
 THEN
 
    ALTER TABLE IF EXISTS VPX_HOST_CRYPTO_KEYS RENAME CONSTRAINT PK_VPX_HOST_CRYPTO_KEYS_REF TO FK_VPX_HOST_CRYPTO_KEYS_REF;
 
 END IF;
 END$$;
 ALTER TABLE IF EXISTS VPX_HOST_CRYPTO_KEYS ADD COLUMN IF NOT EXISTS KEY_ID SERIAL CONSTRAINT PK_VPX_HOST_CRYPTO_KEYS PRIMARY KEY;
 CREATE UNIQUE INDEX IF NOT EXISTS VPX_HOST_CRYPTO_KEYS_UNIQUE_KEY on VPX_HOST_CRYPTO_KEYS (
    HOST_ID,
    CRYPTO_KEY_ID,
    CRYPTO_KEY_PROVIDER_ID
 );
 create table IF NOT EXISTS VPX_HOST_CRYPTO_TAG_KEYS (
    KEY_ID                                       SERIAL,
    CRYPTO_TAG                 VARCHAR(255)      not null,
    CONSTRAINT PK_VPX_HOST_CRYPTO_TAG_KEYS PRIMARY key (KEY_ID, CRYPTO_TAG),
    CONSTRAINT FK_VPX_HOST_CRYPTO_TAG_KEYS_REF FOREIGN KEY (KEY_ID)
       REFERENCES VPX_HOST_CRYPTO_KEYS (KEY_ID)
          ON DELETE CASCADE
 );
 INSERT INTO VPX_PATCH_CONTENT VALUES('65099', 'BB');
 /
 
 
 
 
 <65099/>
 
 
 
 
 
 ALTER TABLE IF EXISTS VPX_DVPORT_SETTING ADD IF NOT EXISTS VNI INTEGER NULL;
 ALTER TABLE IF EXISTS VPX_DVPORTGROUP    ADD IF NOT EXISTS TRANSPORTZONE_UUID VARCHAR(128);
 ALTER TABLE IF EXISTS VPX_DVPORTGROUP    ADD IF NOT EXISTS LOGICALSWITCH_UUID VARCHAR(128);
 INSERT INTO VPX_PATCH_CONTENT VALUES('65101', 'BB');
 /
 
 
 
 <65101/>
 
 
 
 
 
 
 
 
 
 ALTER TABLE IF EXISTS VPX_RESOURCE_POOL ADD IF NOT EXISTS NAMESPACE_ID VARCHAR(255) NULL;
 CREATE TABLE IF NOT EXISTS VPX_FOLDER_NAMESPACE  (
    ID                   BIGINT                          NOT NULL,
    NAMESPACE_ID         VARCHAR(255)                    NOT NULL,
    CONSTRAINT PK_VPX_FOLDER_NAMESPACE PRIMARY KEY (ID),
    CONSTRAINT FK_VPX_FOLDER_NAMESPACE FOREIGN KEY (ID)
          REFERENCES VPX_ENTITY (ID)
          ON DELETE CASCADE
 );
 INSERT INTO VPX_PATCH_CONTENT VALUES('65102', 'BB');
 /
 
 
 
 
 <65102/>
 
 
 
 
 
 
 
 
 
 CREATE TABLE IF NOT EXISTS VPX_KMXD_SERVICES(
    ID                         VARCHAR(255)      NOT NULL,
    HOSTNAME                   VARCHAR(255)      NOT NULL,
    PORT                       INTEGER           NOT NULL,
    CERT                       TEXT              NOT NULL,
    GROUP_ID                   VARCHAR(255)      NOT NULL,
    CONSTRAINT PK_VPX_KMXD_SERVICES PRIMARY KEY (ID),
    CONSTRAINT KMXD_UNIQUE_HOSTNAME_PORT UNIQUE (HOSTNAME, PORT)
 );
 
 
 
 
 
 CREATE TABLE IF NOT EXISTS VPX_ATTESTD_SERVICES(
    ID                         VARCHAR(255)      NOT NULL,
    HOSTNAME                   VARCHAR(255)      NOT NULL,
    PORT                       INTEGER           NOT NULL,
    CERT                       TEXT              NOT NULL,
    GROUP_ID                   VARCHAR(255)      NOT NULL,
    CONSTRAINT PK_VPX_ATTESTD_SERVICES PRIMARY KEY (ID),
    CONSTRAINT ATTESTD_UNIQUE_HOSTNAME_PORT UNIQUE (HOSTNAME, PORT)
 );
 INSERT INTO VPX_PATCH_CONTENT VALUES('65103', 'BB');
 /
 
 
 
 
 <65103/>
 
 
 
 
 
 ALTER TABLE IF EXISTS VPX_DVPORT ADD IF NOT EXISTS EXTERNAL_ID VARCHAR(48);
 INSERT INTO VPX_PATCH_CONTENT VALUES('65104', 'BB');
 /
 
 
 
 <65104/>
 
 
 
 
 
 
 
 
 delete from vpx_version;
 INSERT INTO vpx_version VALUES (685, 'VirtualCenter Database 6.8');
 INSERT INTO VPX_PATCH_CONTENT VALUES('65105', 'BB');
 /
 
 
 
 
 <65105/>
 
 
 
 
 
 ALTER TABLE IF EXISTS VPX_DVHOST ADD IF NOT EXISTS NSXT_ENABLED NUMERIC(1) CHECK (NSXT_ENABLED IN (0, 1));
 ALTER TABLE IF EXISTS VPX_DVHOST ADD IF NOT EXISTS ENS_ENABLED NUMERIC(1) CHECK (ENS_ENABLED IN (0, 1));
 ALTER TABLE IF EXISTS VPX_DVHOST ADD IF NOT EXISTS TRANSPORT_ZONE_ID_ARRAY TEXT;
 INSERT INTO VPX_PATCH_CONTENT VALUES('65107', 'BB');
 /
 
 
 
 
 <65107/>
 
 
 
 
 
 
 
 
 delete from vpx_version;
 INSERT INTO vpx_version VALUES (686, 'VirtualCenter Database 6.8');
 INSERT INTO VPX_PATCH_CONTENT VALUES('65108', 'BB');
 /
 
 
 
 
 <65108/>
 
 
 
 
 
 
 
 
 ALTER TABLE IF EXISTS VPX_DVPORTGROUP ADD IF NOT EXISTS BACKING_TYPE VARCHAR(255) default 'standard' NOT NULL;
 INSERT INTO VPX_PATCH_CONTENT VALUES('65109', 'BB');
 /
 
 
 
 
 <65109/>
 
 
 
 
 
 
 
 
 ALTER TABLE IF EXISTS VPX_ALARM_STATE ADD IF NOT EXISTS DISABLED NUMERIC(1) DEFAULT 0 NOT NULL;
 INSERT INTO VPX_PATCH_CONTENT VALUES('65110', 'BB');
 /
 
 
 
 <65110/>
 
 
 
 
 
 
 
 
 delete from vpx_version;
 INSERT INTO vpx_version VALUES (687, 'VirtualCenter Database 6.8');
 INSERT INTO VPX_PATCH_CONTENT VALUES('65111', 'BB');
 /
 
 
 
 
 <65111/>
 
 
 
 
 
 
 
 
 ALTER INDEX IF EXISTS VPX_HOST_CRYPTO_KEYS_UNIQUE_KEY RENAME TO VPX_HOST_CRYPTO_KEYS_UN_KEY;
 INSERT INTO VPX_PATCH_CONTENT VALUES('65113', 'BB');
 /
 
 
 
 <65113/>
 
 
 
 
 
 ALTER TABLE IF EXISTS VPX_DVHOST ADD IF NOT EXISTS NSXT_USED_UPLINK_NAME_ARRAY TEXT;
 INSERT INTO VPX_PATCH_CONTENT VALUES('65115', 'BB');
 /
 
 
 
 <65115/>
 
 
 
 
 
 
 
 
 ALTER TABLE IF EXISTS VPX_ATTESTD_SERVICES ADD IF NOT EXISTS TRUSTED_CLS_ID VARCHAR(255) DEFAULT '' NOT NULL;
 ALTER TABLE IF EXISTS VPX_ATTESTD_SERVICES RENAME COLUMN ID TO UUID;
 ALTER TABLE IF EXISTS VPX_ATTESTD_SERVICES ALTER COLUMN UUID TYPE VARCHAR(64);
 ALTER TABLE IF EXISTS VPX_ATTESTD_SERVICES ADD IF NOT EXISTS ID SERIAL;
 ALTER TABLE IF EXISTS VPX_ATTESTD_SERVICES DROP CONSTRAINT IF EXISTS PK_VPX_ATTESTD_SERVICES;
 DO
 $$ BEGIN
 IF NOT EXISTS (select constraint_name
                from information_schema.table_constraints
                where table_schema='vc'
                  AND table_name = lower('VPX_ATTESTD_SERVICES')
                  AND constraint_name = lower('PK_VPX_ATTESTD_SERVICES'))
 THEN
 
    ALTER TABLE IF EXISTS VPX_ATTESTD_SERVICES ADD CONSTRAINT PK_VPX_ATTESTD_SERVICES PRIMARY KEY (ID);
 
 END IF;
 END$$;
 DO
 $$ BEGIN
 IF NOT EXISTS (select constraint_name
                from information_schema.table_constraints
                where table_schema='vc'
                  AND table_name = lower('VPX_ATTESTD_SERVICES')
                  AND constraint_name = lower('ATTESTD_UNIQUE_UUID'))
 THEN
 
    ALTER TABLE IF EXISTS VPX_ATTESTD_SERVICES ADD CONSTRAINT ATTESTD_UNIQUE_UUID UNIQUE (UUID);
 
 END IF;
 END$$;
 ALTER TABLE IF EXISTS VPX_KMXD_SERVICES ADD IF NOT EXISTS TRUSTED_CLS_ID VARCHAR(255) DEFAULT '' NOT NULL;
 ALTER TABLE IF EXISTS VPX_KMXD_SERVICES RENAME COLUMN ID TO UUID;
 ALTER TABLE IF EXISTS VPX_KMXD_SERVICES ALTER COLUMN UUID TYPE VARCHAR(64);
 ALTER TABLE IF EXISTS VPX_KMXD_SERVICES ADD IF NOT EXISTS ID SERIAL;
 ALTER TABLE IF EXISTS VPX_KMXD_SERVICES DROP CONSTRAINT IF EXISTS PK_VPX_KMXD_SERVICES;
 DO
 $$ BEGIN
 IF NOT EXISTS (select constraint_name
                from information_schema.table_constraints
                where table_schema='vc'
                  AND table_name = lower('VPX_KMXD_SERVICES')
                  AND constraint_name = lower('PK_VPX_KMXD_SERVICES'))
 THEN
 
    ALTER TABLE IF EXISTS VPX_KMXD_SERVICES ADD CONSTRAINT PK_VPX_KMXD_SERVICES PRIMARY KEY (ID);
 
 END IF;
 END$$;
 DO
 $$ BEGIN
 IF NOT EXISTS (select constraint_name
                from information_schema.table_constraints
                where table_schema='vc'
                  AND table_name = lower('VPX_KMXD_SERVICES')
                  AND constraint_name = lower('KMXD_UNIQUE_UUID'))
 THEN
 
    ALTER TABLE IF EXISTS VPX_KMXD_SERVICES ADD CONSTRAINT KMXD_UNIQUE_UUID UNIQUE (UUID);
 END IF;
 END$$;
 INSERT INTO VPX_PATCH_CONTENT VALUES('65116', 'BB');
 /
 
 
 
 <65116/>
 
 
 
 
 
 
 
 
 
 CREATE TABLE IF NOT EXISTS VPX_CLUSTER_KMXD_SERVICES(
    CLUSTER_ID                         BIGINT            NOT NULL,
    SERVICE_ID                         INT               NOT NULL,
    CONSTRAINT PK_VPX_CLUSTER_KMXD_SERVICES PRIMARY KEY (CLUSTER_ID, SERVICE_ID),
    CONSTRAINT FK_VPX_CLUSTER_KMXD_SERVICES_CLUSTER_ID FOREIGN KEY (CLUSTER_ID)
       REFERENCES VPX_COMPUTE_RESOURCE (ID) ON DELETE CASCADE,
    CONSTRAINT FK_VPX_CLUSTER_KMXD_SERVICES_SERVICE_ID FOREIGN KEY (SERVICE_ID)
       REFERENCES VPX_KMXD_SERVICES (ID)
 );
 
 
 
 
 
 CREATE TABLE IF NOT EXISTS VPX_CLUSTER_ATTESTD_SERVICES(
    CLUSTER_ID                         BIGINT            NOT NULL,
    SERVICE_ID                         INT               NOT NULL,
    CONSTRAINT PK_VPX_CLUSTER_ATTESTD_SERVICES PRIMARY KEY (CLUSTER_ID, SERVICE_ID),
    CONSTRAINT FK_VPX_CLUSTER_ATTESTD_SERVICES_CLUSTER_ID FOREIGN KEY (CLUSTER_ID)
       REFERENCES VPX_COMPUTE_RESOURCE (ID) ON DELETE CASCADE,
    CONSTRAINT FK_VPX_CLUSTER_ATTESTD_SERVICES_SERVICE_ID FOREIGN KEY (SERVICE_ID)
       REFERENCES VPX_ATTESTD_SERVICES (ID)
 );
 
 INSERT INTO VPX_PATCH_CONTENT VALUES('65117', 'BB');
 /
 
 
 
 
 <65117/>
 
 
 
 
 DROP TABLE IF EXISTS VPX_HOST_CRYPTO_TAG_KEYS;
 CREATE TABLE IF NOT EXISTS VPX_CRYPTO_TAG (
    CRYPTO_TAG_ID              INTEGER           NOT NULL,
    CRYPTO_TAG                 VARCHAR(255)      NOT NULL,
    CONSTRAINT PK_VPX_CRYPTO_TAG PRIMARY key (CRYPTO_TAG_ID)
 );
 CREATE SEQUENCE IF NOT EXISTS VPX_CRYPTO_TAG_SEQ INCREMENT BY 10;
 CREATE TABLE IF NOT EXISTS VPX_HOST_CRYPTO_TAG_KEYS (
    KEY_ID                     INTEGER           NOT NULL,
    CRYPTO_TAG_ID              INTEGER           NOT NULL,
    CONSTRAINT PK_VPX_HOST_CRYPTO_TAG_KEYS PRIMARY key (KEY_ID, CRYPTO_TAG_ID),
    CONSTRAINT FK_VPX_HOST_CRYPTO_TAG_KEYS FOREIGN KEY (KEY_ID)
       REFERENCES VPX_HOST_CRYPTO_KEYS (KEY_ID)
          ON DELETE CASCADE,
    CONSTRAINT FK_VPX_HOST_CTK_CRYPTO_TAG_REF FOREIGN KEY (CRYPTO_TAG_ID)
       REFERENCES VPX_CRYPTO_TAG (CRYPTO_TAG_ID)
          ON DELETE CASCADE
 );
 INSERT INTO VPX_PATCH_CONTENT VALUES('65118', 'BB');
 /
 
 
 
 <65118/>
 
 
 
 
 
 
 
 
 
 ALTER TABLE IF EXISTS VPX_NON_ORM_VM_CONFIG_INFO DROP COLUMN IF EXISTS VFLASH_CACHE_RESERVATION;
 
 INSERT INTO VPX_PATCH_CONTENT VALUES('65119', 'BB');
 /
 
 
 
 
 <65119/>
 
 
 
 
 
 
 
 
 delete from vpx_version;
 INSERT INTO vpx_version VALUES (688, 'VirtualCenter Database 6.8');
 INSERT INTO VPX_PATCH_CONTENT VALUES('65120', 'BB');
 /
 
 
 
 
 <65120/>
 
 
 
 
 
 
 
 
 
 ALTER TABLE IF EXISTS VPX_COMPUTE_RESOURCE ADD IF NOT EXISTS LIFECYCLE_MANAGED NUMERIC(1) DEFAULT 0 NOT NULL;
 INSERT INTO VPX_PATCH_CONTENT VALUES('65121', 'BB');
 /
 
 
 
 
 <65121/>
 
 
 
 
 
 
 
 
 
 
 
 create table IF NOT EXISTS VPX_CLUSTER_DATASTORE_CONF (
    CLUSTER_ID       BIGINT not null,
    DATASTORE_SPECS  TEXT,
    VERSION          BIGINT,
    CAN_CHANGE_CONFIG       BOOLEAN,
    CONSTRAINT PK_VPX_CLUS_DDC PRIMARY KEY (CLUSTER_ID),
    CONSTRAINT FK_VPX_CLUS_DDC  FOREIGN KEY (CLUSTER_ID)
          REFERENCES VPX_COMPUTE_RESOURCE (ID)
          ON DELETE CASCADE
 );
 
 
 INSERT INTO VPX_PATCH_CONTENT VALUES('65122', 'BB');
 /
 
 
 
 
 
 <65122/>
 
 
 
 
 
 
 
 
 ALTER TABLE IF EXISTS VPX_DVPORTGROUP ADD IF NOT EXISTS TRANSPORTZONE_NAME VARCHAR(256);
 ALTER TABLE IF EXISTS VPX_DVPORTGROUP ADD IF NOT EXISTS SEGMENT_ID VARCHAR(256);
 INSERT INTO VPX_PATCH_CONTENT VALUES('65123', 'BB');
 /
 
 
 
 
 <65123/>
 
 
 
 
 
 
 
 
 ALTER SEQUENCE IF EXISTS VPX_DEVICE_SEQ INCREMENT BY 1000;
 ALTER SEQUENCE IF EXISTS VPX_STAT_COUNTER_SEQ INCREMENT BY 1000;
 ALTER SEQUENCE IF EXISTS VPX_ENTITY_SEQ INCREMENT BY 1000;
 ALTER SEQUENCE IF EXISTS VPX_EVENT_SEQ INCREMENT BY 1000;
 ALTER SEQUENCE IF EXISTS VPX_TASK_SEQ INCREMENT BY 1000;
 ALTER SEQUENCE IF EXISTS VPX_VDEVICE_BACKING_REL_SEQ INCREMENT BY 1000;
 ALTER SEQUENCE IF EXISTS VPX_SN_VDEVICE_BACKING_REL_SEQ INCREMENT BY 1000;
 INSERT INTO VPX_PATCH_CONTENT VALUES('65124', 'BB');
 /
 
 
 
 
 <65124/>
 
 
 
 
 
 ALTER TABLE IF EXISTS VPX_DVPORT ADD IF NOT EXISTS BACKING_TYPE VARCHAR(16) default 'standard' NOT NULL;
 INSERT INTO VPX_PATCH_CONTENT VALUES('65125', 'BB');
 /
 
 
 
 <65125/>
 
 
 
 
 
 
 
 
 delete from vpx_version;
 INSERT INTO vpx_version VALUES (689, 'VirtualCenter Database 6.8');
 INSERT INTO VPX_PATCH_CONTENT VALUES('65126', 'BB');
 /
 
 
 
 
 <65126/>
 
 
 
 
 
 
 
 
 ALTER TABLE IF EXISTS VPX_DVHOST ADD IF NOT EXISTS NSXT_STATUS VARCHAR(16);
 ALTER TABLE IF EXISTS VPX_DVHOST ADD IF NOT EXISTS NSXT_STATUS_DETAIL VARCHAR(256);
 INSERT INTO VPX_PATCH_CONTENT VALUES('65127', 'BB');
 /
 
 
 
 
 <65127/>
 
 
 
 
 
 
 
 
 delete from vpx_version;
 INSERT INTO vpx_version VALUES (691, 'VirtualCenter Database 6.9');
 INSERT INTO VPX_PATCH_CONTENT VALUES('65129', 'BB');
 /
 
 
 
 
 <65129/>
 
 
 
 
 
 
 
 
 CREATE TABLE IF NOT EXISTS VPX_LICENSE_DISCONNECTED_HOSTS (
     HOST_ENTITY_ID BIGINT NOT NULL
 );
 INSERT INTO VPX_PATCH_CONTENT VALUES('65130', 'BB');
 /
 
 
 
 
 <65130/>
 
 
 
 
 
 
 
 
 
 
 
 
 
 CREATE TABLE IF NOT EXISTS VPX_MODULE_DEF(
    ID          BIGINT      NOT NULL,
    MODULE_UUID CHAR(36)    NOT NULL,
    CLUSTER_ID  BIGINT      NOT NULL,
    CONSTRAINT PK_VPX_MODULE_DEF PRIMARY KEY (ID),
    CONSTRAINT FK_VPX_MODULE_CLUSTER FOREIGN KEY (CLUSTER_ID)
       REFERENCES VPX_COMPUTE_RESOURCE(ID) ON DELETE CASCADE
 )
 ;
 
 CREATE SEQUENCE IF NOT EXISTS VPX_MODULE_DEF_SEQ INCREMENT BY 100;
 
 CREATE INDEX IF NOT EXISTS VPXI_MODULE_DEF_UUID ON VPX_MODULE_DEF (MODULE_UUID);
 
 
 
 
 
 CREATE TABLE IF NOT EXISTS VPX_ENTITY_MODULE_XREF(
    ENTITY_ID   BIGINT      NOT NULL,
    MODULE_ID   BIGINT      NOT NULL,
    CONSTRAINT PK_VPX_ENTITY_MODULE_XREF PRIMARY KEY (ENTITY_ID, MODULE_ID),
    CONSTRAINT FK_VPX_ETX_REF_VPX_ENTITY FOREIGN KEY (ENTITY_ID)
       REFERENCES VPX_ENTITY (ID) ON DELETE CASCADE,
    CONSTRAINT FK_VPX_ETX_REF_VPX_MODULE_DEF FOREIGN KEY (MODULE_ID)
       REFERENCES VPX_MODULE_DEF (ID) ON DELETE CASCADE,
    CONSTRAINT UK_VPX_ETX_REF_ENTITY_ID UNIQUE (ENTITY_ID)
 )
 ;
 
 INSERT INTO VPX_PATCH_CONTENT VALUES('65131', 'BB');
 /
 
 
 
 
 <65131/>
 
 
 
 
 
 ALTER TABLE IF EXISTS VPX_DVPORT ADD IF NOT EXISTS SEGMENT_PORT_ID VARCHAR(256);
 INSERT INTO VPX_PATCH_CONTENT VALUES('65132', 'BB');
 /
 
 
 
 <65132/>
 
 
 
 
 
 
 
 
 delete from vpx_version;
 INSERT INTO vpx_version VALUES (692, 'VirtualCenter Database 6.9');
 INSERT INTO VPX_PATCH_CONTENT VALUES('65133', 'BB');
 /
 
 
 
 
 <65133/>
 
 
 
 
 
 ALTER TABLE IF EXISTS VPX_DVHOST ADD IF NOT EXISTS TRANSPORT_ZONE_TYPE_ARRAY TEXT;
 INSERT INTO VPX_PATCH_CONTENT VALUES('65134', 'BB');
 /
 
 
 
 <65134/>
 
 
 
 
 
 
 
 
 
 ALTER TABLE IF EXISTS VPX_NON_ORM_VM_CONFIG_INFO ADD IF NOT EXISTS GMM_INFO_ENABLED NUMERIC(1) default 0;
 ALTER TABLE IF EXISTS VPX_NON_ORM_VM_CONFIG_INFO ADD IF NOT EXISTS GMM_INFO_GMMFILE VARCHAR(255) null;
 ALTER TABLE IF EXISTS VPX_NON_ORM_VM_CONFIG_INFO ADD IF NOT EXISTS GMM_INFO_APPLIANCE VARCHAR(255) null;
 INSERT INTO VPX_PATCH_CONTENT VALUES('65135', 'BB');
 /
 
 
 
 <65135/>
 
 
 
 
 
 
 
 ALTER TABLE IF EXISTS VPX_NON_ORM_VM_CONFIG_INFO DROP COLUMN IF EXISTS GMM_INFO_ENABLED;
 ALTER TABLE IF EXISTS VPX_NON_ORM_VM_CONFIG_INFO DROP COLUMN IF EXISTS GMM_INFO_GMMFILE;
 ALTER TABLE IF EXISTS VPX_NON_ORM_VM_CONFIG_INFO DROP COLUMN IF EXISTS GMM_INFO_APPLIANCE;
 ALTER TABLE IF EXISTS VPX_NON_ORM_VM_CONFIG_INFO ADD IF NOT EXISTS GUEST_MONITORING_MODE_INFO_ENABLED NUMERIC(1) default 0;
 ALTER TABLE IF EXISTS VPX_NON_ORM_VM_CONFIG_INFO ADD IF NOT EXISTS GUEST_MONITORING_MODE_INFO_GMMFILE VARCHAR(255) null;
 ALTER TABLE IF EXISTS VPX_NON_ORM_VM_CONFIG_INFO ADD IF NOT EXISTS GUEST_MONITORING_MODE_INFO_APPLIANCE VARCHAR(255) null;
 INSERT INTO VPX_PATCH_CONTENT VALUES('65136', 'BB');
 /
 
 
 
 <65136/>
 
 
 
 
 
 ALTER TABLE IF EXISTS VPX_DVHOST ADD IF NOT EXISTS ENS_INTERRUPT_ENABLED NUMERIC(1) default 0;
 INSERT INTO VPX_PATCH_CONTENT VALUES('65137', 'BB');
 /
 
 
 
 <65137/>
 
 
 
 
 
 
 
 
 delete from vpx_version;
 INSERT INTO vpx_version VALUES (693, 'VirtualCenter Database 6.9');
 INSERT INTO VPX_PATCH_CONTENT VALUES('65138', 'BB');
 /
 
 
 
 
 <65138/>
 
 
 
 
 
 
 
 
 
 
 DO
 $$ BEGIN
 IF NOT EXISTS (select constraint_name
                from information_schema.table_constraints
                where table_schema='vc'
                  AND table_name = lower('VPX_ATTESTD_SERVICES')
                  AND constraint_name = lower('ATTESTD_UNIQUE_GROUP_ID'))
 THEN
 
    ALTER TABLE IF EXISTS VPX_ATTESTD_SERVICES ADD CONSTRAINT ATTESTD_UNIQUE_GROUP_ID UNIQUE (GROUP_ID);
 
 END IF;
 END$$;
 DO
 $$ BEGIN
 IF NOT EXISTS (select constraint_name
                from information_schema.table_constraints
                where table_schema='vc'
                  AND table_name = lower('VPX_KMXD_SERVICES')
                  AND constraint_name = lower('KMXD_UNIQUE_GROUP_ID'))
 THEN
 
    ALTER TABLE IF EXISTS VPX_KMXD_SERVICES ADD CONSTRAINT KMXD_UNIQUE_GROUP_ID UNIQUE (GROUP_ID);
 
 END IF;
 END$$;
 INSERT INTO VPX_PATCH_CONTENT VALUES('65139', 'BB');
 /
 
 
 
 <65139/>
 
 
 
 
 
 
 
 
 
 
 
 DROP FUNCTION IF EXISTS cleanup_events_tasks_proc ();
 DROP FUNCTION IF EXISTS calc_topn1_proc (p_last_run timestamp, p_last_stat timestamp);
 DROP FUNCTION IF EXISTS calc_topn2_proc (p_last_run timestamp, p_last_stat timestamp);
 DROP FUNCTION IF EXISTS calc_topn3_proc (p_last_run timestamp, p_last_stat timestamp);
 DROP FUNCTION IF EXISTS calc_topn4_proc (p_last_run timestamp, p_last_stat timestamp);
 DROP FUNCTION IF EXISTS rule_topn1_proc ();
 DROP FUNCTION IF EXISTS rule_topn2_proc ();
 DROP FUNCTION IF EXISTS rule_topn3_proc ();
 DROP FUNCTION IF EXISTS rule_topn4_proc ();
 
 INSERT INTO VPX_PATCH_CONTENT VALUES('65140', 'BB');
 /
 
 
 
 
 <65140/>
 
 
 
 
 
 
 
 
 delete from vpx_version;
 INSERT INTO vpx_version VALUES (700, 'VirtualCenter Database 7.0');
 INSERT INTO VPX_PATCH_CONTENT VALUES('65141', 'BB');
 /
 
 
 
 
 <65141/>
 
 
 
 
 
 
 
 
 ALTER TABLE IF EXISTS VPX_NON_ORM_VM_CONFIG_INFO ADD IF NOT EXISTS TOOLS_SYNC_TIME_WITH_HOST_ALLOWED_FLG NUMERIC(1) default 0;
 INSERT INTO VPX_PATCH_CONTENT VALUES('65142', 'BB');
 /
 
 
 
 
 <65142/>
 
 
 
 
 
 
 
 
 
 ALTER TABLE IF EXISTS VPX_COMPUTE_RESOURCE ADD IF NOT EXISTS EVC_GRAPHICS_MODE TEXT;
 INSERT INTO VPX_PATCH_CONTENT VALUES('65143', 'BB');
 /
 
 
 
 
 <65143/>
 
 
 
 
 
 
 
 
 
 ALTER TABLE IF EXISTS VPX_TASK RESET (
    autovacuum_analyze_scale_factor,
    autovacuum_analyze_threshold,
    autovacuum_vacuum_cost_delay,
    toast.autovacuum_vacuum_cost_delay,
    autovacuum_vacuum_cost_limit,
    toast.autovacuum_vacuum_cost_limit,
    autovacuum_vacuum_scale_factor,
    toast.autovacuum_vacuum_scale_factor,
    autovacuum_vacuum_threshold,
    toast.autovacuum_vacuum_threshold
 );
 
 ALTER TABLE IF EXISTS VPX_ENTITY RESET (
    autovacuum_analyze_scale_factor,
    autovacuum_analyze_threshold,
    autovacuum_vacuum_cost_delay,
    toast.autovacuum_vacuum_cost_delay,
    autovacuum_vacuum_cost_limit,
    toast.autovacuum_vacuum_cost_limit,
    autovacuum_vacuum_scale_factor,
    toast.autovacuum_vacuum_scale_factor,
    autovacuum_vacuum_threshold,
    toast.autovacuum_vacuum_threshold
 );
 
 ALTER TABLE IF EXISTS VPX_VM RESET (
    autovacuum_analyze_scale_factor,
    autovacuum_analyze_threshold,
    autovacuum_vacuum_cost_delay,
    toast.autovacuum_vacuum_cost_delay,
    autovacuum_vacuum_cost_limit,
    toast.autovacuum_vacuum_cost_limit,
    autovacuum_vacuum_scale_factor,
    toast.autovacuum_vacuum_scale_factor,
    autovacuum_vacuum_threshold,
    toast.autovacuum_vacuum_threshold
 );
 
 ALTER TABLE IF EXISTS VPX_DVPORT RESET (
    autovacuum_analyze_scale_factor,
    autovacuum_analyze_threshold,
    autovacuum_vacuum_cost_delay,
    toast.autovacuum_vacuum_cost_delay,
    autovacuum_vacuum_cost_limit,
    toast.autovacuum_vacuum_cost_limit,
    autovacuum_vacuum_scale_factor,
    toast.autovacuum_vacuum_scale_factor,
    autovacuum_vacuum_threshold,
    toast.autovacuum_vacuum_threshold
 );
 
 ALTER TABLE IF EXISTS VPX_HOST RESET (
    autovacuum_analyze_scale_factor,
    autovacuum_analyze_threshold,
    autovacuum_vacuum_cost_delay,
    toast.autovacuum_vacuum_cost_delay,
    autovacuum_vacuum_cost_limit,
    toast.autovacuum_vacuum_cost_limit,
    autovacuum_vacuum_scale_factor,
    toast.autovacuum_vacuum_scale_factor,
    autovacuum_vacuum_threshold,
    toast.autovacuum_vacuum_threshold
 );
 
 ALTER TABLE IF EXISTS VPX_HOST_VM_CONFIG_OPTION RESET (
    autovacuum_analyze_scale_factor,
    autovacuum_analyze_threshold,
    autovacuum_vacuum_cost_delay,
    toast.autovacuum_vacuum_cost_delay,
    autovacuum_vacuum_cost_limit,
    toast.autovacuum_vacuum_cost_limit,
    autovacuum_vacuum_scale_factor,
    toast.autovacuum_vacuum_scale_factor,
    autovacuum_vacuum_threshold,
    toast.autovacuum_vacuum_threshold
 );
 
 ALTER TABLE IF EXISTS VPX_GUEST_DISK RESET (
    autovacuum_analyze_scale_factor,
    autovacuum_analyze_threshold,
    autovacuum_vacuum_cost_delay,
    toast.autovacuum_vacuum_cost_delay,
    autovacuum_vacuum_cost_limit,
    toast.autovacuum_vacuum_cost_limit,
    autovacuum_vacuum_scale_factor,
    toast.autovacuum_vacuum_scale_factor,
    autovacuum_vacuum_threshold,
    toast.autovacuum_vacuum_threshold
 );
 
 ALTER TABLE IF EXISTS VPX_NIC RESET (
    autovacuum_analyze_scale_factor,
    autovacuum_analyze_threshold,
    autovacuum_vacuum_cost_delay,
    toast.autovacuum_vacuum_cost_delay,
    autovacuum_vacuum_cost_limit,
    toast.autovacuum_vacuum_cost_limit,
    autovacuum_vacuum_scale_factor,
    toast.autovacuum_vacuum_scale_factor,
    autovacuum_vacuum_threshold,
    toast.autovacuum_vacuum_threshold
 );
 
 ALTER TABLE IF EXISTS VPX_IP_ADDRESS RESET (
    autovacuum_analyze_scale_factor,
    autovacuum_analyze_threshold,
    autovacuum_vacuum_cost_delay,
    toast.autovacuum_vacuum_cost_delay,
    autovacuum_vacuum_cost_limit,
    toast.autovacuum_vacuum_cost_limit,
    autovacuum_vacuum_scale_factor,
    toast.autovacuum_vacuum_scale_factor,
    autovacuum_vacuum_threshold,
    toast.autovacuum_vacuum_threshold
 );
 
 ALTER TABLE IF EXISTS VPX_VM_TEXT RESET (
    autovacuum_analyze_scale_factor,
    autovacuum_analyze_threshold,
    autovacuum_vacuum_cost_delay,
    toast.autovacuum_vacuum_cost_delay,
    autovacuum_vacuum_cost_limit,
    toast.autovacuum_vacuum_cost_limit,
    autovacuum_vacuum_scale_factor,
    toast.autovacuum_vacuum_scale_factor,
    autovacuum_vacuum_threshold,
    toast.autovacuum_vacuum_threshold
 );
 
 ALTER TABLE IF EXISTS VPX_VM_VIRTUAL_DEVICE RESET (
    autovacuum_analyze_scale_factor,
    autovacuum_analyze_threshold,
    autovacuum_vacuum_cost_delay,
    toast.autovacuum_vacuum_cost_delay,
    autovacuum_vacuum_cost_limit,
    toast.autovacuum_vacuum_cost_limit,
    autovacuum_vacuum_scale_factor,
    toast.autovacuum_vacuum_scale_factor,
    autovacuum_vacuum_threshold,
    toast.autovacuum_vacuum_threshold
 );
 
 INSERT INTO VPX_PATCH_CONTENT VALUES('65144', 'BB');
 /
 
 
 
 
 <65144/>
 
 
 
 
 
 
 
 
 ALTER TABLE IF EXISTS VPX_JOURNAL_ENTRY SET (
    autovacuum_analyze_scale_factor = 0,
    autovacuum_analyze_threshold = 0,
    autovacuum_vacuum_cost_delay = 0,
    toast.autovacuum_vacuum_cost_delay = 0,
    autovacuum_vacuum_cost_limit = 1000,
    toast.autovacuum_vacuum_cost_limit = 1000,
    autovacuum_vacuum_scale_factor = 0,
    toast.autovacuum_vacuum_scale_factor = 0,
    autovacuum_vacuum_threshold = 1000,
    toast.autovacuum_vacuum_threshold = 1000
 );
 /
 
 
 
 
 <65145/>
 
 
 
 
 
 
 
 
 
 ALTER TABLE IF EXISTS  VPX_COMPUTE_RESOURCE ADD IF NOT EXISTS EDRS_MAINTENANCE_MODE_STATUS INTEGER DEFAULT 0 NOT NULL;
 INSERT INTO VPX_PATCH_CONTENT VALUES('65146', 'BB');
 /
 
 
 
 
 <65146/>
 
 
 
 
 
 
 
 
 
 ALTER TABLE IF EXISTS VPX_COMPUTE_RESOURCE ADD IF NOT EXISTS EVC_PARTIAL INTEGER DEFAULT -1 NOT NULL;
 INSERT INTO VPX_PATCH_CONTENT VALUES('65147', 'BB');
 /
 
 
 
 
 <65147/>
 
 
 
 
 
 
 
 
 
 
 create table IF NOT EXISTS VPX_HOST_SEVINFO (
    HOST_ID               BIGINT                        not null,
    SEV_STATE             VARCHAR(32)                   not null,
    SEV_MAX_GUESTS        INTEGER                       not null,
    constraint PK_VPX_HOST_SEVINFO primary key (HOST_ID),
    constraint FK_VPX_HOST_SEVINFO foreign key (HOST_ID)
       references VPX_HOST (ID) on delete cascade
 );
 
 ALTER TABLE IF EXISTS VPX_NON_ORM_VM_CONFIG_INFO ADD IF NOT EXISTS SEV_ENABLED NUMERIC(1) default 0;
 
 INSERT INTO VPX_PATCH_CONTENT VALUES('65148', 'BB');
 /
 
 
 
 
 <65148/>
 
 
 
 
 
 
 
 
 
 ALTER TABLE IF EXISTS VPX_DS_INFO ADD IF NOT EXISTS CONTAINER_ID VARCHAR(33);
 ALTER TABLE IF EXISTS VPX_DS_INFO ADD IF NOT EXISTS ALIAS_OF     VARCHAR(33);
 INSERT INTO VPX_PATCH_CONTENT VALUES('65149', 'BB');
 /
 
 
 
 
 <65149/>
 
 
 
 
 
 
 
 
 
 
 ALTER TABLE IF EXISTS VPX_STORAGE_OBJECT_INFO ADD COLUMN IF NOT EXISTS DISK_PATH TEXT;
 ALTER TABLE IF EXISTS VPX_STORAGE_OBJECT_INFO ADD COLUMN IF NOT EXISTS USED_CAPACITY BIGINT DEFAULT -1;
 INSERT INTO VPX_PATCH_CONTENT VALUES('65150', 'BB');
 /
 
 
 
 
 <65150/>
 
 
 
 
 
 
 
 
 
 ALTER TABLE IF EXISTS VPX_HOST_PCI_DEVICE ADD IF NOT EXISTS NUMA_ID INTEGER;
 INSERT INTO VPX_PATCH_CONTENT VALUES('65151', 'BB');
 /
 
 
 
 
 <65151/>
 
 
 
 
 
 
 
 
 
 ALTER TABLE IF EXISTS VPX_DVS_LAG ADD IF NOT EXISTS LAG_TIMEOUT_MODE VARCHAR(255);
 INSERT INTO VPX_PATCH_CONTENT VALUES('65153', 'BB');
 /
 
 
 
 
 <65153/>
 
 
 
 
 
 
 
 
 
 ALTER TABLE IF EXISTS VPX_FCD_DATASTORE_INFO ADD COLUMN IF NOT EXISTS VCLOCK BIGINT DEFAULT -1;
 INSERT INTO VPX_PATCH_CONTENT VALUES('65154', 'BB');
 /
 
 
 
 
 <65154/>
 
 
 
 
 
 
 
 
 DELETE FROM vpx_version;
 INSERT INTO vpx_version VALUES (701, 'VirtualCenter Database 7.0');
 INSERT INTO VPX_PATCH_CONTENT VALUES('65156', 'BB');
 /
 
 
 
 
 <65156/>
 
 
 
 
 
 
 
 
 CREATE INDEX IF NOT EXISTS VPX_STAT_COUNTER_D1 on VPX_STAT_COUNTER(DEVICE_ID);
 INSERT INTO VPX_PATCH_CONTENT VALUES('65157', 'BB');
 /
 
 
 
 
 <65157/>
 
 
 
 
 
 
 
 
 CREATE TABLE IF NOT EXISTS VPX_ATTESTD_SIGNING_INFO(
    SERVICE_ID                 BIGINT            NOT NULL,
    CERT                       TEXT,
    PUBKEY                     TEXT,
    CONSTRAINT PK_VPX_ATTESTD_SIGNING_INFO PRIMARY KEY (SERVICE_ID),
    CONSTRAINT FK_VPX_ATTESTD_SIGNING_INFO FOREIGN KEY (SERVICE_ID)
       REFERENCES VPX_ATTESTD_SERVICES(ID) ON DELETE CASCADE
 );
 INSERT INTO VPX_PATCH_CONTENT VALUES('65159', 'BB');
 /
 
 
 
 
 <65159/>
 
 
 
 
 
 
 
 
 CREATE TABLE IF NOT EXISTS VPX_HOST_VSAN_RUNTIME (
    ID                   BIGINT  NOT NULL,
    VSAN_RUNTIME_INFO    TEXT,
    CONSTRAINT PK_VPX_HOST_VSAN_RUNTIME PRIMARY KEY (ID),
    CONSTRAINT FK_VPX_HOST_VSAN_RUNTIME_REF_VPX_HOST FOREIGN KEY (ID)
       REFERENCES VPX_HOST (ID) ON DELETE CASCADE
 );
 /
 
 
 
 
 <65160/>
 
 
 
 
 
 
 
 
 
 ALTER TABLE IF EXISTS VPX_NON_ORM_VM_CONFIG_INFO ADD IF NOT EXISTS VNUMA_CORES_PER_NODE      INTEGER    default 0;
 ALTER TABLE IF EXISTS VPX_NON_ORM_VM_CONFIG_INFO ADD IF NOT EXISTS VNUMA_AUTO_CORES_PER_NODE NUMERIC(1) default 0;
 INSERT INTO VPX_PATCH_CONTENT VALUES('65161', 'BB');
 /
 
 
 
 <65161/>
 
 
 
 
 
 
 
 
 ALTER TABLE IF EXISTS VPX_CRYPTO_KMIP_CLUSTER ADD IF NOT EXISTS BACKUP_COUNT INTEGER DEFAULT 0 NOT NULL;
 CREATE TABLE IF NOT EXISTS VPX_CRYPTO_NATIVE_KEY_PROVIDER(
    CLUSTER_ID     VARCHAR(255) NOT NULL,
    KEY_ID         VARCHAR(255) NOT NULL,
    ENC_KDK        VARCHAR(255) NOT NULL,
    KEY_ID_LAST_UPDATE TIMESTAMP,
    PERSIST_TOKEN  TEXT,
    CONSTRAINT PK_VPX_CRYPTO_NATIVE_KEY_PROVIDER PRIMARY KEY (CLUSTER_ID),
    CONSTRAINT FK_VPX_CRYPTO_NATIVE_KEY_PROVIDER FOREIGN KEY (CLUSTER_ID)
       REFERENCES VPX_CRYPTO_KMIP_CLUSTER (CLUSTER_ID) ON DELETE CASCADE
 );
 INSERT INTO VPX_PATCH_CONTENT VALUES('65162', 'BB');
 /
 
 
 
 
 <65162/>
 
 
 
 
 
 
 
 
 DO
 $$
 BEGIN
 
     IF EXISTS ( SELECT 1
                   FROM pg_tables
                  WHERE schemaname = 'vc'
                    AND tablename  = 'vpx_vcdb_ndu_exp_app' )
     THEN
       IF NOT EXISTS ( SELECT CLN_ID
                         FROM VPX_VCDB_NDU_EXP_APP
                        WHERE CLN_ID = 12 )
       THEN
         INSERT INTO VPX_DVS_INFRA_RES_POOL
            SELECT ID AS DVS_ID,
                   'backupNfc' AS NRP_KEY,
                   'vSphere Backup NFC Traffic Type' AS DESCRIPTION,
                   -1 AS ALLOCATION_LIMIT,
                   50 AS ALLOCATION_SHARES_SHARES,
                   'normal' AS ALLOCATION_SHARES_LEVEL,
                   0 AS ALLOCATION_RESERVATION
              FROM VPX_DVS
             WHERE NETWORK_RESOURCE_CTRL_VERSION='version3'
               AND PRODUCT_VERSION='7.0.0'
               AND ID NOT IN (SELECT DVS_ID
                                FROM VPX_DVS_INFRA_RES_POOL
                               WHERE NRP_KEY = 'backupNfc');
       END IF;
     ELSE
       INSERT INTO VPX_DVS_INFRA_RES_POOL
          SELECT ID AS DVS_ID,
                 'backupNfc' AS NRP_KEY,
                 'vSphere Backup NFC Traffic Type' AS DESCRIPTION,
                 -1 AS ALLOCATION_LIMIT,
                 50 AS ALLOCATION_SHARES_SHARES,
                 'normal' AS ALLOCATION_SHARES_LEVEL,
                 0 AS ALLOCATION_RESERVATION
            FROM VPX_DVS
           WHERE NETWORK_RESOURCE_CTRL_VERSION='version3'
             AND PRODUCT_VERSION='7.0.0'
             AND ID NOT IN (SELECT DVS_ID
                              FROM VPX_DVS_INFRA_RES_POOL
                             WHERE NRP_KEY = 'backupNfc');
     END IF;
 END;
 $$;
 
 INSERT INTO VPX_PATCH_CONTENT VALUES('65163', 'BB');
 /
 
 
 
 
 <65163/>
 
 
 
 
 
 
 
 
 ALTER TABLE IF EXISTS VPX_HOST_X ADD IF NOT EXISTS HA_ATTRIBUTES INTEGER NULL;
 INSERT INTO VPX_PATCH_CONTENT VALUES('65165', 'BB');
 /
 
 
 
 
 <65165/>
 
 
 
 
 
 
 
 
 ALTER TABLE IF EXISTS VPX_CRYPTO_KMIP_CLUSTER ADD IF NOT EXISTS TPM_REQUIRED INTEGER DEFAULT 0 NOT NULL;
 ALTER TABLE IF EXISTS VPX_CRYPTO_KMIP_CLUSTER ADD IF NOT EXISTS AUTO_REMEDIATE INTEGER DEFAULT 0 NOT NULL;
 INSERT INTO VPX_PATCH_CONTENT VALUES('65166', 'BB');
 /
 
 
 
 
 <65166/>
 
 
 
 
 
 
 
 
 
 
 CREATE TABLE IF NOT EXISTS VPX_HOST_SYNC_GEN (
    HOST_ID              BIGINT                  NOT NULL,
    MASTER_GEN           INTEGER DEFAULT 0       NOT NULL,
    MASTER_SPEC_GEN      INTEGER DEFAULT 0       NOT NULL,
    CONSTRAINT PK_HOST_SYNC_GEN PRIMARY KEY (HOST_ID),
    CONSTRAINT FK_HOST_SYNC_GEN_REF_VPX_HOST FOREIGN KEY (HOST_ID)
       REFERENCES VPX_HOST(ID) ON DELETE CASCADE
 );
 
 DO
 $$
 BEGIN
 
   IF EXISTS ( SELECT 1
                 FROM pg_tables
                WHERE schemaname = 'vc'
                  AND tablename = 'vpx_vcdb_ndu_exp_app' )
   THEN
     IF NOT EXISTS ( SELECT CLN_ID
                       FROM VPX_VCDB_NDU_EXP_APP
                      WHERE CLN_ID = 15 )
     THEN
       INSERT INTO VPX_HOST_SYNC_GEN (HOST_ID, MASTER_GEN, MASTER_SPEC_GEN)
          SELECT t.ID AS HOST_ID,
                 CAST(t.MASTER_GEN AS INTEGER) AS MASTER_GEN,
                 CAST(t.MASTER_SPEC_GEN AS INTEGER) AS MASTER_SPEC_GEN
            FROM VPX_HOST t;
     END IF;
   ELSE
     INSERT INTO VPX_HOST_SYNC_GEN (HOST_ID, MASTER_GEN, MASTER_SPEC_GEN)
        SELECT t.ID AS HOST_ID,
               CAST(t.MASTER_GEN AS INTEGER) AS MASTER_GEN,
               CAST(t.MASTER_SPEC_GEN AS INTEGER) AS MASTER_SPEC_GEN
          FROM VPX_HOST t;
   END IF;
 END;
 $$;
 
 ALTER TABLE IF EXISTS VPX_HOST DROP COLUMN IF EXISTS MASTER_GEN;
 
 ALTER TABLE IF EXISTS VPX_HOST DROP COLUMN IF EXISTS MASTER_SPEC_GEN;
 
 INSERT INTO VPX_PATCH_CONTENT VALUES('65167', 'BB');
 /
 
 
 
 
 <65167/>
 
 
 
 
 
 
 
 
 
 ALTER TABLE IF EXISTS VPX_NON_ORM_VM_CONFIG_INFO ADD IF NOT EXISTS CHIPSET_MOTHERBOARDLAYOUT VARCHAR(255) null;
 INSERT INTO VPX_PATCH_CONTENT VALUES('65168', 'BB');
 /
 
 
 
 <65168/>
 
 
 
 
 
 
 
 
 
 ALTER TABLE IF EXISTS VPX_VM ADD COLUMN IF NOT EXISTS APPHEARTBEAT_STATUS VARCHAR(64) null;
 INSERT INTO VPX_PATCH_CONTENT VALUES('65169', 'BB');
 /
 
 
 
 
 <65169/>
 
 
 
 
 
 
 
 
 
 CREATE TABLE IF NOT EXISTS VPX_HOST_SERVICE_MODE_STATE(
    HOST_ID              BIGINT  NOT NULL,
    SERVICE_MODE_STATES  TEXT NOT NULL,
    CONSTRAINT PK_VPX_HOST_SERVICE_MODE_STATE PRIMARY KEY (HOST_ID),
    CONSTRAINT FK_VPX_HOST_SERVICE_MODE_STATE FOREIGN KEY (HOST_ID)
       REFERENCES VPX_HOST (ID) ON DELETE CASCADE
 );
 INSERT INTO VPX_PATCH_CONTENT VALUES('65170', 'BB');
 /
 
 
 
 
 <65170/>
 
 
 
 
 
 
 
 
 
 CREATE TABLE IF NOT EXISTS VPX_VCS_VM (
    VM_ID              BIGINT  NOT NULL,
    VM_VCS_STATE       NUMERIC(1) DEFAULT 1   NOT NULL,
    CONSTRAINT PK_VPX_VCS_VM PRIMARY KEY (VM_ID),
    CONSTRAINT FK_VPX_VCS_VM FOREIGN KEY (VM_ID)
       REFERENCES VPX_VM (ID) ON DELETE CASCADE
 );
 INSERT INTO VPX_PATCH_CONTENT VALUES('65172', 'BB');
 /
 
 
 
 
 <65172/>
 
 
 
 
 
 
 
 
 
 CREATE TABLE IF NOT EXISTS VPX_HOST_PERFINFO (
    HOST_ID              BIGINT                  NOT NULL,
    LAST_PERF_TIME       TIMESTAMP,
    PERF_REFRESH_RATE    INTEGER,
    CONSTRAINT PK_HOST_PERFINFO PRIMARY KEY (HOST_ID),
    CONSTRAINT FK_HOST_PERFINFO FOREIGN KEY (HOST_ID)
       REFERENCES VPX_HOST(ID) ON DELETE CASCADE
 );
 
 DO
 $$
 BEGIN
 
   IF EXISTS ( SELECT 1
                 FROM pg_tables
                WHERE schemaname = 'vc'
                  AND tablename = 'vpx_vcdb_ndu_exp_app' )
   THEN
     IF NOT EXISTS ( SELECT CLN_ID
                       FROM VPX_VCDB_NDU_EXP_APP
                      WHERE CLN_ID = 20 )
     THEN
       INSERT INTO VPX_HOST_PERFINFO (HOST_ID, LAST_PERF_TIME, PERF_REFRESH_RATE)
          SELECT t.ID AS HOST_ID,
                 t.LAST_PERF_TIME AS LAST_PERF_TIME,
                 t.PERF_REFRESH_RATE AS PERF_REFRESH_RATE
            FROM VPX_HOST t;
     END IF;
   ELSE
     INSERT INTO VPX_HOST_PERFINFO (HOST_ID, LAST_PERF_TIME, PERF_REFRESH_RATE)
          SELECT t.ID AS HOST_ID,
                 t.LAST_PERF_TIME AS LAST_PERF_TIME,
                 t.PERF_REFRESH_RATE AS PERF_REFRESH_RATE
            FROM VPX_HOST t;
   END IF;
 END;
 $$;
 
 ALTER TABLE IF EXISTS VPX_HOST DROP COLUMN IF EXISTS LAST_PERF_TIME;
 
 ALTER TABLE IF EXISTS VPX_HOST DROP COLUMN IF EXISTS PERF_REFRESH_RATE;
 
 INSERT INTO VPX_PATCH_CONTENT VALUES('65173', 'BB');
 /
 
 
 
 
 <65173/>
 
 
 
 
 
 
 
 
 
 ALTER TABLE IF EXISTS VPX_DATACENTER ADD IF NOT EXISTS MAXIMUM_HW_VERSION VARCHAR(255) null;
 
 ALTER TABLE IF EXISTS VPX_COMPUTE_RESOURCE ADD IF NOT EXISTS MAXIMUM_HW_VERSION VARCHAR(255) null;
 
 INSERT INTO VPX_PATCH_CONTENT VALUES('65175', 'BB');
 /
 
 
 
 
 <65175/>
 
 
 
 
 
 
 
 
 ALTER TABLE IF EXISTS VPX_VM ADD IF NOT EXISTS ENABLE_PMEM_FAILOVER int NULL;
 INSERT INTO VPX_PATCH_CONTENT VALUES('65176', 'BB');
 /
 
 
 
 
 <65176/>
 
 
 
 
 
 
 
 
 
 
 ALTER TABLE IF EXISTS VPX_FCD_SNAPSHOT_INFO ADD IF NOT EXISTS SNAPSHOT_DESCRIPTION VARCHAR(255);
 ALTER TABLE IF EXISTS VPX_FCD_SNAPSHOT_INFO ADD IF NOT EXISTS SNAPSHOT_ID VARCHAR(60);
 ALTER TABLE IF EXISTS VPX_FCD_SNAPSHOT_INFO ADD IF NOT EXISTS SNAPSHOT_DISK_PATH VARCHAR(255);
 ALTER TABLE IF EXISTS VPX_FCD_SNAPSHOT_INFO DROP CONSTRAINT IF EXISTS VPX_SNAPSHOT_ID_U1;
 CREATE UNIQUE INDEX IF NOT EXISTS VPX_SNAPSHOT_ID ON VPX_FCD_SNAPSHOT_INFO(SNAPSHOT_ID);
 DO
 $$ BEGIN
 IF NOT EXISTS (SELECT constraint_name
                  FROM information_schema.table_constraints
                 WHERE table_schema='vc'
                   AND table_name = lower('VPX_FCD_SNAPSHOT_INFO')
                   AND constraint_name = lower('VPX_SNAPSHOT_ID_U2'))
 THEN
 
    ALTER TABLE IF EXISTS VPX_FCD_SNAPSHOT_INFO ADD CONSTRAINT VPX_SNAPSHOT_ID_U2 UNIQUE USING INDEX VPX_SNAPSHOT_ID;
 
 END IF;
 END$$;
 INSERT INTO VPX_PATCH_CONTENT VALUES('65177', 'BB');
 /
 
 
 
 
 <65177/>
 
 
 
 
 
 
 
 
 
 CREATE TABLE IF NOT EXISTS VPX_HOST_NFC_CONFIG (
    HOST_ID           BIGINT       NOT NULL,
    TOTAL_MEMORY      INTEGER      NOT NULL,
    STREAMING_MEMORY  INTEGER      NOT NULL,
    CONSTRAINT PK_VPX_HOST_NFC_CONFIG PRIMARY KEY (HOST_ID),
    CONSTRAINT FK_VPX_HOST_NFC_CONFIG FOREIGN KEY (HOST_ID)
       REFERENCES VPX_HOST (ID) ON DELETE CASCADE
 );
 INSERT INTO VPX_PATCH_CONTENT VALUES('65178', 'BB');
 /
 
 
 
 
 <65178/>
 
 
 
 
 
 
 
 
 
 ALTER TABLE IF EXISTS VPX_COMPUTE_RESOURCE
       ADD COLUMN IF NOT EXISTS PMEM_ADMISSION_CTRL_ENABLED BOOLEAN,
       ADD COLUMN IF NOT EXISTS FAILOVER_PMEM_RESOURCES INTEGER,
       ADD COLUMN IF NOT EXISTS FAILOVER_PMEM_RESOURCE_AUTO_COMPUTE BOOLEAN;
 
 INSERT INTO VPX_PATCH_CONTENT VALUES('65179', 'BB');
 /
 
 
 
 
 <65179/>
 
 
 
 
 
 
 
 CREATE TABLE IF NOT EXISTS VSAN_HISTORICAL_HEALTH (
    HISTORY_ID              BIGSERIAL,
    CLUSTER                 VARCHAR(255)                    not null,
    GROUP_NAME              VARCHAR(63)                     not null,
    TEST_NAME               VARCHAR(63)                     not null,
    TIMESTAMP               TIMESTAMP                       not null,
    HEALTH                  VARCHAR(15)                     not null,
    DETAILS                 TEXT,
    TAGS                    TEXT,
    constraint PK_VSAN_HISTORICAL_HEALTH primary key (HISTORY_ID) using index TABLESPACE hs4
 ) TABLESPACE hs4;
 
 CREATE UNIQUE INDEX IF NOT EXISTS VSAN_HISTORICAL_HEALTH_UNIQUE_ID ON VSAN_HISTORICAL_HEALTH (
    CLUSTER, GROUP_NAME, TEST_NAME, TIMESTAMP
 ) TABLESPACE hs4;
 
 CREATE INDEX IF NOT EXISTS VSAN_HISTORICAL_HEALTH_TIMESTAMP ON VSAN_HISTORICAL_HEALTH (
    TIMESTAMP
 ) TABLESPACE hs4;
 
 INSERT INTO VPX_PATCH_CONTENT VALUES('65180', 'BB');
 /
 
 
 
 <65180/>
 
 
 
 
 
 
 
 
 
 
 
 ALTER TABLE IF EXISTS VPX_HOST_SERVICE_MODE_STATE RENAME TO VPX_HOST_PARTIAL_MM_STATUS;
 
 DO $$
 BEGIN
   IF EXISTS(SELECT *
               FROM information_schema.columns
              WHERE table_name = lower('VPX_HOST_PARTIAL_MM_STATUS')
                AND column_name = lower('SERVICE_MODE_STATES'))
   THEN
       ALTER TABLE VPX_HOST_PARTIAL_MM_STATUS RENAME COLUMN SERVICE_MODE_STATES TO PARTIAL_MM_STATUS;
   END IF;
 END $$;
 
 DO $$
 BEGIN
   IF EXISTS (SELECT constraint_name
                FROM information_schema.table_constraints
               WHERE table_schema='vc'
                 AND table_name = lower('VPX_HOST_PARTIAL_MM_STATUS')
                 AND constraint_name = lower('PK_VPX_HOST_SERVICE_MODE_STATE'))
   THEN
       ALTER TABLE VPX_HOST_PARTIAL_MM_STATUS RENAME CONSTRAINT PK_VPX_HOST_SERVICE_MODE_STATE TO PK_VPX_HOST_PARTIAL_MM_STATUS;
   END IF;
 END $$;
 
 DO $$
 BEGIN
   IF EXISTS (SELECT constraint_name
                FROM information_schema.table_constraints
               WHERE table_schema='vc'
                 AND table_name = lower('VPX_HOST_PARTIAL_MM_STATUS')
                 AND constraint_name = lower('FK_VPX_HOST_SERVICE_MODE_STATE'))
   THEN
       ALTER TABLE VPX_HOST_PARTIAL_MM_STATUS RENAME CONSTRAINT FK_VPX_HOST_SERVICE_MODE_STATE TO FK_VPX_HOST_PARTIAL_MM_STATUS;
   END IF;
 END $$;
 
 INSERT INTO VPX_PATCH_CONTENT VALUES('65181', 'BB');
 /
 
 
 
 
 <65181/>
 
 
 
 
 
 
 
 
 DELETE FROM vpx_version;
 INSERT INTO vpx_version VALUES (702, 'VirtualCenter Database 7.0');
 INSERT INTO VPX_PATCH_CONTENT VALUES('65183', 'BB');
 /
 
 
 
 
 <65183/>
 
 
 
 
 
 
 
 
 CREATE TABLE IF NOT EXISTS VSAN_HISTORICAL_CLUSTER (
    CLUSTER_ID             SERIAL,
    CLUSTER_NAME           VARCHAR(256),
    constraint PK_VSAN_HISTORICAL_CLUSTER primary key (
      CLUSTER_ID) using index TABLESPACE hs4,
    constraint UK_VSAN_HISTORICAL_CLUSTER unique (
       CLUSTER_NAME) using index TABLESPACE hs4
 ) TABLESPACE hs4;
 
 
 
 
 CREATE TABLE IF NOT EXISTS VSAN_HISTORICAL_GROUP (
    GROUP_ID             SERIAL,
    GROUP_NAME           VARCHAR(64),
    constraint PK_VSAN_HISTORICAL_GROUP primary key (
      GROUP_ID) using index TABLESPACE hs4,
    constraint UK_VSAN_HISTORICAL_GROUP unique (
      GROUP_NAME) using index TABLESPACE hs4
 ) TABLESPACE hs4;
 
 
 
 
 CREATE TABLE IF NOT EXISTS VSAN_HISTORICAL_TEST (
    TEST_ID             SERIAL,
    TEST_NAME           VARCHAR(64),
    constraint PK_VSAN_HISTORICAL_TEST primary key (
      TEST_ID) using index TABLESPACE hs4,
    constraint UK_VSAN_HISTORICAL_TEST unique (
      TEST_NAME) using index TABLESPACE hs4
 ) TABLESPACE hs4;
 
 
 
 
 CREATE TABLE IF NOT EXISTS VSAN_HISTORICAL_HEALTH_CHECK (
    HEALTH_ID           INT   NOT NULL,
    HEALTH_DESC         VARCHAR(15),
    constraint PK_VSAN_HISTORICAL_HEALTH_CHECK primary key (
      HEALTH_ID) using index TABLESPACE hs4,
    constraint UK_VSAN_HISTORICAL_HEALTH_CHECK unique (
      HEALTH_DESC) using index TABLESPACE hs4
 ) TABLESPACE hs4;
 
 
 
 
 DROP TABLE IF EXISTS VSAN_HISTORICAL_HEALTH;
 CREATE TABLE VSAN_HISTORICAL_HEALTH (
    CLUSTER_ID          INT,
    GROUP_ID            INT,
    TEST_ID             INT,
    CREATION_TIME       TIMESTAMP   NOT NULL,
    HEALTH_ID           INT         NOT NULL,
    DETAILS             TEXT,
    TAGS                TEXT,
    constraint FK_CLUSTER_VHH_CLUSTERID foreign key(CLUSTER_ID)
                REFERENCES VSAN_HISTORICAL_CLUSTER (CLUSTER_ID),
    constraint FK_GROUP_VHH_GROUPID foreign key(GROUP_ID)
                REFERENCES VSAN_HISTORICAL_GROUP (GROUP_ID),
    constraint FK_TEST_VHH_TESTID foreign key(TEST_ID)
                REFERENCES VSAN_HISTORICAL_TEST (TEST_ID),
    constraint FK_HEALTH_VHH_HEALTHID foreign key(HEALTH_ID)
                REFERENCES VSAN_HISTORICAL_HEALTH_CHECK (HEALTH_ID)
 ) PARTITION BY RANGE (CREATION_TIME) TABLESPACE hs4;
 
 
 
 
 CREATE UNIQUE INDEX IF NOT EXISTS UK_VSAN_HISTORICAL_HEALTH on VSAN_HISTORICAL_HEALTH (
             CLUSTER_ID,
             GROUP_ID,
             TEST_ID,
             CREATION_TIME
 ) TABLESPACE hs4;
 
 INSERT INTO VPX_PATCH_CONTENT VALUES('65184', 'BB');
 /
 
 
 
 
 <65184/>
 
 
 
 
 
 
 
 
 
 DO
 $$ BEGIN
 IF EXISTS (SELECT column_name
              FROM information_schema.columns
             WHERE table_schema='vc'
               AND table_name = lower('VPX_EXT')
               AND column_name = lower('IS_RESTRICTED_USER'))
 THEN
 
 ALTER TABLE IF EXISTS VPX_EXT RENAME COLUMN IS_RESTRICTED_USER TO IS_ONLY_MANAGED_BY_SP_USER;
 
 END IF;
 END $$;
 
 
 
 
 CREATE TABLE IF NOT EXISTS VPX_EXT_UPGRADE(
    STATUS   NUMERIC(1)   DEFAULT 0 not null
 );
 
 DO
 $$
 BEGIN
 
     IF EXISTS ( SELECT 1
                   FROM pg_tables
                  WHERE schemaname = 'vc'
                    AND tablename  = 'vpx_vcdb_ndu_exp_app' )
     THEN
       IF NOT EXISTS ( SELECT CLN_ID
                         FROM VPX_VCDB_NDU_EXP_APP
                        WHERE CLN_ID = 29 )
       THEN
         DELETE FROM VPX_EXT_UPGRADE WHERE STATUS = 0;
         INSERT INTO VPX_EXT_UPGRADE (STATUS) VALUES (0);
       END IF;
     ELSE
       DELETE FROM VPX_EXT_UPGRADE WHERE STATUS = 0;
       INSERT INTO VPX_EXT_UPGRADE (STATUS) VALUES (0);
     END IF;
 END;
 $$;
 
 INSERT INTO VPX_PATCH_CONTENT VALUES(65187,'BB');
 /
 
 
 
 
 <65187/>
 
 
 
 
 
 
 
 
 DO
 $$ BEGIN
 IF NOT EXISTS (SELECT 1
            FROM information_schema.data_type_privileges
            WHERE object_schema = 'vc'
            AND object_name = 'vc_stat_agg_state'
            )
 THEN
    CREATE TYPE vc_stat_agg_state AS (val1 numeric, val2 numeric, type numeric);
 END IF;
 END $$ LANGUAGE plpgsql;
 /
 
 CREATE OR REPLACE FUNCTION vc_stat_agg_transition(agg_state   vc_stat_agg_state,
                                                   val         numeric,
                                                   type        numeric,
                                                   sample_time timestamp)
   RETURNS vc_stat_agg_state
   LANGUAGE plpgsql
   IMMUTABLE
 AS $$
 BEGIN
   IF agg_state.type <> type THEN
     raise exception 'type must have a consistent value for each group';
   END IF;
   IF val IS NULL THEN
     RETURN agg_state;
   END IF;
   IF type < 0 or type > 4 THEN
     RETURN agg_state;
   END IF;
   agg_state.type = type;
   CASE type
     WHEN 0 THEN
       agg_state.val2 := agg_state.val2 + 1;
       agg_state.val1 := coalesce(agg_state.val1, 0) + val;
     WHEN 1 THEN
       IF agg_state.val1 IS NULL OR val > agg_state.val1 THEN agg_state.val1 := val; END IF;
     WHEN 2 THEN
       IF agg_state.val1 IS NULL OR val < agg_state.val1 then agg_state.val1 := val; END IF;
     WHEN 3 THEN
       IF sample_time IS NULL THEN
         RETURN agg_state;
       END IF;
       DECLARE
         etime numeric;
       BEGIN
         etime := extract(epoch FROM sample_time)::numeric;
         IF agg_state.val1 IS NULL OR etime > agg_state.val2 THEN
           agg_state.val1 := val;
           agg_state.val2 := etime;
         END IF;
       END;
     WHEN 4 then
       agg_state.val1 := coalesce(agg_state.val1, 0) + val;
   END case;
   RETURN agg_state;
 END;
 $$;
 /
 
 CREATE OR REPLACE FUNCTION vc_stat_agg_final(agg_state vc_stat_agg_state)
   RETURNS numeric
   LANGUAGE plpgsql
   IMMUTABLE
 AS $$
 BEGIN
   RETURN
     case agg_state.type
       WHEN 0 THEN case when agg_state.val2 >= 1 THEN agg_state.val1 / agg_state.val2 ELSE NULL::numeric END
       WHEN 1 THEN agg_state.val1
       WHEN 2 THEN agg_state.val1
       WHEN 3 THEN agg_state.val1
       WHEN 4 THEN agg_state.val1
       ELSE NULL::numeric
     END;
 End;
 $$;
 /
 
 DO
 $$ BEGIN
 IF NOT EXISTS (SELECT 1
            FROM information_schema.routines
            WHERE routine_schema = 'vc'
            AND routine_name = 'vc_stat_agg'
            )
 THEN
     CREATE AGGREGATE vc_stat_agg(val numeric, type numeric, sample_time timestamp)
     (
       sfunc = vc_stat_agg_transition,
       stype = vc_stat_agg_state,
       finalfunc = vc_stat_agg_final,
       initcond = '(,0,)'
     );
 END IF;
 END $$ LANGUAGE plpgsql;
 /
 
 DROP FUNCTION IF EXISTS stats_rollup1_proc();
 /
 
 DROP FUNCTION IF EXISTS stats_rollup2_proc();
 /
 
 DROP FUNCTION IF EXISTS stats_rollup3_proc();
 /
 
 INSERT INTO VPX_PATCH_CONTENT VALUES(65188,'BB');
 /
 
 
 
 
 <65188/>
 
 
 
 
 
 
 
 
 CREATE TABLE IF NOT EXISTS VPX_HOST_MEMORY_TIER_INFO(
    HOST_ID             BIGINT         NOT NULL,
    MEMORY_TIERING_TYPE VARCHAR(56)    NOT NULL,
    MEMORY_TIER_INFO    TEXT           NOT NULL,
    CONSTRAINT PK_VPX_HOST_MEMORY_TIER_INFO PRIMARY KEY (HOST_ID),
    CONSTRAINT FK_VPX_HOST_MEMORY_TIER_INFO FOREIGN KEY (HOST_ID)
       REFERENCES VPX_HOST (ID) ON DELETE CASCADE
 );
 
 INSERT INTO VPX_PATCH_CONTENT VALUES(65189,'BB');
 /
 
 
 
 
 <65189/>
 
 
 
 
 
 
 
 CREATE TABLE IF NOT EXISTS VPX_VCLS_DRS_WF_COUNTERS(
    EVENT_ID             BIGINT         NOT NULL,
    CLUSTER_ID           BIGINT         NOT NULL,
    INIT_PLACE_COUNT     INT,
    PLACE_MULTIVM_COUNT  INT,
    LB_COUNT             INT,
    HOST_EMM_COUNT       INT,
    CLUSTER_EMM_COUNT    INT,
    XDRS_REC_COUNT       INT,
    RPE_REC_COUNT        INT,
    FIX_VIO_COUNT        INT,
    QUERY_WHATIF_COUNT   INT,
    CONSTRAINT PK_VPX_VCLS_DRS_WF_COUNTERS PRIMARY KEY (EVENT_ID),
    CONSTRAINT FK_VPX_VCLS_DRS_WF_COUNTERS FOREIGN KEY (CLUSTER_ID)
       REFERENCES VPX_ENTITY (ID) ON DELETE CASCADE
 );
 
 INSERT INTO VPX_PATCH_CONTENT VALUES(65191,'BB');
 /
 
 
 
 
 <65191/>
 
 
 
 
 
 
 
 
 ALTER TABLE VPX_TABLE
       ALTER COLUMN TABLE_NAME TYPE VARCHAR(63);
 
 ALTER TABLE VPX_TABLE
       ALTER COLUMN COL_NAME TYPE VARCHAR(63);
 
 INSERT INTO VPX_PATCH_CONTENT VALUES(65190,'BB');
 /
 
 
 
 
 <65190/>
 
 
 
 
 
 
 
 
 ALTER TABLE IF EXISTS VPX_DVS ADD IF NOT EXISTS NETWORK_OFFLOAD_ALLOWED NUMERIC(1) DEFAULT 0 NOT NULL;
 INSERT INTO VPX_PATCH_CONTENT VALUES('65192', 'BB');
 /
 
 
 
 
 <65192/>
 
 
 
 
 
 
 
 
 CREATE TABLE IF NOT EXISTS VPX_VM_OP_NOTIFICATION_CFG (
    CLUSTER_ID                    BIGINT   NOT NULL,
    NOTIFICATION_TIMEOUT          INTEGER,
    CONSTRAINT PK_VPX_VM_OP_NOTIFICATION_CFG PRIMARY KEY (CLUSTER_ID),
    CONSTRAINT FK_VPX_VM_OP_NOTIFICATION_CFG_REF_VPX_ENTITY FOREIGN KEY (CLUSTER_ID)
       REFERENCES VPX_ENTITY (ID)
          ON DELETE CASCADE
 );
 
 INSERT INTO VPX_PATCH_CONTENT VALUES('65193', 'BB');
 /
 
 
 
 
 <65193/>
 
 
 
 
 
 
 
 
 ALTER TABLE IF EXISTS VPX_DVHOST ADD IF NOT EXISTS NETWORK_OFFLOADING_ENABLED NUMERIC(1) DEFAULT 0;
 INSERT INTO VPX_PATCH_CONTENT VALUES('65194', 'BB');
 /
 
 
 
 
 <65194/>
 
 
 
 
 
 
 
 
 CREATE TABLE IF NOT EXISTS VPX_HOST_STATE_ENCRYPTION_INFO(
    HOST_ID                       BIGINT         NOT NULL,
    PROTECTION_MODE               VARCHAR(8)     NOT NULL,
    REQUIRE_SECURE_BOOT           NUMERIC(1),
    REQUIRE_EXEC_INSTALLED_ONLY   NUMERIC(1),
    CONSTRAINT PK_VPX_HOST_STATE_ENCRYPTION_INFO PRIMARY KEY (HOST_ID),
    CONSTRAINT FK_VPX_HOST_STATE_ENCRYPTION_INFO FOREIGN KEY (HOST_ID)
       REFERENCES VPX_HOST (ID) ON DELETE CASCADE
 );
 INSERT INTO VPX_PATCH_CONTENT VALUES('65195', 'BB');
 /
 
 
 
 
 <65195/>
 
 
 
 
 
 
 
 
 ALTER TABLE IF EXISTS VPX_DVS ADD IF NOT EXISTS PREV_VERSION VARCHAR(255);
 INSERT INTO VPX_PATCH_CONTENT VALUES('65196', 'BB');
 /
 
 
 
 
 <65196/>
 
 
 
 
 
 
 
 
 
 ALTER TABLE IF EXISTS VPX_NON_ORM_VM_CONFIG_INFO ADD IF NOT EXISTS CPUID_NUMSMT INTEGER DEFAULT 1 NOT NULL;
 INSERT INTO VPX_PATCH_CONTENT VALUES('65197', 'BB');
 /
 
 
 
 <65197/>
 
 
 
 
 
 
 
 
 ALTER TABLE IF EXISTS VPX_NON_ORM_VM_CONFIG_INFO ADD IF NOT EXISTS CRYPTO_INTEGRITY_PROTECTION_TYPE INTEGER DEFAULT 0;
 ALTER TABLE IF EXISTS VPX_VDEVICE_FILE_BACKING ADD IF NOT EXISTS CRYPTO_INTEGRITY_PROTECTION_TYPE INTEGER DEFAULT 0;
 INSERT INTO VPX_PATCH_CONTENT VALUES('65198', 'BB');
 /
 
 
 
 <65198/>
 
 
 
 
 
 
 
 
 ALTER TABLE IF EXISTS VPX_DVS ADD IF NOT EXISTS NETWORK_OFFLOAD_SPEC_ID VARCHAR(255);
 INSERT INTO VPX_PATCH_CONTENT VALUES('65199', 'BB');
 /
 
 
 
 
 <65199/>
 
 
 
 
 
 
 
 
 DELETE FROM vpx_version;
 INSERT INTO vpx_version VALUES (703, 'VirtualCenter Database 7.0');
 INSERT INTO VPX_PATCH_CONTENT VALUES('65200', 'BB');
 /
 
 
 
 
 <65200/>
 
 
 
 
 
 
 
 
 CREATE TABLE IF NOT EXISTS VPX_CLUSTER_VCLS_DATASTORE (
    CLUSTER_ID       BIGINT                 NOT NULL,
    DATASTORE_ID     BIGINT                 NOT NULL,
    ALLOWMENT        NUMERIC(1)   DEFAULT 0 NOT NULL,
    CONSTRAINT PK_VPX_CLUS_VCLS_DS PRIMARY KEY (DATASTORE_ID, CLUSTER_ID),
    CONSTRAINT FK_VPX_CLUS_VCLS_DS_REF_VPX_COMP_RES FOREIGN KEY (CLUSTER_ID)
          REFERENCES VPX_COMPUTE_RESOURCE (ID)
          ON DELETE CASCADE,
    CONSTRAINT FK_VPX_CLUS_VCLS_DS_REF_VPX_DS FOREIGN KEY (DATASTORE_ID)
          REFERENCES VPX_DATASTORE (ID)
          ON DELETE CASCADE
 );
 /
 
 
 
 
 <65202/>
 
 
 
 
 
 
 
 
 ALTER TABLE IF EXISTS VPX_DVS DROP COLUMN IF EXISTS NETWORK_OFFLOAD_ALLOWED;
 INSERT INTO VPX_PATCH_CONTENT VALUES('65203', 'BB');
 /
 
 
 
 
 <65203/>
 
 
 
 
 
 
 
 
 
 ALTER TABLE IF EXISTS VPX_VM ADD COLUMN IF NOT EXISTS PMEM_SNAPSHOT_MODE VARCHAR(26) null;
 INSERT INTO VPX_PATCH_CONTENT VALUES('65204', 'BB');
 /
 
 
 
 
 <65204/>
 
 
 
 
 
 
 
 
 DROP TABLE IF EXISTS VPX_VM_OP_NOTIFICATION_CFG;
 INSERT INTO VPX_PATCH_CONTENT VALUES('65205', 'BB');
 /
 
 
 
 
 <65205/>
 
 
 
 
 
 
 
 
 ALTER TABLE IF EXISTS VPX_HOST_SGXINFO ADD IF NOT EXISTS SGX_REGISTRATION_INFO TEXT null;
 INSERT INTO VPX_PATCH_CONTENT VALUES('65206', 'BB');
 /
 
 
 
 
 <65206/>
 
 
 
 
 
 
 
 
 
 ALTER TABLE IF EXISTS VPX_COMPUTE_RESOURCE ADD IF NOT EXISTS CONFIG_MANAGER_ENABLED NUMERIC(1) DEFAULT 0 NOT NULL;
 INSERT INTO VPX_PATCH_CONTENT VALUES('65207', 'BB');
 /
 
 
 
 
 <65207/>
 
 
 
 
 
 
 
 
 ALTER TABLE IF EXISTS VPX_VM_SGXINFO ADD IF NOT EXISTS SGX_REQUIRE_ATTESTATION BOOLEAN null;
 INSERT INTO VPX_PATCH_CONTENT VALUES('65208', 'BB');
 /
 
 
 
 
 <65208/>
 
 
 
 
 
 
 
 
 DROP SEQUENCE IF EXISTS VPX_CALLBACK_SERVICE_SEQ;
 DROP INDEX IF EXISTS VPXI_CBK_SERV_UNIQUE_KEY;
 DROP TABLE IF EXISTS VPX_CALLBACK_WHITELIST;
 DROP TABLE IF EXISTS VPX_CALLBACK_SERVICE;
 INSERT INTO VPX_PATCH_CONTENT VALUES('65209', 'BB');
 /
 
 
 
 
 <65209/>
 
 
 
 
 
 
 
 
 CREATE TABLE IF NOT EXISTS VPX_AUTHZ_PRIVILEGES (
    PRIV_ID              INT            NOT NULL,
    PRIV_NAME            VARCHAR(255)   UNIQUE  NOT NULL,
    PRIV_GROUP           VARCHAR(255)   NOT NULL,
    PRIV_VERSION         BIGINT         NOT NULL,
    PRIV_ON_PARENT       BOOLEAN        NOT NULL,
    CONSTRAINT PK_VPX_AUTHZ_PRIVILEGES PRIMARY KEY (PRIV_ID)
 )
 ;
 
 
 
 
 CREATE TABLE IF NOT EXISTS VPX_AUTHZ_ROLES (
    ROLE_ID              BIGINT            NOT NULL,
    ROLE_NAME            VARCHAR(255)      NOT NULL,
    ROLE_VERSION         BIGINT            NOT NULL,
    CONSTRAINT PK_VPX_AUTHZ_ROLES PRIMARY KEY (ROLE_ID)
 )
 ;
 
 
 
 
 CREATE TABLE IF NOT EXISTS VPX_AUTHZ_ROLES_PRIVILEGES (
    ROLE_ID              BIGINT                NOT NULL,
    PRIV_ID              INT                   NOT NULL,
    CONSTRAINT PK_VPX_AUTHZ_ROLES_PRIVILEGES PRIMARY KEY (ROLE_ID, PRIV_ID),
    CONSTRAINT FK_VPX_AUTHZ_ROLES_PRIVILEGES_ROLE FOREIGN KEY (ROLE_ID)
        REFERENCES VPX_AUTHZ_ROLES (ROLE_ID),
    CONSTRAINT FK_VPX_AUTHZ_ROLES_PRIVILEGES_PRIV FOREIGN KEY (PRIV_ID)
        REFERENCES VPX_AUTHZ_PRIVILEGES (PRIV_ID)
 )
 ;
 
 
 
 
 CREATE TABLE IF NOT EXISTS VPX_AUTHZ_GLOBAL_PERMISSIONS (
    PRINCIPAL            VARCHAR(255)      NOT NULL,
    IS_GROUP             BOOLEAN           NOT NULL,
    VERSION              BIGINT            NOT NULL,
    ROLE_ID              BIGINT            NOT NULL,
    CONSTRAINT PK_VPX_AUTHZ_GLOBAL_PERMISSIONS PRIMARY KEY (PRINCIPAL, IS_GROUP),
    CONSTRAINT FK_VPX_AUTHZ_GLOBAL_PERMISSIONS FOREIGN KEY (ROLE_ID)
        REFERENCES VPX_AUTHZ_ROLES (ROLE_ID)
 )
 ;
 
 INSERT INTO VPX_PATCH_CONTENT VALUES('65210', 'BB');
 /
 
 
 
 
 <65210/>
 
 
 
 
 
 
 
 
 ALTER TABLE IF EXISTS VPX_NON_ORM_VM_CONFIG_INFO
       ADD IF NOT EXISTS BOOT_OPTION_NETWORK_PROTOCOL VARCHAR(5) NULL;
 INSERT INTO VPX_PATCH_CONTENT VALUES('65211', 'BB');
 /
 
 
 
 
 <65211/>
 
 
 
 
 
 
 
 
 
 ALTER TABLE IF EXISTS VPX_VM ADD COLUMN IF NOT EXISTS
    GUEST_HEARTBEAT_STATUS NUMERIC(1) default 0 not null
    CONSTRAINT vm_ghb_status_valid_check CHECK (GUEST_HEARTBEAT_STATUS IN (0, 1, 2, 3));
 INSERT INTO VPX_PATCH_CONTENT VALUES('65212', 'BB');
 /
 
 
 
 
 <65212/>
 
 
 
 
 
 
 
 
 ALTER TABLE IF EXISTS VPX_VM
       ADD IF NOT EXISTS INTEGRITY_CHECK_STATE NUMERIC(1) NULL;
 INSERT INTO VPX_PATCH_CONTENT VALUES('65213', 'BB');
 /
 
 
 
 
 <65213/>
 
 
 
 
