DROP TABLE IF EXISTS MGRD_EXP_TABLES_COLUMNS;
 /
 
 CREATE TABLE MGRD_EXP_TABLES_COLUMNS (
    TABLE_NAME VARCHAR(50),
    COLUMN_NAME VARCHAR(50),
    TYPE CHAR(1),
    DATA_TYPE VARCHAR(50),
    DATA_SIZE INT,
    IS_NULLABLE VARCHAR(5),
    COLUMN_DEFAULT VARCHAR(100)
 );
 /
 
 
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_access','id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_access','principal','T','character varying',300,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_access','role_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_access','entity_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_access','flag','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_access','surr_key','T','integer',32,'NO','nextval(''vpx_access_surr_key_seq''::regclass)');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_alarm','alarm_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_alarm','name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_alarm','system_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_alarm','description','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_alarm','enabled','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_alarm','setting_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_alarm','entity_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_alarm','entity_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_alarm','lastmodifiedtime','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_alarm','lastmodifieduser','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_alarm','creation_event_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_alarm','action_frequency','T','numeric',10,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_alarm','trigger_only','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_alarm','alarm_metadata','T','character varying',2000,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_alarm_action','alarm_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_alarm_action','action_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_alarm_action','parent_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_alarm_action','alarm_action_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_alarm_action','green2yellow','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_alarm_action','red2yellow','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_alarm_action','yellow2green','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_alarm_action','yellow2red','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_alarm_action','action_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_alarm_action','action_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_alarm_action','green2yellow_repeat_flg','T','numeric',1,'NO','0');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_alarm_action','red2yellow_repeat_flg','T','numeric',1,'NO','0');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_alarm_action','yellow2green_repeat_flg','T','numeric',1,'NO','0');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_alarm_action','yellow2red_repeat_flg','T','numeric',1,'NO','0');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_alarm_disabled_actions','entity_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_alarm_disabled_actions','entity_type','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_alarm_expr_comp','alarm_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_alarm_expr_comp','expression_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_alarm_expr_comp','attribute_name','T','character varying',255,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_alarm_expr_comp','operator_type','T','character varying',20,'NO','''equals''::character varying');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_alarm_expr_comp','attribute_value','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_alarm_expr_comp','surr_key','T','integer',32,'NO','nextval(''vpx_alarm_expr_comp_surr_key_seq''::regclass)');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_alarm_expression','alarm_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_alarm_expression','expression_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_alarm_expression','parent_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_alarm_expression','expression_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_alarm_expression','object_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_alarm_expression','object_path','T','character varying',1000,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_alarm_expression','operator','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_alarm_expression','red','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_alarm_expression','yellow','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_alarm_expression','new_status','T','character varying',10,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_alarm_expression','red_interval','T','numeric',5,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_alarm_expression','yellow_interval','T','numeric',5,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_alarm_repeat_action','entity_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_alarm_repeat_action','alarm_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_alarm_repeat_action','entity_type','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_alarm_repeat_action','new_status','T','character varying',50,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_alarm_repeat_action','old_status','T','character varying',50,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_alarm_repeat_action','trig_summary','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_alarm_repeat_action','decl_summary','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_alarm_repeat_action','event_desc','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_alarm_repeat_action','event_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_alarm_runtime','entity_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_alarm_runtime','alarm_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_alarm_runtime','entity_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_alarm_runtime','expression_name','T','character varying',440,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_alarm_runtime','state_value','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_alarm_runtime','metric_value','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_alarm_runtime','created_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_alarm_runtime','status_value','T','character varying',50,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_alarm_runtime','event_key','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_alarm_state','entity_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_alarm_state','alarm_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_alarm_state','alarm_overriden','T','numeric',1,'NO','0');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_alarm_state','override_user','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_alarm_state','override_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_alarm_state','alarm_acknowledged','T','numeric',1,'NO','0');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_alarm_state','ack_user','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_alarm_state','ack_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_alarm_state','repeat_trigger','T','numeric',1,'NO','0');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_binary_data','id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_binary_data','data_type','T','character varying',255,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_binary_data','bin_data','T','bytea',0,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_binary_data','created_time','T','timestamp with time zone',0,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_binary_data','change_id','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_callback_service','id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_callback_service','wsdl_name','T','character varying',50,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_callback_service','url_string','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_callback_whitelist','serv_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_callback_whitelist','moid','T','character varying',127,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_change_tag','change_tag_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_change_tag','change_tag_val','T','character varying',255,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_cluster_iofilters','cluster_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_cluster_iofilters','agency_ref','T','character varying',128,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_cluster_iofilters','op_type','T','character varying',128,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compliance_status','compliance_status_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compliance_status','profile_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compliance_status','entity_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compliance_status','status_cd','T','numeric',3,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compliance_status','created_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compliance_status','failure_info','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_res_failover_host','comp_res_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_res_failover_host','host_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_res_user_hb_ds','comp_res_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_res_user_hb_ds','ds_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource','id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource','resource_group_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource','resource_type','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource','summary','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource','vm_swap_placement','T','integer',32,'NO','1');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource','spbm_enabled','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource','das_enabled','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource','failover_level','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource','strict_admission_control','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource','das_options','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource','drs_enabled','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource','default_vm_behavior','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource','vmotion_rate','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource','drs_options','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource','rules_info','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource','dpm_enabled_flg','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource','default_host_behavior','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource','default_das_priority','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource','power_off_on_isolation','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource','dpm_options','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource','evc_mode','T','character varying',30,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource','vmhealth_vm_monitoring','T','integer',32,'NO','0');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource','vmhealth_failure_interval','T','integer',32,'NO','30');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource','vmhealth_min_uptime','T','integer',32,'NO','120');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource','vmhealth_max_failures','T','integer',32,'NO','3');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource','vmhealth_max_failure_window','T','integer',32,'NO','(-1)');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource','failover_cpu_resources','T','numeric',3,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource','failover_mem_resources','T','numeric',3,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource','host_power_action_rate','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource','drs_vm_overrides_enabled_flg','T','numeric',1,'NO','1');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource','das_host_monitoring','T','numeric',1,'YES','1');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource','das_vm_monitoring','T','integer',32,'YES','0');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource','cluster_state','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource','cluster_config_version','T','numeric',22,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource','das_vm_metadata_version','T','numeric',22,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource','das_hostlist_version','T','numeric',22,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource','das_fault_domain_id','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource','das_vm_comp_protecting','T','character varying',30,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource','vmcp_apd_terminate','T','character varying',30,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource','vmcp_apd_terminate_delay','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource','vmcp_apd_reset','T','character varying',30,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource','vmcp_pdl_terminate','T','character varying',30,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource','allow_sys_update_hb_ds','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource','groups_info','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource','num_required_agent_vms','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource','das_metrocluster_enabled','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource','slot_policy','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource','default_hw_version','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource','vsan_enabled','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource','vsan_auto_claim_storage','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource','vsan_uuid','T','character varying',36,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource','vsan_checksum_enabled','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource','das_restart_priority_timeout','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource','orc_ready_condition','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource','orc_post_ready_delay','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource','failover_resource_reduction','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource','failover_resource_auto_compute','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource','proactive_drs_enabled','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource_das_vm','comp_res_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource_das_vm','vm_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource_das_vm','priority','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource_das_vm','num_failure','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource_das_vm','retry_period_sec','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource_das_vm','power_off_on_isolation','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource_das_vm','vmhealth_vm_monitoring','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource_das_vm','vmhealth_failure_interval','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource_das_vm','vmhealth_min_uptime','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource_das_vm','vmhealth_max_failures','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource_das_vm','vmhealth_max_failure_window','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource_das_vm','vmcp_apd_terminate','T','character varying',30,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource_das_vm','vmcp_apd_terminate_delay','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource_das_vm','vmcp_apd_reset','T','character varying',30,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource_das_vm','vmcp_pdl_terminate','T','character varying',30,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource_das_vm','restart_priority_timeout_vm','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource_dpm_host','comp_res_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource_dpm_host','host_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource_dpm_host','dpm_enabled_override_flg','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource_dpm_host','host_behavior_override','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource_drs_vm','comp_res_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource_drs_vm','vm_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource_drs_vm','enabled','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource_drs_vm','behavior','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource_orc_vm','comp_res_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource_orc_vm','vm_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource_orc_vm','orc_ready_condition_vm','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource_orc_vm','orc_post_ready_delay_vm','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource_vsan_host','comp_res_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource_vsan_host','host_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource_vsan_host','node_uuid','T','character varying',36,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource_vsan_host','cluster_uuid','T','character varying',36,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource_vsan_host','autoclaim_storage','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource_vsan_host','enabled','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource_vsan_host','fault_domain','T','character varying',256,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_compute_resource_vsan_host','checksum_enabled','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_config_issue','entity_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_config_issue','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_config_issue','cfg_issue_type','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_crypto_kmip_cluster','cluster_id','T','character varying',255,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_crypto_kmip_cluster','use_as_default','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_crypto_server','cluster_id','T','character varying',255,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_crypto_server','name','T','character varying',255,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_crypto_server','address','T','character varying',255,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_crypto_server','port','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_crypto_server','proxy_address','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_crypto_server','proxy_port','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_crypto_server','reconnect','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_crypto_server','protocol','T','character varying',127,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_crypto_server','nbio','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_crypto_server','timeout','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_crypto_server','user_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_customization_spec','name','T','character varying',255,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_customization_spec','type','T','character varying',255,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_customization_spec','description','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_customization_spec','body','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_customization_spec','change_version','T','character varying',255,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_customization_spec','last_update_time','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_das_hb_datastore_sys','comp_res_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_das_hb_datastore_sys','datastore_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_das_hb_datastore_sys','host_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_datacenter','id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_datacenter','default_hw_version','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_datastore','id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_datastore','name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_datastore','storage_url','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_datastore','capacity','T','character varying',21,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_datastore','free_space','T','character varying',21,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_datastore','type','T','character varying',128,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_datastore','info','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_datastore','capability','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_datastore','datacenter_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_datastore','iorm_enabled','T','numeric',1,'YES','0');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_datastore','iorm_congestion_threshold','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_datastore','maintenance_mode','T','integer',32,'NO','0');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_datastore','thin_prov_space_flag','T','numeric',1,'NO','0');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_datastore','iorm_congestion_thresh_mode','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_datastore','iorm_percent_of_peak_thrp','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_datastore','iorm_stats_enabled','T','numeric',1,'YES','0');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_datastore_info','id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_datastore_info','drs_unfair_threshold','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_datastore_info','free_space','T','character varying',21,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_datastore_info','max_file_size','T','character varying',21,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_datastore_info','max_memory_file_size','T','numeric',22,'NO','70368744177664::bigint');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_datastore_info','max_physical_rdm_file_size','T','numeric',22,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_datastore_info','max_virtual_rdm_file_size','T','numeric',22,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_datastore_info','name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_datastore_info','timestamp','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_datastore_info','url','T','character varying',440,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_datastore_info','path','T','character varying',512,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_datastore_info','remote_host','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_datastore_info','remote_path','T','character varying',512,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_datastore_info','user_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_datastore_info','array_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_datastore_info','security_type','T','character varying',512,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_datastore_info','blocksize_mb','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_datastore_info','forcemount_flg','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_datastore_info','forcemount_persist_flg','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_datastore_info','major_version','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_datastore_info','vmfs_uuid','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_datastore_info','vmfs_version','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_datastore_info','vmfs_upgradeable','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_datastore_info','vmfs_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_datastore_info','vmfs_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_datastore_info','vmfs_capacity','T','numeric',38,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_datastore_info','vmfs_max_blocks','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_datastore_info','vmfs_ssd_flg','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_datastore_info','vpx_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_datastore_info','vvol_uuid','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dbm_counter_metadata','counter_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dbm_counter_metadata','name','T','character varying',100,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dbm_counter_metadata','object_name','T','character varying',100,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dbm_counter_metadata','unit','T','character varying',30,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dbm_counter_metadata','keep_days','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dbm_counter_metadata','description','T','character varying',1000,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dbm_counter_metadata','solution','T','character varying',1000,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dbm_counter_metadata','sql_statement','T','character varying',4000,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dbm_counter_metadata','range_type','T','character varying',30,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dbm_counter_metadata','range_min','T','numeric',22,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dbm_counter_metadata','range_max','T','numeric',22,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dbm_counter_value','counter_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dbm_counter_value','sample_time','T','timestamp without time zone',0,'NO','now()');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dbm_counter_value','counter_value','T','numeric',22,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_device','device_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_device','device_name','T','character varying',450,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_disabled_methods','entity_mo_id_val','T','character varying',255,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_disabled_methods','method_name','T','character varying',50,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_disabled_methods','source_id_val','T','character varying',50,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_disabled_methods','reason_id_val','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ds_assignment','ds_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ds_assignment','entity_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ds_assignment','accessible','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ds_assignment','mount_path','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ds_assignment','mount_id','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ds_assignment','mount_mode','T','character varying',21,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ds_assignment','mounted','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dual','dummy','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvhost','dvs_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvhost','host_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvhost','max_port','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvhost','current_max_port','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvhost','product_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvhost','product_vendor','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvhost','product_version','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvhost','product_build','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvhost','vswitch_key','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvhost','status','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvhost','status_detail','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvhost','has_shadow_ports','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvhost_hc_mtu_result','dvs_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvhost_hc_mtu_result','host_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvhost_hc_mtu_result','uplink_port_key','T','character varying',50,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvhost_hc_mtu_result','supported_flg','T','numeric',1,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvhost_hc_mtu_result','vlan_id_start','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvhost_hc_mtu_result','vlan_id_end','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvhost_hc_mtu_result','surr_key','T','integer',32,'NO','nextval(''vpx_dvhost_hc_mtu_result_surr_key_seq''::regclass)');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvhost_hc_result','dvs_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvhost_hc_result','host_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvhost_hc_result','uplink_port_key','T','character varying',50,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvhost_hc_result','healthcheck_type','T','character varying',255,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvhost_hc_result','summary','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvhost_hc_result','teaming_match_status','T','character varying',50,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvhost_hc_result','pnic_mtu_match_status','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvhost_hc_result','surr_key','T','integer',32,'NO','nextval(''vpx_dvhost_hc_result_surr_key_seq''::regclass)');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvhost_hc_vlan_result','dvs_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvhost_hc_vlan_result','host_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvhost_hc_vlan_result','uplink_port_key','T','character varying',50,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvhost_hc_vlan_result','trunked_flg','T','numeric',1,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvhost_hc_vlan_result','vlan_id_start','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvhost_hc_vlan_result','vlan_id_end','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvhost_hc_vlan_result','surr_key','T','integer',32,'NO','nextval(''vpx_dvhost_hc_vlan_result_surr_key_seq''::regclass)');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvhost_out_of_sync','dvs_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvhost_out_of_sync','host_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvhost_out_of_sync','property_name','T','character varying',255,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport','dvs_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport','dvport_key','T','character varying',50,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport','name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport','description','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport','config_version','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport','link_up','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport','link_blocked','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport','proxy_host','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport','trunk_mode_flg','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport','conflict_flg','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport','conflict_port_key','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport','connection_cookie','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport','last_status_change','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport','mtu','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport','link_peer','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport','mac_address','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport','status_detail','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport','stats_packet_in_multicast','T','character varying',50,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport','stats_packet_out_multicast','T','character varying',50,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport','stats_byte_in_multicast','T','character varying',50,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport','stats_byte_out_multicast','T','character varying',50,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport','stats_packet_in_unicast','T','character varying',50,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport','stats_packet_out_unicast','T','character varying',50,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport','stats_byte_in_unicast','T','character varying',50,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport','stats_byte_out_unicast','T','character varying',50,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport','stats_packet_in_broadcast','T','character varying',50,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport','stats_packet_out_broadcast','T','character varying',50,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport','stats_byte_in_broadcast','T','character varying',50,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport','stats_byte_out_broadcast','T','character varying',50,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport','stats_packet_in_dropped','T','character varying',50,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport','stats_packet_out_dropped','T','character varying',50,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport','stats_packet_in_exception','T','character varying',50,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport','stats_packet_out_exception','T','character varying',50,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport','persistence_location','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport','connectee','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport','connectee_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport','connectee_nic_key','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport','connectee_address','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport','reserved_time','T','character varying',50,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport','powering_on_flg','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport','last_connectee','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport','npt_active','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport','npt_inactive_net','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport','npt_inactive_other','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport','npt_inactive_misc','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport','repush_needed_flg','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport','host_local_port_flg','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport_membership','dvport_key','T','character varying',50,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport_membership','dvs_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport_membership','dvportgroup_id','T','integer',32,'NO','0');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport_membership','host_id','T','integer',32,'NO','0');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport_membership','lag_key','T','character varying',50,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport_setting','dvs_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport_setting','dvportgroup_id','T','integer',32,'NO','0');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport_setting','dvport_key','T','character varying',50,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport_setting','blocked_flg','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport_setting','nrp_key','T','character varying',50,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport_setting','in_shaping_object_flg','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport_setting','in_shaping_avg_bandwidth','T','character varying',50,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport_setting','in_shaping_burst_size','T','character varying',50,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport_setting','in_shaping_enabled','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport_setting','in_shaping_peak_bandwidth','T','character varying',50,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport_setting','out_shaping_object_flg','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport_setting','out_shaping_avg_bandwidth','T','character varying',50,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport_setting','out_shaping_burst_size','T','character varying',50,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport_setting','out_shaping_enabled','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport_setting','out_shaping_peak_bandwidth','T','character varying',50,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport_setting','vlan_object_flg','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport_setting','vlan_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport_setting','trunk_mode_flg','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport_setting','pvlan_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport_setting','qos_tag','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport_setting','tx_uplink','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport_setting','ipfix_object_flg','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport_setting','ipfix_enabled','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport_setting','sec_policy_object_flg','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport_setting','allow_promiscuous','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport_setting','forged_transmits','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport_setting','mac_changes','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport_setting','teaming_object_flg','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport_setting','teaming_policy','T','character varying',50,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport_setting','teaming_reverse','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport_setting','teaming_notify','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport_setting','teaming_rolling','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport_setting','criteria_object_flg','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport_setting','teaming_fail_chk_beacon','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport_setting','teaming_fail_chk_duplex','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport_setting','teaming_fail_chk_percent','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport_setting','teaming_fail_chk_speed','T','character varying',50,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport_setting','teaming_fail_duplex','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport_setting','teaming_fail_percent','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport_setting','teaming_fail_speed','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport_setting','uplink_order_object_flg','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport_setting','vendor_blob_object_flg','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport_setting','overlay_object_flg','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport_setting','npt_allowed_flg','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport_setting','lacp_enable','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport_setting','lacp_mode','T','character varying',50,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport_setting','traffic_filter_obj_flg','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport_setting','surr_key','T','integer',32,'NO','nextval(''vpx_dvport_setting_surr_key_seq''::regclass)');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport_vlan','dvs_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport_vlan','dvportgroup_id','T','integer',32,'NO','0');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport_vlan','dvport_key','T','character varying',50,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport_vlan','runtimeinfo_flg','T','numeric',1,'NO','0');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport_vlan','vlan_id_start','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport_vlan','vlan_id_end','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvport_vlan','surr_key','T','integer',32,'NO','nextval(''vpx_dvport_vlan_surr_key_seq''::regclass)');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvportgroup','id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvportgroup','dvs_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvportgroup','dvportgroup_name','T','character varying',255,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvportgroup','dvportgroup_key','T','character varying',255,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvportgroup','dvportgroup_type','T','character varying',255,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvportgroup','description','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvportgroup','port_name_format','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvportgroup','policy_block_override','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvportgroup','policy_nrp_override','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvportgroup','policy_shaping_override','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvportgroup','policy_blob_override','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvportgroup','policy_live_port_move','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvportgroup','policy_reset_at_connect','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvportgroup','policy_overlay_override','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvportgroup','traffic_filter_override','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvportgroup','num_port','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvportgroup','uplink_portgroup_flg','T','numeric',1,'YES','0');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvportgroup','policy_vlan_override','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvportgroup','policy_uplink_override','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvportgroup','policy_security_override','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvportgroup','policy_ipfix_override','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvportgroup','auto_expand','T','numeric',1,'NO','0');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvportgroup','config_num_port','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvportgroup','vmvnic_resourcepool_key','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs','id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs','datacenter_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs','name','T','character varying',255,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs','uuid','T','character varying',255,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs','description','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs','num_port','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs','num_standalone_port','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs','max_port','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs','product_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs','product_vendor','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs','product_version','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs','product_build','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs','product_bundle_id','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs','product_bundle_url','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs','product_forwarding_class','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs','upgrade_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs','upgrade_vendor','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs','upgrade_version','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs','upgrade_build','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs','upgrade_bundle_id','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs','upgrade_bundle_url','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs','upgrade_forwarding_class','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs','upgrade_status','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs','extension_key','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs','owner','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs','contact','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs','ip_address','T','character varying',50,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs','policy_auto_preinstall','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs','policy_auto_upgrade','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs','policy_partial_upgrade','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs','network_resource_mgmt_enabled','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs','capab_dvs_operation','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs','capab_dvportgroup_operation','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs','capab_dvport_operation','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs','upgrade_mode','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs','port_counter','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs','vspan_key_counter','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs','vspan_dup_check','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs','max_mtu','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs','promiscuous_vspan','T','character varying',50,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs','ldp_protocol_type','T','character varying',50,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs','ldp_operation','T','character varying',50,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs','default_proxyswitch_max_ports','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs','feature_capab_vmdirectpath','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs','lacp_api_version','T','character varying',50,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs','network_resource_ctrl_version','T','character varying',50,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs','multicast_filtering_mode','T','character varying',50,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_blob','dvs_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_blob','dvportgroup_id','T','integer',32,'NO','0');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_blob','dvport_key','T','character varying',50,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_blob','host_id','T','integer',32,'NO','0');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_blob','property_path','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_blob','blob_key','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_blob','blob_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_blob','surr_key','T','integer',32,'NO','nextval(''vpx_dvs_blob_surr_key_seq''::regclass)');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_compatible','id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_compatible','product_line','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_compatible','product_version','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_compatible','surr_key','T','integer',32,'NO','nextval(''vpx_dvs_compatible_surr_key_seq''::regclass)');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_hc_config','dvs_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_hc_config','healthcheck_type','T','character varying',255,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_hc_config','enable','T','numeric',1,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_hc_config','interval','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_hc_config','surr_key','T','integer',32,'NO','nextval(''vpx_dvs_hc_config_surr_key_seq''::regclass)');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_infra_res_pool','dvs_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_infra_res_pool','nrp_key','T','character varying',50,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_infra_res_pool','description','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_infra_res_pool','allocation_limit','T','numeric',22,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_infra_res_pool','allocation_shares_shares','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_infra_res_pool','allocation_shares_level','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_infra_res_pool','allocation_reservation','T','numeric',22,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_infra_res_pool','surr_key','T','integer',32,'NO','nextval(''vpx_dvs_infra_res_pool_surr_key_seq''::regclass)');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_ipfix','dvs_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_ipfix','collector_ip','T','character varying',50,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_ipfix','collector_port','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_ipfix','active_flow_timeout','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_ipfix','idle_flow_timeout','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_ipfix','sampling_rate','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_ipfix','internal_flows_only','T','numeric',1,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_ipfix','observation_domain_id','T','bigint',64,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_ipfix','surr_key','T','integer',32,'NO','nextval(''vpx_dvs_ipfix_surr_key_seq''::regclass)');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_lag','dvs_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_lag','lag_key','T','character varying',50,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_lag','name','T','character varying',255,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_lag','lag_mode','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_lag','uplink_num','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_lag','loadbalance_algorithm','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_lag','ipfix_enabled','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_lag','surr_key','T','integer',32,'NO','nextval(''vpx_dvs_lag_surr_key_seq''::regclass)');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_lag_vlan','dvs_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_lag_vlan','lag_key','T','character varying',50,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_lag_vlan','vlan_id_start','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_lag_vlan','vlan_id_end','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_lag_vlan','surr_key','T','integer',32,'NO','nextval(''vpx_dvs_lag_vlan_surr_key_seq''::regclass)');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_nrp','dvs_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_nrp','nrp_key','T','character varying',50,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_nrp','name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_nrp','description','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_nrp','config_version','T','numeric',21,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_nrp','ptag','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_nrp','allocation_limit','T','numeric',21,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_nrp','allocation_shares_shares','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_nrp','allocation_shares_level','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_opaque_data','dvs_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_opaque_data','dvportgroup_id','T','integer',32,'NO','0');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_opaque_data','dvport_key','T','character varying',50,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_opaque_data','host_id','T','integer',32,'NO','0');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_opaque_data','is_runtime','T','numeric',1,'NO','0');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_opaque_data','is_inherited_type','T','numeric',1,'NO','0');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_opaque_data','opaque_key','T','character varying',255,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_opaque_data','opaque_data','T','bytea',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_opaque_data','surr_key','T','integer',32,'NO','nextval(''vpx_dvs_opaque_data_surr_key_seq''::regclass)');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_overlay_instance','dvs_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_overlay_instance','instance_key','T','character varying',255,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_overlay_instance','instance_depth','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_overlay_instance','overlay_class','T','character varying',255,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_overlay_instance','surr_key','T','integer',32,'NO','nextval(''vpx_dvs_overlay_instance_surr_key_seq''::regclass)');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_pvlan','dvs_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_pvlan','primary_vlanid','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_pvlan','secondary_vlanid','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_pvlan','pvlan_type','T','character varying',50,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_pvlan','surr_key','T','integer',32,'NO','nextval(''vpx_dvs_pvlan_surr_key_seq''::regclass)');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_rule','ruleset_key','T','character varying',100,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_rule','rule_key','T','character varying',100,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_rule','description','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_rule','sequence','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_rule','rule_direction','T','character varying',50,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_rule','qos_tag','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_rule','dscp_tag','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_rule','packets_per_second','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_rule','encap_ip','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_rule','rewrite_mac','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_rule','divert_option','T','character varying',50,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_rule','service_id','T','character varying',50,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_rule','jump_ruleset_key','T','character varying',100,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_rule','forward_port_key','T','character varying',50,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_rule','action_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_rule_qualifier','rule_key','T','character varying',100,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_rule_qualifier','qualifier_key','T','character varying',100,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_rule_qualifier','src_ip_address','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_rule_qualifier','src_ip_not_flg','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_rule_qualifier','src_ip_prefix_length','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_rule_qualifier','src_ip_container_id','T','character varying',50,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_rule_qualifier','src_ip_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_rule_qualifier','dst_ip_address','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_rule_qualifier','dst_ip_not_flg','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_rule_qualifier','dst_ip_prefix_length','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_rule_qualifier','dst_ip_container_id','T','character varying',50,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_rule_qualifier','dst_ip_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_rule_qualifier','l3_l4_protocol','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_rule_qualifier','l3_l4_protocol_not_flg','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_rule_qualifier','src_port_num_start','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_rule_qualifier','src_port_num_end','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_rule_qualifier','src_port_container_id','T','character varying',50,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_rule_qualifier','src_port_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_rule_qualifier','src_port_not_flg','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_rule_qualifier','dst_port_num_start','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_rule_qualifier','dst_port_num_end','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_rule_qualifier','dst_port_container_id','T','character varying',50,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_rule_qualifier','dst_port_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_rule_qualifier','dst_port_not_flg','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_rule_qualifier','tcp_flags','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_rule_qualifier','tcp_flags_not_flg','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_rule_qualifier','src_mac_address','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_rule_qualifier','src_mac_mask','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_rule_qualifier','src_mac_container_id','T','character varying',50,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_rule_qualifier','src_mac_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_rule_qualifier','src_mac_not_flg','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_rule_qualifier','dst_mac_address','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_rule_qualifier','dst_mac_mask','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_rule_qualifier','dst_mac_container_id','T','character varying',50,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_rule_qualifier','dst_mac_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_rule_qualifier','dst_mac_not_flg','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_rule_qualifier','l2_protocol','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_rule_qualifier','l2_protocol_not_flg','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_rule_qualifier','vlan_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_rule_qualifier','vlan_id_not_flg','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_rule_qualifier','type_of_system_traffic','T','character varying',50,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_rule_qualifier','system_traffic_not_flg','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_rule_qualifier','qualifier_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_ruleset','ruleset_key','T','character varying',100,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_ruleset','enabled','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_ruleset','precedence','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_scope','dvs_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_scope','dvportgroup_id','T','integer',32,'NO','0');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_scope','dvport_key','T','character varying',50,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_scope','scope','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_scope','surr_key','T','integer',32,'NO','nextval(''vpx_dvs_scope_surr_key_seq''::regclass)');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_traffic_filter_config','dvs_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_traffic_filter_config','dvportgroup_id','T','integer',32,'NO','0');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_traffic_filter_config','dvport_key','T','character varying',50,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_traffic_filter_config','config_key','T','character varying',100,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_traffic_filter_config','agent_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_traffic_filter_config','on_failure','T','character varying',50,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_traffic_filter_config','ruleset_key','T','character varying',100,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_traffic_filter_config','config_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_traffic_filter_config','surr_key','T','integer',32,'NO','nextval(''vpx_dvs_traffic_filter_config_surr_key_seq''::regclass)');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_traffic_filter_param','dvs_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_traffic_filter_param','dvportgroup_id','T','integer',32,'NO','0');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_traffic_filter_param','dvport_key','T','character varying',50,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_traffic_filter_param','config_key','T','character varying',100,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_traffic_filter_param','param','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_traffic_filter_param','surr_key','T','integer',32,'NO','nextval(''vpx_dvs_traffic_filter_param_surr_key_seq''::regclass)');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_uplink','id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_uplink','uplink_port_name','T','character varying',255,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_uplink','uplink_index','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_uplink','surr_key','T','integer',32,'NO','nextval(''vpx_dvs_uplink_surr_key_seq''::regclass)');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_vmvnic_res_pool','dvs_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_vmvnic_res_pool','nrp_key','T','character varying',50,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_vmvnic_res_pool','description','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_vmvnic_res_pool','name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_vmvnic_res_pool','config_version','T','numeric',22,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_vmvnic_res_pool','allocation_reservation','T','numeric',22,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_vmvnic_res_pool','surr_key','T','integer',32,'NO','nextval(''vpx_dvs_vmvnic_res_pool_surr_key_seq''::regclass)');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_vspan_ports','dvs_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_vspan_ports','vspan_session_key','T','character varying',50,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_vspan_ports','port_use','T','character varying',255,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_vspan_ports','port_identifier_type','T','character varying',255,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_vspan_ports','port_identifier_value','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_vspan_ports','vlan_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_vspan_ports','ip_address','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_vspan_ports','surr_key','T','integer',32,'NO','nextval(''vpx_dvs_vspan_ports_surr_key_seq''::regclass)');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_vspan_session','dvs_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_vspan_session','vspan_session_key','T','character varying',50,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_vspan_session','session_type','T','character varying',255,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_vspan_session','name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_vspan_session','description','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_vspan_session','session_enabled','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_vspan_session','encapsulation_vlanid','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_vspan_session','strip_original_vlan','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_vspan_session','mirrored_packet_length','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_vspan_session','normal_traffic_allowed','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_vspan_session','sampling_rate','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_vspan_session','encap_type','T','character varying',50,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_vspan_session','erspan_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_vspan_session','erspan_cos','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_vspan_session','erspan_gra_nanosec','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_dvs_vspan_session','surr_key','T','integer',32,'NO','nextval(''vpx_dvs_vspan_session_surr_key_seq''::regclass)');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_entity','id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_entity','name','T','character varying',255,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_entity','type_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_entity','parent_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_entity_last_event','entity_id','T','integer',32,'NO','0');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_entity_last_event','event_type','T','character varying',255,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_entity_last_event','last_event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_entity_vmop_count','id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_entity_vmop_count','poweron_count','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_entity_vmop_count','poweroff_count','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_entity_vmop_count','suspend_count','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_entity_vmop_count','reset_count','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_entity_vmop_count','rebootguest_count','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_entity_vmop_count','standbyguest_count','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_entity_vmop_count','shutdownguest_count','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_entity_vmop_count','create_count','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_entity_vmop_count','destroy_count','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_entity_vmop_count','register_count','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_entity_vmop_count','unregister_count','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_entity_vmop_count','reconfigure_count','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_entity_vmop_count','clone_count','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_entity_vmop_count','deploy_count','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_entity_vmop_count','changehost_count','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_entity_vmop_count','changeds_count','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_entity_vmop_count','changehostds_count','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_entity_vmop_count','vmotion_count','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_entity_vmop_count','svmotion_count','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_entity_vmop_count','xvmotion_count','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_1','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_1','chain_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_1','event_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_1','extended_class','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_1','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_1','username','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_1','category','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_1','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_1','vm_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_1','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_1','host_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_1','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_1','computeresource_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_1','computeresource_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_1','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_1','datacenter_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_1','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_1','datastore_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_1','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_1','network_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_1','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_1','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_1','dvs_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_1','storagepod_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_1','storagepod_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_1','change_tag_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_10','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_10','chain_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_10','event_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_10','extended_class','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_10','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_10','username','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_10','category','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_10','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_10','vm_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_10','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_10','host_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_10','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_10','computeresource_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_10','computeresource_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_10','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_10','datacenter_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_10','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_10','datastore_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_10','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_10','network_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_10','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_10','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_10','dvs_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_10','storagepod_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_10','storagepod_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_10','change_tag_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_11','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_11','chain_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_11','event_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_11','extended_class','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_11','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_11','username','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_11','category','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_11','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_11','vm_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_11','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_11','host_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_11','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_11','computeresource_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_11','computeresource_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_11','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_11','datacenter_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_11','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_11','datastore_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_11','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_11','network_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_11','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_11','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_11','dvs_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_11','storagepod_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_11','storagepod_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_11','change_tag_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_12','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_12','chain_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_12','event_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_12','extended_class','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_12','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_12','username','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_12','category','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_12','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_12','vm_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_12','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_12','host_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_12','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_12','computeresource_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_12','computeresource_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_12','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_12','datacenter_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_12','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_12','datastore_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_12','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_12','network_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_12','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_12','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_12','dvs_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_12','storagepod_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_12','storagepod_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_12','change_tag_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_13','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_13','chain_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_13','event_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_13','extended_class','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_13','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_13','username','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_13','category','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_13','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_13','vm_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_13','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_13','host_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_13','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_13','computeresource_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_13','computeresource_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_13','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_13','datacenter_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_13','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_13','datastore_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_13','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_13','network_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_13','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_13','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_13','dvs_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_13','storagepod_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_13','storagepod_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_13','change_tag_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_14','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_14','chain_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_14','event_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_14','extended_class','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_14','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_14','username','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_14','category','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_14','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_14','vm_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_14','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_14','host_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_14','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_14','computeresource_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_14','computeresource_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_14','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_14','datacenter_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_14','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_14','datastore_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_14','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_14','network_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_14','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_14','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_14','dvs_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_14','storagepod_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_14','storagepod_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_14','change_tag_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_15','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_15','chain_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_15','event_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_15','extended_class','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_15','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_15','username','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_15','category','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_15','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_15','vm_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_15','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_15','host_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_15','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_15','computeresource_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_15','computeresource_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_15','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_15','datacenter_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_15','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_15','datastore_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_15','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_15','network_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_15','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_15','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_15','dvs_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_15','storagepod_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_15','storagepod_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_15','change_tag_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_16','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_16','chain_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_16','event_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_16','extended_class','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_16','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_16','username','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_16','category','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_16','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_16','vm_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_16','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_16','host_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_16','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_16','computeresource_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_16','computeresource_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_16','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_16','datacenter_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_16','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_16','datastore_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_16','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_16','network_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_16','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_16','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_16','dvs_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_16','storagepod_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_16','storagepod_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_16','change_tag_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_17','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_17','chain_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_17','event_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_17','extended_class','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_17','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_17','username','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_17','category','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_17','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_17','vm_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_17','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_17','host_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_17','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_17','computeresource_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_17','computeresource_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_17','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_17','datacenter_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_17','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_17','datastore_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_17','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_17','network_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_17','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_17','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_17','dvs_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_17','storagepod_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_17','storagepod_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_17','change_tag_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_18','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_18','chain_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_18','event_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_18','extended_class','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_18','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_18','username','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_18','category','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_18','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_18','vm_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_18','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_18','host_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_18','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_18','computeresource_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_18','computeresource_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_18','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_18','datacenter_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_18','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_18','datastore_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_18','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_18','network_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_18','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_18','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_18','dvs_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_18','storagepod_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_18','storagepod_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_18','change_tag_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_19','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_19','chain_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_19','event_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_19','extended_class','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_19','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_19','username','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_19','category','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_19','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_19','vm_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_19','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_19','host_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_19','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_19','computeresource_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_19','computeresource_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_19','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_19','datacenter_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_19','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_19','datastore_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_19','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_19','network_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_19','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_19','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_19','dvs_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_19','storagepod_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_19','storagepod_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_19','change_tag_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_2','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_2','chain_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_2','event_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_2','extended_class','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_2','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_2','username','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_2','category','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_2','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_2','vm_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_2','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_2','host_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_2','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_2','computeresource_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_2','computeresource_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_2','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_2','datacenter_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_2','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_2','datastore_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_2','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_2','network_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_2','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_2','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_2','dvs_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_2','storagepod_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_2','storagepod_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_2','change_tag_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_20','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_20','chain_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_20','event_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_20','extended_class','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_20','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_20','username','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_20','category','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_20','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_20','vm_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_20','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_20','host_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_20','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_20','computeresource_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_20','computeresource_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_20','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_20','datacenter_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_20','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_20','datastore_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_20','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_20','network_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_20','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_20','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_20','dvs_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_20','storagepod_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_20','storagepod_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_20','change_tag_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_21','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_21','chain_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_21','event_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_21','extended_class','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_21','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_21','username','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_21','category','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_21','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_21','vm_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_21','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_21','host_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_21','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_21','computeresource_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_21','computeresource_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_21','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_21','datacenter_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_21','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_21','datastore_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_21','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_21','network_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_21','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_21','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_21','dvs_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_21','storagepod_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_21','storagepod_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_21','change_tag_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_22','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_22','chain_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_22','event_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_22','extended_class','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_22','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_22','username','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_22','category','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_22','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_22','vm_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_22','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_22','host_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_22','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_22','computeresource_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_22','computeresource_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_22','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_22','datacenter_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_22','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_22','datastore_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_22','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_22','network_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_22','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_22','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_22','dvs_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_22','storagepod_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_22','storagepod_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_22','change_tag_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_23','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_23','chain_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_23','event_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_23','extended_class','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_23','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_23','username','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_23','category','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_23','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_23','vm_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_23','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_23','host_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_23','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_23','computeresource_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_23','computeresource_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_23','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_23','datacenter_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_23','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_23','datastore_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_23','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_23','network_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_23','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_23','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_23','dvs_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_23','storagepod_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_23','storagepod_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_23','change_tag_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_24','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_24','chain_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_24','event_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_24','extended_class','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_24','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_24','username','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_24','category','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_24','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_24','vm_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_24','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_24','host_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_24','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_24','computeresource_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_24','computeresource_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_24','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_24','datacenter_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_24','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_24','datastore_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_24','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_24','network_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_24','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_24','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_24','dvs_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_24','storagepod_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_24','storagepod_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_24','change_tag_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_25','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_25','chain_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_25','event_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_25','extended_class','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_25','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_25','username','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_25','category','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_25','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_25','vm_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_25','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_25','host_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_25','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_25','computeresource_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_25','computeresource_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_25','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_25','datacenter_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_25','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_25','datastore_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_25','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_25','network_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_25','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_25','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_25','dvs_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_25','storagepod_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_25','storagepod_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_25','change_tag_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_26','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_26','chain_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_26','event_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_26','extended_class','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_26','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_26','username','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_26','category','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_26','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_26','vm_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_26','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_26','host_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_26','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_26','computeresource_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_26','computeresource_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_26','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_26','datacenter_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_26','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_26','datastore_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_26','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_26','network_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_26','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_26','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_26','dvs_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_26','storagepod_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_26','storagepod_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_26','change_tag_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_27','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_27','chain_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_27','event_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_27','extended_class','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_27','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_27','username','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_27','category','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_27','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_27','vm_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_27','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_27','host_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_27','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_27','computeresource_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_27','computeresource_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_27','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_27','datacenter_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_27','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_27','datastore_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_27','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_27','network_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_27','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_27','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_27','dvs_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_27','storagepod_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_27','storagepod_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_27','change_tag_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_28','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_28','chain_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_28','event_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_28','extended_class','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_28','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_28','username','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_28','category','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_28','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_28','vm_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_28','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_28','host_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_28','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_28','computeresource_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_28','computeresource_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_28','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_28','datacenter_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_28','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_28','datastore_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_28','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_28','network_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_28','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_28','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_28','dvs_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_28','storagepod_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_28','storagepod_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_28','change_tag_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_29','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_29','chain_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_29','event_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_29','extended_class','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_29','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_29','username','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_29','category','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_29','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_29','vm_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_29','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_29','host_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_29','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_29','computeresource_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_29','computeresource_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_29','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_29','datacenter_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_29','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_29','datastore_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_29','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_29','network_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_29','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_29','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_29','dvs_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_29','storagepod_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_29','storagepod_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_29','change_tag_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_3','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_3','chain_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_3','event_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_3','extended_class','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_3','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_3','username','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_3','category','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_3','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_3','vm_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_3','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_3','host_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_3','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_3','computeresource_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_3','computeresource_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_3','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_3','datacenter_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_3','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_3','datastore_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_3','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_3','network_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_3','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_3','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_3','dvs_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_3','storagepod_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_3','storagepod_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_3','change_tag_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_30','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_30','chain_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_30','event_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_30','extended_class','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_30','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_30','username','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_30','category','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_30','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_30','vm_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_30','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_30','host_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_30','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_30','computeresource_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_30','computeresource_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_30','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_30','datacenter_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_30','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_30','datastore_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_30','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_30','network_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_30','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_30','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_30','dvs_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_30','storagepod_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_30','storagepod_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_30','change_tag_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_31','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_31','chain_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_31','event_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_31','extended_class','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_31','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_31','username','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_31','category','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_31','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_31','vm_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_31','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_31','host_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_31','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_31','computeresource_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_31','computeresource_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_31','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_31','datacenter_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_31','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_31','datastore_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_31','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_31','network_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_31','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_31','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_31','dvs_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_31','storagepod_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_31','storagepod_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_31','change_tag_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_32','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_32','chain_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_32','event_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_32','extended_class','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_32','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_32','username','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_32','category','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_32','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_32','vm_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_32','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_32','host_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_32','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_32','computeresource_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_32','computeresource_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_32','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_32','datacenter_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_32','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_32','datastore_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_32','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_32','network_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_32','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_32','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_32','dvs_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_32','storagepod_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_32','storagepod_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_32','change_tag_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_33','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_33','chain_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_33','event_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_33','extended_class','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_33','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_33','username','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_33','category','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_33','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_33','vm_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_33','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_33','host_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_33','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_33','computeresource_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_33','computeresource_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_33','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_33','datacenter_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_33','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_33','datastore_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_33','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_33','network_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_33','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_33','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_33','dvs_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_33','storagepod_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_33','storagepod_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_33','change_tag_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_34','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_34','chain_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_34','event_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_34','extended_class','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_34','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_34','username','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_34','category','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_34','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_34','vm_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_34','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_34','host_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_34','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_34','computeresource_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_34','computeresource_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_34','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_34','datacenter_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_34','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_34','datastore_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_34','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_34','network_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_34','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_34','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_34','dvs_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_34','storagepod_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_34','storagepod_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_34','change_tag_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_35','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_35','chain_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_35','event_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_35','extended_class','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_35','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_35','username','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_35','category','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_35','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_35','vm_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_35','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_35','host_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_35','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_35','computeresource_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_35','computeresource_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_35','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_35','datacenter_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_35','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_35','datastore_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_35','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_35','network_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_35','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_35','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_35','dvs_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_35','storagepod_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_35','storagepod_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_35','change_tag_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_36','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_36','chain_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_36','event_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_36','extended_class','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_36','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_36','username','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_36','category','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_36','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_36','vm_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_36','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_36','host_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_36','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_36','computeresource_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_36','computeresource_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_36','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_36','datacenter_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_36','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_36','datastore_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_36','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_36','network_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_36','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_36','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_36','dvs_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_36','storagepod_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_36','storagepod_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_36','change_tag_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_37','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_37','chain_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_37','event_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_37','extended_class','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_37','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_37','username','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_37','category','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_37','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_37','vm_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_37','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_37','host_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_37','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_37','computeresource_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_37','computeresource_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_37','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_37','datacenter_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_37','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_37','datastore_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_37','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_37','network_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_37','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_37','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_37','dvs_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_37','storagepod_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_37','storagepod_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_37','change_tag_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_38','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_38','chain_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_38','event_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_38','extended_class','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_38','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_38','username','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_38','category','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_38','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_38','vm_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_38','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_38','host_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_38','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_38','computeresource_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_38','computeresource_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_38','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_38','datacenter_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_38','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_38','datastore_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_38','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_38','network_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_38','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_38','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_38','dvs_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_38','storagepod_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_38','storagepod_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_38','change_tag_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_39','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_39','chain_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_39','event_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_39','extended_class','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_39','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_39','username','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_39','category','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_39','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_39','vm_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_39','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_39','host_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_39','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_39','computeresource_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_39','computeresource_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_39','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_39','datacenter_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_39','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_39','datastore_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_39','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_39','network_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_39','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_39','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_39','dvs_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_39','storagepod_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_39','storagepod_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_39','change_tag_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_4','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_4','chain_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_4','event_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_4','extended_class','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_4','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_4','username','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_4','category','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_4','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_4','vm_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_4','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_4','host_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_4','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_4','computeresource_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_4','computeresource_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_4','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_4','datacenter_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_4','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_4','datastore_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_4','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_4','network_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_4','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_4','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_4','dvs_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_4','storagepod_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_4','storagepod_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_4','change_tag_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_40','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_40','chain_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_40','event_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_40','extended_class','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_40','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_40','username','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_40','category','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_40','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_40','vm_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_40','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_40','host_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_40','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_40','computeresource_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_40','computeresource_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_40','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_40','datacenter_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_40','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_40','datastore_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_40','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_40','network_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_40','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_40','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_40','dvs_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_40','storagepod_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_40','storagepod_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_40','change_tag_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_41','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_41','chain_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_41','event_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_41','extended_class','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_41','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_41','username','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_41','category','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_41','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_41','vm_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_41','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_41','host_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_41','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_41','computeresource_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_41','computeresource_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_41','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_41','datacenter_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_41','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_41','datastore_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_41','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_41','network_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_41','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_41','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_41','dvs_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_41','storagepod_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_41','storagepod_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_41','change_tag_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_42','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_42','chain_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_42','event_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_42','extended_class','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_42','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_42','username','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_42','category','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_42','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_42','vm_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_42','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_42','host_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_42','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_42','computeresource_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_42','computeresource_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_42','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_42','datacenter_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_42','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_42','datastore_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_42','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_42','network_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_42','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_42','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_42','dvs_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_42','storagepod_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_42','storagepod_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_42','change_tag_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_43','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_43','chain_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_43','event_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_43','extended_class','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_43','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_43','username','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_43','category','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_43','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_43','vm_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_43','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_43','host_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_43','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_43','computeresource_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_43','computeresource_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_43','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_43','datacenter_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_43','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_43','datastore_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_43','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_43','network_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_43','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_43','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_43','dvs_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_43','storagepod_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_43','storagepod_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_43','change_tag_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_44','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_44','chain_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_44','event_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_44','extended_class','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_44','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_44','username','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_44','category','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_44','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_44','vm_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_44','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_44','host_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_44','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_44','computeresource_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_44','computeresource_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_44','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_44','datacenter_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_44','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_44','datastore_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_44','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_44','network_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_44','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_44','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_44','dvs_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_44','storagepod_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_44','storagepod_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_44','change_tag_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_45','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_45','chain_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_45','event_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_45','extended_class','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_45','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_45','username','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_45','category','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_45','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_45','vm_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_45','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_45','host_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_45','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_45','computeresource_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_45','computeresource_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_45','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_45','datacenter_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_45','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_45','datastore_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_45','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_45','network_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_45','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_45','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_45','dvs_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_45','storagepod_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_45','storagepod_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_45','change_tag_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_46','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_46','chain_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_46','event_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_46','extended_class','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_46','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_46','username','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_46','category','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_46','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_46','vm_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_46','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_46','host_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_46','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_46','computeresource_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_46','computeresource_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_46','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_46','datacenter_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_46','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_46','datastore_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_46','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_46','network_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_46','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_46','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_46','dvs_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_46','storagepod_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_46','storagepod_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_46','change_tag_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_47','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_47','chain_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_47','event_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_47','extended_class','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_47','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_47','username','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_47','category','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_47','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_47','vm_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_47','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_47','host_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_47','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_47','computeresource_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_47','computeresource_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_47','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_47','datacenter_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_47','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_47','datastore_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_47','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_47','network_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_47','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_47','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_47','dvs_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_47','storagepod_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_47','storagepod_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_47','change_tag_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_48','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_48','chain_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_48','event_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_48','extended_class','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_48','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_48','username','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_48','category','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_48','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_48','vm_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_48','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_48','host_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_48','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_48','computeresource_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_48','computeresource_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_48','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_48','datacenter_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_48','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_48','datastore_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_48','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_48','network_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_48','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_48','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_48','dvs_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_48','storagepod_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_48','storagepod_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_48','change_tag_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_49','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_49','chain_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_49','event_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_49','extended_class','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_49','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_49','username','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_49','category','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_49','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_49','vm_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_49','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_49','host_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_49','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_49','computeresource_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_49','computeresource_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_49','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_49','datacenter_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_49','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_49','datastore_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_49','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_49','network_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_49','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_49','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_49','dvs_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_49','storagepod_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_49','storagepod_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_49','change_tag_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_5','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_5','chain_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_5','event_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_5','extended_class','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_5','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_5','username','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_5','category','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_5','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_5','vm_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_5','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_5','host_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_5','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_5','computeresource_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_5','computeresource_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_5','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_5','datacenter_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_5','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_5','datastore_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_5','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_5','network_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_5','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_5','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_5','dvs_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_5','storagepod_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_5','storagepod_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_5','change_tag_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_50','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_50','chain_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_50','event_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_50','extended_class','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_50','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_50','username','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_50','category','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_50','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_50','vm_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_50','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_50','host_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_50','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_50','computeresource_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_50','computeresource_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_50','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_50','datacenter_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_50','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_50','datastore_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_50','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_50','network_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_50','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_50','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_50','dvs_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_50','storagepod_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_50','storagepod_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_50','change_tag_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_51','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_51','chain_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_51','event_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_51','extended_class','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_51','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_51','username','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_51','category','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_51','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_51','vm_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_51','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_51','host_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_51','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_51','computeresource_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_51','computeresource_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_51','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_51','datacenter_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_51','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_51','datastore_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_51','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_51','network_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_51','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_51','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_51','dvs_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_51','storagepod_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_51','storagepod_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_51','change_tag_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_52','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_52','chain_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_52','event_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_52','extended_class','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_52','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_52','username','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_52','category','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_52','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_52','vm_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_52','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_52','host_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_52','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_52','computeresource_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_52','computeresource_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_52','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_52','datacenter_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_52','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_52','datastore_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_52','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_52','network_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_52','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_52','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_52','dvs_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_52','storagepod_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_52','storagepod_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_52','change_tag_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_53','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_53','chain_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_53','event_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_53','extended_class','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_53','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_53','username','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_53','category','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_53','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_53','vm_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_53','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_53','host_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_53','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_53','computeresource_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_53','computeresource_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_53','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_53','datacenter_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_53','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_53','datastore_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_53','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_53','network_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_53','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_53','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_53','dvs_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_53','storagepod_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_53','storagepod_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_53','change_tag_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_54','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_54','chain_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_54','event_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_54','extended_class','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_54','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_54','username','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_54','category','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_54','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_54','vm_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_54','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_54','host_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_54','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_54','computeresource_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_54','computeresource_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_54','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_54','datacenter_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_54','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_54','datastore_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_54','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_54','network_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_54','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_54','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_54','dvs_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_54','storagepod_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_54','storagepod_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_54','change_tag_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_55','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_55','chain_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_55','event_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_55','extended_class','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_55','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_55','username','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_55','category','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_55','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_55','vm_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_55','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_55','host_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_55','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_55','computeresource_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_55','computeresource_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_55','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_55','datacenter_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_55','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_55','datastore_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_55','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_55','network_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_55','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_55','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_55','dvs_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_55','storagepod_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_55','storagepod_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_55','change_tag_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_56','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_56','chain_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_56','event_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_56','extended_class','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_56','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_56','username','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_56','category','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_56','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_56','vm_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_56','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_56','host_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_56','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_56','computeresource_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_56','computeresource_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_56','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_56','datacenter_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_56','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_56','datastore_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_56','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_56','network_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_56','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_56','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_56','dvs_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_56','storagepod_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_56','storagepod_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_56','change_tag_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_57','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_57','chain_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_57','event_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_57','extended_class','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_57','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_57','username','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_57','category','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_57','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_57','vm_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_57','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_57','host_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_57','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_57','computeresource_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_57','computeresource_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_57','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_57','datacenter_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_57','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_57','datastore_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_57','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_57','network_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_57','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_57','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_57','dvs_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_57','storagepod_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_57','storagepod_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_57','change_tag_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_58','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_58','chain_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_58','event_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_58','extended_class','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_58','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_58','username','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_58','category','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_58','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_58','vm_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_58','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_58','host_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_58','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_58','computeresource_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_58','computeresource_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_58','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_58','datacenter_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_58','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_58','datastore_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_58','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_58','network_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_58','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_58','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_58','dvs_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_58','storagepod_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_58','storagepod_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_58','change_tag_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_59','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_59','chain_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_59','event_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_59','extended_class','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_59','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_59','username','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_59','category','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_59','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_59','vm_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_59','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_59','host_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_59','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_59','computeresource_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_59','computeresource_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_59','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_59','datacenter_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_59','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_59','datastore_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_59','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_59','network_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_59','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_59','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_59','dvs_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_59','storagepod_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_59','storagepod_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_59','change_tag_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_6','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_6','chain_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_6','event_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_6','extended_class','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_6','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_6','username','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_6','category','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_6','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_6','vm_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_6','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_6','host_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_6','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_6','computeresource_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_6','computeresource_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_6','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_6','datacenter_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_6','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_6','datastore_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_6','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_6','network_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_6','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_6','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_6','dvs_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_6','storagepod_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_6','storagepod_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_6','change_tag_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_60','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_60','chain_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_60','event_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_60','extended_class','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_60','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_60','username','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_60','category','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_60','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_60','vm_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_60','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_60','host_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_60','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_60','computeresource_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_60','computeresource_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_60','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_60','datacenter_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_60','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_60','datastore_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_60','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_60','network_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_60','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_60','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_60','dvs_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_60','storagepod_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_60','storagepod_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_60','change_tag_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_61','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_61','chain_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_61','event_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_61','extended_class','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_61','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_61','username','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_61','category','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_61','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_61','vm_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_61','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_61','host_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_61','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_61','computeresource_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_61','computeresource_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_61','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_61','datacenter_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_61','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_61','datastore_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_61','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_61','network_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_61','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_61','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_61','dvs_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_61','storagepod_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_61','storagepod_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_61','change_tag_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_62','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_62','chain_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_62','event_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_62','extended_class','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_62','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_62','username','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_62','category','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_62','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_62','vm_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_62','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_62','host_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_62','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_62','computeresource_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_62','computeresource_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_62','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_62','datacenter_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_62','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_62','datastore_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_62','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_62','network_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_62','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_62','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_62','dvs_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_62','storagepod_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_62','storagepod_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_62','change_tag_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_63','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_63','chain_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_63','event_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_63','extended_class','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_63','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_63','username','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_63','category','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_63','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_63','vm_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_63','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_63','host_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_63','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_63','computeresource_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_63','computeresource_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_63','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_63','datacenter_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_63','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_63','datastore_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_63','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_63','network_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_63','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_63','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_63','dvs_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_63','storagepod_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_63','storagepod_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_63','change_tag_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_64','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_64','chain_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_64','event_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_64','extended_class','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_64','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_64','username','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_64','category','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_64','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_64','vm_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_64','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_64','host_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_64','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_64','computeresource_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_64','computeresource_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_64','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_64','datacenter_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_64','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_64','datastore_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_64','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_64','network_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_64','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_64','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_64','dvs_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_64','storagepod_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_64','storagepod_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_64','change_tag_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_65','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_65','chain_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_65','event_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_65','extended_class','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_65','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_65','username','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_65','category','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_65','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_65','vm_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_65','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_65','host_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_65','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_65','computeresource_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_65','computeresource_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_65','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_65','datacenter_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_65','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_65','datastore_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_65','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_65','network_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_65','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_65','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_65','dvs_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_65','storagepod_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_65','storagepod_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_65','change_tag_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_66','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_66','chain_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_66','event_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_66','extended_class','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_66','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_66','username','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_66','category','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_66','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_66','vm_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_66','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_66','host_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_66','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_66','computeresource_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_66','computeresource_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_66','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_66','datacenter_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_66','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_66','datastore_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_66','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_66','network_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_66','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_66','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_66','dvs_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_66','storagepod_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_66','storagepod_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_66','change_tag_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_67','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_67','chain_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_67','event_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_67','extended_class','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_67','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_67','username','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_67','category','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_67','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_67','vm_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_67','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_67','host_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_67','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_67','computeresource_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_67','computeresource_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_67','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_67','datacenter_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_67','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_67','datastore_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_67','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_67','network_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_67','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_67','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_67','dvs_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_67','storagepod_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_67','storagepod_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_67','change_tag_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_68','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_68','chain_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_68','event_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_68','extended_class','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_68','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_68','username','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_68','category','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_68','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_68','vm_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_68','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_68','host_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_68','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_68','computeresource_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_68','computeresource_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_68','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_68','datacenter_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_68','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_68','datastore_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_68','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_68','network_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_68','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_68','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_68','dvs_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_68','storagepod_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_68','storagepod_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_68','change_tag_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_69','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_69','chain_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_69','event_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_69','extended_class','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_69','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_69','username','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_69','category','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_69','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_69','vm_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_69','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_69','host_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_69','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_69','computeresource_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_69','computeresource_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_69','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_69','datacenter_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_69','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_69','datastore_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_69','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_69','network_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_69','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_69','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_69','dvs_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_69','storagepod_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_69','storagepod_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_69','change_tag_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_7','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_7','chain_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_7','event_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_7','extended_class','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_7','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_7','username','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_7','category','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_7','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_7','vm_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_7','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_7','host_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_7','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_7','computeresource_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_7','computeresource_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_7','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_7','datacenter_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_7','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_7','datastore_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_7','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_7','network_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_7','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_7','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_7','dvs_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_7','storagepod_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_7','storagepod_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_7','change_tag_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_70','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_70','chain_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_70','event_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_70','extended_class','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_70','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_70','username','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_70','category','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_70','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_70','vm_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_70','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_70','host_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_70','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_70','computeresource_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_70','computeresource_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_70','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_70','datacenter_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_70','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_70','datastore_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_70','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_70','network_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_70','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_70','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_70','dvs_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_70','storagepod_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_70','storagepod_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_70','change_tag_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_71','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_71','chain_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_71','event_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_71','extended_class','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_71','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_71','username','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_71','category','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_71','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_71','vm_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_71','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_71','host_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_71','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_71','computeresource_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_71','computeresource_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_71','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_71','datacenter_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_71','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_71','datastore_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_71','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_71','network_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_71','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_71','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_71','dvs_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_71','storagepod_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_71','storagepod_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_71','change_tag_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_72','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_72','chain_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_72','event_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_72','extended_class','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_72','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_72','username','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_72','category','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_72','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_72','vm_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_72','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_72','host_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_72','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_72','computeresource_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_72','computeresource_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_72','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_72','datacenter_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_72','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_72','datastore_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_72','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_72','network_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_72','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_72','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_72','dvs_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_72','storagepod_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_72','storagepod_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_72','change_tag_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_73','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_73','chain_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_73','event_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_73','extended_class','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_73','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_73','username','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_73','category','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_73','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_73','vm_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_73','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_73','host_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_73','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_73','computeresource_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_73','computeresource_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_73','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_73','datacenter_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_73','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_73','datastore_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_73','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_73','network_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_73','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_73','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_73','dvs_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_73','storagepod_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_73','storagepod_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_73','change_tag_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_74','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_74','chain_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_74','event_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_74','extended_class','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_74','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_74','username','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_74','category','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_74','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_74','vm_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_74','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_74','host_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_74','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_74','computeresource_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_74','computeresource_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_74','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_74','datacenter_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_74','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_74','datastore_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_74','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_74','network_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_74','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_74','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_74','dvs_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_74','storagepod_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_74','storagepod_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_74','change_tag_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_75','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_75','chain_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_75','event_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_75','extended_class','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_75','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_75','username','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_75','category','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_75','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_75','vm_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_75','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_75','host_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_75','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_75','computeresource_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_75','computeresource_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_75','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_75','datacenter_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_75','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_75','datastore_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_75','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_75','network_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_75','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_75','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_75','dvs_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_75','storagepod_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_75','storagepod_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_75','change_tag_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_76','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_76','chain_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_76','event_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_76','extended_class','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_76','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_76','username','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_76','category','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_76','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_76','vm_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_76','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_76','host_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_76','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_76','computeresource_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_76','computeresource_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_76','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_76','datacenter_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_76','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_76','datastore_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_76','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_76','network_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_76','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_76','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_76','dvs_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_76','storagepod_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_76','storagepod_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_76','change_tag_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_77','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_77','chain_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_77','event_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_77','extended_class','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_77','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_77','username','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_77','category','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_77','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_77','vm_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_77','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_77','host_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_77','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_77','computeresource_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_77','computeresource_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_77','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_77','datacenter_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_77','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_77','datastore_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_77','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_77','network_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_77','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_77','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_77','dvs_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_77','storagepod_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_77','storagepod_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_77','change_tag_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_78','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_78','chain_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_78','event_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_78','extended_class','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_78','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_78','username','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_78','category','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_78','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_78','vm_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_78','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_78','host_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_78','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_78','computeresource_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_78','computeresource_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_78','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_78','datacenter_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_78','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_78','datastore_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_78','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_78','network_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_78','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_78','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_78','dvs_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_78','storagepod_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_78','storagepod_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_78','change_tag_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_79','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_79','chain_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_79','event_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_79','extended_class','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_79','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_79','username','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_79','category','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_79','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_79','vm_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_79','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_79','host_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_79','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_79','computeresource_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_79','computeresource_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_79','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_79','datacenter_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_79','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_79','datastore_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_79','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_79','network_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_79','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_79','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_79','dvs_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_79','storagepod_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_79','storagepod_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_79','change_tag_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_8','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_8','chain_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_8','event_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_8','extended_class','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_8','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_8','username','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_8','category','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_8','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_8','vm_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_8','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_8','host_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_8','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_8','computeresource_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_8','computeresource_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_8','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_8','datacenter_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_8','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_8','datastore_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_8','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_8','network_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_8','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_8','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_8','dvs_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_8','storagepod_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_8','storagepod_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_8','change_tag_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_80','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_80','chain_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_80','event_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_80','extended_class','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_80','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_80','username','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_80','category','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_80','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_80','vm_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_80','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_80','host_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_80','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_80','computeresource_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_80','computeresource_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_80','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_80','datacenter_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_80','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_80','datastore_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_80','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_80','network_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_80','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_80','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_80','dvs_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_80','storagepod_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_80','storagepod_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_80','change_tag_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_81','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_81','chain_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_81','event_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_81','extended_class','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_81','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_81','username','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_81','category','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_81','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_81','vm_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_81','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_81','host_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_81','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_81','computeresource_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_81','computeresource_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_81','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_81','datacenter_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_81','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_81','datastore_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_81','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_81','network_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_81','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_81','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_81','dvs_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_81','storagepod_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_81','storagepod_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_81','change_tag_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_82','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_82','chain_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_82','event_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_82','extended_class','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_82','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_82','username','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_82','category','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_82','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_82','vm_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_82','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_82','host_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_82','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_82','computeresource_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_82','computeresource_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_82','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_82','datacenter_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_82','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_82','datastore_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_82','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_82','network_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_82','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_82','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_82','dvs_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_82','storagepod_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_82','storagepod_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_82','change_tag_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_83','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_83','chain_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_83','event_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_83','extended_class','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_83','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_83','username','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_83','category','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_83','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_83','vm_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_83','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_83','host_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_83','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_83','computeresource_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_83','computeresource_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_83','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_83','datacenter_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_83','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_83','datastore_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_83','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_83','network_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_83','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_83','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_83','dvs_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_83','storagepod_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_83','storagepod_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_83','change_tag_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_84','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_84','chain_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_84','event_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_84','extended_class','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_84','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_84','username','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_84','category','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_84','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_84','vm_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_84','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_84','host_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_84','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_84','computeresource_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_84','computeresource_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_84','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_84','datacenter_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_84','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_84','datastore_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_84','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_84','network_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_84','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_84','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_84','dvs_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_84','storagepod_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_84','storagepod_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_84','change_tag_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_85','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_85','chain_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_85','event_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_85','extended_class','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_85','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_85','username','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_85','category','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_85','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_85','vm_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_85','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_85','host_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_85','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_85','computeresource_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_85','computeresource_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_85','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_85','datacenter_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_85','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_85','datastore_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_85','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_85','network_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_85','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_85','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_85','dvs_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_85','storagepod_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_85','storagepod_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_85','change_tag_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_86','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_86','chain_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_86','event_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_86','extended_class','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_86','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_86','username','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_86','category','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_86','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_86','vm_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_86','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_86','host_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_86','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_86','computeresource_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_86','computeresource_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_86','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_86','datacenter_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_86','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_86','datastore_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_86','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_86','network_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_86','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_86','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_86','dvs_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_86','storagepod_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_86','storagepod_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_86','change_tag_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_87','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_87','chain_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_87','event_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_87','extended_class','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_87','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_87','username','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_87','category','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_87','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_87','vm_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_87','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_87','host_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_87','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_87','computeresource_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_87','computeresource_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_87','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_87','datacenter_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_87','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_87','datastore_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_87','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_87','network_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_87','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_87','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_87','dvs_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_87','storagepod_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_87','storagepod_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_87','change_tag_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_88','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_88','chain_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_88','event_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_88','extended_class','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_88','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_88','username','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_88','category','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_88','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_88','vm_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_88','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_88','host_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_88','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_88','computeresource_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_88','computeresource_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_88','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_88','datacenter_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_88','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_88','datastore_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_88','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_88','network_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_88','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_88','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_88','dvs_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_88','storagepod_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_88','storagepod_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_88','change_tag_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_89','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_89','chain_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_89','event_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_89','extended_class','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_89','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_89','username','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_89','category','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_89','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_89','vm_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_89','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_89','host_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_89','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_89','computeresource_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_89','computeresource_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_89','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_89','datacenter_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_89','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_89','datastore_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_89','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_89','network_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_89','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_89','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_89','dvs_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_89','storagepod_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_89','storagepod_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_89','change_tag_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_9','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_9','chain_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_9','event_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_9','extended_class','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_9','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_9','username','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_9','category','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_9','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_9','vm_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_9','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_9','host_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_9','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_9','computeresource_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_9','computeresource_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_9','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_9','datacenter_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_9','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_9','datastore_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_9','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_9','network_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_9','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_9','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_9','dvs_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_9','storagepod_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_9','storagepod_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_9','change_tag_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_90','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_90','chain_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_90','event_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_90','extended_class','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_90','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_90','username','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_90','category','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_90','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_90','vm_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_90','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_90','host_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_90','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_90','computeresource_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_90','computeresource_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_90','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_90','datacenter_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_90','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_90','datastore_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_90','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_90','network_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_90','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_90','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_90','dvs_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_90','storagepod_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_90','storagepod_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_90','change_tag_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_91','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_91','chain_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_91','event_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_91','extended_class','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_91','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_91','username','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_91','category','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_91','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_91','vm_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_91','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_91','host_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_91','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_91','computeresource_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_91','computeresource_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_91','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_91','datacenter_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_91','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_91','datastore_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_91','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_91','network_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_91','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_91','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_91','dvs_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_91','storagepod_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_91','storagepod_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_91','change_tag_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_92','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_92','chain_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_92','event_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_92','extended_class','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_92','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_92','username','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_92','category','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_92','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_92','vm_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_92','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_92','host_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_92','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_92','computeresource_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_92','computeresource_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_92','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_92','datacenter_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_92','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_92','datastore_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_92','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_92','network_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_92','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_92','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_92','dvs_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_92','storagepod_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_92','storagepod_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_92','change_tag_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_1','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_1','arg_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_1','arg_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_1','arg_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_1','obj_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_1','obj_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_1','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_1','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_1','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_1','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_1','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_1','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_1','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_1','resourcepool_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_1','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_1','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_1','alarm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_1','scheduledtask_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_10','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_10','arg_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_10','arg_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_10','arg_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_10','obj_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_10','obj_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_10','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_10','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_10','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_10','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_10','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_10','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_10','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_10','resourcepool_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_10','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_10','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_10','alarm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_10','scheduledtask_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_11','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_11','arg_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_11','arg_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_11','arg_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_11','obj_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_11','obj_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_11','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_11','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_11','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_11','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_11','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_11','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_11','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_11','resourcepool_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_11','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_11','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_11','alarm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_11','scheduledtask_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_12','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_12','arg_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_12','arg_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_12','arg_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_12','obj_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_12','obj_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_12','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_12','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_12','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_12','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_12','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_12','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_12','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_12','resourcepool_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_12','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_12','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_12','alarm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_12','scheduledtask_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_13','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_13','arg_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_13','arg_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_13','arg_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_13','obj_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_13','obj_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_13','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_13','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_13','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_13','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_13','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_13','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_13','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_13','resourcepool_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_13','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_13','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_13','alarm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_13','scheduledtask_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_14','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_14','arg_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_14','arg_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_14','arg_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_14','obj_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_14','obj_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_14','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_14','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_14','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_14','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_14','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_14','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_14','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_14','resourcepool_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_14','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_14','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_14','alarm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_14','scheduledtask_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_15','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_15','arg_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_15','arg_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_15','arg_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_15','obj_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_15','obj_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_15','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_15','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_15','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_15','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_15','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_15','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_15','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_15','resourcepool_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_15','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_15','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_15','alarm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_15','scheduledtask_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_16','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_16','arg_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_16','arg_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_16','arg_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_16','obj_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_16','obj_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_16','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_16','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_16','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_16','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_16','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_16','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_16','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_16','resourcepool_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_16','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_16','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_16','alarm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_16','scheduledtask_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_17','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_17','arg_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_17','arg_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_17','arg_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_17','obj_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_17','obj_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_17','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_17','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_17','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_17','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_17','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_17','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_17','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_17','resourcepool_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_17','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_17','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_17','alarm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_17','scheduledtask_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_18','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_18','arg_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_18','arg_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_18','arg_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_18','obj_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_18','obj_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_18','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_18','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_18','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_18','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_18','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_18','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_18','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_18','resourcepool_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_18','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_18','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_18','alarm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_18','scheduledtask_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_19','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_19','arg_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_19','arg_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_19','arg_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_19','obj_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_19','obj_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_19','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_19','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_19','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_19','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_19','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_19','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_19','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_19','resourcepool_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_19','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_19','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_19','alarm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_19','scheduledtask_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_2','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_2','arg_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_2','arg_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_2','arg_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_2','obj_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_2','obj_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_2','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_2','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_2','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_2','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_2','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_2','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_2','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_2','resourcepool_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_2','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_2','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_2','alarm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_2','scheduledtask_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_20','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_20','arg_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_20','arg_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_20','arg_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_20','obj_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_20','obj_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_20','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_20','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_20','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_20','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_20','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_20','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_20','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_20','resourcepool_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_20','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_20','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_20','alarm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_20','scheduledtask_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_21','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_21','arg_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_21','arg_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_21','arg_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_21','obj_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_21','obj_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_21','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_21','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_21','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_21','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_21','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_21','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_21','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_21','resourcepool_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_21','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_21','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_21','alarm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_21','scheduledtask_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_22','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_22','arg_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_22','arg_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_22','arg_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_22','obj_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_22','obj_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_22','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_22','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_22','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_22','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_22','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_22','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_22','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_22','resourcepool_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_22','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_22','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_22','alarm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_22','scheduledtask_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_23','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_23','arg_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_23','arg_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_23','arg_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_23','obj_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_23','obj_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_23','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_23','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_23','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_23','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_23','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_23','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_23','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_23','resourcepool_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_23','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_23','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_23','alarm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_23','scheduledtask_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_24','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_24','arg_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_24','arg_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_24','arg_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_24','obj_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_24','obj_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_24','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_24','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_24','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_24','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_24','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_24','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_24','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_24','resourcepool_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_24','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_24','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_24','alarm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_24','scheduledtask_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_25','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_25','arg_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_25','arg_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_25','arg_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_25','obj_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_25','obj_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_25','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_25','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_25','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_25','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_25','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_25','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_25','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_25','resourcepool_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_25','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_25','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_25','alarm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_25','scheduledtask_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_26','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_26','arg_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_26','arg_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_26','arg_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_26','obj_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_26','obj_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_26','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_26','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_26','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_26','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_26','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_26','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_26','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_26','resourcepool_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_26','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_26','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_26','alarm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_26','scheduledtask_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_27','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_27','arg_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_27','arg_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_27','arg_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_27','obj_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_27','obj_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_27','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_27','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_27','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_27','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_27','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_27','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_27','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_27','resourcepool_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_27','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_27','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_27','alarm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_27','scheduledtask_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_28','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_28','arg_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_28','arg_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_28','arg_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_28','obj_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_28','obj_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_28','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_28','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_28','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_28','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_28','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_28','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_28','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_28','resourcepool_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_28','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_28','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_28','alarm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_28','scheduledtask_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_29','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_29','arg_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_29','arg_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_29','arg_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_29','obj_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_29','obj_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_29','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_29','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_29','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_29','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_29','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_29','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_29','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_29','resourcepool_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_29','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_29','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_29','alarm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_29','scheduledtask_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_3','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_3','arg_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_3','arg_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_3','arg_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_3','obj_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_3','obj_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_3','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_3','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_3','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_3','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_3','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_3','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_3','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_3','resourcepool_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_3','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_3','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_3','alarm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_3','scheduledtask_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_30','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_30','arg_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_30','arg_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_30','arg_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_30','obj_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_30','obj_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_30','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_30','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_30','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_30','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_30','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_30','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_30','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_30','resourcepool_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_30','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_30','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_30','alarm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_30','scheduledtask_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_31','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_31','arg_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_31','arg_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_31','arg_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_31','obj_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_31','obj_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_31','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_31','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_31','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_31','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_31','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_31','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_31','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_31','resourcepool_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_31','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_31','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_31','alarm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_31','scheduledtask_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_32','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_32','arg_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_32','arg_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_32','arg_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_32','obj_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_32','obj_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_32','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_32','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_32','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_32','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_32','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_32','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_32','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_32','resourcepool_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_32','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_32','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_32','alarm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_32','scheduledtask_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_33','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_33','arg_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_33','arg_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_33','arg_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_33','obj_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_33','obj_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_33','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_33','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_33','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_33','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_33','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_33','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_33','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_33','resourcepool_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_33','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_33','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_33','alarm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_33','scheduledtask_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_34','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_34','arg_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_34','arg_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_34','arg_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_34','obj_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_34','obj_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_34','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_34','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_34','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_34','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_34','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_34','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_34','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_34','resourcepool_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_34','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_34','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_34','alarm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_34','scheduledtask_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_35','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_35','arg_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_35','arg_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_35','arg_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_35','obj_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_35','obj_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_35','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_35','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_35','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_35','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_35','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_35','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_35','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_35','resourcepool_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_35','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_35','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_35','alarm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_35','scheduledtask_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_36','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_36','arg_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_36','arg_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_36','arg_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_36','obj_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_36','obj_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_36','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_36','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_36','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_36','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_36','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_36','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_36','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_36','resourcepool_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_36','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_36','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_36','alarm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_36','scheduledtask_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_37','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_37','arg_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_37','arg_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_37','arg_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_37','obj_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_37','obj_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_37','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_37','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_37','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_37','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_37','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_37','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_37','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_37','resourcepool_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_37','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_37','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_37','alarm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_37','scheduledtask_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_38','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_38','arg_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_38','arg_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_38','arg_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_38','obj_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_38','obj_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_38','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_38','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_38','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_38','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_38','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_38','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_38','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_38','resourcepool_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_38','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_38','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_38','alarm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_38','scheduledtask_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_39','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_39','arg_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_39','arg_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_39','arg_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_39','obj_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_39','obj_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_39','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_39','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_39','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_39','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_39','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_39','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_39','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_39','resourcepool_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_39','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_39','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_39','alarm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_39','scheduledtask_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_4','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_4','arg_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_4','arg_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_4','arg_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_4','obj_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_4','obj_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_4','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_4','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_4','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_4','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_4','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_4','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_4','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_4','resourcepool_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_4','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_4','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_4','alarm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_4','scheduledtask_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_40','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_40','arg_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_40','arg_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_40','arg_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_40','obj_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_40','obj_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_40','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_40','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_40','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_40','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_40','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_40','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_40','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_40','resourcepool_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_40','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_40','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_40','alarm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_40','scheduledtask_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_41','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_41','arg_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_41','arg_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_41','arg_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_41','obj_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_41','obj_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_41','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_41','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_41','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_41','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_41','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_41','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_41','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_41','resourcepool_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_41','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_41','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_41','alarm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_41','scheduledtask_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_42','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_42','arg_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_42','arg_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_42','arg_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_42','obj_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_42','obj_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_42','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_42','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_42','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_42','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_42','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_42','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_42','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_42','resourcepool_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_42','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_42','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_42','alarm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_42','scheduledtask_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_43','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_43','arg_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_43','arg_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_43','arg_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_43','obj_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_43','obj_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_43','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_43','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_43','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_43','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_43','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_43','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_43','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_43','resourcepool_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_43','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_43','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_43','alarm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_43','scheduledtask_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_44','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_44','arg_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_44','arg_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_44','arg_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_44','obj_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_44','obj_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_44','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_44','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_44','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_44','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_44','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_44','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_44','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_44','resourcepool_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_44','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_44','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_44','alarm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_44','scheduledtask_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_45','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_45','arg_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_45','arg_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_45','arg_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_45','obj_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_45','obj_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_45','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_45','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_45','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_45','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_45','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_45','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_45','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_45','resourcepool_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_45','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_45','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_45','alarm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_45','scheduledtask_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_46','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_46','arg_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_46','arg_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_46','arg_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_46','obj_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_46','obj_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_46','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_46','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_46','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_46','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_46','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_46','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_46','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_46','resourcepool_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_46','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_46','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_46','alarm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_46','scheduledtask_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_47','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_47','arg_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_47','arg_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_47','arg_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_47','obj_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_47','obj_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_47','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_47','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_47','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_47','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_47','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_47','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_47','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_47','resourcepool_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_47','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_47','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_47','alarm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_47','scheduledtask_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_48','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_48','arg_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_48','arg_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_48','arg_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_48','obj_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_48','obj_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_48','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_48','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_48','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_48','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_48','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_48','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_48','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_48','resourcepool_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_48','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_48','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_48','alarm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_48','scheduledtask_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_49','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_49','arg_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_49','arg_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_49','arg_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_49','obj_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_49','obj_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_49','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_49','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_49','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_49','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_49','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_49','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_49','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_49','resourcepool_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_49','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_49','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_49','alarm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_49','scheduledtask_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_5','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_5','arg_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_5','arg_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_5','arg_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_5','obj_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_5','obj_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_5','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_5','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_5','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_5','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_5','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_5','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_5','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_5','resourcepool_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_5','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_5','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_5','alarm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_5','scheduledtask_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_50','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_50','arg_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_50','arg_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_50','arg_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_50','obj_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_50','obj_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_50','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_50','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_50','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_50','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_50','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_50','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_50','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_50','resourcepool_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_50','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_50','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_50','alarm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_50','scheduledtask_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_51','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_51','arg_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_51','arg_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_51','arg_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_51','obj_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_51','obj_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_51','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_51','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_51','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_51','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_51','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_51','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_51','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_51','resourcepool_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_51','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_51','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_51','alarm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_51','scheduledtask_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_52','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_52','arg_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_52','arg_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_52','arg_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_52','obj_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_52','obj_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_52','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_52','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_52','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_52','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_52','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_52','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_52','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_52','resourcepool_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_52','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_52','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_52','alarm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_52','scheduledtask_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_53','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_53','arg_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_53','arg_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_53','arg_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_53','obj_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_53','obj_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_53','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_53','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_53','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_53','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_53','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_53','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_53','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_53','resourcepool_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_53','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_53','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_53','alarm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_53','scheduledtask_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_54','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_54','arg_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_54','arg_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_54','arg_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_54','obj_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_54','obj_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_54','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_54','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_54','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_54','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_54','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_54','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_54','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_54','resourcepool_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_54','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_54','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_54','alarm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_54','scheduledtask_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_55','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_55','arg_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_55','arg_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_55','arg_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_55','obj_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_55','obj_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_55','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_55','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_55','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_55','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_55','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_55','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_55','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_55','resourcepool_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_55','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_55','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_55','alarm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_55','scheduledtask_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_56','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_56','arg_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_56','arg_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_56','arg_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_56','obj_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_56','obj_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_56','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_56','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_56','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_56','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_56','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_56','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_56','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_56','resourcepool_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_56','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_56','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_56','alarm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_56','scheduledtask_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_57','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_57','arg_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_57','arg_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_57','arg_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_57','obj_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_57','obj_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_57','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_57','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_57','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_57','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_57','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_57','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_57','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_57','resourcepool_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_57','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_57','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_57','alarm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_57','scheduledtask_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_58','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_58','arg_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_58','arg_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_58','arg_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_58','obj_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_58','obj_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_58','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_58','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_58','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_58','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_58','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_58','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_58','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_58','resourcepool_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_58','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_58','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_58','alarm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_58','scheduledtask_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_59','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_59','arg_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_59','arg_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_59','arg_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_59','obj_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_59','obj_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_59','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_59','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_59','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_59','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_59','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_59','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_59','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_59','resourcepool_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_59','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_59','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_59','alarm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_59','scheduledtask_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_6','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_6','arg_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_6','arg_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_6','arg_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_6','obj_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_6','obj_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_6','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_6','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_6','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_6','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_6','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_6','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_6','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_6','resourcepool_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_6','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_6','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_6','alarm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_6','scheduledtask_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_60','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_60','arg_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_60','arg_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_60','arg_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_60','obj_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_60','obj_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_60','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_60','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_60','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_60','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_60','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_60','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_60','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_60','resourcepool_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_60','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_60','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_60','alarm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_60','scheduledtask_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_61','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_61','arg_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_61','arg_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_61','arg_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_61','obj_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_61','obj_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_61','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_61','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_61','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_61','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_61','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_61','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_61','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_61','resourcepool_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_61','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_61','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_61','alarm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_61','scheduledtask_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_62','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_62','arg_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_62','arg_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_62','arg_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_62','obj_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_62','obj_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_62','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_62','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_62','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_62','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_62','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_62','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_62','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_62','resourcepool_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_62','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_62','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_62','alarm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_62','scheduledtask_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_63','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_63','arg_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_63','arg_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_63','arg_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_63','obj_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_63','obj_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_63','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_63','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_63','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_63','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_63','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_63','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_63','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_63','resourcepool_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_63','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_63','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_63','alarm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_63','scheduledtask_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_64','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_64','arg_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_64','arg_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_64','arg_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_64','obj_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_64','obj_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_64','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_64','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_64','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_64','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_64','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_64','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_64','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_64','resourcepool_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_64','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_64','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_64','alarm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_64','scheduledtask_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_65','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_65','arg_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_65','arg_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_65','arg_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_65','obj_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_65','obj_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_65','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_65','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_65','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_65','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_65','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_65','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_65','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_65','resourcepool_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_65','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_65','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_65','alarm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_65','scheduledtask_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_66','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_66','arg_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_66','arg_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_66','arg_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_66','obj_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_66','obj_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_66','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_66','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_66','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_66','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_66','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_66','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_66','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_66','resourcepool_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_66','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_66','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_66','alarm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_66','scheduledtask_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_67','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_67','arg_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_67','arg_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_67','arg_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_67','obj_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_67','obj_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_67','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_67','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_67','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_67','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_67','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_67','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_67','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_67','resourcepool_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_67','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_67','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_67','alarm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_67','scheduledtask_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_68','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_68','arg_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_68','arg_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_68','arg_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_68','obj_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_68','obj_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_68','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_68','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_68','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_68','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_68','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_68','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_68','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_68','resourcepool_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_68','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_68','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_68','alarm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_68','scheduledtask_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_69','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_69','arg_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_69','arg_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_69','arg_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_69','obj_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_69','obj_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_69','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_69','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_69','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_69','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_69','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_69','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_69','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_69','resourcepool_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_69','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_69','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_69','alarm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_69','scheduledtask_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_7','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_7','arg_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_7','arg_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_7','arg_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_7','obj_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_7','obj_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_7','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_7','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_7','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_7','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_7','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_7','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_7','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_7','resourcepool_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_7','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_7','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_7','alarm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_7','scheduledtask_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_70','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_70','arg_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_70','arg_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_70','arg_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_70','obj_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_70','obj_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_70','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_70','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_70','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_70','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_70','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_70','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_70','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_70','resourcepool_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_70','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_70','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_70','alarm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_70','scheduledtask_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_71','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_71','arg_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_71','arg_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_71','arg_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_71','obj_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_71','obj_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_71','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_71','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_71','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_71','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_71','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_71','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_71','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_71','resourcepool_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_71','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_71','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_71','alarm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_71','scheduledtask_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_72','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_72','arg_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_72','arg_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_72','arg_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_72','obj_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_72','obj_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_72','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_72','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_72','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_72','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_72','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_72','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_72','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_72','resourcepool_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_72','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_72','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_72','alarm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_72','scheduledtask_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_73','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_73','arg_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_73','arg_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_73','arg_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_73','obj_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_73','obj_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_73','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_73','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_73','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_73','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_73','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_73','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_73','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_73','resourcepool_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_73','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_73','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_73','alarm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_73','scheduledtask_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_74','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_74','arg_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_74','arg_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_74','arg_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_74','obj_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_74','obj_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_74','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_74','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_74','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_74','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_74','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_74','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_74','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_74','resourcepool_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_74','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_74','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_74','alarm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_74','scheduledtask_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_75','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_75','arg_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_75','arg_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_75','arg_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_75','obj_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_75','obj_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_75','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_75','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_75','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_75','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_75','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_75','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_75','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_75','resourcepool_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_75','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_75','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_75','alarm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_75','scheduledtask_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_76','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_76','arg_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_76','arg_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_76','arg_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_76','obj_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_76','obj_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_76','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_76','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_76','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_76','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_76','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_76','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_76','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_76','resourcepool_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_76','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_76','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_76','alarm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_76','scheduledtask_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_77','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_77','arg_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_77','arg_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_77','arg_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_77','obj_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_77','obj_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_77','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_77','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_77','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_77','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_77','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_77','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_77','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_77','resourcepool_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_77','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_77','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_77','alarm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_77','scheduledtask_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_78','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_78','arg_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_78','arg_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_78','arg_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_78','obj_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_78','obj_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_78','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_78','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_78','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_78','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_78','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_78','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_78','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_78','resourcepool_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_78','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_78','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_78','alarm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_78','scheduledtask_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_79','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_79','arg_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_79','arg_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_79','arg_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_79','obj_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_79','obj_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_79','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_79','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_79','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_79','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_79','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_79','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_79','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_79','resourcepool_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_79','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_79','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_79','alarm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_79','scheduledtask_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_8','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_8','arg_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_8','arg_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_8','arg_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_8','obj_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_8','obj_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_8','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_8','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_8','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_8','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_8','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_8','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_8','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_8','resourcepool_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_8','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_8','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_8','alarm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_8','scheduledtask_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_80','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_80','arg_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_80','arg_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_80','arg_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_80','obj_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_80','obj_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_80','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_80','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_80','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_80','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_80','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_80','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_80','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_80','resourcepool_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_80','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_80','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_80','alarm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_80','scheduledtask_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_81','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_81','arg_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_81','arg_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_81','arg_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_81','obj_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_81','obj_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_81','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_81','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_81','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_81','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_81','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_81','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_81','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_81','resourcepool_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_81','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_81','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_81','alarm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_81','scheduledtask_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_82','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_82','arg_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_82','arg_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_82','arg_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_82','obj_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_82','obj_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_82','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_82','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_82','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_82','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_82','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_82','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_82','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_82','resourcepool_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_82','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_82','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_82','alarm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_82','scheduledtask_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_83','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_83','arg_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_83','arg_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_83','arg_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_83','obj_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_83','obj_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_83','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_83','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_83','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_83','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_83','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_83','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_83','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_83','resourcepool_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_83','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_83','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_83','alarm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_83','scheduledtask_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_84','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_84','arg_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_84','arg_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_84','arg_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_84','obj_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_84','obj_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_84','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_84','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_84','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_84','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_84','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_84','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_84','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_84','resourcepool_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_84','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_84','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_84','alarm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_84','scheduledtask_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_85','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_85','arg_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_85','arg_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_85','arg_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_85','obj_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_85','obj_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_85','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_85','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_85','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_85','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_85','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_85','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_85','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_85','resourcepool_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_85','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_85','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_85','alarm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_85','scheduledtask_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_86','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_86','arg_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_86','arg_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_86','arg_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_86','obj_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_86','obj_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_86','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_86','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_86','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_86','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_86','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_86','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_86','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_86','resourcepool_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_86','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_86','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_86','alarm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_86','scheduledtask_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_87','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_87','arg_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_87','arg_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_87','arg_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_87','obj_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_87','obj_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_87','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_87','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_87','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_87','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_87','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_87','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_87','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_87','resourcepool_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_87','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_87','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_87','alarm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_87','scheduledtask_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_88','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_88','arg_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_88','arg_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_88','arg_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_88','obj_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_88','obj_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_88','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_88','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_88','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_88','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_88','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_88','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_88','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_88','resourcepool_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_88','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_88','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_88','alarm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_88','scheduledtask_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_89','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_89','arg_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_89','arg_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_89','arg_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_89','obj_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_89','obj_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_89','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_89','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_89','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_89','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_89','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_89','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_89','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_89','resourcepool_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_89','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_89','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_89','alarm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_89','scheduledtask_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_9','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_9','arg_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_9','arg_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_9','arg_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_9','obj_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_9','obj_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_9','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_9','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_9','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_9','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_9','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_9','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_9','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_9','resourcepool_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_9','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_9','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_9','alarm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_9','scheduledtask_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_90','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_90','arg_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_90','arg_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_90','arg_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_90','obj_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_90','obj_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_90','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_90','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_90','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_90','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_90','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_90','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_90','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_90','resourcepool_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_90','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_90','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_90','alarm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_90','scheduledtask_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_91','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_91','arg_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_91','arg_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_91','arg_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_91','obj_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_91','obj_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_91','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_91','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_91','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_91','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_91','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_91','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_91','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_91','resourcepool_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_91','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_91','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_91','alarm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_91','scheduledtask_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_92','event_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_92','arg_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_92','arg_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_92','arg_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_92','obj_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_92','obj_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_92','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_92','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_92','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_92','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_92','network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_92','network_type','T','character',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_92','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_92','resourcepool_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_92','dvs_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_92','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_92','alarm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_arg_92','scheduledtask_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_partition_lookup','start_date','T','date',0,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_event_partition_lookup','partition_index','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ext','ext_id','T','character varying',255,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ext','version','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ext','heartbeat','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ext','subject_name','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ext','thumbprint','T','character varying',100,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ext','type_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ext','health_url','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ext','company','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ext','ovf_consumer_url','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ext','ovf_consumer_section_types','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ext','company_url','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ext','product_url','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ext','management_url','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ext','self_entity_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ext','in_solution_manager_flg','T','numeric',1,'NO','0');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ext','small_icon_url','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ext','desc_label','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ext','desc_summary','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ext_client','ext_client_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ext_client','ext_id','T','character varying',255,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ext_client','url','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ext_client','version','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ext_client','company','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ext_client','type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ext_client','desc_label','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ext_client','desc_summary','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ext_data','ext_id','T','character varying',255,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ext_data','data_key','T','character varying',255,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ext_data','data_value','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ext_data','surr_key','T','integer',32,'NO','nextval(''vpx_ext_data_surr_key_seq''::regclass)');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ext_managedby_info','ext_id','T','character varying',255,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ext_managedby_info','type','T','character varying',190,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ext_managedby_info','small_icon_url','T','text',0,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ext_managedby_info','description','T','text',0,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ext_managedby_info','icon_url','T','text',0,'NO','''''::text');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ext_privs','priv_id','T','character varying',255,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ext_privs','ext_id','T','character varying',255,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ext_privs','group_name','T','character varying',255,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ext_privs','surr_key','T','integer',32,'NO','nextval(''vpx_ext_privs_surr_key_seq''::regclass)');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ext_server','ext_server_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ext_server','ext_id','T','character varying',255,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ext_server','url','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ext_server','company','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ext_server','type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ext_server','server_thumbprint','T','character varying',100,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ext_server','desc_label','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ext_server','desc_summary','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ext_server_email','ext_email_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ext_server_email','ext_server_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ext_server_email','email_address','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ext_tabs','ext_id','T','character varying',255,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ext_tabs','tab_index','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ext_tabs','label','T','character varying',255,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ext_tabs','url','T','text',0,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ext_tabs','surr_key','T','integer',32,'NO','nextval(''vpx_ext_tabs_surr_key_seq''::regclass)');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ext_type_ids','ext_id','T','character varying',255,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ext_type_ids','type','T','character varying',255,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ext_type_ids','id','T','character varying',255,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ext_type_ids','type_schema','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ext_type_ids','surr_key','T','integer',32,'NO','nextval(''vpx_ext_type_ids_surr_key_seq''::regclass)');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_field_def','id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_field_def','name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_field_def','mo_type_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_field_def','create_def_priv','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_field_def','delete_def_priv','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_field_def','read_def_priv','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_field_def','update_def_priv','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_field_def','create_val_priv','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_field_def','delete_val_priv','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_field_def','read_val_priv','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_field_def','update_val_priv','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_field_val','field_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_field_val','entity_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_field_val','value','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_field_val','mo_id','T','character varying',255,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_file_system_mount_info','vpx_file_system_mount_info_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_file_system_mount_info','id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_guest_disk','vm_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_guest_disk','path','T','character varying',255,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_guest_disk','capacity','T','character varying',21,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_guest_disk','free_space','T','character varying',21,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_1','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_1','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_1','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_10','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_10','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_10','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_100','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_100','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_100','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_101','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_101','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_101','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_102','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_102','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_102','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_103','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_103','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_103','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_104','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_104','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_104','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_105','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_105','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_105','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_106','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_106','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_106','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_107','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_107','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_107','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_108','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_108','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_108','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_109','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_109','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_109','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_11','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_11','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_11','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_110','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_110','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_110','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_111','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_111','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_111','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_112','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_112','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_112','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_113','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_113','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_113','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_114','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_114','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_114','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_115','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_115','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_115','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_116','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_116','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_116','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_117','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_117','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_117','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_118','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_118','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_118','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_119','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_119','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_119','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_12','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_12','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_12','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_120','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_120','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_120','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_121','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_121','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_121','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_122','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_122','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_122','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_123','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_123','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_123','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_124','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_124','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_124','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_125','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_125','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_125','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_126','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_126','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_126','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_127','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_127','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_127','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_128','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_128','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_128','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_129','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_129','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_129','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_13','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_13','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_13','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_130','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_130','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_130','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_131','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_131','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_131','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_132','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_132','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_132','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_133','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_133','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_133','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_134','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_134','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_134','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_135','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_135','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_135','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_136','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_136','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_136','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_137','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_137','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_137','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_138','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_138','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_138','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_139','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_139','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_139','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_14','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_14','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_14','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_140','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_140','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_140','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_141','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_141','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_141','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_142','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_142','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_142','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_143','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_143','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_143','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_144','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_144','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_144','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_145','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_145','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_145','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_146','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_146','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_146','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_147','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_147','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_147','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_148','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_148','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_148','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_149','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_149','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_149','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_15','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_15','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_15','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_150','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_150','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_150','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_151','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_151','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_151','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_152','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_152','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_152','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_153','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_153','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_153','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_154','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_154','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_154','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_155','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_155','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_155','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_156','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_156','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_156','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_157','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_157','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_157','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_158','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_158','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_158','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_159','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_159','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_159','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_16','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_16','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_16','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_160','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_160','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_160','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_161','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_161','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_161','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_162','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_162','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_162','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_163','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_163','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_163','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_164','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_164','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_164','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_165','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_165','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_165','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_166','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_166','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_166','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_167','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_167','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_167','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_168','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_168','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_168','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_169','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_169','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_169','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_17','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_17','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_17','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_170','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_170','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_170','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_171','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_171','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_171','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_172','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_172','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_172','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_173','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_173','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_173','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_174','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_174','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_174','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_175','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_175','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_175','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_176','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_176','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_176','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_177','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_177','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_177','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_178','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_178','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_178','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_179','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_179','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_179','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_18','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_18','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_18','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_180','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_180','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_180','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_181','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_181','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_181','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_182','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_182','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_182','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_183','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_183','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_183','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_184','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_184','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_184','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_185','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_185','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_185','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_186','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_186','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_186','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_187','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_187','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_187','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_188','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_188','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_188','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_189','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_189','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_189','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_19','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_19','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_19','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_190','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_190','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_190','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_191','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_191','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_191','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_192','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_192','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_192','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_193','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_193','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_193','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_194','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_194','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_194','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_195','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_195','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_195','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_196','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_196','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_196','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_197','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_197','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_197','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_198','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_198','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_198','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_199','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_199','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_199','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_2','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_2','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_2','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_20','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_20','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_20','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_200','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_200','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_200','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_201','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_201','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_201','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_202','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_202','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_202','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_203','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_203','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_203','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_204','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_204','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_204','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_205','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_205','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_205','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_206','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_206','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_206','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_207','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_207','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_207','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_208','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_208','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_208','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_209','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_209','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_209','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_21','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_21','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_21','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_210','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_210','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_210','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_211','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_211','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_211','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_212','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_212','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_212','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_213','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_213','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_213','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_214','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_214','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_214','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_215','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_215','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_215','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_216','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_216','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_216','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_217','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_217','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_217','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_218','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_218','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_218','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_219','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_219','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_219','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_22','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_22','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_22','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_220','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_220','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_220','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_221','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_221','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_221','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_222','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_222','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_222','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_223','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_223','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_223','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_224','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_224','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_224','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_225','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_225','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_225','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_226','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_226','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_226','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_227','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_227','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_227','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_228','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_228','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_228','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_229','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_229','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_229','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_23','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_23','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_23','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_230','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_230','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_230','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_231','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_231','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_231','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_232','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_232','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_232','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_233','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_233','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_233','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_234','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_234','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_234','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_235','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_235','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_235','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_236','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_236','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_236','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_237','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_237','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_237','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_238','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_238','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_238','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_239','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_239','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_239','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_24','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_24','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_24','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_240','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_240','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_240','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_241','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_241','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_241','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_25','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_25','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_25','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_26','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_26','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_26','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_27','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_27','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_27','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_28','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_28','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_28','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_29','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_29','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_29','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_3','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_3','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_3','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_30','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_30','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_30','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_31','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_31','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_31','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_32','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_32','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_32','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_33','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_33','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_33','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_34','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_34','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_34','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_35','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_35','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_35','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_36','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_36','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_36','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_37','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_37','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_37','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_38','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_38','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_38','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_39','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_39','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_39','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_4','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_4','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_4','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_40','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_40','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_40','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_41','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_41','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_41','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_42','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_42','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_42','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_43','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_43','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_43','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_44','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_44','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_44','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_45','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_45','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_45','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_46','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_46','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_46','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_47','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_47','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_47','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_48','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_48','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_48','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_49','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_49','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_49','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_5','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_5','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_5','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_50','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_50','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_50','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_51','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_51','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_51','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_52','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_52','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_52','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_53','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_53','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_53','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_54','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_54','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_54','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_55','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_55','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_55','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_56','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_56','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_56','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_57','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_57','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_57','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_58','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_58','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_58','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_59','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_59','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_59','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_6','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_6','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_6','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_60','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_60','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_60','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_61','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_61','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_61','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_62','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_62','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_62','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_63','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_63','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_63','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_64','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_64','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_64','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_65','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_65','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_65','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_66','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_66','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_66','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_67','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_67','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_67','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_68','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_68','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_68','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_69','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_69','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_69','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_7','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_7','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_7','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_70','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_70','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_70','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_71','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_71','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_71','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_72','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_72','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_72','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_73','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_73','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_73','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_74','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_74','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_74','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_75','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_75','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_75','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_76','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_76','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_76','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_77','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_77','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_77','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_78','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_78','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_78','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_79','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_79','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_79','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_8','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_8','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_8','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_80','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_80','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_80','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_81','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_81','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_81','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_82','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_82','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_82','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_83','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_83','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_83','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_84','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_84','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_84','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_85','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_85','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_85','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_86','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_86','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_86','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_87','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_87','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_87','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_88','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_88','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_88','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_89','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_89','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_89','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_9','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_9','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_9','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_90','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_90','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_90','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_91','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_91','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_91','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_92','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_92','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_92','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_93','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_93','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_93','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_94','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_94','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_94','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_95','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_95','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_95','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_96','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_96','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_96','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_97','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_97','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_97','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_98','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_98','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_98','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_99','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_99','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat1_99','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_1','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_1','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_1','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_10','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_10','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_10','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_11','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_11','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_11','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_12','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_12','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_12','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_13','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_13','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_13','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_14','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_14','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_14','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_15','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_15','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_15','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_16','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_16','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_16','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_17','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_17','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_17','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_18','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_18','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_18','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_19','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_19','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_19','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_2','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_2','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_2','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_20','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_20','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_20','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_21','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_21','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_21','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_22','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_22','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_22','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_23','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_23','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_23','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_24','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_24','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_24','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_25','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_25','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_25','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_26','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_26','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_26','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_27','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_27','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_27','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_28','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_28','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_28','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_29','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_29','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_29','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_3','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_3','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_3','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_30','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_30','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_30','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_31','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_31','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_31','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_32','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_32','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_32','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_33','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_33','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_33','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_34','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_34','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_34','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_35','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_35','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_35','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_36','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_36','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_36','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_37','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_37','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_37','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_38','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_38','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_38','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_39','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_39','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_39','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_4','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_4','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_4','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_40','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_40','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_40','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_41','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_41','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_41','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_42','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_42','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_42','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_43','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_43','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_43','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_44','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_44','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_44','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_45','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_45','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_45','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_46','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_46','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_46','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_47','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_47','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_47','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_48','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_48','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_48','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_49','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_49','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_49','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_5','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_5','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_5','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_50','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_50','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_50','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_51','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_51','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_51','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_52','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_52','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_52','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_53','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_53','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_53','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_54','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_54','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_54','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_55','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_55','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_55','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_56','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_56','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_56','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_57','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_57','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_57','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_58','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_58','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_58','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_59','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_59','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_59','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_6','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_6','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_6','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_60','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_60','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_60','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_61','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_61','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_61','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_62','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_62','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_62','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_63','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_63','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_63','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_64','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_64','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_64','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_65','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_65','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_65','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_66','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_66','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_66','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_67','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_67','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_67','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_68','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_68','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_68','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_69','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_69','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_69','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_7','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_7','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_7','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_70','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_70','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_70','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_71','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_71','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_71','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_72','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_72','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_72','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_73','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_73','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_73','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_74','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_74','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_74','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_75','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_75','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_75','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_76','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_76','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_76','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_77','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_77','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_77','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_78','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_78','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_78','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_79','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_79','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_79','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_8','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_8','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_8','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_80','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_80','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_80','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_81','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_81','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_81','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_82','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_82','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_82','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_83','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_83','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_83','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_84','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_84','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_84','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_85','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_85','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_85','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_9','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_9','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat2_9','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_1','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_1','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_1','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_10','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_10','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_10','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_11','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_11','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_11','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_12','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_12','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_12','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_13','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_13','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_13','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_14','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_14','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_14','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_15','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_15','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_15','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_16','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_16','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_16','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_17','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_17','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_17','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_18','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_18','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_18','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_19','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_19','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_19','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_2','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_2','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_2','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_20','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_20','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_20','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_21','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_21','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_21','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_22','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_22','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_22','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_23','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_23','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_23','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_24','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_24','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_24','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_25','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_25','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_25','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_26','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_26','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_26','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_27','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_27','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_27','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_28','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_28','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_28','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_29','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_29','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_29','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_3','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_3','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_3','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_30','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_30','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_30','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_31','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_31','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_31','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_32','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_32','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_32','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_4','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_4','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_4','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_5','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_5','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_5','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_6','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_6','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_6','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_7','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_7','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_7','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_8','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_8','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_8','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_9','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_9','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat3_9','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_1','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_1','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_1','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_10','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_10','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_10','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_100','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_100','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_100','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_101','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_101','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_101','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_102','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_102','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_102','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_103','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_103','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_103','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_104','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_104','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_104','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_105','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_105','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_105','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_106','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_106','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_106','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_107','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_107','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_107','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_108','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_108','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_108','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_109','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_109','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_109','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_11','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_11','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_11','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_110','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_110','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_110','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_111','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_111','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_111','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_112','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_112','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_112','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_113','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_113','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_113','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_114','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_114','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_114','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_115','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_115','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_115','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_116','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_116','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_116','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_117','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_117','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_117','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_118','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_118','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_118','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_119','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_119','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_119','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_12','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_12','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_12','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_120','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_120','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_120','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_121','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_121','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_121','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_122','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_122','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_122','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_123','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_123','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_123','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_124','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_124','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_124','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_125','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_125','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_125','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_126','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_126','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_126','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_127','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_127','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_127','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_128','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_128','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_128','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_129','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_129','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_129','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_13','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_13','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_13','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_130','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_130','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_130','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_131','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_131','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_131','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_132','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_132','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_132','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_133','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_133','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_133','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_134','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_134','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_134','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_135','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_135','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_135','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_136','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_136','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_136','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_137','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_137','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_137','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_138','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_138','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_138','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_139','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_139','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_139','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_14','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_14','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_14','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_140','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_140','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_140','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_141','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_141','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_141','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_142','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_142','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_142','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_143','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_143','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_143','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_144','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_144','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_144','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_145','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_145','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_145','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_146','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_146','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_146','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_147','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_147','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_147','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_148','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_148','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_148','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_149','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_149','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_149','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_15','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_15','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_15','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_150','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_150','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_150','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_151','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_151','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_151','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_152','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_152','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_152','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_153','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_153','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_153','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_154','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_154','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_154','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_155','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_155','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_155','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_156','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_156','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_156','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_157','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_157','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_157','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_158','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_158','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_158','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_159','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_159','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_159','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_16','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_16','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_16','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_160','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_160','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_160','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_161','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_161','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_161','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_162','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_162','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_162','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_163','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_163','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_163','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_164','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_164','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_164','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_165','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_165','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_165','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_166','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_166','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_166','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_167','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_167','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_167','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_168','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_168','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_168','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_169','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_169','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_169','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_17','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_17','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_17','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_170','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_170','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_170','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_171','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_171','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_171','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_172','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_172','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_172','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_173','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_173','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_173','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_174','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_174','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_174','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_175','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_175','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_175','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_176','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_176','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_176','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_177','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_177','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_177','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_178','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_178','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_178','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_179','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_179','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_179','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_18','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_18','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_18','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_180','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_180','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_180','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_181','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_181','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_181','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_182','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_182','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_182','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_183','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_183','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_183','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_19','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_19','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_19','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_2','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_2','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_2','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_20','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_20','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_20','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_21','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_21','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_21','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_22','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_22','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_22','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_23','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_23','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_23','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_24','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_24','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_24','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_25','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_25','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_25','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_26','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_26','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_26','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_27','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_27','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_27','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_28','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_28','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_28','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_29','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_29','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_29','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_3','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_3','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_3','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_30','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_30','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_30','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_31','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_31','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_31','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_32','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_32','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_32','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_33','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_33','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_33','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_34','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_34','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_34','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_35','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_35','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_35','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_36','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_36','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_36','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_37','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_37','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_37','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_38','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_38','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_38','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_39','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_39','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_39','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_4','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_4','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_4','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_40','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_40','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_40','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_41','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_41','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_41','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_42','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_42','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_42','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_43','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_43','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_43','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_44','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_44','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_44','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_45','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_45','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_45','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_46','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_46','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_46','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_47','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_47','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_47','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_48','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_48','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_48','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_49','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_49','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_49','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_5','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_5','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_5','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_50','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_50','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_50','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_51','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_51','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_51','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_52','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_52','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_52','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_53','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_53','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_53','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_54','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_54','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_54','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_55','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_55','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_55','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_56','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_56','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_56','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_57','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_57','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_57','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_58','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_58','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_58','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_59','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_59','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_59','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_6','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_6','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_6','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_60','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_60','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_60','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_61','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_61','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_61','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_62','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_62','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_62','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_63','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_63','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_63','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_64','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_64','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_64','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_65','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_65','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_65','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_66','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_66','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_66','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_67','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_67','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_67','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_68','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_68','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_68','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_69','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_69','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_69','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_7','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_7','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_7','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_70','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_70','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_70','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_71','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_71','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_71','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_72','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_72','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_72','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_73','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_73','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_73','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_74','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_74','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_74','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_75','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_75','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_75','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_76','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_76','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_76','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_77','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_77','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_77','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_78','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_78','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_78','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_79','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_79','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_79','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_8','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_8','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_8','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_80','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_80','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_80','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_81','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_81','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_81','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_82','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_82','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_82','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_83','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_83','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_83','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_84','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_84','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_84','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_85','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_85','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_85','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_86','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_86','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_86','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_87','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_87','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_87','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_88','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_88','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_88','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_89','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_89','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_89','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_9','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_9','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_9','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_90','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_90','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_90','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_91','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_91','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_91','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_92','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_92','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_92','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_93','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_93','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_93','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_94','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_94','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_94','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_95','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_95','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_95','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_96','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_96','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_96','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_97','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_97','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_97','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_98','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_98','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_98','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_99','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_99','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_hist_stat4_99','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host','id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host','datacenter_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host','dns_name','T','character varying',255,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host','ip_address','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host','expected_ssl_thumbprint','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host','host_ssl_thumbprint','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host','user_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host','password','T','character varying',686,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host','password_last_upd_dt','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host','ipmi_ip_address','T','character varying',50,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host','ipmi_mac_address','T','character varying',18,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host','ipmi_user_name','T','character varying',17,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host','ipmi_password','T','character varying',686,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host','soap_port','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host','authd_port','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host','vpxa_id','T','character varying',21,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host','master_gen','T','character varying',21,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host','master_spec_gen','T','character varying',21,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host','uuid_bios','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host','enabled','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host','vmotion_enabled','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host','licensed_edition','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host','product_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host','product_fullname','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host','product_vendor','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host','product_version','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host','product_build','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host','product_os_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host','product_line_id','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host','product_api_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host','product_api_version','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host','capability','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host','host_vendor','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host','host_model','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host','cpu_model','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host','cpu_count','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host','cpu_core_count','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host','cpu_thread_count','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host','numa_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host','cpu_hz','T','character varying',21,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host','mem_size','T','character varying',21,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host','smc_present','T','numeric',1,'NO','0');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host','cpu_power_mgmt_policy','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host','cpu_power_mgmt_support','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host','nic_count','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host','hba_count','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host','config','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host','vm_hardware_info','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host','vm_prov_policy','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host','root_res_config','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host','last_perf_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host','perf_refresh_rate','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host','boot_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host','boot_time_on_host','T','numeric',21,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host','das_node_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host','maintenance_mode','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host','power_state','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host','default_vm_path','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host','resource_info','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host','config_manager','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host','local_ip_address','T','character varying',50,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host','host_key','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host','admin_disabled_flg','T','numeric',1,'NO','0');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host','management_ip','T','character varying',50,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host','faulttolerance_enabled_flg','T','numeric',1,'NO','0');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host','agent_vm_datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host','agent_vm_network_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host','licensable_resources','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host','endorsement_key','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host','attestation_identity_key','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host','cnx_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host','network_runtime_info','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host','gateway_type','T','character varying',64,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host','gateway_id','T','character varying',128,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host','gateway_trust_token','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host','pmem_capacity_in_mb','T','bigint',64,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host','crypto_state','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host','crypto_key_id','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host','crypto_key_provider_id','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_bus_adapter','id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_bus_adapter','key_val','T','character varying',512,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_bus_adapter','host_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_bus_adapter','vpx_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_config_info','id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_config_info','array_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_cpu','host_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_cpu','cpu_index','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_cpu','hz','T','character varying',21,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_cpu','bus_hz','T','character varying',21,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_cpu','description','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_cpu','vendor','T','character varying',255,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_cpu_cpuid_feature','host_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_cpu_cpuid_feature','cpu_index','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_cpu_cpuid_feature','cpu_feature_level','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_cpu_cpuid_feature','cpu_feature_vendor','T','character varying',16,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_cpu_cpuid_feature','cpu_eax','T','character varying',40,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_cpu_cpuid_feature','cpu_ebx','T','character varying',40,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_cpu_cpuid_feature','cpu_ecx','T','character varying',40,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_cpu_cpuid_feature','cpu_edx','T','character varying',40,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_cpu_thread','host_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_cpu_thread','cpu_index','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_cpu_thread','thread_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_cpuid_feature','host_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_cpuid_feature','host_feature_level','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_cpuid_feature','host_feature_vendor','T','character varying',16,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_cpuid_feature','host_eax','T','character varying',40,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_cpuid_feature','host_ebx','T','character varying',40,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_cpuid_feature','host_ecx','T','character varying',40,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_cpuid_feature','host_edx','T','character varying',40,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_cpuid_feature','surr_key','T','integer',32,'NO','nextval(''vpx_host_cpuid_feature_surr_key_seq''::regclass)');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_crypto_keys','host_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_crypto_keys','crypto_key_id','T','character varying',255,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_crypto_keys','crypto_key_provider_id','T','character varying',255,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_crypto_keys','usage_count','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_disableadmin','host_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_disableadmin','entity_type','T','character varying',256,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_disableadmin','entity_moid','T','character varying',256,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_disableadmin','principal_name','T','character varying',180,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_disableadmin','group_flg','T','numeric',1,'NO','0');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_disableadmin','propagate_flg','T','numeric',1,'NO','0');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_disableadmin','role_id_val','T','numeric',10,'NO','0');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_gw_params','host_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_gw_params','param_name','T','character varying',255,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_gw_params','value','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_internal_capability','host_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_internal_capability','enumerate_extents_flg','T','numeric',1,'NO','0');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_internal_capability','fast_suspend_resume_flg','T','numeric',1,'NO','0');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_internal_capability','svm_vmx_diskcopy_flg','T','numeric',1,'NO','0');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_internal_capability','lun_display_name_flg','T','numeric',1,'NO','0');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_internal_capability','hostprofile_engine_flg','T','numeric',1,'NO','0');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_internal_capability','internal_capability','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_node','host_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_node','numa_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_node','mem_range_begin','T','character varying',21,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_node','mem_range_length','T','character varying',21,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_node_cpu','host_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_node_cpu','numa_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_node_cpu','cpu_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_pci_device','host_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_pci_device','pci_id','T','character varying',255,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_pci_device','class_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_pci_device','bus','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_pci_device','slot','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_pci_device','pci_function','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_pci_device','vendor_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_pci_device','sub_vendor_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_pci_device','vendor_name','T','character varying',255,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_pci_device','device_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_pci_device','sub_device_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_pci_device','device_name','T','character varying',450,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_pci_device','surr_key','T','integer',32,'NO','nextval(''vpx_host_pci_device_surr_key_seq''::regclass)');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_profile','profile_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_profile','ref_host_entity_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_profile','created_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_system_id_info','host_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_system_id_info','system_identification_info','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_text','id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_text','type_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_text','value','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_vflash','host_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_vflash','capacity','T','character varying',21,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_vflash','usage','T','character varying',21,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_vflash','capacity_vmcache','T','character varying',21,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_vflash','free_vmcache','T','character varying',21,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_vflash','accessible','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_vm_config_option','host_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_vm_config_option','config_option_ver','T','character varying',255,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_vm_config_option','data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_vm_config_option','array_index','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_vm_config_option','config_option_desc','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_vm_config_option','create_supported_flg','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_vm_config_option','default_config_option_flg','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_vm_config_option','run_supported_flg','T','numeric',1,'NO','1');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_vm_config_option','upgrade_supported_flg','T','numeric',1,'NO','1');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_x','host_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_x','system_health','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_x','das_node_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_x','das_event_version','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_x','das_event_key','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_x','das_fdm_state_source','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_x','das_vc_state','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_x','das_fdm_state','T','character varying',128,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_x','bios_version','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_host_x','bios_release_date','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_index_column','table_name','T','character varying',30,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_index_column','index_name','T','character varying',30,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_index_column','col_name','T','character varying',30,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_infra_upd_ha_clstr_cfg','cluster_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_infra_upd_ha_clstr_cfg','is_enabled','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_infra_upd_ha_clstr_cfg','behavior','T','character varying',56,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_infra_upd_ha_clstr_cfg','moderate_remediation','T','character varying',56,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_infra_upd_ha_clstr_cfg','severe_remediation','T','character varying',56,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_infra_upd_ha_cp','cluster_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_infra_upd_ha_cp','provider_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_infra_upd_ha_f_c_cfg','filter_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_infra_upd_ha_f_c_cfg','cluster_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_infra_upd_ha_f_h_cfg','filter_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_infra_upd_ha_f_h_cfg','host_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_infra_upd_ha_filter','filter_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_infra_upd_ha_filter','provider_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_infra_upd_ha_filter','uuid','T','character',47,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_infra_upd_ha_filter','name','T','character varying',56,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_infra_upd_ha_fltr_inf','filter_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_infra_upd_ha_fltr_inf','hu_info_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_infra_upd_ha_hu_info','hu_info_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_infra_upd_ha_hu_info','provider_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_infra_upd_ha_hu_info','name','T','character varying',56,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_infra_upd_ha_hu_info','component_type','T','character varying',56,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_infra_upd_ha_hu_info','description','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_infra_upd_ha_p_h','provider_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_infra_upd_ha_p_h','host_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_infra_upd_ha_provider','provider_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_infra_upd_ha_provider','provider_uuid','T','character',47,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_infra_upd_ha_provider','provider_name','T','character varying',56,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_infra_upd_ha_provider','user_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_int_array','array_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_int_array','type_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_int_array','value','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_int_array','array_index','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_int_array','mo_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_int_array','mo_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_int_array','surr_key','T','integer',32,'NO','nextval(''vpx_int_array_surr_key_seq''::regclass)');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ip_address','entity_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ip_address','device_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ip_address','ip_address','T','character varying',50,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ip_address','surr_key','T','integer',32,'NO','nextval(''vpx_ip_address_surr_key_seq''::regclass)');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ip_pool','id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ip_pool','datacenter_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ip_pool','name','T','character varying',255,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ip_pool','ipv4_subnet','T','character varying',16,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ip_pool','ipv4_netmask','T','character varying',16,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ip_pool','ipv4_gateway','T','character varying',16,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ip_pool','ipv4_range','T','character varying',128,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ip_pool','ipv4_dns','T','character varying',128,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ip_pool','ipv4_enabled','T','numeric',1,'NO','0');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ip_pool','ipv4_dhcp','T','numeric',1,'NO','0');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ip_pool','ipv6_subnet','T','character varying',128,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ip_pool','ipv6_netmask','T','character varying',128,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ip_pool','ipv6_gateway','T','character varying',128,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ip_pool','ipv6_range','T','character varying',128,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ip_pool','ipv6_dns','T','character varying',128,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ip_pool','ipv6_enabled','T','numeric',1,'NO','0');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ip_pool','ipv6_dhcp','T','numeric',1,'NO','0');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ip_pool','dns_domain','T','character varying',256,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ip_pool','dns_search_path','T','character varying',128,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ip_pool','host_prefix','T','character varying',128,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ip_pool','http_proxy','T','character varying',128,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ip_pool_allocation','pool_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ip_pool_allocation','allocation_id','T','character varying',255,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ip_pool_allocation','extension_key','T','character varying',255,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ip_pool_allocation','ip_address','T','character varying',50,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ip_pool_allocation','surr_key','T','integer',32,'NO','nextval(''vpx_ip_pool_allocation_surr_key_seq''::regclass)');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ip_pool_association','network_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ip_pool_association','pool_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_job_log','job_id','T','numeric',5,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_job_log','status','T','character varying',10,'NO','''WAITING''::character varying');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_job_log','last_run','T','timestamp without time zone',0,'NO','to_timestamp(''01.01.1900 00:00:00''::text, ''DD.MM.YYYY HH24:MI:SS''::text)');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_journal','id','T','bigint',64,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_journal','type','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_journal_entry','journal_id','T','bigint',64,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_journal_entry','entry_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_journal_entry','entry_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_journal_entry','entry_value','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_lic_auto_keys','entity_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_lic_auto_keys','asset_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_lic_auto_keys','license','T','text',0,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_lic_tps_assets','asset_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_lic_tps_assets','asset_name','T','character varying',64,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_lic_tps_assets','description','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_lock','id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_mac_xvc_vmotion','mac_address','T','character varying',20,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_multipathstateinfo_path','id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_multipathstateinfo_path','path_name','T','character varying',512,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_multipathstateinfo_path','path_state','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_multipathstateinfo_path','surr_key','T','integer',32,'NO','nextval(''vpx_multipathstateinfo_path_surr_key_seq''::regclass)');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_network','id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_network','name','T','character varying',128,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_network','datacenter_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_network','opaque_id','T','character varying',128,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_network','opaque_type','T','character varying',128,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_network','opaque_capability','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_network','opaque_extra_config','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_nic','entity_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_nic','device_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_nic','mac_address','T','character varying',20,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_nic','is_connected','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_nic','network_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_nic','dns_config','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_nic','ip_config','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_nic','net_bios_config','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_nic','surr_key','T','integer',32,'NO','nextval(''vpx_nic_surr_key_seq''::regclass)');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_nw_assignment','network_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_nw_assignment','entity_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_object_type','id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_object_type','name','T','character varying',30,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ovfenv','id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ovfenv','public_ovfenv','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_ovfenv','private_ovfenv','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_parameter','name','T','character varying',255,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_parameter','value','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_patch_version','initial_version','T','character varying',10,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_patch_version','current_version','T','character varying',10,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_priv_role','priv_name','T','character varying',255,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_priv_role','role_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_priv_role','surr_key','T','integer',32,'NO','nextval(''vpx_priv_role_surr_key_seq''::regclass)');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_proc_log','proc_name','T','character varying',50,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_proc_log','start_dt','T','timestamp without time zone',0,'NO','timezone(''UTC''::text, now())');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_proc_log','end_dt','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_proc_log','err_flag','T','character',1,'NO','''N''::bpchar');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_proc_log','chk_flag','T','character',1,'NO','''N''::bpchar');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_proc_log','src_rows','T','numeric',38,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_proc_log','tgt_rows','T','numeric',38,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_proc_log','chk_results','T','character varying',200,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_proc_log','description','T','character varying',1000,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_product','product_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_product','product_desc','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_profile','profile_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_profile','compliance_status','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_profile','profile_name','T','character varying',512,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_profile','modified_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_profile','config_info','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_profile','type_code','T','numeric',3,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_profile','created_time','T','timestamp without time zone',0,'NO','now()');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_profile_answer_file','answerfile_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_profile_answer_file','host_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_profile_answer_file','status','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_profile_answer_file','created_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_profile_answer_file','modified_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_profile_answer_file','user_input','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_profile_entity_association','profile_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_profile_entity_association','entity_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_profile_host_spec','host_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_profile_host_spec','created_time','T','timestamp with time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_profile_host_spec','modified_time','T','timestamp with time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_profile_host_spec','start_time','T','timestamp with time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_profile_host_spec','change_id','T','bigint',64,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_profile_host_spec','host_spec','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_psa_adapter','id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_psa_adapter','host_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_psa_adapter','key_val','T','character varying',512,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_psa_adapter','hba_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_psa_adapter','link_key','T','character varying',512,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_psa_device','id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_psa_device','host_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_psa_device','key_val','T','character varying',512,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_psa_device','scsi_lun_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_psa_device','link_key','T','character varying',512,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_psa_path','host_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_psa_path','path_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_psa_path','key_val','T','character varying',440,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_psa_path','lun_number','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_psa_path','scsi_lun_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_psa_path','hba_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_psa_path','target_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_psa_path','lun_link_key','T','character varying',512,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_psa_path','adapter_link_key','T','character varying',512,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_psa_path','target_link_key','T','character varying',512,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_psa_target','id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_psa_target','host_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_psa_target','key_val','T','character varying',512,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_psa_target_transport','id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_psa_target_transport','host_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_psa_target_transport','update_key','T','character varying',512,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_remote_cnx','id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_remote_cnx','cnx_type','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_remote_cnx','host_name','T','character varying',255,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_remote_cnx','port','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_remote_cnx','ssl','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_remote_cnx','user_name','T','character varying',255,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_remote_cnx','password','T','character varying',686,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_remote_cnx','samltoken','T','text',0,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_remote_cnx','ssl_thumbprint','T','character varying',255,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_remote_cnx','connect_state','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_remote_cnx','state_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_remote_cnx','session_id','T','character varying',80,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_remote_cnx','api_version','T','character varying',80,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_remote_cnx','wfu_version','T','character varying',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_remote_cnx_listener','host_cnx_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_remote_cnx_listener','type_name','T','character varying',255,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_remote_cnx_listener','filter_ref','T','character varying',255,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_remote_cnx_listener','state_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_resource_pool','id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_resource_pool','config_spec','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_resource_pool','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_resource_pool','vapp_config','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_resource_pool','managed_by_ext_key','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_resource_pool','managed_by_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_role','id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_role','name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sample','id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sample','sample_time','T','timestamp without time zone',0,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sample','sample_interval','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sample_time1','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sample_time1','sample_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sample_time1','sample_interval','T','numeric',10,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sample_time1','partition_index','T','numeric',3,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sample_time1','rollup_counter','T','numeric',38,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sample_time1','partition_index_hs2','T','numeric',3,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sample_time2','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sample_time2','sample_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sample_time2','sample_interval','T','numeric',10,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sample_time2','partition_index','T','numeric',3,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sample_time2','rollup_counter','T','numeric',38,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sample_time2','partition_index_hs3','T','numeric',3,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sample_time3','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sample_time3','sample_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sample_time3','sample_interval','T','numeric',10,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sample_time3','partition_index','T','numeric',3,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sample_time3','rollup_counter','T','numeric',38,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sample_time3','partition_index_hs4','T','numeric',3,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sample_time4','time_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sample_time4','sample_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sample_time4','sample_interval','T','numeric',10,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sample_time4','partition_index','T','numeric',3,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sample_time4','rollup_counter','T','numeric',38,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sched_action','scheduledtask_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sched_action','action_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sched_action','action_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sched_scheduler','scheduledtask_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sched_scheduler','scheduler_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sched_scheduler','active_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sched_scheduler','expire_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sched_scheduler','run_at','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sched_scheduler','interval','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sched_scheduler','schedule_minute','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sched_scheduler','schedule_hour','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sched_scheduler','schedule_day','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sched_scheduler','schedule_sunday','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sched_scheduler','schedule_monday','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sched_scheduler','schedule_tuesday','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sched_scheduler','schedule_wednesday','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sched_scheduler','schedule_thursday','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sched_scheduler','schedule_friday','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sched_scheduler','schedule_saturday','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_scheduledtask','scheduledtask_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_scheduledtask','name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_scheduledtask','description','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_scheduledtask','enabled','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_scheduledtask','notification','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_scheduledtask','entity_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_scheduledtask','entity_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_scheduledtask','object_moid','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_scheduledtask','lastmodifiedtime','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_scheduledtask','lastmodifieduser','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_scheduledtask','nextruntime','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_scheduledtask','prevruntime','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_scheduledtask','complete_state','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_scheduledtask','error_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_scheduledtask','result_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_scheduledtask','task_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_schema_hash','schema_hash','T','character varying',50,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_schema_hash','build_num','T','character varying',30,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_scsi_disk_partition','host_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_scsi_disk_partition','vpx_file_system_mount_info_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_scsi_disk_partition','disk_name','T','character varying',2000,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_scsi_lun','id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_scsi_lun','host_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_scsi_lun','uuid','T','character varying',255,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_scsi_lun','canonical_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_scsi_lun','display_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_scsi_lun','key_val','T','character varying',512,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_scsi_lun','array_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_scsi_lun','vpx_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_scsi_lun','update_display_name_flg','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_scsilun_descriptor','descriptor_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_scsilun_descriptor','id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_scsilun_descriptor','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_scsilun_descriptor','update_key','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_scsilun_descriptor','descriptor_id_val','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_scsilun_descriptor','quality','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sdrs_pod_config','pod_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sdrs_pod_config','config_xml','T','text',0,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sdrs_stats_datastore','uuid','T','character varying',64,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sdrs_stats_datastore','quantiles','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sdrs_stats_datastore','history','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sdrs_stats_datastore','injector','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sdrs_stats_vm','vm_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sdrs_stats_vm','quantiles','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sdrs_stats_vm','history','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sdrs_stats_vm','space_stats','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sequence','name','T','character varying',30,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sequence','id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','change_version','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','array_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','change_tracking_enabled','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','cpu_hot_add_enabled','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','cpu_hot_remove_enabled','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','mem_hot_add_enabled','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','vasserts_enabled','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','network_shaper_average_bps','T','character varying',22,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','network_shaper_burst_size','T','character varying',22,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','network_shaper_enabled_flg','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','network_shaper_peak_bps','T','character varying',22,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','hardware_num','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','hardware_memory','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','conprefe_cl_po_suspend_flg','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','conprefe_scr_power_on_flg','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','conprefe_poweronwhenopened_flg','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','tools_before_guest_standby_flg','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','tools_before_guest_reboot_flg','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','tools_before_guestshutdown_flg','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','tools_tools_upgrade_policy','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','tools_after_resume_flg','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','tools_after_power_on_flg','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','tools_sync_time_with_host_flg','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','tools_pending_customization','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','tools_tools_version','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','guest_full_name','T','character varying',512,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','instance_uuid','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','uuid','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','annotation','T','character varying',2000,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','version','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','template_flg','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','mem_allocation_overhead_limit','T','character varying',22,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','memory_allocation_reservation','T','character varying',22,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','memory_allocation_limit','T','character varying',22,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','mem_allocation_shares_shares','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','mem_allocation_shares_level','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','mem_allocexpan_reservation_flg','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','hot_plug_memory_limit','T','character varying',22,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','files_log_directory','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','files_snapshot_directory','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','files_vm_path_name','T','character varying',512,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','files_suspend_directory','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','files_ftmetadata_directory','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','alternate_guest_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','swap_placement','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','location_id','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','guest_id','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','boot_optionenter_biossetup_flg','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','boot_option_boot_delay','T','character varying',22,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','cpu_allocation_overhead_limit','T','character varying',22,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','cpu_allocation_reservation','T','character varying',22,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','cpu_allocation_limit','T','character varying',22,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','cpu_allocation_shares_shares','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','cpu_allocation_shares_level','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','c_alloc_expandable_reserv_flg','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','def_po_ops_default_reset_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','def_po_o_default_suspend_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','def_power_ops_suspend_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','def_power_ops_standby_action','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','def_po_o_def_power_off_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','default_power_ops_reset_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','def_power_ops_power_off_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','h_plug_memory_increment_size','T','character varying',22,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','npiv_world_wide_name_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','npiv_temp_disabled','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','npiv_on_rdm','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','npiv_desired_nwwn','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','npiv_desired_pwwn','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','modified','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','disk_uuid_enabled_flg','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','snapshot_disabled_flg','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','record_replay_enabled_flg','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','fault_tolerance_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','run_with_debug_info_flg','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','virtual_mmu_usage','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','virtual_exec_usage','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','enable_logging_flg','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','snapshot_locked_flg','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','ht_sharing','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','disable_acceleration_flg','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','fl_snapshot_power_off_behavior','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','flags_monitor_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','use_toe_flg','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','preserved_swap_onpoweroff_flg','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','swap_dir','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','boot_option_retry_enabled_flg','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','boot_option_retry_delay','T','numeric',22,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','managed_by_ext_key','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','managed_by_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','hardware_cores','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','firmware','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','max_mks_connections','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','nested_hv_enabled','T','numeric',1,'YES','0');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','virtual_pmc_enabled','T','numeric',1,'YES','0');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','sched_hw_upgrade_policy','T','character varying',22,'YES','''never''::character varying');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','sched_hw_upgrade_version','T','character varying',22,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','sched_hw_upgrade_status','T','character varying',22,'YES','''none''::character varying');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','tools_lastinstall_counter','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','latency_level','T','character varying',22,'YES','''normal''::character varying');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','latency_sensitivity','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','guest_autolock_enabled','T','numeric',1,'YES','0');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','virtual_ich7m_present','T','numeric',1,'YES','0');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','virtual_smc_present','T','numeric',1,'YES','0');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','mem_res_locked_max','T','numeric',1,'YES','0');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','vm_objectid','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','swap_objectid','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','fork_parent_enabled','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','fork_child_group_id','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','fork_child_type','T','character varying',15,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','fork_parent_group_id','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','guest_integrity_info_enabled','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_config_info','boot_option_efi_sb_enabled','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_vdevice_backing_rel','backing_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_vdevice_backing_rel','vpx_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_vdevice_backing_rel','sn_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_vdevice_backing_rel','update_key','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_vdevice_file_backing','backing_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_vdevice_file_backing','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_vdevice_file_backing','hard_device_backing_file_name','T','character varying',2000,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_vdevice_file_backing','file_backing_content_id','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_vdevice_file_backing','file_backing_parent_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_vdevice_file_backing','snapshot_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_vdevice_file_backing','update_key','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_vdevice_file_backing_x','backing_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_vdevice_file_backing_x','device_backing_lun_uuid','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_vdevice_file_backing_x','sn_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_vdevice_file_backing_x','update_key','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_sn_vdevice_file_backing_x','delta_disk_format','T','character varying',50,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_snapshot','id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_snapshot','host_snapshot_id','T','character varying',500,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_snapshot','vm_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_snapshot','snapshot_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_snapshot','snapshot_desc','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_snapshot','create_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_snapshot','power_state','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_snapshot','is_quiesced','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_snapshot','snapshot_uid','T','integer',32,'NO','(-1)');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_snapshot','parent_snapshot_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_snapshot','is_current_snapshot','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_snapshot','config','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_stat_counter','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_stat_counter','entity_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_stat_counter','stat_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_stat_counter','device_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_stat_counter','stat_level','T','numeric',2,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_stat_def','id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_stat_def','rollup_type','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_stat_def','name','T','character varying',30,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_stat_def','group_name','T','character varying',30,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_stat_def','type','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_stat_def','unit','T','character varying',30,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_stat_def','associate_ids','T','character varying',128,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_stat_def','stat_level','T','numeric',2,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_stat_def','perdevice_stat_level','T','numeric',2,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_stat_def','default_level_set','T','numeric',1,'NO','1');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_stat_def','fixed_collection_interval','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_stat_dev_type','device_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_stat_dev_type','device_type_id','T','numeric',10,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_stat_dev_type_def','device_type_id','T','numeric',10,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_stat_dev_type_def','device_type_name','T','character varying',255,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_stat_id','id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_stat_id','moid','T','character varying',255,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_stat_interval_def','interval_seq_num','T','numeric',2,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_stat_interval_def','interval_def_name','T','character varying',30,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_stat_interval_def','interval_val','T','numeric',10,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_stat_interval_def','interval_length','T','numeric',10,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_stat_interval_def','stats_level','T','numeric',10,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_stat_interval_def','rollup_enabled_flg','T','numeric',1,'NO','1');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_string_array','array_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_string_array','type_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_string_array','value','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_string_array','array_index','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_string_array','mo_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_string_array','mo_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_string_array','surr_key','T','integer',32,'NO','nextval(''vpx_string_array_surr_key_seq''::regclass)');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_table','table_name','T','character varying',30,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_table','col_name','T','character varying',30,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_table','col_type','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_table','col_len','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_table','pk_flg','T','integer',32,'NO','0');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_tag','tag_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_tag','name','T','character varying',255,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_tag','type_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_tag_ent_association','tag_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_tag_ent_association','entity_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_task','task_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_task','name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_task','descriptionid','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_task','entity_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_task','entity_type','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_task','entity_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_task','locked_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_task','complete_state','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_task','cancelled','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_task','cancellable','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_task','error_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_task','result_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_task','progress','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_task','reason_data','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_task','queue_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_task','start_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_task','complete_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_task','event_chain_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_task','username','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_task','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_task','host_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_task','computeresource_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_task','datacenter_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_task','resourcepool_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_task','folder_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_task','alarm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_task','scheduledtask_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_task','change_tag_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_task','parent_task_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_task','root_task_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_task','description','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_task','activation_id','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_termination_reason','termination_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_termination_reason','termination_desc','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_text_array','array_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_text_array','type_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_text_array','value','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_text_array','mo_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_text_array','mo_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_text_array','surr_key','T','integer',32,'NO','nextval(''vpx_text_array_surr_key_seq''::regclass)');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_topn_past_day','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_topn_past_day','sample_time','T','timestamp without time zone',0,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_topn_past_day','integral_value','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_topn_past_month','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_topn_past_month','sample_time','T','timestamp without time zone',0,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_topn_past_month','integral_value','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_topn_past_week','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_topn_past_week','sample_time','T','timestamp without time zone',0,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_topn_past_week','integral_value','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_topn_past_year','counter_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_topn_past_year','sample_time','T','timestamp without time zone',0,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_topn_past_year','integral_value','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_topn_state','time_level','T','numeric',2,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_topn_state','sample_time','T','timestamp without time zone',0,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_topn_statistics','stat_id','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_type_map','type_name','T','character varying',255,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_type_map','array_num','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_type_map','mo_ref','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_uplink_teaming','dvs_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_uplink_teaming','dvportgroup_id','T','integer',32,'NO','0');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_uplink_teaming','dvport_key','T','character varying',50,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_uplink_teaming','active_uplink','T','numeric',1,'NO','0');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_uplink_teaming','uplink_name','T','character varying',255,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_uplink_teaming','uplink_index','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_uplink_teaming','surr_key','T','integer',32,'NO','nextval(''vpx_uplink_teaming_surr_key_seq''::regclass)');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_uptime','start_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_uptime','end_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_uptime','host_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_uptime','host_uuid','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_uptime','build_num','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_uptime','prod_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_uptime','term_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_uptime','surr_key','T','integer',32,'NO','nextval(''vpx_uptime_surr_key_seq''::regclass)');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_usage_sample_time','time_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_usage_sample_time','sample_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_usage_sample_time','sample_interval','T','numeric',10,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_usage_stat','counter_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_usage_stat','time_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_usage_stat','stat_val','T','numeric',38,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vapp_link','child_entity_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vapp_link','parent_vapp_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vapp_link','destroy_with_parent','T','numeric',1,'NO','0');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vc_upgrade_id','type_id','T','character varying',512,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vc_upgrade_id','identifier','T','character varying',512,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vc_upgrade_id','refentity','T','character varying',256,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vc_upgrade_id','mo_id','T','character varying',256,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vcha_repl_check','repl_check_value','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vdevice_backing_rel','backing_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vdevice_backing_rel','vpx_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vdevice_backing_rel','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vdevice_backing_rel','update_key','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vdevice_file_backing','backing_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vdevice_file_backing','datastore_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vdevice_file_backing','hard_device_backing_file_name','T','character varying',2000,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vdevice_file_backing','file_backing_content_id','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vdevice_file_backing','file_backing_parent_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vdevice_file_backing','vm_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vdevice_file_backing','update_key','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vdevice_file_backing_x','backing_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vdevice_file_backing_x','device_backing_lun_uuid','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vdevice_file_backing_x','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vdevice_file_backing_x','update_key','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vdevice_file_backing_x','delta_disk_format','T','character varying',50,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_version','ver_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_version','version_value','T','character varying',30,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_virtual_disk_iofilters','vm_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_virtual_disk_iofilters','disk_key','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_virtual_disk_iofilters','iofilter','T','character varying',128,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm','id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm','datacenter_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm','file_name','T','character varying',440,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm','local_file_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm','power_state','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm','disabled_snapshot','T','integer',32,'NO','0');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm','failed_dmotion','T','numeric',1,'NO','0');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm','uuid_bios','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm','resource_group_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm','guest_os','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm','guest_family','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm','guest_state','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm','mem_size_mb','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm','memory_reservation','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm','cpu_reservation','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm','num_vcpu','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm','num_nic','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm','num_disk','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm','dns_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm','is_template','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm','host_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm','ip_address','T','character varying',50,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm','tools_status','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm','tools_version_status','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm','tools_running_status','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm','tools_version','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm','guest_ops_ready','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm','int_guest_ops_ready','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm','screen_width','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm','screen_height','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm','agent_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm','agent_cnx_state','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm','config','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm','capability','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm','suspend_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm','boot_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm','suspend_interval','T','character varying',21,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm','question_info','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm','memory_overhead','T','character varying',21,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm','tools_mounted','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm','mks_connections','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm','online_standby','T','numeric',1,'NO','0');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm','description','T','character varying',2000,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm','annotation','T','character varying',2000,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm','pending_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm','pending_annotation','T','character varying',2000,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm','pending_annot_set_flg','T','numeric',1,'NO','0');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm','file_layout','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm','file_layout_x','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm','uuid_instance','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm','vapp_config','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm','aggr_commited_storage_space','T','numeric',38,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm','aggr_uncommited_storage_space','T','numeric',38,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm','aggr_unshared_storage_space','T','numeric',38,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm','storage_space_updated_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm','fault_tolerance_state','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm','record_replay_state','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm','dev_runtime','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm','guest_ip_stack','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm','managed_by_ext_key','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm','managed_by_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm','esx_agent_vm_state','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm','das_protected_desired','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm','das_protected_actual','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm','is_consolidate_needed','T','numeric',1,'NO','0');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm','offline_feature_requirement','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm','feature_requirement','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm','feature_mask','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm','generation_info','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm','paused','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm','snapshot_in_background','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm','guest_state_change_supported','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm','is_quiesced_fork_parent','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','change_version','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','array_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','change_tracking_enabled','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','cpu_hot_add_enabled','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','cpu_hot_remove_enabled','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','mem_hot_add_enabled','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','vasserts_enabled','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','vflash_cache_reservation','T','numeric',22,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','network_shaper_average_bps','T','character varying',22,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','network_shaper_burst_size','T','character varying',22,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','network_shaper_enabled_flg','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','network_shaper_peak_bps','T','character varying',22,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','hardware_num','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','hardware_memory','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','conprefe_cl_po_suspend_flg','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','conprefe_scr_power_on_flg','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','conprefe_poweronwhenopened_flg','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','tools_before_guest_standby_flg','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','tools_before_guest_reboot_flg','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','tools_before_guestshutdown_flg','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','tools_tools_upgrade_policy','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','tools_after_resume_flg','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','tools_after_power_on_flg','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','tools_sync_time_with_host_flg','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','tools_pending_customization','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','tools_tools_version','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','guest_full_name','T','character varying',512,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','instance_uuid','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','uuid','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','annotation','T','character varying',2000,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','version','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','template_flg','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','mem_allocation_overhead_limit','T','character varying',22,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','memory_allocation_reservation','T','character varying',22,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','memory_allocation_limit','T','character varying',22,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','mem_allocation_shares_shares','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','mem_allocation_shares_level','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','mem_allocexpan_reservation_flg','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','hot_plug_memory_limit','T','character varying',22,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','files_log_directory','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','files_snapshot_directory','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','files_vm_path_name','T','character varying',512,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','files_suspend_directory','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','files_ftmetadata_directory','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','alternate_guest_name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','swap_placement','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','location_id','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','guest_id','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','boot_optionenter_biossetup_flg','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','boot_option_boot_delay','T','character varying',22,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','cpu_allocation_overhead_limit','T','character varying',22,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','cpu_allocation_reservation','T','character varying',22,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','cpu_allocation_limit','T','character varying',22,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','cpu_allocation_shares_shares','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','cpu_allocation_shares_level','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','c_alloc_expandable_reserv_flg','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','def_po_ops_default_reset_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','def_po_o_default_suspend_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','def_power_ops_suspend_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','def_power_ops_standby_action','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','def_po_o_def_power_off_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','default_power_ops_reset_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','def_power_ops_power_off_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','h_plug_memory_increment_size','T','character varying',22,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','name','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','npiv_world_wide_name_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','npiv_temp_disabled','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','npiv_on_rdm','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','npiv_desired_nwwn','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','npiv_desired_pwwn','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','modified','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','disk_uuid_enabled_flg','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','snapshot_disabled_flg','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','record_replay_enabled_flg','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','fault_tolerance_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','run_with_debug_info_flg','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','virtual_mmu_usage','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','virtual_exec_usage','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','enable_logging_flg','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','snapshot_locked_flg','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','ht_sharing','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','disable_acceleration_flg','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','fl_snapshot_power_off_behavior','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','flags_monitor_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','use_toe_flg','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','preserved_swap_onpoweroff_flg','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','swap_dir','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','boot_option_retry_enabled_flg','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','boot_option_retry_delay','T','numeric',22,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','managed_by_ext_key','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','managed_by_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','hardware_cores','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','firmware','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','max_mks_connections','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','nested_hv_enabled','T','numeric',1,'YES','0');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','virtual_pmc_enabled','T','numeric',1,'YES','0');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','sched_hw_upgrade_policy','T','character varying',22,'YES','''never''::character varying');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','sched_hw_upgrade_version','T','character varying',22,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','sched_hw_upgrade_status','T','character varying',22,'YES','''none''::character varying');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','tools_lastinstall_counter','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','latency_level','T','character varying',22,'YES','''normal''::character varying');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','latency_sensitivity','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','guest_autolock_enabled','T','numeric',1,'YES','0');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','virtual_ich7m_present','T','numeric',1,'YES','0');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','virtual_smc_present','T','numeric',1,'YES','0');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','mem_res_locked_max','T','numeric',1,'YES','0');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','vm_objectid','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','swap_objectid','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','fork_parent_enabled','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','fork_child_group_id','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','fork_child_type','T','character varying',15,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','fork_parent_group_id','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','message_bus_tunnel_enabled','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','guest_integrity_info_enabled','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','boot_option_efi_sb_enabled','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_config_info','migrate_encryption','T','character varying',15,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_ds_space','vm_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_ds_space','ds_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_ds_space','commited_space','T','numeric',38,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_ds_space','uncommited_space','T','numeric',38,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_ds_space','unshared_space','T','numeric',38,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_ds_space','updated_time','T','timestamp without time zone',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_file_layout_ex','vm_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_file_layout_ex','last_update_time','T','timestamp without time zone',0,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_fle_disk_layout','id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_fle_disk_layout','vm_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_fle_disk_layout','key_val','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_fle_disk_unit','disk_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_fle_disk_unit','array_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_fle_disk_unit','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_fle_disk_unit','update_key','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_fle_file_info','vm_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_fle_file_info','key_val','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_fle_file_info','name','T','character varying',420,'YES',''' ''::character varying');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_fle_file_info','file_size','T','character varying',22,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_fle_file_info','file_uniquesize','T','character varying',22,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_fle_file_info','type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_fle_snap_disk_unit','snapshot_disk_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_fle_snap_disk_unit','array_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_fle_snap_disk_unit','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_fle_snap_disk_unit','update_key','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_fle_snapshot_disk','id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_fle_snapshot_disk','snapshot_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_fle_snapshot_disk','disk_key','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_fle_snapshot_disk','vm_id','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_fle_snapshot_disk','update_key','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_fle_snapshot_layout','id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_fle_snapshot_layout','vm_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_fle_snapshot_layout','snapshot_file_key','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_fle_snapshot_layout','snapshot_key','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_sn_virtual_device','id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_sn_virtual_device','conn_al_gu_control_flag','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_sn_virtual_device','conn_connected_flag','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_sn_virtual_device','conn_start_connected_flag','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_sn_virtual_device','conn_status','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_sn_virtual_device','device_info_summary','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_sn_virtual_device','device_info_label','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_sn_virtual_device','device_controller_key','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_sn_virtual_device','device_unit_number','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_sn_virtual_device','device_key','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_sn_virtual_device','device_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_sn_virtual_device','device_text','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_static_overhead_map','vm_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_static_overhead_map','host_build_num','T','character varying',20,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_static_overhead_map','static_mem_overhead','T','character varying',21,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_virtual_device','id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_virtual_device','conn_al_gu_control_flag','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_virtual_device','conn_connected_flag','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_virtual_device','conn_start_connected_flag','T','numeric',1,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_virtual_device','conn_status','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_virtual_device','device_info_summary','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_virtual_device','device_info_label','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_virtual_device','device_controller_key','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_virtual_device','device_unit_number','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_virtual_device','device_key','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_virtual_device','device_type','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vm_virtual_device','device_text','T','text',0,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vmfs_extent','id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vmfs_extent','disk_name','T','character varying',512,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vmfs_extent','partition_val','T','integer',32,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vmfs_extent','surr_key','T','integer',32,'NO','nextval(''vpx_vmfs_extent_surr_key_seq''::regclass)');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vmfs_volume','vpx_file_system_mount_info_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_vmfs_volume','uuid','T','character varying',255,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_wwn','entity_id','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_wwn','node_wwn','T','character varying',21,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_wwn','port_wwn','T','character varying',21,'YES',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_wwn','is_vm_npiv','T','integer',32,'NO',null);
 INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('vpx_wwn','surr_key','T','integer',32,'NO','nextval(''vpx_wwn_surr_key_seq''::regclass)');
 
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('CIS_KV_PROVIDERS','PK_CIS_KV_PROVIDERS','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('CIS_KV_KEYVALUE','PK_CIS_KV_KEYVALUE','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('CIS_KV_KEYVALUE','PROVIDER_KEY','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_OBJECT_TYPE','PK_VPX_OBJECT_TYPE','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_ALARM','PK_VPX_ALARM','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_ALARM_EXPRESSION','PK_VPX_ALARM_EXP','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_ALARM_EXPR_COMP','PK_VPX_ALARM_EXPR_COMP','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_ALARM_ACTION','PK_VPX_ALARM_ACTION','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_ALARM_RUNTIME','PK_VPX_ALARM_RUNTIME','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_ALARM_RUNTIME','IX_VPX_ALRT_CRTIME_STATUSVALUE','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_ALARM_STATE','PK_VPX_ALARM_STATE','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_ALARM_REPEAT_ACTION','PK_VPX_ALARM_RPTACT','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_CUSTOMIZATION_SPEC','PK_VPX_CUSTOMIZATION_SPEC','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_CHANGE_TAG','PK_VPX_CHANGE_TAG','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_CHANGE_TAG','VPX_CHANGE_TAG_M1','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_1','PK_VPX_EVENT_1','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_2','PK_VPX_EVENT_2','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_3','PK_VPX_EVENT_3','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_4','PK_VPX_EVENT_4','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_5','PK_VPX_EVENT_5','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_6','PK_VPX_EVENT_6','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_7','PK_VPX_EVENT_7','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_8','PK_VPX_EVENT_8','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_9','PK_VPX_EVENT_9','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_10','PK_VPX_EVENT_10','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_11','PK_VPX_EVENT_11','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_12','PK_VPX_EVENT_12','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_13','PK_VPX_EVENT_13','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_14','PK_VPX_EVENT_14','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_15','PK_VPX_EVENT_15','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_16','PK_VPX_EVENT_16','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_17','PK_VPX_EVENT_17','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_18','PK_VPX_EVENT_18','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_19','PK_VPX_EVENT_19','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_20','PK_VPX_EVENT_20','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_21','PK_VPX_EVENT_21','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_22','PK_VPX_EVENT_22','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_23','PK_VPX_EVENT_23','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_24','PK_VPX_EVENT_24','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_25','PK_VPX_EVENT_25','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_26','PK_VPX_EVENT_26','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_27','PK_VPX_EVENT_27','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_28','PK_VPX_EVENT_28','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_29','PK_VPX_EVENT_29','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_30','PK_VPX_EVENT_30','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_31','PK_VPX_EVENT_31','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_32','PK_VPX_EVENT_32','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_33','PK_VPX_EVENT_33','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_34','PK_VPX_EVENT_34','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_35','PK_VPX_EVENT_35','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_36','PK_VPX_EVENT_36','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_37','PK_VPX_EVENT_37','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_38','PK_VPX_EVENT_38','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_39','PK_VPX_EVENT_39','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_40','PK_VPX_EVENT_40','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_41','PK_VPX_EVENT_41','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_42','PK_VPX_EVENT_42','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_43','PK_VPX_EVENT_43','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_44','PK_VPX_EVENT_44','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_45','PK_VPX_EVENT_45','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_46','PK_VPX_EVENT_46','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_47','PK_VPX_EVENT_47','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_48','PK_VPX_EVENT_48','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_49','PK_VPX_EVENT_49','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_50','PK_VPX_EVENT_50','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_51','PK_VPX_EVENT_51','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_52','PK_VPX_EVENT_52','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_53','PK_VPX_EVENT_53','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_54','PK_VPX_EVENT_54','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_55','PK_VPX_EVENT_55','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_56','PK_VPX_EVENT_56','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_57','PK_VPX_EVENT_57','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_58','PK_VPX_EVENT_58','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_59','PK_VPX_EVENT_59','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_60','PK_VPX_EVENT_60','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_61','PK_VPX_EVENT_61','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_62','PK_VPX_EVENT_62','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_63','PK_VPX_EVENT_63','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_64','PK_VPX_EVENT_64','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_65','PK_VPX_EVENT_65','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_66','PK_VPX_EVENT_66','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_67','PK_VPX_EVENT_67','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_68','PK_VPX_EVENT_68','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_69','PK_VPX_EVENT_69','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_70','PK_VPX_EVENT_70','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_71','PK_VPX_EVENT_71','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_72','PK_VPX_EVENT_72','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_73','PK_VPX_EVENT_73','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_74','PK_VPX_EVENT_74','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_75','PK_VPX_EVENT_75','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_76','PK_VPX_EVENT_76','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_77','PK_VPX_EVENT_77','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_78','PK_VPX_EVENT_78','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_79','PK_VPX_EVENT_79','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_80','PK_VPX_EVENT_80','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_81','PK_VPX_EVENT_81','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_82','PK_VPX_EVENT_82','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_83','PK_VPX_EVENT_83','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_84','PK_VPX_EVENT_84','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_85','PK_VPX_EVENT_85','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_86','PK_VPX_EVENT_86','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_87','PK_VPX_EVENT_87','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_88','PK_VPX_EVENT_88','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_89','PK_VPX_EVENT_89','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_90','PK_VPX_EVENT_90','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_91','PK_VPX_EVENT_91','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_92','PK_VPX_EVENT_92','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_1','VPXI_EVENT_DVS_ID_1','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_2','VPXI_EVENT_DVS_ID_2','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_3','VPXI_EVENT_DVS_ID_3','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_4','VPXI_EVENT_DVS_ID_4','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_5','VPXI_EVENT_DVS_ID_5','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_6','VPXI_EVENT_DVS_ID_6','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_7','VPXI_EVENT_DVS_ID_7','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_8','VPXI_EVENT_DVS_ID_8','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_9','VPXI_EVENT_DVS_ID_9','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_10','VPXI_EVENT_DVS_ID_10','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_11','VPXI_EVENT_DVS_ID_11','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_12','VPXI_EVENT_DVS_ID_12','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_13','VPXI_EVENT_DVS_ID_13','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_14','VPXI_EVENT_DVS_ID_14','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_15','VPXI_EVENT_DVS_ID_15','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_16','VPXI_EVENT_DVS_ID_16','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_17','VPXI_EVENT_DVS_ID_17','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_18','VPXI_EVENT_DVS_ID_18','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_19','VPXI_EVENT_DVS_ID_19','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_20','VPXI_EVENT_DVS_ID_20','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_21','VPXI_EVENT_DVS_ID_21','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_22','VPXI_EVENT_DVS_ID_22','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_23','VPXI_EVENT_DVS_ID_23','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_24','VPXI_EVENT_DVS_ID_24','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_25','VPXI_EVENT_DVS_ID_25','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_26','VPXI_EVENT_DVS_ID_26','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_27','VPXI_EVENT_DVS_ID_27','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_28','VPXI_EVENT_DVS_ID_28','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_29','VPXI_EVENT_DVS_ID_29','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_30','VPXI_EVENT_DVS_ID_30','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_31','VPXI_EVENT_DVS_ID_31','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_32','VPXI_EVENT_DVS_ID_32','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_33','VPXI_EVENT_DVS_ID_33','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_34','VPXI_EVENT_DVS_ID_34','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_35','VPXI_EVENT_DVS_ID_35','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_36','VPXI_EVENT_DVS_ID_36','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_37','VPXI_EVENT_DVS_ID_37','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_38','VPXI_EVENT_DVS_ID_38','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_39','VPXI_EVENT_DVS_ID_39','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_40','VPXI_EVENT_DVS_ID_40','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_41','VPXI_EVENT_DVS_ID_41','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_42','VPXI_EVENT_DVS_ID_42','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_43','VPXI_EVENT_DVS_ID_43','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_44','VPXI_EVENT_DVS_ID_44','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_45','VPXI_EVENT_DVS_ID_45','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_46','VPXI_EVENT_DVS_ID_46','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_47','VPXI_EVENT_DVS_ID_47','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_48','VPXI_EVENT_DVS_ID_48','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_49','VPXI_EVENT_DVS_ID_49','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_50','VPXI_EVENT_DVS_ID_50','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_51','VPXI_EVENT_DVS_ID_51','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_52','VPXI_EVENT_DVS_ID_52','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_53','VPXI_EVENT_DVS_ID_53','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_54','VPXI_EVENT_DVS_ID_54','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_55','VPXI_EVENT_DVS_ID_55','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_56','VPXI_EVENT_DVS_ID_56','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_57','VPXI_EVENT_DVS_ID_57','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_58','VPXI_EVENT_DVS_ID_58','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_59','VPXI_EVENT_DVS_ID_59','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_60','VPXI_EVENT_DVS_ID_60','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_61','VPXI_EVENT_DVS_ID_61','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_62','VPXI_EVENT_DVS_ID_62','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_63','VPXI_EVENT_DVS_ID_63','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_64','VPXI_EVENT_DVS_ID_64','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_65','VPXI_EVENT_DVS_ID_65','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_66','VPXI_EVENT_DVS_ID_66','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_67','VPXI_EVENT_DVS_ID_67','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_68','VPXI_EVENT_DVS_ID_68','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_69','VPXI_EVENT_DVS_ID_69','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_70','VPXI_EVENT_DVS_ID_70','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_71','VPXI_EVENT_DVS_ID_71','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_72','VPXI_EVENT_DVS_ID_72','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_73','VPXI_EVENT_DVS_ID_73','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_74','VPXI_EVENT_DVS_ID_74','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_75','VPXI_EVENT_DVS_ID_75','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_76','VPXI_EVENT_DVS_ID_76','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_77','VPXI_EVENT_DVS_ID_77','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_78','VPXI_EVENT_DVS_ID_78','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_79','VPXI_EVENT_DVS_ID_79','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_80','VPXI_EVENT_DVS_ID_80','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_81','VPXI_EVENT_DVS_ID_81','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_82','VPXI_EVENT_DVS_ID_82','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_83','VPXI_EVENT_DVS_ID_83','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_84','VPXI_EVENT_DVS_ID_84','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_85','VPXI_EVENT_DVS_ID_85','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_86','VPXI_EVENT_DVS_ID_86','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_87','VPXI_EVENT_DVS_ID_87','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_88','VPXI_EVENT_DVS_ID_88','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_89','VPXI_EVENT_DVS_ID_89','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_90','VPXI_EVENT_DVS_ID_90','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_91','VPXI_EVENT_DVS_ID_91','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_92','VPXI_EVENT_DVS_ID_92','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_1','VPXI_EVENT_CATEGORY_1','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_2','VPXI_EVENT_CATEGORY_2','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_3','VPXI_EVENT_CATEGORY_3','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_4','VPXI_EVENT_CATEGORY_4','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_5','VPXI_EVENT_CATEGORY_5','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_6','VPXI_EVENT_CATEGORY_6','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_7','VPXI_EVENT_CATEGORY_7','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_8','VPXI_EVENT_CATEGORY_8','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_9','VPXI_EVENT_CATEGORY_9','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_10','VPXI_EVENT_CATEGORY_10','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_11','VPXI_EVENT_CATEGORY_11','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_12','VPXI_EVENT_CATEGORY_12','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_13','VPXI_EVENT_CATEGORY_13','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_14','VPXI_EVENT_CATEGORY_14','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_15','VPXI_EVENT_CATEGORY_15','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_16','VPXI_EVENT_CATEGORY_16','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_17','VPXI_EVENT_CATEGORY_17','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_18','VPXI_EVENT_CATEGORY_18','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_19','VPXI_EVENT_CATEGORY_19','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_20','VPXI_EVENT_CATEGORY_20','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_21','VPXI_EVENT_CATEGORY_21','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_22','VPXI_EVENT_CATEGORY_22','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_23','VPXI_EVENT_CATEGORY_23','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_24','VPXI_EVENT_CATEGORY_24','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_25','VPXI_EVENT_CATEGORY_25','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_26','VPXI_EVENT_CATEGORY_26','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_27','VPXI_EVENT_CATEGORY_27','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_28','VPXI_EVENT_CATEGORY_28','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_29','VPXI_EVENT_CATEGORY_29','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_30','VPXI_EVENT_CATEGORY_30','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_31','VPXI_EVENT_CATEGORY_31','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_32','VPXI_EVENT_CATEGORY_32','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_33','VPXI_EVENT_CATEGORY_33','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_34','VPXI_EVENT_CATEGORY_34','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_35','VPXI_EVENT_CATEGORY_35','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_36','VPXI_EVENT_CATEGORY_36','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_37','VPXI_EVENT_CATEGORY_37','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_38','VPXI_EVENT_CATEGORY_38','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_39','VPXI_EVENT_CATEGORY_39','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_40','VPXI_EVENT_CATEGORY_40','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_41','VPXI_EVENT_CATEGORY_41','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_42','VPXI_EVENT_CATEGORY_42','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_43','VPXI_EVENT_CATEGORY_43','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_44','VPXI_EVENT_CATEGORY_44','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_45','VPXI_EVENT_CATEGORY_45','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_46','VPXI_EVENT_CATEGORY_46','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_47','VPXI_EVENT_CATEGORY_47','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_48','VPXI_EVENT_CATEGORY_48','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_49','VPXI_EVENT_CATEGORY_49','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_50','VPXI_EVENT_CATEGORY_50','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_51','VPXI_EVENT_CATEGORY_51','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_52','VPXI_EVENT_CATEGORY_52','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_53','VPXI_EVENT_CATEGORY_53','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_54','VPXI_EVENT_CATEGORY_54','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_55','VPXI_EVENT_CATEGORY_55','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_56','VPXI_EVENT_CATEGORY_56','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_57','VPXI_EVENT_CATEGORY_57','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_58','VPXI_EVENT_CATEGORY_58','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_59','VPXI_EVENT_CATEGORY_59','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_60','VPXI_EVENT_CATEGORY_60','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_61','VPXI_EVENT_CATEGORY_61','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_62','VPXI_EVENT_CATEGORY_62','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_63','VPXI_EVENT_CATEGORY_63','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_64','VPXI_EVENT_CATEGORY_64','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_65','VPXI_EVENT_CATEGORY_65','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_66','VPXI_EVENT_CATEGORY_66','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_67','VPXI_EVENT_CATEGORY_67','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_68','VPXI_EVENT_CATEGORY_68','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_69','VPXI_EVENT_CATEGORY_69','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_70','VPXI_EVENT_CATEGORY_70','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_71','VPXI_EVENT_CATEGORY_71','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_72','VPXI_EVENT_CATEGORY_72','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_73','VPXI_EVENT_CATEGORY_73','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_74','VPXI_EVENT_CATEGORY_74','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_75','VPXI_EVENT_CATEGORY_75','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_76','VPXI_EVENT_CATEGORY_76','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_77','VPXI_EVENT_CATEGORY_77','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_78','VPXI_EVENT_CATEGORY_78','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_79','VPXI_EVENT_CATEGORY_79','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_80','VPXI_EVENT_CATEGORY_80','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_81','VPXI_EVENT_CATEGORY_81','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_82','VPXI_EVENT_CATEGORY_82','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_83','VPXI_EVENT_CATEGORY_83','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_84','VPXI_EVENT_CATEGORY_84','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_85','VPXI_EVENT_CATEGORY_85','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_86','VPXI_EVENT_CATEGORY_86','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_87','VPXI_EVENT_CATEGORY_87','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_88','VPXI_EVENT_CATEGORY_88','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_89','VPXI_EVENT_CATEGORY_89','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_90','VPXI_EVENT_CATEGORY_90','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_91','VPXI_EVENT_CATEGORY_91','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_92','VPXI_EVENT_CATEGORY_92','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_1','VPXI_EVENT_CHAIN_ID_1','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_2','VPXI_EVENT_CHAIN_ID_2','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_3','VPXI_EVENT_CHAIN_ID_3','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_4','VPXI_EVENT_CHAIN_ID_4','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_5','VPXI_EVENT_CHAIN_ID_5','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_6','VPXI_EVENT_CHAIN_ID_6','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_7','VPXI_EVENT_CHAIN_ID_7','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_8','VPXI_EVENT_CHAIN_ID_8','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_9','VPXI_EVENT_CHAIN_ID_9','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_10','VPXI_EVENT_CHAIN_ID_10','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_11','VPXI_EVENT_CHAIN_ID_11','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_12','VPXI_EVENT_CHAIN_ID_12','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_13','VPXI_EVENT_CHAIN_ID_13','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_14','VPXI_EVENT_CHAIN_ID_14','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_15','VPXI_EVENT_CHAIN_ID_15','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_16','VPXI_EVENT_CHAIN_ID_16','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_17','VPXI_EVENT_CHAIN_ID_17','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_18','VPXI_EVENT_CHAIN_ID_18','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_19','VPXI_EVENT_CHAIN_ID_19','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_20','VPXI_EVENT_CHAIN_ID_20','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_21','VPXI_EVENT_CHAIN_ID_21','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_22','VPXI_EVENT_CHAIN_ID_22','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_23','VPXI_EVENT_CHAIN_ID_23','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_24','VPXI_EVENT_CHAIN_ID_24','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_25','VPXI_EVENT_CHAIN_ID_25','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_26','VPXI_EVENT_CHAIN_ID_26','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_27','VPXI_EVENT_CHAIN_ID_27','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_28','VPXI_EVENT_CHAIN_ID_28','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_29','VPXI_EVENT_CHAIN_ID_29','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_30','VPXI_EVENT_CHAIN_ID_30','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_31','VPXI_EVENT_CHAIN_ID_31','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_32','VPXI_EVENT_CHAIN_ID_32','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_33','VPXI_EVENT_CHAIN_ID_33','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_34','VPXI_EVENT_CHAIN_ID_34','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_35','VPXI_EVENT_CHAIN_ID_35','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_36','VPXI_EVENT_CHAIN_ID_36','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_37','VPXI_EVENT_CHAIN_ID_37','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_38','VPXI_EVENT_CHAIN_ID_38','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_39','VPXI_EVENT_CHAIN_ID_39','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_40','VPXI_EVENT_CHAIN_ID_40','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_41','VPXI_EVENT_CHAIN_ID_41','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_42','VPXI_EVENT_CHAIN_ID_42','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_43','VPXI_EVENT_CHAIN_ID_43','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_44','VPXI_EVENT_CHAIN_ID_44','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_45','VPXI_EVENT_CHAIN_ID_45','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_46','VPXI_EVENT_CHAIN_ID_46','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_47','VPXI_EVENT_CHAIN_ID_47','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_48','VPXI_EVENT_CHAIN_ID_48','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_49','VPXI_EVENT_CHAIN_ID_49','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_50','VPXI_EVENT_CHAIN_ID_50','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_51','VPXI_EVENT_CHAIN_ID_51','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_52','VPXI_EVENT_CHAIN_ID_52','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_53','VPXI_EVENT_CHAIN_ID_53','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_54','VPXI_EVENT_CHAIN_ID_54','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_55','VPXI_EVENT_CHAIN_ID_55','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_56','VPXI_EVENT_CHAIN_ID_56','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_57','VPXI_EVENT_CHAIN_ID_57','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_58','VPXI_EVENT_CHAIN_ID_58','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_59','VPXI_EVENT_CHAIN_ID_59','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_60','VPXI_EVENT_CHAIN_ID_60','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_61','VPXI_EVENT_CHAIN_ID_61','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_62','VPXI_EVENT_CHAIN_ID_62','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_63','VPXI_EVENT_CHAIN_ID_63','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_64','VPXI_EVENT_CHAIN_ID_64','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_65','VPXI_EVENT_CHAIN_ID_65','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_66','VPXI_EVENT_CHAIN_ID_66','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_67','VPXI_EVENT_CHAIN_ID_67','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_68','VPXI_EVENT_CHAIN_ID_68','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_69','VPXI_EVENT_CHAIN_ID_69','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_70','VPXI_EVENT_CHAIN_ID_70','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_71','VPXI_EVENT_CHAIN_ID_71','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_72','VPXI_EVENT_CHAIN_ID_72','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_73','VPXI_EVENT_CHAIN_ID_73','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_74','VPXI_EVENT_CHAIN_ID_74','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_75','VPXI_EVENT_CHAIN_ID_75','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_76','VPXI_EVENT_CHAIN_ID_76','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_77','VPXI_EVENT_CHAIN_ID_77','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_78','VPXI_EVENT_CHAIN_ID_78','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_79','VPXI_EVENT_CHAIN_ID_79','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_80','VPXI_EVENT_CHAIN_ID_80','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_81','VPXI_EVENT_CHAIN_ID_81','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_82','VPXI_EVENT_CHAIN_ID_82','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_83','VPXI_EVENT_CHAIN_ID_83','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_84','VPXI_EVENT_CHAIN_ID_84','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_85','VPXI_EVENT_CHAIN_ID_85','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_86','VPXI_EVENT_CHAIN_ID_86','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_87','VPXI_EVENT_CHAIN_ID_87','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_88','VPXI_EVENT_CHAIN_ID_88','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_89','VPXI_EVENT_CHAIN_ID_89','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_90','VPXI_EVENT_CHAIN_ID_90','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_91','VPXI_EVENT_CHAIN_ID_91','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_92','VPXI_EVENT_CHAIN_ID_92','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_1','VPXI_EVENT_COMPUTERES_ID_1','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_2','VPXI_EVENT_COMPUTERES_ID_2','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_3','VPXI_EVENT_COMPUTERES_ID_3','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_4','VPXI_EVENT_COMPUTERES_ID_4','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_5','VPXI_EVENT_COMPUTERES_ID_5','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_6','VPXI_EVENT_COMPUTERES_ID_6','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_7','VPXI_EVENT_COMPUTERES_ID_7','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_8','VPXI_EVENT_COMPUTERES_ID_8','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_9','VPXI_EVENT_COMPUTERES_ID_9','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_10','VPXI_EVENT_COMPUTERES_ID_10','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_11','VPXI_EVENT_COMPUTERES_ID_11','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_12','VPXI_EVENT_COMPUTERES_ID_12','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_13','VPXI_EVENT_COMPUTERES_ID_13','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_14','VPXI_EVENT_COMPUTERES_ID_14','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_15','VPXI_EVENT_COMPUTERES_ID_15','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_16','VPXI_EVENT_COMPUTERES_ID_16','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_17','VPXI_EVENT_COMPUTERES_ID_17','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_18','VPXI_EVENT_COMPUTERES_ID_18','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_19','VPXI_EVENT_COMPUTERES_ID_19','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_20','VPXI_EVENT_COMPUTERES_ID_20','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_21','VPXI_EVENT_COMPUTERES_ID_21','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_22','VPXI_EVENT_COMPUTERES_ID_22','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_23','VPXI_EVENT_COMPUTERES_ID_23','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_24','VPXI_EVENT_COMPUTERES_ID_24','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_25','VPXI_EVENT_COMPUTERES_ID_25','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_26','VPXI_EVENT_COMPUTERES_ID_26','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_27','VPXI_EVENT_COMPUTERES_ID_27','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_28','VPXI_EVENT_COMPUTERES_ID_28','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_29','VPXI_EVENT_COMPUTERES_ID_29','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_30','VPXI_EVENT_COMPUTERES_ID_30','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_31','VPXI_EVENT_COMPUTERES_ID_31','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_32','VPXI_EVENT_COMPUTERES_ID_32','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_33','VPXI_EVENT_COMPUTERES_ID_33','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_34','VPXI_EVENT_COMPUTERES_ID_34','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_35','VPXI_EVENT_COMPUTERES_ID_35','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_36','VPXI_EVENT_COMPUTERES_ID_36','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_37','VPXI_EVENT_COMPUTERES_ID_37','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_38','VPXI_EVENT_COMPUTERES_ID_38','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_39','VPXI_EVENT_COMPUTERES_ID_39','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_40','VPXI_EVENT_COMPUTERES_ID_40','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_41','VPXI_EVENT_COMPUTERES_ID_41','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_42','VPXI_EVENT_COMPUTERES_ID_42','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_43','VPXI_EVENT_COMPUTERES_ID_43','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_44','VPXI_EVENT_COMPUTERES_ID_44','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_45','VPXI_EVENT_COMPUTERES_ID_45','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_46','VPXI_EVENT_COMPUTERES_ID_46','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_47','VPXI_EVENT_COMPUTERES_ID_47','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_48','VPXI_EVENT_COMPUTERES_ID_48','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_49','VPXI_EVENT_COMPUTERES_ID_49','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_50','VPXI_EVENT_COMPUTERES_ID_50','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_51','VPXI_EVENT_COMPUTERES_ID_51','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_52','VPXI_EVENT_COMPUTERES_ID_52','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_53','VPXI_EVENT_COMPUTERES_ID_53','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_54','VPXI_EVENT_COMPUTERES_ID_54','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_55','VPXI_EVENT_COMPUTERES_ID_55','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_56','VPXI_EVENT_COMPUTERES_ID_56','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_57','VPXI_EVENT_COMPUTERES_ID_57','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_58','VPXI_EVENT_COMPUTERES_ID_58','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_59','VPXI_EVENT_COMPUTERES_ID_59','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_60','VPXI_EVENT_COMPUTERES_ID_60','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_61','VPXI_EVENT_COMPUTERES_ID_61','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_62','VPXI_EVENT_COMPUTERES_ID_62','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_63','VPXI_EVENT_COMPUTERES_ID_63','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_64','VPXI_EVENT_COMPUTERES_ID_64','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_65','VPXI_EVENT_COMPUTERES_ID_65','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_66','VPXI_EVENT_COMPUTERES_ID_66','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_67','VPXI_EVENT_COMPUTERES_ID_67','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_68','VPXI_EVENT_COMPUTERES_ID_68','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_69','VPXI_EVENT_COMPUTERES_ID_69','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_70','VPXI_EVENT_COMPUTERES_ID_70','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_71','VPXI_EVENT_COMPUTERES_ID_71','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_72','VPXI_EVENT_COMPUTERES_ID_72','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_73','VPXI_EVENT_COMPUTERES_ID_73','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_74','VPXI_EVENT_COMPUTERES_ID_74','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_75','VPXI_EVENT_COMPUTERES_ID_75','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_76','VPXI_EVENT_COMPUTERES_ID_76','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_77','VPXI_EVENT_COMPUTERES_ID_77','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_78','VPXI_EVENT_COMPUTERES_ID_78','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_79','VPXI_EVENT_COMPUTERES_ID_79','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_80','VPXI_EVENT_COMPUTERES_ID_80','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_81','VPXI_EVENT_COMPUTERES_ID_81','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_82','VPXI_EVENT_COMPUTERES_ID_82','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_83','VPXI_EVENT_COMPUTERES_ID_83','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_84','VPXI_EVENT_COMPUTERES_ID_84','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_85','VPXI_EVENT_COMPUTERES_ID_85','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_86','VPXI_EVENT_COMPUTERES_ID_86','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_87','VPXI_EVENT_COMPUTERES_ID_87','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_88','VPXI_EVENT_COMPUTERES_ID_88','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_89','VPXI_EVENT_COMPUTERES_ID_89','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_90','VPXI_EVENT_COMPUTERES_ID_90','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_91','VPXI_EVENT_COMPUTERES_ID_91','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_92','VPXI_EVENT_COMPUTERES_ID_92','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_1','VPXI_EVENT_CREATE_TIME_1','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_2','VPXI_EVENT_CREATE_TIME_2','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_3','VPXI_EVENT_CREATE_TIME_3','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_4','VPXI_EVENT_CREATE_TIME_4','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_5','VPXI_EVENT_CREATE_TIME_5','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_6','VPXI_EVENT_CREATE_TIME_6','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_7','VPXI_EVENT_CREATE_TIME_7','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_8','VPXI_EVENT_CREATE_TIME_8','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_9','VPXI_EVENT_CREATE_TIME_9','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_10','VPXI_EVENT_CREATE_TIME_10','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_11','VPXI_EVENT_CREATE_TIME_11','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_12','VPXI_EVENT_CREATE_TIME_12','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_13','VPXI_EVENT_CREATE_TIME_13','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_14','VPXI_EVENT_CREATE_TIME_14','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_15','VPXI_EVENT_CREATE_TIME_15','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_16','VPXI_EVENT_CREATE_TIME_16','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_17','VPXI_EVENT_CREATE_TIME_17','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_18','VPXI_EVENT_CREATE_TIME_18','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_19','VPXI_EVENT_CREATE_TIME_19','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_20','VPXI_EVENT_CREATE_TIME_20','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_21','VPXI_EVENT_CREATE_TIME_21','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_22','VPXI_EVENT_CREATE_TIME_22','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_23','VPXI_EVENT_CREATE_TIME_23','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_24','VPXI_EVENT_CREATE_TIME_24','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_25','VPXI_EVENT_CREATE_TIME_25','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_26','VPXI_EVENT_CREATE_TIME_26','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_27','VPXI_EVENT_CREATE_TIME_27','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_28','VPXI_EVENT_CREATE_TIME_28','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_29','VPXI_EVENT_CREATE_TIME_29','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_30','VPXI_EVENT_CREATE_TIME_30','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_31','VPXI_EVENT_CREATE_TIME_31','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_32','VPXI_EVENT_CREATE_TIME_32','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_33','VPXI_EVENT_CREATE_TIME_33','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_34','VPXI_EVENT_CREATE_TIME_34','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_35','VPXI_EVENT_CREATE_TIME_35','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_36','VPXI_EVENT_CREATE_TIME_36','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_37','VPXI_EVENT_CREATE_TIME_37','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_38','VPXI_EVENT_CREATE_TIME_38','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_39','VPXI_EVENT_CREATE_TIME_39','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_40','VPXI_EVENT_CREATE_TIME_40','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_41','VPXI_EVENT_CREATE_TIME_41','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_42','VPXI_EVENT_CREATE_TIME_42','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_43','VPXI_EVENT_CREATE_TIME_43','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_44','VPXI_EVENT_CREATE_TIME_44','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_45','VPXI_EVENT_CREATE_TIME_45','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_46','VPXI_EVENT_CREATE_TIME_46','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_47','VPXI_EVENT_CREATE_TIME_47','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_48','VPXI_EVENT_CREATE_TIME_48','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_49','VPXI_EVENT_CREATE_TIME_49','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_50','VPXI_EVENT_CREATE_TIME_50','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_51','VPXI_EVENT_CREATE_TIME_51','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_52','VPXI_EVENT_CREATE_TIME_52','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_53','VPXI_EVENT_CREATE_TIME_53','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_54','VPXI_EVENT_CREATE_TIME_54','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_55','VPXI_EVENT_CREATE_TIME_55','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_56','VPXI_EVENT_CREATE_TIME_56','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_57','VPXI_EVENT_CREATE_TIME_57','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_58','VPXI_EVENT_CREATE_TIME_58','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_59','VPXI_EVENT_CREATE_TIME_59','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_60','VPXI_EVENT_CREATE_TIME_60','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_61','VPXI_EVENT_CREATE_TIME_61','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_62','VPXI_EVENT_CREATE_TIME_62','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_63','VPXI_EVENT_CREATE_TIME_63','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_64','VPXI_EVENT_CREATE_TIME_64','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_65','VPXI_EVENT_CREATE_TIME_65','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_66','VPXI_EVENT_CREATE_TIME_66','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_67','VPXI_EVENT_CREATE_TIME_67','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_68','VPXI_EVENT_CREATE_TIME_68','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_69','VPXI_EVENT_CREATE_TIME_69','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_70','VPXI_EVENT_CREATE_TIME_70','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_71','VPXI_EVENT_CREATE_TIME_71','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_72','VPXI_EVENT_CREATE_TIME_72','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_73','VPXI_EVENT_CREATE_TIME_73','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_74','VPXI_EVENT_CREATE_TIME_74','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_75','VPXI_EVENT_CREATE_TIME_75','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_76','VPXI_EVENT_CREATE_TIME_76','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_77','VPXI_EVENT_CREATE_TIME_77','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_78','VPXI_EVENT_CREATE_TIME_78','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_79','VPXI_EVENT_CREATE_TIME_79','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_80','VPXI_EVENT_CREATE_TIME_80','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_81','VPXI_EVENT_CREATE_TIME_81','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_82','VPXI_EVENT_CREATE_TIME_82','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_83','VPXI_EVENT_CREATE_TIME_83','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_84','VPXI_EVENT_CREATE_TIME_84','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_85','VPXI_EVENT_CREATE_TIME_85','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_86','VPXI_EVENT_CREATE_TIME_86','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_87','VPXI_EVENT_CREATE_TIME_87','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_88','VPXI_EVENT_CREATE_TIME_88','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_89','VPXI_EVENT_CREATE_TIME_89','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_90','VPXI_EVENT_CREATE_TIME_90','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_91','VPXI_EVENT_CREATE_TIME_91','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_92','VPXI_EVENT_CREATE_TIME_92','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_1','VPXI_EVENT_DATACENTER_ID_1','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_2','VPXI_EVENT_DATACENTER_ID_2','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_3','VPXI_EVENT_DATACENTER_ID_3','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_4','VPXI_EVENT_DATACENTER_ID_4','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_5','VPXI_EVENT_DATACENTER_ID_5','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_6','VPXI_EVENT_DATACENTER_ID_6','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_7','VPXI_EVENT_DATACENTER_ID_7','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_8','VPXI_EVENT_DATACENTER_ID_8','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_32','VPXI_EVENT_EVENT_TYPE_32','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_9','VPXI_EVENT_DATACENTER_ID_9','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_10','VPXI_EVENT_DATACENTER_ID_10','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_11','VPXI_EVENT_DATACENTER_ID_11','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_12','VPXI_EVENT_DATACENTER_ID_12','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_13','VPXI_EVENT_DATACENTER_ID_13','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_14','VPXI_EVENT_DATACENTER_ID_14','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_15','VPXI_EVENT_DATACENTER_ID_15','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_16','VPXI_EVENT_DATACENTER_ID_16','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_17','VPXI_EVENT_DATACENTER_ID_17','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_18','VPXI_EVENT_DATACENTER_ID_18','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_19','VPXI_EVENT_DATACENTER_ID_19','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_20','VPXI_EVENT_DATACENTER_ID_20','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_21','VPXI_EVENT_DATACENTER_ID_21','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_22','VPXI_EVENT_DATACENTER_ID_22','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_23','VPXI_EVENT_DATACENTER_ID_23','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_24','VPXI_EVENT_DATACENTER_ID_24','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_25','VPXI_EVENT_DATACENTER_ID_25','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_26','VPXI_EVENT_DATACENTER_ID_26','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_27','VPXI_EVENT_DATACENTER_ID_27','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_28','VPXI_EVENT_DATACENTER_ID_28','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_29','VPXI_EVENT_DATACENTER_ID_29','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_30','VPXI_EVENT_DATACENTER_ID_30','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_31','VPXI_EVENT_DATACENTER_ID_31','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_32','VPXI_EVENT_DATACENTER_ID_32','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_33','VPXI_EVENT_DATACENTER_ID_33','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_34','VPXI_EVENT_DATACENTER_ID_34','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_35','VPXI_EVENT_DATACENTER_ID_35','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_36','VPXI_EVENT_DATACENTER_ID_36','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_37','VPXI_EVENT_DATACENTER_ID_37','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_38','VPXI_EVENT_DATACENTER_ID_38','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_39','VPXI_EVENT_DATACENTER_ID_39','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_40','VPXI_EVENT_DATACENTER_ID_40','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_41','VPXI_EVENT_DATACENTER_ID_41','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_42','VPXI_EVENT_DATACENTER_ID_42','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_43','VPXI_EVENT_DATACENTER_ID_43','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_44','VPXI_EVENT_DATACENTER_ID_44','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_45','VPXI_EVENT_DATACENTER_ID_45','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_46','VPXI_EVENT_DATACENTER_ID_46','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_47','VPXI_EVENT_DATACENTER_ID_47','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_48','VPXI_EVENT_DATACENTER_ID_48','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_49','VPXI_EVENT_DATACENTER_ID_49','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_50','VPXI_EVENT_DATACENTER_ID_50','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_51','VPXI_EVENT_DATACENTER_ID_51','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_52','VPXI_EVENT_DATACENTER_ID_52','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_53','VPXI_EVENT_DATACENTER_ID_53','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_54','VPXI_EVENT_DATACENTER_ID_54','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_55','VPXI_EVENT_DATACENTER_ID_55','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_56','VPXI_EVENT_DATACENTER_ID_56','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_57','VPXI_EVENT_DATACENTER_ID_57','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_58','VPXI_EVENT_DATACENTER_ID_58','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_59','VPXI_EVENT_DATACENTER_ID_59','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_60','VPXI_EVENT_DATACENTER_ID_60','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_61','VPXI_EVENT_DATACENTER_ID_61','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_62','VPXI_EVENT_DATACENTER_ID_62','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_63','VPXI_EVENT_DATACENTER_ID_63','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_64','VPXI_EVENT_DATACENTER_ID_64','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_65','VPXI_EVENT_DATACENTER_ID_65','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_66','VPXI_EVENT_DATACENTER_ID_66','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_67','VPXI_EVENT_DATACENTER_ID_67','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_68','VPXI_EVENT_DATACENTER_ID_68','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_69','VPXI_EVENT_DATACENTER_ID_69','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_70','VPXI_EVENT_DATACENTER_ID_70','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_71','VPXI_EVENT_DATACENTER_ID_71','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_72','VPXI_EVENT_DATACENTER_ID_72','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_73','VPXI_EVENT_DATACENTER_ID_73','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_74','VPXI_EVENT_DATACENTER_ID_74','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_75','VPXI_EVENT_DATACENTER_ID_75','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_76','VPXI_EVENT_DATACENTER_ID_76','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_77','VPXI_EVENT_DATACENTER_ID_77','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_78','VPXI_EVENT_DATACENTER_ID_78','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_79','VPXI_EVENT_DATACENTER_ID_79','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_80','VPXI_EVENT_DATACENTER_ID_80','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_81','VPXI_EVENT_DATACENTER_ID_81','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_82','VPXI_EVENT_DATACENTER_ID_82','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_83','VPXI_EVENT_DATACENTER_ID_83','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_84','VPXI_EVENT_DATACENTER_ID_84','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_85','VPXI_EVENT_DATACENTER_ID_85','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_86','VPXI_EVENT_DATACENTER_ID_86','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_87','VPXI_EVENT_DATACENTER_ID_87','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_88','VPXI_EVENT_DATACENTER_ID_88','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_89','VPXI_EVENT_DATACENTER_ID_89','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_90','VPXI_EVENT_DATACENTER_ID_90','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_91','VPXI_EVENT_DATACENTER_ID_91','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_92','VPXI_EVENT_DATACENTER_ID_92','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_1','VPXI_EVENT_DATASTORE_ID_1','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_2','VPXI_EVENT_DATASTORE_ID_2','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_3','VPXI_EVENT_DATASTORE_ID_3','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_4','VPXI_EVENT_DATASTORE_ID_4','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_5','VPXI_EVENT_DATASTORE_ID_5','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_6','VPXI_EVENT_DATASTORE_ID_6','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_7','VPXI_EVENT_DATASTORE_ID_7','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_8','VPXI_EVENT_DATASTORE_ID_8','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_9','VPXI_EVENT_DATASTORE_ID_9','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_10','VPXI_EVENT_DATASTORE_ID_10','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_11','VPXI_EVENT_DATASTORE_ID_11','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_12','VPXI_EVENT_DATASTORE_ID_12','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_13','VPXI_EVENT_DATASTORE_ID_13','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_14','VPXI_EVENT_DATASTORE_ID_14','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_15','VPXI_EVENT_DATASTORE_ID_15','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_16','VPXI_EVENT_DATASTORE_ID_16','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_17','VPXI_EVENT_DATASTORE_ID_17','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_18','VPXI_EVENT_DATASTORE_ID_18','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_19','VPXI_EVENT_DATASTORE_ID_19','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_20','VPXI_EVENT_DATASTORE_ID_20','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_21','VPXI_EVENT_DATASTORE_ID_21','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_22','VPXI_EVENT_DATASTORE_ID_22','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_23','VPXI_EVENT_DATASTORE_ID_23','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_24','VPXI_EVENT_DATASTORE_ID_24','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_25','VPXI_EVENT_DATASTORE_ID_25','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_26','VPXI_EVENT_DATASTORE_ID_26','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_27','VPXI_EVENT_DATASTORE_ID_27','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_28','VPXI_EVENT_DATASTORE_ID_28','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_29','VPXI_EVENT_DATASTORE_ID_29','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_30','VPXI_EVENT_DATASTORE_ID_30','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_31','VPXI_EVENT_DATASTORE_ID_31','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_32','VPXI_EVENT_DATASTORE_ID_32','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_33','VPXI_EVENT_DATASTORE_ID_33','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_34','VPXI_EVENT_DATASTORE_ID_34','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_35','VPXI_EVENT_DATASTORE_ID_35','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_36','VPXI_EVENT_DATASTORE_ID_36','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_37','VPXI_EVENT_DATASTORE_ID_37','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_38','VPXI_EVENT_DATASTORE_ID_38','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_39','VPXI_EVENT_DATASTORE_ID_39','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_40','VPXI_EVENT_DATASTORE_ID_40','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_41','VPXI_EVENT_DATASTORE_ID_41','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_42','VPXI_EVENT_DATASTORE_ID_42','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_43','VPXI_EVENT_DATASTORE_ID_43','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_44','VPXI_EVENT_DATASTORE_ID_44','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_45','VPXI_EVENT_DATASTORE_ID_45','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_46','VPXI_EVENT_DATASTORE_ID_46','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_47','VPXI_EVENT_DATASTORE_ID_47','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_48','VPXI_EVENT_DATASTORE_ID_48','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_49','VPXI_EVENT_DATASTORE_ID_49','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_50','VPXI_EVENT_DATASTORE_ID_50','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_51','VPXI_EVENT_DATASTORE_ID_51','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_52','VPXI_EVENT_DATASTORE_ID_52','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_53','VPXI_EVENT_DATASTORE_ID_53','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_54','VPXI_EVENT_DATASTORE_ID_54','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_55','VPXI_EVENT_DATASTORE_ID_55','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_56','VPXI_EVENT_DATASTORE_ID_56','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_57','VPXI_EVENT_DATASTORE_ID_57','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_58','VPXI_EVENT_DATASTORE_ID_58','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_59','VPXI_EVENT_DATASTORE_ID_59','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_60','VPXI_EVENT_DATASTORE_ID_60','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_61','VPXI_EVENT_DATASTORE_ID_61','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_62','VPXI_EVENT_DATASTORE_ID_62','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_63','VPXI_EVENT_DATASTORE_ID_63','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_64','VPXI_EVENT_DATASTORE_ID_64','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_65','VPXI_EVENT_DATASTORE_ID_65','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_66','VPXI_EVENT_DATASTORE_ID_66','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_67','VPXI_EVENT_DATASTORE_ID_67','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_68','VPXI_EVENT_DATASTORE_ID_68','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_69','VPXI_EVENT_DATASTORE_ID_69','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_70','VPXI_EVENT_DATASTORE_ID_70','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_71','VPXI_EVENT_DATASTORE_ID_71','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_72','VPXI_EVENT_DATASTORE_ID_72','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_73','VPXI_EVENT_DATASTORE_ID_73','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_74','VPXI_EVENT_DATASTORE_ID_74','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_75','VPXI_EVENT_DATASTORE_ID_75','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_76','VPXI_EVENT_DATASTORE_ID_76','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_77','VPXI_EVENT_DATASTORE_ID_77','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_78','VPXI_EVENT_DATASTORE_ID_78','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_79','VPXI_EVENT_DATASTORE_ID_79','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_80','VPXI_EVENT_DATASTORE_ID_80','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_81','VPXI_EVENT_DATASTORE_ID_81','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_82','VPXI_EVENT_DATASTORE_ID_82','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_83','VPXI_EVENT_DATASTORE_ID_83','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_84','VPXI_EVENT_DATASTORE_ID_84','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_85','VPXI_EVENT_DATASTORE_ID_85','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_86','VPXI_EVENT_DATASTORE_ID_86','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_87','VPXI_EVENT_DATASTORE_ID_87','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_88','VPXI_EVENT_DATASTORE_ID_88','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_89','VPXI_EVENT_DATASTORE_ID_89','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_90','VPXI_EVENT_DATASTORE_ID_90','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_91','VPXI_EVENT_DATASTORE_ID_91','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_92','VPXI_EVENT_DATASTORE_ID_92','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_1','VPXI_EVENT_EVENT_TYPE_1','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_2','VPXI_EVENT_EVENT_TYPE_2','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_3','VPXI_EVENT_EVENT_TYPE_3','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_4','VPXI_EVENT_EVENT_TYPE_4','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_5','VPXI_EVENT_EVENT_TYPE_5','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_6','VPXI_EVENT_EVENT_TYPE_6','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_7','VPXI_EVENT_EVENT_TYPE_7','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_8','VPXI_EVENT_EVENT_TYPE_8','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_9','VPXI_EVENT_EVENT_TYPE_9','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_10','VPXI_EVENT_EVENT_TYPE_10','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_11','VPXI_EVENT_EVENT_TYPE_11','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_12','VPXI_EVENT_EVENT_TYPE_12','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_13','VPXI_EVENT_EVENT_TYPE_13','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_14','VPXI_EVENT_EVENT_TYPE_14','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_15','VPXI_EVENT_EVENT_TYPE_15','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_16','VPXI_EVENT_EVENT_TYPE_16','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_17','VPXI_EVENT_EVENT_TYPE_17','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_18','VPXI_EVENT_EVENT_TYPE_18','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_19','VPXI_EVENT_EVENT_TYPE_19','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_20','VPXI_EVENT_EVENT_TYPE_20','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_21','VPXI_EVENT_EVENT_TYPE_21','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_22','VPXI_EVENT_EVENT_TYPE_22','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_23','VPXI_EVENT_EVENT_TYPE_23','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_24','VPXI_EVENT_EVENT_TYPE_24','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_25','VPXI_EVENT_EVENT_TYPE_25','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_26','VPXI_EVENT_EVENT_TYPE_26','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_27','VPXI_EVENT_EVENT_TYPE_27','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_28','VPXI_EVENT_EVENT_TYPE_28','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_29','VPXI_EVENT_EVENT_TYPE_29','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_30','VPXI_EVENT_EVENT_TYPE_30','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_31','VPXI_EVENT_EVENT_TYPE_31','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_33','VPXI_EVENT_EVENT_TYPE_33','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_34','VPXI_EVENT_EVENT_TYPE_34','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_35','VPXI_EVENT_EVENT_TYPE_35','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_36','VPXI_EVENT_EVENT_TYPE_36','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_37','VPXI_EVENT_EVENT_TYPE_37','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_38','VPXI_EVENT_EVENT_TYPE_38','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_39','VPXI_EVENT_EVENT_TYPE_39','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_40','VPXI_EVENT_EVENT_TYPE_40','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_41','VPXI_EVENT_EVENT_TYPE_41','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_42','VPXI_EVENT_EVENT_TYPE_42','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_43','VPXI_EVENT_EVENT_TYPE_43','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_44','VPXI_EVENT_EVENT_TYPE_44','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_45','VPXI_EVENT_EVENT_TYPE_45','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_46','VPXI_EVENT_EVENT_TYPE_46','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_47','VPXI_EVENT_EVENT_TYPE_47','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_48','VPXI_EVENT_EVENT_TYPE_48','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_49','VPXI_EVENT_EVENT_TYPE_49','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_50','VPXI_EVENT_EVENT_TYPE_50','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_51','VPXI_EVENT_EVENT_TYPE_51','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_52','VPXI_EVENT_EVENT_TYPE_52','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_53','VPXI_EVENT_EVENT_TYPE_53','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_54','VPXI_EVENT_EVENT_TYPE_54','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_55','VPXI_EVENT_EVENT_TYPE_55','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_56','VPXI_EVENT_EVENT_TYPE_56','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_57','VPXI_EVENT_EVENT_TYPE_57','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_58','VPXI_EVENT_EVENT_TYPE_58','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_59','VPXI_EVENT_EVENT_TYPE_59','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_60','VPXI_EVENT_EVENT_TYPE_60','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_61','VPXI_EVENT_EVENT_TYPE_61','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_62','VPXI_EVENT_EVENT_TYPE_62','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_63','VPXI_EVENT_EVENT_TYPE_63','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_64','VPXI_EVENT_EVENT_TYPE_64','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_65','VPXI_EVENT_EVENT_TYPE_65','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_66','VPXI_EVENT_EVENT_TYPE_66','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_67','VPXI_EVENT_EVENT_TYPE_67','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_68','VPXI_EVENT_EVENT_TYPE_68','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_69','VPXI_EVENT_EVENT_TYPE_69','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_70','VPXI_EVENT_EVENT_TYPE_70','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_71','VPXI_EVENT_EVENT_TYPE_71','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_72','VPXI_EVENT_EVENT_TYPE_72','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_73','VPXI_EVENT_EVENT_TYPE_73','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_74','VPXI_EVENT_EVENT_TYPE_74','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_75','VPXI_EVENT_EVENT_TYPE_75','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_76','VPXI_EVENT_EVENT_TYPE_76','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_77','VPXI_EVENT_EVENT_TYPE_77','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_78','VPXI_EVENT_EVENT_TYPE_78','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_79','VPXI_EVENT_EVENT_TYPE_79','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_80','VPXI_EVENT_EVENT_TYPE_80','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_81','VPXI_EVENT_EVENT_TYPE_81','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_82','VPXI_EVENT_EVENT_TYPE_82','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_83','VPXI_EVENT_EVENT_TYPE_83','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_84','VPXI_EVENT_EVENT_TYPE_84','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_85','VPXI_EVENT_EVENT_TYPE_85','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_86','VPXI_EVENT_EVENT_TYPE_86','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_87','VPXI_EVENT_EVENT_TYPE_87','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_88','VPXI_EVENT_EVENT_TYPE_88','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_89','VPXI_EVENT_EVENT_TYPE_89','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_90','VPXI_EVENT_EVENT_TYPE_90','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_91','VPXI_EVENT_EVENT_TYPE_91','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_92','VPXI_EVENT_EVENT_TYPE_92','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_1','VPXI_EVENT_EXTENDED_CLASS_1','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_2','VPXI_EVENT_EXTENDED_CLASS_2','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_3','VPXI_EVENT_EXTENDED_CLASS_3','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_4','VPXI_EVENT_EXTENDED_CLASS_4','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_5','VPXI_EVENT_EXTENDED_CLASS_5','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_6','VPXI_EVENT_EXTENDED_CLASS_6','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_7','VPXI_EVENT_EXTENDED_CLASS_7','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_8','VPXI_EVENT_EXTENDED_CLASS_8','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_9','VPXI_EVENT_EXTENDED_CLASS_9','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_10','VPXI_EVENT_EXTENDED_CLASS_10','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_11','VPXI_EVENT_EXTENDED_CLASS_11','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_12','VPXI_EVENT_EXTENDED_CLASS_12','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_13','VPXI_EVENT_EXTENDED_CLASS_13','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_14','VPXI_EVENT_EXTENDED_CLASS_14','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_15','VPXI_EVENT_EXTENDED_CLASS_15','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_16','VPXI_EVENT_EXTENDED_CLASS_16','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_17','VPXI_EVENT_EXTENDED_CLASS_17','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_18','VPXI_EVENT_EXTENDED_CLASS_18','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_19','VPXI_EVENT_EXTENDED_CLASS_19','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_20','VPXI_EVENT_EXTENDED_CLASS_20','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_21','VPXI_EVENT_EXTENDED_CLASS_21','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_22','VPXI_EVENT_EXTENDED_CLASS_22','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_23','VPXI_EVENT_EXTENDED_CLASS_23','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_24','VPXI_EVENT_EXTENDED_CLASS_24','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_25','VPXI_EVENT_EXTENDED_CLASS_25','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_26','VPXI_EVENT_EXTENDED_CLASS_26','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_27','VPXI_EVENT_EXTENDED_CLASS_27','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_28','VPXI_EVENT_EXTENDED_CLASS_28','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_29','VPXI_EVENT_EXTENDED_CLASS_29','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_30','VPXI_EVENT_EXTENDED_CLASS_30','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_31','VPXI_EVENT_EXTENDED_CLASS_31','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_32','VPXI_EVENT_EXTENDED_CLASS_32','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_33','VPXI_EVENT_EXTENDED_CLASS_33','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_34','VPXI_EVENT_EXTENDED_CLASS_34','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_35','VPXI_EVENT_EXTENDED_CLASS_35','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_36','VPXI_EVENT_EXTENDED_CLASS_36','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_37','VPXI_EVENT_EXTENDED_CLASS_37','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_38','VPXI_EVENT_EXTENDED_CLASS_38','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_39','VPXI_EVENT_EXTENDED_CLASS_39','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_40','VPXI_EVENT_EXTENDED_CLASS_40','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_41','VPXI_EVENT_EXTENDED_CLASS_41','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_42','VPXI_EVENT_EXTENDED_CLASS_42','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_43','VPXI_EVENT_EXTENDED_CLASS_43','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_44','VPXI_EVENT_EXTENDED_CLASS_44','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_45','VPXI_EVENT_EXTENDED_CLASS_45','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_46','VPXI_EVENT_EXTENDED_CLASS_46','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_47','VPXI_EVENT_EXTENDED_CLASS_47','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_48','VPXI_EVENT_EXTENDED_CLASS_48','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_49','VPXI_EVENT_EXTENDED_CLASS_49','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_50','VPXI_EVENT_EXTENDED_CLASS_50','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_51','VPXI_EVENT_EXTENDED_CLASS_51','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_52','VPXI_EVENT_EXTENDED_CLASS_52','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_53','VPXI_EVENT_EXTENDED_CLASS_53','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_54','VPXI_EVENT_EXTENDED_CLASS_54','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_55','VPXI_EVENT_EXTENDED_CLASS_55','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_56','VPXI_EVENT_EXTENDED_CLASS_56','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_57','VPXI_EVENT_EXTENDED_CLASS_57','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_58','VPXI_EVENT_EXTENDED_CLASS_58','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_59','VPXI_EVENT_EXTENDED_CLASS_59','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_60','VPXI_EVENT_EXTENDED_CLASS_60','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_61','VPXI_EVENT_EXTENDED_CLASS_61','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_62','VPXI_EVENT_EXTENDED_CLASS_62','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_63','VPXI_EVENT_EXTENDED_CLASS_63','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_64','VPXI_EVENT_EXTENDED_CLASS_64','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_65','VPXI_EVENT_EXTENDED_CLASS_65','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_66','VPXI_EVENT_EXTENDED_CLASS_66','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_67','VPXI_EVENT_EXTENDED_CLASS_67','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_68','VPXI_EVENT_EXTENDED_CLASS_68','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_69','VPXI_EVENT_EXTENDED_CLASS_69','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_70','VPXI_EVENT_EXTENDED_CLASS_70','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_71','VPXI_EVENT_EXTENDED_CLASS_71','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_72','VPXI_EVENT_EXTENDED_CLASS_72','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_73','VPXI_EVENT_EXTENDED_CLASS_73','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_74','VPXI_EVENT_EXTENDED_CLASS_74','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_75','VPXI_EVENT_EXTENDED_CLASS_75','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_76','VPXI_EVENT_EXTENDED_CLASS_76','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_77','VPXI_EVENT_EXTENDED_CLASS_77','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_78','VPXI_EVENT_EXTENDED_CLASS_78','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_79','VPXI_EVENT_EXTENDED_CLASS_79','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_80','VPXI_EVENT_EXTENDED_CLASS_80','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_81','VPXI_EVENT_EXTENDED_CLASS_81','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_82','VPXI_EVENT_EXTENDED_CLASS_82','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_83','VPXI_EVENT_EXTENDED_CLASS_83','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_84','VPXI_EVENT_EXTENDED_CLASS_84','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_85','VPXI_EVENT_EXTENDED_CLASS_85','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_86','VPXI_EVENT_EXTENDED_CLASS_86','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_87','VPXI_EVENT_EXTENDED_CLASS_87','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_88','VPXI_EVENT_EXTENDED_CLASS_88','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_89','VPXI_EVENT_EXTENDED_CLASS_89','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_90','VPXI_EVENT_EXTENDED_CLASS_90','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_91','VPXI_EVENT_EXTENDED_CLASS_91','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_92','VPXI_EVENT_EXTENDED_CLASS_92','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_1','VPXI_EVENT_HOST_ID_1','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_2','VPXI_EVENT_HOST_ID_2','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_3','VPXI_EVENT_HOST_ID_3','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_4','VPXI_EVENT_HOST_ID_4','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_5','VPXI_EVENT_HOST_ID_5','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_6','VPXI_EVENT_HOST_ID_6','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_7','VPXI_EVENT_HOST_ID_7','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_8','VPXI_EVENT_HOST_ID_8','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_9','VPXI_EVENT_HOST_ID_9','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_10','VPXI_EVENT_HOST_ID_10','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_11','VPXI_EVENT_HOST_ID_11','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_12','VPXI_EVENT_HOST_ID_12','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_13','VPXI_EVENT_HOST_ID_13','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_14','VPXI_EVENT_HOST_ID_14','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_15','VPXI_EVENT_HOST_ID_15','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_16','VPXI_EVENT_HOST_ID_16','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_17','VPXI_EVENT_HOST_ID_17','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_18','VPXI_EVENT_HOST_ID_18','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_19','VPXI_EVENT_HOST_ID_19','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_20','VPXI_EVENT_HOST_ID_20','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_21','VPXI_EVENT_HOST_ID_21','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_22','VPXI_EVENT_HOST_ID_22','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_23','VPXI_EVENT_HOST_ID_23','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_24','VPXI_EVENT_HOST_ID_24','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_25','VPXI_EVENT_HOST_ID_25','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_26','VPXI_EVENT_HOST_ID_26','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_27','VPXI_EVENT_HOST_ID_27','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_28','VPXI_EVENT_HOST_ID_28','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_29','VPXI_EVENT_HOST_ID_29','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_30','VPXI_EVENT_HOST_ID_30','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_31','VPXI_EVENT_HOST_ID_31','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_32','VPXI_EVENT_HOST_ID_32','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_33','VPXI_EVENT_HOST_ID_33','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_34','VPXI_EVENT_HOST_ID_34','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_35','VPXI_EVENT_HOST_ID_35','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_36','VPXI_EVENT_HOST_ID_36','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_37','VPXI_EVENT_HOST_ID_37','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_38','VPXI_EVENT_HOST_ID_38','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_39','VPXI_EVENT_HOST_ID_39','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_40','VPXI_EVENT_HOST_ID_40','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_41','VPXI_EVENT_HOST_ID_41','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_42','VPXI_EVENT_HOST_ID_42','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_43','VPXI_EVENT_HOST_ID_43','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_44','VPXI_EVENT_HOST_ID_44','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_45','VPXI_EVENT_HOST_ID_45','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_46','VPXI_EVENT_HOST_ID_46','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_47','VPXI_EVENT_HOST_ID_47','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_48','VPXI_EVENT_HOST_ID_48','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_49','VPXI_EVENT_HOST_ID_49','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_50','VPXI_EVENT_HOST_ID_50','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_51','VPXI_EVENT_HOST_ID_51','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_52','VPXI_EVENT_HOST_ID_52','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_53','VPXI_EVENT_HOST_ID_53','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_54','VPXI_EVENT_HOST_ID_54','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_55','VPXI_EVENT_HOST_ID_55','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_56','VPXI_EVENT_HOST_ID_56','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_57','VPXI_EVENT_HOST_ID_57','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_58','VPXI_EVENT_HOST_ID_58','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_59','VPXI_EVENT_HOST_ID_59','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_60','VPXI_EVENT_HOST_ID_60','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_61','VPXI_EVENT_HOST_ID_61','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_62','VPXI_EVENT_HOST_ID_62','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_63','VPXI_EVENT_HOST_ID_63','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_64','VPXI_EVENT_HOST_ID_64','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_65','VPXI_EVENT_HOST_ID_65','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_66','VPXI_EVENT_HOST_ID_66','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_67','VPXI_EVENT_HOST_ID_67','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_68','VPXI_EVENT_HOST_ID_68','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_69','VPXI_EVENT_HOST_ID_69','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_70','VPXI_EVENT_HOST_ID_70','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_71','VPXI_EVENT_HOST_ID_71','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_72','VPXI_EVENT_HOST_ID_72','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_73','VPXI_EVENT_HOST_ID_73','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_74','VPXI_EVENT_HOST_ID_74','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_75','VPXI_EVENT_HOST_ID_75','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_76','VPXI_EVENT_HOST_ID_76','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_77','VPXI_EVENT_HOST_ID_77','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_78','VPXI_EVENT_HOST_ID_78','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_79','VPXI_EVENT_HOST_ID_79','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_80','VPXI_EVENT_HOST_ID_80','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_81','VPXI_EVENT_HOST_ID_81','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_82','VPXI_EVENT_HOST_ID_82','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_83','VPXI_EVENT_HOST_ID_83','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_84','VPXI_EVENT_HOST_ID_84','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_85','VPXI_EVENT_HOST_ID_85','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_86','VPXI_EVENT_HOST_ID_86','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_87','VPXI_EVENT_HOST_ID_87','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_88','VPXI_EVENT_HOST_ID_88','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_89','VPXI_EVENT_HOST_ID_89','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_90','VPXI_EVENT_HOST_ID_90','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_91','VPXI_EVENT_HOST_ID_91','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_92','VPXI_EVENT_HOST_ID_92','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_1','VPXI_EVENT_USERNAME_1','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_2','VPXI_EVENT_USERNAME_2','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_3','VPXI_EVENT_USERNAME_3','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_4','VPXI_EVENT_USERNAME_4','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_5','VPXI_EVENT_USERNAME_5','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_6','VPXI_EVENT_USERNAME_6','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_7','VPXI_EVENT_USERNAME_7','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_8','VPXI_EVENT_USERNAME_8','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_9','VPXI_EVENT_USERNAME_9','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_10','VPXI_EVENT_USERNAME_10','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_11','VPXI_EVENT_USERNAME_11','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_12','VPXI_EVENT_USERNAME_12','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_13','VPXI_EVENT_USERNAME_13','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_14','VPXI_EVENT_USERNAME_14','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_15','VPXI_EVENT_USERNAME_15','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_16','VPXI_EVENT_USERNAME_16','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_17','VPXI_EVENT_USERNAME_17','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_18','VPXI_EVENT_USERNAME_18','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_19','VPXI_EVENT_USERNAME_19','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_20','VPXI_EVENT_USERNAME_20','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_21','VPXI_EVENT_USERNAME_21','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_22','VPXI_EVENT_USERNAME_22','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_23','VPXI_EVENT_USERNAME_23','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_24','VPXI_EVENT_USERNAME_24','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_25','VPXI_EVENT_USERNAME_25','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_26','VPXI_EVENT_USERNAME_26','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_27','VPXI_EVENT_USERNAME_27','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_28','VPXI_EVENT_USERNAME_28','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_29','VPXI_EVENT_USERNAME_29','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_30','VPXI_EVENT_USERNAME_30','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_31','VPXI_EVENT_USERNAME_31','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_32','VPXI_EVENT_USERNAME_32','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_33','VPXI_EVENT_USERNAME_33','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_34','VPXI_EVENT_USERNAME_34','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_35','VPXI_EVENT_USERNAME_35','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_36','VPXI_EVENT_USERNAME_36','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_37','VPXI_EVENT_USERNAME_37','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_38','VPXI_EVENT_USERNAME_38','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_39','VPXI_EVENT_USERNAME_39','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_40','VPXI_EVENT_USERNAME_40','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_41','VPXI_EVENT_USERNAME_41','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_42','VPXI_EVENT_USERNAME_42','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_43','VPXI_EVENT_USERNAME_43','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_44','VPXI_EVENT_USERNAME_44','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_45','VPXI_EVENT_USERNAME_45','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_46','VPXI_EVENT_USERNAME_46','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_47','VPXI_EVENT_USERNAME_47','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_48','VPXI_EVENT_USERNAME_48','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_49','VPXI_EVENT_USERNAME_49','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_50','VPXI_EVENT_USERNAME_50','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_51','VPXI_EVENT_USERNAME_51','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_52','VPXI_EVENT_USERNAME_52','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_53','VPXI_EVENT_USERNAME_53','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_54','VPXI_EVENT_USERNAME_54','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_55','VPXI_EVENT_USERNAME_55','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_56','VPXI_EVENT_USERNAME_56','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_57','VPXI_EVENT_USERNAME_57','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_58','VPXI_EVENT_USERNAME_58','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_59','VPXI_EVENT_USERNAME_59','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_60','VPXI_EVENT_USERNAME_60','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_61','VPXI_EVENT_USERNAME_61','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_62','VPXI_EVENT_USERNAME_62','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_63','VPXI_EVENT_USERNAME_63','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_64','VPXI_EVENT_USERNAME_64','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_65','VPXI_EVENT_USERNAME_65','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_66','VPXI_EVENT_USERNAME_66','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_67','VPXI_EVENT_USERNAME_67','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_68','VPXI_EVENT_USERNAME_68','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_69','VPXI_EVENT_USERNAME_69','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_70','VPXI_EVENT_USERNAME_70','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_71','VPXI_EVENT_USERNAME_71','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_72','VPXI_EVENT_USERNAME_72','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_73','VPXI_EVENT_USERNAME_73','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_74','VPXI_EVENT_USERNAME_74','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_75','VPXI_EVENT_USERNAME_75','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_76','VPXI_EVENT_USERNAME_76','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_77','VPXI_EVENT_USERNAME_77','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_78','VPXI_EVENT_USERNAME_78','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_79','VPXI_EVENT_USERNAME_79','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_80','VPXI_EVENT_USERNAME_80','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_81','VPXI_EVENT_USERNAME_81','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_82','VPXI_EVENT_USERNAME_82','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_83','VPXI_EVENT_USERNAME_83','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_84','VPXI_EVENT_USERNAME_84','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_85','VPXI_EVENT_USERNAME_85','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_86','VPXI_EVENT_USERNAME_86','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_87','VPXI_EVENT_USERNAME_87','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_88','VPXI_EVENT_USERNAME_88','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_89','VPXI_EVENT_USERNAME_89','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_90','VPXI_EVENT_USERNAME_90','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_91','VPXI_EVENT_USERNAME_91','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_92','VPXI_EVENT_USERNAME_92','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_1','VPXI_EVENT_VM_ID_1','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_2','VPXI_EVENT_VM_ID_2','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_3','VPXI_EVENT_VM_ID_3','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_4','VPXI_EVENT_VM_ID_4','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_5','VPXI_EVENT_VM_ID_5','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_6','VPXI_EVENT_VM_ID_6','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_7','VPXI_EVENT_VM_ID_7','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_8','VPXI_EVENT_VM_ID_8','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_9','VPXI_EVENT_VM_ID_9','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_10','VPXI_EVENT_VM_ID_10','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_11','VPXI_EVENT_VM_ID_11','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_12','VPXI_EVENT_VM_ID_12','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_13','VPXI_EVENT_VM_ID_13','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_14','VPXI_EVENT_VM_ID_14','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_15','VPXI_EVENT_VM_ID_15','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_16','VPXI_EVENT_VM_ID_16','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_17','VPXI_EVENT_VM_ID_17','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_18','VPXI_EVENT_VM_ID_18','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_19','VPXI_EVENT_VM_ID_19','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_20','VPXI_EVENT_VM_ID_20','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_21','VPXI_EVENT_VM_ID_21','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_22','VPXI_EVENT_VM_ID_22','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_23','VPXI_EVENT_VM_ID_23','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_24','VPXI_EVENT_VM_ID_24','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_25','VPXI_EVENT_VM_ID_25','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_26','VPXI_EVENT_VM_ID_26','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_27','VPXI_EVENT_VM_ID_27','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_28','VPXI_EVENT_VM_ID_28','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_29','VPXI_EVENT_VM_ID_29','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_30','VPXI_EVENT_VM_ID_30','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_31','VPXI_EVENT_VM_ID_31','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_32','VPXI_EVENT_VM_ID_32','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_33','VPXI_EVENT_VM_ID_33','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_34','VPXI_EVENT_VM_ID_34','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_35','VPXI_EVENT_VM_ID_35','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_36','VPXI_EVENT_VM_ID_36','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_37','VPXI_EVENT_VM_ID_37','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_38','VPXI_EVENT_VM_ID_38','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_39','VPXI_EVENT_VM_ID_39','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_40','VPXI_EVENT_VM_ID_40','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_41','VPXI_EVENT_VM_ID_41','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_42','VPXI_EVENT_VM_ID_42','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_43','VPXI_EVENT_VM_ID_43','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_44','VPXI_EVENT_VM_ID_44','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_45','VPXI_EVENT_VM_ID_45','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_46','VPXI_EVENT_VM_ID_46','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_47','VPXI_EVENT_VM_ID_47','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_48','VPXI_EVENT_VM_ID_48','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_49','VPXI_EVENT_VM_ID_49','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_50','VPXI_EVENT_VM_ID_50','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_51','VPXI_EVENT_VM_ID_51','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_52','VPXI_EVENT_VM_ID_52','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_53','VPXI_EVENT_VM_ID_53','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_54','VPXI_EVENT_VM_ID_54','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_55','VPXI_EVENT_VM_ID_55','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_56','VPXI_EVENT_VM_ID_56','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_57','VPXI_EVENT_VM_ID_57','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_58','VPXI_EVENT_VM_ID_58','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_59','VPXI_EVENT_VM_ID_59','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_60','VPXI_EVENT_VM_ID_60','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_61','VPXI_EVENT_VM_ID_61','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_62','VPXI_EVENT_VM_ID_62','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_63','VPXI_EVENT_VM_ID_63','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_64','VPXI_EVENT_VM_ID_64','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_65','VPXI_EVENT_VM_ID_65','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_66','VPXI_EVENT_VM_ID_66','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_67','VPXI_EVENT_VM_ID_67','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_68','VPXI_EVENT_VM_ID_68','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_69','VPXI_EVENT_VM_ID_69','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_70','VPXI_EVENT_VM_ID_70','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_71','VPXI_EVENT_VM_ID_71','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_72','VPXI_EVENT_VM_ID_72','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_73','VPXI_EVENT_VM_ID_73','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_74','VPXI_EVENT_VM_ID_74','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_75','VPXI_EVENT_VM_ID_75','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_76','VPXI_EVENT_VM_ID_76','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_77','VPXI_EVENT_VM_ID_77','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_78','VPXI_EVENT_VM_ID_78','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_79','VPXI_EVENT_VM_ID_79','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_80','VPXI_EVENT_VM_ID_80','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_81','VPXI_EVENT_VM_ID_81','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_82','VPXI_EVENT_VM_ID_82','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_83','VPXI_EVENT_VM_ID_83','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_84','VPXI_EVENT_VM_ID_84','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_85','VPXI_EVENT_VM_ID_85','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_86','VPXI_EVENT_VM_ID_86','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_87','VPXI_EVENT_VM_ID_87','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_88','VPXI_EVENT_VM_ID_88','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_89','VPXI_EVENT_VM_ID_89','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_90','VPXI_EVENT_VM_ID_90','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_91','VPXI_EVENT_VM_ID_91','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_92','VPXI_EVENT_VM_ID_92','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_1','VPXI_CHANGE_TAG_1','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_2','VPXI_CHANGE_TAG_2','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_3','VPXI_CHANGE_TAG_3','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_4','VPXI_CHANGE_TAG_4','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_5','VPXI_CHANGE_TAG_5','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_6','VPXI_CHANGE_TAG_6','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_7','VPXI_CHANGE_TAG_7','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_8','VPXI_CHANGE_TAG_8','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_9','VPXI_CHANGE_TAG_9','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_10','VPXI_CHANGE_TAG_10','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_11','VPXI_CHANGE_TAG_11','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_12','VPXI_CHANGE_TAG_12','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_13','VPXI_CHANGE_TAG_13','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_14','VPXI_CHANGE_TAG_14','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_15','VPXI_CHANGE_TAG_15','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_16','VPXI_CHANGE_TAG_16','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_17','VPXI_CHANGE_TAG_17','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_18','VPXI_CHANGE_TAG_18','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_19','VPXI_CHANGE_TAG_19','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_20','VPXI_CHANGE_TAG_20','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_21','VPXI_CHANGE_TAG_21','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_22','VPXI_CHANGE_TAG_22','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_23','VPXI_CHANGE_TAG_23','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_24','VPXI_CHANGE_TAG_24','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_25','VPXI_CHANGE_TAG_25','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_26','VPXI_CHANGE_TAG_26','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_27','VPXI_CHANGE_TAG_27','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_28','VPXI_CHANGE_TAG_28','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_29','VPXI_CHANGE_TAG_29','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_30','VPXI_CHANGE_TAG_30','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_31','VPXI_CHANGE_TAG_31','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_32','VPXI_CHANGE_TAG_32','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_33','VPXI_CHANGE_TAG_33','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_34','VPXI_CHANGE_TAG_34','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_35','VPXI_CHANGE_TAG_35','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_36','VPXI_CHANGE_TAG_36','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_37','VPXI_CHANGE_TAG_37','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_38','VPXI_CHANGE_TAG_38','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_39','VPXI_CHANGE_TAG_39','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_40','VPXI_CHANGE_TAG_40','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_41','VPXI_CHANGE_TAG_41','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_42','VPXI_CHANGE_TAG_42','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_43','VPXI_CHANGE_TAG_43','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_44','VPXI_CHANGE_TAG_44','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_45','VPXI_CHANGE_TAG_45','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_46','VPXI_CHANGE_TAG_46','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_47','VPXI_CHANGE_TAG_47','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_48','VPXI_CHANGE_TAG_48','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_49','VPXI_CHANGE_TAG_49','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_50','VPXI_CHANGE_TAG_50','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_51','VPXI_CHANGE_TAG_51','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_52','VPXI_CHANGE_TAG_52','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_53','VPXI_CHANGE_TAG_53','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_54','VPXI_CHANGE_TAG_54','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_55','VPXI_CHANGE_TAG_55','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_56','VPXI_CHANGE_TAG_56','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_57','VPXI_CHANGE_TAG_57','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_58','VPXI_CHANGE_TAG_58','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_59','VPXI_CHANGE_TAG_59','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_60','VPXI_CHANGE_TAG_60','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_61','VPXI_CHANGE_TAG_61','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_62','VPXI_CHANGE_TAG_62','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_63','VPXI_CHANGE_TAG_63','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_64','VPXI_CHANGE_TAG_64','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_65','VPXI_CHANGE_TAG_65','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_66','VPXI_CHANGE_TAG_66','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_67','VPXI_CHANGE_TAG_67','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_68','VPXI_CHANGE_TAG_68','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_69','VPXI_CHANGE_TAG_69','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_70','VPXI_CHANGE_TAG_70','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_71','VPXI_CHANGE_TAG_71','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_72','VPXI_CHANGE_TAG_72','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_73','VPXI_CHANGE_TAG_73','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_74','VPXI_CHANGE_TAG_74','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_75','VPXI_CHANGE_TAG_75','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_76','VPXI_CHANGE_TAG_76','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_77','VPXI_CHANGE_TAG_77','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_78','VPXI_CHANGE_TAG_78','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_79','VPXI_CHANGE_TAG_79','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_80','VPXI_CHANGE_TAG_80','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_81','VPXI_CHANGE_TAG_81','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_82','VPXI_CHANGE_TAG_82','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_83','VPXI_CHANGE_TAG_83','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_84','VPXI_CHANGE_TAG_84','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_85','VPXI_CHANGE_TAG_85','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_86','VPXI_CHANGE_TAG_86','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_87','VPXI_CHANGE_TAG_87','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_88','VPXI_CHANGE_TAG_88','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_89','VPXI_CHANGE_TAG_89','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_90','VPXI_CHANGE_TAG_90','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_91','VPXI_CHANGE_TAG_91','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_92','VPXI_CHANGE_TAG_92','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_1','VPXI_EVENT_NETWORK_ID_1','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_2','VPXI_EVENT_NETWORK_ID_2','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_3','VPXI_EVENT_NETWORK_ID_3','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_4','VPXI_EVENT_NETWORK_ID_4','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_5','VPXI_EVENT_NETWORK_ID_5','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_6','VPXI_EVENT_NETWORK_ID_6','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_7','VPXI_EVENT_NETWORK_ID_7','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_8','VPXI_EVENT_NETWORK_ID_8','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_9','VPXI_EVENT_NETWORK_ID_9','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_10','VPXI_EVENT_NETWORK_ID_10','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_11','VPXI_EVENT_NETWORK_ID_11','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_12','VPXI_EVENT_NETWORK_ID_12','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_13','VPXI_EVENT_NETWORK_ID_13','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_14','VPXI_EVENT_NETWORK_ID_14','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_15','VPXI_EVENT_NETWORK_ID_15','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_16','VPXI_EVENT_NETWORK_ID_16','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_17','VPXI_EVENT_NETWORK_ID_17','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_18','VPXI_EVENT_NETWORK_ID_18','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_19','VPXI_EVENT_NETWORK_ID_19','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_20','VPXI_EVENT_NETWORK_ID_20','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_21','VPXI_EVENT_NETWORK_ID_21','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_22','VPXI_EVENT_NETWORK_ID_22','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_23','VPXI_EVENT_NETWORK_ID_23','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_24','VPXI_EVENT_NETWORK_ID_24','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_25','VPXI_EVENT_NETWORK_ID_25','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_26','VPXI_EVENT_NETWORK_ID_26','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_27','VPXI_EVENT_NETWORK_ID_27','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_28','VPXI_EVENT_NETWORK_ID_28','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_29','VPXI_EVENT_NETWORK_ID_29','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_30','VPXI_EVENT_NETWORK_ID_30','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_31','VPXI_EVENT_NETWORK_ID_31','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_32','VPXI_EVENT_NETWORK_ID_32','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_33','VPXI_EVENT_NETWORK_ID_33','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_34','VPXI_EVENT_NETWORK_ID_34','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_35','VPXI_EVENT_NETWORK_ID_35','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_36','VPXI_EVENT_NETWORK_ID_36','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_37','VPXI_EVENT_NETWORK_ID_37','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_38','VPXI_EVENT_NETWORK_ID_38','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_39','VPXI_EVENT_NETWORK_ID_39','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_40','VPXI_EVENT_NETWORK_ID_40','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_41','VPXI_EVENT_NETWORK_ID_41','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_42','VPXI_EVENT_NETWORK_ID_42','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_43','VPXI_EVENT_NETWORK_ID_43','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_44','VPXI_EVENT_NETWORK_ID_44','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_45','VPXI_EVENT_NETWORK_ID_45','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_46','VPXI_EVENT_NETWORK_ID_46','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_47','VPXI_EVENT_NETWORK_ID_47','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_48','VPXI_EVENT_NETWORK_ID_48','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_49','VPXI_EVENT_NETWORK_ID_49','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_50','VPXI_EVENT_NETWORK_ID_50','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_51','VPXI_EVENT_NETWORK_ID_51','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_52','VPXI_EVENT_NETWORK_ID_52','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_53','VPXI_EVENT_NETWORK_ID_53','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_54','VPXI_EVENT_NETWORK_ID_54','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_55','VPXI_EVENT_NETWORK_ID_55','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_56','VPXI_EVENT_NETWORK_ID_56','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_57','VPXI_EVENT_NETWORK_ID_57','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_58','VPXI_EVENT_NETWORK_ID_58','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_59','VPXI_EVENT_NETWORK_ID_59','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_60','VPXI_EVENT_NETWORK_ID_60','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_61','VPXI_EVENT_NETWORK_ID_61','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_62','VPXI_EVENT_NETWORK_ID_62','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_63','VPXI_EVENT_NETWORK_ID_63','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_64','VPXI_EVENT_NETWORK_ID_64','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_65','VPXI_EVENT_NETWORK_ID_65','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_66','VPXI_EVENT_NETWORK_ID_66','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_67','VPXI_EVENT_NETWORK_ID_67','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_68','VPXI_EVENT_NETWORK_ID_68','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_69','VPXI_EVENT_NETWORK_ID_69','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_70','VPXI_EVENT_NETWORK_ID_70','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_71','VPXI_EVENT_NETWORK_ID_71','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_72','VPXI_EVENT_NETWORK_ID_72','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_73','VPXI_EVENT_NETWORK_ID_73','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_74','VPXI_EVENT_NETWORK_ID_74','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_75','VPXI_EVENT_NETWORK_ID_75','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_76','VPXI_EVENT_NETWORK_ID_76','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_77','VPXI_EVENT_NETWORK_ID_77','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_78','VPXI_EVENT_NETWORK_ID_78','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_79','VPXI_EVENT_NETWORK_ID_79','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_80','VPXI_EVENT_NETWORK_ID_80','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_81','VPXI_EVENT_NETWORK_ID_81','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_82','VPXI_EVENT_NETWORK_ID_82','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_83','VPXI_EVENT_NETWORK_ID_83','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_84','VPXI_EVENT_NETWORK_ID_84','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_85','VPXI_EVENT_NETWORK_ID_85','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_86','VPXI_EVENT_NETWORK_ID_86','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_87','VPXI_EVENT_NETWORK_ID_87','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_88','VPXI_EVENT_NETWORK_ID_88','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_89','VPXI_EVENT_NETWORK_ID_89','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_90','VPXI_EVENT_NETWORK_ID_90','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_91','VPXI_EVENT_NETWORK_ID_91','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_92','VPXI_EVENT_NETWORK_ID_92','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_1','VPX_EVENT_F1_1','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_2','VPX_EVENT_F1_2','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_3','VPX_EVENT_F1_3','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_4','VPX_EVENT_F1_4','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_5','VPX_EVENT_F1_5','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_6','VPX_EVENT_F1_6','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_7','VPX_EVENT_F1_7','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_8','VPX_EVENT_F1_8','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_9','VPX_EVENT_F1_9','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_10','VPX_EVENT_F1_10','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_11','VPX_EVENT_F1_11','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_12','VPX_EVENT_F1_12','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_13','VPX_EVENT_F1_13','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_14','VPX_EVENT_F1_14','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_15','VPX_EVENT_F1_15','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_16','VPX_EVENT_F1_16','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_17','VPX_EVENT_F1_17','I');
 INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE)  VALUES ('VPX_EVENT_18','VPX_EVENT_F1_18','I');
 INSERT INTO MGRD_E