
 
 
 
 
 
 delete from vpx_version;
 /
 
 INSERT INTO vpx_version VALUES (
         703,
         'VirtualCenter Database 7.0'
 );
 /
 
 SELECT force_checkpoint();
 /
 
 
 
 
 CREATE TABLE VPX_HOST_SCSI_LUN (
         ID                       INT NOT NULL,
         HOST_ID                  BIGINT NOT NULL,
         UUID                     VARCHAR(255) NOT NULL,
         CANONICAL_NAME           VARCHAR(255),
         DISPLAY_NAME             VARCHAR(255),
         UPDATE_DISPLAY_NAME_FLG  NUMERIC(1),
         constraint PK_VPX_HOST_SCSI_LUN primary key (ID),
         constraint FK_HOST_SCSI_LUN_VPX_HOST foreign key(HOST_ID)
                    references VPX_HOST (ID) on delete cascade
 );
 /
 CREATE INDEX VPX_HOST_SCSI_LUN_F1 on VPX_HOST_SCSI_LUN(HOST_ID);
 /
 
 
 
 
 CREATE TABLE VPX_HOST_SCSILUN_DESCRIPTOR (
         ID                 INT NOT NULL,
         DESCRIPTOR_ID_VAL  VARCHAR(255),
         QUALITY            VARCHAR(255),
         constraint FK_HOST_SCSILUN_DESCRIPTOR foreign key(ID)
                    references VPX_HOST_SCSI_LUN (ID) on delete cascade
 );
 /
 
 CREATE INDEX VPX_HOST_SCSILUN_DESC_HOST on VPX_HOST_SCSILUN_DESCRIPTOR(ID);
 /
 
 CREATE SEQUENCE VPX_HOST_SCSI_LUN_SEQ INCREMENT BY 1;
 /
 
 
 
 
 
 CREATE TABLE VPX_HOST_SCSI_DISK_PARTITION (
         ID        INT NOT NULL,
         HOST_ID   BIGINT NOT NULL,
         VMFS_UUID VARCHAR(128),
         DISK_NAME VARCHAR(512),
         constraint FK_HOST_SCSI_DISK_PART foreign key(HOST_ID)
                    references VPX_HOST (ID) on delete cascade
 )
 ;
 /
 CREATE INDEX VPX_SCSI_DISKPART_F1 on VPX_HOST_SCSI_DISK_PARTITION(HOST_ID);
 /
 CREATE INDEX VPX_SCSI_DISKPART_F2 on VPX_HOST_SCSI_DISK_PARTITION(ID);
 /
 CREATE INDEX VPX_SCSI_DISKPART_F3 on VPX_HOST_SCSI_DISK_PARTITION(VMFS_UUID);
 /
 
 CREATE SEQUENCE VPX_HOST_DISK_PART_SEQ INCREMENT BY 1;
 /
 
 
 
 
 CREATE TABLE VPX_NON_ORM_VM_CONFIG_INFO (
         ID                              BIGINT NOT NULL,
         CHANGE_VERSION                  VARCHAR(255),
         CHANGE_TRACKING_ENABLED         NUMERIC(1),
         CPU_HOT_ADD_ENABLED             NUMERIC(1),
         CPU_HOT_REMOVE_ENABLED          NUMERIC(1),
         MEM_HOT_ADD_ENABLED             NUMERIC(1),
         VFLASH_CACHE_RESERVATION        NUMERIC(22),
         NETWORK_SHAPER_AVERAGE_BPS      VARCHAR(22),
         NETWORK_SHAPER_BURST_SIZE       VARCHAR(22),
         NETWORK_SHAPER_ENABLED_FLG      NUMERIC(1),
         NETWORK_SHAPER_PEAK_BPS         VARCHAR(22),
         HARDWARE_NUM                    INTEGER,
         HARDWARE_MEMORY                 INTEGER,
         HARDWARE_CORES                  INTEGER,
         VIRTUAL_ICH7M_PRESENT           NUMERIC(1) default 0,
         VIRTUAL_SMC_PRESENT             NUMERIC(1) default 0,
         CONPREFE_CL_PO_SUSPEND_FLG      NUMERIC(1),
         CONPREFE_SCR_POWER_ON_FLG       NUMERIC(1),
         CONPREFE_POWERONWHENOPENED_FLG  NUMERIC(1),
         TOOLS_BEFORE_GUEST_STANDBY_FLG  NUMERIC(1),
         TOOLS_BEFORE_GUEST_REBOOT_FLG   NUMERIC(1),
         TOOLS_BEFORE_GUESTSHUTDOWN_FLG  NUMERIC(1),
         TOOLS_TOOLS_UPGRADE_POLICY      VARCHAR(255),
         TOOLS_AFTER_RESUME_FLG          NUMERIC(1),
         TOOLS_AFTER_POWER_ON_FLG        NUMERIC(1),
         TOOLS_SYNC_TIME_WITH_HOST_FLG   NUMERIC(1),
         TOOLS_PENDING_CUSTOMIZATION     VARCHAR(255),
         TOOLS_TOOLS_VERSION             INT,
         TOOLS_LASTINSTALL_COUNTER       INT,
         GUEST_FULL_NAME                 VARCHAR(512),
         INSTANCE_UUID                   VARCHAR(255),
         UUID                            VARCHAR(255),
         ANNOTATION                      VARCHAR(2000),
         VERSION                         VARCHAR(255),
         TEMPLATE_FLG                    NUMERIC(1),
         MEM_ALLOCATION_OVERHEAD_LIMIT   VARCHAR(22),
         MEMORY_ALLOCATION_RESERVATION   VARCHAR(22),
         MEMORY_ALLOCATION_LIMIT         VARCHAR(22),
         MEM_ALLOCATION_SHARES_SHARES    INT,
         MEM_ALLOCATION_SHARES_LEVEL     VARCHAR(255),
         MEM_ALLOCEXPAN_RESERVATION_FLG  NUMERIC(1),
         HOT_PLUG_MEMORY_LIMIT           VARCHAR(22),
         FILES_LOG_DIRECTORY             VARCHAR(255),
         FILES_SNAPSHOT_DIRECTORY        VARCHAR(255),
         FILES_VM_PATH_NAME              VARCHAR(512),
         FILES_SUSPEND_DIRECTORY         VARCHAR(255),
         FILES_FTMETADATA_DIRECTORY      VARCHAR(255),
         ALTERNATE_GUEST_NAME            VARCHAR(255),
         SWAP_PLACEMENT                  VARCHAR(255),
         LOCATION_ID                     VARCHAR(255),
         GUEST_ID                        VARCHAR(255),
         BOOT_OPTIONENTER_BIOSSETUP_FLG  NUMERIC(1),
         BOOT_OPTION_BOOT_DELAY          VARCHAR(22),
         BOOT_OPTION_RETRY_ENABLED_FLG   NUMERIC(1),
         BOOT_OPTION_RETRY_DELAY         NUMERIC(22),
         BOOT_OPTION_EFI_SB_ENABLED      NUMERIC(1),
         CPU_ALLOCATION_OVERHEAD_LIMIT   VARCHAR(22),
         CPU_ALLOCATION_RESERVATION      VARCHAR(22),
         CPU_ALLOCATION_LIMIT            VARCHAR(22),
         CPU_ALLOCATION_SHARES_SHARES    INT,
         CPU_ALLOCATION_SHARES_LEVEL     VARCHAR(255),
         C_ALLOC_EXPANDABLE_RESERV_FLG   NUMERIC(1),
         DEF_PO_OPS_DEFAULT_RESET_TYPE   VARCHAR(255),
         DEF_PO_O_DEFAULT_SUSPEND_TYPE   VARCHAR(255),
         DEF_POWER_OPS_SUSPEND_TYPE      VARCHAR(255),
         DEF_POWER_OPS_STANDBY_ACTION    VARCHAR(255),
         DEF_PO_O_DEF_POWER_OFF_TYPE     VARCHAR(255),
         DEFAULT_POWER_OPS_RESET_TYPE    VARCHAR(255),
         DEF_POWER_OPS_POWER_OFF_TYPE    VARCHAR(255),
         H_PLUG_MEMORY_INCREMENT_SIZE    VARCHAR(22),
         NAME                            VARCHAR(255),
         NPIV_WORLD_WIDE_NAME_TYPE       VARCHAR(255),
         NPIV_TEMP_DISABLED              NUMERIC(1),
         NPIV_ON_RDM                     NUMERIC(1),
         NPIV_DESIRED_NWWN               INT,
         NPIV_DESIRED_PWWN               INT,
         MODIFIED                        TIMESTAMP,
         DISK_UUID_ENABLED_FLG           NUMERIC(1),
         SNAPSHOT_DISABLED_FLG           NUMERIC(1),
         RECORD_REPLAY_ENABLED_FLG       NUMERIC(1),
         FAULT_TOLERANCE_TYPE            VARCHAR(255),
         RUN_WITH_DEBUG_INFO_FLG         NUMERIC(1),
         VIRTUAL_MMU_USAGE               VARCHAR(255),
         VIRTUAL_EXEC_USAGE              VARCHAR(255),
         ENABLE_LOGGING_FLG              NUMERIC(1),
         SNAPSHOT_LOCKED_FLG             NUMERIC(1),
         HT_SHARING                      VARCHAR(255),
         DISABLE_ACCELERATION_FLG        NUMERIC(1),
         FL_SNAPSHOT_POWER_OFF_BEHAVIOR  VARCHAR(255),
         FLAGS_MONITOR_TYPE              VARCHAR(255),
         USE_TOE_FLG                     NUMERIC(1),
         FIRMWARE                        VARCHAR(255),
         MAX_MKS_CONNECTIONS             INTEGER,
         NESTED_HV_ENABLED               NUMERIC(1) default 0,
         VIRTUAL_PMC_ENABLED             NUMERIC(1) default 0,
         SCHED_HW_UPGRADE_POLICY         VARCHAR(22) default 'never',
         SCHED_HW_UPGRADE_VERSION        VARCHAR(22),
         SCHED_HW_UPGRADE_STATUS         VARCHAR(22) default 'none',
         LATENCY_SENSITIVITY             INT,
         LATENCY_LEVEL                   VARCHAR(22) default 'normal',
         GUEST_AUTOLOCK_ENABLED          NUMERIC(1) default 0,
         MEM_RES_LOCKED_MAX              NUMERIC(1) default 0,
         VM_OBJECTID                     VARCHAR(255),
         SWAP_OBJECTID                   VARCHAR(255),
         MESSAGE_BUS_TUNNEL_ENABLED      INTEGER,
         GUEST_INTEGRITY_INFO_ENABLED    NUMERIC(1),
         MIGRATE_ENCRYPTION              VARCHAR(15),
         PRESERVED_SWAP_ONPOWEROFF_FLG   NUMERIC(1),
         SWAP_DIR                        VARCHAR(255),
         VM_ID                           BIGINT NOT NULL,
         CREATE_DATE                     TIMESTAMP,
         VVTD_ENABLED                    NUMERIC(1),
         VBS_ENABLED                     NUMERIC(1),
         constraint PK_N_VM_CONFIG_INFO primary key (ID),
         constraint FK_N_VM_CONFIG_INFO_REF_VPX_VM foreign key(VM_ID)
            references VPX_VM (ID) on delete cascade
 )
 ;
 /
 
 
 
 ALTER TABLE VPX_NON_ORM_VM_CONFIG_INFO SET
                     (autovacuum_vacuum_scale_factor = 0.05);
 /
 
 ALTER TABLE VPX_NON_ORM_VM_CONFIG_INFO SET
                     (toast.autovacuum_vacuum_scale_factor = 0.05);
 /
 
 ALTER TABLE VPX_NON_ORM_VM_CONFIG_INFO SET
                     (autovacuum_analyze_scale_factor = 0.05);
 /
 
 ALTER TABLE VPX_NON_ORM_VM_CONFIG_INFO SET
                     (autovacuum_vacuum_threshold = 25);
 /
 
 ALTER TABLE VPX_NON_ORM_VM_CONFIG_INFO SET
                     (toast.autovacuum_vacuum_threshold = 25);
 /
 
 ALTER TABLE VPX_NON_ORM_VM_CONFIG_INFO SET
                     (autovacuum_analyze_threshold = 25);
 /
 
 ALTER TABLE VPX_NON_ORM_VM_CONFIG_INFO SET
                     (autovacuum_vacuum_cost_delay = 10);
 /
 
 ALTER TABLE VPX_NON_ORM_VM_CONFIG_INFO SET
                     (toast.autovacuum_vacuum_cost_delay = 10);
 /
 
 ALTER TABLE VPX_NON_ORM_VM_CONFIG_INFO SET
                     (autovacuum_vacuum_cost_limit = 1000);
 /
 
 ALTER TABLE VPX_NON_ORM_VM_CONFIG_INFO SET
                     (toast.autovacuum_vacuum_cost_limit = 1000);
 /
 
 
 CREATE INDEX VPXI_N_BOOT_OPTIN_RETRY_DELY ON
              VPX_NON_ORM_VM_CONFIG_INFO(BOOT_OPTION_RETRY_DELAY);
 /
 CREATE INDEX VPXI_NORM_VM_ID ON VPX_NON_ORM_VM_CONFIG_INFO(VM_ID);
 /
 
 
 
 
 
 INSERT INTO VPX_NON_ORM_VM_CONFIG_INFO
    SELECT ID,
       CHANGE_VERSION,
       CHANGE_TRACKING_ENABLED,
       CPU_HOT_ADD_ENABLED,
       CPU_HOT_REMOVE_ENABLED,
       MEM_HOT_ADD_ENABLED,
       VFLASH_CACHE_RESERVATION,
       NETWORK_SHAPER_AVERAGE_BPS,
       NETWORK_SHAPER_BURST_SIZE,
       NETWORK_SHAPER_ENABLED_FLG,
       NETWORK_SHAPER_PEAK_BPS,
       HARDWARE_NUM,
       HARDWARE_MEMORY,
       HARDWARE_CORES,
       VIRTUAL_ICH7M_PRESENT,
       VIRTUAL_SMC_PRESENT,
       CONPREFE_CL_PO_SUSPEND_FLG,
       CONPREFE_SCR_POWER_ON_FLG,
       CONPREFE_POWERONWHENOPENED_FLG,
       TOOLS_BEFORE_GUEST_STANDBY_FLG,
       TOOLS_BEFORE_GUEST_REBOOT_FLG,
       TOOLS_BEFORE_GUESTSHUTDOWN_FLG,
       TOOLS_TOOLS_UPGRADE_POLICY,
       TOOLS_AFTER_RESUME_FLG,
       TOOLS_AFTER_POWER_ON_FLG,
       TOOLS_SYNC_TIME_WITH_HOST_FLG,
       TOOLS_PENDING_CUSTOMIZATION,
       TOOLS_TOOLS_VERSION,
       TOOLS_LASTINSTALL_COUNTER,
       GUEST_FULL_NAME,
       INSTANCE_UUID,
       UUID,
       ANNOTATION,
       VERSION,
       TEMPLATE_FLG,
       MEM_ALLOCATION_OVERHEAD_LIMIT,
       MEMORY_ALLOCATION_RESERVATION,
       MEMORY_ALLOCATION_LIMIT,
       MEM_ALLOCATION_SHARES_SHARES,
       MEM_ALLOCATION_SHARES_LEVEL,
       MEM_ALLOCEXPAN_RESERVATION_FLG,
       HOT_PLUG_MEMORY_LIMIT,
       FILES_LOG_DIRECTORY,
       FILES_SNAPSHOT_DIRECTORY,
       FILES_VM_PATH_NAME,
       FILES_SUSPEND_DIRECTORY,
       FILES_FTMETADATA_DIRECTORY,
       ALTERNATE_GUEST_NAME,
       SWAP_PLACEMENT,
       LOCATION_ID,
       GUEST_ID,
       BOOT_OPTIONENTER_BIOSSETUP_FLG,
       BOOT_OPTION_BOOT_DELAY,
       BOOT_OPTION_RETRY_ENABLED_FLG,
       BOOT_OPTION_RETRY_DELAY,
       BOOT_OPTION_EFI_SB_ENABLED,
       CPU_ALLOCATION_OVERHEAD_LIMIT,
       CPU_ALLOCATION_RESERVATION,
       CPU_ALLOCATION_LIMIT,
       CPU_ALLOCATION_SHARES_SHARES,
       CPU_ALLOCATION_SHARES_LEVEL,
       C_ALLOC_EXPANDABLE_RESERV_FLG,
       DEF_PO_OPS_DEFAULT_RESET_TYPE,
       DEF_PO_O_DEFAULT_SUSPEND_TYPE,
       DEF_POWER_OPS_SUSPEND_TYPE,
       DEF_POWER_OPS_STANDBY_ACTION,
       DEF_PO_O_DEF_POWER_OFF_TYPE,
       DEFAULT_POWER_OPS_RESET_TYPE,
       DEF_POWER_OPS_POWER_OFF_TYPE,
       H_PLUG_MEMORY_INCREMENT_SIZE,
       NAME,
       NPIV_WORLD_WIDE_NAME_TYPE,
       NPIV_TEMP_DISABLED,
       NPIV_ON_RDM,
       NPIV_DESIRED_NWWN,
       NPIV_DESIRED_PWWN,
       MODIFIED,
       DISK_UUID_ENABLED_FLG,
       SNAPSHOT_DISABLED_FLG,
       RECORD_REPLAY_ENABLED_FLG,
       FAULT_TOLERANCE_TYPE,
       RUN_WITH_DEBUG_INFO_FLG,
       VIRTUAL_MMU_USAGE,
       VIRTUAL_EXEC_USAGE,
       ENABLE_LOGGING_FLG,
       SNAPSHOT_LOCKED_FLG,
       HT_SHARING,
       DISABLE_ACCELERATION_FLG,
       FL_SNAPSHOT_POWER_OFF_BEHAVIOR,
       FLAGS_MONITOR_TYPE,
       USE_TOE_FLG,
       FIRMWARE,
       MAX_MKS_CONNECTIONS,
       NESTED_HV_ENABLED,
       VIRTUAL_PMC_ENABLED,
       SCHED_HW_UPGRADE_POLICY,
       SCHED_HW_UPGRADE_VERSION,
       SCHED_HW_UPGRADE_STATUS,
       LATENCY_SENSITIVITY,
       LATENCY_LEVEL,
       GUEST_AUTOLOCK_ENABLED,
       MEM_RES_LOCKED_MAX,
       VM_OBJECTID,
       SWAP_OBJECTID,
       MESSAGE_BUS_TUNNEL_ENABLED,
       GUEST_INTEGRITY_INFO_ENABLED,
       MIGRATE_ENCRYPTION,
       PRESERVED_SWAP_ONPOWEROFF_FLG,
       SWAP_DIR,
       ID AS VM_ID
       FROM VPX_VM_CONFIG_INFO;
 /
 
 
 
 
 
 INSERT INTO VPX_NON_ORM_VM_CONFIG_INFO
    SELECT SC.ID,
       CHANGE_VERSION,
       CHANGE_TRACKING_ENABLED,
       CPU_HOT_ADD_ENABLED,
       CPU_HOT_REMOVE_ENABLED,
       MEM_HOT_ADD_ENABLED,
       0,
       NETWORK_SHAPER_AVERAGE_BPS,
       NETWORK_SHAPER_BURST_SIZE,
       NETWORK_SHAPER_ENABLED_FLG,
       NETWORK_SHAPER_PEAK_BPS,
       HARDWARE_NUM,
       HARDWARE_MEMORY,
       HARDWARE_CORES,
       VIRTUAL_ICH7M_PRESENT,
       VIRTUAL_SMC_PRESENT,
       CONPREFE_CL_PO_SUSPEND_FLG,
       CONPREFE_SCR_POWER_ON_FLG,
       CONPREFE_POWERONWHENOPENED_FLG,
       TOOLS_BEFORE_GUEST_STANDBY_FLG,
       TOOLS_BEFORE_GUEST_REBOOT_FLG,
       TOOLS_BEFORE_GUESTSHUTDOWN_FLG,
       TOOLS_TOOLS_UPGRADE_POLICY,
       TOOLS_AFTER_RESUME_FLG,
       TOOLS_AFTER_POWER_ON_FLG,
       TOOLS_SYNC_TIME_WITH_HOST_FLG,
       TOOLS_PENDING_CUSTOMIZATION,
       TOOLS_TOOLS_VERSION,
       TOOLS_LASTINSTALL_COUNTER,
       GUEST_FULL_NAME,
       INSTANCE_UUID,
       UUID,
       ANNOTATION,
       VERSION,
       TEMPLATE_FLG,
       MEM_ALLOCATION_OVERHEAD_LIMIT,
       MEMORY_ALLOCATION_RESERVATION,
       MEMORY_ALLOCATION_LIMIT,
       MEM_ALLOCATION_SHARES_SHARES,
       MEM_ALLOCATION_SHARES_LEVEL,
       MEM_ALLOCEXPAN_RESERVATION_FLG,
       HOT_PLUG_MEMORY_LIMIT,
       FILES_LOG_DIRECTORY,
       FILES_SNAPSHOT_DIRECTORY,
       FILES_VM_PATH_NAME,
       FILES_SUSPEND_DIRECTORY,
       FILES_FTMETADATA_DIRECTORY,
       ALTERNATE_GUEST_NAME,
       SWAP_PLACEMENT,
       LOCATION_ID,
       GUEST_ID,
       BOOT_OPTIONENTER_BIOSSETUP_FLG,
       BOOT_OPTION_BOOT_DELAY,
       BOOT_OPTION_RETRY_ENABLED_FLG,
       BOOT_OPTION_RETRY_DELAY,
       BOOT_OPTION_EFI_SB_ENABLED,
       CPU_ALLOCATION_OVERHEAD_LIMIT,
       CPU_ALLOCATION_RESERVATION,
       CPU_ALLOCATION_LIMIT,
       CPU_ALLOCATION_SHARES_SHARES,
       CPU_ALLOCATION_SHARES_LEVEL,
       C_ALLOC_EXPANDABLE_RESERV_FLG,
       DEF_PO_OPS_DEFAULT_RESET_TYPE,
       DEF_PO_O_DEFAULT_SUSPEND_TYPE,
       DEF_POWER_OPS_SUSPEND_TYPE,
       DEF_POWER_OPS_STANDBY_ACTION,
       DEF_PO_O_DEF_POWER_OFF_TYPE,
       DEFAULT_POWER_OPS_RESET_TYPE,
       DEF_POWER_OPS_POWER_OFF_TYPE,
       H_PLUG_MEMORY_INCREMENT_SIZE,
       NAME,
       NPIV_WORLD_WIDE_NAME_TYPE,
       NPIV_TEMP_DISABLED,
       NPIV_ON_RDM,
       NPIV_DESIRED_NWWN,
       NPIV_DESIRED_PWWN,
       MODIFIED,
       DISK_UUID_ENABLED_FLG,
       SNAPSHOT_DISABLED_FLG,
       RECORD_REPLAY_ENABLED_FLG,
       FAULT_TOLERANCE_TYPE,
       RUN_WITH_DEBUG_INFO_FLG,
       VIRTUAL_MMU_USAGE,
       VIRTUAL_EXEC_USAGE,
       ENABLE_LOGGING_FLG,
       SNAPSHOT_LOCKED_FLG,
       HT_SHARING,
       DISABLE_ACCELERATION_FLG,
       FL_SNAPSHOT_POWER_OFF_BEHAVIOR,
       FLAGS_MONITOR_TYPE,
       USE_TOE_FLG,
       FIRMWARE,
       MAX_MKS_CONNECTIONS,
       NESTED_HV_ENABLED,
       VIRTUAL_PMC_ENABLED,
       SCHED_HW_UPGRADE_POLICY,
       SCHED_HW_UPGRADE_VERSION,
       SCHED_HW_UPGRADE_STATUS,
       LATENCY_SENSITIVITY,
       LATENCY_LEVEL,
       GUEST_AUTOLOCK_ENABLED,
       MEM_RES_LOCKED_MAX,
       VM_OBJECTID,
       SWAP_OBJECTID,
       0,
       GUEST_INTEGRITY_INFO_ENABLED,
       null,
       PRESERVED_SWAP_ONPOWEROFF_FLG,
       SWAP_DIR,
       S.VM_ID as VM_ID
       FROM VPX_SN_CONFIG_INFO SC, VPX_SNAPSHOT S
             WHERE SC.ID = S.ID;
 /
 
 
 
 
 
 CREATE TABLE VPX_DS_INFO (
    ID                            BIGINT         NOT NULL,
    FREE_SPACE                    VARCHAR(21)    NULL,
    MAX_FILE_SIZE                 VARCHAR(21)    NULL,
    MAX_MEMORY_FILE_SIZE          NUMERIC(22)    DEFAULT 70368744177664 NOT NULL,
    NAME                          VARCHAR(255)   NULL,
    TIMESTAMP                     TIMESTAMP,
    URL                           VARCHAR(440)   NOT NULL,
    VPX_TYPE                      VARCHAR(255)   NULL,
    PATH                          VARCHAR(512)   NULL,
    REMOTE_HOST                   VARCHAR(255)   NULL,
    REMOTE_HOST_NAMES             TEXT           NULL,
    REMOTE_PATH                   VARCHAR(512)   NULL,
    USER_NAME                     VARCHAR(255)   NULL,
    SECURITY_TYPE                 VARCHAR(512)   NULL,
    BLOCKSIZE_MB                  INT            NULL,
    FORCEMOUNT_FLG                NUMERIC(1)     NULL,
    FORCEMOUNT_PERSIST_FLG        NUMERIC(1)     NULL,
    MAJOR_VERSION                 INT            NULL,
    MAX_PHYSICAL_RDM_FILE_SIZE    NUMERIC(22)    NULL,
    MAX_VIRTUAL_RDM_FILE_SIZE     NUMERIC(22)    NULL,
    VMFS_UUID                     VARCHAR(255)   NULL,
    VMFS_VERSION                  VARCHAR(255)   NULL,
    VMFS_UPGRADEABLE              NUMERIC(1)     NULL,
    VMFS_NAME                     VARCHAR(255)   NULL,
    VMFS_TYPE                     VARCHAR(255)   NULL,
    VMFS_CAPACITY                 NUMERIC(38)    NULL,
    VMFS_MAX_BLOCKS               INT            NULL,
    VMFS_SSD_FLG                  NUMERIC(1)     NULL,
    VVOL_UUID                     VARCHAR(255)   NULL,
    VVOL_VASA_PROVIDER_INFO       TEXT           NULL,
    VVOL_STORAGE_ARRAY            TEXT           NULL,
    constraint PK_VPX_DS_INFO primary key (ID,URL),
    constraint FK_VPX_DS_INFO foreign key (ID)
       references VPX_DATASTORE (ID) on delete cascade
 )
 ;
 /
 
 
 
 
 CREATE TABLE VPX_DS_VMFS_EXTENT (
    ID              BIGINT         NOT NULL,
    DISK_NAME       VARCHAR(512),
    PARTITION_VAL   INT,
    SURR_KEY        SERIAL,
    constraint PK_VPX_DS_VMFS_EXTENT primary key (ID,SURR_KEY),
    constraint FK_VPX_DS_VMFS_EXTENT_REF_DS foreign key(ID)
        references VPX_DATASTORE (ID) on delete cascade
 )
 ;
 /
 
 
 
 
 ALTER TABLE VPX_COMPUTE_RESOURCE DROP COLUMN DAS_METROCLUSTER_ENABLED;
 /
 
 
 
 
 
 CREATE TABLE VPX_NORM_VM_FLE_FILE_INFO (
         VM_ID           BIGINT NOT NULL,
         KEY_VAL         INT NOT NULL,
         NAME            VARCHAR(420) DEFAULT ' ',
         FILE_SIZE       VARCHAR(22),
         FILE_UNIQUESIZE VARCHAR(22),
         TYPE            VARCHAR(255),
         constraint PK_NFLE_FILE_INFO primary key (VM_ID, KEY_VAL),
         constraint FK_NFLE_FILE_INFO_REF_VM foreign key(VM_ID)
            references VPX_VM (ID) on delete cascade
 )
 ;
 /
 
 CREATE INDEX VPX_NFLE_FILE_INFO_M1 on VPX_NORM_VM_FLE_FILE_INFO(NAME);
 /
 INSERT INTO VPX_TYPE_MAP VALUES ('layoutEx', 88, null);
 /
 
 
 
 
 CREATE TABLE VPX_VM_TEXT (
    ID             BIGINT NOT NULL,
    TYPE_ID        INT NOT NULL,
    TEXT_VALUE     TEXT,
    VM_ID          BIGINT NOT NULL,
    constraint PK_VM_TEXT primary key (ID, TYPE_ID),
    constraint FK_VM_TEXT_VM foreign key(VM_ID)
       references VPX_VM (ID) on delete cascade
 )
 ;
 /
 CREATE INDEX VPXI_VM_TEXT_VM_ID ON VPX_VM_TEXT(VM_ID);
 /
 
 
 
 
 INSERT INTO VPX_VM_TEXT
    SELECT MO_ID as ID,
       TYPE_ID,
       VALUE AS TEXT_VALUE,
       MO_ID as VM_ID
       FROM VPX_TEXT_ARRAY t, VPX_VM_CONFIG_INFO v  WHERE t.MO_TYPE = 'vm' AND
       t.array_id = v.array_id and t.mo_id = v.id and
       TYPE_ID IN (1, 2, 3, 4, 5, 6,7, 8, 43, 69, 70, 87);
 /
 
 INSERT INTO VPX_VM_TEXT
    SELECT ST.MO_ID as ID,
       TYPE_ID,
       VALUE AS TEXT_VALUE,
       S.VM_ID as VM_ID
       FROM VPX_TEXT_ARRAY ST, VPX_SN_CONFIG_INFO SN, VPX_SNAPSHOT S WHERE
       MO_TYPE = 'snapshot' AND ST.ARRAY_ID = SN.ARRAY_ID AND ST.MO_ID = SN.ID
       AND SN.ID = S.ID AND
       TYPE_ID IN (1, 2, 3, 4, 5, 6, 7, 8, 43, 69, 70, 87) AND ST.MO_ID = S.ID;
 /
 
 
 
 
 
 ALTER TABLE VPX_HOST DROP COLUMN DEFAULT_VM_PATH;
 /
 ALTER TABLE VPX_HOST ADD CRYPTO_ENABLE NUMERIC(1) null;
 /
 
 
 
 
 ALTER TABLE VPX_DVS DROP COLUMN VSPAN_KEY_COUNTER;
 /
 ALTER TABLE VPX_DVS DROP COLUMN VSPAN_DUP_CHECK;
 /
 
 
 
 
 ALTER TABLE VPX_VM ADD PMEM_RESERVATION INTEGER null;
 /
 ALTER TABLE VPX_VM ADD INSTANT_CLONE_FROZEN NUMERIC(1);
 /
 ALTER TABLE VPX_VM ADD CREATE_DATE TIMESTAMP;
 /
 ALTER TABLE VPX_VM DROP COLUMN DESCRIPTION CASCADE;
 /
 ALTER TABLE VPX_VM ADD VVTD_ENABLED NUMERIC(1);
 /
 ALTER TABLE VPX_VM ADD TPM_PRESENT NUMERIC(1);
 /
 ALTER TABLE VPX_VM ADD NUM_VMIOP_BACKINGS INTEGER;
 /
 UPDATE VPX_VM
  SET NUM_VMIOP_BACKINGS = (
   SELECT COUNT(T2.ID)
     FROM VPX_VM_VIRTUAL_DEVICE T2
    WHERE T2.ID = VPX_VM.ID
     AND T2.DEVICE_TYPE = 'vim.vm.device.VirtualPCIPassthrough'
     AND T2.DEVICE_TEXT LIKE '%VmiopBackingInfo%');
 /
 ALTER TABLE VPX_VM ADD CRYPTO_STATE VARCHAR(128) null;
 /
 ALTER TABLE VPX_VM DROP COLUMN ANNOTATION CASCADE;
 /
 ALTER TABLE VPX_VM DROP COLUMN TOOLS_VERSION CASCADE;
 /
 
 
 
 ALTER TABLE VPX_CLUSTER_IOFILTERS ADD VIB_URL VARCHAR(255);
 /
 ALTER TABLE VPX_CLUSTER_IOFILTERS ADD VIB_ID VARCHAR(255);
 /
 ALTER TABLE VPX_CLUSTER_IOFILTERS ADD VIB_NAME VARCHAR(255);
 /
 ALTER TABLE VPX_CLUSTER_IOFILTERS ADD VIB_VERSION VARCHAR(255);
 /
 ALTER TABLE VPX_CLUSTER_IOFILTERS ADD VIB_VENDOR VARCHAR(255);
 /
 ALTER TABLE VPX_CLUSTER_IOFILTERS ADD VIB_SUMMARY VARCHAR(255);
 /
 ALTER TABLE VPX_CLUSTER_IOFILTERS ADD VIB_RELEASE_DATE VARCHAR(255);
 /
 ALTER TABLE VPX_CLUSTER_IOFILTERS ADD FILTER_CLASS VARCHAR(128);
 /
 
 
 
 
 INSERT INTO VPX_DS_INFO
 SELECT ID,
    FREE_SPACE,
    MAX_FILE_SIZE,
    MAX_MEMORY_FILE_SIZE,
    NAME,
    TIMESTAMP,
    URL,
    VPX_TYPE,
    PATH,
    REMOTE_HOST,
    (SELECT ta.VALUE
       FROM VPX_TEXT_ARRAY ta
      WHERE di.ARRAY_ID = ta.ARRAY_ID
        AND di.ID = ta.MO_ID
        AND ta.TYPE_ID = 78
      LIMIT 1)
    AS REMOTE_HOST_NAMES,
    REMOTE_PATH,
    USER_NAME,
    SECURITY_TYPE,
    BLOCKSIZE_MB,
    FORCEMOUNT_FLG,
    FORCEMOUNT_PERSIST_FLG,
    MAJOR_VERSION,
    MAX_PHYSICAL_RDM_FILE_SIZE,
    MAX_VIRTUAL_RDM_FILE_SIZE,
    VMFS_UUID,
    VMFS_VERSION,
    VMFS_UPGRADEABLE,
    VMFS_NAME,
    VMFS_TYPE,
    VMFS_CAPACITY,
    VMFS_MAX_BLOCKS,
    VMFS_SSD_FLG,
    VVOL_UUID,
    (SELECT ta.VALUE
       FROM VPX_TEXT_ARRAY ta
      WHERE di.ARRAY_ID = ta.ARRAY_ID
        AND di.ID = ta.MO_ID
        AND ta.TYPE_ID = 80
      LIMIT 1)
      AS VVOL_VASA_PROVIDER_INFO,
    (SELECT ta.VALUE
       FROM VPX_TEXT_ARRAY ta
      WHERE di.ARRAY_ID = ta.ARRAY_ID
        AND di.ID = ta.MO_ID
        AND ta.TYPE_ID = 81
      LIMIT 1)
      AS VVOL_STORAGE_ARRAY
    FROM VPX_DATASTORE_INFO di;
 /
 
 
 
 
 INSERT INTO VPX_DS_VMFS_EXTENT
    SELECT ID,
    DISK_NAME,
    PARTITION_VAL
    FROM VPX_VMFS_EXTENT;
 /
 
 
 
 
 DROP TABLE VPX_DATASTORE_INFO CASCADE;
 /
 DROP TABLE VPX_VMFS_EXTENT;
 /
 CREATE INDEX VPX_DS_INFO_M1 ON VPX_DS_INFO(VMFS_UUID);
 /
 CREATE INDEX VPX_DS_INFO_M2 ON VPX_DS_INFO(ID, VMFS_UUID);
 /
 
 
 
 
 DROP TABLE VPX_VC_UPGRADE_ID;
 /
 
 
 
 
 ALTER TABLE VPX_DVS DROP COLUMN UPGRADE_MODE;
 /
 ALTER TABLE VPX_DVS DROP COLUMN PORT_COUNTER;
 /
 
 
 
 
 DROP TABLE VPX_PROC_LOG;
 /
 
 CREATE TABLE VPX_PROC_LOG
 (
    EVENT_ID SERIAL,
    PROC_NAME VARCHAR(50) NOT NULL,
    EVENT VARCHAR(50) NOT NULL,
    EVENT_DT TIMESTAMP DEFAULT TIMEZONE('UTC',now()) NOT NULL,
    ERR_FLAG INTEGER NOT NULL,
    DESCRIPTION VARCHAR(1000),
    CONSTRAINT PK_VPX_PROC_LOG PRIMARY KEY(EVENT_ID)
 );
 /
 CREATE INDEX VPXI_PROC_LOG_NAME ON VPX_PROC_LOG (PROC_NAME);
 /
 
 
 
 
 UPDATE VPX_VDEVICE_FILE_BACKING_X
 SET VM_ID = 0
 WHERE VM_ID IS NULL;
 /
 
 DO
 $$
 BEGIN
 IF NOT EXISTS(
    SELECT 1 FROM information_schema.columns
       WHERE IS_NULLABLE = 'NO'
       AND UPPER(TABLE_NAME) = 'VPX_VDEVICE_FILE_BACKING_X'
       AND UPPER(COLUMN_NAME) = 'VM_ID')
 THEN
 ALTER TABLE VPX_VDEVICE_FILE_BACKING_X ALTER COLUMN VM_ID SET NOT NULL;
 END IF;
 END$$;
 /
 
 
 
 
 ALTER TABLE VPX_SN_VDEVICE_BACKING_REL ALTER COLUMN SN_ID SET NOT NULL;
 /
 
 
 
 
 UPDATE VPX_SN_VDEVICE_FILE_BACKING_X
 SET SN_ID = 0
 WHERE SN_ID IS NULL;
 /
 
 DO
 $$
 BEGIN
 IF NOT EXISTS(
    SELECT 1 FROM information_schema.columns
       WHERE IS_NULLABLE = 'NO'
       AND UPPER(TABLE_NAME) = 'VPX_SN_VDEVICE_FILE_BACKING_X'
       AND UPPER(COLUMN_NAME) = 'SN_ID')
 THEN
 ALTER TABLE VPX_SN_VDEVICE_FILE_BACKING_X ALTER COLUMN SN_ID SET NOT NULL;
 END IF;
 END$$;
 /
 
 
 
 
 
 ALTER TABLE VPX_VDEVICE_FILE_BACKING ADD DEVICE_BACKING_LUN_UUID VARCHAR(255);
 /
 ALTER TABLE VPX_VDEVICE_FILE_BACKING ADD DELTA_DISK_FORMAT VARCHAR(50);
 /
 UPDATE VPX_VDEVICE_FILE_BACKING T1
  SET DEVICE_BACKING_LUN_UUID = T2.DEVICE_BACKING_LUN_UUID,
      DELTA_DISK_FORMAT = T2.DELTA_DISK_FORMAT
  FROM VPX_VDEVICE_FILE_BACKING_X T2
  WHERE T1.BACKING_ID = T2.BACKING_ID;
 /
 CREATE INDEX VPX_VDEVICE_FILE_BACKING_M2
  ON VPX_VDEVICE_FILE_BACKING(DEVICE_BACKING_LUN_UUID);
 /
 
 ALTER TABLE VPX_SN_VDEVICE_FILE_BACKING
  ADD DEVICE_BACKING_LUN_UUID VARCHAR(255);
 /
 ALTER TABLE VPX_SN_VDEVICE_FILE_BACKING ADD DELTA_DISK_FORMAT VARCHAR(50);
 /
 UPDATE VPX_SN_VDEVICE_FILE_BACKING T1
  SET DEVICE_BACKING_LUN_UUID = T2.DEVICE_BACKING_LUN_UUID,
      DELTA_DISK_FORMAT = T2.DELTA_DISK_FORMAT
  FROM VPX_SN_VDEVICE_FILE_BACKING_X T2
  WHERE T1.BACKING_ID = T2.BACKING_ID;
 /
 CREATE INDEX VPX_SN_VDEVICE_FILE_BACKING_M2
  ON VPX_SN_VDEVICE_FILE_BACKING(DEVICE_BACKING_LUN_UUID);
 /
 
 
 
 
 
 DROP VIEW IF EXISTS VPXV_ALARMS;
 /
 DROP VIEW IF EXISTS VPX_EVENT;
 /
 DROP VIEW IF EXISTS VPXV_EVENTS;
 /
 DROP VIEW IF EXISTS VPXV_EVENT_ALL;
 /
 DROP VIEW IF EXISTS VPX_EVENT_ARG;
 /
 DROP VIEW IF EXISTS VPXV_EVENT_ARG;
 /
 DROP VIEW IF EXISTS VPXV_TASKS;
 /
 DROP VIEW IF EXISTS VPXV_ENTITY_VMOP_COUNT;
 /
 DROP VIEW IF EXISTS VPXV_SNAPSHOT;
 /
 DROP VIEW IF EXISTS VPXV_TEMPLATES;
 /
 DROP VIEW IF EXISTS VPXV_COMPUTE_RESOURCE_DRS_VM;
 /
 DROP VIEW IF EXISTS VPXV_VMS;
 /
 DROP VIEW IF EXISTS VPXV_COMPUTE_RESOURCE_NETWORK;
 /
 DROP VIEW IF EXISTS VPXV_VM_DATASTORE;
 /
 DROP VIEW IF EXISTS VPXV_COMPUTE_RESOURCE_DAS_VM;
 /
 DROP VIEW IF EXISTS VPXV_CUSTOMIZED_FIELD;
 /
 DROP VIEW IF EXISTS VPXV_VMGROUPS;
 /
 DROP VIEW IF EXISTS VPXV_VM_NETWORK;
 /
 DROP VIEW IF EXISTS VPXV_HOST_DATASTORE;
 /
 DROP VIEW IF EXISTS VPXV_VM_RDM_LUN_INFO;
 /
 DROP VIEW IF EXISTS VPXV_HOST_CPU;
 /
 DROP VIEW IF EXISTS VPXV_FARMGROUPS;
 /
 DROP VIEW IF EXISTS VPXV_HOST_NETWORK;
 /
 DROP VIEW IF EXISTS VPXV_ENTITY_MOID;
 /
 DROP VIEW IF EXISTS VPXV_HOSTS;
 /
 DROP VIEW IF EXISTS VPXV_VM_FIELDS;
 /
 DROP VIEW IF EXISTS VPXV_COMPUTE_RESOURCE;
 /
 DROP VIEW IF EXISTS VPXV_HOST_FIELDS;
 /
 DROP VIEW IF EXISTS VPXV_ENTITY;
 /
 DROP VIEW IF EXISTS VPXV_DATASTORE;
 /
 DROP VIEW IF EXISTS VPXV_DS_LUN_INFO;
 /
 DROP VIEW IF EXISTS VPXV_SN_RDM_LUN_INFO;
 /
 
 ALTER TABLE VPX_SEQUENCE
 	  ALTER COLUMN ID TYPE BIGINT;
 /
 ALTER TABLE VPX_ALARM
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN ENTITY_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_ALARM_EXPRESSION
       ALTER COLUMN ALARM_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_ALARM_EXPR_COMP
       ALTER COLUMN ALARM_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_ALARM_ACTION
       ALTER COLUMN ALARM_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_ALARM_RUNTIME
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN ENTITY_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_ALARM_STATE
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN ENTITY_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_ALARM_REPEAT_ACTION
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN ENTITY_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_EVENT_1
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN STORAGEPOD_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_2
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN STORAGEPOD_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_3
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN STORAGEPOD_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_4
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN STORAGEPOD_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_5
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN STORAGEPOD_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_6
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN STORAGEPOD_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_7
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN STORAGEPOD_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_8
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN STORAGEPOD_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_9
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN STORAGEPOD_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_10
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN STORAGEPOD_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_11
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN STORAGEPOD_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_12
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN STORAGEPOD_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_13
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN STORAGEPOD_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_14
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN STORAGEPOD_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_15
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN STORAGEPOD_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_16
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN STORAGEPOD_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_17
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN STORAGEPOD_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_18
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN STORAGEPOD_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_19
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN STORAGEPOD_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_20
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN STORAGEPOD_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_21
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN STORAGEPOD_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_22
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN STORAGEPOD_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_23
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN STORAGEPOD_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_24
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN STORAGEPOD_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_25
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN STORAGEPOD_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_26
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN STORAGEPOD_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_27
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN STORAGEPOD_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_28
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN STORAGEPOD_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_29
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN STORAGEPOD_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_30
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN STORAGEPOD_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_31
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN STORAGEPOD_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_32
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN STORAGEPOD_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_33
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN STORAGEPOD_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_34
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN STORAGEPOD_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_35
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN STORAGEPOD_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_36
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN STORAGEPOD_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_37
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN STORAGEPOD_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_38
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN STORAGEPOD_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_39
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN STORAGEPOD_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_40
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN STORAGEPOD_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_41
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN STORAGEPOD_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_42
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN STORAGEPOD_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_43
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN STORAGEPOD_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_44
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN STORAGEPOD_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_45
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN STORAGEPOD_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_46
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN STORAGEPOD_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_47
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN STORAGEPOD_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_48
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN STORAGEPOD_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_49
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN STORAGEPOD_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_50
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN STORAGEPOD_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_51
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN STORAGEPOD_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_52
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN STORAGEPOD_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_53
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN STORAGEPOD_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_54
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN STORAGEPOD_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_55
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN STORAGEPOD_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_56
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN STORAGEPOD_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_57
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN STORAGEPOD_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_58
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN STORAGEPOD_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_59
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN STORAGEPOD_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_60
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN STORAGEPOD_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_61
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN STORAGEPOD_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_62
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN STORAGEPOD_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_63
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN STORAGEPOD_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_64
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN STORAGEPOD_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_65
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN STORAGEPOD_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_66
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN STORAGEPOD_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_67
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN STORAGEPOD_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_68
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN STORAGEPOD_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_69
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN STORAGEPOD_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_70
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN STORAGEPOD_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_71
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN STORAGEPOD_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_72
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN STORAGEPOD_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_73
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN STORAGEPOD_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_74
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN STORAGEPOD_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_75
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN STORAGEPOD_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_76
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN STORAGEPOD_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_77
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN STORAGEPOD_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_78
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN STORAGEPOD_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_79
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN STORAGEPOD_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_80
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN STORAGEPOD_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_81
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN STORAGEPOD_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_82
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN STORAGEPOD_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_83
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN STORAGEPOD_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_84
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN STORAGEPOD_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_85
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN STORAGEPOD_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_86
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN STORAGEPOD_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_87
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN STORAGEPOD_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_88
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN STORAGEPOD_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_89
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN STORAGEPOD_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_90
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN STORAGEPOD_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_91
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN STORAGEPOD_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_92
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN STORAGEPOD_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_EVENT_ARG_1
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCEPOOL_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT,
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_ARG_2
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCEPOOL_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT,
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_ARG_3
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCEPOOL_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT,
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_ARG_4
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCEPOOL_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT,
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_ARG_5
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCEPOOL_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT,
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_ARG_6
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCEPOOL_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT,
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_ARG_7
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCEPOOL_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT,
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_ARG_8
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCEPOOL_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT,
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_ARG_9
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCEPOOL_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT,
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_ARG_10
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCEPOOL_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT,
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_ARG_11
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCEPOOL_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT,
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_ARG_12
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCEPOOL_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT,
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_ARG_13
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCEPOOL_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT,
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_ARG_14
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCEPOOL_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT,
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_ARG_15
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCEPOOL_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT,
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_ARG_16
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCEPOOL_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT,
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_ARG_17
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCEPOOL_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT,
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_ARG_18
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCEPOOL_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT,
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_ARG_19
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCEPOOL_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT,
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_ARG_20
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCEPOOL_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT,
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_ARG_21
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCEPOOL_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT,
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_ARG_22
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCEPOOL_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT,
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_ARG_23
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCEPOOL_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT,
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_ARG_24
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCEPOOL_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT,
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_ARG_25
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCEPOOL_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT,
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_ARG_26
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCEPOOL_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT,
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_ARG_27
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCEPOOL_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT,
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_ARG_28
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCEPOOL_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT,
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_ARG_29
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCEPOOL_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT,
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_ARG_30
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCEPOOL_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT,
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_ARG_31
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCEPOOL_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT,
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_ARG_32
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCEPOOL_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT,
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_ARG_33
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCEPOOL_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT,
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_ARG_34
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCEPOOL_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT,
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_ARG_35
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCEPOOL_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT,
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_ARG_36
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCEPOOL_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT,
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_ARG_37
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCEPOOL_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT,
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_ARG_38
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCEPOOL_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT,
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_ARG_39
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCEPOOL_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT,
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_ARG_40
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCEPOOL_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT,
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_ARG_41
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCEPOOL_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT,
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_ARG_42
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCEPOOL_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT,
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_ARG_43
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCEPOOL_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT,
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_ARG_44
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCEPOOL_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT,
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_ARG_45
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCEPOOL_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT,
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_ARG_46
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCEPOOL_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT,
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_ARG_47
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCEPOOL_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT,
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_ARG_48
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCEPOOL_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT,
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_ARG_49
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCEPOOL_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT,
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_ARG_50
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCEPOOL_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT,
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_ARG_51
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCEPOOL_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT,
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_ARG_52
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCEPOOL_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT,
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_ARG_53
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCEPOOL_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT,
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_ARG_54
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCEPOOL_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT,
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_ARG_55
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCEPOOL_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT,
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_ARG_56
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCEPOOL_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT,
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_ARG_57
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCEPOOL_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT,
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_ARG_58
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCEPOOL_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT,
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_ARG_59
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCEPOOL_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT,
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_ARG_60
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCEPOOL_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT,
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_ARG_61
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCEPOOL_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT,
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_ARG_62
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCEPOOL_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT,
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_ARG_63
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCEPOOL_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT,
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_ARG_64
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCEPOOL_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT,
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_ARG_65
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCEPOOL_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT,
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_ARG_66
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCEPOOL_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT,
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_ARG_67
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCEPOOL_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT,
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_ARG_68
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCEPOOL_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT,
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_ARG_69
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCEPOOL_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT,
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_ARG_70
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCEPOOL_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT,
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_ARG_71
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCEPOOL_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT,
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_ARG_72
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCEPOOL_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT,
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_ARG_73
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCEPOOL_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT,
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_ARG_74
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCEPOOL_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT,
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_ARG_75
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCEPOOL_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT,
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_ARG_76
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCEPOOL_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT,
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_ARG_77
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCEPOOL_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT,
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_ARG_78
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCEPOOL_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT,
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_ARG_79
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCEPOOL_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT,
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_ARG_80
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCEPOOL_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT,
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_ARG_81
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCEPOOL_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT,
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_ARG_82
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCEPOOL_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT,
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_ARG_83
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCEPOOL_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT,
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_ARG_84
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCEPOOL_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT,
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_ARG_85
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCEPOOL_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT,
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_ARG_86
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCEPOOL_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT,
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_ARG_87
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCEPOOL_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT,
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_ARG_88
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCEPOOL_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT,
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_ARG_89
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCEPOOL_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT,
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_ARG_90
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCEPOOL_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT,
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_ARG_91
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCEPOOL_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT,
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_EVENT_ARG_92
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCEPOOL_ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT,
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 
 
 ALTER TABLE VPX_SCHEDULEDTASK
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT,
       ALTER COLUMN ENTITY_ID TYPE BIGINT,
       ALTER COLUMN TASK_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_SCHED_SCHEDULER
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 ALTER TABLE VPX_SCHED_ACTION
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_TASK
       ALTER COLUMN TASK_ID TYPE BIGINT,
       ALTER COLUMN ENTITY_ID TYPE BIGINT,
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT,
       ALTER COLUMN COMPUTERESOURCE_ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCEPOOL_ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT,
       ALTER COLUMN ALARM_ID TYPE BIGINT,
       ALTER COLUMN SCHEDULEDTASK_ID TYPE BIGINT,
       ALTER COLUMN PARENT_TASK_ID TYPE BIGINT,
       ALTER COLUMN ROOT_TASK_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_ENTITY
       ALTER COLUMN ID TYPE BIGINT,
       ALTER COLUMN PARENT_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_ALARM_DISABLED_ACTIONS
       ALTER COLUMN ENTITY_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_ACCESS
       ALTER COLUMN ENTITY_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_CONFIG_ISSUE
       ALTER COLUMN ENTITY_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_SNAPSHOT
       ALTER COLUMN ID TYPE BIGINT,
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN PARENT_SNAPSHOT_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_FIELD_VAL
       ALTER COLUMN ENTITY_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_DATACENTER
       ALTER COLUMN ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_VM
       ALTER COLUMN ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN RESOURCE_GROUP_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_OVFENV
       ALTER COLUMN ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_WWN
       ALTER COLUMN ENTITY_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_VM_STATIC_OVERHEAD_MAP
       ALTER COLUMN VM_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_COMPUTE_RESOURCE
       ALTER COLUMN ID TYPE BIGINT,
       ALTER COLUMN RESOURCE_GROUP_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_CLUSTER_IOFILTERS
       ALTER COLUMN CLUSTER_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_DATASTORE
       ALTER COLUMN ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_NETWORK
       ALTER COLUMN ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_IP_POOL
       ALTER COLUMN DATACENTER_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_IP_POOL_ASSOCIATION
       ALTER COLUMN NETWORK_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_NW_ASSIGNMENT
       ALTER COLUMN NETWORK_ID TYPE BIGINT,
       ALTER COLUMN ENTITY_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_DVS
       ALTER COLUMN ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_DVS_COMPATIBLE
       ALTER COLUMN ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_DVS_UPLINK
       ALTER COLUMN ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_DVPORTGROUP
       ALTER COLUMN ID TYPE BIGINT,
       ALTER COLUMN DVS_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_DVHOST
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_DVPORT_SETTING
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN DVPORTGROUP_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_DVPORT
       ALTER COLUMN DVS_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_DVS_NRP
       ALTER COLUMN DVS_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_DVPORT_MEMBERSHIP
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN DVPORTGROUP_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_DVS_SCOPE
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN DVPORTGROUP_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_DVS_VSPAN_SESSION
       ALTER COLUMN DVS_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_DVS_HC_CONFIG
       ALTER COLUMN DVS_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_DVHOST_HC_RESULT
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_DVHOST_HC_VLAN_RESULT
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_DVHOST_HC_MTU_RESULT
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_DVS_IPFIX
       ALTER COLUMN DVS_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_DVS_VSPAN_PORTS
       ALTER COLUMN DVS_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_DVS_PVLAN
       ALTER COLUMN DVS_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_DVPORT_VLAN
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN DVPORTGROUP_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_UPLINK_TEAMING
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN DVPORTGROUP_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_DVS_BLOB
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN DVPORTGROUP_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_DVS_OVERLAY_INSTANCE
       ALTER COLUMN DVS_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_DVS_OPAQUE_DATA
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN DVPORTGROUP_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_DVS_TRAFFIC_FILTER_CONFIG
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN DVPORTGROUP_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_DVS_TRAFFIC_FILTER_PARAM
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN DVPORTGROUP_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_DVS_INFRA_RES_POOL
       ALTER COLUMN DVS_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_DVS_VMVNIC_RES_POOL
       ALTER COLUMN DVS_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_DVS_LAG
       ALTER COLUMN DVS_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_DVS_LAG_VLAN
       ALTER COLUMN DVS_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_HOST
       ALTER COLUMN ID TYPE BIGINT,
       ALTER COLUMN DATACENTER_ID TYPE BIGINT,
       ALTER COLUMN AGENT_VM_DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN AGENT_VM_NETWORK_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_HOST_SYSTEM_ID_INFO
       ALTER COLUMN HOST_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_HOST_X
       ALTER COLUMN HOST_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_HOST_GW_PARAMS
       ALTER COLUMN HOST_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_RESOURCE_POOL
       ALTER COLUMN ID TYPE BIGINT,
       ALTER COLUMN FOLDER_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_DS_ASSIGNMENT
       ALTER COLUMN DS_ID TYPE BIGINT,
       ALTER COLUMN ENTITY_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_HOST_VM_CONFIG_OPTION
       ALTER COLUMN HOST_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_COMPUTE_RESOURCE_DAS_VM
       ALTER COLUMN COMP_RES_ID TYPE BIGINT,
       ALTER COLUMN VM_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_COMPUTE_RESOURCE_ORC_VM
       ALTER COLUMN COMP_RES_ID TYPE BIGINT,
       ALTER COLUMN VM_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_DAS_HB_DATASTORE_SYS
       ALTER COLUMN COMP_RES_ID TYPE BIGINT,
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_COMPUTE_RES_USER_HB_DS
       ALTER COLUMN COMP_RES_ID TYPE BIGINT,
       ALTER COLUMN DS_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_COMPUTE_RESOURCE_DRS_VM
       ALTER COLUMN COMP_RES_ID TYPE BIGINT,
       ALTER COLUMN VM_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_COMPUTE_RESOURCE_DPM_HOST
       ALTER COLUMN COMP_RES_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_HOST_CPU
       ALTER COLUMN HOST_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_HOST_VFLASH
       ALTER COLUMN HOST_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_HOST_CPU_THREAD
       ALTER COLUMN HOST_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_HOST_CPU_CPUID_FEATURE
       ALTER COLUMN HOST_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_HOST_NODE
       ALTER COLUMN HOST_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_GUEST_DISK
       ALTER COLUMN VM_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_NIC
       ALTER COLUMN ENTITY_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_HOST_NODE_CPU
       ALTER COLUMN HOST_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_IP_ADDRESS
       ALTER COLUMN ENTITY_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_HOST_PCI_DEVICE
       ALTER COLUMN HOST_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_HOST_CPUID_FEATURE
       ALTER COLUMN HOST_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_EXT
       ALTER COLUMN SELF_ENTITY_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_COMPUTE_RESOURCE_VSAN_HOST
       ALTER COLUMN COMP_RES_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_HOST_PROFILE
       ALTER COLUMN REF_HOST_ENTITY_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_PROFILE_ANSWER_FILE
       ALTER COLUMN HOST_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_PROFILE_HOST_SPEC
       ALTER COLUMN HOST_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_COMPLIANCE_STATUS
       ALTER COLUMN ENTITY_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_PROFILE_ENTITY_ASSOCIATION
       ALTER COLUMN ENTITY_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_ENTITY_LAST_EVENT
       ALTER COLUMN ENTITY_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_HOST_INTERNAL_CAPABILITY
       ALTER COLUMN HOST_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_COMPUTE_RES_FAILOVER_HOST
       ALTER COLUMN COMP_RES_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_VM_DS_SPACE
       ALTER COLUMN VM_ID TYPE BIGINT,
       ALTER COLUMN DS_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_VM_CONFIG_INFO
       ALTER COLUMN ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_VDEVICE_BACKING_REL
       ALTER COLUMN VM_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_VDEVICE_FILE_BACKING
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN VM_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_VDEVICE_FILE_BACKING_X
       ALTER COLUMN VM_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_VIRTUAL_DISK_IOFILTERS
       ALTER COLUMN VM_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_INT_ARRAY
       ALTER COLUMN MO_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_STRING_ARRAY
       ALTER COLUMN MO_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_TEXT_ARRAY
       ALTER COLUMN MO_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_HOST_CONFIG_INFO
       ALTER COLUMN ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_FILE_SYSTEM_MOUNT_INFO
       ALTER COLUMN ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_SCSI_DISK_PARTITION
       ALTER COLUMN HOST_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_HOST_BUS_ADAPTER
       ALTER COLUMN HOST_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_SCSI_LUN
       ALTER COLUMN HOST_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_PSA_ADAPTER
       ALTER COLUMN HOST_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_PSA_DEVICE
       ALTER COLUMN HOST_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_PSA_TARGET
       ALTER COLUMN HOST_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_PSA_TARGET_TRANSPORT
       ALTER COLUMN HOST_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_PSA_PATH
       ALTER COLUMN HOST_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_MULTIPATHSTATEINFO_PATH
       ALTER COLUMN ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_HOST_TEXT
       ALTER COLUMN ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_VM_FILE_LAYOUT_EX
       ALTER COLUMN VM_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_VM_FLE_DISK_LAYOUT
       ALTER COLUMN VM_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_VM_FLE_DISK_UNIT
       ALTER COLUMN VM_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_VM_FLE_FILE_INFO
       ALTER COLUMN VM_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_VM_FLE_SNAPSHOT_LAYOUT
       ALTER COLUMN VM_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_VM_FLE_SNAPSHOT_DISK
       ALTER COLUMN VM_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_VM_FLE_SNAP_DISK_UNIT
       ALTER COLUMN VM_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_VM_VIRTUAL_DEVICE
       ALTER COLUMN ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_SN_CONFIG_INFO
       ALTER COLUMN ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_SN_VDEVICE_BACKING_REL
       ALTER COLUMN SN_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_SN_VDEVICE_FILE_BACKING
       ALTER COLUMN DATASTORE_ID TYPE BIGINT,
       ALTER COLUMN SNAPSHOT_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_SN_VDEVICE_FILE_BACKING_X
       ALTER COLUMN SN_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_VM_SN_VIRTUAL_DEVICE
       ALTER COLUMN ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_SCSILUN_DESCRIPTOR
       ALTER COLUMN HOST_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_TAG_ENT_ASSOCIATION
       ALTER COLUMN ENTITY_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_ENTITY_VMOP_COUNT
       ALTER COLUMN ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_DVHOST_OUT_OF_SYNC
       ALTER COLUMN DVS_ID TYPE BIGINT,
       ALTER COLUMN HOST_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_VAPP_LINK
       ALTER COLUMN CHILD_ENTITY_ID TYPE BIGINT,
       ALTER COLUMN PARENT_VAPP_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_SDRS_POD_CONFIG
       ALTER COLUMN POD_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_SDRS_STATS_VM
       ALTER COLUMN VM_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_LIC_AUTO_KEYS
       ALTER COLUMN ENTITY_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_HOST_CRYPTO_KEYS
       ALTER COLUMN HOST_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_INFRA_UPD_HA_CLSTR_CFG
       ALTER COLUMN CLUSTER_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_INFRA_UPD_HA_P_H
       ALTER COLUMN HOST_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_INFRA_UPD_HA_CP
       ALTER COLUMN CLUSTER_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_INFRA_UPD_HA_F_C_CFG
       ALTER COLUMN CLUSTER_ID TYPE BIGINT;
 /
 
 ALTER TABLE VPX_INFRA_UPD_HA_F_H_CFG
       ALTER COLUMN HOST_ID TYPE BIGINT;
 /
 
 
 
 
 
 
 
 
 
 DO
 $$
 BEGIN
 IF EXISTS (
     SELECT 1
     FROM   pg_class c
     JOIN   pg_namespace n ON n.oid = c.relnamespace
     WHERE  c.relname = 'VPXI_EVENT_USERNAME'
     AND    n.nspname = 'vc'
     ) THEN
    ALTER INDEX VPXI_EVENT_USERNAME RENAME TO VPXI_EVENT_USERNAME_1;
 END IF;
 END$$;
 /
 
 
 
 
 
 
 ALTER TABLE VPX_TASK SET (autovacuum_vacuum_scale_factor = 0.05);
 /
 ALTER TABLE VPX_TASK SET (toast.autovacuum_vacuum_scale_factor = 0.05);
 /
 ALTER TABLE VPX_TASK SET (autovacuum_analyze_scale_factor = 0.05);
 /
 ALTER TABLE VPX_TASK SET (autovacuum_vacuum_threshold = 25);
 /
 ALTER TABLE VPX_TASK SET (toast.autovacuum_vacuum_threshold = 25);
 /
 ALTER TABLE VPX_TASK SET (autovacuum_analyze_threshold = 25);
 /
 ALTER TABLE VPX_TASK SET (autovacuum_vacuum_cost_delay = 10);
 /
 ALTER TABLE VPX_TASK SET (toast.autovacuum_vacuum_cost_delay = 10);
 /
 ALTER TABLE VPX_TASK SET (autovacuum_vacuum_cost_limit = 1000);
 /
 ALTER TABLE VPX_TASK SET (toast.autovacuum_vacuum_cost_limit = 1000);
 /
 
 ALTER TABLE VPX_ENTITY SET (autovacuum_vacuum_scale_factor = 0.05);
 /
 ALTER TABLE VPX_ENTITY SET (toast.autovacuum_vacuum_scale_factor = 0.05);
 /
 ALTER TABLE VPX_ENTITY SET (autovacuum_analyze_scale_factor = 0.05);
 /
 ALTER TABLE VPX_ENTITY SET (autovacuum_vacuum_threshold = 25);
 /
 ALTER TABLE VPX_ENTITY SET (toast.autovacuum_vacuum_threshold = 25);
 /
 ALTER TABLE VPX_ENTITY SET (autovacuum_analyze_threshold = 25);
 /
 ALTER TABLE VPX_ENTITY SET (autovacuum_vacuum_cost_delay = 10);
 /
 ALTER TABLE VPX_ENTITY SET (toast.autovacuum_vacuum_cost_delay = 10);
 /
 ALTER TABLE VPX_ENTITY SET (autovacuum_vacuum_cost_limit = 1000);
 /
 ALTER TABLE VPX_ENTITY SET (toast.autovacuum_vacuum_cost_limit = 1000);
 /
 
 ALTER TABLE VPX_DVPORT SET (autovacuum_vacuum_scale_factor = 0.05);
 /
 ALTER TABLE VPX_DVPORT SET (toast.autovacuum_vacuum_scale_factor = 0.05);
 /
 ALTER TABLE VPX_DVPORT SET (autovacuum_analyze_scale_factor = 0.05);
 /
 ALTER TABLE VPX_DVPORT SET (autovacuum_vacuum_threshold = 25);
 /
 ALTER TABLE VPX_DVPORT SET (toast.autovacuum_vacuum_threshold = 25);
 /
 ALTER TABLE VPX_DVPORT SET (autovacuum_analyze_threshold = 25);
 /
 ALTER TABLE VPX_DVPORT SET (autovacuum_vacuum_cost_delay = 10);
 /
 ALTER TABLE VPX_DVPORT SET (toast.autovacuum_vacuum_cost_delay = 10);
 /
 ALTER TABLE VPX_DVPORT SET (autovacuum_vacuum_cost_limit = 1000);
 /
 ALTER TABLE VPX_DVPORT SET (toast.autovacuum_vacuum_cost_limit = 1000);
 /
 
 ALTER TABLE VPX_GUEST_DISK SET (autovacuum_vacuum_scale_factor = 0.05);
 /
 ALTER TABLE VPX_GUEST_DISK SET (toast.autovacuum_vacuum_scale_factor = 0.05);
 /
 ALTER TABLE VPX_GUEST_DISK SET (autovacuum_analyze_scale_factor = 0.05);
 /
 ALTER TABLE VPX_GUEST_DISK SET (autovacuum_vacuum_threshold = 25);
 /
 ALTER TABLE VPX_GUEST_DISK SET (toast.autovacuum_vacuum_threshold = 25);
 /
 ALTER TABLE VPX_GUEST_DISK SET (autovacuum_analyze_threshold = 25);
 /
 ALTER TABLE VPX_GUEST_DISK SET (autovacuum_vacuum_cost_delay = 10);
 /
 ALTER TABLE VPX_GUEST_DISK SET (toast.autovacuum_vacuum_cost_delay = 10);
 /
 ALTER TABLE VPX_GUEST_DISK SET (autovacuum_vacuum_cost_limit = 1000);
 /
 ALTER TABLE VPX_GUEST_DISK SET (toast.autovacuum_vacuum_cost_limit = 1000);
 /
 
 ALTER TABLE VPX_NIC SET (autovacuum_vacuum_scale_factor = 0.05);
 /
 ALTER TABLE VPX_NIC SET (toast.autovacuum_vacuum_scale_factor = 0.05);
 /
 ALTER TABLE VPX_NIC SET (autovacuum_analyze_scale_factor = 0.05);
 /
 ALTER TABLE VPX_NIC SET (autovacuum_vacuum_threshold = 25);
 /
 ALTER TABLE VPX_NIC SET (toast.autovacuum_vacuum_threshold = 25);
 /
 ALTER TABLE VPX_NIC SET (autovacuum_analyze_threshold = 25);
 /
 ALTER TABLE VPX_NIC SET (autovacuum_vacuum_cost_delay = 10);
 /
 ALTER TABLE VPX_NIC SET (toast.autovacuum_vacuum_cost_delay = 10);
 /
 ALTER TABLE VPX_NIC SET (autovacuum_vacuum_cost_limit = 1000);
 /
 ALTER TABLE VPX_NIC SET (toast.autovacuum_vacuum_cost_limit = 1000);
 /
 
 ALTER TABLE VPX_IP_ADDRESS SET (autovacuum_vacuum_scale_factor = 0.05);
 /
 ALTER TABLE VPX_IP_ADDRESS SET (toast.autovacuum_vacuum_scale_factor = 0.05);
 /
 ALTER TABLE VPX_IP_ADDRESS SET (autovacuum_analyze_scale_factor = 0.05);
 /
 ALTER TABLE VPX_IP_ADDRESS SET (autovacuum_vacuum_threshold = 25);
 /
 ALTER TABLE VPX_IP_ADDRESS SET (toast.autovacuum_vacuum_threshold = 25);
 /
 ALTER TABLE VPX_IP_ADDRESS SET (autovacuum_analyze_threshold = 25);
 /
 ALTER TABLE VPX_IP_ADDRESS SET (autovacuum_vacuum_cost_delay = 10);
 /
 ALTER TABLE VPX_IP_ADDRESS SET (toast.autovacuum_vacuum_cost_delay = 10);
 /
 ALTER TABLE VPX_IP_ADDRESS SET (autovacuum_vacuum_cost_limit = 1000);
 /
 ALTER TABLE VPX_IP_ADDRESS SET (toast.autovacuum_vacuum_cost_limit = 1000);
 /
 
 ALTER TABLE VPX_VM_TEXT SET (autovacuum_vacuum_scale_factor = 0.05);
 /
 ALTER TABLE VPX_VM_TEXT SET (toast.autovacuum_vacuum_scale_factor = 0.05);
 /
 ALTER TABLE VPX_VM_TEXT SET (autovacuum_analyze_scale_factor = 0.05);
 /
 ALTER TABLE VPX_VM_TEXT SET (autovacuum_vacuum_threshold = 25);
 /
 ALTER TABLE VPX_VM_TEXT SET (toast.autovacuum_vacuum_threshold = 25);
 /
 ALTER TABLE VPX_VM_TEXT SET (autovacuum_analyze_threshold = 25);
 /
 ALTER TABLE VPX_VM_TEXT SET (autovacuum_vacuum_cost_delay = 10);
 /
 ALTER TABLE VPX_VM_TEXT SET (toast.autovacuum_vacuum_cost_delay = 10);
 /
 ALTER TABLE VPX_VM_TEXT SET (autovacuum_vacuum_cost_limit = 1000);
 /
 ALTER TABLE VPX_VM_TEXT SET (toast.autovacuum_vacuum_cost_limit = 1000);
 /
 
 ALTER TABLE VPX_VDEVICE_BACKING_REL SET (autovacuum_vacuum_scale_factor = 0.05);
 /
 ALTER TABLE VPX_VDEVICE_BACKING_REL SET (toast.autovacuum_vacuum_scale_factor = 0.05);
 /
 ALTER TABLE VPX_VDEVICE_BACKING_REL SET (autovacuum_analyze_scale_factor = 0.05);
 /
 ALTER TABLE VPX_VDEVICE_BACKING_REL SET (autovacuum_vacuum_threshold = 25);
 /
 ALTER TABLE VPX_VDEVICE_BACKING_REL SET (toast.autovacuum_vacuum_threshold = 25);
 /
 ALTER TABLE VPX_VDEVICE_BACKING_REL SET (autovacuum_analyze_threshold = 25);
 /
 ALTER TABLE VPX_VDEVICE_BACKING_REL SET (autovacuum_vacuum_cost_delay = 10);
 /
 ALTER TABLE VPX_VDEVICE_BACKING_REL SET (toast.autovacuum_vacuum_cost_delay = 10);
 /
 ALTER TABLE VPX_VDEVICE_BACKING_REL SET (autovacuum_vacuum_cost_limit = 1000);
 /
 ALTER TABLE VPX_VDEVICE_BACKING_REL SET (toast.autovacuum_vacuum_cost_limit = 1000);
 /
 
 ALTER TABLE VPX_VDEVICE_FILE_BACKING SET (autovacuum_vacuum_scale_factor = 0.05);
 /
 ALTER TABLE VPX_VDEVICE_FILE_BACKING SET (toast.autovacuum_vacuum_scale_factor = 0.05);
 /
 ALTER TABLE VPX_VDEVICE_FILE_BACKING SET (autovacuum_analyze_scale_factor = 0.05);
 /
 ALTER TABLE VPX_VDEVICE_FILE_BACKING SET (autovacuum_vacuum_threshold = 25);
 /
 ALTER TABLE VPX_VDEVICE_FILE_BACKING SET (toast.autovacuum_vacuum_threshold = 25);
 /
 ALTER TABLE VPX_VDEVICE_FILE_BACKING SET (autovacuum_analyze_threshold = 25);
 /
 ALTER TABLE VPX_VDEVICE_FILE_BACKING SET (autovacuum_vacuum_cost_delay = 10);
 /
 ALTER TABLE VPX_VDEVICE_FILE_BACKING SET (toast.autovacuum_vacuum_cost_delay = 10);
 /
 ALTER TABLE VPX_VDEVICE_FILE_BACKING SET (autovacuum_vacuum_cost_limit = 1000);
 /
 ALTER TABLE VPX_VDEVICE_FILE_BACKING SET (toast.autovacuum_vacuum_cost_limit = 1000);
 /
 
 
 
 
 
 
 
 
 CREATE TABLE VPX_HOST_TPM_ATTESTATION (
    HOST_ID               BIGINT    NOT NULL,
    ATTESTATION_TIME      TIMESTAMP NOT NULL,
    ATTESTATION_STATUS    INTEGER   NOT NULL,
    ATTESTATION_MESSAGE   TEXT      NULL,
    constraint PK_HOST_TPM_ATTESTATION primary key (HOST_ID),
    constraint FK_HOST_TPM_ATTESTATION_HOST foreign key(HOST_ID)
               references VPX_HOST (ID) on delete cascade
 )
 ;
 /
 
 
 
 
 ALTER TABLE VPX_DATASTORE ADD IORM_STATS_AGGR_DISABLED NUMERIC(1) DEFAULT 0;
 /
 
 
 
 
 DO $$
 DECLARE l_sn_vdevice_backing_seq int;
 DECLARE sql_stmt VARCHAR;
 
 BEGIN
    SELECT COALESCE(MAX(backing_id), 0)
       INTO l_sn_vdevice_backing_seq
    FROM VPX_SN_VDEVICE_BACKING_REL;
 
    l_sn_vdevice_backing_seq = l_sn_vdevice_backing_seq + 50;
    sql_stmt = 'ALTER SEQUENCE VPX_SN_VDEVICE_BACKING_REL_SEQ RESTART WITH '
          || l_sn_vdevice_backing_seq || ';';
    EXECUTE sql_stmt;
 
 END$$;
 /
 
 
 
 
 
 CREATE TABLE VPX_CP_POLICY(
    POLICY_ID      INTEGER         NOT NULL,
    POLICY_UUID    CHAR(36)        NOT NULL,
    POLICY_INFO    TEXT            NOT NULL,
    CONSTRAINT PK_VPX_CP_POLICY    PRIMARY KEY (POLICY_ID)
 )
 ;
 /
 
 CREATE SEQUENCE VPX_CP_POLICY_SEQ INCREMENT BY 10;
 /
 
 
 
 
 
 
 ALTER TABLE VPX_VDEVICE_FILE_BACKING ADD SECTOR_FORMAT VARCHAR(50) DEFAULT 'native_512';
 /
 ALTER TABLE VPX_SN_VDEVICE_FILE_BACKING ADD SECTOR_FORMAT VARCHAR(50) DEFAULT 'native_512';
 /
 
 
 
 
 DROP TABLE VPX_VCHA_REPL_CHECK;
 /
 
 SELECT force_checkpoint();
 /
 
 
 
 
 ALTER TABLE VPX_DVS_VSPAN_SESSION ADD VSPAN_NETSTACK VARCHAR(20) null;
 /
 
 
 
 
 ALTER TABLE VPX_DVPORT_SETTING ADD MAC_MGMT_OBJECT_FLG NUMERIC(1) null;
 /
 ALTER TABLE VPX_DVPORT_SETTING ADD MAC_MGMT_ALLOW_PROMISCUOUS NUMERIC(1) null;
 /
 ALTER TABLE VPX_DVPORT_SETTING ADD MAC_MGMT_FORGED_TRANSMITS NUMERIC(1) null;
 /
 ALTER TABLE VPX_DVPORT_SETTING ADD MAC_MGMT_MAC_CHANGES NUMERIC(1) null;
 /
 ALTER TABLE VPX_DVPORT_SETTING ADD MAC_LEARNING_OBJECT_FLG NUMERIC(1) null;
 /
 ALTER TABLE VPX_DVPORT_SETTING ADD MAC_LEARNING_ENABLED NUMERIC(1) null;
 /
 ALTER TABLE VPX_DVPORT_SETTING ADD ALLOW_UNICAST_FLOODING NUMERIC(1) null;
 /
 ALTER TABLE VPX_DVPORT_SETTING ADD MAC_LEARNING_LIMIT int null;
 /
 ALTER TABLE VPX_DVPORT_SETTING ADD MAC_LEARNING_LIMIT_POLICY VARCHAR(50) null;
 /
 
 
 
 
 ALTER TABLE VPX_IP_ADDRESS DROP CONSTRAINT PK_VPX_IP_ADDRESS;
 /
 ALTER TABLE VPX_IP_ADDRESS DROP COLUMN SURR_KEY;
 /
 CREATE INDEX IX_VPX_IP_ADDRESS ON VPX_IP_ADDRESS(ENTITY_ID, DEVICE_ID);
 /
