DROP TABLE IF EXISTS MGRD_EXP_TABLES_COLUMNS;
 /
 
 CREATE TABLE MGRD_EXP_TABLES_COLUMNS (
    TABLE_NAME VARCHAR(50),
    COLUMN_NAME VARCHAR(50),
    TYPE CHAR(1),
    DATA_TYPE VARCHAR(50),
    DATA_SIZE INT,
    IS_NULLABLE VARCHAR(5),
    COLUMN_DEFAULT VARCHAR(100)
 );
 /
 
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ACCESS','ENTITY_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ACCESS','FLAG','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ACCESS','ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ACCESS','PRINCIPAL','T','character varying',300,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ACCESS','ROLE_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ACCESS','SURR_KEY','T','integer',32,'NO','nextval(''vpx_access_surr_key_seq''::regclass)');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ALARM','ACTION_FREQUENCY','T','numeric',10,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ALARM','ALARM_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ALARM','ALARM_METADATA','T','character varying',2000,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ALARM','CREATION_EVENT_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ALARM','DESCRIPTION','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ALARM','ENABLED','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ALARM','ENTITY_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ALARM','ENTITY_TYPE','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ALARM','LASTMODIFIEDTIME','T','timestamp without time zone',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ALARM','LASTMODIFIEDUSER','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ALARM','NAME','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ALARM','SETTING_DATA','T','text',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ALARM','SYSTEM_NAME','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ALARM','TRIGGER_ONLY','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ALARM_ACTION','ACTION_DATA','T','text',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ALARM_ACTION','ACTION_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ALARM_ACTION','ACTION_TYPE','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ALARM_ACTION','ALARM_ACTION_TYPE','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ALARM_ACTION','ALARM_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ALARM_ACTION','GREEN2YELLOW','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ALARM_ACTION','GREEN2YELLOW_REPEAT_FLG','T','numeric',1,'NO','0');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ALARM_ACTION','PARENT_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ALARM_ACTION','RED2YELLOW','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ALARM_ACTION','RED2YELLOW_REPEAT_FLG','T','numeric',1,'NO','0');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ALARM_ACTION','YELLOW2GREEN','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ALARM_ACTION','YELLOW2GREEN_REPEAT_FLG','T','numeric',1,'NO','0');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ALARM_ACTION','YELLOW2RED','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ALARM_ACTION','YELLOW2RED_REPEAT_FLG','T','numeric',1,'NO','0');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ALARM_DISABLED_ACTIONS','ENTITY_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ALARM_DISABLED_ACTIONS','ENTITY_TYPE','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ALARM_EXPR_COMP','ALARM_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ALARM_EXPR_COMP','ATTRIBUTE_NAME','T','character varying',255,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ALARM_EXPR_COMP','ATTRIBUTE_VALUE','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ALARM_EXPR_COMP','EXPRESSION_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ALARM_EXPR_COMP','OPERATOR_TYPE','T','character varying',20,'NO','''equals''::character varying');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ALARM_EXPR_COMP','SURR_KEY','T','integer',32,'NO','nextval(''vpx_alarm_expr_comp_surr_key_seq''::regclass)');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ALARM_EXPRESSION','ALARM_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ALARM_EXPRESSION','EXPRESSION_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ALARM_EXPRESSION','EXPRESSION_TYPE','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ALARM_EXPRESSION','NEW_STATUS','T','character varying',10,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ALARM_EXPRESSION','OBJECT_PATH','T','character varying',1000,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ALARM_EXPRESSION','OBJECT_TYPE','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ALARM_EXPRESSION','OPERATOR','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ALARM_EXPRESSION','PARENT_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ALARM_EXPRESSION','RED','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ALARM_EXPRESSION','RED_INTERVAL','T','numeric',5,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ALARM_EXPRESSION','YELLOW','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ALARM_EXPRESSION','YELLOW_INTERVAL','T','numeric',5,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ALARM_REPEAT_ACTION','ALARM_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ALARM_REPEAT_ACTION','DECL_SUMMARY','T','text',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ALARM_REPEAT_ACTION','ENTITY_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ALARM_REPEAT_ACTION','ENTITY_TYPE','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ALARM_REPEAT_ACTION','EVENT_DESC','T','text',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ALARM_REPEAT_ACTION','EVENT_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ALARM_REPEAT_ACTION','NEW_STATUS','T','character varying',50,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ALARM_REPEAT_ACTION','OLD_STATUS','T','character varying',50,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ALARM_REPEAT_ACTION','TRIG_SUMMARY','T','text',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ALARM_RUNTIME','ALARM_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ALARM_RUNTIME','CREATED_TIME','T','timestamp without time zone',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ALARM_RUNTIME','ENTITY_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ALARM_RUNTIME','ENTITY_TYPE','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ALARM_RUNTIME','EVENT_KEY','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ALARM_RUNTIME','EXPRESSION_NAME','T','character varying',440,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ALARM_RUNTIME','METRIC_VALUE','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ALARM_RUNTIME','STATE_VALUE','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ALARM_RUNTIME','STATUS_VALUE','T','character varying',50,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ALARM_STATE','ACK_TIME','T','timestamp without time zone',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ALARM_STATE','ACK_USER','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ALARM_STATE','ALARM_ACKNOWLEDGED','T','numeric',1,'NO','0');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ALARM_STATE','ALARM_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ALARM_STATE','ALARM_OVERRIDEN','T','numeric',1,'NO','0');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ALARM_STATE','ENTITY_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ALARM_STATE','OVERRIDE_TIME','T','timestamp without time zone',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ALARM_STATE','OVERRIDE_USER','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ALARM_STATE','REPEAT_TRIGGER','T','numeric',1,'NO','0');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_BINARY_DATA','BIN_DATA','T','bytea',-1,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_BINARY_DATA','CHANGE_ID','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_BINARY_DATA','CREATED_TIME','T','timestamp with time zone',-1,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_BINARY_DATA','DATA_TYPE','T','character varying',255,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_BINARY_DATA','ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_CHANGE_TAG','CHANGE_TAG_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_CHANGE_TAG','CHANGE_TAG_VAL','T','character varying',255,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_CLUSTER_IOFILTERS','AGENCY_REF','T','character varying',128,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_CLUSTER_IOFILTERS','CLUSTER_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_CLUSTER_IOFILTERS','OP_TYPE','T','character varying',128,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_COMPLIANCE_STATUS','COMPLIANCE_STATUS_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_COMPLIANCE_STATUS','CREATED_TIME','T','timestamp without time zone',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_COMPLIANCE_STATUS','ENTITY_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_COMPLIANCE_STATUS','FAILURE_INFO','T','text',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_COMPLIANCE_STATUS','PROFILE_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_COMPLIANCE_STATUS','STATUS_CD','T','numeric',3,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_COMPUTE_RES_FAILOVER_HOST','COMP_RES_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_COMPUTE_RES_FAILOVER_HOST','HOST_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_COMPUTE_RES_USER_HB_DS','COMP_RES_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_COMPUTE_RES_USER_HB_DS','DS_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_COMPUTE_RESOURCE','ALLOW_SYS_UPDATE_HB_DS','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_COMPUTE_RESOURCE','CLUSTER_CONFIG_VERSION','T','numeric',22,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_COMPUTE_RESOURCE','CLUSTER_STATE','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_COMPUTE_RESOURCE','DAS_ENABLED','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_COMPUTE_RESOURCE','DAS_FAULT_DOMAIN_ID','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_COMPUTE_RESOURCE','DAS_HOST_MONITORING','T','numeric',1,'YES','1');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_COMPUTE_RESOURCE','DAS_HOSTLIST_VERSION','T','numeric',22,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_COMPUTE_RESOURCE','DAS_METROCLUSTER_ENABLED','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_COMPUTE_RESOURCE','DAS_OPTIONS','T','text',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_COMPUTE_RESOURCE','DAS_VM_COMP_PROTECTING','T','character varying',30,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_COMPUTE_RESOURCE','DAS_VM_METADATA_VERSION','T','numeric',22,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_COMPUTE_RESOURCE','DAS_VM_MONITORING','T','integer',32,'YES','0');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_COMPUTE_RESOURCE','DEFAULT_DAS_PRIORITY','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_COMPUTE_RESOURCE','DEFAULT_HOST_BEHAVIOR','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_COMPUTE_RESOURCE','DEFAULT_HW_VERSION','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_COMPUTE_RESOURCE','DEFAULT_VM_BEHAVIOR','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_COMPUTE_RESOURCE','DPM_ENABLED_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_COMPUTE_RESOURCE','DPM_OPTIONS','T','text',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_COMPUTE_RESOURCE','DRS_ENABLED','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_COMPUTE_RESOURCE','DRS_OPTIONS','T','text',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_COMPUTE_RESOURCE','DRS_VM_OVERRIDES_ENABLED_FLG','T','numeric',1,'NO','1');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_COMPUTE_RESOURCE','EVC_MODE','T','character varying',30,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_COMPUTE_RESOURCE','FAILOVER_CPU_RESOURCES','T','numeric',3,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_COMPUTE_RESOURCE','FAILOVER_LEVEL','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_COMPUTE_RESOURCE','FAILOVER_MEM_RESOURCES','T','numeric',3,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_COMPUTE_RESOURCE','GROUPS_INFO','T','text',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_COMPUTE_RESOURCE','HOST_POWER_ACTION_RATE','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_COMPUTE_RESOURCE','ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_COMPUTE_RESOURCE','NUM_REQUIRED_AGENT_VMS','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_COMPUTE_RESOURCE','POWER_OFF_ON_ISOLATION','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_COMPUTE_RESOURCE','RESOURCE_GROUP_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_COMPUTE_RESOURCE','RESOURCE_TYPE','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_COMPUTE_RESOURCE','RULES_INFO','T','text',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_COMPUTE_RESOURCE','SLOT_POLICY','T','text',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_COMPUTE_RESOURCE','SPBM_ENABLED','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_COMPUTE_RESOURCE','STRICT_ADMISSION_CONTROL','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_COMPUTE_RESOURCE','SUMMARY','T','text',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_COMPUTE_RESOURCE','VM_SWAP_PLACEMENT','T','integer',32,'NO','1');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_COMPUTE_RESOURCE','VMCP_APD_RESET','T','character varying',30,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_COMPUTE_RESOURCE','VMCP_APD_TERMINATE','T','character varying',30,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_COMPUTE_RESOURCE','VMCP_APD_TERMINATE_DELAY','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_COMPUTE_RESOURCE','VMCP_PDL_TERMINATE','T','character varying',30,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_COMPUTE_RESOURCE','VMHEALTH_FAILURE_INTERVAL','T','integer',32,'NO','30');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_COMPUTE_RESOURCE','VMHEALTH_MAX_FAILURE_WINDOW','T','integer',32,'NO','(-1)');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_COMPUTE_RESOURCE','VMHEALTH_MAX_FAILURES','T','integer',32,'NO','3');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_COMPUTE_RESOURCE','VMHEALTH_MIN_UPTIME','T','integer',32,'NO','120');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_COMPUTE_RESOURCE','VMHEALTH_VM_MONITORING','T','integer',32,'NO','0');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_COMPUTE_RESOURCE','VMOTION_RATE','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_COMPUTE_RESOURCE','VSAN_AUTO_CLAIM_STORAGE','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_COMPUTE_RESOURCE','VSAN_CHECKSUM_ENABLED','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_COMPUTE_RESOURCE','VSAN_ENABLED','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_COMPUTE_RESOURCE','VSAN_UUID','T','character varying',36,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_COMPUTE_RESOURCE_DAS_VM','COMP_RES_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_COMPUTE_RESOURCE_DAS_VM','NUM_FAILURE','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_COMPUTE_RESOURCE_DAS_VM','POWER_OFF_ON_ISOLATION','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_COMPUTE_RESOURCE_DAS_VM','PRIORITY','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_COMPUTE_RESOURCE_DAS_VM','RETRY_PERIOD_SEC','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_COMPUTE_RESOURCE_DAS_VM','VM_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_COMPUTE_RESOURCE_DAS_VM','VMCP_APD_RESET','T','character varying',30,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_COMPUTE_RESOURCE_DAS_VM','VMCP_APD_TERMINATE','T','character varying',30,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_COMPUTE_RESOURCE_DAS_VM','VMCP_APD_TERMINATE_DELAY','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_COMPUTE_RESOURCE_DAS_VM','VMCP_PDL_TERMINATE','T','character varying',30,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_COMPUTE_RESOURCE_DAS_VM','VMHEALTH_FAILURE_INTERVAL','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_COMPUTE_RESOURCE_DAS_VM','VMHEALTH_MAX_FAILURE_WINDOW','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_COMPUTE_RESOURCE_DAS_VM','VMHEALTH_MAX_FAILURES','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_COMPUTE_RESOURCE_DAS_VM','VMHEALTH_MIN_UPTIME','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_COMPUTE_RESOURCE_DAS_VM','VMHEALTH_VM_MONITORING','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_COMPUTE_RESOURCE_DPM_HOST','COMP_RES_ID','T','integer',32,'NO',null);
 /
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_COMPUTE_RESOURCE_DPM_HOST','DPM_ENABLED_OVERRIDE_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_COMPUTE_RESOURCE_DPM_HOST','HOST_BEHAVIOR_OVERRIDE','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_COMPUTE_RESOURCE_DPM_HOST','HOST_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_COMPUTE_RESOURCE_DRS_VM','BEHAVIOR','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_COMPUTE_RESOURCE_DRS_VM','COMP_RES_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_COMPUTE_RESOURCE_DRS_VM','ENABLED','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_COMPUTE_RESOURCE_DRS_VM','VM_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_COMPUTE_RESOURCE_VSAN_HOST','AUTOCLAIM_STORAGE','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_COMPUTE_RESOURCE_VSAN_HOST','CHECKSUM_ENABLED','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_COMPUTE_RESOURCE_VSAN_HOST','CLUSTER_UUID','T','character varying',36,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_COMPUTE_RESOURCE_VSAN_HOST','COMP_RES_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_COMPUTE_RESOURCE_VSAN_HOST','ENABLED','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_COMPUTE_RESOURCE_VSAN_HOST','FAULT_DOMAIN','T','character varying',256,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_COMPUTE_RESOURCE_VSAN_HOST','HOST_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_COMPUTE_RESOURCE_VSAN_HOST','NODE_UUID','T','character varying',36,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_CONFIG_ISSUE','CFG_ISSUE_TYPE','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_CONFIG_ISSUE','ENTITY_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_CONFIG_ISSUE','EVENT_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_CUSTOMIZATION_SPEC','BODY','T','text',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_CUSTOMIZATION_SPEC','CHANGE_VERSION','T','character varying',255,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_CUSTOMIZATION_SPEC','DESCRIPTION','T','text',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_CUSTOMIZATION_SPEC','LAST_UPDATE_TIME','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_CUSTOMIZATION_SPEC','NAME','T','character varying',255,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_CUSTOMIZATION_SPEC','TYPE','T','character varying',255,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DAS_HB_DATASTORE_SYS','COMP_RES_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DAS_HB_DATASTORE_SYS','DATASTORE_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DAS_HB_DATASTORE_SYS','HOST_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DATACENTER','DEFAULT_HW_VERSION','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DATACENTER','ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DATASTORE','CAPABILITY','T','text',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DATASTORE','CAPACITY','T','character varying',21,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DATASTORE','DATACENTER_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DATASTORE','FREE_SPACE','T','character varying',21,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DATASTORE','ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DATASTORE','INFO','T','text',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DATASTORE','IORM_CONGESTION_THRESH_MODE','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DATASTORE','IORM_CONGESTION_THRESHOLD','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DATASTORE','IORM_ENABLED','T','numeric',1,'YES','0');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DATASTORE','IORM_PERCENT_OF_PEAK_THRP','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DATASTORE','IORM_STATS_ENABLED','T','numeric',1,'YES','0');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DATASTORE','MAINTENANCE_MODE','T','integer',32,'NO','0');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DATASTORE','NAME','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DATASTORE','STORAGE_URL','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DATASTORE','THIN_PROV_SPACE_FLAG','T','numeric',1,'NO','0');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DATASTORE','TYPE','T','character varying',128,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DATASTORE_INFO','ARRAY_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DATASTORE_INFO','BLOCKSIZE_MB','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DATASTORE_INFO','DRS_UNFAIR_THRESHOLD','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DATASTORE_INFO','FORCEMOUNT_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DATASTORE_INFO','FORCEMOUNT_PERSIST_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DATASTORE_INFO','FREE_SPACE','T','character varying',21,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DATASTORE_INFO','ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DATASTORE_INFO','MAJOR_VERSION','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DATASTORE_INFO','MAX_FILE_SIZE','T','character varying',21,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DATASTORE_INFO','MAX_MEMORY_FILE_SIZE','T','numeric',22,'NO','70368744177664::bigint');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DATASTORE_INFO','MAX_PHYSICAL_RDM_FILE_SIZE','T','numeric',22,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DATASTORE_INFO','MAX_VIRTUAL_RDM_FILE_SIZE','T','numeric',22,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DATASTORE_INFO','NAME','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DATASTORE_INFO','PATH','T','character varying',512,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DATASTORE_INFO','REMOTE_HOST','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DATASTORE_INFO','REMOTE_PATH','T','character varying',512,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DATASTORE_INFO','SECURITY_TYPE','T','character varying',512,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DATASTORE_INFO','TIMESTAMP','T','timestamp without time zone',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DATASTORE_INFO','URL','T','character varying',440,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DATASTORE_INFO','USER_NAME','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DATASTORE_INFO','VMFS_CAPACITY','T','numeric',38,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DATASTORE_INFO','VMFS_MAX_BLOCKS','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DATASTORE_INFO','VMFS_NAME','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DATASTORE_INFO','VMFS_SSD_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DATASTORE_INFO','VMFS_TYPE','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DATASTORE_INFO','VMFS_UPGRADEABLE','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DATASTORE_INFO','VMFS_UUID','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DATASTORE_INFO','VMFS_VERSION','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DATASTORE_INFO','VPX_TYPE','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DATASTORE_INFO','VVOL_UUID','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DBM_COUNTER_METADATA','COUNTER_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DBM_COUNTER_METADATA','DESCRIPTION','T','character varying',1000,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DBM_COUNTER_METADATA','KEEP_DAYS','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DBM_COUNTER_METADATA','NAME','T','character varying',100,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DBM_COUNTER_METADATA','OBJECT_NAME','T','character varying',100,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DBM_COUNTER_METADATA','RANGE_MAX','T','numeric',22,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DBM_COUNTER_METADATA','RANGE_MIN','T','numeric',22,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DBM_COUNTER_METADATA','RANGE_TYPE','T','character varying',30,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DBM_COUNTER_METADATA','SOLUTION','T','character varying',1000,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DBM_COUNTER_METADATA','SQL_STATEMENT','T','character varying',4000,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DBM_COUNTER_METADATA','UNIT','T','character varying',30,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DBM_COUNTER_VALUE','COUNTER_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DBM_COUNTER_VALUE','COUNTER_VALUE','T','numeric',22,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DBM_COUNTER_VALUE','SAMPLE_TIME','T','timestamp without time zone',-1,'NO','now()');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DEVICE','DEVICE_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DEVICE','DEVICE_NAME','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DISABLED_METHODS','ENTITY_MO_ID_VAL','T','character varying',255,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DISABLED_METHODS','METHOD_NAME','T','character varying',50,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DISABLED_METHODS','REASON_ID_VAL','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DISABLED_METHODS','SOURCE_ID_VAL','T','character varying',50,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DISTR_VPORT_BACKING','BACKING_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DISTR_VPORT_BACKING','HARD_DEV_BAC_PO_CONNE_COOKIE','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DISTR_VPORT_BACKING','HARD_DEV_BAC_PO_PORTGROUP_KEY','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DISTR_VPORT_BACKING','HARD_DEV_BAC_PORT_SWITCH_UUID','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DISTR_VPORT_BACKING','HARD_DEV_BACKING_PORT_PORT_KEY','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DISTR_VPORT_BACKING','UPDATE_KEY','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DISTR_VPORT_BACKING','VM_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DS_ASSIGNMENT','ACCESSIBLE','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DS_ASSIGNMENT','DS_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DS_ASSIGNMENT','ENTITY_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DS_ASSIGNMENT','MOUNT_ID','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DS_ASSIGNMENT','MOUNT_MODE','T','character varying',21,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DS_ASSIGNMENT','MOUNT_PATH','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DS_ASSIGNMENT','MOUNTED','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DUAL','DUMMY','T','character',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVHOST','CURRENT_MAX_PORT','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVHOST','DVS_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVHOST','HAS_SHADOW_PORTS','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVHOST','HOST_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVHOST','MAX_PORT','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVHOST','PRODUCT_BUILD','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVHOST','PRODUCT_NAME','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVHOST','PRODUCT_VENDOR','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVHOST','PRODUCT_VERSION','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVHOST','STATUS','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVHOST','STATUS_DETAIL','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVHOST','VSWITCH_KEY','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVHOST_HC_MTU_RESULT','DVS_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVHOST_HC_MTU_RESULT','HOST_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVHOST_HC_MTU_RESULT','SUPPORTED_FLG','T','numeric',1,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVHOST_HC_MTU_RESULT','SURR_KEY','T','integer',32,'NO','nextval(''vpx_dvhost_hc_mtu_result_surr_key_seq''::regclass)');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVHOST_HC_MTU_RESULT','UPLINK_PORT_KEY','T','character varying',50,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVHOST_HC_MTU_RESULT','VLAN_ID_END','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVHOST_HC_MTU_RESULT','VLAN_ID_START','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVHOST_HC_RESULT','DVS_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVHOST_HC_RESULT','HEALTHCHECK_TYPE','T','character varying',255,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVHOST_HC_RESULT','HOST_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVHOST_HC_RESULT','PNIC_MTU_MATCH_STATUS','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVHOST_HC_RESULT','SUMMARY','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVHOST_HC_RESULT','SURR_KEY','T','integer',32,'NO','nextval(''vpx_dvhost_hc_result_surr_key_seq''::regclass)');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVHOST_HC_RESULT','TEAMING_MATCH_STATUS','T','character varying',50,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVHOST_HC_RESULT','UPLINK_PORT_KEY','T','character varying',50,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVHOST_HC_VLAN_RESULT','DVS_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVHOST_HC_VLAN_RESULT','HOST_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVHOST_HC_VLAN_RESULT','SURR_KEY','T','integer',32,'NO','nextval(''vpx_dvhost_hc_vlan_result_surr_key_seq''::regclass)');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVHOST_HC_VLAN_RESULT','TRUNKED_FLG','T','numeric',1,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVHOST_HC_VLAN_RESULT','UPLINK_PORT_KEY','T','character varying',50,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVHOST_HC_VLAN_RESULT','VLAN_ID_END','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVHOST_HC_VLAN_RESULT','VLAN_ID_START','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVHOST_OUT_OF_SYNC','DVS_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVHOST_OUT_OF_SYNC','HOST_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVHOST_OUT_OF_SYNC','PROPERTY_NAME','T','character varying',255,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT','CONFIG_VERSION','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT','CONFLICT_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT','CONFLICT_PORT_KEY','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT','CONNECTEE','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT','CONNECTEE_ADDRESS','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT','CONNECTEE_NIC_KEY','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT','CONNECTEE_TYPE','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT','CONNECTION_COOKIE','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT','DESCRIPTION','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT','DVPORT_KEY','T','character varying',50,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT','DVS_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT','HOST_LOCAL_PORT_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT','LAST_CONNECTEE','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT','LAST_STATUS_CHANGE','T','timestamp without time zone',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT','LINK_BLOCKED','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT','LINK_PEER','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT','LINK_UP','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT','MAC_ADDRESS','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT','MTU','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT','NAME','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT','NPT_ACTIVE','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT','NPT_INACTIVE_MISC','T','character varying',255,'YES',null);
 /
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT','NPT_INACTIVE_NET','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT','NPT_INACTIVE_OTHER','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT','PERSISTENCE_LOCATION','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT','POWERING_ON_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT','PROXY_HOST','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT','REPUSH_NEEDED_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT','RESERVED_TIME','T','character varying',50,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT','STATS_BYTE_IN_BROADCAST','T','character varying',50,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT','STATS_BYTE_IN_MULTICAST','T','character varying',50,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT','STATS_BYTE_IN_UNICAST','T','character varying',50,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT','STATS_BYTE_OUT_BROADCAST','T','character varying',50,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT','STATS_BYTE_OUT_MULTICAST','T','character varying',50,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT','STATS_BYTE_OUT_UNICAST','T','character varying',50,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT','STATS_PACKET_IN_BROADCAST','T','character varying',50,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT','STATS_PACKET_IN_DROPPED','T','character varying',50,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT','STATS_PACKET_IN_EXCEPTION','T','character varying',50,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT','STATS_PACKET_IN_MULTICAST','T','character varying',50,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT','STATS_PACKET_IN_UNICAST','T','character varying',50,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT','STATS_PACKET_OUT_BROADCAST','T','character varying',50,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT','STATS_PACKET_OUT_DROPPED','T','character varying',50,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT','STATS_PACKET_OUT_EXCEPTION','T','character varying',50,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT','STATS_PACKET_OUT_MULTICAST','T','character varying',50,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT','STATS_PACKET_OUT_UNICAST','T','character varying',50,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT','STATUS_DETAIL','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT','TRUNK_MODE_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT_MEMBERSHIP','DVPORT_KEY','T','character varying',50,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT_MEMBERSHIP','DVPORTGROUP_ID','T','integer',32,'NO','0');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT_MEMBERSHIP','DVS_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT_MEMBERSHIP','HOST_ID','T','integer',32,'NO','0');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT_MEMBERSHIP','LAG_KEY','T','character varying',50,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT_SETTING','ALLOW_PROMISCUOUS','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT_SETTING','BLOCKED_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT_SETTING','CRITERIA_OBJECT_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT_SETTING','DVPORT_KEY','T','character varying',50,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT_SETTING','DVPORTGROUP_ID','T','integer',32,'NO','0');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT_SETTING','DVS_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT_SETTING','FORGED_TRANSMITS','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT_SETTING','IN_SHAPING_AVG_BANDWIDTH','T','character varying',50,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT_SETTING','IN_SHAPING_BURST_SIZE','T','character varying',50,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT_SETTING','IN_SHAPING_ENABLED','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT_SETTING','IN_SHAPING_OBJECT_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT_SETTING','IN_SHAPING_PEAK_BANDWIDTH','T','character varying',50,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT_SETTING','IPFIX_ENABLED','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT_SETTING','IPFIX_OBJECT_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT_SETTING','LACP_ENABLE','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT_SETTING','LACP_MODE','T','character varying',50,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT_SETTING','MAC_CHANGES','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT_SETTING','NPT_ALLOWED_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT_SETTING','NRP_KEY','T','character varying',50,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT_SETTING','OUT_SHAPING_AVG_BANDWIDTH','T','character varying',50,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT_SETTING','OUT_SHAPING_BURST_SIZE','T','character varying',50,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT_SETTING','OUT_SHAPING_ENABLED','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT_SETTING','OUT_SHAPING_OBJECT_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT_SETTING','OUT_SHAPING_PEAK_BANDWIDTH','T','character varying',50,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT_SETTING','OVERLAY_OBJECT_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT_SETTING','PVLAN_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT_SETTING','QOS_TAG','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT_SETTING','SEC_POLICY_OBJECT_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT_SETTING','SURR_KEY','T','integer',32,'NO','nextval(''vpx_dvport_setting_surr_key_seq''::regclass)');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT_SETTING','TEAMING_FAIL_CHK_BEACON','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT_SETTING','TEAMING_FAIL_CHK_DUPLEX','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT_SETTING','TEAMING_FAIL_CHK_PERCENT','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT_SETTING','TEAMING_FAIL_CHK_SPEED','T','character varying',50,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT_SETTING','TEAMING_FAIL_DUPLEX','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT_SETTING','TEAMING_FAIL_PERCENT','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT_SETTING','TEAMING_FAIL_SPEED','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT_SETTING','TEAMING_NOTIFY','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT_SETTING','TEAMING_OBJECT_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT_SETTING','TEAMING_POLICY','T','character varying',50,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT_SETTING','TEAMING_REVERSE','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT_SETTING','TEAMING_ROLLING','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT_SETTING','TRAFFIC_FILTER_OBJ_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT_SETTING','TRUNK_MODE_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT_SETTING','TX_UPLINK','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT_SETTING','UPLINK_ORDER_OBJECT_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT_SETTING','VENDOR_BLOB_OBJECT_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT_SETTING','VLAN_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT_SETTING','VLAN_OBJECT_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT_VLAN','DVPORT_KEY','T','character varying',50,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT_VLAN','DVPORTGROUP_ID','T','integer',32,'NO','0');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT_VLAN','DVS_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT_VLAN','RUNTIMEINFO_FLG','T','numeric',1,'NO','0');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT_VLAN','SURR_KEY','T','integer',32,'NO','nextval(''vpx_dvport_vlan_surr_key_seq''::regclass)');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT_VLAN','VLAN_ID_END','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORT_VLAN','VLAN_ID_START','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORTGROUP','AUTO_EXPAND','T','numeric',1,'NO','0');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORTGROUP','CONFIG_NUM_PORT','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORTGROUP','DESCRIPTION','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORTGROUP','DVPORTGROUP_KEY','T','character varying',255,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORTGROUP','DVPORTGROUP_NAME','T','character varying',255,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORTGROUP','DVPORTGROUP_TYPE','T','character varying',255,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORTGROUP','DVS_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORTGROUP','ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORTGROUP','NUM_PORT','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORTGROUP','POLICY_BLOB_OVERRIDE','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORTGROUP','POLICY_BLOCK_OVERRIDE','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORTGROUP','POLICY_IPFIX_OVERRIDE','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORTGROUP','POLICY_LIVE_PORT_MOVE','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORTGROUP','POLICY_NRP_OVERRIDE','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORTGROUP','POLICY_OVERLAY_OVERRIDE','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORTGROUP','POLICY_RESET_AT_CONNECT','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORTGROUP','POLICY_SECURITY_OVERRIDE','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORTGROUP','POLICY_SHAPING_OVERRIDE','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORTGROUP','POLICY_UPLINK_OVERRIDE','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORTGROUP','POLICY_VLAN_OVERRIDE','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORTGROUP','PORT_NAME_FORMAT','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORTGROUP','TRAFFIC_FILTER_OVERRIDE','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORTGROUP','UPLINK_PORTGROUP_FLG','T','numeric',1,'YES','0');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVPORTGROUP','VMVNIC_RESOURCEPOOL_KEY','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS','CAPAB_DVPORT_OPERATION','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS','CAPAB_DVPORTGROUP_OPERATION','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS','CAPAB_DVS_OPERATION','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS','CONTACT','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS','CREATE_TIME','T','timestamp without time zone',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS','DATACENTER_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS','DEFAULT_PROXYSWITCH_MAX_PORTS','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS','DESCRIPTION','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS','EXTENSION_KEY','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS','FEATURE_CAPAB_VMDIRECTPATH','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS','ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS','IP_ADDRESS','T','character varying',50,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS','LACP_API_VERSION','T','character varying',50,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS','LDP_OPERATION','T','character varying',50,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS','LDP_PROTOCOL_TYPE','T','character varying',50,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS','MAX_MTU','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS','MAX_PORT','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS','MULTICAST_FILTERING_MODE','T','character varying',50,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS','NAME','T','character varying',255,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS','NETWORK_RESOURCE_CTRL_VERSION','T','character varying',50,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS','NETWORK_RESOURCE_MGMT_ENABLED','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS','NUM_PORT','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS','NUM_STANDALONE_PORT','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS','OWNER','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS','POLICY_AUTO_PREINSTALL','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS','POLICY_AUTO_UPGRADE','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS','POLICY_PARTIAL_UPGRADE','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS','PORT_COUNTER','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS','PRODUCT_BUILD','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS','PRODUCT_BUNDLE_ID','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS','PRODUCT_BUNDLE_URL','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS','PRODUCT_FORWARDING_CLASS','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS','PRODUCT_NAME','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS','PRODUCT_VENDOR','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS','PRODUCT_VERSION','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS','PROMISCUOUS_VSPAN','T','character varying',50,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS','UPGRADE_BUILD','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS','UPGRADE_BUNDLE_ID','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS','UPGRADE_BUNDLE_URL','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS','UPGRADE_FORWARDING_CLASS','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS','UPGRADE_MODE','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS','UPGRADE_NAME','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS','UPGRADE_STATUS','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS','UPGRADE_VENDOR','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS','UPGRADE_VERSION','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS','UUID','T','character varying',255,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS','VSPAN_DUP_CHECK','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS','VSPAN_KEY_COUNTER','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_BLOB','BLOB_DATA','T','text',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_BLOB','BLOB_KEY','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_BLOB','DVPORT_KEY','T','character varying',50,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_BLOB','DVPORTGROUP_ID','T','integer',32,'NO','0');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_BLOB','DVS_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_BLOB','HOST_ID','T','integer',32,'NO','0');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_BLOB','PROPERTY_PATH','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_BLOB','SURR_KEY','T','integer',32,'NO','nextval(''vpx_dvs_blob_surr_key_seq''::regclass)');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_COMPATIBLE','ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_COMPATIBLE','PRODUCT_LINE','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_COMPATIBLE','PRODUCT_VERSION','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_COMPATIBLE','SURR_KEY','T','integer',32,'NO','nextval(''vpx_dvs_compatible_surr_key_seq''::regclass)');
 /
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_HC_CONFIG','DVS_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_HC_CONFIG','ENABLE','T','numeric',1,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_HC_CONFIG','HEALTHCHECK_TYPE','T','character varying',255,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_HC_CONFIG','INTERVAL','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_HC_CONFIG','SURR_KEY','T','integer',32,'NO','nextval(''vpx_dvs_hc_config_surr_key_seq''::regclass)');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_INFRA_RES_POOL','ALLOCATION_LIMIT','T','numeric',22,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_INFRA_RES_POOL','ALLOCATION_RESERVATION','T','numeric',22,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_INFRA_RES_POOL','ALLOCATION_SHARES_LEVEL','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_INFRA_RES_POOL','ALLOCATION_SHARES_SHARES','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_INFRA_RES_POOL','DESCRIPTION','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_INFRA_RES_POOL','DVS_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_INFRA_RES_POOL','NRP_KEY','T','character varying',50,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_INFRA_RES_POOL','SURR_KEY','T','integer',32,'NO','nextval(''vpx_dvs_infra_res_pool_surr_key_seq''::regclass)');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_IPFIX','ACTIVE_FLOW_TIMEOUT','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_IPFIX','COLLECTOR_IP','T','character varying',50,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_IPFIX','COLLECTOR_PORT','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_IPFIX','DVS_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_IPFIX','IDLE_FLOW_TIMEOUT','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_IPFIX','INTERNAL_FLOWS_ONLY','T','numeric',1,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_IPFIX','OBSERVATION_DOMAIN_ID','T','bigint',64,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_IPFIX','SAMPLING_RATE','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_IPFIX','SURR_KEY','T','integer',32,'NO','nextval(''vpx_dvs_ipfix_surr_key_seq''::regclass)');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_LAG','DVS_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_LAG','IPFIX_ENABLED','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_LAG','LAG_KEY','T','character varying',50,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_LAG','LAG_MODE','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_LAG','LOADBALANCE_ALGORITHM','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_LAG','NAME','T','character varying',255,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_LAG','SURR_KEY','T','integer',32,'NO','nextval(''vpx_dvs_lag_surr_key_seq''::regclass)');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_LAG','UPLINK_NUM','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_LAG_VLAN','DVS_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_LAG_VLAN','LAG_KEY','T','character varying',50,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_LAG_VLAN','SURR_KEY','T','integer',32,'NO','nextval(''vpx_dvs_lag_vlan_surr_key_seq''::regclass)');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_LAG_VLAN','VLAN_ID_END','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_LAG_VLAN','VLAN_ID_START','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_NRP','ALLOCATION_LIMIT','T','numeric',21,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_NRP','ALLOCATION_SHARES_LEVEL','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_NRP','ALLOCATION_SHARES_SHARES','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_NRP','CONFIG_VERSION','T','numeric',21,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_NRP','DESCRIPTION','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_NRP','DVS_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_NRP','NAME','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_NRP','NRP_KEY','T','character varying',50,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_NRP','PTAG','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_OPAQUE_DATA','DVPORT_KEY','T','character varying',50,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_OPAQUE_DATA','DVPORTGROUP_ID','T','integer',32,'NO','0');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_OPAQUE_DATA','DVS_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_OPAQUE_DATA','HOST_ID','T','integer',32,'NO','0');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_OPAQUE_DATA','IS_INHERITED_TYPE','T','numeric',1,'NO','0');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_OPAQUE_DATA','IS_RUNTIME','T','numeric',1,'NO','0');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_OPAQUE_DATA','OPAQUE_DATA','T','bytea',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_OPAQUE_DATA','OPAQUE_KEY','T','character varying',255,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_OPAQUE_DATA','SURR_KEY','T','integer',32,'NO','nextval(''vpx_dvs_opaque_data_surr_key_seq''::regclass)');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_OVERLAY_INSTANCE','DVS_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_OVERLAY_INSTANCE','INSTANCE_DEPTH','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_OVERLAY_INSTANCE','INSTANCE_KEY','T','character varying',255,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_OVERLAY_INSTANCE','OVERLAY_CLASS','T','character varying',255,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_OVERLAY_INSTANCE','SURR_KEY','T','integer',32,'NO','nextval(''vpx_dvs_overlay_instance_surr_key_seq''::regclass)');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_PVLAN','DVS_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_PVLAN','PRIMARY_VLANID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_PVLAN','PVLAN_TYPE','T','character varying',50,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_PVLAN','SECONDARY_VLANID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_PVLAN','SURR_KEY','T','integer',32,'NO','nextval(''vpx_dvs_pvlan_surr_key_seq''::regclass)');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_RULE','ACTION_TYPE','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_RULE','DESCRIPTION','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_RULE','DIVERT_OPTION','T','character varying',50,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_RULE','DSCP_TAG','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_RULE','ENCAP_IP','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_RULE','FORWARD_PORT_KEY','T','character varying',50,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_RULE','JUMP_RULESET_KEY','T','character varying',100,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_RULE','PACKETS_PER_SECOND','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_RULE','QOS_TAG','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_RULE','REWRITE_MAC','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_RULE','RULE_DIRECTION','T','character varying',50,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_RULE','RULE_KEY','T','character varying',100,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_RULE','RULESET_KEY','T','character varying',100,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_RULE','SEQUENCE','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_RULE','SERVICE_ID','T','character varying',50,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_RULE_QUALIFIER','DST_IP_ADDRESS','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_RULE_QUALIFIER','DST_IP_CONTAINER_ID','T','character varying',50,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_RULE_QUALIFIER','DST_IP_NOT_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_RULE_QUALIFIER','DST_IP_PREFIX_LENGTH','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_RULE_QUALIFIER','DST_IP_TYPE','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_RULE_QUALIFIER','DST_MAC_ADDRESS','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_RULE_QUALIFIER','DST_MAC_CONTAINER_ID','T','character varying',50,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_RULE_QUALIFIER','DST_MAC_MASK','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_RULE_QUALIFIER','DST_MAC_NOT_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_RULE_QUALIFIER','DST_MAC_TYPE','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_RULE_QUALIFIER','DST_PORT_CONTAINER_ID','T','character varying',50,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_RULE_QUALIFIER','DST_PORT_NOT_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_RULE_QUALIFIER','DST_PORT_NUM_END','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_RULE_QUALIFIER','DST_PORT_NUM_START','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_RULE_QUALIFIER','DST_PORT_TYPE','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_RULE_QUALIFIER','L2_PROTOCOL','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_RULE_QUALIFIER','L2_PROTOCOL_NOT_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_RULE_QUALIFIER','L3_L4_PROTOCOL','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_RULE_QUALIFIER','L3_L4_PROTOCOL_NOT_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_RULE_QUALIFIER','QUALIFIER_KEY','T','character varying',100,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_RULE_QUALIFIER','QUALIFIER_TYPE','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_RULE_QUALIFIER','RULE_KEY','T','character varying',100,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_RULE_QUALIFIER','SRC_IP_ADDRESS','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_RULE_QUALIFIER','SRC_IP_CONTAINER_ID','T','character varying',50,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_RULE_QUALIFIER','SRC_IP_NOT_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_RULE_QUALIFIER','SRC_IP_PREFIX_LENGTH','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_RULE_QUALIFIER','SRC_IP_TYPE','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_RULE_QUALIFIER','SRC_MAC_ADDRESS','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_RULE_QUALIFIER','SRC_MAC_CONTAINER_ID','T','character varying',50,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_RULE_QUALIFIER','SRC_MAC_MASK','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_RULE_QUALIFIER','SRC_MAC_NOT_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_RULE_QUALIFIER','SRC_MAC_TYPE','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_RULE_QUALIFIER','SRC_PORT_CONTAINER_ID','T','character varying',50,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_RULE_QUALIFIER','SRC_PORT_NOT_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_RULE_QUALIFIER','SRC_PORT_NUM_END','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_RULE_QUALIFIER','SRC_PORT_NUM_START','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_RULE_QUALIFIER','SRC_PORT_TYPE','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_RULE_QUALIFIER','SYSTEM_TRAFFIC_NOT_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_RULE_QUALIFIER','TCP_FLAGS','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_RULE_QUALIFIER','TCP_FLAGS_NOT_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_RULE_QUALIFIER','TYPE_OF_SYSTEM_TRAFFIC','T','character varying',50,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_RULE_QUALIFIER','VLAN_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_RULE_QUALIFIER','VLAN_ID_NOT_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_RULESET','ENABLED','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_RULESET','PRECEDENCE','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_RULESET','RULESET_KEY','T','character varying',100,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_SCOPE','DVPORT_KEY','T','character varying',50,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_SCOPE','DVPORTGROUP_ID','T','integer',32,'NO','0');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_SCOPE','DVS_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_SCOPE','SCOPE','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_SCOPE','SURR_KEY','T','integer',32,'NO','nextval(''vpx_dvs_scope_surr_key_seq''::regclass)');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_TRAFFIC_FILTER_CONFIG','AGENT_NAME','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_TRAFFIC_FILTER_CONFIG','CONFIG_KEY','T','character varying',100,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_TRAFFIC_FILTER_CONFIG','CONFIG_TYPE','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_TRAFFIC_FILTER_CONFIG','DVPORT_KEY','T','character varying',50,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_TRAFFIC_FILTER_CONFIG','DVPORTGROUP_ID','T','integer',32,'NO','0');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_TRAFFIC_FILTER_CONFIG','DVS_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_TRAFFIC_FILTER_CONFIG','ON_FAILURE','T','character varying',50,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_TRAFFIC_FILTER_CONFIG','RULESET_KEY','T','character varying',100,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_TRAFFIC_FILTER_CONFIG','SURR_KEY','T','integer',32,'NO','nextval(''vpx_dvs_traffic_filter_config_surr_key_seq''::regclass)');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_TRAFFIC_FILTER_PARAM','CONFIG_KEY','T','character varying',100,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_TRAFFIC_FILTER_PARAM','DVPORT_KEY','T','character varying',50,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_TRAFFIC_FILTER_PARAM','DVPORTGROUP_ID','T','integer',32,'NO','0');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_TRAFFIC_FILTER_PARAM','DVS_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_TRAFFIC_FILTER_PARAM','PARAM','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_TRAFFIC_FILTER_PARAM','SURR_KEY','T','integer',32,'NO','nextval(''vpx_dvs_traffic_filter_param_surr_key_seq''::regclass)');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_UPLINK','ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_UPLINK','SURR_KEY','T','integer',32,'NO','nextval(''vpx_dvs_uplink_surr_key_seq''::regclass)');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_UPLINK','UPLINK_INDEX','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_UPLINK','UPLINK_PORT_NAME','T','character varying',255,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_VMVNIC_RES_POOL','ALLOCATION_RESERVATION','T','numeric',22,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_VMVNIC_RES_POOL','CONFIG_VERSION','T','numeric',22,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_VMVNIC_RES_POOL','DESCRIPTION','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_VMVNIC_RES_POOL','DVS_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_VMVNIC_RES_POOL','NAME','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_VMVNIC_RES_POOL','NRP_KEY','T','character varying',50,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_VMVNIC_RES_POOL','SURR_KEY','T','integer',32,'NO','nextval(''vpx_dvs_vmvnic_res_pool_surr_key_seq''::regclass)');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_VSPAN_PORTS','DVS_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_VSPAN_PORTS','IP_ADDRESS','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_VSPAN_PORTS','PORT_IDENTIFIER_TYPE','T','character varying',255,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_VSPAN_PORTS','PORT_IDENTIFIER_VALUE','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_VSPAN_PORTS','PORT_USE','T','character varying',255,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_VSPAN_PORTS','SURR_KEY','T','integer',32,'NO','nextval(''vpx_dvs_vspan_ports_surr_key_seq''::regclass)');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_VSPAN_PORTS','VLAN_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_VSPAN_PORTS','VSPAN_SESSION_KEY','T','character varying',50,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_VSPAN_SESSION','DESCRIPTION','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_VSPAN_SESSION','DVS_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_VSPAN_SESSION','ENCAPSULATION_VLANID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_VSPAN_SESSION','MIRRORED_PACKET_LENGTH','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_VSPAN_SESSION','NAME','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_VSPAN_SESSION','NORMAL_TRAFFIC_ALLOWED','T','numeric',1,'YES',null);
 /
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_VSPAN_SESSION','SAMPLING_RATE','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_VSPAN_SESSION','SESSION_ENABLED','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_VSPAN_SESSION','SESSION_TYPE','T','character varying',255,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_VSPAN_SESSION','STRIP_ORIGINAL_VLAN','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_VSPAN_SESSION','SURR_KEY','T','integer',32,'NO','nextval(''vpx_dvs_vspan_session_surr_key_seq''::regclass)');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_DVS_VSPAN_SESSION','VSPAN_SESSION_KEY','T','character varying',50,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ENTITY','ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ENTITY','NAME','T','character varying',255,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ENTITY','PARENT_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ENTITY','TYPE_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ENTITY_LAST_EVENT','ENTITY_ID','T','integer',32,'NO','0');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ENTITY_LAST_EVENT','EVENT_TYPE','T','character varying',255,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ENTITY_LAST_EVENT','LAST_EVENT_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ENTITY_VMOP_COUNT','CHANGEDS_COUNT','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ENTITY_VMOP_COUNT','CHANGEHOST_COUNT','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ENTITY_VMOP_COUNT','CHANGEHOSTDS_COUNT','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ENTITY_VMOP_COUNT','CLONE_COUNT','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ENTITY_VMOP_COUNT','CREATE_COUNT','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ENTITY_VMOP_COUNT','DEPLOY_COUNT','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ENTITY_VMOP_COUNT','DESTROY_COUNT','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ENTITY_VMOP_COUNT','ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ENTITY_VMOP_COUNT','POWEROFF_COUNT','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ENTITY_VMOP_COUNT','POWERON_COUNT','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ENTITY_VMOP_COUNT','REBOOTGUEST_COUNT','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ENTITY_VMOP_COUNT','RECONFIGURE_COUNT','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ENTITY_VMOP_COUNT','REGISTER_COUNT','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ENTITY_VMOP_COUNT','RESET_COUNT','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ENTITY_VMOP_COUNT','SHUTDOWNGUEST_COUNT','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ENTITY_VMOP_COUNT','STANDBYGUEST_COUNT','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ENTITY_VMOP_COUNT','SUSPEND_COUNT','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ENTITY_VMOP_COUNT','SVMOTION_COUNT','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ENTITY_VMOP_COUNT','UNREGISTER_COUNT','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ENTITY_VMOP_COUNT','VMOTION_COUNT','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ENTITY_VMOP_COUNT','XVMOTION_COUNT','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EVENT','CATEGORY','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EVENT','CHAIN_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EVENT','CHANGE_TAG_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EVENT','COMPUTERESOURCE_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EVENT','COMPUTERESOURCE_NAME','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EVENT','COMPUTERESOURCE_TYPE','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EVENT','CREATE_TIME','T','timestamp without time zone',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EVENT','DATACENTER_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EVENT','DATACENTER_NAME','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EVENT','DATASTORE_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EVENT','DATASTORE_NAME','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EVENT','DVS_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EVENT','DVS_NAME','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EVENT','EVENT_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EVENT','EVENT_TYPE','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EVENT','EXTENDED_CLASS','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EVENT','HOST_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EVENT','HOST_NAME','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EVENT','NETWORK_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EVENT','NETWORK_NAME','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EVENT','NETWORK_TYPE','T','character',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EVENT','STORAGEPOD_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EVENT','STORAGEPOD_NAME','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EVENT','USERNAME','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EVENT','VM_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EVENT','VM_NAME','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EVENT_ARG','ALARM_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EVENT_ARG','ARG_DATA','T','text',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EVENT_ARG','ARG_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EVENT_ARG','ARG_TYPE','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EVENT_ARG','COMPUTERESOURCE_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EVENT_ARG','DATACENTER_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EVENT_ARG','DATASTORE_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EVENT_ARG','DVS_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EVENT_ARG','EVENT_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EVENT_ARG','FOLDER_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EVENT_ARG','HOST_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EVENT_ARG','NETWORK_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EVENT_ARG','NETWORK_TYPE','T','character',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EVENT_ARG','OBJ_NAME','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EVENT_ARG','OBJ_TYPE','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EVENT_ARG','RESOURCEPOOL_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EVENT_ARG','SCHEDULEDTASK_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EVENT_ARG','VM_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EXT','COMPANY','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EXT','COMPANY_URL','T','text',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EXT','DESC_LABEL','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EXT','DESC_SUMMARY','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EXT','EXT_ID','T','character varying',255,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EXT','HEALTH_URL','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EXT','HEARTBEAT','T','timestamp without time zone',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EXT','IN_SOLUTION_MANAGER_FLG','T','numeric',1,'NO','0');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EXT','MANAGEMENT_URL','T','text',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EXT','OVF_CONSUMER_SECTION_TYPES','T','text',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EXT','OVF_CONSUMER_URL','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EXT','PRODUCT_URL','T','text',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EXT','SELF_ENTITY_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EXT','SMALL_ICON_URL','T','text',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EXT','SUBJECT_NAME','T','text',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EXT','THUMBPRINT','T','character varying',100,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EXT','TYPE_NAME','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EXT','VERSION','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EXT_CLIENT','COMPANY','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EXT_CLIENT','DESC_LABEL','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EXT_CLIENT','DESC_SUMMARY','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EXT_CLIENT','EXT_CLIENT_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EXT_CLIENT','EXT_ID','T','character varying',255,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EXT_CLIENT','TYPE','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EXT_CLIENT','URL','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EXT_CLIENT','VERSION','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EXT_DATA','DATA_KEY','T','character varying',255,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EXT_DATA','DATA_VALUE','T','text',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EXT_DATA','EXT_ID','T','character varying',255,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EXT_DATA','SURR_KEY','T','integer',32,'NO','nextval(''vpx_ext_data_surr_key_seq''::regclass)');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EXT_MANAGEDBY_INFO','DESCRIPTION','T','text',-1,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EXT_MANAGEDBY_INFO','EXT_ID','T','character varying',255,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EXT_MANAGEDBY_INFO','ICON_URL','T','text',-1,'NO','''''::text');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EXT_MANAGEDBY_INFO','SMALL_ICON_URL','T','text',-1,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EXT_MANAGEDBY_INFO','TYPE','T','character varying',190,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EXT_PRIVS','EXT_ID','T','character varying',255,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EXT_PRIVS','GROUP_NAME','T','character varying',255,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EXT_PRIVS','PRIV_ID','T','character varying',255,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EXT_PRIVS','SURR_KEY','T','integer',32,'NO','nextval(''vpx_ext_privs_surr_key_seq''::regclass)');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EXT_SERVER','COMPANY','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EXT_SERVER','DESC_LABEL','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EXT_SERVER','DESC_SUMMARY','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EXT_SERVER','EXT_ID','T','character varying',255,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EXT_SERVER','EXT_SERVER_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EXT_SERVER','SERVER_THUMBPRINT','T','character varying',100,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EXT_SERVER','TYPE','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EXT_SERVER','URL','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EXT_SERVER_EMAIL','EMAIL_ADDRESS','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EXT_SERVER_EMAIL','EXT_EMAIL_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EXT_SERVER_EMAIL','EXT_SERVER_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EXT_TABS','EXT_ID','T','character varying',255,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EXT_TABS','LABEL','T','character varying',255,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EXT_TABS','SURR_KEY','T','integer',32,'NO','nextval(''vpx_ext_tabs_surr_key_seq''::regclass)');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EXT_TABS','TAB_INDEX','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EXT_TABS','URL','T','text',-1,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EXT_TYPE_IDS','EXT_ID','T','character varying',255,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EXT_TYPE_IDS','ID','T','character varying',255,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EXT_TYPE_IDS','SURR_KEY','T','integer',32,'NO','nextval(''vpx_ext_type_ids_surr_key_seq''::regclass)');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EXT_TYPE_IDS','TYPE','T','character varying',255,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_EXT_TYPE_IDS','TYPE_SCHEMA','T','text',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_FIELD_DEF','CREATE_DEF_PRIV','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_FIELD_DEF','CREATE_VAL_PRIV','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_FIELD_DEF','DELETE_DEF_PRIV','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_FIELD_DEF','DELETE_VAL_PRIV','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_FIELD_DEF','ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_FIELD_DEF','MO_TYPE_NAME','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_FIELD_DEF','NAME','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_FIELD_DEF','READ_DEF_PRIV','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_FIELD_DEF','READ_VAL_PRIV','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_FIELD_DEF','UPDATE_DEF_PRIV','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_FIELD_DEF','UPDATE_VAL_PRIV','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_FIELD_VAL','ENTITY_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_FIELD_VAL','FIELD_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_FIELD_VAL','MO_ID','T','character varying',255,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_FIELD_VAL','VALUE','T','text',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_FILE_SYSTEM_MOUNT_INFO','ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_FILE_SYSTEM_MOUNT_INFO','VPX_FILE_SYSTEM_MOUNT_INFO_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_GUEST_DISK','CAPACITY','T','character varying',21,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_GUEST_DISK','FREE_SPACE','T','character varying',21,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_GUEST_DISK','PATH','T','character varying',255,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_GUEST_DISK','VM_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_1','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_1','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_1','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_10','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_10','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_10','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_100','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_100','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_100','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_101','COUNTER_ID','T','numeric',38,'NO',null);
 
 /
 
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_101','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_101','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_102','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_102','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_102','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_103','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_103','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_103','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_104','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_104','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_104','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_105','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_105','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_105','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_106','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_106','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_106','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_107','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_107','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_107','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_108','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_108','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_108','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_109','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_109','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_109','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_11','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_11','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_11','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_110','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_110','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_110','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_111','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_111','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_111','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_112','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_112','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_112','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_113','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_113','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_113','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_114','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_114','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_114','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_115','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_115','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_115','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_116','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_116','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_116','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_117','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_117','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_117','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_118','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_118','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_118','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_119','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_119','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_119','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_12','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_12','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_12','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_120','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_120','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_120','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_121','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_121','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_121','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_122','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_122','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_122','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_123','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_123','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_123','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_124','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_124','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_124','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_125','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_125','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_125','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_126','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_126','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_126','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_127','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_127','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_127','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_128','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_128','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_128','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_129','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_129','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_129','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_13','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_13','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_13','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_130','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_130','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_130','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_131','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_131','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_131','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_132','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_132','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_132','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_133','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_133','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_133','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_134','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_134','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_134','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_135','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_135','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_135','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_136','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_136','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_136','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_137','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_137','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_137','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_138','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_138','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_138','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_139','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_139','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_139','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_14','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_14','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_14','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_140','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_140','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_140','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_141','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_141','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_141','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_142','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_142','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_142','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_143','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_143','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_143','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_144','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_144','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_144','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_145','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_145','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_145','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_146','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_146','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_146','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_147','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_147','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_147','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_148','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_148','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_148','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_149','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_149','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_149','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_15','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_15','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_15','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_150','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_150','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_150','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_151','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_151','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_151','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_152','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_152','STAT_VAL','T','numeric',38,'NO',null);
 /
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_152','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_153','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_153','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_153','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_154','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_154','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_154','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_155','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_155','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_155','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_156','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_156','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_156','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_157','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_157','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_157','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_158','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_158','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_158','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_159','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_159','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_159','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_16','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_16','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_16','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_160','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_160','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_160','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_161','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_161','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_161','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_162','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_162','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_162','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_163','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_163','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_163','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_164','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_164','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_164','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_165','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_165','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_165','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_166','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_166','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_166','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_167','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_167','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_167','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_168','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_168','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_168','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_169','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_169','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_169','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_17','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_17','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_17','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_170','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_170','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_170','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_171','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_171','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_171','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_172','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_172','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_172','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_173','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_173','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_173','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_174','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_174','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_174','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_175','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_175','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_175','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_176','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_176','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_176','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_177','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_177','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_177','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_178','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_178','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_178','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_179','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_179','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_179','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_18','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_18','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_18','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_180','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_180','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_180','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_181','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_181','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_181','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_182','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_182','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_182','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_183','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_183','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_183','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_184','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_184','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_184','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_185','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_185','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_185','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_186','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_186','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_186','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_187','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_187','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_187','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_188','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_188','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_188','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_189','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_189','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_189','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_19','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_19','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_19','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_190','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_190','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_190','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_191','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_191','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_191','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_192','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_192','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_192','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_193','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_193','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_193','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_194','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_194','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_194','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_195','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_195','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_195','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_196','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_196','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_196','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_197','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_197','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_197','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_198','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_198','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_198','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_199','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_199','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_199','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_2','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_2','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_2','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_20','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_20','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_20','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_200','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_200','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_200','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_201','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_201','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_201','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_202','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_202','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_202','TIME_ID','T','numeric',38,'NO',null);
 /
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_203','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_203','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_203','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_204','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_204','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_204','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_205','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_205','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_205','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_206','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_206','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_206','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_207','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_207','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_207','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_208','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_208','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_208','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_209','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_209','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_209','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_21','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_21','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_21','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_210','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_210','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_210','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_211','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_211','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_211','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_212','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_212','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_212','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_213','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_213','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_213','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_214','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_214','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_214','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_215','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_215','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_215','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_216','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_216','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_216','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_217','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_217','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_217','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_218','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_218','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_218','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_219','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_219','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_219','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_22','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_22','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_22','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_220','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_220','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_220','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_221','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_221','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_221','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_222','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_222','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_222','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_223','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_223','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_223','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_224','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_224','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_224','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_225','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_225','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_225','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_226','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_226','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_226','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_227','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_227','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_227','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_228','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_228','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_228','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_229','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_229','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_229','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_23','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_23','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_23','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_230','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_230','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_230','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_231','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_231','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_231','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_232','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_232','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_232','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_233','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_233','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_233','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_234','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_234','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_234','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_235','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_235','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_235','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_236','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_236','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_236','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_237','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_237','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_237','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_238','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_238','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_238','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_239','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_239','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_239','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_24','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_24','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_24','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_240','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_240','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_240','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_241','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_241','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_241','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_25','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_25','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_25','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_26','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_26','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_26','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_27','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_27','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_27','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_28','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_28','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_28','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_29','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_29','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_29','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_3','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_3','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_3','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_30','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_30','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_30','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_31','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_31','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_31','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_32','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_32','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_32','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_33','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_33','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_33','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_34','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_34','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_34','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_35','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_35','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_35','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_36','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_36','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_36','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_37','COUNTER_ID','T','numeric',38,'NO',null);
 /
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_37','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_37','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_38','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_38','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_38','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_39','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_39','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_39','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_4','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_4','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_4','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_40','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_40','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_40','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_41','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_41','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_41','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_42','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_42','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_42','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_43','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_43','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_43','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_44','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_44','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_44','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_45','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_45','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_45','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_46','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_46','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_46','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_47','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_47','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_47','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_48','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_48','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_48','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_49','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_49','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_49','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_5','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_5','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_5','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_50','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_50','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_50','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_51','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_51','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_51','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_52','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_52','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_52','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_53','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_53','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_53','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_54','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_54','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_54','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_55','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_55','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_55','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_56','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_56','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_56','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_57','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_57','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_57','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_58','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_58','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_58','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_59','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_59','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_59','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_6','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_6','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_6','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_60','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_60','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_60','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_61','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_61','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_61','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_62','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_62','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_62','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_63','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_63','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_63','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_64','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_64','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_64','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_65','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_65','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_65','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_66','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_66','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_66','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_67','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_67','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_67','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_68','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_68','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_68','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_69','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_69','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_69','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_7','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_7','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_7','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_70','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_70','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_70','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_71','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_71','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_71','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_72','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_72','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_72','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_73','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_73','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_73','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_74','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_74','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_74','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_75','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_75','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_75','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_76','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_76','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_76','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_77','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_77','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_77','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_78','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_78','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_78','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_79','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_79','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_79','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_8','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_8','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_8','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_80','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_80','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_80','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_81','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_81','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_81','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_82','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_82','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_82','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_83','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_83','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_83','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_84','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_84','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_84','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_85','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_85','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_85','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_86','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_86','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_86','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_87','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_87','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_87','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_88','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_88','STAT_VAL','T','numeric',38,'NO',null);
 /
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_88','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_89','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_89','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_89','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_9','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_9','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_9','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_90','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_90','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_90','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_91','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_91','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_91','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_92','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_92','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_92','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_93','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_93','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_93','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_94','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_94','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_94','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_95','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_95','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_95','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_96','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_96','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_96','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_97','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_97','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_97','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_98','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_98','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_98','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_99','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_99','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT1_99','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_1','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_1','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_1','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_10','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_10','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_10','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_11','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_11','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_11','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_12','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_12','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_12','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_13','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_13','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_13','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_14','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_14','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_14','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_15','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_15','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_15','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_16','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_16','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_16','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_17','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_17','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_17','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_18','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_18','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_18','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_19','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_19','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_19','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_2','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_2','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_2','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_20','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_20','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_20','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_21','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_21','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_21','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_22','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_22','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_22','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_23','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_23','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_23','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_24','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_24','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_24','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_25','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_25','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_25','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_26','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_26','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_26','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_27','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_27','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_27','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_28','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_28','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_28','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_29','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_29','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_29','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_3','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_3','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_3','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_30','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_30','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_30','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_31','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_31','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_31','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_32','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_32','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_32','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_33','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_33','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_33','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_34','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_34','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_34','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_35','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_35','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_35','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_36','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_36','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_36','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_37','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_37','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_37','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_38','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_38','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_38','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_39','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_39','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_39','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_4','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_4','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_4','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_40','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_40','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_40','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_41','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_41','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_41','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_42','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_42','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_42','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_43','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_43','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_43','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_44','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_44','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_44','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_45','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_45','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_45','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_46','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_46','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_46','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_47','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_47','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_47','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_48','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_48','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_48','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_49','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_49','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_49','TIME_ID','T','numeric',38,'NO',null);
 /
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_5','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_5','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_5','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_50','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_50','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_50','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_51','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_51','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_51','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_52','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_52','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_52','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_53','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_53','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_53','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_54','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_54','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_54','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_55','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_55','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_55','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_56','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_56','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_56','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_57','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_57','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_57','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_58','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_58','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_58','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_59','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_59','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_59','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_6','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_6','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_6','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_60','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_60','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_60','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_61','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_61','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_61','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_62','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_62','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_62','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_63','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_63','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_63','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_64','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_64','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_64','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_65','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_65','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_65','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_66','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_66','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_66','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_67','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_67','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_67','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_68','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_68','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_68','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_69','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_69','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_69','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_7','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_7','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_7','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_70','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_70','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_70','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_71','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_71','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_71','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_72','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_72','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_72','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_73','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_73','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_73','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_74','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_74','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_74','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_75','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_75','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_75','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_76','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_76','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_76','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_77','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_77','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_77','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_78','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_78','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_78','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_79','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_79','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_79','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_8','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_8','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_8','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_80','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_80','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_80','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_81','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_81','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_81','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_82','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_82','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_82','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_83','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_83','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_83','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_84','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_84','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_84','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_85','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_85','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_85','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_9','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_9','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT2_9','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_1','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_1','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_1','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_10','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_10','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_10','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_11','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_11','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_11','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_12','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_12','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_12','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_13','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_13','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_13','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_14','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_14','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_14','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_15','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_15','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_15','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_16','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_16','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_16','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_17','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_17','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_17','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_18','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_18','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_18','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_19','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_19','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_19','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_2','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_2','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_2','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_20','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_20','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_20','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_21','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_21','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_21','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_22','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_22','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_22','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_23','COUNTER_ID','T','numeric',38,'NO',null);
 /
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_23','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_23','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_24','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_24','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_24','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_25','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_25','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_25','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_26','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_26','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_26','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_27','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_27','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_27','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_28','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_28','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_28','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_29','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_29','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_29','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_3','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_3','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_3','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_30','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_30','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_30','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_31','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_31','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_31','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_32','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_32','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_32','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_4','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_4','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_4','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_5','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_5','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_5','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_6','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_6','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_6','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_7','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_7','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_7','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_8','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_8','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_8','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_9','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_9','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT3_9','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_1','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_1','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_1','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_10','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_10','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_10','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_100','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_100','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_100','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_101','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_101','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_101','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_102','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_102','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_102','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_103','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_103','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_103','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_104','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_104','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_104','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_105','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_105','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_105','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_106','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_106','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_106','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_107','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_107','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_107','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_108','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_108','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_108','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_109','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_109','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_109','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_11','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_11','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_11','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_110','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_110','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_110','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_111','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_111','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_111','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_112','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_112','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_112','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_113','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_113','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_113','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_114','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_114','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_114','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_115','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_115','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_115','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_116','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_116','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_116','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_117','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_117','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_117','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_118','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_118','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_118','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_119','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_119','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_119','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_12','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_12','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_12','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_120','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_120','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_120','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_121','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_121','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_121','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_122','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_122','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_122','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_123','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_123','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_123','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_124','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_124','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_124','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_125','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_125','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_125','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_126','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_126','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_126','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_127','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_127','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_127','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_128','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_128','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_128','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_129','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_129','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_129','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_13','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_13','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_13','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_130','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_130','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_130','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_131','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_131','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_131','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_132','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_132','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_132','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_133','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_133','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_133','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_134','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_134','STAT_VAL','T','numeric',38,'NO',null);
 /
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_134','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_135','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_135','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_135','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_136','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_136','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_136','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_137','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_137','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_137','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_138','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_138','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_138','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_139','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_139','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_139','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_14','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_14','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_14','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_140','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_140','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_140','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_141','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_141','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_141','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_142','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_142','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_142','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_143','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_143','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_143','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_144','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_144','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_144','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_145','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_145','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_145','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_146','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_146','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_146','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_147','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_147','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_147','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_148','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_148','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_148','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_149','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_149','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_149','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_15','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_15','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_15','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_150','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_150','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_150','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_151','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_151','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_151','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_152','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_152','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_152','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_153','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_153','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_153','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_154','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_154','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_154','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_155','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_155','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_155','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_156','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_156','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_156','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_157','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_157','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_157','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_158','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_158','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_158','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_159','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_159','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_159','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_16','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_16','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_16','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_160','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_160','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_160','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_161','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_161','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_161','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_162','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_162','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_162','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_163','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_163','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_163','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_164','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_164','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_164','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_165','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_165','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_165','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_166','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_166','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_166','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_167','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_167','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_167','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_168','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_168','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_168','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_169','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_169','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_169','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_17','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_17','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_17','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_170','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_170','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_170','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_171','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_171','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_171','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_172','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_172','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_172','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_173','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_173','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_173','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_174','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_174','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_174','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_175','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_175','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_175','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_176','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_176','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_176','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_177','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_177','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_177','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_178','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_178','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_178','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_179','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_179','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_179','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_18','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_18','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_18','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_180','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_180','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_180','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_181','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_181','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_181','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_182','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_182','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_182','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_183','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_183','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_183','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_19','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_19','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_19','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_2','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_2','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_2','TIME_ID','T','numeric',38,'NO',null);
 /
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_20','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_20','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_20','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_21','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_21','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_21','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_22','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_22','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_22','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_23','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_23','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_23','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_24','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_24','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_24','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_25','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_25','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_25','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_26','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_26','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_26','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_27','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_27','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_27','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_28','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_28','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_28','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_29','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_29','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_29','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_3','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_3','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_3','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_30','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_30','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_30','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_31','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_31','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_31','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_32','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_32','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_32','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_33','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_33','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_33','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_34','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_34','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_34','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_35','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_35','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_35','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_36','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_36','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_36','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_37','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_37','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_37','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_38','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_38','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_38','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_39','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_39','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_39','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_4','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_4','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_4','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_40','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_40','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_40','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_41','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_41','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_41','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_42','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_42','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_42','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_43','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_43','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_43','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_44','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_44','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_44','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_45','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_45','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_45','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_46','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_46','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_46','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_47','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_47','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_47','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_48','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_48','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_48','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_49','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_49','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_49','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_5','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_5','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_5','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_50','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_50','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_50','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_51','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_51','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_51','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_52','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_52','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_52','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_53','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_53','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_53','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_54','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_54','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_54','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_55','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_55','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_55','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_56','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_56','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_56','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_57','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_57','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_57','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_58','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_58','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_58','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_59','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_59','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_59','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_6','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_6','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_6','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_60','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_60','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_60','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_61','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_61','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_61','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_62','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_62','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_62','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_63','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_63','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_63','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_64','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_64','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_64','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_65','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_65','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_65','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_66','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_66','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_66','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_67','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_67','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_67','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_68','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_68','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_68','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_69','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_69','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_69','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_7','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_7','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_7','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_70','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_70','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_70','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_71','COUNTER_ID','T','numeric',38,'NO',null);
 /
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_71','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_71','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_72','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_72','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_72','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_73','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_73','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_73','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_74','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_74','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_74','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_75','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_75','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_75','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_76','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_76','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_76','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_77','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_77','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_77','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_78','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_78','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_78','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_79','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_79','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_79','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_8','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_8','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_8','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_80','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_80','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_80','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_81','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_81','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_81','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_82','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_82','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_82','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_83','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_83','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_83','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_84','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_84','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_84','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_85','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_85','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_85','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_86','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_86','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_86','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_87','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_87','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_87','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_88','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_88','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_88','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_89','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_89','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_89','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_9','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_9','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_9','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_90','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_90','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_90','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_91','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_91','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_91','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_92','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_92','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_92','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_93','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_93','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_93','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_94','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_94','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_94','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_95','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_95','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_95','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_96','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_96','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_96','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_97','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_97','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_97','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_98','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_98','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_98','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_99','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_99','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HIST_STAT4_99','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST','ADMIN_DISABLED_FLG','T','numeric',1,'NO','0');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST','AGENT_VM_DATASTORE_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST','AGENT_VM_NETWORK_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST','ATTESTATION_IDENTITY_KEY','T','text',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST','AUTHD_PORT','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST','BOOT_TIME','T','timestamp without time zone',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST','BOOT_TIME_ON_HOST','T','numeric',21,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST','CAPABILITY','T','text',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST','CNX_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST','CONFIG','T','text',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST','CONFIG_MANAGER','T','text',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST','CPU_CORE_COUNT','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST','CPU_COUNT','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST','CPU_HZ','T','character varying',21,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST','CPU_MODEL','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST','CPU_POWER_MGMT_POLICY','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST','CPU_POWER_MGMT_SUPPORT','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST','CPU_THREAD_COUNT','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST','DAS_NODE_NAME','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST','DATACENTER_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST','DEFAULT_VM_PATH','T','text',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST','DNS_NAME','T','character varying',255,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST','ENABLED','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST','ENDORSEMENT_KEY','T','text',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST','EXPECTED_SSL_THUMBPRINT','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST','FAULTTOLERANCE_ENABLED_FLG','T','numeric',1,'NO','0');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST','GATEWAY_ID','T','character varying',128,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST','GATEWAY_TRUST_TOKEN','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST','GATEWAY_TYPE','T','character varying',64,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST','HBA_COUNT','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST','HOST_KEY','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST','HOST_MODEL','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST','HOST_SSL_THUMBPRINT','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST','HOST_VENDOR','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST','ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST','IP_ADDRESS','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST','IPMI_IP_ADDRESS','T','character varying',50,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST','IPMI_MAC_ADDRESS','T','character varying',18,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST','IPMI_PASSWORD','T','character varying',686,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST','IPMI_USER_NAME','T','character varying',17,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST','LAST_PERF_TIME','T','timestamp without time zone',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST','LICENSABLE_RESOURCES','T','text',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST','LICENSED_EDITION','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST','LOCAL_IP_ADDRESS','T','character varying',50,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST','MAINTENANCE_MODE','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST','MANAGEMENT_IP','T','character varying',50,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST','MASTER_GEN','T','character varying',21,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST','MASTER_SPEC_GEN','T','character varying',21,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST','MEM_SIZE','T','character varying',21,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST','NETWORK_RUNTIME_INFO','T','text',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST','NIC_COUNT','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST','NUMA_TYPE','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST','PASSWORD','T','character varying',686,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST','PASSWORD_LAST_UPD_DT','T','timestamp without time zone',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST','PERF_REFRESH_RATE','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST','POWER_STATE','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST','PRODUCT_API_TYPE','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST','PRODUCT_API_VERSION','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST','PRODUCT_BUILD','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST','PRODUCT_FULLNAME','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST','PRODUCT_LINE_ID','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST','PRODUCT_NAME','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST','PRODUCT_OS_TYPE','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST','PRODUCT_VENDOR','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST','PRODUCT_VERSION','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST','RESOURCE_INFO','T','text',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST','ROOT_RES_CONFIG','T','text',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST','SMC_PRESENT','T','numeric',1,'NO','0');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST','SOAP_PORT','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST','USER_NAME','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST','UUID_BIOS','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST','VM_HARDWARE_INFO','T','text',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST','VM_PROV_POLICY','T','text',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST','VMOTION_ENABLED','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST','VPXA_ID','T','character varying',21,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_BUS_ADAPTER','HOST_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_BUS_ADAPTER','ID','T','integer',32,'NO',null);
 /
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_BUS_ADAPTER','KEY_VAL','T','character varying',512,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_BUS_ADAPTER','VPX_TYPE','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_CONFIG_INFO','ARRAY_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_CONFIG_INFO','ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_CPU','BUS_HZ','T','character varying',21,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_CPU','CPU_INDEX','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_CPU','DESCRIPTION','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_CPU','HOST_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_CPU','HZ','T','character varying',21,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_CPU','VENDOR','T','character varying',255,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_CPU_CPUID_FEATURE','CPU_EAX','T','character varying',40,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_CPU_CPUID_FEATURE','CPU_EBX','T','character varying',40,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_CPU_CPUID_FEATURE','CPU_ECX','T','character varying',40,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_CPU_CPUID_FEATURE','CPU_EDX','T','character varying',40,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_CPU_CPUID_FEATURE','CPU_FEATURE_LEVEL','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_CPU_CPUID_FEATURE','CPU_FEATURE_VENDOR','T','character varying',16,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_CPU_CPUID_FEATURE','CPU_INDEX','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_CPU_CPUID_FEATURE','HOST_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_CPU_THREAD','CPU_INDEX','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_CPU_THREAD','HOST_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_CPU_THREAD','THREAD_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_CPUID_FEATURE','HOST_EAX','T','character varying',40,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_CPUID_FEATURE','HOST_EBX','T','character varying',40,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_CPUID_FEATURE','HOST_ECX','T','character varying',40,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_CPUID_FEATURE','HOST_EDX','T','character varying',40,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_CPUID_FEATURE','HOST_FEATURE_LEVEL','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_CPUID_FEATURE','HOST_FEATURE_VENDOR','T','character varying',16,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_CPUID_FEATURE','HOST_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_CPUID_FEATURE','SURR_KEY','T','integer',32,'NO','nextval(''vpx_host_cpuid_feature_surr_key_seq''::regclass)');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_DISABLEADMIN','ENTITY_MOID','T','character varying',256,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_DISABLEADMIN','ENTITY_TYPE','T','character varying',256,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_DISABLEADMIN','GROUP_FLG','T','numeric',1,'NO','0');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_DISABLEADMIN','HOST_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_DISABLEADMIN','PRINCIPAL_NAME','T','character varying',180,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_DISABLEADMIN','PROPAGATE_FLG','T','numeric',1,'NO','0');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_DISABLEADMIN','ROLE_ID_VAL','T','numeric',10,'NO','0');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_GW_PARAMS','HOST_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_GW_PARAMS','PARAM_NAME','T','character varying',255,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_GW_PARAMS','VALUE','T','text',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_INTERNAL_CAPABILITY','ENUMERATE_EXTENTS_FLG','T','numeric',1,'NO','0');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_INTERNAL_CAPABILITY','FAST_SUSPEND_RESUME_FLG','T','numeric',1,'NO','0');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_INTERNAL_CAPABILITY','HOST_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_INTERNAL_CAPABILITY','HOSTPROFILE_ENGINE_FLG','T','numeric',1,'NO','0');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_INTERNAL_CAPABILITY','INTERNAL_CAPABILITY','T','text',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_INTERNAL_CAPABILITY','LUN_DISPLAY_NAME_FLG','T','numeric',1,'NO','0');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_INTERNAL_CAPABILITY','SVM_VMX_DISKCOPY_FLG','T','numeric',1,'NO','0');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_NODE','HOST_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_NODE','MEM_RANGE_BEGIN','T','character varying',21,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_NODE','MEM_RANGE_LENGTH','T','character varying',21,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_NODE','NUMA_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_NODE_CPU','CPU_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_NODE_CPU','HOST_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_NODE_CPU','NUMA_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_PCI_DEVICE','BUS','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_PCI_DEVICE','CLASS_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_PCI_DEVICE','DEVICE_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_PCI_DEVICE','DEVICE_NAME','T','character varying',255,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_PCI_DEVICE','HOST_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_PCI_DEVICE','PCI_FUNCTION','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_PCI_DEVICE','PCI_ID','T','character varying',255,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_PCI_DEVICE','SLOT','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_PCI_DEVICE','SUB_DEVICE_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_PCI_DEVICE','SUB_VENDOR_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_PCI_DEVICE','SURR_KEY','T','integer',32,'NO','nextval(''vpx_host_pci_device_surr_key_seq''::regclass)');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_PCI_DEVICE','VENDOR_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_PCI_DEVICE','VENDOR_NAME','T','character varying',255,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_PROFILE','CREATED_TIME','T','timestamp without time zone',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_PROFILE','PROFILE_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_PROFILE','REF_HOST_ENTITY_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_SYSTEM_ID_INFO','HOST_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_SYSTEM_ID_INFO','SYSTEM_IDENTIFICATION_INFO','T','text',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_TEXT','ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_TEXT','TYPE_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_TEXT','VALUE','T','text',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_VM_CONFIG_OPTION','ARRAY_INDEX','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_VM_CONFIG_OPTION','CONFIG_OPTION_DESC','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_VM_CONFIG_OPTION','CONFIG_OPTION_VER','T','character varying',255,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_VM_CONFIG_OPTION','CREATE_SUPPORTED_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_VM_CONFIG_OPTION','DATA','T','text',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_VM_CONFIG_OPTION','DEFAULT_CONFIG_OPTION_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_VM_CONFIG_OPTION','HOST_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_VM_CONFIG_OPTION','RUN_SUPPORTED_FLG','T','numeric',1,'NO','1');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_VM_CONFIG_OPTION','UPGRADE_SUPPORTED_FLG','T','numeric',1,'NO','1');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_X','BIOS_RELEASE_DATE','T','timestamp without time zone',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_X','BIOS_VERSION','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_X','DAS_EVENT_KEY','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_X','DAS_EVENT_VERSION','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_X','DAS_FDM_STATE','T','character varying',128,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_X','DAS_FDM_STATE_SOURCE','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_X','DAS_NODE_NAME','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_X','DAS_VC_STATE','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_X','HOST_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_HOST_X','SYSTEM_HEALTH','T','text',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_INDEX_COLUMN','COL_NAME','T','character varying',30,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_INDEX_COLUMN','INDEX_NAME','T','character varying',30,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_INDEX_COLUMN','TABLE_NAME','T','character varying',30,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_INT_ARRAY','ARRAY_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_INT_ARRAY','ARRAY_INDEX','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_INT_ARRAY','MO_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_INT_ARRAY','MO_TYPE','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_INT_ARRAY','SURR_KEY','T','integer',32,'NO','nextval(''vpx_int_array_surr_key_seq''::regclass)');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_INT_ARRAY','TYPE_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_INT_ARRAY','VALUE','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_IP_ADDRESS','DEVICE_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_IP_ADDRESS','ENTITY_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_IP_ADDRESS','IP_ADDRESS','T','character varying',50,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_IP_ADDRESS','SURR_KEY','T','integer',32,'NO','nextval(''vpx_ip_address_surr_key_seq''::regclass)');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_IP_POOL','DATACENTER_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_IP_POOL','DNS_DOMAIN','T','character varying',256,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_IP_POOL','DNS_SEARCH_PATH','T','character varying',128,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_IP_POOL','HOST_PREFIX','T','character varying',128,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_IP_POOL','HTTP_PROXY','T','character varying',128,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_IP_POOL','ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_IP_POOL','IPV4_DHCP','T','numeric',1,'NO','0');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_IP_POOL','IPV4_DNS','T','character varying',128,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_IP_POOL','IPV4_ENABLED','T','numeric',1,'NO','0');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_IP_POOL','IPV4_GATEWAY','T','character varying',16,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_IP_POOL','IPV4_NETMASK','T','character varying',16,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_IP_POOL','IPV4_RANGE','T','character varying',128,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_IP_POOL','IPV4_SUBNET','T','character varying',16,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_IP_POOL','IPV6_DHCP','T','numeric',1,'NO','0');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_IP_POOL','IPV6_DNS','T','character varying',128,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_IP_POOL','IPV6_ENABLED','T','numeric',1,'NO','0');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_IP_POOL','IPV6_GATEWAY','T','character varying',128,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_IP_POOL','IPV6_NETMASK','T','character varying',128,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_IP_POOL','IPV6_RANGE','T','character varying',128,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_IP_POOL','IPV6_SUBNET','T','character varying',128,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_IP_POOL','NAME','T','character varying',255,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_IP_POOL_ALLOCATION','ALLOCATION_ID','T','character varying',255,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_IP_POOL_ALLOCATION','EXTENSION_KEY','T','character varying',255,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_IP_POOL_ALLOCATION','IP_ADDRESS','T','character varying',50,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_IP_POOL_ALLOCATION','POOL_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_IP_POOL_ALLOCATION','SURR_KEY','T','integer',32,'NO','nextval(''vpx_ip_pool_allocation_surr_key_seq''::regclass)');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_IP_POOL_ASSOCIATION','NETWORK_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_IP_POOL_ASSOCIATION','POOL_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_JOB_LOG','JOB_ID','T','numeric',5,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_JOB_LOG','LAST_RUN','T','timestamp without time zone',-1,'NO','to_timestamp(''01.01.1900 00:00:00''::text, ''DD.MM.YYYY HH24:MI:SS''::text)');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_JOB_LOG','STATUS','T','character varying',10,'NO','''WAITING''::character varying');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_LIC_ASSET_PROPERTIES','ASSET_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_LIC_ASSET_PROPERTIES','CREATE_TIMESTAMP','T','character',19,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_LIC_ASSET_PROPERTIES','CREATE_TS','T','numeric',22,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_LIC_ASSET_PROPERTIES','DATA_TYPE','T','character',3,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_LIC_ASSET_PROPERTIES','DELETE_TIMESTAMP','T','character',19,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_LIC_ASSET_PROPERTIES','DELETE_TS','T','numeric',22,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_LIC_ASSET_PROPERTIES','DIGEST','T','bytea',-1,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_LIC_ASSET_PROPERTIES','IS_ACTIVE','T','numeric',1,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_LIC_ASSET_PROPERTIES','PROPERTY_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_LIC_ASSET_PROPERTIES','VALUE','T','character varying',255,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_LIC_ASSETS','ASSET_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_LIC_ASSETS','ASSET_KEY','T','character varying',100,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_LIC_ASSETS','NAME','T','character varying',100,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_LIC_AUTO_KEYS','ASSET_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_LIC_AUTO_KEYS','ENTITY_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_LIC_AUTO_KEYS','LICENSE','T','text',-1,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_LIC_CONTEXT','ASSET_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_LIC_CONTEXT','CONTEXT_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_LIC_CONTEXT','LICENSE_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_LIC_CONTEXT','VC_GROUP_ID','T','numeric',38,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_LIC_CONTEXT','VC_NAME','T','character varying',50,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_LIC_CONTEXT','VC_SCOPE','T','character varying',50,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_LIC_LICENSES','CAPACITY','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_LIC_LICENSES','COST_UNIT','T','character varying',50,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_LIC_LICENSES','COST_UNIT_NUM','T','numeric',4,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_LIC_LICENSES','EDITION_KEY','T','character varying',100,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_LIC_LICENSES','EDITION_NAME','T','character varying',100,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_LIC_LICENSES','EXPIRATION_DATE','T','timestamp without time zone',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_LIC_LICENSES','EXPIRATION_TS','T','numeric',22,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_LIC_LICENSES','LICENSE_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_LIC_LICENSES','LICENSE_KEY','T','character varying',150,'NO',null);
 /
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_LIC_LICENSES','PRODUCT_NAME','T','character varying',100,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_LIC_LICENSES','PRODUCT_VERSION','T','character varying',50,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_LIC_METADATA','DATA_TYPE','T','character',3,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_LIC_METADATA','GLOBAL_DIGEST','T','bytea',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_LIC_METADATA','IS_STATE_VALID','T','numeric',1,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_LIC_METADATA','LAST_SAMPLE_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_LIC_METADATA','LAST_SAMPLE_TIMESTAMP','T','timestamp without time zone',-1,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_LIC_METADATA','RETAINED_SAMPLE_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_LIC_METADATA','RETAINED_SAMPLE_TIMESTAMP','T','timestamp without time zone',-1,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_LIC_METADATA','WEEK_KEEP_COUNT','T','numeric',4,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_LIC_SETTINGS','NAME','T','character varying',255,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_LIC_SETTINGS','VALUE','T','character varying',255,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_LIC_SNAPSHOT','ASSET_KEY','T','character varying',100,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_LIC_SNAPSHOT','ASSET_NAME','T','character varying',100,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_LIC_SNAPSHOT','CAPACITY','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_LIC_SNAPSHOT','COST_UNIT','T','character varying',50,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_LIC_SNAPSHOT','COST_UNIT_NUM','T','numeric',4,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_LIC_SNAPSHOT','EDITION_KEY','T','character varying',100,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_LIC_SNAPSHOT','EDITION_NAME','T','character varying',100,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_LIC_SNAPSHOT','EXPIRATION_DATE','T','character',19,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_LIC_SNAPSHOT','EXPIRATION_TS','T','numeric',22,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_LIC_SNAPSHOT','LAST_SAMPLE_COUNT','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_LIC_SNAPSHOT','LICENSE_KEY','T','character varying',150,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_LIC_SNAPSHOT','PRODUCT_NAME','T','character varying',100,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_LIC_SNAPSHOT','PRODUCT_VERSION','T','character varying',50,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_LIC_SNAPSHOT','SAMPLE_DIGEST','T','bytea',-1,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_LIC_SNAPSHOT','USAGE','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_LIC_SNAPSHOT','USAGE_TIMESTAMP','T','character',19,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_LIC_SNAPSHOT','USAGE_TS','T','numeric',22,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_LIC_SNAPSHOT','VC_NAME','T','character varying',50,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_LIC_SNAPSHOT','VC_SCOPE','T','character varying',50,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_LIC_SNAPSHOT_VC_GROUP','VC_ID','T','character varying',50,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_LIC_SNAPSHOT_VC_GROUP','VC_NAME','T','character varying',50,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_LIC_TPS_ASSETS','ASSET_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_LIC_TPS_ASSETS','ASSET_NAME','T','character varying',64,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_LIC_TPS_ASSETS','DESCRIPTION','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_LIC_USAGE','CONTEXT_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_LIC_USAGE','LAST_SAMPLE_COUNT','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_LIC_USAGE','SAMPLE_DIGEST','T','bytea',-1,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_LIC_USAGE','SAMPLE_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_LIC_USAGE','SAMPLE_TIMESTAMP','T','timestamp without time zone',-1,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_LIC_USAGE','SAMPLE_TS','T','numeric',22,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_LIC_USAGE','USAGE','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_LIC_VC_GROUP_MEMBERS','VC_GROUP_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_LIC_VC_GROUP_MEMBERS','VC_ID','T','character varying',50,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_LIC_VC_GROUP_MEMBERS','VC_NAME','T','character varying',50,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_LIC_VC_GROUPS','CREATED_TIMESTAMP','T','timestamp without time zone',-1,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_LIC_VC_GROUPS','IS_ACTIVE','T','numeric',1,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_LIC_VC_GROUPS','VC_GROUP_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_LICENSE','SERIAL_KEY','T','character varying',30,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_LICENSE','SERIAL_NUMBER','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_LICENSE','TYPE','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_LOCK','ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_MAC_XVC_VMOTION','MAC_ADDRESS','T','character varying',20,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_MULTIPATHSTATEINFO_PATH','ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_MULTIPATHSTATEINFO_PATH','PATH_NAME','T','character varying',512,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_MULTIPATHSTATEINFO_PATH','PATH_STATE','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_MULTIPATHSTATEINFO_PATH','SURR_KEY','T','integer',32,'NO','nextval(''vpx_multipathstateinfo_path_surr_key_seq''::regclass)');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_NETWORK','DATACENTER_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_NETWORK','ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_NETWORK','NAME','T','character varying',128,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_NETWORK','OPAQUE_ID','T','character varying',128,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_NETWORK','OPAQUE_TYPE','T','character varying',128,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_NIC','DEVICE_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_NIC','DNS_CONFIG','T','text',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_NIC','ENTITY_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_NIC','IP_CONFIG','T','text',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_NIC','IS_CONNECTED','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_NIC','MAC_ADDRESS','T','character varying',20,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_NIC','NET_BIOS_CONFIG','T','text',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_NIC','NETWORK_NAME','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_NIC','SURR_KEY','T','integer',32,'NO','nextval(''vpx_nic_surr_key_seq''::regclass)');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_NW_ASSIGNMENT','ENTITY_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_NW_ASSIGNMENT','NETWORK_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_OBJECT_TYPE','ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_OBJECT_TYPE','NAME','T','character varying',30,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_OPAQUE_NET_BACKING','BACKING_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_OPAQUE_NET_BACKING','OPAQUE_NETWORK_ID','T','character varying',128,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_OPAQUE_NET_BACKING','OPAQUE_NETWORK_TYPE','T','character varying',128,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_OPAQUE_NET_BACKING','UPDATE_KEY','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_OPAQUE_NET_BACKING','VM_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_OVFENV','ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_OVFENV','PRIVATE_OVFENV','T','text',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_OVFENV','PUBLIC_OVFENV','T','text',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_PARAMETER','NAME','T','character varying',255,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_PARAMETER','VALUE','T','text',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_PRIV_ROLE','PRIV_NAME','T','character varying',255,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_PRIV_ROLE','ROLE_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_PRIV_ROLE','SURR_KEY','T','integer',32,'NO','nextval(''vpx_priv_role_surr_key_seq''::regclass)');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_PROC_LOG','CHK_FLAG','T','character',1,'NO','''N''::bpchar');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_PROC_LOG','CHK_RESULTS','T','character varying',200,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_PROC_LOG','DESCRIPTION','T','character varying',1000,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_PROC_LOG','END_DT','T','timestamp without time zone',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_PROC_LOG','ERR_FLAG','T','character',1,'NO','''N''::bpchar');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_PROC_LOG','PROC_NAME','T','character varying',50,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_PROC_LOG','SRC_ROWS','T','numeric',38,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_PROC_LOG','START_DT','T','timestamp without time zone',-1,'NO','timezone(''UTC''::text, now())');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_PROC_LOG','TGT_ROWS','T','numeric',38,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_PRODUCT','PRODUCT_DESC','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_PRODUCT','PRODUCT_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_PROFILE','COMPLIANCE_STATUS','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_PROFILE','CONFIG_INFO','T','text',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_PROFILE','CREATED_TIME','T','timestamp without time zone',-1,'NO','now()');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_PROFILE','MODIFIED_TIME','T','timestamp without time zone',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_PROFILE','PROFILE_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_PROFILE','PROFILE_NAME','T','character varying',512,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_PROFILE','TYPE_CODE','T','numeric',3,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_PROFILE_ANSWER_FILE','ANSWERFILE_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_PROFILE_ANSWER_FILE','CREATED_TIME','T','timestamp without time zone',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_PROFILE_ANSWER_FILE','HOST_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_PROFILE_ANSWER_FILE','MODIFIED_TIME','T','timestamp without time zone',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_PROFILE_ANSWER_FILE','STATUS','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_PROFILE_ANSWER_FILE','USER_INPUT','T','text',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_PROFILE_ENTITY_ASSOCIATION','ENTITY_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_PROFILE_ENTITY_ASSOCIATION','PROFILE_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_PSA_ADAPTER','HBA_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_PSA_ADAPTER','HOST_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_PSA_ADAPTER','ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_PSA_ADAPTER','KEY_VAL','T','character varying',512,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_PSA_ADAPTER','LINK_KEY','T','character varying',512,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_PSA_DEVICE','HOST_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_PSA_DEVICE','ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_PSA_DEVICE','KEY_VAL','T','character varying',512,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_PSA_DEVICE','LINK_KEY','T','character varying',512,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_PSA_DEVICE','SCSI_LUN_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_PSA_PATH','ADAPTER_LINK_KEY','T','character varying',512,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_PSA_PATH','HBA_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_PSA_PATH','HOST_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_PSA_PATH','KEY_VAL','T','character varying',440,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_PSA_PATH','LUN_LINK_KEY','T','character varying',512,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_PSA_PATH','LUN_NUMBER','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_PSA_PATH','PATH_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_PSA_PATH','SCSI_LUN_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_PSA_PATH','TARGET_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_PSA_PATH','TARGET_LINK_KEY','T','character varying',512,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_PSA_TARGET','HOST_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_PSA_TARGET','ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_PSA_TARGET','KEY_VAL','T','character varying',512,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_PSA_TARGET_TRANSPORT','HOST_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_PSA_TARGET_TRANSPORT','ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_PSA_TARGET_TRANSPORT','UPDATE_KEY','T','character varying',512,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_REMOTE_CNX','API_VERSION','T','character varying',80,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_REMOTE_CNX','CNX_TYPE','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_REMOTE_CNX','CONNECT_STATE','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_REMOTE_CNX','HOST_NAME','T','character varying',255,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_REMOTE_CNX','ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_REMOTE_CNX','PASSWORD','T','character varying',686,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_REMOTE_CNX','PORT','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_REMOTE_CNX','SAMLTOKEN','T','text',-1,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_REMOTE_CNX','SESSION_ID','T','character varying',80,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_REMOTE_CNX','SSL','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_REMOTE_CNX','SSL_THUMBPRINT','T','character varying',255,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_REMOTE_CNX','STATE_DATA','T','text',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_REMOTE_CNX','USER_NAME','T','character varying',255,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_REMOTE_CNX','WFU_VERSION','T','character varying',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_REMOTE_CNX_LISTENER','FILTER_REF','T','character varying',255,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_REMOTE_CNX_LISTENER','HOST_CNX_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_REMOTE_CNX_LISTENER','STATE_DATA','T','text',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_REMOTE_CNX_LISTENER','TYPE_NAME','T','character varying',255,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_RESOURCE_POOL','ALLOCATED_CPU','T','character varying',21,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_RESOURCE_POOL','ALLOCATED_MEM','T','character varying',21,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_RESOURCE_POOL','ALLOCATED_VM_CPU','T','character varying',21,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_RESOURCE_POOL','ALLOCATED_VM_MEM','T','character varying',21,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_RESOURCE_POOL','AVAILABLE_POOL_CPU','T','character varying',21,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_RESOURCE_POOL','AVAILABLE_POOL_MEM','T','character varying',21,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_RESOURCE_POOL','AVAILABLE_VM_CPU','T','character varying',21,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_RESOURCE_POOL','AVAILABLE_VM_MEM','T','character varying',21,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_RESOURCE_POOL','CONFIG_SPEC','T','text',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_RESOURCE_POOL','CURRENT_CPU','T','character varying',21,'YES',null);
 /
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_RESOURCE_POOL','CURRENT_MEM','T','character varying',21,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_RESOURCE_POOL','FOLDER_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_RESOURCE_POOL','HOSTD_ID_VAL','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_RESOURCE_POOL','ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_RESOURCE_POOL','MANAGED_BY_EXT_KEY','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_RESOURCE_POOL','MANAGED_BY_TYPE','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_RESOURCE_POOL','OVERALL_STATUS','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_RESOURCE_POOL','VAPP_CONFIG','T','text',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ROLE','ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_ROLE','NAME','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SAMPLE','ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SAMPLE','SAMPLE_INTERVAL','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SAMPLE','SAMPLE_TIME','T','timestamp without time zone',-1,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SAMPLE_TIME1','PARTITION_INDEX','T','numeric',3,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SAMPLE_TIME1','PARTITION_INDEX_HS2','T','numeric',3,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SAMPLE_TIME1','ROLLUP_COUNTER','T','numeric',38,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SAMPLE_TIME1','SAMPLE_INTERVAL','T','numeric',10,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SAMPLE_TIME1','SAMPLE_TIME','T','timestamp without time zone',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SAMPLE_TIME1','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SAMPLE_TIME2','PARTITION_INDEX','T','numeric',3,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SAMPLE_TIME2','PARTITION_INDEX_HS3','T','numeric',3,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SAMPLE_TIME2','ROLLUP_COUNTER','T','numeric',38,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SAMPLE_TIME2','SAMPLE_INTERVAL','T','numeric',10,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SAMPLE_TIME2','SAMPLE_TIME','T','timestamp without time zone',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SAMPLE_TIME2','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SAMPLE_TIME3','PARTITION_INDEX','T','numeric',3,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SAMPLE_TIME3','PARTITION_INDEX_HS4','T','numeric',3,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SAMPLE_TIME3','ROLLUP_COUNTER','T','numeric',38,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SAMPLE_TIME3','SAMPLE_INTERVAL','T','numeric',10,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SAMPLE_TIME3','SAMPLE_TIME','T','timestamp without time zone',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SAMPLE_TIME3','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SAMPLE_TIME4','PARTITION_INDEX','T','numeric',3,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SAMPLE_TIME4','ROLLUP_COUNTER','T','numeric',38,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SAMPLE_TIME4','SAMPLE_INTERVAL','T','numeric',10,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SAMPLE_TIME4','SAMPLE_TIME','T','timestamp without time zone',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SAMPLE_TIME4','TIME_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SCHED_ACTION','ACTION_DATA','T','text',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SCHED_ACTION','ACTION_TYPE','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SCHED_ACTION','SCHEDULEDTASK_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SCHED_SCHEDULER','ACTIVE_TIME','T','timestamp without time zone',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SCHED_SCHEDULER','EXPIRE_TIME','T','timestamp without time zone',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SCHED_SCHEDULER','INTERVAL','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SCHED_SCHEDULER','RUN_AT','T','timestamp without time zone',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SCHED_SCHEDULER','SCHEDULE_DAY','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SCHED_SCHEDULER','SCHEDULE_FRIDAY','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SCHED_SCHEDULER','SCHEDULE_HOUR','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SCHED_SCHEDULER','SCHEDULE_MINUTE','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SCHED_SCHEDULER','SCHEDULE_MONDAY','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SCHED_SCHEDULER','SCHEDULE_SATURDAY','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SCHED_SCHEDULER','SCHEDULE_SUNDAY','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SCHED_SCHEDULER','SCHEDULE_THURSDAY','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SCHED_SCHEDULER','SCHEDULE_TUESDAY','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SCHED_SCHEDULER','SCHEDULE_WEDNESDAY','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SCHED_SCHEDULER','SCHEDULEDTASK_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SCHED_SCHEDULER','SCHEDULER_TYPE','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SCHEDULEDTASK','COMPLETE_STATE','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SCHEDULEDTASK','DESCRIPTION','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SCHEDULEDTASK','ENABLED','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SCHEDULEDTASK','ENTITY_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SCHEDULEDTASK','ENTITY_TYPE','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SCHEDULEDTASK','ERROR_DATA','T','text',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SCHEDULEDTASK','LASTMODIFIEDTIME','T','timestamp without time zone',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SCHEDULEDTASK','LASTMODIFIEDUSER','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SCHEDULEDTASK','NAME','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SCHEDULEDTASK','NEXTRUNTIME','T','timestamp without time zone',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SCHEDULEDTASK','NOTIFICATION','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SCHEDULEDTASK','OBJECT_MOID','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SCHEDULEDTASK','PREVRUNTIME','T','timestamp without time zone',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SCHEDULEDTASK','RESULT_DATA','T','text',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SCHEDULEDTASK','SCHEDULEDTASK_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SCHEDULEDTASK','TASK_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SCHEMA_HASH','BUILD_NUM','T','character varying',30,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SCHEMA_HASH','SCHEMA_HASH','T','character varying',50,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SCSI_DISK_PARTITION','DISK_NAME','T','character varying',2000,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SCSI_DISK_PARTITION','HOST_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SCSI_DISK_PARTITION','VPX_FILE_SYSTEM_MOUNT_INFO_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SCSI_LUN','ARRAY_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SCSI_LUN','CANONICAL_NAME','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SCSI_LUN','DISPLAY_NAME','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SCSI_LUN','HOST_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SCSI_LUN','ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SCSI_LUN','KEY_VAL','T','character varying',512,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SCSI_LUN','UPDATE_DISPLAY_NAME_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SCSI_LUN','UUID','T','character varying',255,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SCSI_LUN','VPX_TYPE','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SCSILUN_DESCRIPTOR','DESCRIPTOR_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SCSILUN_DESCRIPTOR','DESCRIPTOR_ID_VAL','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SCSILUN_DESCRIPTOR','HOST_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SCSILUN_DESCRIPTOR','ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SCSILUN_DESCRIPTOR','QUALITY','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SCSILUN_DESCRIPTOR','UPDATE_KEY','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SDRS_POD_CONFIG','CONFIG_XML','T','text',-1,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SDRS_POD_CONFIG','POD_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SDRS_STATS_DATASTORE','HISTORY','T','text',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SDRS_STATS_DATASTORE','INJECTOR','T','text',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SDRS_STATS_DATASTORE','QUANTILES','T','text',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SDRS_STATS_DATASTORE','UUID','T','character varying',64,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SDRS_STATS_VM','HISTORY','T','text',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SDRS_STATS_VM','QUANTILES','T','text',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SDRS_STATS_VM','SPACE_STATS','T','text',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SDRS_STATS_VM','VM_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SEQUENCE','ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SEQUENCE','NAME','T','character varying',30,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','ALTERNATE_GUEST_NAME','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','ANNOTATION','T','character varying',2000,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','ARRAY_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','BOOT_OPTION_BOOT_DELAY','T','character varying',22,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','BOOT_OPTION_RETRY_DELAY','T','numeric',22,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','BOOT_OPTION_RETRY_ENABLED_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','BOOT_OPTIONENTER_BIOSSETUP_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','C_ALLOC_EXPANDABLE_RESERV_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','CHANGE_TRACKING_ENABLED','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','CHANGE_VERSION','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','CONPREFE_CL_PO_SUSPEND_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','CONPREFE_POWERONWHENOPENED_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','CONPREFE_SCR_POWER_ON_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','CPU_ALLOCATION_LIMIT','T','character varying',22,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','CPU_ALLOCATION_OVERHEAD_LIMIT','T','character varying',22,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','CPU_ALLOCATION_RESERVATION','T','character varying',22,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','CPU_ALLOCATION_SHARES_LEVEL','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','CPU_ALLOCATION_SHARES_SHARES','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','CPU_HOT_ADD_ENABLED','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','CPU_HOT_REMOVE_ENABLED','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','DEF_PO_O_DEF_POWER_OFF_TYPE','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','DEF_PO_O_DEFAULT_SUSPEND_TYPE','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','DEF_PO_OPS_DEFAULT_RESET_TYPE','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','DEF_POWER_OPS_POWER_OFF_TYPE','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','DEF_POWER_OPS_STANDBY_ACTION','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','DEF_POWER_OPS_SUSPEND_TYPE','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','DEFAULT_POWER_OPS_RESET_TYPE','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','DISABLE_ACCELERATION_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','DISK_UUID_ENABLED_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','ENABLE_LOGGING_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','FAULT_TOLERANCE_TYPE','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','FILES_FTMETADATA_DIRECTORY','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','FILES_LOG_DIRECTORY','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','FILES_SNAPSHOT_DIRECTORY','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','FILES_SUSPEND_DIRECTORY','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','FILES_VM_PATH_NAME','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','FIRMWARE','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','FL_SNAPSHOT_POWER_OFF_BEHAVIOR','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','FLAGS_MONITOR_TYPE','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','FORK_CHILD_GROUP_ID','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','FORK_CHILD_TYPE','T','character varying',15,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','FORK_PARENT_ENABLED','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','GUEST_AUTOLOCK_ENABLED','T','numeric',1,'YES','0');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','GUEST_FULL_NAME','T','character varying',512,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','GUEST_ID','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','H_PLUG_MEMORY_INCREMENT_SIZE','T','character varying',22,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','HARDWARE_CORES','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','HARDWARE_MEMORY','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','HARDWARE_NUM','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','HOT_PLUG_MEMORY_LIMIT','T','character varying',22,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','HT_SHARING','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','INSTANCE_UUID','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','LATENCY_LEVEL','T','character varying',22,'YES','''normal''::character varying');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','LATENCY_SENSITIVITY','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','LOCATION_ID','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','MANAGED_BY_EXT_KEY','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','MANAGED_BY_TYPE','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','MAX_MKS_CONNECTIONS','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','MEM_ALLOCATION_OVERHEAD_LIMIT','T','character varying',22,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','MEM_ALLOCATION_SHARES_LEVEL','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','MEM_ALLOCATION_SHARES_SHARES','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','MEM_ALLOCEXPAN_RESERVATION_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','MEM_HOT_ADD_ENABLED','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','MEM_RES_LOCKED_MAX','T','numeric',1,'YES','0');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','MEMORY_ALLOCATION_LIMIT','T','character varying',22,'YES',null);
 /
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','MEMORY_ALLOCATION_RESERVATION','T','character varying',22,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','MODIFIED','T','timestamp without time zone',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','NAME','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','NESTED_HV_ENABLED','T','numeric',1,'YES','0');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','NETWORK_SHAPER_AVERAGE_BPS','T','character varying',22,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','NETWORK_SHAPER_BURST_SIZE','T','character varying',22,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','NETWORK_SHAPER_ENABLED_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','NETWORK_SHAPER_PEAK_BPS','T','character varying',22,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','NPIV_DESIRED_NWWN','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','NPIV_DESIRED_PWWN','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','NPIV_ON_RDM','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','NPIV_TEMP_DISABLED','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','NPIV_WORLD_WIDE_NAME_TYPE','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','PRESERVED_SWAP_ONPOWEROFF_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','RECORD_REPLAY_ENABLED_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','RUN_WITH_DEBUG_INFO_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','SCHED_HW_UPGRADE_POLICY','T','character varying',22,'YES','''never''::character varying');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','SCHED_HW_UPGRADE_STATUS','T','character varying',22,'YES','''none''::character varying');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','SCHED_HW_UPGRADE_VERSION','T','character varying',22,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','SNAPSHOT_DISABLED_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','SNAPSHOT_LOCKED_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','SWAP_DIR','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','SWAP_OBJECTID','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','SWAP_PLACEMENT','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','TEMPLATE_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','TOOLS_AFTER_POWER_ON_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','TOOLS_AFTER_RESUME_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','TOOLS_BEFORE_GUEST_REBOOT_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','TOOLS_BEFORE_GUEST_STANDBY_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','TOOLS_BEFORE_GUESTSHUTDOWN_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','TOOLS_LASTINSTALL_COUNTER','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','TOOLS_PENDING_CUSTOMIZATION','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','TOOLS_SYNC_TIME_WITH_HOST_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','TOOLS_TOOLS_UPGRADE_POLICY','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','TOOLS_TOOLS_VERSION','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','USE_TOE_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','UUID','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','VASSERTS_ENABLED','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','VERSION','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','VIRTUAL_EXEC_USAGE','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','VIRTUAL_ICH7M_PRESENT','T','numeric',1,'YES','0');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','VIRTUAL_MMU_USAGE','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','VIRTUAL_PMC_ENABLED','T','numeric',1,'YES','0');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','VIRTUAL_SMC_PRESENT','T','numeric',1,'YES','0');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_CONFIG_INFO','VM_OBJECTID','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_DISTR_VPORT_BACKING','BACKING_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_DISTR_VPORT_BACKING','HARD_DEV_BAC_PO_CONNE_COOKIE','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_DISTR_VPORT_BACKING','HARD_DEV_BAC_PO_PORTGROUP_KEY','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_DISTR_VPORT_BACKING','HARD_DEV_BAC_PORT_SWITCH_UUID','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_DISTR_VPORT_BACKING','HARD_DEV_BACKING_PORT_PORT_KEY','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_DISTR_VPORT_BACKING','SN_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_DISTR_VPORT_BACKING','UPDATE_KEY','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_OPAQUE_NET_BACKING','BACKING_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_OPAQUE_NET_BACKING','OPAQUE_NETWORK_ID','T','character varying',128,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_OPAQUE_NET_BACKING','OPAQUE_NETWORK_TYPE','T','character varying',128,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_OPAQUE_NET_BACKING','SN_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_OPAQUE_NET_BACKING','UPDATE_KEY','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VD_DEVICE_BACKING_X','ARRAY_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VD_DEVICE_BACKING_X','BACKING_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VD_DEVICE_BACKING_X','DEV_BAC_HO_POIN_DEVICE','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VD_DEVICE_BACKING_X','DEV_BAC_I_PASST_MODE','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VD_DEVICE_BACKING_X','DEVICE_BACKING_DEVICE_ID_VAL','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VD_DEVICE_BACKING_X','DEVICE_BACKING_EXCLUSIVE','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VD_DEVICE_BACKING_X','DEVICE_BACKING_SYSTEM_ID_VAL','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VD_DEVICE_BACKING_X','HARD_DEV_BAC_DESCR_FILE_NAME','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VD_DEVICE_BACKING_X','NETWORK_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VD_DEVICE_BACKING_X','PCI_ID_VAL','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VD_DEVICE_BACKING_X','SN_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VD_DEVICE_BACKING_X','UPDATE_KEY','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VD_DEVICE_BACKING_X','VENDOR_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VDEVICE_BACKING_REL','BACKING_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VDEVICE_BACKING_REL','CHANGE_ID','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VDEVICE_BACKING_REL','DEVICE_NAME','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VDEVICE_BACKING_REL','SN_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VDEVICE_BACKING_REL','UPDATE_KEY','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VDEVICE_BACKING_REL','UUID','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VDEVICE_BACKING_REL','VDEVICE_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VDEVICE_BACKING_REL','VPX_TYPE','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VDEVICE_DEVICE_BACKING','BACKING_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VDEVICE_DEVICE_BACKING','SN_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VDEVICE_DEVICE_BACKING','UPDATE_KEY','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VDEVICE_DEVICE_BACKING','VDEV_USE_AUTO_DETECT_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VDEVICE_FILE_BACKING','BACKING_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VDEVICE_FILE_BACKING','BACKING_OBJECT_ID','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VDEVICE_FILE_BACKING','DATASTORE_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VDEVICE_FILE_BACKING','FILE_BACKING_CONTENT_ID','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VDEVICE_FILE_BACKING','FILE_BACKING_PARENT_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VDEVICE_FILE_BACKING','HARD_DEVICE_BACKING_FILE_NAME','T','character varying',2000,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VDEVICE_FILE_BACKING','SNAPSHOT_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VDEVICE_FILE_BACKING','UPDATE_KEY','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VDEVICE_FILE_BACKING_X','BACKING_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VDEVICE_FILE_BACKING_X','DELTA_DISK_FORMAT','T','character varying',50,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VDEVICE_FILE_BACKING_X','DELTA_DISK_FORMAT_VARIANT','T','character varying',50,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VDEVICE_FILE_BACKING_X','DELTA_GRAIN_SIZE','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VDEVICE_FILE_BACKING_X','DEV_BAC_COMPAT_MODE','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VDEVICE_FILE_BACKING_X','DEV_BAC_THIN_PROVISIONED_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VDEVICE_FILE_BACKING_X','DEV_BACKING_SPACE_USED_IN','T','character varying',22,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VDEVICE_FILE_BACKING_X','DEV_BACKING_SPLIT_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VDEVICE_FILE_BACKING_X','DEV_BACKING_WRITE_THROUGH_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VDEVICE_FILE_BACKING_X','DEVICE_BACKING_DISK_MODE','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VDEVICE_FILE_BACKING_X','DEVICE_BACKING_LUN_UUID','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VDEVICE_FILE_BACKING_X','DEVICE_BACKING_UUID','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VDEVICE_FILE_BACKING_X','DIGEST_ENABLED','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VDEVICE_FILE_BACKING_X','EAGERLY_SCRUB','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VDEVICE_FILE_BACKING_X','GRAIN_SIZE','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VDEVICE_FILE_BACKING_X','SN_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VDEVICE_FILE_BACKING_X','UPDATE_KEY','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VDEVICE_PIPE_BACKING','BACKING_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VDEVICE_PIPE_BACKING','BACKING_NO_RX_LOSS_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VDEVICE_PIPE_BACKING','HARD_DEVICE_BACKING_ENDPOINT','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VDEVICE_PIPE_BACKING','HARD_DEVICE_BACKING_PIPE_NAME','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VDEVICE_PIPE_BACKING','SN_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VDEVICE_PIPE_BACKING','UPDATE_KEY','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VDEVICE_PLUGIN_BACKING','BACKING_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VDEVICE_PLUGIN_BACKING','SN_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VDEVICE_PLUGIN_BACKING','UPDATE_KEY','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VDEVICE_PLUGIN_BACKING','VDEV_PLUGIN_VGPU','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VIRTUAL_CONTROLLER','ARRAY_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VIRTUAL_CONTROLLER','HARDWARE_DEVICE_BUS_NUMBER','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VIRTUAL_CONTROLLER','SN_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VIRTUAL_CONTROLLER','UPDATE_KEY','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VIRTUAL_CONTROLLER','VDEVICE_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VIRTUAL_DEVICE','CONNE_AL_GU_CONTROL_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VIRTUAL_DEVICE','CONNE_START_CONNECTED_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VIRTUAL_DEVICE','CONNECTABLE_CONNECTED_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VIRTUAL_DEVICE','CONNECTION_STATUS','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VIRTUAL_DEVICE','DEVICE_CONTROLLER_KEY','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VIRTUAL_DEVICE','DEVICE_ELEMENT_INFO_KEY','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VIRTUAL_DEVICE','DEVICE_INFO_LABEL','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VIRTUAL_DEVICE','DEVICE_INFO_SUMMARY','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VIRTUAL_DEVICE','DEVICE_KEY','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VIRTUAL_DEVICE','DEVICE_METHOD_INFO_KEY','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VIRTUAL_DEVICE','DEVICE_TYPE_INFO_KEY','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VIRTUAL_DEVICE','DEVICE_UNIT_NUMBER','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VIRTUAL_DEVICE','HARD_DEV_DEVICE_INFO_FREQUENCY','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VIRTUAL_DEVICE','ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VIRTUAL_DEVICE','VDEVICE_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VIRTUAL_DEVICE','VPX_TYPE','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VIRTUAL_DISK','ARRAY_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VIRTUAL_DISK','CAPACITY_IN_BYTES','T','character varying',42,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VIRTUAL_DISK','DISK_OBJECT_ID','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VIRTUAL_DISK','HARDWARE_DEVICE_CAPACITY_IN','T','character varying',22,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VIRTUAL_DISK','HARDWARE_DEVICE_SHARES_LEVEL','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VIRTUAL_DISK','HARDWARE_DEVICE_SHARES_SHARES','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VIRTUAL_DISK','IORM_LIMIT','T','numeric',22,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VIRTUAL_DISK','IORM_RESERVATION','T','numeric',22,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VIRTUAL_DISK','IORM_SHARES_LEVEL','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VIRTUAL_DISK','IORM_SHARES_SHARES','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VIRTUAL_DISK','SN_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VIRTUAL_DISK','UPDATE_KEY','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VIRTUAL_DISK','VDEVICE_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VIRTUAL_DISK','VFLASH_CACHE_BLOCK_SIZE','T','numeric',22,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VIRTUAL_DISK','VFLASH_CACHE_CONSISTENCY_TYPE','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VIRTUAL_DISK','VFLASH_CACHE_MODE','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VIRTUAL_DISK','VFLASH_CACHE_MODULE','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VIRTUAL_DISK','VFLASH_CACHE_RESERVATION','T','numeric',22,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VIRTUAL_ETHERNET_CARD','DEV_WAKE_ON_LAN_ENABLED_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VIRTUAL_ETHERNET_CARD','DEVICE_ADDRESS_TYPE','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VIRTUAL_ETHERNET_CARD','DEVICE_EXTERNAL_ID','T','character varying',100,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VIRTUAL_ETHERNET_CARD','DEVICE_MAC_ADDRESS','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VIRTUAL_ETHERNET_CARD','NET_ALLOCATION_LIMIT','T','character varying',22,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VIRTUAL_ETHERNET_CARD','NET_ALLOCATION_RESERVATION','T','character varying',22,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VIRTUAL_ETHERNET_CARD','NET_ALLOCATION_SHARES_LEVEL','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VIRTUAL_ETHERNET_CARD','NET_ALLOCATION_SHARES_SHARES','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VIRTUAL_ETHERNET_CARD','SN_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VIRTUAL_ETHERNET_CARD','UPDATE_KEY','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VIRTUAL_ETHERNET_CARD','VDEVICE_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VIRTUAL_SATACONTROLLER','SN_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VIRTUAL_SATACONTROLLER','UPDATE_KEY','T','integer',32,'YES',null);
 /
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VIRTUAL_SATACONTROLLER','VDEVICE_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VIRTUAL_SCSICONTROLLER','HARD_DEV_SCSI_CTLR_UNIT_NUMBER','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VIRTUAL_SCSICONTROLLER','HARDWARE_DEVICE_SHARED_BUS','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VIRTUAL_SCSICONTROLLER','HOT_ADD_REMOVE_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VIRTUAL_SCSICONTROLLER','SN_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VIRTUAL_SCSICONTROLLER','UPDATE_KEY','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VIRTUAL_SCSICONTROLLER','VDEVICE_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VIRTUAL_SERIAL_PORT','SN_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VIRTUAL_SERIAL_PORT','UPDATE_KEY','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VIRTUAL_SERIAL_PORT','VDEVICE_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VIRTUAL_SERIAL_PORT','YIELD_ON_POLL_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VIRTUAL_USB','ARRAY_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VIRTUAL_USB','CONNECTED_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VIRTUAL_USB','PRODUCT_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VIRTUAL_USB','SN_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VIRTUAL_USB','UPDATE_KEY','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VIRTUAL_USB','VDEVICE_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VIRTUAL_USB','VENDOR_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VIRTUAL_USBCONTROLLER','AUTO_CONNECT_DEVICES_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VIRTUAL_USBCONTROLLER','EHCI_ENABLED_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VIRTUAL_USBCONTROLLER','SN_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VIRTUAL_USBCONTROLLER','UPDATE_KEY','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VIRTUAL_USBCONTROLLER','VDEVICE_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VIRTUAL_VIDEO_CARD','ENABLE_MPT_SUPPORT_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VIRTUAL_VIDEO_CARD','ENABLE3_DSUPPORT_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VIRTUAL_VIDEO_CARD','GUEST_MEMORY_FOR_3D_SIZE','T','numeric',22,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VIRTUAL_VIDEO_CARD','HARD_DEVICE_VIDEO_RAM_SIZE_IN','T','character varying',22,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VIRTUAL_VIDEO_CARD','NUM_DISPLAYS','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VIRTUAL_VIDEO_CARD','SN_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VIRTUAL_VIDEO_CARD','UPDATE_KEY','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VIRTUAL_VIDEO_CARD','USE_3D_RENDERER','T','character varying',22,'YES','''automatic''::character varying');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VIRTUAL_VIDEO_CARD','USE_AUTO_DETECT_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VIRTUAL_VIDEO_CARD','VDEVICE_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VIRTUAL_VMCIDEVICE','ALLOW_UNREST_COMM','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VIRTUAL_VMCIDEVICE','FILTER_ENABLE','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VIRTUAL_VMCIDEVICE','HARDWARE_DEVICE_ID_VAL','T','character varying',22,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VIRTUAL_VMCIDEVICE','SN_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VIRTUAL_VMCIDEVICE','UPDATE_KEY','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VIRTUAL_VMCIDEVICE','VDEVICE_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VSRIOV_ETHERNET_CARD','DEV_ALLOW_GUEST_MTU_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VSRIOV_ETHERNET_CARD','PF_DEVICE_ID','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VSRIOV_ETHERNET_CARD','PF_PCI_ID','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VSRIOV_ETHERNET_CARD','PF_SYSTEM_ID','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VSRIOV_ETHERNET_CARD','PF_VENDOR_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VSRIOV_ETHERNET_CARD','SN_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VSRIOV_ETHERNET_CARD','UPDATE_KEY','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VSRIOV_ETHERNET_CARD','VDEVICE_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VSRIOV_ETHERNET_CARD','VF_DEVICE_ID','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VSRIOV_ETHERNET_CARD','VF_INDEX','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VSRIOV_ETHERNET_CARD','VF_PCI_ID','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VSRIOV_ETHERNET_CARD','VF_SYSTEM_ID','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SN_VSRIOV_ETHERNET_CARD','VF_VENDOR_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SNAPSHOT','CONFIG','T','text',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SNAPSHOT','CREATE_TIME','T','timestamp without time zone',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SNAPSHOT','HOST_SNAPSHOT_ID','T','character varying',500,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SNAPSHOT','ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SNAPSHOT','IS_CURRENT_SNAPSHOT','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SNAPSHOT','IS_QUIESCED','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SNAPSHOT','PARENT_SNAPSHOT_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SNAPSHOT','POWER_STATE','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SNAPSHOT','SNAPSHOT_DESC','T','text',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SNAPSHOT','SNAPSHOT_NAME','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SNAPSHOT','SNAPSHOT_UID','T','integer',32,'NO','(-1)');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_SNAPSHOT','VM_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_STAT_COUNTER','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_STAT_COUNTER','DEVICE_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_STAT_COUNTER','ENTITY_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_STAT_COUNTER','STAT_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_STAT_COUNTER','STAT_LEVEL','T','numeric',2,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_STAT_DEF','ASSOCIATE_IDS','T','character varying',128,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_STAT_DEF','DEFAULT_LEVEL_SET','T','numeric',1,'NO','1');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_STAT_DEF','FIXED_COLLECTION_INTERVAL','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_STAT_DEF','GROUP_NAME','T','character varying',30,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_STAT_DEF','ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_STAT_DEF','NAME','T','character varying',30,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_STAT_DEF','PERDEVICE_STAT_LEVEL','T','numeric',2,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_STAT_DEF','ROLLUP_TYPE','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_STAT_DEF','STAT_LEVEL','T','numeric',2,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_STAT_DEF','TYPE','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_STAT_DEF','UNIT','T','character varying',30,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_STAT_DEV_TYPE','DEVICE_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_STAT_DEV_TYPE','DEVICE_TYPE_ID','T','numeric',10,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_STAT_DEV_TYPE_DEF','DEVICE_TYPE_ID','T','numeric',10,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_STAT_DEV_TYPE_DEF','DEVICE_TYPE_NAME','T','character varying',255,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_STAT_ID','ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_STAT_ID','MOID','T','character varying',255,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_STAT_INTERVAL_DEF','INTERVAL_DEF_NAME','T','character varying',30,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_STAT_INTERVAL_DEF','INTERVAL_LENGTH','T','numeric',10,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_STAT_INTERVAL_DEF','INTERVAL_SEQ_NUM','T','numeric',2,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_STAT_INTERVAL_DEF','INTERVAL_VAL','T','numeric',10,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_STAT_INTERVAL_DEF','ROLLUP_ENABLED_FLG','T','numeric',1,'NO','1');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_STAT_INTERVAL_DEF','STATS_LEVEL','T','numeric',10,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_STRING_ARRAY','ARRAY_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_STRING_ARRAY','ARRAY_INDEX','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_STRING_ARRAY','MO_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_STRING_ARRAY','MO_TYPE','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_STRING_ARRAY','SURR_KEY','T','integer',32,'NO','nextval(''vpx_string_array_surr_key_seq''::regclass)');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_STRING_ARRAY','TYPE_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_STRING_ARRAY','VALUE','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_TABLE','COL_LEN','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_TABLE','COL_NAME','T','character varying',30,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_TABLE','COL_TYPE','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_TABLE','PK_FLG','T','integer',32,'NO','0');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_TABLE','TABLE_NAME','T','character varying',30,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_TAG','NAME','T','character varying',255,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_TAG','TAG_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_TAG','TYPE_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_TAG_ENT_ASSOCIATION','ENTITY_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_TAG_ENT_ASSOCIATION','TAG_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_TASK','ACTIVATION_ID','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_TASK','ALARM_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_TASK','CANCELLABLE','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_TASK','CANCELLED','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_TASK','CHANGE_TAG_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_TASK','COMPLETE_STATE','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_TASK','COMPLETE_TIME','T','timestamp without time zone',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_TASK','COMPUTERESOURCE_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_TASK','DATACENTER_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_TASK','DESCRIPTION','T','text',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_TASK','DESCRIPTIONID','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_TASK','ENTITY_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_TASK','ENTITY_NAME','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_TASK','ENTITY_TYPE','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_TASK','ERROR_DATA','T','text',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_TASK','EVENT_CHAIN_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_TASK','FOLDER_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_TASK','HOST_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_TASK','LOCKED_DATA','T','text',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_TASK','NAME','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_TASK','PARENT_TASK_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_TASK','PROGRESS','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_TASK','QUEUE_TIME','T','timestamp without time zone',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_TASK','REASON_DATA','T','text',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_TASK','RESOURCEPOOL_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_TASK','RESULT_DATA','T','text',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_TASK','ROOT_TASK_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_TASK','SCHEDULEDTASK_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_TASK','START_TIME','T','timestamp without time zone',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_TASK','TASK_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_TASK','USERNAME','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_TASK','VM_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_TERMINATION_REASON','TERMINATION_DESC','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_TERMINATION_REASON','TERMINATION_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_TEXT_ARRAY','ARRAY_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_TEXT_ARRAY','MO_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_TEXT_ARRAY','MO_TYPE','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_TEXT_ARRAY','SURR_KEY','T','integer',32,'NO','nextval(''vpx_text_array_surr_key_seq''::regclass)');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_TEXT_ARRAY','TYPE_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_TEXT_ARRAY','VALUE','T','text',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_TOPN_PAST_DAY','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_TOPN_PAST_DAY','INTEGRAL_VALUE','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_TOPN_PAST_DAY','SAMPLE_TIME','T','timestamp without time zone',-1,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_TOPN_PAST_MONTH','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_TOPN_PAST_MONTH','INTEGRAL_VALUE','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_TOPN_PAST_MONTH','SAMPLE_TIME','T','timestamp without time zone',-1,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_TOPN_PAST_WEEK','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_TOPN_PAST_WEEK','INTEGRAL_VALUE','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_TOPN_PAST_WEEK','SAMPLE_TIME','T','timestamp without time zone',-1,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_TOPN_PAST_YEAR','COUNTER_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_TOPN_PAST_YEAR','INTEGRAL_VALUE','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_TOPN_PAST_YEAR','SAMPLE_TIME','T','timestamp without time zone',-1,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_TOPN_STATE','SAMPLE_TIME','T','timestamp without time zone',-1,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_TOPN_STATE','TIME_LEVEL','T','numeric',2,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_TOPN_STATISTICS','STAT_ID','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_TYPE_MAP','ARRAY_NUM','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_TYPE_MAP','MO_REF','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_TYPE_MAP','TYPE_NAME','T','character varying',255,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_UPLINK_TEAMING','ACTIVE_UPLINK','T','numeric',1,'NO','0');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_UPLINK_TEAMING','DVPORT_KEY','T','character varying',50,'YES',null);
 /
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_UPLINK_TEAMING','DVPORTGROUP_ID','T','integer',32,'NO','0');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_UPLINK_TEAMING','DVS_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_UPLINK_TEAMING','SURR_KEY','T','integer',32,'NO','nextval(''vpx_uplink_teaming_surr_key_seq''::regclass)');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_UPLINK_TEAMING','UPLINK_INDEX','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_UPLINK_TEAMING','UPLINK_NAME','T','character varying',255,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_UPTIME','BUILD_NUM','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_UPTIME','END_TIME','T','timestamp without time zone',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_UPTIME','HOST_NAME','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_UPTIME','HOST_UUID','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_UPTIME','PROD_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_UPTIME','START_TIME','T','timestamp without time zone',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_UPTIME','SURR_KEY','T','integer',32,'NO','nextval(''vpx_uptime_surr_key_seq''::regclass)');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_UPTIME','TERM_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_USAGE_SAMPLE_TIME','SAMPLE_INTERVAL','T','numeric',10,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_USAGE_SAMPLE_TIME','SAMPLE_TIME','T','timestamp without time zone',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_USAGE_SAMPLE_TIME','TIME_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_USAGE_STAT','COUNTER_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_USAGE_STAT','STAT_VAL','T','numeric',38,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_USAGE_STAT','TIME_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VAPP_LINK','CHILD_ENTITY_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VAPP_LINK','DESTROY_WITH_PARENT','T','numeric',1,'NO','0');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VAPP_LINK','PARENT_VAPP_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VC_UPGRADE_ID','IDENTIFIER','T','character varying',512,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VC_UPGRADE_ID','MO_ID','T','character varying',256,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VC_UPGRADE_ID','REFENTITY','T','character varying',256,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VC_UPGRADE_ID','TYPE_ID','T','character varying',512,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VDEVICE_BACKING_REL','BACKING_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VDEVICE_BACKING_REL','CHANGE_ID','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VDEVICE_BACKING_REL','DEVICE_NAME','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VDEVICE_BACKING_REL','UPDATE_KEY','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VDEVICE_BACKING_REL','UUID','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VDEVICE_BACKING_REL','VDEVICE_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VDEVICE_BACKING_REL','VM_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VDEVICE_BACKING_REL','VPX_TYPE','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VDEVICE_DEVICE_BACKING','BACKING_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VDEVICE_DEVICE_BACKING','UPDATE_KEY','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VDEVICE_DEVICE_BACKING','VDEV_USE_AUTO_DETECT_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VDEVICE_DEVICE_BACKING','VM_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VDEVICE_DEVICE_BACKING_X','ARRAY_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VDEVICE_DEVICE_BACKING_X','BACKING_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VDEVICE_DEVICE_BACKING_X','DEV_BAC_HO_POIN_DEVICE','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VDEVICE_DEVICE_BACKING_X','DEV_BAC_I_PASST_MODE','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VDEVICE_DEVICE_BACKING_X','DEVICE_BACKING_DEVICE_ID_VAL','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VDEVICE_DEVICE_BACKING_X','DEVICE_BACKING_EXCLUSIVE','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VDEVICE_DEVICE_BACKING_X','DEVICE_BACKING_SYSTEM_ID_VAL','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VDEVICE_DEVICE_BACKING_X','HARD_DEV_BAC_DESCR_FILE_NAME','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VDEVICE_DEVICE_BACKING_X','NETWORK_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VDEVICE_DEVICE_BACKING_X','PCI_ID_VAL','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VDEVICE_DEVICE_BACKING_X','UPDATE_KEY','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VDEVICE_DEVICE_BACKING_X','VENDOR_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VDEVICE_DEVICE_BACKING_X','VM_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VDEVICE_FILE_BACKING','BACKING_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VDEVICE_FILE_BACKING','BACKING_OBJECT_ID','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VDEVICE_FILE_BACKING','DATASTORE_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VDEVICE_FILE_BACKING','FILE_BACKING_CONTENT_ID','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VDEVICE_FILE_BACKING','FILE_BACKING_PARENT_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VDEVICE_FILE_BACKING','HARD_DEVICE_BACKING_FILE_NAME','T','character varying',2000,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VDEVICE_FILE_BACKING','UPDATE_KEY','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VDEVICE_FILE_BACKING','VM_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VDEVICE_FILE_BACKING_X','BACKING_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VDEVICE_FILE_BACKING_X','DELTA_DISK_FORMAT','T','character varying',50,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VDEVICE_FILE_BACKING_X','DELTA_DISK_FORMAT_VARIANT','T','character varying',50,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VDEVICE_FILE_BACKING_X','DELTA_GRAIN_SIZE','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VDEVICE_FILE_BACKING_X','DEV_BAC_COMPAT_MODE','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VDEVICE_FILE_BACKING_X','DEV_BAC_THIN_PROVISIONED_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VDEVICE_FILE_BACKING_X','DEV_BACKING_SPACE_USED_IN','T','character varying',22,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VDEVICE_FILE_BACKING_X','DEV_BACKING_SPLIT_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VDEVICE_FILE_BACKING_X','DEV_BACKING_WRITE_THROUGH_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VDEVICE_FILE_BACKING_X','DEVICE_BACKING_DISK_MODE','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VDEVICE_FILE_BACKING_X','DEVICE_BACKING_LUN_UUID','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VDEVICE_FILE_BACKING_X','DEVICE_BACKING_UUID','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VDEVICE_FILE_BACKING_X','DIGEST_ENABLED','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VDEVICE_FILE_BACKING_X','EAGERLY_SCRUB','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VDEVICE_FILE_BACKING_X','GRAIN_SIZE','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VDEVICE_FILE_BACKING_X','UPDATE_KEY','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VDEVICE_FILE_BACKING_X','VM_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VDEVICE_PIPE_BACKING','BACKING_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VDEVICE_PIPE_BACKING','BACKING_NO_RX_LOSS_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VDEVICE_PIPE_BACKING','HARD_DEVICE_BACKING_ENDPOINT','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VDEVICE_PIPE_BACKING','HARD_DEVICE_BACKING_PIPE_NAME','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VDEVICE_PIPE_BACKING','UPDATE_KEY','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VDEVICE_PIPE_BACKING','VM_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VDEVICE_PLUGIN_BACKING','BACKING_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VDEVICE_PLUGIN_BACKING','UPDATE_KEY','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VDEVICE_PLUGIN_BACKING','VDEV_PLUGIN_VGPU','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VDEVICE_PLUGIN_BACKING','VM_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VERSION','VER_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VERSION','VERSION_VALUE','T','character varying',30,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_CONTROLLER','ARRAY_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_CONTROLLER','HARDWARE_DEVICE_BUS_NUMBER','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_CONTROLLER','UPDATE_KEY','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_CONTROLLER','VDEVICE_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_CONTROLLER','VM_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_DEVICE','CONNE_AL_GU_CONTROL_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_DEVICE','CONNE_START_CONNECTED_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_DEVICE','CONNECTABLE_CONNECTED_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_DEVICE','CONNECTION_STATUS','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_DEVICE','DEVICE_CONTROLLER_KEY','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_DEVICE','DEVICE_ELEMENT_INFO_KEY','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_DEVICE','DEVICE_INFO_LABEL','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_DEVICE','DEVICE_INFO_SUMMARY','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_DEVICE','DEVICE_KEY','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_DEVICE','DEVICE_METHOD_INFO_KEY','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_DEVICE','DEVICE_TYPE_INFO_KEY','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_DEVICE','DEVICE_UNIT_NUMBER','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_DEVICE','HARD_DEV_DEVICE_INFO_FREQUENCY','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_DEVICE','ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_DEVICE','VDEVICE_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_DEVICE','VPX_TYPE','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_DISK','ARRAY_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_DISK','CAPACITY_IN_BYTES','T','character varying',42,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_DISK','DISK_OBJECT_ID','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_DISK','HARDWARE_DEVICE_CAPACITY_IN','T','character varying',22,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_DISK','HARDWARE_DEVICE_SHARES_LEVEL','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_DISK','HARDWARE_DEVICE_SHARES_SHARES','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_DISK','IORM_LIMIT','T','numeric',22,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_DISK','IORM_RESERVATION','T','numeric',22,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_DISK','IORM_SHARES_LEVEL','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_DISK','IORM_SHARES_SHARES','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_DISK','UPDATE_KEY','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_DISK','VDEVICE_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_DISK','VFLASH_CACHE_BLOCK_SIZE','T','numeric',22,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_DISK','VFLASH_CACHE_CONSISTENCY_TYPE','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_DISK','VFLASH_CACHE_MODE','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_DISK','VFLASH_CACHE_MODULE','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_DISK','VFLASH_CACHE_RESERVATION','T','numeric',22,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_DISK','VM_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_DISK_IOFILTERS','DISK_KEY','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_DISK_IOFILTERS','IOFILTER','T','character varying',128,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_DISK_IOFILTERS','VM_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_ETHERNET_CARD','DEV_WAKE_ON_LAN_ENABLED_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_ETHERNET_CARD','DEVICE_ADDRESS_TYPE','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_ETHERNET_CARD','DEVICE_EXTERNAL_ID','T','character varying',100,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_ETHERNET_CARD','DEVICE_MAC_ADDRESS','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_ETHERNET_CARD','NET_ALLOCATION_LIMIT','T','character varying',22,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_ETHERNET_CARD','NET_ALLOCATION_RESERVATION','T','character varying',22,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_ETHERNET_CARD','NET_ALLOCATION_SHARES_LEVEL','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_ETHERNET_CARD','NET_ALLOCATION_SHARES_SHARES','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_ETHERNET_CARD','UPDATE_KEY','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_ETHERNET_CARD','VDEVICE_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_ETHERNET_CARD','VM_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_SATACONTROLLER','UPDATE_KEY','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_SATACONTROLLER','VDEVICE_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_SATACONTROLLER','VM_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_SCSICONTROLLER','HARD_DEV_SCSI_CTLR_UNIT_NUMBER','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_SCSICONTROLLER','HARDWARE_DEVICE_SHARED_BUS','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_SCSICONTROLLER','HOT_ADD_REMOVE_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_SCSICONTROLLER','UPDATE_KEY','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_SCSICONTROLLER','VDEVICE_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_SCSICONTROLLER','VM_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_SERIAL_PORT','UPDATE_KEY','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_SERIAL_PORT','VDEVICE_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_SERIAL_PORT','VM_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_SERIAL_PORT','YIELD_ON_POLL_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_USB','ARRAY_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_USB','CONNECTED_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_USB','PRODUCT_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_USB','UPDATE_KEY','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_USB','VDEVICE_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_USB','VENDOR_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_USB','VM_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_USBCONTROLLER','AUTO_CONNECT_DEVICES_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_USBCONTROLLER','EHCI_ENABLED_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_USBCONTROLLER','UPDATE_KEY','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_USBCONTROLLER','VDEVICE_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_USBCONTROLLER','VM_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_VIDEO_CARD','ENABLE_MPT_SUPPORT_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_VIDEO_CARD','ENABLE3_DSUPPORT_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_VIDEO_CARD','GUEST_MEMORY_FOR_3D_SIZE','T','numeric',22,'YES',null);
 /
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_VIDEO_CARD','HARD_DEVICE_VIDEO_RAM_SIZE_IN','T','character varying',22,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_VIDEO_CARD','NUM_DISPLAYS','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_VIDEO_CARD','UPDATE_KEY','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_VIDEO_CARD','USE_3D_RENDERER','T','character varying',22,'YES','''automatic''::character varying');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_VIDEO_CARD','USE_AUTO_DETECT_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_VIDEO_CARD','VDEVICE_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_VIDEO_CARD','VM_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_VMCIDEVICE','ALLOW_UNREST_COMM','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_VMCIDEVICE','FILTER_ENABLE','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_VMCIDEVICE','HARDWARE_DEVICE_ID_VAL','T','character varying',22,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_VMCIDEVICE','UPDATE_KEY','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_VMCIDEVICE','VDEVICE_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VIRTUAL_VMCIDEVICE','VM_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM','AGENT_CNX_STATE','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM','AGENT_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM','AGGR_COMMITED_STORAGE_SPACE','T','numeric',38,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM','AGGR_UNCOMMITED_STORAGE_SPACE','T','numeric',38,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM','AGGR_UNSHARED_STORAGE_SPACE','T','numeric',38,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM','ANNOTATION','T','character varying',2000,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM','BOOT_TIME','T','timestamp without time zone',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM','CAPABILITY','T','text',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM','CONFIG','T','text',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM','CPU_RESERVATION','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM','DAS_PROTECTED_ACTUAL','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM','DAS_PROTECTED_DESIRED','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM','DATACENTER_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM','DESCRIPTION','T','character varying',2000,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM','DEV_RUNTIME','T','text',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM','DISABLED_SNAPSHOT','T','integer',32,'NO','0');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM','DNS_NAME','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM','ESX_AGENT_VM_STATE','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM','FAILED_DMOTION','T','numeric',1,'NO','0');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM','FAULT_TOLERANCE_STATE','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM','FEATURE_MASK','T','text',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM','FEATURE_REQUIREMENT','T','text',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM','FILE_LAYOUT','T','text',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM','FILE_LAYOUT_X','T','text',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM','FILE_NAME','T','character varying',440,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM','GENERATION_INFO','T','text',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM','GUEST_FAMILY','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM','GUEST_IP_STACK','T','text',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM','GUEST_OPS_READY','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM','GUEST_OS','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM','GUEST_STATE','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM','GUEST_STATE_CHANGE_SUPPORTED','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM','HOST_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM','ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM','INT_GUEST_OPS_READY','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM','IP_ADDRESS','T','character varying',50,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM','IS_CONSOLIDATE_NEEDED','T','numeric',1,'NO','0');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM','IS_QUIESCED_FORK_PARENT','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM','IS_TEMPLATE','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM','LOCAL_FILE_NAME','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM','MANAGED_BY_EXT_KEY','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM','MANAGED_BY_TYPE','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM','MEM_SIZE_MB','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM','MEMORY_OVERHEAD','T','character varying',21,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM','MEMORY_RESERVATION','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM','MKS_CONNECTIONS','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM','NUM_DISK','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM','NUM_NIC','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM','NUM_VCPU','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM','OFFLINE_FEATURE_REQUIREMENT','T','text',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM','ONLINE_STANDBY','T','numeric',1,'NO','0');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM','PAUSED','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM','PENDING_ANNOT_SET_FLG','T','numeric',1,'NO','0');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM','PENDING_ANNOTATION','T','character varying',2000,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM','PENDING_NAME','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM','POWER_STATE','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM','QUESTION_INFO','T','text',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM','RECORD_REPLAY_STATE','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM','RESOURCE_GROUP_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM','SCREEN_HEIGHT','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM','SCREEN_WIDTH','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM','SNAPSHOT_IN_BACKGROUND','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM','STORAGE_SPACE_UPDATED_TIME','T','timestamp without time zone',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM','SUSPEND_INTERVAL','T','character varying',21,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM','SUSPEND_TIME','T','timestamp without time zone',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM','TOOLS_MOUNTED','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM','TOOLS_RUNNING_STATUS','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM','TOOLS_STATUS','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM','TOOLS_VERSION','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM','TOOLS_VERSION_STATUS','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM','UUID_BIOS','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM','UUID_INSTANCE','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM','VAPP_CONFIG','T','text',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CHILD_TABLES','TABLE_NAME','T','character varying',30,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CHILD_TABLES','VM_ID_COLUMN_NAME','T','character varying',6,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','ALTERNATE_GUEST_NAME','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','ANNOTATION','T','character varying',2000,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','ARRAY_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','BOOT_OPTION_BOOT_DELAY','T','character varying',22,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','BOOT_OPTION_RETRY_DELAY','T','numeric',22,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','BOOT_OPTION_RETRY_ENABLED_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','BOOT_OPTIONENTER_BIOSSETUP_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','C_ALLOC_EXPANDABLE_RESERV_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','CHANGE_TRACKING_ENABLED','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','CHANGE_VERSION','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','CONPREFE_CL_PO_SUSPEND_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','CONPREFE_POWERONWHENOPENED_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','CONPREFE_SCR_POWER_ON_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','CPU_ALLOCATION_LIMIT','T','character varying',22,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','CPU_ALLOCATION_OVERHEAD_LIMIT','T','character varying',22,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','CPU_ALLOCATION_RESERVATION','T','character varying',22,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','CPU_ALLOCATION_SHARES_LEVEL','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','CPU_ALLOCATION_SHARES_SHARES','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','CPU_HOT_ADD_ENABLED','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','CPU_HOT_REMOVE_ENABLED','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','DEF_PO_O_DEF_POWER_OFF_TYPE','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','DEF_PO_O_DEFAULT_SUSPEND_TYPE','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','DEF_PO_OPS_DEFAULT_RESET_TYPE','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','DEF_POWER_OPS_POWER_OFF_TYPE','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','DEF_POWER_OPS_STANDBY_ACTION','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','DEF_POWER_OPS_SUSPEND_TYPE','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','DEFAULT_POWER_OPS_RESET_TYPE','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','DISABLE_ACCELERATION_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','DISK_UUID_ENABLED_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','ENABLE_LOGGING_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','FAULT_TOLERANCE_TYPE','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','FILES_FTMETADATA_DIRECTORY','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','FILES_LOG_DIRECTORY','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','FILES_SNAPSHOT_DIRECTORY','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','FILES_SUSPEND_DIRECTORY','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','FILES_VM_PATH_NAME','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','FIRMWARE','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','FL_SNAPSHOT_POWER_OFF_BEHAVIOR','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','FLAGS_MONITOR_TYPE','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','FORK_CHILD_GROUP_ID','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','FORK_CHILD_TYPE','T','character varying',15,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','FORK_PARENT_ENABLED','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','GUEST_AUTOLOCK_ENABLED','T','numeric',1,'YES','0');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','GUEST_FULL_NAME','T','character varying',512,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','GUEST_ID','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','H_PLUG_MEMORY_INCREMENT_SIZE','T','character varying',22,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','HARDWARE_CORES','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','HARDWARE_MEMORY','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','HARDWARE_NUM','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','HOT_PLUG_MEMORY_LIMIT','T','character varying',22,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','HT_SHARING','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','INSTANCE_UUID','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','LATENCY_LEVEL','T','character varying',22,'YES','''normal''::character varying');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','LATENCY_SENSITIVITY','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','LOCATION_ID','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','MANAGED_BY_EXT_KEY','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','MANAGED_BY_TYPE','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','MAX_MKS_CONNECTIONS','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','MEM_ALLOCATION_OVERHEAD_LIMIT','T','character varying',22,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','MEM_ALLOCATION_SHARES_LEVEL','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','MEM_ALLOCATION_SHARES_SHARES','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','MEM_ALLOCEXPAN_RESERVATION_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','MEM_HOT_ADD_ENABLED','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','MEM_RES_LOCKED_MAX','T','numeric',1,'YES','0');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','MEMORY_ALLOCATION_LIMIT','T','character varying',22,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','MEMORY_ALLOCATION_RESERVATION','T','character varying',22,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','MODIFIED','T','timestamp without time zone',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','NAME','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','NESTED_HV_ENABLED','T','numeric',1,'YES','0');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','NETWORK_SHAPER_AVERAGE_BPS','T','character varying',22,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','NETWORK_SHAPER_BURST_SIZE','T','character varying',22,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','NETWORK_SHAPER_ENABLED_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','NETWORK_SHAPER_PEAK_BPS','T','character varying',22,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','NPIV_DESIRED_NWWN','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','NPIV_DESIRED_PWWN','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','NPIV_ON_RDM','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','NPIV_TEMP_DISABLED','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','NPIV_WORLD_WIDE_NAME_TYPE','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','PRESERVED_SWAP_ONPOWEROFF_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','RECORD_REPLAY_ENABLED_FLG','T','numeric',1,'YES',null);
 /
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','RUN_WITH_DEBUG_INFO_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','SCHED_HW_UPGRADE_POLICY','T','character varying',22,'YES','''never''::character varying');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','SCHED_HW_UPGRADE_STATUS','T','character varying',22,'YES','''none''::character varying');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','SCHED_HW_UPGRADE_VERSION','T','character varying',22,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','SNAPSHOT_DISABLED_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','SNAPSHOT_LOCKED_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','SWAP_DIR','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','SWAP_OBJECTID','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','SWAP_PLACEMENT','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','TEMPLATE_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','TOOLS_AFTER_POWER_ON_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','TOOLS_AFTER_RESUME_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','TOOLS_BEFORE_GUEST_REBOOT_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','TOOLS_BEFORE_GUEST_STANDBY_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','TOOLS_BEFORE_GUESTSHUTDOWN_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','TOOLS_LASTINSTALL_COUNTER','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','TOOLS_PENDING_CUSTOMIZATION','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','TOOLS_SYNC_TIME_WITH_HOST_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','TOOLS_TOOLS_UPGRADE_POLICY','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','TOOLS_TOOLS_VERSION','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','USE_TOE_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','UUID','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','VASSERTS_ENABLED','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','VERSION','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','VFLASH_CACHE_RESERVATION','T','numeric',22,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','VIRTUAL_EXEC_USAGE','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','VIRTUAL_ICH7M_PRESENT','T','numeric',1,'YES','0');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','VIRTUAL_MMU_USAGE','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','VIRTUAL_PMC_ENABLED','T','numeric',1,'YES','0');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','VIRTUAL_SMC_PRESENT','T','numeric',1,'YES','0');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_CONFIG_INFO','VM_OBJECTID','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_DS_SPACE','COMMITED_SPACE','T','numeric',38,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_DS_SPACE','DS_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_DS_SPACE','UNCOMMITED_SPACE','T','numeric',38,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_DS_SPACE','UNSHARED_SPACE','T','numeric',38,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_DS_SPACE','UPDATED_TIME','T','timestamp without time zone',-1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_DS_SPACE','VM_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_FILE_LAYOUT_EX','LAST_UPDATE_TIME','T','timestamp without time zone',-1,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_FILE_LAYOUT_EX','VM_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_FLE_DISK_LAYOUT','ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_FLE_DISK_LAYOUT','KEY_VAL','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_FLE_DISK_LAYOUT','VM_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_FLE_DISK_UNIT','ARRAY_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_FLE_DISK_UNIT','DISK_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_FLE_DISK_UNIT','UPDATE_KEY','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_FLE_DISK_UNIT','VM_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_FLE_FILE_INFO','FILE_SIZE','T','character varying',22,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_FLE_FILE_INFO','FILE_UNIQUESIZE','T','character varying',22,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_FLE_FILE_INFO','KEY_VAL','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_FLE_FILE_INFO','NAME','T','character varying',420,'YES',''' ''::character varying');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_FLE_FILE_INFO','TYPE','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_FLE_FILE_INFO','VM_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_FLE_SNAP_DISK_UNIT','ARRAY_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_FLE_SNAP_DISK_UNIT','SNAPSHOT_DISK_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_FLE_SNAP_DISK_UNIT','UPDATE_KEY','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_FLE_SNAP_DISK_UNIT','VM_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_FLE_SNAPSHOT_DISK','DISK_KEY','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_FLE_SNAPSHOT_DISK','ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_FLE_SNAPSHOT_DISK','SNAPSHOT_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_FLE_SNAPSHOT_DISK','UPDATE_KEY','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_FLE_SNAPSHOT_DISK','VM_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_FLE_SNAPSHOT_LAYOUT','ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_FLE_SNAPSHOT_LAYOUT','SNAPSHOT_FILE_KEY','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_FLE_SNAPSHOT_LAYOUT','SNAPSHOT_KEY','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_FLE_SNAPSHOT_LAYOUT','VM_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_STATIC_OVERHEAD_MAP','HOST_BUILD_NUM','T','character varying',20,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_STATIC_OVERHEAD_MAP','STATIC_MEM_OVERHEAD','T','character varying',21,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VM_STATIC_OVERHEAD_MAP','VM_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VMFS_EXTENT','DISK_NAME','T','character varying',512,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VMFS_EXTENT','ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VMFS_EXTENT','PARTITION_VAL','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VMFS_EXTENT','SURR_KEY','T','integer',32,'NO','nextval(''vpx_vmfs_extent_surr_key_seq''::regclass)');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VMFS_VOLUME','UUID','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VMFS_VOLUME','VPX_FILE_SYSTEM_MOUNT_INFO_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VSRIOV_ETHERNET_CARD','DEV_ALLOW_GUEST_MTU_FLG','T','numeric',1,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VSRIOV_ETHERNET_CARD','PF_DEVICE_ID','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VSRIOV_ETHERNET_CARD','PF_PCI_ID','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VSRIOV_ETHERNET_CARD','PF_SYSTEM_ID','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VSRIOV_ETHERNET_CARD','PF_VENDOR_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VSRIOV_ETHERNET_CARD','UPDATE_KEY','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VSRIOV_ETHERNET_CARD','VDEVICE_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VSRIOV_ETHERNET_CARD','VF_DEVICE_ID','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VSRIOV_ETHERNET_CARD','VF_INDEX','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VSRIOV_ETHERNET_CARD','VF_PCI_ID','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VSRIOV_ETHERNET_CARD','VF_SYSTEM_ID','T','character varying',255,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VSRIOV_ETHERNET_CARD','VF_VENDOR_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_VSRIOV_ETHERNET_CARD','VM_ID','T','integer',32,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_WWN','ENTITY_ID','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_WWN','IS_VM_NPIV','T','integer',32,'NO',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_WWN','NODE_WWN','T','character varying',21,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_WWN','PORT_WWN','T','character varying',21,'YES',null);
  INSERT INTO MGRD_EXP_TABLES_COLUMNS VALUES ('VPX_WWN','SURR_KEY','T','integer',32,'NO','nextval(''vpx_wwn_surr_key_seq''::regclass)');
 /
 
 
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_OBJECT_TYPE','PK_VPX_OBJECT_TYPE','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_ALARM','PK_VPX_ALARM','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_ALARM_EXPRESSION','PK_VPX_ALARM_EXP','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_ALARM_EXPR_COMP','PK_VPX_ALARM_EXPR_COMP','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_ALARM_ACTION','PK_VPX_ALARM_ACTION','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_ALARM_RUNTIME','PK_VPX_ALARM_RUNTIME','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_ALARM_RUNTIME','IX_VPX_ALRT_CRTIME_STATUSVALUE','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_ALARM_STATE','PK_VPX_ALARM_STATE','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_ALARM_REPEAT_ACTION','PK_VPX_ALARM_RPTACT','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_CUSTOMIZATION_SPEC','PK_VPX_CUSTOMIZATION_SPEC','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_CHANGE_TAG','PK_VPX_CHANGE_TAG','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_CHANGE_TAG','VPX_CHANGE_TAG_M1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_EVENT','PK_VPX_EVENT','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_EVENT','VPXI_EVENT_DVS_ID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_EVENT','VPXI_EVENT_CATEGORY','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_EVENT','VPXI_EVENT_CHAIN_ID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_EVENT','VPXI_EVENT_COMPUTERESOURCE_ID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_EVENT','VPXI_EVENT_CREATE_TIME','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_EVENT','VPXI_EVENT_DATACENTER_ID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_EVENT','VPXI_EVENT_DATASTORE_ID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_EVENT','VPXI_EVENT_EVENT_TYPE','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_EVENT','VPXI_EVENT_EXTENDED_CLASS','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_EVENT','VPXI_EVENT_HOST_ID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_EVENT','VPXI_EVENT_USERNAME','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_EVENT','VPXI_EVENT_VM_ID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_EVENT','VPXI_CHANGE_TAG','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_EVENT','VPXI_EVENT_NETWORK_ID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_EVENT_ARG','PK_VPX_EVENT_ARG','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_EVENT_ARG','VPX_EVENT_ARG_F2','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_EVENT_ARG','VPX_EVENT_ARG_F3','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_FIELD_DEF','PK_VPX_FIELD_DEF','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_ROLE','PK_VPX_ROLE','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SAMPLE','PK_VPX_SAMPLE','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SAMPLE','VPXI_SAMPLE_UNIQUE_KEY','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SAMPLE','VPXI_SAMPLE_SAMPLE_TIME','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SCHEDULEDTASK','PK_VPX_SCHEDULEDTASK','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SCHED_SCHEDULER','PK_VPX_SCHED_SCHEDULER','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SCHED_ACTION','PK_VPX_SCHED_ACTION','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SEQUENCE','PK_VPX_SEQUENCE','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_PARAMETER','PK_VPX_PARAMETER','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_STAT_DEF','PK_VPX_STAT_DEF','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_STAT_ID','PK_VPX_STAT_ID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_TASK','PK_VPX_TASK','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_TASK','VPXI_TASK_ALARM_ID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_TASK','VPXI_TASK_COMPLETE_STATE','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_TASK','VPXI_TASK_COMPLETE_TIME','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_TASK','VPXI_TASK_COMPUTERESOURCE_ID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_TASK','VPXI_TASK_DATACENTER_ID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_TASK','VPXI_TASK_ENTITY_ID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_TASK','VPXI_TASK_HOST_ID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_TASK','VPXI_TASK_RESOURCEPOOL_ID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_TASK','VPXI_TASK_FOLDER_ID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_TASK','VPXI_TASK_QUEUE_TIME','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_TASK','VPXI_TASK_SCHEDULEDTASK_ID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_TASK','VPXI_TASK_START_TIME','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_TASK','VPXI_TASK_USERNAME','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_TASK','VPXI_TASK_VM_ID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_TASK','VPXI_CHANGE_TAG_ID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_TASK','VPXI_PARENT_TASK_ID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_TASK','VPXI_ROOT_TASK_ID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VERSION','PK_VPX_VERSION','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_PRIV_ROLE','PK_VPX_PRIV_ROLE','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_ENTITY','PK_VPX_ENTITY','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_ALARM_DISABLED_ACTIONS','PK_VPX_ALARM_DISABLED_ACTIONS','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_ENTITY','VPXI_ENTITY_TYPE_ID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_ACCESS','PK_VPX_ACCESS','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_CONFIG_ISSUE','PK_VPX_CONFIG_ISSUE','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SNAPSHOT','PK_VPX_SNAPSHOT','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_FIELD_VAL','PK_VPX_FIELD_VAL','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DATACENTER','PK_VPX_DATACENTER','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VM','PK_VPX_VM','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VM','VPXI_VM_DISABLED_SNAPSHOT','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VM','IX_VPX_VM_DCID_ISTMPLT_UUIDINS','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VM_CHILD_TABLES','PK_VPX_VM_CHILD_TABLES','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_OVFENV','PK_VPX_OVFENV','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_WWN','PK_VPX_WWN','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_MAC_XVC_VMOTION','PK_VPX_MAC_XVC_VMOTION','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VM','VPXI_VM_FILE_NAME','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VM','VPXI_VM_UUID_BIOS','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VM','VPXI_VM_UUID_INSTANCE','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VM','VPXI_VM_DATACENTER_ID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VM','VPXI_VM_DNS_NAME','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VM','VPXI_VM_IP_ADDRESS','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VM','VPXI_VM_RESOURCE_GROUP_ID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VM','VPX_VM_F1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VM_STATIC_OVERHEAD_MAP','PK_VPX_VM_STATIC_OVERHEAD_MAP','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_COMPUTE_RESOURCE','PK_VPX_COMP_RES','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_CLUSTER_IOFILTERS','PK_VPX_CLUS_IOF','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DATASTORE','PK_VPX_DATASTORE','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DATASTORE','VPXI_DATASTORE_DATACENTER','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_NETWORK','PK_VPX_NETWORK','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_NETWORK','VPXI_NETWORK_DATACENTER','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_IP_POOL','PK_VPX_IPPOOL','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_IP_POOL','VPXI_IP_POOL_UNIQUE_DC_ID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_IP_POOL','VPXI_IP_POOL_UNIQUE_DC_NAME','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_IP_POOL_ASSOCIATION','PK_VPX_IPPOOL_ASSOCIATION','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_IP_POOL_ALLOCATION','PK_VPX_IP_POOL_ALLOCATION','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_IP_POOL_ALLOCATION','VPXI_IP_POOL_ALLOC_UNIQUE_ID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_IP_POOL_ALLOCATION','VPXI_IP_POOL_ALLOC_EXT_KEY','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_NW_ASSIGNMENT','PK_VPX_NW_ASSIGNMENT','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_NW_ASSIGNMENT','VPXI_NW_ASSIGNMENT_ENTITY','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVS','PK_VPX_DVS','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVS','VPX_DVS_F1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVS','VPX_DVS_F2','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVS','VPX_DVS_F3','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVS_COMPATIBLE','PK_VPX_DVS_COMPATIBLE','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVS_UPLINK','PK_VPX_DVS_UPLINK','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVPORTGROUP','PK_VPX_DVPORTGROUP','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVPORTGROUP','VPX_DVPORTGROUP_F1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVHOST','PK_VPX_DVHOST','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVHOST','VPX_DVHOST_F1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVPORT_SETTING','PK_VPX_DVPORT_SETTING','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVPORT_SETTING','VPX_DVPORT_SETTING_U1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVPORT_SETTING','VPX_DVPORT_SETTING_M1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVPORT_SETTING','VPX_DVPORT_SETTING_M2','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVPORT','PK_VPX_DVPORT','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVPORT','VPX_DVPORT_M1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVPORT','VPX_DVPORT_M2','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVPORT','VPX_DVPORT_M3','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVS_NRP','PK_VPX_DVS_NRP','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVPORT_MEMBERSHIP','PK_VPX_DVPORT_MEMBERSHIP','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVPORT_MEMBERSHIP','VPX_DVPORT_MEMBERSHIP_F1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVPORT_MEMBERSHIP','VPX_DVPORT_MEMBERSHIP_F2','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVS_SCOPE','PK_VPX_DVS_SCOPE','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVS_SCOPE','VPX_DVS_SCOPE_M1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVS_VSPAN_SESSION','PK_VPX_DVS_VSPAN_SESSION','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVS_VSPAN_SESSION','VPX_DVS_VSPAN_SESSION_U1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVS_HC_CONFIG','PK_VPX_DVS_HC_CONFIG','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVHOST_HC_RESULT','PK_VPX_DVHOST_HC_RESULT','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVHOST_HC_RESULT','VPX_DVHOST_HC_RESULT_M1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVHOST_HC_VLAN_RESULT','PK_VPX_DVHOST_HC_VLAN_RESULT','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVHOST_HC_VLAN_RESULT','VPX_DVHOST_HC_VLAN_RESULT_M1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVHOST_HC_MTU_RESULT','PK_VPX_DVHOST_HC_MTU_RESULT','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVHOST_HC_MTU_RESULT','VPX_DVHOST_HC_MTU_RESULT_M1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVS_IPFIX','PK_VPX_DVS_IPFIX','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVS_VSPAN_PORTS','PK_VPX_DVS_VSPAN_PORTS','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVS_PVLAN','PK_VPX_DVS_PVLAN','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVS_PVLAN','VPX_DVS_PVLAN_F1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVPORT_VLAN','PK_VPX_DVPORT_VLAN','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVPORT_VLAN','VPX_DVPORT_VLAN_M1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_UPLINK_TEAMING','PK_VPX_UPLINK_TEAMING','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_UPLINK_TEAMING','VPX_UPLINK_TEAMING_M1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVS_BLOB','PK_VPX_DVS_BLOB','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVS_BLOB','VPX_DVS_BLOB_M1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVS_BLOB','VPX_DVS_BLOB_F1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVS_OVERLAY_INSTANCE','PK_VPX_DVS_OVERLAY_INSTANCE','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVS_OPAQUE_DATA','PK_VPX_DVS_OPAQUE_DATA','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVS_RULESET','PK_VPX_DVS_RULESET','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVS_RULE','PK_VPX_DVS_RULE','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVS_RULE','IDX_VPX_DVS_RULE','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVS_RULE_QUALIFIER','PK_VPX_DVS_RULE_QUALIFIER','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVS_RULE_QUALIFIER','IDX_VPX_DVS_RULE_QUALIFIER','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVS_TRAFFIC_FILTER_CONFIG','PK_VPX_DVS_TRAFFIC_FILT_CONFIG','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVS_TRAFFIC_FILTER_PARAM','PK_VPX_DVS_TRAFFIC_FILT_PARAM','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVS_INFRA_RES_POOL','PK_VPX_DVS_INFRA_RES_POOL','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVS_VMVNIC_RES_POOL','PK_VPX_DVS_VMVNIC_RES_POOL','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_REMOTE_CNX','PK_VPX_HOST_CNX','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_REMOTE_CNX_LISTENER','PK_VPX_HOST_CNX_FILTER','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVS_LAG','PK_VPX_DVS_LAG','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVS_LAG','VPX_DVS_LAG_U1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVS_LAG_VLAN','PK_VPX_DVS_LAG_VLAN','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HOST','PK_VPX_HOST','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HOST','VPXI_HOST_DATACENTER_ID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HOST','VPXI_HOST_UUID_BIOS','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HOST','VPXI_HOST_DNS_NAME','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HOST','VPXI_HOST_IP_ADDRESS','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HOST','IDX_VPX_HOST','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HOST_SYSTEM_ID_INFO','PK_HOST_SYSIDINFO','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HOST_X','PK_VPX_HOST_X','I');
 /
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HOST_GW_PARAMS','PK_VPX_HOST_GW_PARAMS','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_RESOURCE_POOL','PK_VPX_RESOURCE_POOL','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DS_ASSIGNMENT','PK_VPX_DS_ASSIGNMENT','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DS_ASSIGNMENT','VPXI_DS_ASSIGNMENT_ENTITY','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HOST_VM_CONFIG_OPTION','PK_VPX_HOST_VM_CONFIG_OPTION','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_COMPUTE_RESOURCE_DAS_VM','PK_VPX_COMP_DAS_VM','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_COMPUTE_RESOURCE_DAS_VM','VPX_COMPUTE_RESOURCE_DAS_VM_F1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DAS_HB_DATASTORE_SYS','PK_VPX_COMP_DAS_HB_DS_SYS','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_COMPUTE_RES_USER_HB_DS','PK_COMPUTE_RES_USER_HB_DS','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_COMPUTE_RESOURCE_DRS_VM','PK_VPX_COMP_DRS_VM','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_COMPUTE_RESOURCE_DRS_VM','VPX_COMPUTE_RESOURCE_DRS_VM_F1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_COMPUTE_RESOURCE_DPM_HOST','PK_VPX_COMP_RESOURCE_DPM_HOST','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HOST_CPU','PK_VPX_HOST_CPU','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HOST_CPU_THREAD','PK_VPX_CPU_THREAD','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HOST_CPU_CPUID_FEATURE','PK_VPX_CPU_CPUID_FEAT','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HOST_NODE','PK_VPX_HOST_NODE','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_GUEST_DISK','PK_VPX_GUEST_DISK','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_NIC','PK_VPX_NIC','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_NIC','VPXI_GUEST_NET_MAC','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HOST_NODE_CPU','PK_VPX_HOST_NODE_CPU','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_IP_ADDRESS','PK_VPX_IP_ADDRESS','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HOST_PCI_DEVICE','PK_VPX_HOST_PCI_DEVICE','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HOST_CPUID_FEATURE','PK_VPX_HOST_CPUID_FEATURE','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_EXT','PK_VPX_EXT','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_EXT_SERVER','PK_VPX_EXT_SERVER','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_EXT_SERVER_EMAIL','PK_VPX_EXT_SERVER_EMAIL','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_EXT_CLIENT','PK_VPX_EXT_CLIENT','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_EXT_TYPE_IDS','PK_VPX_EXT_TYPE_IDS','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_EXT_PRIVS','PK_VPX_EXT_PRIVS','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_EXT_MANAGEDBY_INFO','PK_VPX_EXT_MANAGEDBY_INFO','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_EXT_TABS','PK_VPX_EXT_TABS','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_EXT_DATA','PK_VPX_EXT_DATA','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HOST_DISABLEADMIN','PK_VPX_HOST_DISABLEADMIN','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_COMPUTE_RESOURCE_VSAN_HOST','PK_COMP_RESOURCE_VSAN_HOST','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DISABLED_METHODS','PK_VPX_DISABLED_METHODS','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_STAT_INTERVAL_DEF','PK_VPX_STAT_INTERVAL_DEF','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DEVICE','PK_VPX_DEVICE','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DEVICE','VPX_DEVICE_U1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_STAT_COUNTER','PK_VPX_STAT_COUNTER','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_STAT_COUNTER','VPX_STAT_COUNTER_P1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SAMPLE_TIME1','PK_VPX_SAMPLE_TIME1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SAMPLE_TIME1','VPX_SAMPLE_TIME1_U1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SAMPLE_TIME1','VPX_SAMPLE_TIME1_M1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SAMPLE_TIME2','PK_VPX_SAMPLE_TIME2','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SAMPLE_TIME2','VPX_SAMPLE_TIME2_U1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SAMPLE_TIME2','VPX_SAMPLE_TIME2_M1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SAMPLE_TIME3','PK_VPX_SAMPLE_TIME3','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SAMPLE_TIME3','VPX_SAMPLE_TIME3_U1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SAMPLE_TIME3','VPX_SAMPLE_TIME3_M1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SAMPLE_TIME4','PK_VPX_SAMPLE_TIME4','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SAMPLE_TIME4','VPX_SAMPLE_TIME4_U1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SAMPLE_TIME4','VPX_SAMPLE_TIME4_M1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_2','PK_VPX_HIST_STAT2_2','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_3','PK_VPX_HIST_STAT2_3','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_4','PK_VPX_HIST_STAT2_4','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_5','PK_VPX_HIST_STAT2_5','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_6','PK_VPX_HIST_STAT2_6','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_7','PK_VPX_HIST_STAT2_7','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_8','PK_VPX_HIST_STAT2_8','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_9','PK_VPX_HIST_STAT2_9','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_10','PK_VPX_HIST_STAT2_10','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_11','PK_VPX_HIST_STAT2_11','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_12','PK_VPX_HIST_STAT2_12','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_13','PK_VPX_HIST_STAT2_13','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_14','PK_VPX_HIST_STAT2_14','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_15','PK_VPX_HIST_STAT2_15','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_16','PK_VPX_HIST_STAT2_16','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_17','PK_VPX_HIST_STAT2_17','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_18','PK_VPX_HIST_STAT2_18','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_19','PK_VPX_HIST_STAT2_19','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_20','PK_VPX_HIST_STAT2_20','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_21','PK_VPX_HIST_STAT2_21','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_22','PK_VPX_HIST_STAT2_22','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_23','PK_VPX_HIST_STAT2_23','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_24','PK_VPX_HIST_STAT2_24','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_25','PK_VPX_HIST_STAT2_25','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_26','PK_VPX_HIST_STAT2_26','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_28','PK_VPX_HIST_STAT2_28','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_29','PK_VPX_HIST_STAT2_29','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_30','PK_VPX_HIST_STAT2_30','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_31','PK_VPX_HIST_STAT2_31','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_32','PK_VPX_HIST_STAT2_32','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_33','PK_VPX_HIST_STAT2_33','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_34','PK_VPX_HIST_STAT2_34','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_35','PK_VPX_HIST_STAT2_35','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_36','PK_VPX_HIST_STAT2_36','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_37','PK_VPX_HIST_STAT2_37','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_38','PK_VPX_HIST_STAT2_38','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_39','PK_VPX_HIST_STAT2_39','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_41','PK_VPX_HIST_STAT2_41','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_42','PK_VPX_HIST_STAT2_42','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_43','PK_VPX_HIST_STAT2_43','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_44','PK_VPX_HIST_STAT2_44','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_45','PK_VPX_HIST_STAT2_45','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_46','PK_VPX_HIST_STAT2_46','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_47','PK_VPX_HIST_STAT2_47','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_48','PK_VPX_HIST_STAT2_48','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_49','PK_VPX_HIST_STAT2_49','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_50','PK_VPX_HIST_STAT2_50','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_51','PK_VPX_HIST_STAT2_51','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_52','PK_VPX_HIST_STAT2_52','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_53','PK_VPX_HIST_STAT2_53','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_54','PK_VPX_HIST_STAT2_54','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_55','PK_VPX_HIST_STAT2_55','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_56','PK_VPX_HIST_STAT2_56','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_57','PK_VPX_HIST_STAT2_57','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_59','PK_VPX_HIST_STAT2_59','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_60','PK_VPX_HIST_STAT2_60','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_61','PK_VPX_HIST_STAT2_61','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_62','PK_VPX_HIST_STAT2_62','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_63','PK_VPX_HIST_STAT2_63','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_64','PK_VPX_HIST_STAT2_64','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_65','PK_VPX_HIST_STAT2_65','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_66','PK_VPX_HIST_STAT2_66','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_67','PK_VPX_HIST_STAT2_67','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_68','PK_VPX_HIST_STAT2_68','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_69','PK_VPX_HIST_STAT2_69','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_70','PK_VPX_HIST_STAT2_70','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_71','PK_VPX_HIST_STAT2_71','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_72','PK_VPX_HIST_STAT2_72','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_73','PK_VPX_HIST_STAT2_73','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_74','PK_VPX_HIST_STAT2_74','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_75','PK_VPX_HIST_STAT2_75','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_76','PK_VPX_HIST_STAT2_76','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_77','PK_VPX_HIST_STAT2_77','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_78','PK_VPX_HIST_STAT2_78','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_79','PK_VPX_HIST_STAT2_79','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_80','PK_VPX_HIST_STAT2_80','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_81','PK_VPX_HIST_STAT2_81','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_82','PK_VPX_HIST_STAT2_82','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_83','PK_VPX_HIST_STAT2_83','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_84','PK_VPX_HIST_STAT2_84','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_1','PK_VPX_HIST_STAT2_1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_27','PK_VPX_HIST_STAT2_27','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_40','PK_VPX_HIST_STAT2_40','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_58','PK_VPX_HIST_STAT2_58','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_85','PK_VPX_HIST_STAT2_85','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_1','IX_VPX_HIST_STAT2_1_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_2','IX_VPX_HIST_STAT2_2_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_3','IX_VPX_HIST_STAT2_3_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_4','IX_VPX_HIST_STAT2_4_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_5','IX_VPX_HIST_STAT2_5_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_6','IX_VPX_HIST_STAT2_6_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_7','IX_VPX_HIST_STAT2_7_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_8','IX_VPX_HIST_STAT2_8_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_9','IX_VPX_HIST_STAT2_9_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_10','IX_VPX_HIST_STAT2_10_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_11','IX_VPX_HIST_STAT2_11_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_12','IX_VPX_HIST_STAT2_12_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_13','IX_VPX_HIST_STAT2_13_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_14','IX_VPX_HIST_STAT2_14_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_15','IX_VPX_HIST_STAT2_15_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_16','IX_VPX_HIST_STAT2_16_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_17','IX_VPX_HIST_STAT2_17_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_18','IX_VPX_HIST_STAT2_18_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_19','IX_VPX_HIST_STAT2_19_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_20','IX_VPX_HIST_STAT2_20_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_21','IX_VPX_HIST_STAT2_21_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_22','IX_VPX_HIST_STAT2_22_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_23','IX_VPX_HIST_STAT2_23_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_24','IX_VPX_HIST_STAT2_24_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_25','IX_VPX_HIST_STAT2_25_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_26','IX_VPX_HIST_STAT2_26_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_27','IX_VPX_HIST_STAT2_27_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_28','IX_VPX_HIST_STAT2_28_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_29','IX_VPX_HIST_STAT2_29_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_30','IX_VPX_HIST_STAT2_30_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_31','IX_VPX_HIST_STAT2_31_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_32','IX_VPX_HIST_STAT2_32_TID','I');
 /
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_33','IX_VPX_HIST_STAT2_33_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_34','IX_VPX_HIST_STAT2_34_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_35','IX_VPX_HIST_STAT2_35_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_36','IX_VPX_HIST_STAT2_36_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_37','IX_VPX_HIST_STAT2_37_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_38','IX_VPX_HIST_STAT2_38_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_39','IX_VPX_HIST_STAT2_39_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_40','IX_VPX_HIST_STAT2_40_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_41','IX_VPX_HIST_STAT2_41_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_42','IX_VPX_HIST_STAT2_42_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_43','IX_VPX_HIST_STAT2_43_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_44','IX_VPX_HIST_STAT2_44_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_45','IX_VPX_HIST_STAT2_45_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_46','IX_VPX_HIST_STAT2_46_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_47','IX_VPX_HIST_STAT2_47_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_48','IX_VPX_HIST_STAT2_48_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_49','IX_VPX_HIST_STAT2_49_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_50','IX_VPX_HIST_STAT2_50_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_51','IX_VPX_HIST_STAT2_51_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_52','IX_VPX_HIST_STAT2_52_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_53','IX_VPX_HIST_STAT2_53_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_54','IX_VPX_HIST_STAT2_54_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_55','IX_VPX_HIST_STAT2_55_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_56','IX_VPX_HIST_STAT2_56_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_57','IX_VPX_HIST_STAT2_57_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_58','IX_VPX_HIST_STAT2_58_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_59','IX_VPX_HIST_STAT2_59_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_60','IX_VPX_HIST_STAT2_60_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_61','IX_VPX_HIST_STAT2_61_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_62','IX_VPX_HIST_STAT2_62_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_63','IX_VPX_HIST_STAT2_63_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_64','IX_VPX_HIST_STAT2_64_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_65','IX_VPX_HIST_STAT2_65_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_66','IX_VPX_HIST_STAT2_66_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_67','IX_VPX_HIST_STAT2_67_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_68','IX_VPX_HIST_STAT2_68_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_69','IX_VPX_HIST_STAT2_69_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_70','IX_VPX_HIST_STAT2_70_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_71','IX_VPX_HIST_STAT2_71_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_72','IX_VPX_HIST_STAT2_72_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_73','IX_VPX_HIST_STAT2_73_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_74','IX_VPX_HIST_STAT2_74_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_75','IX_VPX_HIST_STAT2_75_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_76','IX_VPX_HIST_STAT2_76_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_77','IX_VPX_HIST_STAT2_77_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_78','IX_VPX_HIST_STAT2_78_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_79','IX_VPX_HIST_STAT2_79_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_80','IX_VPX_HIST_STAT2_80_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_81','IX_VPX_HIST_STAT2_81_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_82','IX_VPX_HIST_STAT2_82_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_83','IX_VPX_HIST_STAT2_83_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_84','IX_VPX_HIST_STAT2_84_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_85','IX_VPX_HIST_STAT2_85_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_2','PK_VPX_HIST_STAT3_2','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_3','PK_VPX_HIST_STAT3_3','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_4','PK_VPX_HIST_STAT3_4','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_1','PK_VPX_HIST_STAT3_1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_5','PK_VPX_HIST_STAT3_5','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_6','PK_VPX_HIST_STAT3_6','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_7','PK_VPX_HIST_STAT3_7','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_8','PK_VPX_HIST_STAT3_8','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_9','PK_VPX_HIST_STAT3_9','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_10','PK_VPX_HIST_STAT3_10','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_11','PK_VPX_HIST_STAT3_11','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_12','PK_VPX_HIST_STAT3_12','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_13','PK_VPX_HIST_STAT3_13','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_14','PK_VPX_HIST_STAT3_14','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_15','PK_VPX_HIST_STAT3_15','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_16','PK_VPX_HIST_STAT3_16','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_17','PK_VPX_HIST_STAT3_17','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_18','PK_VPX_HIST_STAT3_18','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_19','PK_VPX_HIST_STAT3_19','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_20','PK_VPX_HIST_STAT3_20','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_21','PK_VPX_HIST_STAT3_21','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_22','PK_VPX_HIST_STAT3_22','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_23','PK_VPX_HIST_STAT3_23','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_24','PK_VPX_HIST_STAT3_24','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_25','PK_VPX_HIST_STAT3_25','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_26','PK_VPX_HIST_STAT3_26','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_27','PK_VPX_HIST_STAT3_27','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_28','PK_VPX_HIST_STAT3_28','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_29','PK_VPX_HIST_STAT3_29','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_30','PK_VPX_HIST_STAT3_30','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_31','PK_VPX_HIST_STAT3_31','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_32','PK_VPX_HIST_STAT3_32','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_1','IX_VPX_HIST_STAT3_1_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_2','IX_VPX_HIST_STAT3_2_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_3','IX_VPX_HIST_STAT3_3_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_4','IX_VPX_HIST_STAT3_4_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_5','IX_VPX_HIST_STAT3_5_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_6','IX_VPX_HIST_STAT3_6_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_7','IX_VPX_HIST_STAT3_7_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_8','IX_VPX_HIST_STAT3_8_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_9','IX_VPX_HIST_STAT3_9_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_10','IX_VPX_HIST_STAT3_10_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_11','IX_VPX_HIST_STAT3_11_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_12','IX_VPX_HIST_STAT3_12_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_13','IX_VPX_HIST_STAT3_13_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_14','IX_VPX_HIST_STAT3_14_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_15','IX_VPX_HIST_STAT3_15_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_16','IX_VPX_HIST_STAT3_16_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_17','IX_VPX_HIST_STAT3_17_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_18','IX_VPX_HIST_STAT3_18_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_19','IX_VPX_HIST_STAT3_19_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_20','IX_VPX_HIST_STAT3_20_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_21','IX_VPX_HIST_STAT3_21_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_22','IX_VPX_HIST_STAT3_22_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_23','IX_VPX_HIST_STAT3_23_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_24','IX_VPX_HIST_STAT3_24_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_25','IX_VPX_HIST_STAT3_25_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_26','IX_VPX_HIST_STAT3_26_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_27','IX_VPX_HIST_STAT3_27_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_28','IX_VPX_HIST_STAT3_28_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_29','IX_VPX_HIST_STAT3_29_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_30','IX_VPX_HIST_STAT3_30_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_31','IX_VPX_HIST_STAT3_31_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_32','IX_VPX_HIST_STAT3_32_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_2','PK_VPX_HIST_STAT4_2','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_3','PK_VPX_HIST_STAT4_3','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_4','PK_VPX_HIST_STAT4_4','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_5','PK_VPX_HIST_STAT4_5','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_7','PK_VPX_HIST_STAT4_7','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_8','PK_VPX_HIST_STAT4_8','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_9','PK_VPX_HIST_STAT4_9','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_10','PK_VPX_HIST_STAT4_10','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_11','PK_VPX_HIST_STAT4_11','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_12','PK_VPX_HIST_STAT4_12','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_13','PK_VPX_HIST_STAT4_13','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_14','PK_VPX_HIST_STAT4_14','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_15','PK_VPX_HIST_STAT4_15','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_16','PK_VPX_HIST_STAT4_16','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_17','PK_VPX_HIST_STAT4_17','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_18','PK_VPX_HIST_STAT4_18','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_19','PK_VPX_HIST_STAT4_19','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_20','PK_VPX_HIST_STAT4_20','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_21','PK_VPX_HIST_STAT4_21','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_22','PK_VPX_HIST_STAT4_22','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_23','PK_VPX_HIST_STAT4_23','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_24','PK_VPX_HIST_STAT4_24','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_25','PK_VPX_HIST_STAT4_25','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_26','PK_VPX_HIST_STAT4_26','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_27','PK_VPX_HIST_STAT4_27','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_28','PK_VPX_HIST_STAT4_28','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_29','PK_VPX_HIST_STAT4_29','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_30','PK_VPX_HIST_STAT4_30','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_32','PK_VPX_HIST_STAT4_32','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_33','PK_VPX_HIST_STAT4_33','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_34','PK_VPX_HIST_STAT4_34','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_35','PK_VPX_HIST_STAT4_35','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_36','PK_VPX_HIST_STAT4_36','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_37','PK_VPX_HIST_STAT4_37','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_38','PK_VPX_HIST_STAT4_38','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_39','PK_VPX_HIST_STAT4_39','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_40','PK_VPX_HIST_STAT4_40','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_41','PK_VPX_HIST_STAT4_41','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_42','PK_VPX_HIST_STAT4_42','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_43','PK_VPX_HIST_STAT4_43','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_44','PK_VPX_HIST_STAT4_44','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_45','PK_VPX_HIST_STAT4_45','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_46','PK_VPX_HIST_STAT4_46','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_47','PK_VPX_HIST_STAT4_47','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_48','PK_VPX_HIST_STAT4_48','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_50','PK_VPX_HIST_STAT4_50','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_51','PK_VPX_HIST_STAT4_51','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_52','PK_VPX_HIST_STAT4_52','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_53','PK_VPX_HIST_STAT4_53','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_54','PK_VPX_HIST_STAT4_54','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_55','PK_VPX_HIST_STAT4_55','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_56','PK_VPX_HIST_STAT4_56','I');
 /
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_57','PK_VPX_HIST_STAT4_57','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_58','PK_VPX_HIST_STAT4_58','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_59','PK_VPX_HIST_STAT4_59','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_60','PK_VPX_HIST_STAT4_60','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_61','PK_VPX_HIST_STAT4_61','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_62','PK_VPX_HIST_STAT4_62','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_63','PK_VPX_HIST_STAT4_63','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_64','PK_VPX_HIST_STAT4_64','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_65','PK_VPX_HIST_STAT4_65','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_66','PK_VPX_HIST_STAT4_66','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_67','PK_VPX_HIST_STAT4_67','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_68','PK_VPX_HIST_STAT4_68','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_69','PK_VPX_HIST_STAT4_69','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_70','PK_VPX_HIST_STAT4_70','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_71','PK_VPX_HIST_STAT4_71','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_72','PK_VPX_HIST_STAT4_72','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_73','PK_VPX_HIST_STAT4_73','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_74','PK_VPX_HIST_STAT4_74','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_75','PK_VPX_HIST_STAT4_75','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_77','PK_VPX_HIST_STAT4_77','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_78','PK_VPX_HIST_STAT4_78','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_79','PK_VPX_HIST_STAT4_79','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_80','PK_VPX_HIST_STAT4_80','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_81','PK_VPX_HIST_STAT4_81','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_82','PK_VPX_HIST_STAT4_82','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_83','PK_VPX_HIST_STAT4_83','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_84','PK_VPX_HIST_STAT4_84','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_85','PK_VPX_HIST_STAT4_85','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_86','PK_VPX_HIST_STAT4_86','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_87','PK_VPX_HIST_STAT4_87','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_88','PK_VPX_HIST_STAT4_88','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_89','PK_VPX_HIST_STAT4_89','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_90','PK_VPX_HIST_STAT4_90','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_91','PK_VPX_HIST_STAT4_91','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_92','PK_VPX_HIST_STAT4_92','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_93','PK_VPX_HIST_STAT4_93','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_95','PK_VPX_HIST_STAT4_95','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_96','PK_VPX_HIST_STAT4_96','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_97','PK_VPX_HIST_STAT4_97','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_98','PK_VPX_HIST_STAT4_98','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_99','PK_VPX_HIST_STAT4_99','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_100','PK_VPX_HIST_STAT4_100','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_101','PK_VPX_HIST_STAT4_101','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_102','PK_VPX_HIST_STAT4_102','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_103','PK_VPX_HIST_STAT4_103','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_104','PK_VPX_HIST_STAT4_104','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_105','PK_VPX_HIST_STAT4_105','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_106','PK_VPX_HIST_STAT4_106','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_107','PK_VPX_HIST_STAT4_107','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_108','PK_VPX_HIST_STAT4_108','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_109','PK_VPX_HIST_STAT4_109','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_110','PK_VPX_HIST_STAT4_110','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_111','PK_VPX_HIST_STAT4_111','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_112','PK_VPX_HIST_STAT4_112','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_113','PK_VPX_HIST_STAT4_113','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_114','PK_VPX_HIST_STAT4_114','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_115','PK_VPX_HIST_STAT4_115','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_116','PK_VPX_HIST_STAT4_116','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_117','PK_VPX_HIST_STAT4_117','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_118','PK_VPX_HIST_STAT4_118','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_119','PK_VPX_HIST_STAT4_119','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_120','PK_VPX_HIST_STAT4_120','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_122','PK_VPX_HIST_STAT4_122','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_123','PK_VPX_HIST_STAT4_123','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_124','PK_VPX_HIST_STAT4_124','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_125','PK_VPX_HIST_STAT4_125','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_126','PK_VPX_HIST_STAT4_126','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_127','PK_VPX_HIST_STAT4_127','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_128','PK_VPX_HIST_STAT4_128','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_129','PK_VPX_HIST_STAT4_129','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_130','PK_VPX_HIST_STAT4_130','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_131','PK_VPX_HIST_STAT4_131','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_132','PK_VPX_HIST_STAT4_132','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_133','PK_VPX_HIST_STAT4_133','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_134','PK_VPX_HIST_STAT4_134','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_135','PK_VPX_HIST_STAT4_135','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_136','PK_VPX_HIST_STAT4_136','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_137','PK_VPX_HIST_STAT4_137','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_138','PK_VPX_HIST_STAT4_138','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_140','PK_VPX_HIST_STAT4_140','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_141','PK_VPX_HIST_STAT4_141','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_142','PK_VPX_HIST_STAT4_142','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_143','PK_VPX_HIST_STAT4_143','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_144','PK_VPX_HIST_STAT4_144','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_145','PK_VPX_HIST_STAT4_145','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_146','PK_VPX_HIST_STAT4_146','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_147','PK_VPX_HIST_STAT4_147','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_148','PK_VPX_HIST_STAT4_148','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_149','PK_VPX_HIST_STAT4_149','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_150','PK_VPX_HIST_STAT4_150','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_151','PK_VPX_HIST_STAT4_151','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_152','PK_VPX_HIST_STAT4_152','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_153','PK_VPX_HIST_STAT4_153','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_154','PK_VPX_HIST_STAT4_154','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_155','PK_VPX_HIST_STAT4_155','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_156','PK_VPX_HIST_STAT4_156','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_157','PK_VPX_HIST_STAT4_157','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_158','PK_VPX_HIST_STAT4_158','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_159','PK_VPX_HIST_STAT4_159','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_160','PK_VPX_HIST_STAT4_160','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_161','PK_VPX_HIST_STAT4_161','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_162','PK_VPX_HIST_STAT4_162','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_163','PK_VPX_HIST_STAT4_163','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_164','PK_VPX_HIST_STAT4_164','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_165','PK_VPX_HIST_STAT4_165','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_1','PK_VPX_HIST_STAT4_1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_6','PK_VPX_HIST_STAT4_6','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_31','PK_VPX_HIST_STAT4_31','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_49','PK_VPX_HIST_STAT4_49','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_76','PK_VPX_HIST_STAT4_76','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_94','PK_VPX_HIST_STAT4_94','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_121','PK_VPX_HIST_STAT4_121','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_139','PK_VPX_HIST_STAT4_139','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_166','PK_VPX_HIST_STAT4_166','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_167','PK_VPX_HIST_STAT4_167','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_168','PK_VPX_HIST_STAT4_168','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_169','PK_VPX_HIST_STAT4_169','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_170','PK_VPX_HIST_STAT4_170','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_171','PK_VPX_HIST_STAT4_171','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_172','PK_VPX_HIST_STAT4_172','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_173','PK_VPX_HIST_STAT4_173','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_174','PK_VPX_HIST_STAT4_174','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_175','PK_VPX_HIST_STAT4_175','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_176','PK_VPX_HIST_STAT4_176','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_177','PK_VPX_HIST_STAT4_177','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_178','PK_VPX_HIST_STAT4_178','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_179','PK_VPX_HIST_STAT4_179','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_180','PK_VPX_HIST_STAT4_180','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_181','PK_VPX_HIST_STAT4_181','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_182','PK_VPX_HIST_STAT4_182','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_183','PK_VPX_HIST_STAT4_183','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_1','IX_VPX_HIST_STAT4_1_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_2','IX_VPX_HIST_STAT4_2_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_3','IX_VPX_HIST_STAT4_3_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_4','IX_VPX_HIST_STAT4_4_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_5','IX_VPX_HIST_STAT4_5_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_6','IX_VPX_HIST_STAT4_6_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_7','IX_VPX_HIST_STAT4_7_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_8','IX_VPX_HIST_STAT4_8_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_9','IX_VPX_HIST_STAT4_9_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_10','IX_VPX_HIST_STAT4_10_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_11','IX_VPX_HIST_STAT4_11_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_12','IX_VPX_HIST_STAT4_12_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_13','IX_VPX_HIST_STAT4_13_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_14','IX_VPX_HIST_STAT4_14_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_15','IX_VPX_HIST_STAT4_15_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_16','IX_VPX_HIST_STAT4_16_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_17','IX_VPX_HIST_STAT4_17_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_18','IX_VPX_HIST_STAT4_18_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_19','IX_VPX_HIST_STAT4_19_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_20','IX_VPX_HIST_STAT4_20_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_21','IX_VPX_HIST_STAT4_21_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_22','IX_VPX_HIST_STAT4_22_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_23','IX_VPX_HIST_STAT4_23_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_24','IX_VPX_HIST_STAT4_24_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_25','IX_VPX_HIST_STAT4_25_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_26','IX_VPX_HIST_STAT4_26_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_27','IX_VPX_HIST_STAT4_27_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_28','IX_VPX_HIST_STAT4_28_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_29','IX_VPX_HIST_STAT4_29_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_30','IX_VPX_HIST_STAT4_30_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_31','IX_VPX_HIST_STAT4_31_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_32','IX_VPX_HIST_STAT4_32_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_33','IX_VPX_HIST_STAT4_33_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_34','IX_VPX_HIST_STAT4_34_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_35','IX_VPX_HIST_STAT4_35_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_36','IX_VPX_HIST_STAT4_36_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_37','IX_VPX_HIST_STAT4_37_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_38','IX_VPX_HIST_STAT4_38_TID','I');
 /
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_39','IX_VPX_HIST_STAT4_39_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_40','IX_VPX_HIST_STAT4_40_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_41','IX_VPX_HIST_STAT4_41_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_42','IX_VPX_HIST_STAT4_42_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_43','IX_VPX_HIST_STAT4_43_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_44','IX_VPX_HIST_STAT4_44_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_45','IX_VPX_HIST_STAT4_45_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_46','IX_VPX_HIST_STAT4_46_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_47','IX_VPX_HIST_STAT4_47_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_48','IX_VPX_HIST_STAT4_48_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_49','IX_VPX_HIST_STAT4_49_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_50','IX_VPX_HIST_STAT4_50_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_51','IX_VPX_HIST_STAT4_51_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_52','IX_VPX_HIST_STAT4_52_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_53','IX_VPX_HIST_STAT4_53_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_54','IX_VPX_HIST_STAT4_54_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_55','IX_VPX_HIST_STAT4_55_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_56','IX_VPX_HIST_STAT4_56_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_57','IX_VPX_HIST_STAT4_57_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_58','IX_VPX_HIST_STAT4_58_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_59','IX_VPX_HIST_STAT4_59_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_60','IX_VPX_HIST_STAT4_60_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_61','IX_VPX_HIST_STAT4_61_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_62','IX_VPX_HIST_STAT4_62_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_63','IX_VPX_HIST_STAT4_63_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_64','IX_VPX_HIST_STAT4_64_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_65','IX_VPX_HIST_STAT4_65_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_66','IX_VPX_HIST_STAT4_66_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_67','IX_VPX_HIST_STAT4_67_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_68','IX_VPX_HIST_STAT4_68_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_69','IX_VPX_HIST_STAT4_69_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_70','IX_VPX_HIST_STAT4_70_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_71','IX_VPX_HIST_STAT4_71_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_72','IX_VPX_HIST_STAT4_72_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_73','IX_VPX_HIST_STAT4_73_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_74','IX_VPX_HIST_STAT4_74_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_75','IX_VPX_HIST_STAT4_75_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_76','IX_VPX_HIST_STAT4_76_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_77','IX_VPX_HIST_STAT4_77_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_78','IX_VPX_HIST_STAT4_78_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_79','IX_VPX_HIST_STAT4_79_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_80','IX_VPX_HIST_STAT4_80_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_81','IX_VPX_HIST_STAT4_81_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_82','IX_VPX_HIST_STAT4_82_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_83','IX_VPX_HIST_STAT4_83_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_84','IX_VPX_HIST_STAT4_84_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_85','IX_VPX_HIST_STAT4_85_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_86','IX_VPX_HIST_STAT4_86_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_87','IX_VPX_HIST_STAT4_87_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_88','IX_VPX_HIST_STAT4_88_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_89','IX_VPX_HIST_STAT4_89_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_90','IX_VPX_HIST_STAT4_90_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_91','IX_VPX_HIST_STAT4_91_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_92','IX_VPX_HIST_STAT4_92_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_93','IX_VPX_HIST_STAT4_93_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_94','IX_VPX_HIST_STAT4_94_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_95','IX_VPX_HIST_STAT4_95_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_96','IX_VPX_HIST_STAT4_96_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_97','IX_VPX_HIST_STAT4_97_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_98','IX_VPX_HIST_STAT4_98_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_99','IX_VPX_HIST_STAT4_99_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_100','IX_VPX_HIST_STAT4_100_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_101','IX_VPX_HIST_STAT4_101_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_102','IX_VPX_HIST_STAT4_102_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_103','IX_VPX_HIST_STAT4_103_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_104','IX_VPX_HIST_STAT4_104_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_105','IX_VPX_HIST_STAT4_105_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_106','IX_VPX_HIST_STAT4_106_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_107','IX_VPX_HIST_STAT4_107_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_108','IX_VPX_HIST_STAT4_108_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_109','IX_VPX_HIST_STAT4_109_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_110','IX_VPX_HIST_STAT4_110_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_111','IX_VPX_HIST_STAT4_111_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_112','IX_VPX_HIST_STAT4_112_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_113','IX_VPX_HIST_STAT4_113_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_114','IX_VPX_HIST_STAT4_114_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_115','IX_VPX_HIST_STAT4_115_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_116','IX_VPX_HIST_STAT4_116_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_117','IX_VPX_HIST_STAT4_117_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_118','IX_VPX_HIST_STAT4_118_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_119','IX_VPX_HIST_STAT4_119_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_120','IX_VPX_HIST_STAT4_120_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_121','IX_VPX_HIST_STAT4_121_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_122','IX_VPX_HIST_STAT4_122_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_123','IX_VPX_HIST_STAT4_123_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_124','IX_VPX_HIST_STAT4_124_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_125','IX_VPX_HIST_STAT4_125_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_126','IX_VPX_HIST_STAT4_126_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_127','IX_VPX_HIST_STAT4_127_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_128','IX_VPX_HIST_STAT4_128_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_129','IX_VPX_HIST_STAT4_129_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_130','IX_VPX_HIST_STAT4_130_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_131','IX_VPX_HIST_STAT4_131_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_132','IX_VPX_HIST_STAT4_132_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_133','IX_VPX_HIST_STAT4_133_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_134','IX_VPX_HIST_STAT4_134_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_135','IX_VPX_HIST_STAT4_135_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_136','IX_VPX_HIST_STAT4_136_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_137','IX_VPX_HIST_STAT4_137_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_138','IX_VPX_HIST_STAT4_138_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_139','IX_VPX_HIST_STAT4_139_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_140','IX_VPX_HIST_STAT4_140_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_141','IX_VPX_HIST_STAT4_141_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_142','IX_VPX_HIST_STAT4_142_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_143','IX_VPX_HIST_STAT4_143_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_144','IX_VPX_HIST_STAT4_144_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_145','IX_VPX_HIST_STAT4_145_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_146','IX_VPX_HIST_STAT4_146_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_147','IX_VPX_HIST_STAT4_147_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_148','IX_VPX_HIST_STAT4_148_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_149','IX_VPX_HIST_STAT4_149_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_150','IX_VPX_HIST_STAT4_150_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_151','IX_VPX_HIST_STAT4_151_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_152','IX_VPX_HIST_STAT4_152_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_153','IX_VPX_HIST_STAT4_153_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_154','IX_VPX_HIST_STAT4_154_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_155','IX_VPX_HIST_STAT4_155_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_156','IX_VPX_HIST_STAT4_156_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_157','IX_VPX_HIST_STAT4_157_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_158','IX_VPX_HIST_STAT4_158_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_159','IX_VPX_HIST_STAT4_159_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_160','IX_VPX_HIST_STAT4_160_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_161','IX_VPX_HIST_STAT4_161_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_162','IX_VPX_HIST_STAT4_162_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_163','IX_VPX_HIST_STAT4_163_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_164','IX_VPX_HIST_STAT4_164_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_165','IX_VPX_HIST_STAT4_165_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_166','IX_VPX_HIST_STAT4_166_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_167','IX_VPX_HIST_STAT4_167_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_168','IX_VPX_HIST_STAT4_168_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_169','IX_VPX_HIST_STAT4_169_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_170','IX_VPX_HIST_STAT4_170_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_171','IX_VPX_HIST_STAT4_171_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_172','IX_VPX_HIST_STAT4_172_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_173','IX_VPX_HIST_STAT4_173_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_174','IX_VPX_HIST_STAT4_174_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_175','IX_VPX_HIST_STAT4_175_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_176','IX_VPX_HIST_STAT4_176_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_177','IX_VPX_HIST_STAT4_177_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_178','IX_VPX_HIST_STAT4_178_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_179','IX_VPX_HIST_STAT4_179_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_180','IX_VPX_HIST_STAT4_180_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_181','IX_VPX_HIST_STAT4_181_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_182','IX_VPX_HIST_STAT4_182_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_183','IX_VPX_HIST_STAT4_183_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_2','PK_VPX_HIST_STAT1_2','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_3','PK_VPX_HIST_STAT1_3','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_4','PK_VPX_HIST_STAT1_4','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_5','PK_VPX_HIST_STAT1_5','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_6','PK_VPX_HIST_STAT1_6','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_7','PK_VPX_HIST_STAT1_7','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_8','PK_VPX_HIST_STAT1_8','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_9','PK_VPX_HIST_STAT1_9','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_10','PK_VPX_HIST_STAT1_10','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_11','PK_VPX_HIST_STAT1_11','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_12','PK_VPX_HIST_STAT1_12','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_13','PK_VPX_HIST_STAT1_13','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_14','PK_VPX_HIST_STAT1_14','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_15','PK_VPX_HIST_STAT1_15','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_16','PK_VPX_HIST_STAT1_16','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_17','PK_VPX_HIST_STAT1_17','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_18','PK_VPX_HIST_STAT1_18','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_19','PK_VPX_HIST_STAT1_19','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_21','PK_VPX_HIST_STAT1_21','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_22','PK_VPX_HIST_STAT1_22','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_23','PK_VPX_HIST_STAT1_23','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_25','PK_VPX_HIST_STAT1_25','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_26','PK_VPX_HIST_STAT1_26','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_27','PK_VPX_HIST_STAT1_27','I');
 /
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_28','PK_VPX_HIST_STAT1_28','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_29','PK_VPX_HIST_STAT1_29','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_30','PK_VPX_HIST_STAT1_30','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_31','PK_VPX_HIST_STAT1_31','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_32','PK_VPX_HIST_STAT1_32','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_33','PK_VPX_HIST_STAT1_33','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_34','PK_VPX_HIST_STAT1_34','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_35','PK_VPX_HIST_STAT1_35','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_36','PK_VPX_HIST_STAT1_36','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_37','PK_VPX_HIST_STAT1_37','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_38','PK_VPX_HIST_STAT1_38','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_39','PK_VPX_HIST_STAT1_39','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_40','PK_VPX_HIST_STAT1_40','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_41','PK_VPX_HIST_STAT1_41','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_43','PK_VPX_HIST_STAT1_43','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_44','PK_VPX_HIST_STAT1_44','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_45','PK_VPX_HIST_STAT1_45','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_46','PK_VPX_HIST_STAT1_46','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_47','PK_VPX_HIST_STAT1_47','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_48','PK_VPX_HIST_STAT1_48','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_49','PK_VPX_HIST_STAT1_49','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_50','PK_VPX_HIST_STAT1_50','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_51','PK_VPX_HIST_STAT1_51','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_52','PK_VPX_HIST_STAT1_52','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_53','PK_VPX_HIST_STAT1_53','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_54','PK_VPX_HIST_STAT1_54','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_55','PK_VPX_HIST_STAT1_55','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_56','PK_VPX_HIST_STAT1_56','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_57','PK_VPX_HIST_STAT1_57','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_58','PK_VPX_HIST_STAT1_58','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_59','PK_VPX_HIST_STAT1_59','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_60','PK_VPX_HIST_STAT1_60','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_61','PK_VPX_HIST_STAT1_61','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_62','PK_VPX_HIST_STAT1_62','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_63','PK_VPX_HIST_STAT1_63','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_64','PK_VPX_HIST_STAT1_64','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_65','PK_VPX_HIST_STAT1_65','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_66','PK_VPX_HIST_STAT1_66','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_67','PK_VPX_HIST_STAT1_67','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_68','PK_VPX_HIST_STAT1_68','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_70','PK_VPX_HIST_STAT1_70','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_71','PK_VPX_HIST_STAT1_71','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_72','PK_VPX_HIST_STAT1_72','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_73','PK_VPX_HIST_STAT1_73','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_74','PK_VPX_HIST_STAT1_74','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_75','PK_VPX_HIST_STAT1_75','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_76','PK_VPX_HIST_STAT1_76','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_77','PK_VPX_HIST_STAT1_77','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_78','PK_VPX_HIST_STAT1_78','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_79','PK_VPX_HIST_STAT1_79','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_80','PK_VPX_HIST_STAT1_80','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_81','PK_VPX_HIST_STAT1_81','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_82','PK_VPX_HIST_STAT1_82','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_83','PK_VPX_HIST_STAT1_83','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_84','PK_VPX_HIST_STAT1_84','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_85','PK_VPX_HIST_STAT1_85','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_86','PK_VPX_HIST_STAT1_86','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_88','PK_VPX_HIST_STAT1_88','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_89','PK_VPX_HIST_STAT1_89','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_90','PK_VPX_HIST_STAT1_90','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_91','PK_VPX_HIST_STAT1_91','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_92','PK_VPX_HIST_STAT1_92','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_93','PK_VPX_HIST_STAT1_93','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_94','PK_VPX_HIST_STAT1_94','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_95','PK_VPX_HIST_STAT1_95','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_96','PK_VPX_HIST_STAT1_96','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_97','PK_VPX_HIST_STAT1_97','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_98','PK_VPX_HIST_STAT1_98','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_99','PK_VPX_HIST_STAT1_99','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_100','PK_VPX_HIST_STAT1_100','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_101','PK_VPX_HIST_STAT1_101','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_102','PK_VPX_HIST_STAT1_102','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_103','PK_VPX_HIST_STAT1_103','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_104','PK_VPX_HIST_STAT1_104','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_105','PK_VPX_HIST_STAT1_105','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_106','PK_VPX_HIST_STAT1_106','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_107','PK_VPX_HIST_STAT1_107','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_108','PK_VPX_HIST_STAT1_108','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_109','PK_VPX_HIST_STAT1_109','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_110','PK_VPX_HIST_STAT1_110','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_111','PK_VPX_HIST_STAT1_111','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_112','PK_VPX_HIST_STAT1_112','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_113','PK_VPX_HIST_STAT1_113','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_115','PK_VPX_HIST_STAT1_115','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_116','PK_VPX_HIST_STAT1_116','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_117','PK_VPX_HIST_STAT1_117','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_118','PK_VPX_HIST_STAT1_118','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_119','PK_VPX_HIST_STAT1_119','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_120','PK_VPX_HIST_STAT1_120','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_121','PK_VPX_HIST_STAT1_121','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_122','PK_VPX_HIST_STAT1_122','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_123','PK_VPX_HIST_STAT1_123','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_124','PK_VPX_HIST_STAT1_124','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_125','PK_VPX_HIST_STAT1_125','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_126','PK_VPX_HIST_STAT1_126','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_127','PK_VPX_HIST_STAT1_127','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_128','PK_VPX_HIST_STAT1_128','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_129','PK_VPX_HIST_STAT1_129','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_130','PK_VPX_HIST_STAT1_130','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_131','PK_VPX_HIST_STAT1_131','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_133','PK_VPX_HIST_STAT1_133','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_134','PK_VPX_HIST_STAT1_134','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_135','PK_VPX_HIST_STAT1_135','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_136','PK_VPX_HIST_STAT1_136','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_137','PK_VPX_HIST_STAT1_137','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_138','PK_VPX_HIST_STAT1_138','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_139','PK_VPX_HIST_STAT1_139','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_140','PK_VPX_HIST_STAT1_140','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_141','PK_VPX_HIST_STAT1_141','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_142','PK_VPX_HIST_STAT1_142','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_143','PK_VPX_HIST_STAT1_143','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_144','PK_VPX_HIST_STAT1_144','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_145','PK_VPX_HIST_STAT1_145','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_146','PK_VPX_HIST_STAT1_146','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_147','PK_VPX_HIST_STAT1_147','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_148','PK_VPX_HIST_STAT1_148','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_149','PK_VPX_HIST_STAT1_149','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_150','PK_VPX_HIST_STAT1_150','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_151','PK_VPX_HIST_STAT1_151','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_152','PK_VPX_HIST_STAT1_152','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_153','PK_VPX_HIST_STAT1_153','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_154','PK_VPX_HIST_STAT1_154','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_155','PK_VPX_HIST_STAT1_155','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_156','PK_VPX_HIST_STAT1_156','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_157','PK_VPX_HIST_STAT1_157','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_158','PK_VPX_HIST_STAT1_158','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_160','PK_VPX_HIST_STAT1_160','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_161','PK_VPX_HIST_STAT1_161','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_162','PK_VPX_HIST_STAT1_162','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_163','PK_VPX_HIST_STAT1_163','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_164','PK_VPX_HIST_STAT1_164','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_165','PK_VPX_HIST_STAT1_165','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_166','PK_VPX_HIST_STAT1_166','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_167','PK_VPX_HIST_STAT1_167','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_168','PK_VPX_HIST_STAT1_168','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_169','PK_VPX_HIST_STAT1_169','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_170','PK_VPX_HIST_STAT1_170','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_171','PK_VPX_HIST_STAT1_171','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_172','PK_VPX_HIST_STAT1_172','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_173','PK_VPX_HIST_STAT1_173','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_174','PK_VPX_HIST_STAT1_174','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_175','PK_VPX_HIST_STAT1_175','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_176','PK_VPX_HIST_STAT1_176','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_178','PK_VPX_HIST_STAT1_178','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_179','PK_VPX_HIST_STAT1_179','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_180','PK_VPX_HIST_STAT1_180','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_181','PK_VPX_HIST_STAT1_181','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_182','PK_VPX_HIST_STAT1_182','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_183','PK_VPX_HIST_STAT1_183','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_184','PK_VPX_HIST_STAT1_184','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_185','PK_VPX_HIST_STAT1_185','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_186','PK_VPX_HIST_STAT1_186','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_187','PK_VPX_HIST_STAT1_187','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_188','PK_VPX_HIST_STAT1_188','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_189','PK_VPX_HIST_STAT1_189','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_190','PK_VPX_HIST_STAT1_190','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_191','PK_VPX_HIST_STAT1_191','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_192','PK_VPX_HIST_STAT1_192','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_193','PK_VPX_HIST_STAT1_193','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_194','PK_VPX_HIST_STAT1_194','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_195','PK_VPX_HIST_STAT1_195','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_196','PK_VPX_HIST_STAT1_196','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_197','PK_VPX_HIST_STAT1_197','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_198','PK_VPX_HIST_STAT1_198','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_199','PK_VPX_HIST_STAT1_199','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_200','PK_VPX_HIST_STAT1_200','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_201','PK_VPX_HIST_STAT1_201','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_202','PK_VPX_HIST_STAT1_202','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_203','PK_VPX_HIST_STAT1_203','I');
 /
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_1','PK_VPX_HIST_STAT1_1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_20','PK_VPX_HIST_STAT1_20','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_24','PK_VPX_HIST_STAT1_24','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_42','PK_VPX_HIST_STAT1_42','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_69','PK_VPX_HIST_STAT1_69','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_87','PK_VPX_HIST_STAT1_87','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_114','PK_VPX_HIST_STAT1_114','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_205','PK_VPX_HIST_STAT1_205','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_206','PK_VPX_HIST_STAT1_206','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_207','PK_VPX_HIST_STAT1_207','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_208','PK_VPX_HIST_STAT1_208','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_209','PK_VPX_HIST_STAT1_209','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_210','PK_VPX_HIST_STAT1_210','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_211','PK_VPX_HIST_STAT1_211','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_212','PK_VPX_HIST_STAT1_212','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_213','PK_VPX_HIST_STAT1_213','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_214','PK_VPX_HIST_STAT1_214','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_215','PK_VPX_HIST_STAT1_215','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_216','PK_VPX_HIST_STAT1_216','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_217','PK_VPX_HIST_STAT1_217','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_218','PK_VPX_HIST_STAT1_218','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_219','PK_VPX_HIST_STAT1_219','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_220','PK_VPX_HIST_STAT1_220','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_221','PK_VPX_HIST_STAT1_221','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_223','PK_VPX_HIST_STAT1_223','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_224','PK_VPX_HIST_STAT1_224','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_225','PK_VPX_HIST_STAT1_225','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_226','PK_VPX_HIST_STAT1_226','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_227','PK_VPX_HIST_STAT1_227','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_228','PK_VPX_HIST_STAT1_228','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_229','PK_VPX_HIST_STAT1_229','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_230','PK_VPX_HIST_STAT1_230','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_231','PK_VPX_HIST_STAT1_231','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_232','PK_VPX_HIST_STAT1_232','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_233','PK_VPX_HIST_STAT1_233','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_234','PK_VPX_HIST_STAT1_234','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_235','PK_VPX_HIST_STAT1_235','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_236','PK_VPX_HIST_STAT1_236','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_237','PK_VPX_HIST_STAT1_237','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_238','PK_VPX_HIST_STAT1_238','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_239','PK_VPX_HIST_STAT1_239','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_240','PK_VPX_HIST_STAT1_240','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_241','PK_VPX_HIST_STAT1_241','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_132','PK_VPX_HIST_STAT1_132','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_159','PK_VPX_HIST_STAT1_159','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_177','PK_VPX_HIST_STAT1_177','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_204','PK_VPX_HIST_STAT1_204','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_222','PK_VPX_HIST_STAT1_222','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_1','IX_VPX_HIST_STAT1_1_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_2','IX_VPX_HIST_STAT1_2_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_3','IX_VPX_HIST_STAT1_3_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_4','IX_VPX_HIST_STAT1_4_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_5','IX_VPX_HIST_STAT1_5_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_6','IX_VPX_HIST_STAT1_6_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_7','IX_VPX_HIST_STAT1_7_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_8','IX_VPX_HIST_STAT1_8_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_9','IX_VPX_HIST_STAT1_9_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_10','IX_VPX_HIST_STAT1_10_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_11','IX_VPX_HIST_STAT1_11_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_12','IX_VPX_HIST_STAT1_12_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_13','IX_VPX_HIST_STAT1_13_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_14','IX_VPX_HIST_STAT1_14_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_15','IX_VPX_HIST_STAT1_15_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_16','IX_VPX_HIST_STAT1_16_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_17','IX_VPX_HIST_STAT1_17_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_18','IX_VPX_HIST_STAT1_18_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_19','IX_VPX_HIST_STAT1_19_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_20','IX_VPX_HIST_STAT1_20_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_21','IX_VPX_HIST_STAT1_21_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_22','IX_VPX_HIST_STAT1_22_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_23','IX_VPX_HIST_STAT1_23_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_24','IX_VPX_HIST_STAT1_24_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_25','IX_VPX_HIST_STAT1_25_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_26','IX_VPX_HIST_STAT1_26_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_27','IX_VPX_HIST_STAT1_27_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_28','IX_VPX_HIST_STAT1_28_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_29','IX_VPX_HIST_STAT1_29_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_30','IX_VPX_HIST_STAT1_30_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_31','IX_VPX_HIST_STAT1_31_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_32','IX_VPX_HIST_STAT1_32_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_33','IX_VPX_HIST_STAT1_33_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_34','IX_VPX_HIST_STAT1_34_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_35','IX_VPX_HIST_STAT1_35_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_36','IX_VPX_HIST_STAT1_36_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_37','IX_VPX_HIST_STAT1_37_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_38','IX_VPX_HIST_STAT1_38_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_39','IX_VPX_HIST_STAT1_39_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_40','IX_VPX_HIST_STAT1_40_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_41','IX_VPX_HIST_STAT1_41_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_42','IX_VPX_HIST_STAT1_42_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_43','IX_VPX_HIST_STAT1_43_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_44','IX_VPX_HIST_STAT1_44_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_45','IX_VPX_HIST_STAT1_45_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_46','IX_VPX_HIST_STAT1_46_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_47','IX_VPX_HIST_STAT1_47_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_48','IX_VPX_HIST_STAT1_48_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_49','IX_VPX_HIST_STAT1_49_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_50','IX_VPX_HIST_STAT1_50_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_51','IX_VPX_HIST_STAT1_51_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_52','IX_VPX_HIST_STAT1_52_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_53','IX_VPX_HIST_STAT1_53_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_54','IX_VPX_HIST_STAT1_54_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_55','IX_VPX_HIST_STAT1_55_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_56','IX_VPX_HIST_STAT1_56_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_57','IX_VPX_HIST_STAT1_57_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_58','IX_VPX_HIST_STAT1_58_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_59','IX_VPX_HIST_STAT1_59_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_60','IX_VPX_HIST_STAT1_60_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_61','IX_VPX_HIST_STAT1_61_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_62','IX_VPX_HIST_STAT1_62_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_63','IX_VPX_HIST_STAT1_63_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_64','IX_VPX_HIST_STAT1_64_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_65','IX_VPX_HIST_STAT1_65_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_66','IX_VPX_HIST_STAT1_66_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_67','IX_VPX_HIST_STAT1_67_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_68','IX_VPX_HIST_STAT1_68_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_69','IX_VPX_HIST_STAT1_69_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_70','IX_VPX_HIST_STAT1_70_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_71','IX_VPX_HIST_STAT1_71_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_72','IX_VPX_HIST_STAT1_72_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_73','IX_VPX_HIST_STAT1_73_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_74','IX_VPX_HIST_STAT1_74_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_75','IX_VPX_HIST_STAT1_75_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_76','IX_VPX_HIST_STAT1_76_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_77','IX_VPX_HIST_STAT1_77_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_78','IX_VPX_HIST_STAT1_78_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_79','IX_VPX_HIST_STAT1_79_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_80','IX_VPX_HIST_STAT1_80_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_81','IX_VPX_HIST_STAT1_81_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_82','IX_VPX_HIST_STAT1_82_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_83','IX_VPX_HIST_STAT1_83_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_84','IX_VPX_HIST_STAT1_84_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_85','IX_VPX_HIST_STAT1_85_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_86','IX_VPX_HIST_STAT1_86_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_87','IX_VPX_HIST_STAT1_87_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_88','IX_VPX_HIST_STAT1_88_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_89','IX_VPX_HIST_STAT1_89_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_90','IX_VPX_HIST_STAT1_90_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_91','IX_VPX_HIST_STAT1_91_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_92','IX_VPX_HIST_STAT1_92_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_93','IX_VPX_HIST_STAT1_93_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_94','IX_VPX_HIST_STAT1_94_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_95','IX_VPX_HIST_STAT1_95_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_96','IX_VPX_HIST_STAT1_96_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_97','IX_VPX_HIST_STAT1_97_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_98','IX_VPX_HIST_STAT1_98_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_99','IX_VPX_HIST_STAT1_99_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_100','IX_VPX_HIST_STAT1_100_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_101','IX_VPX_HIST_STAT1_101_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_102','IX_VPX_HIST_STAT1_102_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_103','IX_VPX_HIST_STAT1_103_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_104','IX_VPX_HIST_STAT1_104_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_105','IX_VPX_HIST_STAT1_105_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_106','IX_VPX_HIST_STAT1_106_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_107','IX_VPX_HIST_STAT1_107_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_108','IX_VPX_HIST_STAT1_108_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_109','IX_VPX_HIST_STAT1_109_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_110','IX_VPX_HIST_STAT1_110_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_111','IX_VPX_HIST_STAT1_111_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_112','IX_VPX_HIST_STAT1_112_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_113','IX_VPX_HIST_STAT1_113_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_114','IX_VPX_HIST_STAT1_114_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_115','IX_VPX_HIST_STAT1_115_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_116','IX_VPX_HIST_STAT1_116_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_117','IX_VPX_HIST_STAT1_117_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_118','IX_VPX_HIST_STAT1_118_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_119','IX_VPX_HIST_STAT1_119_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_120','IX_VPX_HIST_STAT1_120_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_121','IX_VPX_HIST_STAT1_121_TID','I');
 /
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_122','IX_VPX_HIST_STAT1_122_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_123','IX_VPX_HIST_STAT1_123_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_124','IX_VPX_HIST_STAT1_124_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_125','IX_VPX_HIST_STAT1_125_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_126','IX_VPX_HIST_STAT1_126_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_127','IX_VPX_HIST_STAT1_127_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_128','IX_VPX_HIST_STAT1_128_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_129','IX_VPX_HIST_STAT1_129_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_130','IX_VPX_HIST_STAT1_130_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_131','IX_VPX_HIST_STAT1_131_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_132','IX_VPX_HIST_STAT1_132_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_133','IX_VPX_HIST_STAT1_133_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_134','IX_VPX_HIST_STAT1_134_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_135','IX_VPX_HIST_STAT1_135_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_136','IX_VPX_HIST_STAT1_136_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_137','IX_VPX_HIST_STAT1_137_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_138','IX_VPX_HIST_STAT1_138_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_139','IX_VPX_HIST_STAT1_139_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_140','IX_VPX_HIST_STAT1_140_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_141','IX_VPX_HIST_STAT1_141_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_142','IX_VPX_HIST_STAT1_142_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_143','IX_VPX_HIST_STAT1_143_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_144','IX_VPX_HIST_STAT1_144_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_145','IX_VPX_HIST_STAT1_145_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_146','IX_VPX_HIST_STAT1_146_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_147','IX_VPX_HIST_STAT1_147_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_148','IX_VPX_HIST_STAT1_148_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_149','IX_VPX_HIST_STAT1_149_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_150','IX_VPX_HIST_STAT1_150_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_151','IX_VPX_HIST_STAT1_151_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_152','IX_VPX_HIST_STAT1_152_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_153','IX_VPX_HIST_STAT1_153_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_154','IX_VPX_HIST_STAT1_154_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_155','IX_VPX_HIST_STAT1_155_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_156','IX_VPX_HIST_STAT1_156_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_157','IX_VPX_HIST_STAT1_157_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_158','IX_VPX_HIST_STAT1_158_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_159','IX_VPX_HIST_STAT1_159_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_160','IX_VPX_HIST_STAT1_160_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_161','IX_VPX_HIST_STAT1_161_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_162','IX_VPX_HIST_STAT1_162_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_163','IX_VPX_HIST_STAT1_163_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_164','IX_VPX_HIST_STAT1_164_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_165','IX_VPX_HIST_STAT1_165_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_166','IX_VPX_HIST_STAT1_166_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_167','IX_VPX_HIST_STAT1_167_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_168','IX_VPX_HIST_STAT1_168_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_169','IX_VPX_HIST_STAT1_169_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_170','IX_VPX_HIST_STAT1_170_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_171','IX_VPX_HIST_STAT1_171_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_172','IX_VPX_HIST_STAT1_172_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_173','IX_VPX_HIST_STAT1_173_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_174','IX_VPX_HIST_STAT1_174_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_175','IX_VPX_HIST_STAT1_175_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_176','IX_VPX_HIST_STAT1_176_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_177','IX_VPX_HIST_STAT1_177_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_178','IX_VPX_HIST_STAT1_178_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_179','IX_VPX_HIST_STAT1_179_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_180','IX_VPX_HIST_STAT1_180_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_181','IX_VPX_HIST_STAT1_181_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_182','IX_VPX_HIST_STAT1_182_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_183','IX_VPX_HIST_STAT1_183_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_184','IX_VPX_HIST_STAT1_184_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_185','IX_VPX_HIST_STAT1_185_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_186','IX_VPX_HIST_STAT1_186_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_187','IX_VPX_HIST_STAT1_187_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_188','IX_VPX_HIST_STAT1_188_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_189','IX_VPX_HIST_STAT1_189_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_190','IX_VPX_HIST_STAT1_190_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_191','IX_VPX_HIST_STAT1_191_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_192','IX_VPX_HIST_STAT1_192_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_193','IX_VPX_HIST_STAT1_193_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_194','IX_VPX_HIST_STAT1_194_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_195','IX_VPX_HIST_STAT1_195_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_196','IX_VPX_HIST_STAT1_196_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_197','IX_VPX_HIST_STAT1_197_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_198','IX_VPX_HIST_STAT1_198_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_199','IX_VPX_HIST_STAT1_199_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_200','IX_VPX_HIST_STAT1_200_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_201','IX_VPX_HIST_STAT1_201_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_202','IX_VPX_HIST_STAT1_202_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_203','IX_VPX_HIST_STAT1_203_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_204','IX_VPX_HIST_STAT1_204_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_205','IX_VPX_HIST_STAT1_205_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_206','IX_VPX_HIST_STAT1_206_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_207','IX_VPX_HIST_STAT1_207_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_208','IX_VPX_HIST_STAT1_208_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_209','IX_VPX_HIST_STAT1_209_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_210','IX_VPX_HIST_STAT1_210_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_211','IX_VPX_HIST_STAT1_211_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_212','IX_VPX_HIST_STAT1_212_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_213','IX_VPX_HIST_STAT1_213_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_214','IX_VPX_HIST_STAT1_214_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_215','IX_VPX_HIST_STAT1_215_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_216','IX_VPX_HIST_STAT1_216_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_217','IX_VPX_HIST_STAT1_217_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_218','IX_VPX_HIST_STAT1_218_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_219','IX_VPX_HIST_STAT1_219_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_220','IX_VPX_HIST_STAT1_220_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_221','IX_VPX_HIST_STAT1_221_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_222','IX_VPX_HIST_STAT1_222_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_223','IX_VPX_HIST_STAT1_223_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_224','IX_VPX_HIST_STAT1_224_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_225','IX_VPX_HIST_STAT1_225_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_226','IX_VPX_HIST_STAT1_226_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_227','IX_VPX_HIST_STAT1_227_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_228','IX_VPX_HIST_STAT1_228_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_229','IX_VPX_HIST_STAT1_229_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_230','IX_VPX_HIST_STAT1_230_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_231','IX_VPX_HIST_STAT1_231_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_232','IX_VPX_HIST_STAT1_232_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_233','IX_VPX_HIST_STAT1_233_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_234','IX_VPX_HIST_STAT1_234_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_235','IX_VPX_HIST_STAT1_235_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_236','IX_VPX_HIST_STAT1_236_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_237','IX_VPX_HIST_STAT1_237_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_238','IX_VPX_HIST_STAT1_238_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_239','IX_VPX_HIST_STAT1_239_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_240','IX_VPX_HIST_STAT1_240_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_241','IX_VPX_HIST_STAT1_241_TID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VC_UPGRADE_ID','PK_VPX_UPGRADE_ID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_PROFILE','PK_VPX_PROF','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HOST_PROFILE','PK_VPX_HOST_PROF','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_PROFILE_ANSWER_FILE','PK_VPX_PROF_ANSFILE','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_COMPLIANCE_STATUS','PK_VPX_COMP_STAT','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_PROFILE_ENTITY_ASSOCIATION','PK_VPX_ENT_ASSO','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_ENTITY_LAST_EVENT','PK_VPX_LAST_EVENT','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_ENTITY_LAST_EVENT','VPX_ENTITY_LAST_EVENT_F1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_STAT_DEV_TYPE_DEF','PK_VPX_STAT_DEV_TYPE_DEF','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_STAT_DEV_TYPE_DEF','VPX_STAT_DEV_TYPE_DEF_U1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_STAT_DEV_TYPE','PK_VPX_STAT_DEV_TYPE','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HOST_INTERNAL_CAPABILITY','PK_HOST_INTERVAL_CAPABILITY','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_COMPUTE_RES_FAILOVER_HOST','PK_COMPUTE_RES_FAILOVER_HOST','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_COMPUTE_RES_FAILOVER_HOST','VPX_COMP_RES_FAILOVER_HOST_F1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VM_DS_SPACE','PK_VPX_VM_DS_SPACE','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VM_DS_SPACE','VPX_VM_DS_SPACE_F1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VM_CONFIG_INFO','PK_VPX_VM_CONFIG_INFO','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VM_CONFIG_INFO','VPXI_VCI_BOOT_OPTIN_RETRY_DELY','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VIRTUAL_DEVICE','PK_VPX_VIRTUAL_DEVICE','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VIRTUAL_DEVICE','VPX_VIRTUAL_DEVICE_U1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VDEVICE_BACKING_REL','PK_VPX_VDEVICE_BACKING_REL','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VDEVICE_BACKING_REL','VPX_VDEVICE_BACKING_REL_F1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VDEVICE_BACKING_REL','VPX_VDEVICE_BACKING_REL_U1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VDEVICE_DEVICE_BACKING','PK_VDEVICE_DEVICE_BACKING','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VDEVICE_DEVICE_BACKING','VPX_VDEVICE_DEVICE_BACKING_F1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VDEVICE_PLUGIN_BACKING','PK_VDEVICE_PLUGIN_BACKING','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VDEVICE_PLUGIN_BACKING','VPX_VDEVICE_PLUGIN_BACKING_F1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VDEVICE_FILE_BACKING','PK_VDEVICE_FILE_BACKING','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VDEVICE_FILE_BACKING','VPX_VDEVICE_FILE_BACKING_U1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VDEVICE_FILE_BACKING','VPX_VDEVICE_FILE_BACKING_M1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VDEVICE_FILE_BACKING','VPX_VDEVICE_FILE_BACKING_F1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VDEVICE_FILE_BACKING','IX_VPX_VDFB_VM_ID_UPDATE_KEY','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VDEVICE_FILE_BACKING_X','PK_VDEVICE_FILE_BACKING_X','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VDEVICE_FILE_BACKING_X','VPX_VDEVICE_FILE_BACKING_X_F1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VDEVICE_FILE_BACKING_X','VPX_VDEVICE_FILE_BACKING_X_M1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VDEVICE_FILE_BACKING_X','VPX_VDEVICE_FILE_BACKING_X_M2','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VDEVICE_DEVICE_BACKING_X','PK_VDEVICE_DEVICE_BACKING_X','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VDEVICE_DEVICE_BACKING_X','VPX_VDEVICE_DEVBACKING_X_F1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VDEVICE_PIPE_BACKING','PK_VPX_VDEVICE_PIPE_BACKING','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VDEVICE_PIPE_BACKING','VPX_VDEVICE_PIPE_BACKING_F1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DISTR_VPORT_BACKING','PK_VPX_DISTR_VPORT_BACKING','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DISTR_VPORT_BACKING','VPX_DISTR_VPORT_BACKING_F1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_OPAQUE_NET_BACKING','PK_VPX_OPAQUE_NET_BACKING','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_OPAQUE_NET_BACKING','VPX_OPAQUE_NET_BACKING_F1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VIRTUAL_DISK','PK_VPX_VIRTUAL_DISK','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VIRTUAL_DISK','VPX_VIRTUAL_DISK_F1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VIRTUAL_DISK_IOFILTERS','PK_VPX_VDISK_IOFILTER','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VIRTUAL_DISK_IOFILTERS','IDX_VDISKIOF_IOFILTER','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VIRTUAL_ETHERNET_CARD','PK_VPX_VIRTUAL_ETHERNET_CARD','I');
 /
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VIRTUAL_ETHERNET_CARD','VPX_VIRTUAL_ETHERNET_CARD_F1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VSRIOV_ETHERNET_CARD','PK_VPX_VSRIOV_ETHERNET_CARD','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VSRIOV_ETHERNET_CARD','VPX_VSRIOV_ETHERNET_CARD_F1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VIRTUAL_SERIAL_PORT','PK_VPX_VIRTUAL_SERIAL_PORT','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VIRTUAL_SERIAL_PORT','VPX_VIRTUAL_SERIAL_PORT_F1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VIRTUAL_USB','PK_VPX_VIRTUAL_USB','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VIRTUAL_USB','VPX_VIRTUAL_USB_F1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VIRTUAL_VMCIDEVICE','PK_VPX_VIRTUAL_VMCIDEVICE','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VIRTUAL_VMCIDEVICE','VPX_VIRTUAL_VMCIDEVICE_F1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VIRTUAL_VIDEO_CARD','PK_VPX_VIRTUAL_VIDEO_CARD','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VIRTUAL_VIDEO_CARD','VPX_VIRTUAL_VIDEO_CARD_F1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VIRTUAL_CONTROLLER','PK_VPX_VIRTUAL_CONTROLLER','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VIRTUAL_CONTROLLER','VPX_VIRTUAL_CONTROLLER_M1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VIRTUAL_SCSICONTROLLER','PK_VPX_VIRTUAL_SCSICONTROLLER','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VIRTUAL_SCSICONTROLLER','VPX_VIRTUAL_SCSICONTROLLER_F1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VIRTUAL_SATACONTROLLER','PK_VPX_VIRTUAL_SATACONTROLLER','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VIRTUAL_SATACONTROLLER','VPX_VIRTUAL_SATACONTROLLER_F1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VIRTUAL_USBCONTROLLER','PK_VPX_VIRTUAL_USBCONTROLLER','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VIRTUAL_USBCONTROLLER','VPX_VIRTUAL_USBCONTROLLER_F1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_INT_ARRAY','PK_VPX_INT_ARRAY','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_INT_ARRAY','VPX_INT_ARRAY_F2','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_INT_ARRAY','VPX_INT_ARRAY_M1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_STRING_ARRAY','PK_VPX_STRING_ARRAY','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_STRING_ARRAY','VPX_STRING_ARRAY_F1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_STRING_ARRAY','VPX_STRING_ARRAY_M1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_STRING_ARRAY','VPX_STRING_ARRAY_M2','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_TEXT_ARRAY','PK_VPX_TEXT_ARRAY','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_TEXT_ARRAY','VPX_TEXT_ARRAY_F2','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_TEXT_ARRAY','VPX_TEXT_ARRAY_M1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_TYPE_MAP','PK_VPX_TYPE_MAP','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HOST_CONFIG_INFO','PK_VPX_HOST_CONFIG_INFO','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_FILE_SYSTEM_MOUNT_INFO','PK_VPX_FILE_SYSTEM_MOUNT_INFO','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_FILE_SYSTEM_MOUNT_INFO','VPX_FILE_SYSTEM_MOUNT_INFO_M1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VMFS_VOLUME','PK_VPX_VMFS_VOLUME','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VMFS_VOLUME','IX_VPX_VMFS_VOLUME_UUID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SCSI_DISK_PARTITION','VPX_SCSI_DISK_PARTITION_F1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SCSI_DISK_PARTITION','VPX_SCSI_DISK_PARTITION_M1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HOST_BUS_ADAPTER','PK_VPX_HOST_BUS_ADAPTER','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HOST_BUS_ADAPTER','VPX_HOST_BUS_ADAPTER_M1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HOST_BUS_ADAPTER','VPX_HOST_BUS_ADAPTER_M2','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SCSI_LUN','PK_VPX_SCSI_LUN','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SCSI_LUN','VPX_SCSI_LUN_F1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SCSI_LUN','VPX_SCSI_LUN_F2','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SCSI_LUN','VPX_SCSI_LUN_M1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SCSI_LUN','VPX_SCSI_LUN_M2','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_PSA_ADAPTER','PK_PSA_ADAPTER','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_PSA_ADAPTER','VPX_PSA_ADAPTER_M1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_PSA_ADAPTER','VPX_PSA_ADAPTER_F1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_PSA_DEVICE','PK_PSA_DEVICE','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_PSA_DEVICE','VPX_PSA_DEVICE_M1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_PSA_TARGET','PK_PSA_TARGET','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_PSA_TARGET','VPX_PSA_TARGET_M1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_PSA_TARGET_TRANSPORT','PK_PSA_TARGET_TRANSPORT','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_PSA_TARGET_TRANSPORT','VPX_PSA_TARGET_TRANSPORT_F1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_PSA_PATH','PK_PSA_PATH','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_PSA_PATH','VPX_PSA_PATH_M1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_PSA_PATH','VPXI_PSA_PATH','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_MULTIPATHSTATEINFO_PATH','PK_MPSI_PATH','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HOST_TEXT','PK_HOST_TEXT','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DATASTORE_INFO','PK_VPX_DATASTORE_INFO','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VMFS_EXTENT','PK_VPX_VMFS_EXTENT','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VM_FILE_LAYOUT_EX','PK_FILE_LAYOUT_EX','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VM_FLE_DISK_LAYOUT','PK_FLE_DISK_LAYOUT','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VM_FLE_DISK_LAYOUT','VPX_VM_FLE_DISK_LAYOUT_U1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VM_FLE_DISK_UNIT','PK_FLE_DISK_UNIT','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VM_FLE_DISK_UNIT','VPX_VM_FLE_DISK_UNIT_F1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VM_FLE_FILE_INFO','PK_FLE_FILE_INFO','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VM_FLE_FILE_INFO','VPX_VM_FLE_FILE_INFO_M1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VM_FLE_FILE_INFO','VPX_VM_FLE_FILE_INFO_M3','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VM_FLE_SNAPSHOT_LAYOUT','PK_FLE_SNAPSHOT_LAYOUT','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VM_FLE_SNAPSHOT_LAYOUT','VPX_VM_FLE_SNAPSHOT_LAYOUT_U1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VM_FLE_SNAPSHOT_DISK','PK_FLE_SNAPSHOT_DISK','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VM_FLE_SNAPSHOT_DISK','VPX_VM_FLE_SNAPSHOT_DISK_U1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VM_FLE_SNAPSHOT_DISK','VPX_VM_FLE_SNAPSHOT_DISK_F1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VM_FLE_SNAP_DISK_UNIT','PK_FLE_SNAP_DISK_UNIT','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VM_FLE_SNAP_DISK_UNIT','VPX_VM_FLE_SNAP_DISK_UNIT_M1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VM_FLE_SNAP_DISK_UNIT','VPX_VM_FLE_SNAP_DISK_UNIT_F1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SN_CONFIG_INFO','PK_VPX_SN_CONFIG_INFO','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SN_VIRTUAL_DEVICE','PK_VPX_SN_VIRTUAL_DEVICE','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SN_VIRTUAL_DEVICE','VPX_SN_VIRTUAL_DEVICE_M1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SN_VDEVICE_BACKING_REL','PK_SN_VPX_VDEVICE_BACKING_REL','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SN_VDEVICE_BACKING_REL','VPX_SN_VDEVICE_BACKING_REL_U1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SN_VDEVICE_BACKING_REL','IX_VPX_SNVDBACKING_REL_SN_ID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SN_VDEVICE_DEVICE_BACKING','PK_SN_VDEVICE_DEVICE_BACKING','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SN_VDEVICE_PLUGIN_BACKING','PK_SN_VDEVICE_PLUGIN_BACKING','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SN_VDEVICE_FILE_BACKING','PK_SN_VDEVICE_FILE_BACKING','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SN_VDEVICE_FILE_BACKING','VPX_SN_VDEVICE_FILE_BACKING_U1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SN_VDEVICE_FILE_BACKING','VPX_SN_VDEVICE_FILE_BACKING_M1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SN_VDEVICE_FILE_BACKING','VPX_SN_VDEVICE_FILE_BACKING_F1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SN_VDEVICE_FILE_BACKING_X','PK_SN_VDEVICE_FILE_BACKING_X','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SN_VDEVICE_FILE_BACKING_X','VPX_SN_VDEVICE_FILE_BKG_X_M1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SN_VDEVICE_FILE_BACKING_X','VPX_SN_VDEVICE_FILE_BKG_X_M2','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SN_VD_DEVICE_BACKING_X','PK_SN_VD_DEVICE_BACKING_X','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SN_VDEVICE_PIPE_BACKING','PK_VPX_SN_VDEVICE_PIPE_BACKING','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SN_DISTR_VPORT_BACKING','PK_VPX_SN_DISTR_VPORT_BACKING','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SN_OPAQUE_NET_BACKING','PK_VPX_SN_OPAQUE_NET_BACKING','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SN_VIRTUAL_DISK','PK_VPX_SN_VIRTUAL_DISK','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SN_VIRTUAL_ETHERNET_CARD','PK_VPX_SN_VETHERNET_CARD','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SN_VSRIOV_ETHERNET_CARD','PK_VPX_SN_VSETHERNET_CARD','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SN_VIRTUAL_SERIAL_PORT','PK_VPX_SN_VIRTUAL_SERIAL_PORT','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SN_VIRTUAL_USB','PK_VPX_SN_VIRTUAL_USB','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SN_VIRTUAL_VMCIDEVICE','PK_VPX_SN_VIRTUAL_VMCIDEVICE','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SN_VIRTUAL_VIDEO_CARD','PK_VPX_SN_VIRTUAL_VIDEO_CARD','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SN_VIRTUAL_CONTROLLER','PK_VPX_SN_VIRTUAL_CONTROLLER','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SN_VIRTUAL_SCSICONTROLLER','PK_SN_VIRTUAL_SCSICONTROLLER','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SN_VIRTUAL_SATACONTROLLER','PK_SN_VIRTUAL_SATACONTROLLER','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SN_VIRTUAL_USBCONTROLLER','PK_SN_VIRTUAL_USBCONTROLLER','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SCSILUN_DESCRIPTOR','PK_VPX_SCSILUN_DESCRIPTOR','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SCSILUN_DESCRIPTOR','VPX_SCSILUN_DESCRIPTOR_F1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SCSILUN_DESCRIPTOR','VPX_SCSILUN_DESCRIPTOR_F2','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_USAGE_STAT','PK_VPX_USAGE_STAT','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_USAGE_SAMPLE_TIME','PK_VPX_USAGE_SAMPLE_TIME','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_USAGE_SAMPLE_TIME','VPX_USAGE_SAMPLE_TIME_U1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_TAG','PK_VPX_TAG','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_TAG','VPX_TAG_U1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_TAG_ENT_ASSOCIATION','PK_VPX_TAG_ENT_ASSOCIATION','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_ENTITY_VMOP_COUNT','PK_VPX_ENTITY_VMOP_COUNT','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_BINARY_DATA','PK_VPX_BIN_DATA','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVHOST_OUT_OF_SYNC','PK_DVHOST_OUT_OF_SYNC','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VAPP_LINK','PK_VPX_VAPP_LINK','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VAPP_LINK','VPXI_VAPP_LINK_PARENT_VAPP_ID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_LIC_METADATA','PK_VPX_LIC_METADATA','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_LIC_ASSETS','PK_VPX_LIC_ASSETS','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_LIC_LICENSES','PK_VPX_LIC_LICENSES','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_LIC_VC_GROUPS','PK_VPX_LIC_VC_GROUPS','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_LIC_CONTEXT','VPXI_LIC_CONTEXT_ASSET_ID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_LIC_CONTEXT','VPXI_LIC_CONTEXT_LICENSE_ID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_LIC_CONTEXT','VPXI_LIC_CONTEXT_VC_GROUP_ID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_LIC_CONTEXT','PK_VPX_LIC_CONTEXT','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_LIC_VC_GROUP_MEMBERS','PK_VPX_LIC_VC_GROUP_MEMBERS','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_LIC_VC_GROUP_MEMBERS','IDX_VPX_LIC_VC_GROUP_MEMBERS','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_LIC_USAGE','PK_VPX_LIC_USAGE','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_LIC_USAGE','IX_VPX_LIC_USAGE','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_LIC_USAGE','VPXI_LIC_USAGE_CONTEXT_ID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_LIC_SETTINGS','PK_VPX_LIC_SETTINGS','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_LIC_ASSET_PROPERTIES','PK_VPX_LIC_ASSET_PROPERTIES','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_PRODUCT','PK_PRODUCT','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_TERMINATION_REASON','PK_TERMINATION_REASON','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_UPTIME','PK_VPX_UPTIME','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SDRS_POD_CONFIG','PK_VPX_SDRS_POD_CONFIG','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_TABLE','PK_VPX_TABLE','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_INDEX_COLUMN','PK_VPX_INDEX_COLUMN','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SDRS_STATS_VM','PK_VPX_SDRS_STATS_VM','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SDRS_STATS_DATASTORE','PK_VPX_STATS_DS','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_LIC_TPS_ASSETS','PK_VPX_LIC_TPS_ASSETS','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_LIC_TPS_ASSETS','UK_VPX_LIC_TPS_ASSETS','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_LIC_AUTO_KEYS','PK_VPX_LIC_AUTO_KEYS','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_LIC_AUTO_KEYS','VPXI_LIC_AUTO_KEYS_ASSET_ID','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DBM_COUNTER_METADATA','PK_VPX_DBM_COUNTER_METADATA','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DBM_COUNTER_VALUE','PK_VPX_DBM_COUNTER_VALUE','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_PROC_LOG','PK_VPX_PROC_LOG','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_ALARM','VPX_ALARM_F1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_COMPUTE_RESOURCE','VPX_COMPUTE_RESOURCE_F1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_ENTITY','VPX_ENTITY_F1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_EVENT_ARG','VPX_EVENT_ARG_F1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_EVENT','VPX_EVENT_F1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SCHEDULEDTASK','VPX_SCHEDULEDTASK_F1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SNAPSHOT','VPX_SNAPSHOT_F1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_TASK','VPX_TASK_F1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_EXT_CLIENT','VPX_EXT_CLIENT_EXT_ID_F1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_EXT_SERVER','VPX_EXT_SERVER_EXT_ID_F1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_EXT_SERVER_EMAIL','VPX_EXT_SERVMAIL_EXTSERID_F1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HOST_PROFILE','VPX_HOST_PROFREFHOST_ENTID_F1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_IP_POOL_ASSOCIATION','VPX_IP_POOL_ASSOCASSET_ID_F1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_LIC_ASSET_PROPERTIES','VPX_LIC_ASSET_PROPASSET_ID_F1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_PROFILE_ANSWER_FILE','VPX_PROFANS_FILE_HOST_ID_F1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_COMPLIANCE_STATUS','VPX_COMPL_STATUS_PROFID_F1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_COMPLIANCE_STATUS','VPX_COMPL_STATUS_ENTITY_ID_F1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_COMPUTE_RES_USER_HB_DS','VPX_COMPUTE_RES_USER_HB_DS_F1','I');
 /
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DAS_HB_DATASTORE_SYS','VPX_DAS_HB_DATASTORE_SYS_F1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DAS_HB_DATASTORE_SYS','VPX_DAS_HB_DATASTORE_SYS_F2','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_PROFILE_ENTITY_ASSOCIATION','VPX_PROFILE_ENTITY_ASSC_F1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SCSI_LUN','VPX_SCSI_LUN_M3','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_TEXT_ARRAY','VPX_TEXT_ARRAY_M2','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DATASTORE_INFO','VPX_DATASTORE_INFO_M1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DATASTORE_INFO','VPX_DATASTORE_INFO_M2','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DS_ASSIGNMENT','VPX_DS_ASSIGNMENT_M1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SAMPLE_TIME1','VPX_SAMPLE_TIME1_M2','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SAMPLE_TIME2','VPX_SAMPLE_TIME2_M2','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SAMPLE_TIME3','VPX_SAMPLE_TIME3_M2','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SAMPLE_TIME4','VPX_SAMPLE_TIME4_M2','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_STAT_ID','VPX_STAT_ID_M1','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_TOPN_PAST_DAY','PK_VPX_TOPN_PAST_DAY','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_TOPN_PAST_WEEK','PK_VPX_TOPN_PAST_WEEK','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_TOPN_PAST_MONTH','PK_VPX_TOPN_PAST_MONTH','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_TOPN_PAST_YEAR','PK_VPX_TOPN_PAST_YEAR','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_TOPN_STATISTICS','PK_VPX_TOPN_STATISTICS','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_TOPN_STATE','PK_VPX_TOPN_STATE','I');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_JOB_LOG','PK_VPX_JOB_LOG','I');
 /
 
 /
 
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_OBJECT_TYPE','PK_VPX_OBJECT_TYPE','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_ALARM','PK_VPX_ALARM','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_ALARM','FK_VPX_ALARM_REF_ENTITY','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_ALARM_EXPRESSION','PK_VPX_ALARM_EXP','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_ALARM_EXPRESSION','FK_VPX_ALARM_EXP_REF_ALARM','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_ALARM_EXPR_COMP','PK_VPX_ALARM_EXPR_COMP','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_ALARM_EXPR_COMP','FK_VPX_ALARM_EXPR_COMP_REF','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_ALARM_ACTION','PK_VPX_ALARM_ACTION','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_ALARM_ACTION','FK_VPX_ALARM_ACT_REF_ALARM','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_ALARM_RUNTIME','PK_VPX_ALARM_RUNTIME','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_ALARM_STATE','PK_VPX_ALARM_STATE','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_ALARM_REPEAT_ACTION','PK_VPX_ALARM_RPTACT','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_CUSTOMIZATION_SPEC','PK_VPX_CUSTOMIZATION_SPEC','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_CHANGE_TAG','PK_VPX_CHANGE_TAG','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_EVENT','PK_VPX_EVENT','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_EVENT','FK_VPX_EVENT_REF_COMPUTERES','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_EVENT','FK_VPX_CHANGE_TAG','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_EVENT_ARG','PK_VPX_EVENT_ARG','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_EVENT_ARG','FK_VPX_EVENT_ARG_REF_EVENT','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_EVENT_ARG','FK_VPX_EVENT_ARG_REF_ENTITY','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_FIELD_DEF','PK_VPX_FIELD_DEF','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_ROLE','PK_VPX_ROLE','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SAMPLE','PK_VPX_SAMPLE','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SCHEDULEDTASK','PK_VPX_SCHEDULEDTASK','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SCHEDULEDTASK','FK_VPX_SCHED_REF_ENTITY','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SCHED_SCHEDULER','PK_VPX_SCHED_SCHEDULER','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SCHED_SCHEDULER','FK_VPX_SCHED_XDL_REF_SCHED','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SCHED_ACTION','PK_VPX_SCHED_ACTION','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SCHED_ACTION','FK_VPX_SCHED_ACT_REF_SCHED','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SEQUENCE','PK_VPX_SEQUENCE','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_PARAMETER','PK_VPX_PARAMETER','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_STAT_DEF','PK_VPX_STAT_DEF','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_STAT_ID','PK_VPX_STAT_ID','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_TASK','PK_VPX_TASK','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_TASK','FK_VPX_TASK_REF_ENTITY','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_TASK','FK_VPX_TASK_CHANGE_TAG','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_TASK','FK_PARENT_TASK_REF','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VERSION','PK_VPX_VERSION','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_PRIV_ROLE','PK_VPX_PRIV_ROLE','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_PRIV_ROLE','FK_VPX_PRIV_REF_VPX_ROLE','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_ENTITY','PK_VPX_ENTITY','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_ENTITY','FK_VPX_ENTI_REF_VPX_ENTI','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_ENTITY','FK_VPX_ENT_REF_VPX_ENT_TYPE','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_ALARM_DISABLED_ACTIONS','PK_VPX_ALARM_DISABLED_ACTIONS','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_ALARM_DISABLED_ACTIONS','FK_VPX_ALARM_DIS_REF_ENTITY','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_ACCESS','PK_VPX_ACCESS','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_ACCESS','FK_VPX_ACCE_REF_VPX_ENTI','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_CONFIG_ISSUE','PK_VPX_CONFIG_ISSUE','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_CONFIG_ISSUE','FK_VPX_CFGISS_VPX_VM','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SNAPSHOT','PK_VPX_SNAPSHOT','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SNAPSHOT','FK_VPX_SNAPSHOT_REF_VPX_VM','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_FIELD_VAL','PK_VPX_FIELD_VAL','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_FIELD_VAL','FK_VPX_F_VAL_REF_F_DEF','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DATACENTER','PK_VPX_DATACENTER','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DATACENTER','FK_VPX_DC_REF_VPX_ENTITY','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VM','PK_VPX_VM','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VM_CHILD_TABLES','PK_VPX_VM_CHILD_TABLES','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_OVFENV','PK_VPX_OVFENV','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_OVFENV','FK_VPX_OVFENV_REF_VPX_ENTITY','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_WWN','PK_VPX_WWN','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_WWN','FK_VPX_VW_REF_VPX_ENTITY','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_MAC_XVC_VMOTION','PK_VPX_MAC_XVC_VMOTION','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VM_STATIC_OVERHEAD_MAP','PK_VPX_VM_STATIC_OVERHEAD_MAP','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_COMPUTE_RESOURCE','PK_VPX_COMP_RES','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_COMPUTE_RESOURCE','FK_VPX_CLUS_REF_VPX_ENTI','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_COMPUTE_RESOURCE','FK_VPX_COMP_REFERENCE_VPX_ENTI','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_CLUSTER_IOFILTERS','PK_VPX_CLUS_IOF','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_CLUSTER_IOFILTERS','FK_VPX_CLUS_IOF','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DATASTORE','PK_VPX_DATASTORE','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DATASTORE','FK_VPX_DS_REF_VPX_ENTITY','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DATASTORE','FK_VPX_DS_DC_REF_VPX_ENT','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_NETWORK','PK_VPX_NETWORK','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_NETWORK','FK_VPX_NET_REF_VPX_ENTI','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_NETWORK','FK_VPX_NET_REF_VPX_DATA','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_IP_POOL','PK_VPX_IPPOOL','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_IP_POOL','FK_VPX_IPPOOL_REF_VPX_DATA','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_IP_POOL_ASSOCIATION','PK_VPX_IPPOOL_ASSOCIATION','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_IP_POOL_ASSOCIATION','FK_VPX_IP_POOL_ASSOCIATION','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_IP_POOL_ALLOCATION','PK_VPX_IP_POOL_ALLOCATION','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_IP_POOL_ALLOCATION','FK_VPX_IP_POOL_ALLOCATION','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_NW_ASSIGNMENT','PK_VPX_NW_ASSIGNMENT','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_NW_ASSIGNMENT','FK_VPX_ENTNET_REF_VPX_ENTI','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVS','PK_VPX_DVS','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVS','FK_VPX_DVS_REF_VPX_ENTI','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVS_COMPATIBLE','PK_VPX_DVS_COMPATIBLE','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVS_COMPATIBLE','FK_VPX_DVS_COMPAT_REF_VPX_ENTI','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVS_UPLINK','PK_VPX_DVS_UPLINK','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVS_UPLINK','FK_VPX_DVS_UPLINK_REF_VPX_ENTI','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVPORTGROUP','PK_VPX_DVPORTGROUP','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVPORTGROUP','FK_VPX_DVPORTGRP_REF_VPX_ENTI','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVHOST','PK_VPX_DVHOST','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVHOST','FK_VPX_DVHOST_REF_VPX_ENTI','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVPORT_SETTING','PK_VPX_DVPORT_SETTING','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVPORT_SETTING','FK_VPX_DVPORT_STG_REF_VPX_ENTI','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVPORT','PK_VPX_DVPORT','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVPORT','FK_VPX_DVPORT_REF_VPX_ENTI','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVS_NRP','PK_VPX_DVS_NRP','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVS_NRP','FK_VPX_DVS_NRP_REF_VPX_ENTI','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVPORT_MEMBERSHIP','PK_VPX_DVPORT_MEMBERSHIP','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVPORT_MEMBERSHIP','FK_VPX_DVPORT_MEM_REF','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVS_SCOPE','PK_VPX_DVS_SCOPE','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVS_SCOPE','FK_VPX_DVS_SCOPE_REF_VPX_ENTI','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVS_VSPAN_SESSION','PK_VPX_DVS_VSPAN_SESSION','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVS_VSPAN_SESSION','FK_DVS_VSPAN_SESSION_REF_ENTI','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVS_HC_CONFIG','PK_VPX_DVS_HC_CONFIG','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVS_HC_CONFIG','FK_DVS_HC_CONFIG_REF_ENTI','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVHOST_HC_RESULT','PK_VPX_DVHOST_HC_RESULT','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVHOST_HC_RESULT','FK_DVHOST_HC_RESULT_REF_ENTI','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVHOST_HC_VLAN_RESULT','PK_VPX_DVHOST_HC_VLAN_RESULT','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVHOST_HC_VLAN_RESULT','FK_HC_VLAN_RESULT_REF_ENTI','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVHOST_HC_MTU_RESULT','PK_VPX_DVHOST_HC_MTU_RESULT','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVHOST_HC_MTU_RESULT','FK_HC_MTU_RESULT_REF_ENTI','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVS_IPFIX','PK_VPX_DVS_IPFIX','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVS_IPFIX','FK_VPX_DVS_IPFIX_DVS','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVS_VSPAN_PORTS','PK_VPX_DVS_VSPAN_PORTS','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVS_VSPAN_PORTS','FK_DVS_VSPAN_PORTS_REF_ENTI','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVS_PVLAN','PK_VPX_DVS_PVLAN','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVS_PVLAN','FK_VPX_DVS_PVLAN_REF_VPX_ENTI','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVPORT_VLAN','PK_VPX_DVPORT_VLAN','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVPORT_VLAN','FK_VPX_DVS_VLAN_REF_VPX_ENTI','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_UPLINK_TEAMING','PK_VPX_UPLINK_TEAMING','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_UPLINK_TEAMING','FK_VPX_TEAMING_REF_VPX_ENTI','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVS_BLOB','PK_VPX_DVS_BLOB','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVS_BLOB','FK_VPX_DVS_BLOB_REF_VPX_ENTI','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVS_OVERLAY_INSTANCE','PK_VPX_DVS_OVERLAY_INSTANCE','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVS_OVERLAY_INSTANCE','FK_DVS_OVERLAY_INSTANCE_REF','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVS_OPAQUE_DATA','PK_VPX_DVS_OPAQUE_DATA','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVS_OPAQUE_DATA','FK_DVS_OPAQUE_REF_VPX_ENTI','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVS_RULESET','PK_VPX_DVS_RULESET','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVS_RULE','PK_VPX_DVS_RULE','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVS_RULE','FK_DVS_RULE_REF_VPX_ENT1','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVS_RULE_QUALIFIER','PK_VPX_DVS_RULE_QUALIFIER','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVS_RULE_QUALIFIER','FK_DVS_QUALIFIER_REF_VPX_ENT1','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVS_TRAFFIC_FILTER_CONFIG','PK_VPX_DVS_TRAFFIC_FILT_CONFIG','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVS_TRAFFIC_FILTER_CONFIG','FK_FILTER_CONFIG_REF_VPX_ENT1','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVS_TRAFFIC_FILTER_PARAM','PK_VPX_DVS_TRAFFIC_FILT_PARAM','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVS_TRAFFIC_FILTER_PARAM','FK_FILTER_PARAM_REF_VPX_ENT1','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVS_INFRA_RES_POOL','PK_VPX_DVS_INFRA_RES_POOL','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVS_INFRA_RES_POOL','FK_DVS_IRP_REF_VPX_ENT1','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVS_VMVNIC_RES_POOL','PK_VPX_DVS_VMVNIC_RES_POOL','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVS_VMVNIC_RES_POOL','FK_DVS_VMVNICRP_REF_VPX_ENT1','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_REMOTE_CNX','PK_VPX_HOST_CNX','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_REMOTE_CNX_LISTENER','PK_VPX_HOST_CNX_FILTER','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_REMOTE_CNX_LISTENER','FK_VPX_HOST_CNX_LISTEN_REF','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVS_LAG','PK_VPX_DVS_LAG','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVS_LAG','FK_DVS_LAG_REF_ENTI','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVS_LAG_VLAN','PK_VPX_DVS_LAG_VLAN','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SAMPLE_TIME3','PK_VPX_SAMPLE_TIME3','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVS_LAG_VLAN','FK_DVS_LAG_VLAN_REF_ENTI','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HOST','PK_VPX_HOST','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HOST','FK_VPX_HOST_REF_VPX_ENTI','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HOST','FK_VPX_HOST_REF_VPX_H_CX','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HOST_SYSTEM_ID_INFO','PK_HOST_SYSIDINFO','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HOST_SYSTEM_ID_INFO','FK_HOST_SYSIDINFO_REF_VPX_HOST','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HOST_X','PK_VPX_HOST_X','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HOST_X','FK_VPX_HOST_X_REF_VPX_HOST','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HOST_GW_PARAMS','PK_VPX_HOST_GW_PARAMS','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HOST_GW_PARAMS','FK_VPX_HOST_GW_PARAMS_REF','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_RESOURCE_POOL','PK_VPX_RESOURCE_POOL','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_RESOURCE_POOL','FK_VPX_RESPOOL_REF_VPX_ENTI','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DS_ASSIGNMENT','PK_VPX_DS_ASSIGNMENT','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DS_ASSIGNMENT','FK_VPX_DS_A_REF_VPX_DATA','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DS_ASSIGNMENT','FK_VPX_DS_A_REF_VPX_ENTI','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HOST_VM_CONFIG_OPTION','PK_VPX_HOST_VM_CONFIG_OPTION','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HOST_VM_CONFIG_OPTION','FK_VPX_HOST_VM_CONF_REF_HOST','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_COMPUTE_RESOURCE_DAS_VM','PK_VPX_COMP_DAS_VM','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_COMPUTE_RESOURCE_DAS_VM','FK_VPX_COMP_DAS_VM_REF_VPX_COM','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DAS_HB_DATASTORE_SYS','PK_VPX_COMP_DAS_HB_DS_SYS','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DAS_HB_DATASTORE_SYS','FK_VPX_COMP_DAS_HB_DS_SYS2','C');
 /
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DAS_HB_DATASTORE_SYS','FK_VPX_COMP_DAS_HB_DS_SYS1','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DAS_HB_DATASTORE_SYS','FK_VPX_COMP_DAS_HB_DS_SYS3','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_COMPUTE_RES_USER_HB_DS','PK_COMPUTE_RES_USER_HB_DS','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_COMPUTE_RES_USER_HB_DS','FK_COMPUTE_RES_USER_HB_DS1','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_COMPUTE_RES_USER_HB_DS','FK_COMPUTE_RES_USER_HB_DS2','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_COMPUTE_RESOURCE_DRS_VM','PK_VPX_COMP_DRS_VM','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_COMPUTE_RESOURCE_DRS_VM','FK_VPX_COMP_DRS_VM_REF_VPX_COM','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_COMPUTE_RESOURCE_DPM_HOST','PK_VPX_COMP_RESOURCE_DPM_HOST','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_COMPUTE_RESOURCE_DPM_HOST','FK_VPX_COMPRES_DPM_HOST1','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_COMPUTE_RESOURCE_DPM_HOST','FK_VPX_COMPRES_DPM_HOST2','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HOST_CPU','PK_VPX_HOST_CPU','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HOST_CPU','FK_VPX_HOST_REFERENCE_VPX_HOST','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HOST_CPU_THREAD','PK_VPX_CPU_THREAD','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HOST_CPU_THREAD','FK_VPX_CPU_THREAD_REF_HOST_CPU','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HOST_CPU_CPUID_FEATURE','PK_VPX_CPU_CPUID_FEAT','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SAMPLE_TIME4','PK_VPX_SAMPLE_TIME4','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HOST_CPU_CPUID_FEATURE','FK_VPX_CPU_CPUID_F_REF_H_CPU','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HOST_NODE','PK_VPX_HOST_NODE','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HOST_NODE','FK_VPX_HOST_NODE_REF_VPX_HOST','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_GUEST_DISK','PK_VPX_GUEST_DISK','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_NIC','PK_VPX_NIC','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_NIC','FK_VPX_VN_REF_VPX_VM','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HOST_NODE_CPU','PK_VPX_HOST_NODE_CPU','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HOST_NODE_CPU','FK_VPX_NODE_CPU_REF_HOST_NODE','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_IP_ADDRESS','PK_VPX_IP_ADDRESS','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_IP_ADDRESS','FK_VPX_GUES_REFERENCE_VPX_GUES','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HOST_PCI_DEVICE','PK_VPX_HOST_PCI_DEVICE','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HOST_PCI_DEVICE','FK_VPX_HOST_PCI_REF_VPX_HOST','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HOST_CPUID_FEATURE','PK_VPX_HOST_CPUID_FEATURE','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HOST_CPUID_FEATURE','FK_VPX_HOST_CPUID_F_REF_VPX_H','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_EXT','PK_VPX_EXT','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_EXT_SERVER','PK_VPX_EXT_SERVER','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_EXT_SERVER','FK_VPX_EXT_SERVER_REF_EXT','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_EXT_SERVER_EMAIL','PK_VPX_EXT_SERVER_EMAIL','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_EXT_SERVER_EMAIL','FK_VPX_EMAIL_REF_SERVER','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_EXT_CLIENT','PK_VPX_EXT_CLIENT','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_EXT_CLIENT','FK_VPX_EXT_CLIENT_REF_EXT','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_EXT_TYPE_IDS','PK_VPX_EXT_TYPE_IDS','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_EXT_TYPE_IDS','FK_VETI_REF_EXT','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_EXT_PRIVS','PK_VPX_EXT_PRIVS','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_EXT_PRIVS','FK_VPX_EXT_PRIVS_REF_EXT','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_EXT_MANAGEDBY_INFO','PK_VPX_EXT_MANAGEDBY_INFO','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_EXT_MANAGEDBY_INFO','FK_VPX_EXT_MGDBY_INF_REF_EXT','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_EXT_TABS','PK_VPX_EXT_TABS','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_EXT_TABS','FK_VPX_EXT_TABS_REF_EXT','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_EXT_DATA','PK_VPX_EXT_DATA','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HOST_DISABLEADMIN','PK_VPX_HOST_DISABLEADMIN','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_COMPUTE_RESOURCE_VSAN_HOST','PK_COMP_RESOURCE_VSAN_HOST','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_COMPUTE_RESOURCE_VSAN_HOST','FK_COMP_RES_VSAN_REF_COMP_RES','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_COMPUTE_RESOURCE_VSAN_HOST','FK_COMP_RES_VSAN_REF_HOST','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DISABLED_METHODS','PK_VPX_DISABLED_METHODS','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_STAT_INTERVAL_DEF','PK_VPX_STAT_INTERVAL_DEF','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DEVICE','PK_VPX_DEVICE','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_STAT_COUNTER','PK_VPX_STAT_COUNTER','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SAMPLE_TIME1','PK_VPX_SAMPLE_TIME1','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SAMPLE_TIME2','PK_VPX_SAMPLE_TIME2','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_1','PK_VPX_HIST_STAT2_1','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_2','PK_VPX_HIST_STAT2_2','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_3','PK_VPX_HIST_STAT2_3','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_4','PK_VPX_HIST_STAT2_4','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_5','PK_VPX_HIST_STAT2_5','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_6','PK_VPX_HIST_STAT2_6','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_7','PK_VPX_HIST_STAT2_7','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_8','PK_VPX_HIST_STAT2_8','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_9','PK_VPX_HIST_STAT2_9','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_10','PK_VPX_HIST_STAT2_10','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_11','PK_VPX_HIST_STAT2_11','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_12','PK_VPX_HIST_STAT2_12','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_13','PK_VPX_HIST_STAT2_13','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_14','PK_VPX_HIST_STAT2_14','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_15','PK_VPX_HIST_STAT2_15','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_16','PK_VPX_HIST_STAT2_16','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_17','PK_VPX_HIST_STAT2_17','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_18','PK_VPX_HIST_STAT2_18','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_19','PK_VPX_HIST_STAT2_19','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_20','PK_VPX_HIST_STAT2_20','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_21','PK_VPX_HIST_STAT2_21','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_22','PK_VPX_HIST_STAT2_22','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_23','PK_VPX_HIST_STAT2_23','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_24','PK_VPX_HIST_STAT2_24','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_25','PK_VPX_HIST_STAT2_25','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_26','PK_VPX_HIST_STAT2_26','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_27','PK_VPX_HIST_STAT2_27','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_28','PK_VPX_HIST_STAT2_28','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_29','PK_VPX_HIST_STAT2_29','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_30','PK_VPX_HIST_STAT2_30','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_31','PK_VPX_HIST_STAT2_31','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_32','PK_VPX_HIST_STAT2_32','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_33','PK_VPX_HIST_STAT2_33','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_34','PK_VPX_HIST_STAT2_34','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_35','PK_VPX_HIST_STAT2_35','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_36','PK_VPX_HIST_STAT2_36','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_37','PK_VPX_HIST_STAT2_37','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_38','PK_VPX_HIST_STAT2_38','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_39','PK_VPX_HIST_STAT2_39','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_40','PK_VPX_HIST_STAT2_40','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_41','PK_VPX_HIST_STAT2_41','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_42','PK_VPX_HIST_STAT2_42','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_43','PK_VPX_HIST_STAT2_43','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_44','PK_VPX_HIST_STAT2_44','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_45','PK_VPX_HIST_STAT2_45','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_46','PK_VPX_HIST_STAT2_46','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_47','PK_VPX_HIST_STAT2_47','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_48','PK_VPX_HIST_STAT2_48','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_49','PK_VPX_HIST_STAT2_49','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_50','PK_VPX_HIST_STAT2_50','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_51','PK_VPX_HIST_STAT2_51','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_52','PK_VPX_HIST_STAT2_52','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_53','PK_VPX_HIST_STAT2_53','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_54','PK_VPX_HIST_STAT2_54','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_55','PK_VPX_HIST_STAT2_55','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_56','PK_VPX_HIST_STAT2_56','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_57','PK_VPX_HIST_STAT2_57','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_58','PK_VPX_HIST_STAT2_58','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_59','PK_VPX_HIST_STAT2_59','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_60','PK_VPX_HIST_STAT2_60','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_61','PK_VPX_HIST_STAT2_61','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_62','PK_VPX_HIST_STAT2_62','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_63','PK_VPX_HIST_STAT2_63','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_64','PK_VPX_HIST_STAT2_64','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_65','PK_VPX_HIST_STAT2_65','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_66','PK_VPX_HIST_STAT2_66','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_67','PK_VPX_HIST_STAT2_67','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_68','PK_VPX_HIST_STAT2_68','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_69','PK_VPX_HIST_STAT2_69','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_70','PK_VPX_HIST_STAT2_70','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_71','PK_VPX_HIST_STAT2_71','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_72','PK_VPX_HIST_STAT2_72','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_73','PK_VPX_HIST_STAT2_73','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_74','PK_VPX_HIST_STAT2_74','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_75','PK_VPX_HIST_STAT2_75','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_76','PK_VPX_HIST_STAT2_76','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_77','PK_VPX_HIST_STAT2_77','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_78','PK_VPX_HIST_STAT2_78','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_79','PK_VPX_HIST_STAT2_79','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_80','PK_VPX_HIST_STAT2_80','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_81','PK_VPX_HIST_STAT2_81','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_82','PK_VPX_HIST_STAT2_82','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_83','PK_VPX_HIST_STAT2_83','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_84','PK_VPX_HIST_STAT2_84','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT2_85','PK_VPX_HIST_STAT2_85','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_1','PK_VPX_HIST_STAT3_1','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_2','PK_VPX_HIST_STAT3_2','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_3','PK_VPX_HIST_STAT3_3','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_4','PK_VPX_HIST_STAT3_4','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_5','PK_VPX_HIST_STAT3_5','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_6','PK_VPX_HIST_STAT3_6','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_7','PK_VPX_HIST_STAT3_7','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_8','PK_VPX_HIST_STAT3_8','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_9','PK_VPX_HIST_STAT3_9','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_10','PK_VPX_HIST_STAT3_10','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_11','PK_VPX_HIST_STAT3_11','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_12','PK_VPX_HIST_STAT3_12','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_13','PK_VPX_HIST_STAT3_13','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_14','PK_VPX_HIST_STAT3_14','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_15','PK_VPX_HIST_STAT3_15','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_16','PK_VPX_HIST_STAT3_16','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_17','PK_VPX_HIST_STAT3_17','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_18','PK_VPX_HIST_STAT3_18','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_19','PK_VPX_HIST_STAT3_19','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_20','PK_VPX_HIST_STAT3_20','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_21','PK_VPX_HIST_STAT3_21','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_22','PK_VPX_HIST_STAT3_22','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_23','PK_VPX_HIST_STAT3_23','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_24','PK_VPX_HIST_STAT3_24','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_25','PK_VPX_HIST_STAT3_25','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_26','PK_VPX_HIST_STAT3_26','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_27','PK_VPX_HIST_STAT3_27','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_28','PK_VPX_HIST_STAT3_28','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_29','PK_VPX_HIST_STAT3_29','C');
 /
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_30','PK_VPX_HIST_STAT3_30','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_31','PK_VPX_HIST_STAT3_31','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT3_32','PK_VPX_HIST_STAT3_32','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_1','PK_VPX_HIST_STAT4_1','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_2','PK_VPX_HIST_STAT4_2','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_3','PK_VPX_HIST_STAT4_3','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_4','PK_VPX_HIST_STAT4_4','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_5','PK_VPX_HIST_STAT4_5','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_6','PK_VPX_HIST_STAT4_6','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_7','PK_VPX_HIST_STAT4_7','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_8','PK_VPX_HIST_STAT4_8','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_9','PK_VPX_HIST_STAT4_9','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_10','PK_VPX_HIST_STAT4_10','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_11','PK_VPX_HIST_STAT4_11','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_12','PK_VPX_HIST_STAT4_12','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_13','PK_VPX_HIST_STAT4_13','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_14','PK_VPX_HIST_STAT4_14','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_15','PK_VPX_HIST_STAT4_15','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_16','PK_VPX_HIST_STAT4_16','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_17','PK_VPX_HIST_STAT4_17','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_18','PK_VPX_HIST_STAT4_18','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_19','PK_VPX_HIST_STAT4_19','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_20','PK_VPX_HIST_STAT4_20','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_21','PK_VPX_HIST_STAT4_21','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_22','PK_VPX_HIST_STAT4_22','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_23','PK_VPX_HIST_STAT4_23','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_24','PK_VPX_HIST_STAT4_24','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_25','PK_VPX_HIST_STAT4_25','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_26','PK_VPX_HIST_STAT4_26','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_27','PK_VPX_HIST_STAT4_27','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_28','PK_VPX_HIST_STAT4_28','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_29','PK_VPX_HIST_STAT4_29','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_30','PK_VPX_HIST_STAT4_30','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_31','PK_VPX_HIST_STAT4_31','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_32','PK_VPX_HIST_STAT4_32','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_33','PK_VPX_HIST_STAT4_33','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_34','PK_VPX_HIST_STAT4_34','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_35','PK_VPX_HIST_STAT4_35','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_36','PK_VPX_HIST_STAT4_36','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_37','PK_VPX_HIST_STAT4_37','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_38','PK_VPX_HIST_STAT4_38','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_39','PK_VPX_HIST_STAT4_39','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_40','PK_VPX_HIST_STAT4_40','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_41','PK_VPX_HIST_STAT4_41','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_42','PK_VPX_HIST_STAT4_42','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_43','PK_VPX_HIST_STAT4_43','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_44','PK_VPX_HIST_STAT4_44','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_45','PK_VPX_HIST_STAT4_45','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_46','PK_VPX_HIST_STAT4_46','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_47','PK_VPX_HIST_STAT4_47','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_48','PK_VPX_HIST_STAT4_48','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_49','PK_VPX_HIST_STAT4_49','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_50','PK_VPX_HIST_STAT4_50','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_51','PK_VPX_HIST_STAT4_51','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_52','PK_VPX_HIST_STAT4_52','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_53','PK_VPX_HIST_STAT4_53','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_54','PK_VPX_HIST_STAT4_54','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_55','PK_VPX_HIST_STAT4_55','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_56','PK_VPX_HIST_STAT4_56','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_57','PK_VPX_HIST_STAT4_57','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_58','PK_VPX_HIST_STAT4_58','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_59','PK_VPX_HIST_STAT4_59','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_60','PK_VPX_HIST_STAT4_60','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_61','PK_VPX_HIST_STAT4_61','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_62','PK_VPX_HIST_STAT4_62','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_63','PK_VPX_HIST_STAT4_63','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_64','PK_VPX_HIST_STAT4_64','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_65','PK_VPX_HIST_STAT4_65','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_66','PK_VPX_HIST_STAT4_66','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_67','PK_VPX_HIST_STAT4_67','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_68','PK_VPX_HIST_STAT4_68','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_69','PK_VPX_HIST_STAT4_69','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_70','PK_VPX_HIST_STAT4_70','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_71','PK_VPX_HIST_STAT4_71','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_72','PK_VPX_HIST_STAT4_72','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_73','PK_VPX_HIST_STAT4_73','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_74','PK_VPX_HIST_STAT4_74','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_75','PK_VPX_HIST_STAT4_75','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_76','PK_VPX_HIST_STAT4_76','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_77','PK_VPX_HIST_STAT4_77','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_78','PK_VPX_HIST_STAT4_78','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_79','PK_VPX_HIST_STAT4_79','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_80','PK_VPX_HIST_STAT4_80','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_81','PK_VPX_HIST_STAT4_81','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_82','PK_VPX_HIST_STAT4_82','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_83','PK_VPX_HIST_STAT4_83','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_84','PK_VPX_HIST_STAT4_84','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_85','PK_VPX_HIST_STAT4_85','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_86','PK_VPX_HIST_STAT4_86','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_87','PK_VPX_HIST_STAT4_87','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_88','PK_VPX_HIST_STAT4_88','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_89','PK_VPX_HIST_STAT4_89','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_90','PK_VPX_HIST_STAT4_90','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_91','PK_VPX_HIST_STAT4_91','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_92','PK_VPX_HIST_STAT4_92','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_93','PK_VPX_HIST_STAT4_93','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_94','PK_VPX_HIST_STAT4_94','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_95','PK_VPX_HIST_STAT4_95','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_96','PK_VPX_HIST_STAT4_96','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_97','PK_VPX_HIST_STAT4_97','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_98','PK_VPX_HIST_STAT4_98','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_99','PK_VPX_HIST_STAT4_99','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_100','PK_VPX_HIST_STAT4_100','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_101','PK_VPX_HIST_STAT4_101','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_102','PK_VPX_HIST_STAT4_102','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_103','PK_VPX_HIST_STAT4_103','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_104','PK_VPX_HIST_STAT4_104','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_105','PK_VPX_HIST_STAT4_105','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_106','PK_VPX_HIST_STAT4_106','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_107','PK_VPX_HIST_STAT4_107','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_108','PK_VPX_HIST_STAT4_108','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_109','PK_VPX_HIST_STAT4_109','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_110','PK_VPX_HIST_STAT4_110','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_111','PK_VPX_HIST_STAT4_111','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_112','PK_VPX_HIST_STAT4_112','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_113','PK_VPX_HIST_STAT4_113','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_114','PK_VPX_HIST_STAT4_114','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_115','PK_VPX_HIST_STAT4_115','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_116','PK_VPX_HIST_STAT4_116','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_117','PK_VPX_HIST_STAT4_117','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_118','PK_VPX_HIST_STAT4_118','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_119','PK_VPX_HIST_STAT4_119','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_120','PK_VPX_HIST_STAT4_120','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_121','PK_VPX_HIST_STAT4_121','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_122','PK_VPX_HIST_STAT4_122','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_123','PK_VPX_HIST_STAT4_123','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_124','PK_VPX_HIST_STAT4_124','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_125','PK_VPX_HIST_STAT4_125','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_126','PK_VPX_HIST_STAT4_126','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_127','PK_VPX_HIST_STAT4_127','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_128','PK_VPX_HIST_STAT4_128','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_129','PK_VPX_HIST_STAT4_129','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_130','PK_VPX_HIST_STAT4_130','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_131','PK_VPX_HIST_STAT4_131','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_132','PK_VPX_HIST_STAT4_132','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_133','PK_VPX_HIST_STAT4_133','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_134','PK_VPX_HIST_STAT4_134','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_135','PK_VPX_HIST_STAT4_135','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_136','PK_VPX_HIST_STAT4_136','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_137','PK_VPX_HIST_STAT4_137','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_138','PK_VPX_HIST_STAT4_138','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_139','PK_VPX_HIST_STAT4_139','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_140','PK_VPX_HIST_STAT4_140','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_141','PK_VPX_HIST_STAT4_141','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_142','PK_VPX_HIST_STAT4_142','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_143','PK_VPX_HIST_STAT4_143','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_144','PK_VPX_HIST_STAT4_144','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_145','PK_VPX_HIST_STAT4_145','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_146','PK_VPX_HIST_STAT4_146','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_147','PK_VPX_HIST_STAT4_147','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_148','PK_VPX_HIST_STAT4_148','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_149','PK_VPX_HIST_STAT4_149','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_150','PK_VPX_HIST_STAT4_150','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_151','PK_VPX_HIST_STAT4_151','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_152','PK_VPX_HIST_STAT4_152','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_153','PK_VPX_HIST_STAT4_153','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_154','PK_VPX_HIST_STAT4_154','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_155','PK_VPX_HIST_STAT4_155','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_156','PK_VPX_HIST_STAT4_156','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_157','PK_VPX_HIST_STAT4_157','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_158','PK_VPX_HIST_STAT4_158','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_159','PK_VPX_HIST_STAT4_159','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_160','PK_VPX_HIST_STAT4_160','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_161','PK_VPX_HIST_STAT4_161','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_162','PK_VPX_HIST_STAT4_162','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_163','PK_VPX_HIST_STAT4_163','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_164','PK_VPX_HIST_STAT4_164','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_165','PK_VPX_HIST_STAT4_165','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_166','PK_VPX_HIST_STAT4_166','C');
 /
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_167','PK_VPX_HIST_STAT4_167','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_168','PK_VPX_HIST_STAT4_168','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_169','PK_VPX_HIST_STAT4_169','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_170','PK_VPX_HIST_STAT4_170','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_171','PK_VPX_HIST_STAT4_171','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_172','PK_VPX_HIST_STAT4_172','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_173','PK_VPX_HIST_STAT4_173','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_174','PK_VPX_HIST_STAT4_174','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_175','PK_VPX_HIST_STAT4_175','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_176','PK_VPX_HIST_STAT4_176','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_177','PK_VPX_HIST_STAT4_177','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_178','PK_VPX_HIST_STAT4_178','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_179','PK_VPX_HIST_STAT4_179','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_180','PK_VPX_HIST_STAT4_180','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_181','PK_VPX_HIST_STAT4_181','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_182','PK_VPX_HIST_STAT4_182','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT4_183','PK_VPX_HIST_STAT4_183','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_1','PK_VPX_HIST_STAT1_1','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_2','PK_VPX_HIST_STAT1_2','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_3','PK_VPX_HIST_STAT1_3','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_4','PK_VPX_HIST_STAT1_4','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_5','PK_VPX_HIST_STAT1_5','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_6','PK_VPX_HIST_STAT1_6','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_7','PK_VPX_HIST_STAT1_7','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_8','PK_VPX_HIST_STAT1_8','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_9','PK_VPX_HIST_STAT1_9','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_10','PK_VPX_HIST_STAT1_10','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_11','PK_VPX_HIST_STAT1_11','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_12','PK_VPX_HIST_STAT1_12','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_13','PK_VPX_HIST_STAT1_13','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_14','PK_VPX_HIST_STAT1_14','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_15','PK_VPX_HIST_STAT1_15','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_16','PK_VPX_HIST_STAT1_16','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_17','PK_VPX_HIST_STAT1_17','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_18','PK_VPX_HIST_STAT1_18','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_19','PK_VPX_HIST_STAT1_19','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_20','PK_VPX_HIST_STAT1_20','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_21','PK_VPX_HIST_STAT1_21','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_22','PK_VPX_HIST_STAT1_22','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_23','PK_VPX_HIST_STAT1_23','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_24','PK_VPX_HIST_STAT1_24','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_25','PK_VPX_HIST_STAT1_25','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_26','PK_VPX_HIST_STAT1_26','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_27','PK_VPX_HIST_STAT1_27','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_28','PK_VPX_HIST_STAT1_28','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_29','PK_VPX_HIST_STAT1_29','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_30','PK_VPX_HIST_STAT1_30','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_31','PK_VPX_HIST_STAT1_31','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_32','PK_VPX_HIST_STAT1_32','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_33','PK_VPX_HIST_STAT1_33','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_34','PK_VPX_HIST_STAT1_34','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_35','PK_VPX_HIST_STAT1_35','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_36','PK_VPX_HIST_STAT1_36','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_37','PK_VPX_HIST_STAT1_37','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_38','PK_VPX_HIST_STAT1_38','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_39','PK_VPX_HIST_STAT1_39','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_40','PK_VPX_HIST_STAT1_40','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_41','PK_VPX_HIST_STAT1_41','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_42','PK_VPX_HIST_STAT1_42','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_43','PK_VPX_HIST_STAT1_43','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_44','PK_VPX_HIST_STAT1_44','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_45','PK_VPX_HIST_STAT1_45','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_46','PK_VPX_HIST_STAT1_46','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_47','PK_VPX_HIST_STAT1_47','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_48','PK_VPX_HIST_STAT1_48','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_49','PK_VPX_HIST_STAT1_49','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_50','PK_VPX_HIST_STAT1_50','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_51','PK_VPX_HIST_STAT1_51','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_52','PK_VPX_HIST_STAT1_52','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_53','PK_VPX_HIST_STAT1_53','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_54','PK_VPX_HIST_STAT1_54','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_55','PK_VPX_HIST_STAT1_55','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_56','PK_VPX_HIST_STAT1_56','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_57','PK_VPX_HIST_STAT1_57','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_58','PK_VPX_HIST_STAT1_58','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_59','PK_VPX_HIST_STAT1_59','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_60','PK_VPX_HIST_STAT1_60','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_61','PK_VPX_HIST_STAT1_61','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_62','PK_VPX_HIST_STAT1_62','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_63','PK_VPX_HIST_STAT1_63','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_64','PK_VPX_HIST_STAT1_64','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_65','PK_VPX_HIST_STAT1_65','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_66','PK_VPX_HIST_STAT1_66','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_67','PK_VPX_HIST_STAT1_67','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_68','PK_VPX_HIST_STAT1_68','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_69','PK_VPX_HIST_STAT1_69','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_70','PK_VPX_HIST_STAT1_70','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_71','PK_VPX_HIST_STAT1_71','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_72','PK_VPX_HIST_STAT1_72','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_73','PK_VPX_HIST_STAT1_73','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_74','PK_VPX_HIST_STAT1_74','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_75','PK_VPX_HIST_STAT1_75','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_76','PK_VPX_HIST_STAT1_76','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_77','PK_VPX_HIST_STAT1_77','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_78','PK_VPX_HIST_STAT1_78','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_79','PK_VPX_HIST_STAT1_79','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_80','PK_VPX_HIST_STAT1_80','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_81','PK_VPX_HIST_STAT1_81','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_82','PK_VPX_HIST_STAT1_82','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_83','PK_VPX_HIST_STAT1_83','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_84','PK_VPX_HIST_STAT1_84','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_85','PK_VPX_HIST_STAT1_85','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_86','PK_VPX_HIST_STAT1_86','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_87','PK_VPX_HIST_STAT1_87','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_88','PK_VPX_HIST_STAT1_88','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_89','PK_VPX_HIST_STAT1_89','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_90','PK_VPX_HIST_STAT1_90','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_91','PK_VPX_HIST_STAT1_91','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_92','PK_VPX_HIST_STAT1_92','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_93','PK_VPX_HIST_STAT1_93','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_94','PK_VPX_HIST_STAT1_94','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_95','PK_VPX_HIST_STAT1_95','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_96','PK_VPX_HIST_STAT1_96','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_97','PK_VPX_HIST_STAT1_97','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_98','PK_VPX_HIST_STAT1_98','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_99','PK_VPX_HIST_STAT1_99','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_100','PK_VPX_HIST_STAT1_100','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_101','PK_VPX_HIST_STAT1_101','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_102','PK_VPX_HIST_STAT1_102','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_103','PK_VPX_HIST_STAT1_103','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_104','PK_VPX_HIST_STAT1_104','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_105','PK_VPX_HIST_STAT1_105','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_106','PK_VPX_HIST_STAT1_106','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_107','PK_VPX_HIST_STAT1_107','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_108','PK_VPX_HIST_STAT1_108','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_109','PK_VPX_HIST_STAT1_109','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_110','PK_VPX_HIST_STAT1_110','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_111','PK_VPX_HIST_STAT1_111','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_112','PK_VPX_HIST_STAT1_112','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_113','PK_VPX_HIST_STAT1_113','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_114','PK_VPX_HIST_STAT1_114','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_115','PK_VPX_HIST_STAT1_115','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_116','PK_VPX_HIST_STAT1_116','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_117','PK_VPX_HIST_STAT1_117','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_118','PK_VPX_HIST_STAT1_118','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_119','PK_VPX_HIST_STAT1_119','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_120','PK_VPX_HIST_STAT1_120','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_121','PK_VPX_HIST_STAT1_121','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_122','PK_VPX_HIST_STAT1_122','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_123','PK_VPX_HIST_STAT1_123','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_124','PK_VPX_HIST_STAT1_124','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_125','PK_VPX_HIST_STAT1_125','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_126','PK_VPX_HIST_STAT1_126','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_127','PK_VPX_HIST_STAT1_127','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_128','PK_VPX_HIST_STAT1_128','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_129','PK_VPX_HIST_STAT1_129','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_130','PK_VPX_HIST_STAT1_130','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_131','PK_VPX_HIST_STAT1_131','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_132','PK_VPX_HIST_STAT1_132','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_133','PK_VPX_HIST_STAT1_133','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_134','PK_VPX_HIST_STAT1_134','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_135','PK_VPX_HIST_STAT1_135','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_136','PK_VPX_HIST_STAT1_136','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_137','PK_VPX_HIST_STAT1_137','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_138','PK_VPX_HIST_STAT1_138','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_139','PK_VPX_HIST_STAT1_139','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_140','PK_VPX_HIST_STAT1_140','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_141','PK_VPX_HIST_STAT1_141','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_142','PK_VPX_HIST_STAT1_142','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_143','PK_VPX_HIST_STAT1_143','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_144','PK_VPX_HIST_STAT1_144','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_145','PK_VPX_HIST_STAT1_145','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_146','PK_VPX_HIST_STAT1_146','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_147','PK_VPX_HIST_STAT1_147','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_148','PK_VPX_HIST_STAT1_148','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_149','PK_VPX_HIST_STAT1_149','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_150','PK_VPX_HIST_STAT1_150','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_151','PK_VPX_HIST_STAT1_151','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_152','PK_VPX_HIST_STAT1_152','C');
 /
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_153','PK_VPX_HIST_STAT1_153','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_154','PK_VPX_HIST_STAT1_154','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_155','PK_VPX_HIST_STAT1_155','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_156','PK_VPX_HIST_STAT1_156','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_157','PK_VPX_HIST_STAT1_157','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_158','PK_VPX_HIST_STAT1_158','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_159','PK_VPX_HIST_STAT1_159','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_160','PK_VPX_HIST_STAT1_160','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_161','PK_VPX_HIST_STAT1_161','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_162','PK_VPX_HIST_STAT1_162','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_163','PK_VPX_HIST_STAT1_163','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_164','PK_VPX_HIST_STAT1_164','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_165','PK_VPX_HIST_STAT1_165','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_166','PK_VPX_HIST_STAT1_166','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_167','PK_VPX_HIST_STAT1_167','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_168','PK_VPX_HIST_STAT1_168','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_169','PK_VPX_HIST_STAT1_169','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_170','PK_VPX_HIST_STAT1_170','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_171','PK_VPX_HIST_STAT1_171','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_172','PK_VPX_HIST_STAT1_172','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_173','PK_VPX_HIST_STAT1_173','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_174','PK_VPX_HIST_STAT1_174','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_175','PK_VPX_HIST_STAT1_175','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_176','PK_VPX_HIST_STAT1_176','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_177','PK_VPX_HIST_STAT1_177','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_178','PK_VPX_HIST_STAT1_178','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_179','PK_VPX_HIST_STAT1_179','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_180','PK_VPX_HIST_STAT1_180','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_181','PK_VPX_HIST_STAT1_181','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_182','PK_VPX_HIST_STAT1_182','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_183','PK_VPX_HIST_STAT1_183','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_184','PK_VPX_HIST_STAT1_184','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_185','PK_VPX_HIST_STAT1_185','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_186','PK_VPX_HIST_STAT1_186','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_187','PK_VPX_HIST_STAT1_187','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_188','PK_VPX_HIST_STAT1_188','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_189','PK_VPX_HIST_STAT1_189','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_190','PK_VPX_HIST_STAT1_190','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_191','PK_VPX_HIST_STAT1_191','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_192','PK_VPX_HIST_STAT1_192','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_193','PK_VPX_HIST_STAT1_193','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_194','PK_VPX_HIST_STAT1_194','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_195','PK_VPX_HIST_STAT1_195','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_196','PK_VPX_HIST_STAT1_196','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_197','PK_VPX_HIST_STAT1_197','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_198','PK_VPX_HIST_STAT1_198','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_199','PK_VPX_HIST_STAT1_199','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_200','PK_VPX_HIST_STAT1_200','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_201','PK_VPX_HIST_STAT1_201','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_202','PK_VPX_HIST_STAT1_202','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_203','PK_VPX_HIST_STAT1_203','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_204','PK_VPX_HIST_STAT1_204','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_205','PK_VPX_HIST_STAT1_205','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_206','PK_VPX_HIST_STAT1_206','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_207','PK_VPX_HIST_STAT1_207','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_208','PK_VPX_HIST_STAT1_208','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_209','PK_VPX_HIST_STAT1_209','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_210','PK_VPX_HIST_STAT1_210','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_211','PK_VPX_HIST_STAT1_211','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_212','PK_VPX_HIST_STAT1_212','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_213','PK_VPX_HIST_STAT1_213','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_214','PK_VPX_HIST_STAT1_214','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_215','PK_VPX_HIST_STAT1_215','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_216','PK_VPX_HIST_STAT1_216','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_217','PK_VPX_HIST_STAT1_217','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_218','PK_VPX_HIST_STAT1_218','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_219','PK_VPX_HIST_STAT1_219','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_220','PK_VPX_HIST_STAT1_220','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_221','PK_VPX_HIST_STAT1_221','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_222','PK_VPX_HIST_STAT1_222','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_223','PK_VPX_HIST_STAT1_223','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_224','PK_VPX_HIST_STAT1_224','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_225','PK_VPX_HIST_STAT1_225','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_226','PK_VPX_HIST_STAT1_226','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_227','PK_VPX_HIST_STAT1_227','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_228','PK_VPX_HIST_STAT1_228','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_229','PK_VPX_HIST_STAT1_229','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_230','PK_VPX_HIST_STAT1_230','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_231','PK_VPX_HIST_STAT1_231','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_232','PK_VPX_HIST_STAT1_232','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_233','PK_VPX_HIST_STAT1_233','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_234','PK_VPX_HIST_STAT1_234','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_235','PK_VPX_HIST_STAT1_235','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_236','PK_VPX_HIST_STAT1_236','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_237','PK_VPX_HIST_STAT1_237','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_238','PK_VPX_HIST_STAT1_238','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_239','PK_VPX_HIST_STAT1_239','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_240','PK_VPX_HIST_STAT1_240','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HIST_STAT1_241','PK_VPX_HIST_STAT1_241','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VC_UPGRADE_ID','PK_VPX_UPGRADE_ID','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_PROFILE','PK_VPX_PROF','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HOST_PROFILE','PK_VPX_HOST_PROF','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HOST_PROFILE','FK_VPX_HP_REF_VPX_PROF','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HOST_PROFILE','FK_VPX_HP_REF_VPX_HOST','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_PROFILE_ANSWER_FILE','PK_VPX_PROF_ANSFILE','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_PROFILE_ANSWER_FILE','FK_VPX_ANSFILE_REF_VPX_HOST','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_COMPLIANCE_STATUS','PK_VPX_COMP_STAT','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_COMPLIANCE_STATUS','FK_VPX_COMP_REF_VPX_PROF','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_COMPLIANCE_STATUS','FK_VPX_HP_REF_VPX_ENTI','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_PROFILE_ENTITY_ASSOCIATION','PK_VPX_ENT_ASSO','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_PROFILE_ENTITY_ASSOCIATION','FK_VPX_ENT_ASSO_REF_VPX_PROF','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_PROFILE_ENTITY_ASSOCIATION','FK_VPX_ENT_ASSO_VPX_ENTI','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_ENTITY_LAST_EVENT','PK_VPX_LAST_EVENT','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_ENTITY_LAST_EVENT','FK_VPX_LAST_EVENT_EVENT','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_STAT_DEV_TYPE_DEF','PK_VPX_STAT_DEV_TYPE_DEF','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_STAT_DEV_TYPE','PK_VPX_STAT_DEV_TYPE','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_STAT_DEV_TYPE','FK_VPX_STAT_DEV_TYPE2','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HOST_INTERNAL_CAPABILITY','PK_HOST_INTERVAL_CAPABILITY','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HOST_INTERNAL_CAPABILITY','FK_INTERVAL_CAPABILITY_HOST','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_COMPUTE_RES_FAILOVER_HOST','PK_COMPUTE_RES_FAILOVER_HOST','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_COMPUTE_RES_FAILOVER_HOST','FK_VPX_FAILOVER_HOST_REF1','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_COMPUTE_RES_FAILOVER_HOST','FK_VPX_FAILOVER_HOST_REF2','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VM_DS_SPACE','PK_VPX_VM_DS_SPACE','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VM_DS_SPACE','FK_VPX_VM_DS_SPACE2','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VM_CONFIG_INFO','PK_VPX_VM_CONFIG_INFO','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VIRTUAL_DEVICE','PK_VPX_VIRTUAL_DEVICE','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VDEVICE_BACKING_REL','PK_VPX_VDEVICE_BACKING_REL','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VDEVICE_BACKING_REL','FK_VPX_VDEVICE_BACKING_REL','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VDEVICE_DEVICE_BACKING','PK_VDEVICE_DEVICE_BACKING','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VDEVICE_DEVICE_BACKING','FK_VDEVICE_DEVICE_BACKING','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VDEVICE_PLUGIN_BACKING','PK_VDEVICE_PLUGIN_BACKING','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VDEVICE_PLUGIN_BACKING','FK_VDEVICE_PLUGIN_BACKING','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VDEVICE_FILE_BACKING','PK_VDEVICE_FILE_BACKING','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VDEVICE_FILE_BACKING','FK_VDEVICE_FILE_BACKING','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VDEVICE_FILE_BACKING_X','PK_VDEVICE_FILE_BACKING_X','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VDEVICE_FILE_BACKING_X','FK_VDEVICE_FILE_BACKING_X','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VDEVICE_DEVICE_BACKING_X','PK_VDEVICE_DEVICE_BACKING_X','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VDEVICE_DEVICE_BACKING_X','FK_VDEVICE_DEVICE_BACKING_X','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VDEVICE_PIPE_BACKING','PK_VPX_VDEVICE_PIPE_BACKING','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VDEVICE_PIPE_BACKING','FK_VPX_VDEVICE_PIPE_BACKING','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DISTR_VPORT_BACKING','PK_VPX_DISTR_VPORT_BACKING','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DISTR_VPORT_BACKING','FK_VPX_DISTR_VPORT_BACKING','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_OPAQUE_NET_BACKING','PK_VPX_OPAQUE_NET_BACKING','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_OPAQUE_NET_BACKING','FK_VPX_OPAQUE_NET_BACKING','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VIRTUAL_DISK','PK_VPX_VIRTUAL_DISK','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VIRTUAL_DISK','FK_VPX_VIRTUAL_DISK','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VIRTUAL_DISK_IOFILTERS','PK_VPX_VDISK_IOFILTER','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VIRTUAL_DISK_IOFILTERS','FK_VPX_VDISK_IOFILTER','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VIRTUAL_ETHERNET_CARD','PK_VPX_VIRTUAL_ETHERNET_CARD','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VIRTUAL_ETHERNET_CARD','FK_VPX_VIRTUAL_ETHERNET_CARD','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VSRIOV_ETHERNET_CARD','PK_VPX_VSRIOV_ETHERNET_CARD','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VSRIOV_ETHERNET_CARD','FK_VPX_VSRIOV_ETHERNET_CARD','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VIRTUAL_SERIAL_PORT','PK_VPX_VIRTUAL_SERIAL_PORT','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VIRTUAL_SERIAL_PORT','FK_V_VIR_SER_PO_REF_V_VIR_DEV','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VIRTUAL_USB','PK_VPX_VIRTUAL_USB','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VIRTUAL_USB','FK_V_VIR_REF_V_VIRTUAL_DEVICE','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VIRTUAL_VMCIDEVICE','PK_VPX_VIRTUAL_VMCIDEVICE','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VIRTUAL_VMCIDEVICE','FK_V_VIR_VMCID_REF_V_VIR_DEV','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VIRTUAL_VIDEO_CARD','PK_VPX_VIRTUAL_VIDEO_CARD','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VIRTUAL_VIDEO_CARD','FK_V_VIR_VI_CA_REF_V_VIR_DEV','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VIRTUAL_CONTROLLER','PK_VPX_VIRTUAL_CONTROLLER','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VIRTUAL_CONTROLLER','FK_V_VIR_CONTR_REF_V_VIR_DEV','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VIRTUAL_SCSICONTROLLER','PK_VPX_VIRTUAL_SCSICONTROLLER','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VIRTUAL_SCSICONTROLLER','FK_V_V_SCSICON_REF_V_VIR_CONTR','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VIRTUAL_SATACONTROLLER','PK_VPX_VIRTUAL_SATACONTROLLER','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VIRTUAL_SATACONTROLLER','FK_V_SATACON_REF_VCONTR','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VIRTUAL_USBCONTROLLER','PK_VPX_VIRTUAL_USBCONTROLLER','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VIRTUAL_USBCONTROLLER','FK_V_V_USBCON_REF_V_VIR_CONTR','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_INT_ARRAY','PK_VPX_INT_ARRAY','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_STRING_ARRAY','PK_VPX_STRING_ARRAY','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_TEXT_ARRAY','PK_VPX_TEXT_ARRAY','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_TYPE_MAP','PK_VPX_TYPE_MAP','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HOST_CONFIG_INFO','PK_VPX_HOST_CONFIG_INFO','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HOST_CONFIG_INFO','FK_HO_CON_INFO_REF_VPX_HOST1','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_FILE_SYSTEM_MOUNT_INFO','PK_VPX_FILE_SYSTEM_MOUNT_INFO','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_FILE_SYSTEM_MOUNT_INFO','FK_V_FI_SYS_MO_IN_REF_VPX_HOST','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VMFS_VOLUME','PK_VPX_VMFS_VOLUME','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VMFS_VOLUME','FK_V_VM_VOL_REF_V_FI_SYS_MO_IN','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SCSI_DISK_PARTITION','FK_V_PART_REF_V_FI_SYS_MO_INFO','C');
 /
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HOST_BUS_ADAPTER','PK_VPX_HOST_BUS_ADAPTER','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HOST_BUS_ADAPTER','FK_V_HO_B_ADAPTER_REF_VPX_HOST','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SCSI_LUN','PK_VPX_SCSI_LUN','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SCSI_LUN','FK_VPX_SCSI_LUN_REF_VPX_HOST','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_PSA_ADAPTER','PK_PSA_ADAPTER','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_PSA_ADAPTER','FK_PSA_ADAPTER1','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_PSA_DEVICE','PK_PSA_DEVICE','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_PSA_DEVICE','FK_PSA_DEVICE','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_PSA_TARGET','PK_PSA_TARGET','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_PSA_TARGET','FK_PSA_TARGET','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_PSA_TARGET_TRANSPORT','PK_PSA_TARGET_TRANSPORT','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_PSA_TARGET_TRANSPORT','FK_PSA_TARGET_TRANSPORT','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_PSA_PATH','PK_PSA_PATH','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_PSA_PATH','FK_PSA_PATH1','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_MULTIPATHSTATEINFO_PATH','PK_MPSI_PATH','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_MULTIPATHSTATEINFO_PATH','FK_VPX_MUL_PATH_HOST','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HOST_TEXT','PK_HOST_TEXT','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_HOST_TEXT','FK_HOST_TEXT_HOST','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DATASTORE_INFO','PK_VPX_DATASTORE_INFO','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DATASTORE_INFO','FK_VPX_DATASTORE_INFO','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VMFS_EXTENT','PK_VPX_VMFS_EXTENT','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VMFS_EXTENT','FK_VMFS_EXTENT_REF_DATASTORE','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VM_FILE_LAYOUT_EX','PK_FILE_LAYOUT_EX','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VM_FLE_DISK_LAYOUT','PK_FLE_DISK_LAYOUT','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VM_FLE_DISK_UNIT','PK_FLE_DISK_UNIT','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VM_FLE_DISK_UNIT','FK_FLE_DISK_UNIT_REF_DL','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VM_FLE_FILE_INFO','PK_FLE_FILE_INFO','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VM_FLE_SNAPSHOT_LAYOUT','PK_FLE_SNAPSHOT_LAYOUT','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VM_FLE_SNAPSHOT_DISK','PK_FLE_SNAPSHOT_DISK','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VM_FLE_SNAPSHOT_DISK','FK_FLE_SNAPSHOT_D_REF_SN','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VM_FLE_SNAP_DISK_UNIT','PK_FLE_SNAP_DISK_UNIT','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VM_FLE_SNAP_DISK_UNIT','FK_FLE_SNAP_DISK_U_REF_SD','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SN_CONFIG_INFO','PK_VPX_SN_CONFIG_INFO','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SN_CONFIG_INFO','FK_V_SN_CONFIG_INFO_REF_VPX_SN','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SN_VIRTUAL_DEVICE','PK_VPX_SN_VIRTUAL_DEVICE','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SN_VIRTUAL_DEVICE','FK_SN_VIR_DEV_REF_SN','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SN_VDEVICE_BACKING_REL','PK_SN_VPX_VDEVICE_BACKING_REL','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SN_VDEVICE_BACKING_REL','FK_SN_VPX_VDEVICE_BACKING_REL','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SN_VDEVICE_DEVICE_BACKING','PK_SN_VDEVICE_DEVICE_BACKING','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SN_VDEVICE_DEVICE_BACKING','FK_SN_VDEVICE_DEVICE_BACKING','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SN_VDEVICE_PLUGIN_BACKING','PK_SN_VDEVICE_PLUGIN_BACKING','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SN_VDEVICE_PLUGIN_BACKING','FK_SN_VDEVICE_PLUGIN_BACKING','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SN_VDEVICE_FILE_BACKING','PK_SN_VDEVICE_FILE_BACKING','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SN_VDEVICE_FILE_BACKING','FK_SN_VDEVICE_FILE_BACKING','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SN_VDEVICE_FILE_BACKING_X','PK_SN_VDEVICE_FILE_BACKING_X','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SN_VDEVICE_FILE_BACKING_X','FK_SN_VDEVICE_FILE_BACKING_X','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SN_VD_DEVICE_BACKING_X','PK_SN_VD_DEVICE_BACKING_X','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SN_VD_DEVICE_BACKING_X','FK_SN_VD_DEVICE_BACKING_X','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SN_VDEVICE_PIPE_BACKING','PK_VPX_SN_VDEVICE_PIPE_BACKING','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SN_VDEVICE_PIPE_BACKING','FK_VPX_SN_VDEVICE_PIPE_BACKING','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SN_DISTR_VPORT_BACKING','PK_VPX_SN_DISTR_VPORT_BACKING','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SN_DISTR_VPORT_BACKING','FK_VPX_SN_DISTR_VPORT_BACKING','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SN_OPAQUE_NET_BACKING','PK_VPX_SN_OPAQUE_NET_BACKING','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SN_OPAQUE_NET_BACKING','FK_VPX_SN_OPAQUE_NET_BACKING','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SN_VIRTUAL_DISK','PK_VPX_SN_VIRTUAL_DISK','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SN_VIRTUAL_DISK','FK_VPX_SN_VIRTUAL_DISK','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SN_VIRTUAL_ETHERNET_CARD','PK_VPX_SN_VETHERNET_CARD','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SN_VIRTUAL_ETHERNET_CARD','FK_VPX_SN_VETHERNET_CARD','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SN_VSRIOV_ETHERNET_CARD','PK_VPX_SN_VSETHERNET_CARD','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SN_VSRIOV_ETHERNET_CARD','FK_VPX_SN_VSETHERNET_CARD','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SN_VIRTUAL_SERIAL_PORT','PK_VPX_SN_VIRTUAL_SERIAL_PORT','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SN_VIRTUAL_SERIAL_PORT','FK_SN_VIR_SER_PO_REF_VDEV','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SN_VIRTUAL_USB','PK_VPX_SN_VIRTUAL_USB','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SN_VIRTUAL_USB','FK_SN_VUSB_REF_VIRTUAL_DEVICE','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SN_VIRTUAL_VMCIDEVICE','PK_VPX_SN_VIRTUAL_VMCIDEVICE','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SN_VIRTUAL_VMCIDEVICE','FK_SN_VIR_VMCID_REF_VDEV','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SN_VIRTUAL_VIDEO_CARD','PK_VPX_SN_VIRTUAL_VIDEO_CARD','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SN_VIRTUAL_VIDEO_CARD','FK_SN_VIR_VICA_REF_VDEV','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SN_VIRTUAL_CONTROLLER','PK_VPX_SN_VIRTUAL_CONTROLLER','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SN_VIRTUAL_CONTROLLER','FK_SN_VIR_CONTR_REF_VDEV','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SN_VIRTUAL_SCSICONTROLLER','PK_SN_VIRTUAL_SCSICONTROLLER','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SN_VIRTUAL_SCSICONTROLLER','FK_SN_SCSICON_REF_VCONTR','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SN_VIRTUAL_SATACONTROLLER','PK_SN_VIRTUAL_SATACONTROLLER','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SN_VIRTUAL_SATACONTROLLER','FK_SN_SATACON_REF_VCONTR','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SN_VIRTUAL_USBCONTROLLER','PK_SN_VIRTUAL_USBCONTROLLER','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SN_VIRTUAL_USBCONTROLLER','FK_SN_USBCON_REF_VCONTR','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SCSILUN_DESCRIPTOR','PK_VPX_SCSILUN_DESCRIPTOR','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SCSILUN_DESCRIPTOR','FK_VPX_SCSILUN_REF_DESCRIPTOR','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_USAGE_STAT','PK_VPX_USAGE_STAT','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_USAGE_SAMPLE_TIME','PK_VPX_USAGE_SAMPLE_TIME','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_TAG','PK_VPX_TAG','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_TAG_ENT_ASSOCIATION','PK_VPX_TAG_ENT_ASSOCIATION','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_TAG_ENT_ASSOCIATION','FK_TAG_ENT_ASSOCIATION1','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_TAG_ENT_ASSOCIATION','FK_TAG_ENT_ASSOCIATION2','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_ENTITY_VMOP_COUNT','PK_VPX_ENTITY_VMOP_COUNT','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_ENTITY_VMOP_COUNT','FK_VPX_ENTITY_VMOP_COUNT_REF','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_BINARY_DATA','PK_VPX_BIN_DATA','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVHOST_OUT_OF_SYNC','PK_DVHOST_OUT_OF_SYNC','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DVHOST_OUT_OF_SYNC','FK_DVHOST_OUT_OF_SYNC_REF_ENTI','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_VAPP_LINK','PK_VPX_VAPP_LINK','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_LIC_METADATA','CK_DATA_TYPE','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_LIC_METADATA','CK_VPX_LIC_METADATA_IS_VALID','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_LIC_METADATA','PK_VPX_LIC_METADATA','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_LIC_ASSETS','PK_VPX_LIC_ASSETS','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_LIC_LICENSES','PK_VPX_LIC_LICENSES','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_LIC_VC_GROUPS','PK_VPX_LIC_VC_GROUPS','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_LIC_CONTEXT','PK_VPX_LIC_CONTEXT','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_LIC_CONTEXT','FK_VPX_LIC_ASSETS_CONTEXT','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_LIC_CONTEXT','FK_VPX_LIC_LICENSES_CONTEXT','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_LIC_CONTEXT','FK_VPX_LIC_VC_GROUPS_CONTEXT','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_LIC_VC_GROUP_MEMBERS','PK_VPX_LIC_VC_GROUP_MEMBERS','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_LIC_VC_GROUP_MEMBERS','FK_VPX_LIC_VC_GROUPS_MEMBERS','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_LIC_USAGE','IX_VPX_LIC_USAGE','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_LIC_USAGE','PK_VPX_LIC_USAGE','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_LIC_USAGE','FK_VPX_LIC_CONTEXT_USAGE','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_LIC_SETTINGS','PK_VPX_LIC_SETTINGS','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_LIC_ASSET_PROPERTIES','CK_IS_ACTIVE','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_LIC_ASSET_PROPERTIES','PK_VPX_LIC_ASSET_PROPERTIES','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_LIC_ASSET_PROPERTIES','FK_VPX_LIC_METADATA_PROPERTIES','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_LIC_ASSET_PROPERTIES','FK_VPX_LIC_ASSETS_PROPERTIES','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_PRODUCT','PK_PRODUCT','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_TERMINATION_REASON','PK_TERMINATION_REASON','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_UPTIME','PK_VPX_UPTIME','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_UPTIME','FK_VPX_UPTIME_PRODID','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_UPTIME','FK_VPX_UPTIME_TERMID','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SDRS_POD_CONFIG','PK_VPX_SDRS_POD_CONFIG','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SDRS_POD_CONFIG','FK_VPX_SDRS_POD_CONFIG','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_TABLE','PK_VPX_TABLE','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_INDEX_COLUMN','PK_VPX_INDEX_COLUMN','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SDRS_STATS_VM','PK_VPX_SDRS_STATS_VM','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_SDRS_STATS_DATASTORE','PK_VPX_STATS_DS','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_LIC_TPS_ASSETS','PK_VPX_LIC_TPS_ASSETS','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_LIC_TPS_ASSETS','UK_VPX_LIC_TPS_ASSETS','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_LIC_AUTO_KEYS','PK_VPX_LIC_AUTO_KEYS','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_LIC_AUTO_KEYS','FK_VPX_LIC_AUTO_KEYS_ENTITY_ID','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_LIC_AUTO_KEYS','FK_VPX_LIC_AUTO_KEYS_ASSET_ID','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DBM_COUNTER_METADATA','CK_COUNTER_RANGE_TYPE','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DBM_COUNTER_METADATA','PK_VPX_DBM_COUNTER_METADATA','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DBM_COUNTER_VALUE','PK_VPX_DBM_COUNTER_VALUE','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_DBM_COUNTER_VALUE','FK_VPX_DBM_COUNTER_VALUES','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_PROC_LOG','PK_VPX_PROC_LOG','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_TOPN_PAST_DAY','PK_VPX_TOPN_PAST_DAY','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_TOPN_PAST_WEEK','PK_VPX_TOPN_PAST_WEEK','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_TOPN_PAST_MONTH','PK_VPX_TOPN_PAST_MONTH','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_TOPN_PAST_YEAR','PK_VPX_TOPN_PAST_YEAR','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_TOPN_STATISTICS','PK_VPX_TOPN_STATISTICS','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_TOPN_STATE','CK_VPX_TOPN_STATE','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_TOPN_STATE','PK_VPX_TOPN_STATE','C');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('VPX_JOB_LOG','PK_VPX_JOB_LOG','C');
 /
 
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_PROFILE_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_CHANGE_TAG_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_DEVICE_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_SAMPLE_TIME1_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_SAMPLE_TIME2_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_SAMPLE_TIME3_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_SAMPLE_TIME4_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_STAT_COUNTER_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_USAGE_SAMPLE_TIME_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_ENTITY_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_SAMPLE_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_TEMPLATE_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_LICENSE_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_EVENT_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_TASK_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_ALARM_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_SCHEDULEDTASK_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_FIELD_DEF_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_STAT_DEF_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_STAT_ID_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_ROLE_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_ACCESS_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_DRSRULES_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_EXT_SERVER_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_EXT_SERVER_EMAIL_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_EXT_CLIENT_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_IMAGE_LIB_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_COMPLIANCE_STATUS_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_VIRTUAL_DEVICE_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_VDEVICE_BACKING_REL_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_SCSI_LUN_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_HOST_BUS_ADAPTER_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_FILE_SYSTEM_MOUNT_INFO_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_TAG_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_VM_FLE_DISK_LAYOUT_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_VM_FLE_SNAPSHOT_LAYOUT_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_VM_FLE_SNAPSHOT_DISK_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_PSA_TARGET_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_PSA_PATH_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_PSA_DEVICE_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_PSA_ADAPTER_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_SN_VDEVICE_BACKING_REL_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_SN_VIRTUAL_DEVICE_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_SCSILUN_DESCRIPTOR_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_BINARY_DATA_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_IP_POOL_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_ARRAY_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_LIC_ASSETS_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_LIC_LICENSES_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_LIC_VC_GROUPS_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_LIC_CONTEXT_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_ANSFILE_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_HOST_CNX_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_ALARM_EXPR_COMP_SURR_KEY_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_PRIV_ROLE_SURR_KEY_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_ACCESS_SURR_KEY_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_WWN_SURR_KEY_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_DVS_UPLINK_SURR_KEY_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_IP_POOL_ALLOCATION_SURR_KEY_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_DVS_COMPATIBLE_SURR_KEY_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_DVPORT_SETTING_SURR_KEY_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_DVS_VSPAN_SESSION_SURR_KEY_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_DVS_SCOPE_SURR_KEY_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_DVS_HC_CONFIG_SURR_KEY_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_DVHOST_HC_RESULT_SURR_KEY_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_DVHOST_HC_VLAN_RESULT_SURR_KEY_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_DVHOST_HC_MTU_RESULT_SURR_KEY_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_DVS_IPFIX_SURR_KEY_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_DVS_OVERLAY_INSTANCE_SURR_KEY_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_DVS_VSPAN_PORTS_SURR_KEY_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_DVS_PVLAN_SURR_KEY_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_DVPORT_VLAN_SURR_KEY_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_UPLINK_TEAMING_SURR_KEY_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_DVS_BLOB_SURR_KEY_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_DVS_OPAQUE_DATA_SURR_KEY_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_DVS_LAG_VLAN_SURR_KEY_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_DVS_TRAFFIC_FILTER_CONFIG_SURR_KEY_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_DVS_TRAFFIC_FILTER_PARAM_SURR_KEY_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_DVS_INFRA_RES_POOL_SURR_KEY_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_DVS_VMVNIC_RES_POOL_SURR_KEY_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_DVS_LAG_SURR_KEY_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_IP_ADDRESS_SURR_KEY_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_HOST_CPUID_FEATURE_SURR_KEY_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_NIC_SURR_KEY_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_HOST_PCI_DEVICE_SURR_KEY_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_EXT_TABS_SURR_KEY_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_EXT_TYPE_IDS_SURR_KEY_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_EXT_PRIVS_SURR_KEY_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_EXT_DATA_SURR_KEY_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_INT_ARRAY_SURR_KEY_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_STRING_ARRAY_SURR_KEY_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_TEXT_ARRAY_SURR_KEY_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_MULTIPATHSTATEINFO_PATH_SURR_KEY_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_VMFS_EXTENT_SURR_KEY_SEQ','S');
  INSERT INTO MGRD_EXP_TABLES_COLUMNS (TABLE_NAME,COLUMN_NAME,TYPE) VALUES ('SEQUENCE','VPX_UPTIME_SURR_KEY_SEQ','S');
 /