
 
 
 
 
 
 delete from vpx_version;
 /
 
 INSERT INTO vpx_version VALUES (650, 'VirtualCenter Database 6.5');
 /
 
 
 
 DROP VIEW IF EXISTS VPXV_RESOURCE_POOL;
 /
 
 
 
 
 ALTER TABLE VPX_RESOURCE_POOL DROP COLUMN HOSTD_ID_VAL;
 /
 
 ALTER TABLE VPX_RESOURCE_POOL DROP COLUMN ALLOCATED_CPU;
 /
 
 ALTER TABLE VPX_RESOURCE_POOL DROP COLUMN ALLOCATED_VM_CPU;
 /
 
 ALTER TABLE VPX_RESOURCE_POOL DROP COLUMN AVAILABLE_POOL_CPU;
 /
 
 ALTER TABLE VPX_RESOURCE_POOL DROP COLUMN AVAILABLE_VM_CPU;
 /
 
 ALTER TABLE VPX_RESOURCE_POOL DROP COLUMN ALLOCATED_MEM;
 /
 
 ALTER TABLE VPX_RESOURCE_POOL DROP COLUMN ALLOCATED_VM_MEM;
 /
 
 ALTER TABLE VPX_RESOURCE_POOL DROP COLUMN AVAILABLE_POOL_MEM;
 /
 
 ALTER TABLE VPX_RESOURCE_POOL DROP COLUMN AVAILABLE_VM_MEM;
 /
 
 ALTER TABLE VPX_RESOURCE_POOL DROP COLUMN CURRENT_CPU;
 /
 
 ALTER TABLE VPX_RESOURCE_POOL DROP COLUMN CURRENT_MEM;
 /
 
 ALTER TABLE VPX_RESOURCE_POOL DROP COLUMN OVERALL_STATUS;
 /
 
 
 
 
 
 create table VPX_PROFILE_HOST_SPEC   (
    HOST_ID                    INT                          not null,
    CREATED_TIME               TIMESTAMP WITH TIME ZONE,
    MODIFIED_TIME              TIMESTAMP WITH TIME ZONE,
    START_TIME                 TIMESTAMP WITH TIME ZONE,
    CHANGE_ID                  BIGINT,
    HOST_SPEC                  TEXT,
    constraint PK_VPX_PROF_HOSTSPEC primary key  (HOST_ID)
 );
 /
 
 
 
 
 create table VPX_JOURNAL (
    ID                   BIGINT               not null,
    TYPE                 INTEGER              not null,
    constraint PK_VPX_JOURNAL primary key (ID)
 );
 /
 
 
 
 
 create table VPX_JOURNAL_ENTRY (
    JOURNAL_ID           BIGINT               not null,
    ENTRY_ID             INTEGER              not null,
    ENTRY_NAME           VARCHAR(255),
    ENTRY_VALUE          TEXT,
    constraint PK_VPX_JOURNAL_ENTRY primary key (JOURNAL_ID, ENTRY_ID),
    constraint FK_VPX_JOURNAL_REF foreign key (JOURNAL_ID)
       references VPX_JOURNAL (ID)
          on delete cascade
 );
 /
 
 
 
 
 ALTER TABLE VPX_JOURNAL_ENTRY SET (autovacuum_vacuum_scale_factor = 0.05);
 ALTER TABLE VPX_JOURNAL_ENTRY SET (toast.autovacuum_vacuum_scale_factor = 0.05);
 ALTER TABLE VPX_JOURNAL_ENTRY SET (autovacuum_analyze_scale_factor = 0.05);
 ALTER TABLE VPX_JOURNAL_ENTRY SET (autovacuum_vacuum_threshold = 25);
 ALTER TABLE VPX_JOURNAL_ENTRY SET (toast.autovacuum_vacuum_threshold = 25);
 ALTER TABLE VPX_JOURNAL_ENTRY SET (autovacuum_analyze_threshold = 25);
 ALTER TABLE VPX_JOURNAL_ENTRY SET (autovacuum_vacuum_cost_delay = 10);
 ALTER TABLE VPX_JOURNAL_ENTRY SET (toast.autovacuum_vacuum_cost_delay = 10);
 ALTER TABLE VPX_JOURNAL_ENTRY SET (autovacuum_vacuum_cost_limit = 1000);
 ALTER TABLE VPX_JOURNAL_ENTRY SET (toast.autovacuum_vacuum_cost_limit = 1000);
 /
 
 
 
 
 
 SELECT PREFTABLESPACE('task');
 /
 DROP INDEX IF EXISTS VPXI_TASK_ALARM_ID;
 /
 CREATE INDEX VPXI_TASK_ALARM_ID on VPX_TASK (ALARM_ID)  WHERE ALARM_ID IS NOT NULL;
 /
 
 DROP INDEX IF EXISTS VPXI_TASK_RESOURCEPOOL_ID;
 /
 CREATE INDEX VPXI_TASK_RESOURCEPOOL_ID on VPX_TASK (RESOURCEPOOL_ID)  WHERE RESOURCEPOOL_ID IS NOT NULL;
 /
 
 DROP INDEX IF EXISTS VPXI_TASK_FOLDER_ID;
 /
 CREATE INDEX VPXI_TASK_FOLDER_ID on VPX_TASK (FOLDER_ID)  WHERE FOLDER_ID IS NOT NULL;
 /
 
 DROP INDEX IF EXISTS VPXI_TASK_SCHEDULEDTASK_ID;
 /
 CREATE INDEX VPXI_TASK_SCHEDULEDTASK_ID on VPX_TASK (SCHEDULEDTASK_ID)  WHERE SCHEDULEDTASK_ID IS NOT NULL;
 /
 
 RESET default_tablespace;
 /
 
 
 
 
 DROP VIEW IF EXISTS VPXV_EVENTS;
 /
 
 DROP FUNCTION IF EXISTS insert_stats_proc (p_counter_id_in in numeric,p_time_id_in in numeric,p_stat_value_in in numeric,p_partition_index_in numeric);
 /
 DROP FUNCTION IF EXISTS delete_stats_proc (p_entity_id_in in numeric(38,0));
 /
 DROP FUNCTION IF EXISTS load_stats_proc (p_entity_id_in in numeric,p_stat_id_in in numeric,p_device_name_in varchar(255),p_time_id_in in numeric,p_stat_value_in in numeric,p_device_type_name_in varchar(255),p_partition_index_in numeric);
 /
 DROP FUNCTION IF EXISTS load_usage_stats_proc (p_entity_id_in in  numeric, p_stat_id_in in  numeric, p_device_name_in in  varchar(255),p_time_id_in in  numeric, p_stat_value_in in  numeric,p_device_type_name_in in  varchar(255));
 /
 
 
 
 
 
 ALTER TABLE VPX_VM_CONFIG_INFO ALTER COLUMN FILES_VM_PATH_NAME TYPE VARCHAR(512);
 /
 ALTER TABLE VPX_SN_CONFIG_INFO ALTER COLUMN FILES_VM_PATH_NAME TYPE VARCHAR(512);
 /
 
 
 
 
 
 
 
 
 
 DROP FUNCTION IF EXISTS process_license_snapshot_proc();
 /
 
 
 
 
 
 DROP VIEW IF EXISTS VPXV_LIC_USAGE_HISTORY;
 /
 
 
 
 
 
 DROP VIEW IF EXISTS VPXV_LIC_VC_GROUPS;
 /
 
 
 
 
 
 DROP TABLE IF EXISTS VPX_LICENSE CASCADE;
 /
 
 
 
 
 
 DROP TABLE IF EXISTS VPX_LIC_SNAPSHOT CASCADE;
 /
 
 
 
 
 
 DROP TABLE IF EXISTS VPX_LIC_SNAPSHOT_VC_GROUP CASCADE;
 /
 
 
 
 
 
 DROP TABLE IF EXISTS VPX_LIC_METADATA CASCADE;
 /
 
 
 
 
 
 DROP TABLE IF EXISTS VPX_LIC_ASSETS CASCADE;
 /
 
 
 
 
 
 DROP TABLE IF EXISTS VPX_LIC_LICENSES CASCADE;
 /
 
 
 
 
 
 DROP TABLE IF EXISTS VPX_LIC_VC_GROUPS CASCADE;
 /
 
 
 
 
 
 DROP TABLE IF EXISTS VPX_LIC_CONTEXT CASCADE;
 /
 
 
 
 
 
 DROP TABLE IF EXISTS VPX_LIC_VC_GROUP_MEMBERS CASCADE;
 /
 
 
 
 
 
 DROP TABLE IF EXISTS VPX_LIC_USAGE CASCADE;
 /
 
 
 
 
 
 DROP TABLE IF EXISTS VPX_LIC_SETTINGS CASCADE;
 /
 
 
 
 
 
 DROP TABLE IF EXISTS VPX_LIC_ASSET_PROPERTIES CASCADE;
 /
 
 
 
 
 
 DROP  SEQUENCE IF EXISTS VPX_LICENSE_SEQ;
 /
 
 
 
 
 
 DROP  SEQUENCE IF EXISTS VPX_LIC_ASSETS_SEQ;
 /
 
 
 
 
 
 DROP  SEQUENCE IF EXISTS VPX_LIC_LICENSES_SEQ;
 /
 
 
 
 
 
 DROP  SEQUENCE IF EXISTS VPX_LIC_VC_GROUPS_SEQ;
 /
 
 
 
 
 
 DROP  SEQUENCE IF EXISTS VPX_LIC_CONTEXT_SEQ;
 /
 
 
 
 
 DROP VIEW IF EXISTS VPXV_HIST_STAT_DAILY;
 /
 DROP VIEW IF EXISTS VPXV_HIST_STAT_WEEKLY;
 /
 DROP VIEW IF EXISTS VPXV_HIST_STAT_MONTHLY;
 /
 DROP VIEW IF EXISTS VPXV_HIST_STAT_YEARLY;
 /
 
 
 
 
 
 DROP RULE IF EXISTS NULL_DEVICE_NAME ON VPX_DEVICE;
 /
 
 
 
 
 ALTER TABLE VPX_DEVICE ALTER COLUMN DEVICE_NAME TYPE VARCHAR(450);
 /
 ALTER TABLE VPX_HOST_PCI_DEVICE ALTER COLUMN DEVICE_NAME TYPE VARCHAR(450);
 /
 ALTER TABLE VPX_SN_VDEVICE_BACKING_REL ALTER COLUMN DEVICE_NAME TYPE VARCHAR(450);
 /
 ALTER TABLE VPX_VDEVICE_BACKING_REL ALTER COLUMN DEVICE_NAME TYPE VARCHAR(450);
 /
 
 
 
 
 
 
 SELECT PREFTABLESPACE('event');
 /
 
 
 
 
 
 ALTER TABLE VPX_EVENT RENAME TO VPX_EVENT_1;
 /
 ALTER INDEX VPXI_EVENT_DVS_ID RENAME TO VPXI_EVENT_DVS_ID_1;
 /
 ALTER INDEX VPXI_EVENT_CATEGORY RENAME TO VPXI_EVENT_CATEGORY_1;
 /
 ALTER INDEX VPXI_EVENT_CHAIN_ID RENAME TO VPXI_EVENT_CHAIN_ID_1;
 /
 ALTER INDEX VPXI_EVENT_COMPUTERESOURCE_ID RENAME TO VPXI_EVENT_COMPUTERES_ID_1;
 /
 ALTER INDEX VPXI_EVENT_CREATE_TIME RENAME TO VPXI_EVENT_CREATE_TIME_1;
 /
 ALTER INDEX VPXI_EVENT_DATACENTER_ID RENAME TO VPXI_EVENT_DATACENTER_ID_1;
 /
 ALTER INDEX VPXI_EVENT_DATASTORE_ID RENAME TO VPXI_EVENT_DATASTORE_ID_1;
 /
 ALTER INDEX VPXI_EVENT_EVENT_TYPE RENAME TO VPXI_EVENT_EVENT_TYPE_1;
 /
 ALTER INDEX VPXI_EVENT_EXTENDED_CLASS RENAME TO VPXI_EVENT_EXTENDED_CLASS_1;
 /
 ALTER INDEX VPXI_EVENT_HOST_ID RENAME TO VPXI_EVENT_HOST_ID_1;
 /
 ALTER INDEX VPXI_EVENT_VM_ID RENAME TO VPXI_EVENT_VM_ID_1;
 /
 ALTER INDEX VPXI_CHANGE_TAG RENAME TO VPXI_CHANGE_TAG_1;
 /
 ALTER INDEX VPXI_EVENT_NETWORK_ID RENAME TO VPXI_EVENT_NETWORK_ID_1;
 /
 ALTER INDEX VPX_EVENT_F1 RENAME TO VPX_EVENT_F1_1;
 /
 
 
 
 ALTER TABLE VPX_EVENT_1 RENAME CONSTRAINT PK_VPX_EVENT TO PK_VPX_EVENT_1;
 /
 ALTER TABLE VPX_EVENT_1 DROP CONSTRAINT IF EXISTS FK_VPX_EVENT_REF_COMPUTERES;
 /
 ALTER TABLE VPX_EVENT_1 DROP CONSTRAINT IF EXISTS FK_VPX_CHANGE_TAG;
 /
 
 CREATE TABLE VPX_EVENT_2 (LIKE VPX_EVENT_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_3 (LIKE VPX_EVENT_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_4 (LIKE VPX_EVENT_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_5 (LIKE VPX_EVENT_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_6 (LIKE VPX_EVENT_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_7 (LIKE VPX_EVENT_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_8 (LIKE VPX_EVENT_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_9 (LIKE VPX_EVENT_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_10 (LIKE VPX_EVENT_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_11 (LIKE VPX_EVENT_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_12 (LIKE VPX_EVENT_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_13 (LIKE VPX_EVENT_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_14 (LIKE VPX_EVENT_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_15 (LIKE VPX_EVENT_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_16 (LIKE VPX_EVENT_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_17 (LIKE VPX_EVENT_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_18 (LIKE VPX_EVENT_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_19 (LIKE VPX_EVENT_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_20 (LIKE VPX_EVENT_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_21 (LIKE VPX_EVENT_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_22 (LIKE VPX_EVENT_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_23 (LIKE VPX_EVENT_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_24 (LIKE VPX_EVENT_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_25 (LIKE VPX_EVENT_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_26 (LIKE VPX_EVENT_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_27 (LIKE VPX_EVENT_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_28 (LIKE VPX_EVENT_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_29 (LIKE VPX_EVENT_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_30 (LIKE VPX_EVENT_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_31 (LIKE VPX_EVENT_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_32 (LIKE VPX_EVENT_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_33 (LIKE VPX_EVENT_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_34 (LIKE VPX_EVENT_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_35 (LIKE VPX_EVENT_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_36 (LIKE VPX_EVENT_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_37 (LIKE VPX_EVENT_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_38 (LIKE VPX_EVENT_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_39 (LIKE VPX_EVENT_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_40 (LIKE VPX_EVENT_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_41 (LIKE VPX_EVENT_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_42 (LIKE VPX_EVENT_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_43 (LIKE VPX_EVENT_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_44 (LIKE VPX_EVENT_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_45 (LIKE VPX_EVENT_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_46 (LIKE VPX_EVENT_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_47 (LIKE VPX_EVENT_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_48 (LIKE VPX_EVENT_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_49 (LIKE VPX_EVENT_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_50 (LIKE VPX_EVENT_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_51 (LIKE VPX_EVENT_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_52 (LIKE VPX_EVENT_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_53 (LIKE VPX_EVENT_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_54 (LIKE VPX_EVENT_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_55 (LIKE VPX_EVENT_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_56 (LIKE VPX_EVENT_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_57 (LIKE VPX_EVENT_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_58 (LIKE VPX_EVENT_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_59 (LIKE VPX_EVENT_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_60 (LIKE VPX_EVENT_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_61 (LIKE VPX_EVENT_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_62 (LIKE VPX_EVENT_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_63 (LIKE VPX_EVENT_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_64 (LIKE VPX_EVENT_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_65 (LIKE VPX_EVENT_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_66 (LIKE VPX_EVENT_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_67 (LIKE VPX_EVENT_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_68 (LIKE VPX_EVENT_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_69 (LIKE VPX_EVENT_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_70 (LIKE VPX_EVENT_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_71 (LIKE VPX_EVENT_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_72 (LIKE VPX_EVENT_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_73 (LIKE VPX_EVENT_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_74 (LIKE VPX_EVENT_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_75 (LIKE VPX_EVENT_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_76 (LIKE VPX_EVENT_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_77 (LIKE VPX_EVENT_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_78 (LIKE VPX_EVENT_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_79 (LIKE VPX_EVENT_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_80 (LIKE VPX_EVENT_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_81 (LIKE VPX_EVENT_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_82 (LIKE VPX_EVENT_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_83 (LIKE VPX_EVENT_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_84 (LIKE VPX_EVENT_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_85 (LIKE VPX_EVENT_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_86 (LIKE VPX_EVENT_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_87 (LIKE VPX_EVENT_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_88 (LIKE VPX_EVENT_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_89 (LIKE VPX_EVENT_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_90 (LIKE VPX_EVENT_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_91 (LIKE VPX_EVENT_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_92 (LIKE VPX_EVENT_1 INCLUDING DEFAULTS);
 /
 
 
 
 
 
 ALTER TABLE VPX_EVENT_ARG RENAME TO VPX_EVENT_ARG_1;
 /
 ALTER INDEX VPX_EVENT_ARG_F1 RENAME TO VPX_EVENT_ARG_F1_1;
 /
 ALTER INDEX VPX_EVENT_ARG_F2 RENAME TO VPX_EVENT_ARG_F2_1;
 /
 ALTER INDEX VPX_EVENT_ARG_F3 RENAME TO VPX_EVENT_ARG_F3_1;
 /
 
 ALTER TABLE VPX_EVENT_ARG_1 RENAME CONSTRAINT PK_VPX_EVENT_ARG TO PK_VPX_EVENT_ARG_1;
 /
 ALTER TABLE VPX_EVENT_ARG_1 DROP CONSTRAINT IF EXISTS FK_VPX_EVENT_ARG_REF_EVENT;
 /
 ALTER TABLE VPX_EVENT_ARG_1 DROP CONSTRAINT IF EXISTS FK_VPX_EVENT_ARG_REF_ENTITY;
 /
 
 CREATE TABLE VPX_EVENT_ARG_2 (LIKE VPX_EVENT_ARG_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_ARG_3 (LIKE VPX_EVENT_ARG_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_ARG_4 (LIKE VPX_EVENT_ARG_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_ARG_5 (LIKE VPX_EVENT_ARG_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_ARG_6 (LIKE VPX_EVENT_ARG_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_ARG_7 (LIKE VPX_EVENT_ARG_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_ARG_8 (LIKE VPX_EVENT_ARG_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_ARG_9 (LIKE VPX_EVENT_ARG_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_ARG_10 (LIKE VPX_EVENT_ARG_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_ARG_11 (LIKE VPX_EVENT_ARG_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_ARG_12 (LIKE VPX_EVENT_ARG_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_ARG_13 (LIKE VPX_EVENT_ARG_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_ARG_14 (LIKE VPX_EVENT_ARG_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_ARG_15 (LIKE VPX_EVENT_ARG_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_ARG_16 (LIKE VPX_EVENT_ARG_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_ARG_17 (LIKE VPX_EVENT_ARG_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_ARG_18 (LIKE VPX_EVENT_ARG_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_ARG_19 (LIKE VPX_EVENT_ARG_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_ARG_20 (LIKE VPX_EVENT_ARG_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_ARG_21 (LIKE VPX_EVENT_ARG_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_ARG_22 (LIKE VPX_EVENT_ARG_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_ARG_23 (LIKE VPX_EVENT_ARG_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_ARG_24 (LIKE VPX_EVENT_ARG_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_ARG_25 (LIKE VPX_EVENT_ARG_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_ARG_26 (LIKE VPX_EVENT_ARG_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_ARG_27 (LIKE VPX_EVENT_ARG_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_ARG_28 (LIKE VPX_EVENT_ARG_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_ARG_29 (LIKE VPX_EVENT_ARG_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_ARG_30 (LIKE VPX_EVENT_ARG_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_ARG_31 (LIKE VPX_EVENT_ARG_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_ARG_32 (LIKE VPX_EVENT_ARG_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_ARG_33 (LIKE VPX_EVENT_ARG_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_ARG_34 (LIKE VPX_EVENT_ARG_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_ARG_35 (LIKE VPX_EVENT_ARG_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_ARG_36 (LIKE VPX_EVENT_ARG_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_ARG_37 (LIKE VPX_EVENT_ARG_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_ARG_38 (LIKE VPX_EVENT_ARG_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_ARG_39 (LIKE VPX_EVENT_ARG_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_ARG_40 (LIKE VPX_EVENT_ARG_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_ARG_41 (LIKE VPX_EVENT_ARG_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_ARG_42 (LIKE VPX_EVENT_ARG_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_ARG_43 (LIKE VPX_EVENT_ARG_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_ARG_44 (LIKE VPX_EVENT_ARG_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_ARG_45 (LIKE VPX_EVENT_ARG_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_ARG_46 (LIKE VPX_EVENT_ARG_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_ARG_47 (LIKE VPX_EVENT_ARG_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_ARG_48 (LIKE VPX_EVENT_ARG_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_ARG_49 (LIKE VPX_EVENT_ARG_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_ARG_50 (LIKE VPX_EVENT_ARG_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_ARG_51 (LIKE VPX_EVENT_ARG_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_ARG_52 (LIKE VPX_EVENT_ARG_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_ARG_53 (LIKE VPX_EVENT_ARG_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_ARG_54 (LIKE VPX_EVENT_ARG_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_ARG_55 (LIKE VPX_EVENT_ARG_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_ARG_56 (LIKE VPX_EVENT_ARG_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_ARG_57 (LIKE VPX_EVENT_ARG_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_ARG_58 (LIKE VPX_EVENT_ARG_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_ARG_59 (LIKE VPX_EVENT_ARG_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_ARG_60 (LIKE VPX_EVENT_ARG_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_ARG_61 (LIKE VPX_EVENT_ARG_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_ARG_62 (LIKE VPX_EVENT_ARG_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_ARG_63 (LIKE VPX_EVENT_ARG_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_ARG_64 (LIKE VPX_EVENT_ARG_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_ARG_65 (LIKE VPX_EVENT_ARG_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_ARG_66 (LIKE VPX_EVENT_ARG_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_ARG_67 (LIKE VPX_EVENT_ARG_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_ARG_68 (LIKE VPX_EVENT_ARG_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_ARG_69 (LIKE VPX_EVENT_ARG_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_ARG_70 (LIKE VPX_EVENT_ARG_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_ARG_71 (LIKE VPX_EVENT_ARG_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_ARG_72 (LIKE VPX_EVENT_ARG_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_ARG_73 (LIKE VPX_EVENT_ARG_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_ARG_74 (LIKE VPX_EVENT_ARG_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_ARG_75 (LIKE VPX_EVENT_ARG_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_ARG_76 (LIKE VPX_EVENT_ARG_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_ARG_77 (LIKE VPX_EVENT_ARG_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_ARG_78 (LIKE VPX_EVENT_ARG_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_ARG_79 (LIKE VPX_EVENT_ARG_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_ARG_80 (LIKE VPX_EVENT_ARG_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_ARG_81 (LIKE VPX_EVENT_ARG_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_ARG_82 (LIKE VPX_EVENT_ARG_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_ARG_83 (LIKE VPX_EVENT_ARG_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_ARG_84 (LIKE VPX_EVENT_ARG_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_ARG_85 (LIKE VPX_EVENT_ARG_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_ARG_86 (LIKE VPX_EVENT_ARG_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_ARG_87 (LIKE VPX_EVENT_ARG_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_ARG_88 (LIKE VPX_EVENT_ARG_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_ARG_89 (LIKE VPX_EVENT_ARG_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_ARG_90 (LIKE VPX_EVENT_ARG_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_ARG_91 (LIKE VPX_EVENT_ARG_1 INCLUDING DEFAULTS);
 /
 CREATE TABLE VPX_EVENT_ARG_92 (LIKE VPX_EVENT_ARG_1 INCLUDING DEFAULTS);
 /
 
 
 DO $$
 DECLARE
     sql_stmt varchar;
 BEGIN
      FOR r IN 2..92
     LOOP
       sql_stmt = 'ALTER TABLE VPX_EVENT_'|| CAST (r as VARCHAR) ||' ADD CONSTRAINT PK_VPX_EVENT_'|| CAST (r as VARCHAR) ||' PRIMARY KEY (EVENT_ID)';
       EXECUTE sql_stmt;
       sql_stmt = 'ALTER TABLE VPX_EVENT_ARG_'|| CAST (r as VARCHAR) ||' ADD CONSTRAINT PK_VPX_EVENT_ARG_'|| CAST (r as VARCHAR) ||' primary key  (EVENT_ID, ARG_ID);';
       EXECUTE sql_stmt;
       sql_stmt = 'CREATE INDEX VPXI_EVENT_DVS_ID_'|| CAST (r as VARCHAR) ||' on VPX_EVENT_'|| CAST (r as VARCHAR) ||' (DVS_ID)  WHERE DVS_ID IS NOT NULL';
       EXECUTE sql_stmt;
       sql_stmt = 'CREATE INDEX VPXI_EVENT_CATEGORY_'|| CAST (r as VARCHAR) ||' on VPX_EVENT_'|| CAST (r as VARCHAR) ||' (CATEGORY)';
       EXECUTE sql_stmt;
       sql_stmt = 'CREATE INDEX VPXI_EVENT_CHAIN_ID_'|| CAST (r as VARCHAR) ||' on VPX_EVENT_'|| CAST (r as VARCHAR) ||' (CHAIN_ID)';
       EXECUTE sql_stmt;
       sql_stmt = 'CREATE INDEX VPXI_EVENT_COMPUTERES_ID_'|| CAST (r as VARCHAR) ||' on VPX_EVENT_'|| CAST (r as VARCHAR) ||' (COMPUTERESOURCE_ID) WHERE COMPUTERESOURCE_ID IS NOT NULL';
       EXECUTE sql_stmt;
       sql_stmt = 'CREATE INDEX VPXI_EVENT_CREATE_TIME_'|| CAST (r as VARCHAR) ||' on VPX_EVENT_'|| CAST (r as VARCHAR) ||' (CREATE_TIME)';
       EXECUTE sql_stmt;
       sql_stmt = 'CREATE INDEX VPXI_EVENT_DATACENTER_ID_'|| CAST (r as VARCHAR) ||' on VPX_EVENT_'|| CAST (r as VARCHAR) ||' (DATACENTER_ID) WHERE DATACENTER_ID IS NOT NULL';
       EXECUTE sql_stmt;
       sql_stmt = 'CREATE INDEX VPXI_EVENT_DATASTORE_ID_'|| CAST (r as VARCHAR) ||' on VPX_EVENT_'|| CAST (r as VARCHAR) ||' (DATASTORE_ID) WHERE DATASTORE_ID IS NOT NULL';
       EXECUTE sql_stmt;
       sql_stmt = 'CREATE INDEX VPXI_EVENT_EVENT_TYPE_'|| CAST (r as VARCHAR) ||' on VPX_EVENT_'|| CAST (r as VARCHAR) ||' (EVENT_TYPE)';
       EXECUTE sql_stmt;
       sql_stmt = 'CREATE INDEX VPXI_EVENT_EXTENDED_CLASS_'|| CAST (r as VARCHAR) ||' on VPX_EVENT_'|| CAST (r as VARCHAR) ||' ( EXTENDED_CLASS)';
       EXECUTE sql_stmt;
       sql_stmt = 'CREATE INDEX VPXI_EVENT_HOST_ID_'|| CAST (r as VARCHAR) ||' on VPX_EVENT_'|| CAST (r as VARCHAR) ||' ( HOST_ID)  WHERE HOST_ID IS NOT NULL';
       EXECUTE sql_stmt;
       sql_stmt = 'CREATE INDEX VPXI_EVENT_USERNAME_'|| CAST (r as VARCHAR) ||' on VPX_EVENT_'|| CAST (r as VARCHAR) ||' (USERNAME)  WHERE USERNAME IS NOT NULL';
       EXECUTE sql_stmt;
       sql_stmt = 'CREATE INDEX VPXI_EVENT_VM_ID_'|| CAST (r as VARCHAR) ||' on VPX_EVENT_'|| CAST (r as VARCHAR) ||' (VM_ID)  WHERE VM_ID IS NOT NULL';
       EXECUTE sql_stmt;
       sql_stmt = 'CREATE INDEX VPXI_CHANGE_TAG_'|| CAST (r as VARCHAR) ||' on VPX_EVENT_'|| CAST (r as VARCHAR) ||' (CHANGE_TAG_ID) WHERE CHANGE_TAG_ID IS NOT NULL';
       EXECUTE sql_stmt;
       sql_stmt = 'CREATE INDEX VPXI_EVENT_NETWORK_ID_'|| CAST (r as VARCHAR) ||' on VPX_EVENT_'|| CAST (r as VARCHAR) ||' (NETWORK_ID) WHERE NETWORK_ID IS NOT NULL';
       EXECUTE sql_stmt;
       sql_stmt = 'CREATE INDEX VPX_EVENT_F1_'|| CAST (r as VARCHAR) ||' ON VPX_EVENT_'|| CAST (r as VARCHAR) ||'(COMPUTERESOURCE_TYPE) WHERE COMPUTERESOURCE_TYPE IS NOT NULL';
       EXECUTE sql_stmt;
       sql_stmt = 'CREATE INDEX VPX_EVENT_ARG_F1_'|| CAST (r as VARCHAR) ||' ON VPX_EVENT_ARG_'|| CAST (r as VARCHAR) ||'(OBJ_TYPE)';
       EXECUTE sql_stmt;
       sql_stmt = 'CREATE INDEX VPX_EVENT_ARG_F2_'|| CAST (r as VARCHAR) ||' ON VPX_EVENT_ARG_'|| CAST (r as VARCHAR) ||' (ALARM_ID) WHERE ALARM_ID IS NOT NULL';
       EXECUTE sql_stmt;
       sql_stmt = 'CREATE INDEX VPX_EVENT_ARG_F3_'|| CAST (r as VARCHAR) ||' ON VPX_EVENT_ARG_'|| CAST (r as VARCHAR) ||' (SCHEDULEDTASK_ID) WHERE SCHEDULEDTASK_ID IS NOT NULL';
       EXECUTE sql_stmt;
     END LOOP;
 END$$;
 /
 
 
 
 
 CREATE TABLE VPX_EVENT_PARTITION_LOOKUP (
     START_DATE DATE NOT NULL,
     PARTITION_INDEX INTEGER NOT NULL,
     constraint PK_VPX_EVENT_PARTITION_LOOKUP primary key (START_DATE)
     );
 /
 
 
 
 
 DO
 $$
 
 DECLARE min_create_date DATE;
 DECLARE max_create_date DATE;
 BEGIN
 SELECT min(CREATE_TIME), max(CREATE_TIME)
 INTO min_create_date, max_create_date
 FROM VPX_EVENT_1
 WHERE CREATE_TIME IS NOT NULL;
 
 INSERT INTO VPX_EVENT_PARTITION_LOOKUP (START_DATE, PARTITION_INDEX)
 SELECT i::date, 1 FROM generate_series(min_create_date,
   max_create_date, '1 day'::interval) i;
 
 END$$;
 /
 
 ALTER TABLE VPX_ENTITY_LAST_EVENT DROP CONSTRAINT  FK_VPX_LAST_EVENT_EVENT;
 /
 
 
 
 
 RESET default_tablespace;
 /
 
 
 
 UPDATE VPX_DBM_COUNTER_METADATA
 SET  OBJECT_NAME = 'PostgreSQL:Buffer Cache'
 WHERE COUNTER_ID = 1;
 /
 UPDATE VPX_DBM_COUNTER_METADATA
 SET  OBJECT_NAME = 'PostgreSQL:General Statistics',
 DESCRIPTION = 'The number of users currently connected to the PostgreSQL.'
 WHERE COUNTER_ID = 2;
 /
 UPDATE VPX_DBM_COUNTER_METADATA
 SET  OBJECT_NAME = 'PostgreSQL:WAL'
 WHERE COUNTER_ID = 3;
 /
 UPDATE VPX_DBM_COUNTER_METADATA
 SET  OBJECT_NAME = 'PostgreSQL:Buffer space allocation'
 WHERE COUNTER_ID = 4;
 /
 
 
 
 
 ALTER TABLE VPX_VM_CONFIG_INFO ADD MESSAGE_BUS_TUNNEL_ENABLED INTEGER;
 /
 ALTER TABLE VPX_VM_CONFIG_INFO ADD CONSTRAINT FK_V_VM_CONFIG_INFO_REF_VPX_VM
    FOREIGN KEY(ID) REFERENCES VPX_VM (ID)
       ON DELETE CASCADE;
 /
 ALTER TABLE VPX_VM_CONFIG_INFO ADD FORK_PARENT_GROUP_ID VARCHAR(255);
 /
 ALTER TABLE VPX_VM_CONFIG_INFO ADD GUEST_INTEGRITY_INFO_ENABLED NUMERIC(1);
 /
 ALTER TABLE VPX_VM_CONFIG_INFO ADD BOOT_OPTION_EFI_SB_ENABLED NUMERIC(1);
 /
 ALTER TABLE VPX_VM_CONFIG_INFO ADD MIGRATE_ENCRYPTION VARCHAR(15);
 /
 
 
 
 
 ALTER TABLE VPX_SN_CONFIG_INFO ADD FORK_PARENT_GROUP_ID VARCHAR(255);
 /
 ALTER TABLE VPX_SN_CONFIG_INFO ADD GUEST_INTEGRITY_INFO_ENABLED NUMERIC(1);
 /
 ALTER TABLE VPX_SN_CONFIG_INFO ADD BOOT_OPTION_EFI_SB_ENABLED NUMERIC(1);
 /
 
 
 
 
 DROP INDEX IF EXISTS VPX_VDEVICE_DEVICE_BACKING_F1;
 /
 DROP INDEX IF EXISTS VPX_VDEVICE_PLUGIN_BACKING_F1;
 /
 DROP INDEX IF EXISTS VPX_VDEVICE_DEVBACKING_X_F1;
 /
 DROP INDEX IF EXISTS VPX_VDEVICE_PIPE_BACKING_F1;
 /
 DROP INDEX IF EXISTS VPX_DISTR_VPORT_BACKING_F1;
 /
 DROP INDEX IF EXISTS VPX_OPAQUE_NET_BACKING_F1;
 /
 DROP INDEX IF EXISTS VPX_VIRTUAL_DISK_F1;
 /
 DROP INDEX IF EXISTS VPX_VSRIOV_ETHERNET_CARD_F1;
 /
 DROP INDEX IF EXISTS VPX_VIRTUAL_SERIAL_PORT_F1;
 /
 DROP INDEX IF EXISTS VPX_VIRTUAL_USB_F1;
 /
 DROP INDEX IF EXISTS VPX_VIRTUAL_VMCIDEVICE_F1;
 /
 DROP INDEX IF EXISTS VPX_VIRTUAL_VIDEO_CARD_F1;
 /
 DROP INDEX IF EXISTS VPX_VIRTUAL_SCSICONTROLLER_F1;
 /
 DROP INDEX IF EXISTS VPX_VIRTUAL_SATACONTROLLER_F1;
 /
 DROP INDEX IF EXISTS VPX_VIRTUAL_USBCONTROLLER_F1;
 /
 DROP INDEX IF EXISTS VPX_SN_VIRTUAL_DEVICE_M1;
 /
 DROP INDEX IF EXISTS VPX_SN_VDEVICE_BACKING_REL_U1;
 /
 DROP INDEX IF EXISTS IX_VPX_SNVDBACKING_REL_SN_ID;
 /
 
 
 
 
 
 
 ALTER TABLE VPX_VDEVICE_BACKING_REL DROP CONSTRAINT IF EXISTS FK_VPX_VDEVICE_BACKING_REL;
 /
 ALTER TABLE VPX_VIRTUAL_DISK DROP CONSTRAINT IF EXISTS FK_VPX_VIRTUAL_DISK;
 /
 ALTER TABLE VPX_VIRTUAL_ETHERNET_CARD DROP CONSTRAINT IF EXISTS FK_VPX_VIRTUAL_ETHERNET_CARD;
 /
 ALTER TABLE VPX_VIRTUAL_SERIAL_PORT DROP CONSTRAINT IF EXISTS FK_V_VIR_SER_PO_REF_V_VIR_DEV;
 /
 ALTER TABLE VPX_VIRTUAL_USB DROP CONSTRAINT IF EXISTS  FK_V_VIR_REF_V_VIRTUAL_DEVICE;
 /
 ALTER TABLE VPX_VIRTUAL_VMCIDEVICE DROP CONSTRAINT IF EXISTS FK_V_VIR_VMCID_REF_V_VIR_DEV;
 /
 ALTER TABLE VPX_VIRTUAL_VIDEO_CARD DROP CONSTRAINT IF EXISTS FK_V_VIR_VI_CA_REF_V_VIR_DEV;
 /
 ALTER TABLE VPX_VIRTUAL_CONTROLLER DROP CONSTRAINT IF EXISTS FK_V_VIR_CONTR_REF_V_VIR_DEV;
 /
 ALTER TABLE VPX_SN_VDEVICE_BACKING_REL DROP CONSTRAINT IF EXISTS FK_SN_VPX_VDEVICE_BACKING_REL;
 /
 ALTER TABLE VPX_SN_VIRTUAL_DISK DROP CONSTRAINT IF EXISTS FK_VPX_SN_VIRTUAL_DISK;
 /
 ALTER TABLE VPX_SN_VIRTUAL_ETHERNET_CARD DROP CONSTRAINT IF EXISTS FK_VPX_SN_VETHERNET_CARD;
 /
 ALTER TABLE VPX_SN_VIRTUAL_SERIAL_PORT DROP CONSTRAINT IF EXISTS FK_SN_VIR_SER_PO_REF_VDEV;
 /
 ALTER TABLE VPX_SN_VIRTUAL_USB DROP CONSTRAINT IF EXISTS FK_SN_VUSB_REF_VIRTUAL_DEVICE;
 /
 ALTER TABLE VPX_SN_VIRTUAL_VMCIDEVICE DROP CONSTRAINT IF EXISTS FK_SN_VIR_VMCID_REF_VDEV;
 /
 ALTER TABLE VPX_SN_VIRTUAL_VIDEO_CARD DROP CONSTRAINT IF EXISTS FK_SN_VIR_VICA_REF_VDEV;
 /
 ALTER TABLE VPX_SN_VIRTUAL_CONTROLLER DROP CONSTRAINT IF EXISTS FK_SN_VIR_CONTR_REF_VDEV;
 /
 
 
 
 
 
 ALTER TABLE VPX_VIRTUAL_DEVICE DROP CONSTRAINT IF EXISTS PK_VPX_VIRTUAL_DEVICE;
 /
 ALTER TABLE VPX_SN_VIRTUAL_DEVICE DROP CONSTRAINT IF EXISTS PK_VPX_SN_VIRTUAL_DEVICE;
 /
 
 
 
 
 
 ALTER TABLE VPX_VIRTUAL_DEVICE ADD CONSTRAINT PK_VPX_VIRTUAL_DEVICE  primary key (ID, DEVICE_KEY);
 /
 ALTER TABLE VPX_SN_VIRTUAL_DEVICE ADD CONSTRAINT PK_VPX_SN_VIRTUAL_DEVICE primary key (ID, DEVICE_KEY, VDEVICE_ID);
 /
 
 
 
 
 ALTER TABLE VPX_VDEVICE_BACKING_REL ADD constraint FK_VPX_VDEVICE_BACKING_REL foreign key(VM_ID, UPDATE_KEY)
             references VPX_VIRTUAL_DEVICE(ID, DEVICE_KEY) ON DELETE cascade;
 /
 
 ALTER TABLE VPX_VIRTUAL_DISK ADD constraint FK_VPX_VIRTUAL_DISK foreign key (VM_ID, UPDATE_KEY)
             references VPX_VIRTUAL_DEVICE (ID, DEVICE_KEY) on delete cascade;
 /
 
 ALTER TABLE VPX_VIRTUAL_ETHERNET_CARD ADD constraint FK_VPX_VIRTUAL_ETHERNET_CARD foreign key(VM_ID, UPDATE_KEY)
             references VPX_VIRTUAL_DEVICE (ID, DEVICE_KEY) on delete cascade;
 /
 
 ALTER TABLE VPX_VIRTUAL_SERIAL_PORT ADD constraint FK_V_VIR_SER_PO_REF_V_VIR_DEV foreign key(VM_ID,UPDATE_KEY)
             references VPX_VIRTUAL_DEVICE (ID, DEVICE_KEY) on delete cascade;
 /
 
 ALTER TABLE VPX_VIRTUAL_USB ADD constraint FK_V_VIR_REF_V_VIRTUAL_DEVICE foreign key(VM_ID, UPDATE_KEY)
             references VPX_VIRTUAL_DEVICE (ID, DEVICE_KEY) on delete cascade;
 /
 
 ALTER TABLE VPX_VIRTUAL_VMCIDEVICE ADD constraint FK_V_VIR_VMCID_REF_V_VIR_DEV foreign key(VM_ID, UPDATE_KEY)
             references VPX_VIRTUAL_DEVICE (ID, DEVICE_KEY) on delete cascade;
 /
 
 ALTER TABLE VPX_VIRTUAL_VIDEO_CARD ADD constraint FK_V_VIR_VI_CA_REF_V_VIR_DEV foreign key(VM_ID, UPDATE_KEY)
             references VPX_VIRTUAL_DEVICE (ID, DEVICE_KEY) on delete cascade;
 /
 
 ALTER TABLE VPX_VIRTUAL_CONTROLLER ADD constraint FK_V_VIR_CONTR_REF_V_VIR_DEV foreign key(VM_ID, UPDATE_KEY)
             references VPX_VIRTUAL_DEVICE (ID,DEVICE_KEY) on delete cascade;
 /
 
 ALTER TABLE VPX_SN_VDEVICE_BACKING_REL ADD constraint FK_SN_VPX_VDEVICE_BACKING_REL foreign key(SN_ID, UPDATE_KEY,VDEVICE_ID)
             references VPX_SN_VIRTUAL_DEVICE(ID, DEVICE_KEY, VDEVICE_ID) ON DELETE cascade;
 /
 
 ALTER TABLE VPX_SN_VIRTUAL_DISK ADD constraint FK_VPX_SN_VIRTUAL_DISK foreign key(SN_ID,UPDATE_KEY,VDEVICE_ID)
 	    references VPX_SN_VIRTUAL_DEVICE (ID, DEVICE_KEY, VDEVICE_ID) on delete cascade;
 /
 
 ALTER TABLE VPX_SN_VIRTUAL_ETHERNET_CARD ADD constraint FK_VPX_SN_VETHERNET_CARD foreign key(SN_ID, UPDATE_KEY, VDEVICE_ID)
 	   references VPX_SN_VIRTUAL_DEVICE (ID, DEVICE_KEY, VDEVICE_ID) on delete cascade;
 /
 
 ALTER TABLE VPX_SN_VIRTUAL_SERIAL_PORT ADD constraint FK_SN_VIR_SER_PO_REF_VDEV foreign key(SN_ID, UPDATE_KEY, VDEVICE_ID)
 	   references VPX_SN_VIRTUAL_DEVICE (ID, DEVICE_KEY, VDEVICE_ID) on delete cascade;
 /
 
 ALTER TABLE VPX_SN_VIRTUAL_USB ADD constraint FK_SN_VUSB_REF_VIRTUAL_DEVICE foreign key(SN_ID, UPDATE_KEY, VDEVICE_ID)
 	        references VPX_SN_VIRTUAL_DEVICE (ID, DEVICE_KEY, VDEVICE_ID) on delete cascade;
 /
 
 ALTER TABLE VPX_SN_VIRTUAL_VMCIDEVICE ADD constraint FK_SN_VIR_VMCID_REF_VDEV foreign key(SN_ID, UPDATE_KEY, VDEVICE_ID)
 	   references VPX_SN_VIRTUAL_DEVICE (ID, DEVICE_KEY, VDEVICE_ID) on delete cascade;
 /
 
 ALTER TABLE VPX_SN_VIRTUAL_VIDEO_CARD ADD constraint FK_SN_VIR_VICA_REF_VDEV foreign key(SN_ID, UPDATE_KEY, VDEVICE_ID)
 	    references VPX_SN_VIRTUAL_DEVICE (ID, DEVICE_KEY, VDEVICE_ID) on delete cascade;
 /
 
 ALTER TABLE VPX_SN_VIRTUAL_CONTROLLER ADD constraint FK_SN_VIR_CONTR_REF_VDEV foreign key(SN_ID, UPDATE_KEY, VDEVICE_ID)
 	    references VPX_SN_VIRTUAL_DEVICE (ID, DEVICE_KEY, VDEVICE_ID) on delete cascade;
 /
 
 
 
 
 CREATE INDEX VPX_VDEVICE_DEVICE_BACKING_F1 ON VPX_VDEVICE_DEVICE_BACKING(VM_ID,UPDATE_KEY);
 /
 CREATE INDEX VPX_VDEVICE_PLUGIN_BACKING_F1 ON VPX_VDEVICE_PLUGIN_BACKING(VM_ID,UPDATE_KEY);
 /
 CREATE INDEX VPX_VDEVICE_DEVBACKING_X_F1 ON VPX_VDEVICE_DEVICE_BACKING_X(VM_ID,UPDATE_KEY);
 /
 CREATE INDEX VPX_VDEVICE_PIPE_BACKING_F1 ON VPX_VDEVICE_PIPE_BACKING(VM_ID,UPDATE_KEY);
 /
 CREATE INDEX VPX_DISTR_VPORT_BACKING_F1 ON VPX_DISTR_VPORT_BACKING(VM_ID,UPDATE_KEY);
 /
 CREATE INDEX VPX_OPAQUE_NET_BACKING_F1 ON VPX_OPAQUE_NET_BACKING(VM_ID,UPDATE_KEY);
 /
 CREATE INDEX VPX_VIRTUAL_DISK_F1 ON VPX_VIRTUAL_DISK(VM_ID,UPDATE_KEY);
 /
 CREATE INDEX VPX_VSRIOV_ETHERNET_CARD_F1 ON VPX_VSRIOV_ETHERNET_CARD(VM_ID,UPDATE_KEY);
 /
 CREATE INDEX VPX_VIRTUAL_SERIAL_PORT_F1 ON VPX_VIRTUAL_SERIAL_PORT(VM_ID,UPDATE_KEY);
 /
 CREATE INDEX VPX_VIRTUAL_USB_F1 ON VPX_VIRTUAL_USB(VM_ID,UPDATE_KEY);
 /
 CREATE INDEX VPX_VIRTUAL_VMCIDEVICE_F1 ON VPX_VIRTUAL_VMCIDEVICE(VM_ID,UPDATE_KEY);
 /
 CREATE INDEX VPX_VIRTUAL_VIDEO_CARD_F1 ON VPX_VIRTUAL_VIDEO_CARD(VM_ID,UPDATE_KEY);
 /
 CREATE INDEX VPX_VIRTUAL_SCSICONTROLLER_F1 ON VPX_VIRTUAL_SCSICONTROLLER(VM_ID,UPDATE_KEY);
 /
 CREATE INDEX VPX_VIRTUAL_SATACONTROLLER_F1 ON VPX_VIRTUAL_SATACONTROLLER(VM_ID,UPDATE_KEY);
 /
 CREATE INDEX VPX_VIRTUAL_USBCONTROLLER_F1 ON VPX_VIRTUAL_USBCONTROLLER(VM_ID,UPDATE_KEY);
 /
 CREATE INDEX VPX_SN_VDEVICE_BACKING_REL_U1 ON VPX_SN_VDEVICE_BACKING_REL(SN_ID, UPDATE_KEY,VDEVICE_ID);
 /
 
 
 
 
 ALTER TABLE VPX_VM_STATIC_OVERHEAD_MAP ADD CONSTRAINT FK_VPX_VM_STATIC_OVHD_MAP_REF
    FOREIGN KEY(VM_ID) REFERENCES VPX_VM (ID)
       ON DELETE CASCADE;
 /
 
 
 
 
 ALTER TABLE VPX_VM_FILE_LAYOUT_EX ADD CONSTRAINT FK_FILE_LAYOUT_EX_REF_VM
    FOREIGN KEY(VM_ID) REFERENCES VPX_VM (ID)
       ON DELETE CASCADE;
 /
 
 
 
 
 ALTER TABLE VPX_VM_DS_SPACE ADD CONSTRAINT FK_VPX_VM_DS_SPACE1
    FOREIGN KEY(VM_ID) REFERENCES VPX_VM (ID)
       ON DELETE CASCADE;
 /
 
 
 
 
 ALTER TABLE VPX_VM_FLE_DISK_LAYOUT ADD CONSTRAINT FK_FLE_DISK_LAYOUT_REF_VM
    FOREIGN KEY(VM_ID) REFERENCES VPX_VM (ID)
       ON DELETE CASCADE;
 /
 
 
 
 
 ALTER TABLE VPX_COMPUTE_RESOURCE_DAS_VM ADD CONSTRAINT FK_VPX_COMP_DAS_VM_REF_VPX_VM
    FOREIGN KEY(VM_ID) REFERENCES VPX_VM (ID)
       ON DELETE CASCADE;
 /
 
 
 
 
 ALTER TABLE VPX_VM_FLE_FILE_INFO ADD CONSTRAINT FK_FLE_FILE_INFO_REF_VM
    FOREIGN KEY(VM_ID) REFERENCES VPX_VM (ID)
       ON DELETE CASCADE;
 /
 
 
 
 
 ALTER TABLE VPX_VM_FLE_SNAPSHOT_LAYOUT ADD CONSTRAINT FK_FLE_SNAPSHOT_L_REF_VM
    FOREIGN KEY(VM_ID) REFERENCES VPX_VM (ID)
       ON DELETE CASCADE;
 /
 
 
 
 
 ALTER TABLE VPX_COMPUTE_RESOURCE_DRS_VM ADD CONSTRAINT FK_VPX_COMP_DRS_VM_REF_VPX_VM
    FOREIGN KEY(VM_ID) REFERENCES VPX_VM (ID)
       ON DELETE CASCADE;
 /
 
 
 
 
 ALTER TABLE VPX_GUEST_DISK ADD CONSTRAINT FK_VPX_VD_REF_VPX_VM
    FOREIGN KEY(VM_ID) REFERENCES VPX_VM (ID)
       ON DELETE CASCADE;
 /
 
 
 
 
 ALTER TABLE VPX_VM ADD CONSTRAINT FK_VPX_VM_REF_VPX_ENTI
    FOREIGN KEY (ID) REFERENCES VPX_ENTITY (ID)
       ON DELETE CASCADE;
 /
 
 
 
 
 DROP TABLE IF EXISTS VPX_VM_CHILD_TABLES CASCADE;
 /
 
 CREATE SEQUENCE VPX_CALLBACK_SERVICE_SEQ                 INCREMENT BY 1000;
 /
 
 CREATE SEQUENCE VPX_INFRA_UPD_HA_PROVIDER_SEQ INCREMENT BY 50;
 /
 CREATE SEQUENCE VPX_INFRA_UPD_HA_HU_INFO_SEQ  INCREMENT BY 50;
 /
 CREATE SEQUENCE VPX_INFRA_UPD_HA_FILTER_SEQ   INCREMENT BY 50;
 /
 
 
 
 
 CREATE TABLE VPX_CALLBACK_SERVICE (
    ID    INT NOT NULL,
    WSDL_NAME    VARCHAR(50),
    URL_STRING    VARCHAR(255),
    constraint PK_VPX_CALLBACK_SERVICE primary key (ID)
 );
 /
 
 
 
 
 create unique index VPXI_CBK_SERV_UNIQUE_KEY on VPX_CALLBACK_SERVICE (
    WSDL_NAME,
    URL_STRING
 );
 /
 
 
 
 
 CREATE TABLE VPX_CALLBACK_WHITELIST (
    SERV_ID    INT NOT NULL,
    MOID       VARCHAR(127),
    constraint PK_VPX_CBK_WL primary key (SERV_ID, MOID),
    constraint FK_WL_REF_VPX_CBK_SERV foreign key(SERV_ID)
    references VPX_CALLBACK_SERVICE (ID) on delete cascade
 );
 /
 
 
 
 
 ALTER TABLE VPX_VIRTUAL_DEVICE ADD CONSTRAINT FK_V_VIR_DEV_REF_VM
    FOREIGN KEY(ID) REFERENCES VPX_VM (ID)
       ON DELETE CASCADE;
 /
 
 
 
 
 ALTER TABLE VPX_HOST SET (autovacuum_vacuum_scale_factor = 0.05);
 ALTER TABLE VPX_HOST SET (toast.autovacuum_vacuum_scale_factor = 0.05);
 ALTER TABLE VPX_HOST SET (autovacuum_analyze_scale_factor = 0.05);
 ALTER TABLE VPX_HOST SET (autovacuum_vacuum_threshold = 25);
 ALTER TABLE VPX_HOST SET (toast.autovacuum_vacuum_threshold = 25);
 ALTER TABLE VPX_HOST SET (autovacuum_analyze_threshold = 25);
 ALTER TABLE VPX_HOST SET (autovacuum_vacuum_cost_delay = 10);
 ALTER TABLE VPX_HOST SET (toast.autovacuum_vacuum_cost_delay = 10);
 ALTER TABLE VPX_HOST SET (autovacuum_vacuum_cost_limit = 1000);
 ALTER TABLE VPX_HOST SET (toast.autovacuum_vacuum_cost_limit = 1000);
 /
 
 
 
 
 ALTER TABLE VPX_VM SET (autovacuum_vacuum_scale_factor = 0.05);
 ALTER TABLE VPX_VM SET (toast.autovacuum_vacuum_scale_factor = 0.05);
 ALTER TABLE VPX_VM SET (autovacuum_analyze_scale_factor = 0.05);
 ALTER TABLE VPX_VM SET (autovacuum_vacuum_threshold = 25);
 ALTER TABLE VPX_VM SET (toast.autovacuum_vacuum_threshold = 25);
 ALTER TABLE VPX_VM SET (autovacuum_analyze_threshold = 25);
 ALTER TABLE VPX_VM SET (autovacuum_vacuum_cost_delay = 10);
 ALTER TABLE VPX_VM SET (toast.autovacuum_vacuum_cost_delay = 10);
 ALTER TABLE VPX_VM SET (autovacuum_vacuum_cost_limit = 1000);
 ALTER TABLE VPX_VM SET (toast.autovacuum_vacuum_cost_limit = 1000);
 /
 
 
 
 
 
 ALTER TABLE VPX_VM_CONFIG_INFO SET (autovacuum_vacuum_scale_factor = 0.05);
 ALTER TABLE VPX_VM_CONFIG_INFO SET (toast.autovacuum_vacuum_scale_factor = 0.05);
 ALTER TABLE VPX_VM_CONFIG_INFO SET (autovacuum_analyze_scale_factor = 0.05);
 ALTER TABLE VPX_VM_CONFIG_INFO SET (autovacuum_vacuum_threshold = 25);
 ALTER TABLE VPX_VM_CONFIG_INFO SET (toast.autovacuum_vacuum_threshold = 25);
 ALTER TABLE VPX_VM_CONFIG_INFO SET (autovacuum_analyze_threshold = 25);
 ALTER TABLE VPX_VM_CONFIG_INFO SET (autovacuum_vacuum_cost_delay = 10);
 ALTER TABLE VPX_VM_CONFIG_INFO SET (toast.autovacuum_vacuum_cost_delay = 10);
 ALTER TABLE VPX_VM_CONFIG_INFO SET (autovacuum_vacuum_cost_limit = 1000);
 ALTER TABLE VPX_VM_CONFIG_INFO SET (toast.autovacuum_vacuum_cost_limit = 1000);
 /
 
 
 
 
 
 
 CREATE TABLE VPX_CRYPTO_KMIP_CLUSTER(
    CLUSTER_ID     VARCHAR(255) NOT NULL,
    USE_AS_DEFAULT INTEGER NOT NULL,
    CONSTRAINT PK_VPX_CRYPTO_KMIP_CLUSTER PRIMARY KEY (CLUSTER_ID)
 );
 /
 
 
 
 
 
 CREATE TABLE VPX_CRYPTO_SERVER(
    CLUSTER_ID     VARCHAR(255) NOT NULL,
    NAME           VARCHAR(255) NOT NULL,
    ADDRESS        VARCHAR(255) NOT NULL,
    PORT           INTEGER,
    PROXY_ADDRESS  VARCHAR(255),
    PROXY_PORT     INTEGER,
    RECONNECT      INTEGER,
    PROTOCOL       VARCHAR(127),
    NBIO           INTEGER,
    TIMEOUT        INTEGER,
    USER_NAME      VARCHAR(255),
    CONSTRAINT PK_VPX_CRYPTO_SERVER PRIMARY KEY (CLUSTER_ID, NAME),
    CONSTRAINT FK_VPX_CRYPTO_KMIP_CLUSTER FOREIGN KEY (CLUSTER_ID)
          REFERENCES VPX_CRYPTO_KMIP_CLUSTER(CLUSTER_ID)
 );
 /
 
 INSERT INTO VPX_TYPE_MAP VALUES ('keyId', 87, null);
 /
 
 
 
 
 
 
 
 
 
 CREATE TABLE VPX_HOST_CRYPTO_KEYS (
    HOST_ID                    INTEGER           NOT NULL,
    CRYPTO_KEY_ID              VARCHAR(255)      NOT NULL,
    CRYPTO_KEY_PROVIDER_ID     VARCHAR(255)      NOT NULL,
    USAGE_COUNT                INTEGER,
    CONSTRAINT PK_VPX_HOST_CRYPTO_KEYS PRIMARY KEY (HOST_ID, CRYPTO_KEY_ID, CRYPTO_KEY_PROVIDER_ID),
    CONSTRAINT PK_VPX_HOST_CRYPTO_KEYS_REF FOREIGN KEY (HOST_ID)
       REFERENCES VPX_HOST (ID)
          ON DELETE CASCADE
 );
 /
 
 
 
 
 CREATE TABLE VPX_VM_VIRTUAL_DEVICE (
         ID                              INT NOT NULL,
         CONN_AL_GU_CONTROL_FLAG         NUMERIC(1),
         CONN_CONNECTED_FLAG             NUMERIC(1),
         CONN_START_CONNECTED_FLAG       NUMERIC(1),
         CONN_STATUS                     VARCHAR(255),
         DEVICE_INFO_SUMMARY             VARCHAR(255),
         DEVICE_INFO_LABEL               VARCHAR(255),
         DEVICE_CONTROLLER_KEY           INT,
         DEVICE_UNIT_NUMBER              INT,
         DEVICE_KEY                      INT NOT NULL,
         DEVICE_TYPE                     VARCHAR(255),
         DEVICE_TEXT                     TEXT,
         constraint PK_VPX_VM_VIRTUAL_DEVICE primary key (ID, DEVICE_KEY),
         constraint FK_VPX_VM_VIRTUAL_DEVICE foreign key(ID)
             references VPX_VM(ID) on delete cascade
 );
 /
 
 
 
 
 
 ALTER TABLE VPX_VM_VIRTUAL_DEVICE SET (autovacuum_vacuum_scale_factor = 0.05);
 ALTER TABLE VPX_VM_VIRTUAL_DEVICE SET (toast.autovacuum_vacuum_scale_factor = 0.05);
 ALTER TABLE VPX_VM_VIRTUAL_DEVICE SET (autovacuum_analyze_scale_factor = 0.05);
 ALTER TABLE VPX_VM_VIRTUAL_DEVICE SET (autovacuum_vacuum_threshold = 25);
 ALTER TABLE VPX_VM_VIRTUAL_DEVICE SET (toast.autovacuum_vacuum_threshold = 25);
 ALTER TABLE VPX_VM_VIRTUAL_DEVICE SET (autovacuum_analyze_threshold = 25);
 ALTER TABLE VPX_VM_VIRTUAL_DEVICE SET (autovacuum_vacuum_cost_delay = 10);
 ALTER TABLE VPX_VM_VIRTUAL_DEVICE SET (toast.autovacuum_vacuum_cost_delay = 10);
 ALTER TABLE VPX_VM_VIRTUAL_DEVICE SET (autovacuum_vacuum_cost_limit = 1000);
 ALTER TABLE VPX_VM_VIRTUAL_DEVICE SET (toast.autovacuum_vacuum_cost_limit = 1000);
 /
 
 
 
 
 CREATE TABLE VPX_VM_SN_VIRTUAL_DEVICE (
         ID                              INT NOT NULL,
         CONN_AL_GU_CONTROL_FLAG         NUMERIC(1),
         CONN_CONNECTED_FLAG             NUMERIC(1),
         CONN_START_CONNECTED_FLAG       NUMERIC(1),
         CONN_STATUS                     VARCHAR(255),
         DEVICE_INFO_SUMMARY             VARCHAR(255),
         DEVICE_INFO_LABEL               VARCHAR(255),
         DEVICE_CONTROLLER_KEY           INT,
         DEVICE_UNIT_NUMBER              INT,
         DEVICE_KEY                      INT NOT NULL,
         DEVICE_TYPE                     VARCHAR(255),
         DEVICE_TEXT                     TEXT,
         constraint PK_VPX_VM_SN_VIRTUAL_DEVICE primary key (ID, DEVICE_KEY),
         constraint FK_VPX_VM_SN_VIRTUAL_DEVICE foreign key(ID)
             references VPX_SNAPSHOT (ID) on delete cascade
 );
 /
 
 
 
 
 create table VPX_COMPUTE_RESOURCE_ORC_VM  (
    COMP_RES_ID          INTEGER                         not null,
    VM_ID                INTEGER                         not null,
    ORC_READY_CONDITION_VM   INTEGER,
    ORC_POST_READY_DELAY_VM  INTEGER,
    constraint PK_VPX_COMP_ORC_VM primary key (COMP_RES_ID, VM_ID),
    constraint FK_VPX_COMP_ORC_VM_REF_VPX_COM foreign key (COMP_RES_ID)
          references VPX_COMPUTE_RESOURCE (ID),
    constraint FK_VPX_COMP_ORC_VM_REF_VPX_VM foreign key (VM_ID)
          references VPX_VM (ID) on delete cascade
 );
 /
 
 CREATE INDEX VPX_COMPUTE_RESOURCE_ORC_VM_F1 ON VPX_COMPUTE_RESOURCE_ORC_VM(VM_ID);
 /
 CREATE INDEX VPX_COMPUTE_RESOURCE_ORC_VM_F2 ON VPX_COMPUTE_RESOURCE_ORC_VM(COMP_RES_ID);
 /
 
 
 
 
 ALTER TABLE VPX_COMPUTE_RESOURCE_DAS_VM ADD RESTART_PRIORITY_TIMEOUT_VM INTEGER;
 /
 
 
 
 
 ALTER TABLE VPX_COMPUTE_RESOURCE ADD DAS_RESTART_PRIORITY_TIMEOUT INTEGER;
 /
 ALTER TABLE VPX_COMPUTE_RESOURCE ADD ORC_READY_CONDITION INTEGER;
 /
 ALTER TABLE VPX_COMPUTE_RESOURCE ADD ORC_POST_READY_DELAY INTEGER;
 /
 
 
 
 
 
 
 
 
 UPDATE VPX_EXT_MANAGEDBY_INFO
 SET DESCRIPTION = ''
 WHERE DESCRIPTION IS NULL;
 /
 
 UPDATE VPX_EXT_MANAGEDBY_INFO
 SET SMALL_ICON_URL = ''
 WHERE SMALL_ICON_URL IS NULL;
 /
 
 UPDATE VPX_EXT_MANAGEDBY_INFO
 SET ICON_URL = ''
 WHERE ICON_URL IS NULL;
 /
 
 DO
 $$
 BEGIN
 IF NOT EXISTS(
    SELECT 1 FROM information_schema.columns
       WHERE IS_NULLABLE = 'NO'
       AND UPPER(TABLE_NAME) = 'VPX_EXT_MANAGEDBY_INFO'
       AND UPPER(COLUMN_NAME) = 'DESCRIPTION')
 THEN
 ALTER TABLE VPX_EXT_MANAGEDBY_INFO ALTER COLUMN DESCRIPTION SET NOT NULL;
 END IF;
 END$$;
 /
 
 DO
 $$
 BEGIN
 IF NOT EXISTS(
    SELECT IS_NULLABLE FROM information_schema.columns
       WHERE  IS_NULLABLE = 'NO'
       AND UPPER(TABLE_NAME) = 'VPX_EXT_MANAGEDBY_INFO'
       AND UPPER(COLUMN_NAME) = 'SMALL_ICON_URL')
 THEN
 ALTER TABLE VPX_EXT_MANAGEDBY_INFO ALTER COLUMN SMALL_ICON_URL SET NOT NULL;
 END IF;
 END$$;
 /
 
 DO
 $$
 BEGIN
 IF NOT EXISTS(
    SELECT 1 FROM information_schema.columns
       WHERE IS_NULLABLE = 'NO'
       AND UPPER(TABLE_NAME) = 'VPX_EXT_MANAGEDBY_INFO'
       AND UPPER(COLUMN_NAME) = 'ICON_URL')
 THEN
 ALTER TABLE VPX_EXT_MANAGEDBY_INFO ALTER COLUMN ICON_URL SET NOT NULL;
 END IF;
 END$$;
 /
 
 
 
 
 UPDATE VPX_DVHOST_OUT_OF_SYNC
 SET PROPERTY_NAME = ''
 WHERE PROPERTY_NAME IS NULL;
 /
 
 DO
 $$
 BEGIN
 IF NOT EXISTS(
    SELECT 1 FROM information_schema.columns
       WHERE IS_NULLABLE = 'NO'
       AND UPPER(TABLE_NAME) = 'VPX_DVHOST_OUT_OF_SYNC'
       AND UPPER(COLUMN_NAME) = 'PROPERTY_NAME')
 THEN
 ALTER TABLE VPX_DVHOST_OUT_OF_SYNC ALTER COLUMN PROPERTY_NAME SET NOT NULL;
 END IF;
 END$$;
 /
 
 DO
 $$
 BEGIN
 IF NOT EXISTS(
    SELECT 1 FROM information_schema.constraint_column_usage
    WHERE  UPPER(CONSTRAINT_NAME) = 'PK_DVHOST_OUT_OF_SYNC')
 THEN
 ALTER TABLE VPX_DVHOST_OUT_OF_SYNC
 ADD CONSTRAINT PK_DVHOST_OUT_OF_SYNC primary key (DVS_ID,HOST_ID,PROPERTY_NAME);
 END IF;
 END$$;
 /
 
 
 
 
 
 DELETE
 FROM VPX_STAT_COUNTER
 WHERE (ENTITY_ID IS NULL) OR (STAT_ID IS NULL);
 /
 
 DO
 $$
 BEGIN
 IF NOT EXISTS(
    SELECT 1 FROM information_schema.columns
       WHERE IS_NULLABLE = 'NO'
       AND UPPER(TABLE_NAME) = 'VPX_STAT_COUNTER'
       AND UPPER(COLUMN_NAME) = 'ENTITY_ID')
 THEN
 ALTER TABLE VPX_STAT_COUNTER ALTER COLUMN ENTITY_ID SET NOT NULL;
 END IF;
 END$$;
 /
 
 DO
 $$
 BEGIN
 IF NOT EXISTS(
    SELECT 1 FROM information_schema.columns
       WHERE IS_NULLABLE = 'NO'
       AND UPPER(TABLE_NAME) = 'VPX_STAT_COUNTER'
       AND UPPER(COLUMN_NAME) = 'STAT_ID')
 THEN
 ALTER TABLE VPX_STAT_COUNTER ALTER COLUMN STAT_ID SET NOT NULL;
 END IF;
 END$$;
 /
 DO
 $$
 BEGIN
 IF NOT EXISTS(
    SELECT 1 FROM information_schema.constraint_column_usage
    WHERE  UPPER(CONSTRAINT_NAME) = 'PK_VPX_STAT_COUNTER')
 THEN
 ALTER TABLE VPX_STAT_COUNTER
 ADD CONSTRAINT PK_VPX_STAT_COUNTER PRIMARY KEY (ENTITY_ID,STAT_ID,DEVICE_ID);
 END IF;
 END$$;
 /
 
 
 
 
 DELETE
 FROM VPX_STAT_INTERVAL_DEF
 WHERE (INTERVAL_SEQ_NUM IS NULL);
 /
 
 DO
 $$
 BEGIN
 IF NOT EXISTS(
    SELECT 1 FROM information_schema.columns
       WHERE IS_NULLABLE = 'NO'
       AND UPPER(TABLE_NAME) = 'VPX_STAT_INTERVAL_DEF'
       AND UPPER(COLUMN_NAME) = 'INTERVAL_SEQ_NUM')
 THEN
 ALTER TABLE VPX_STAT_INTERVAL_DEF ALTER COLUMN INTERVAL_SEQ_NUM SET NOT NULL;
 END IF;
 END$$;
 /
 DO
 $$
 BEGIN
 IF NOT EXISTS(
    SELECT 1 FROM information_schema.constraint_column_usage
    WHERE  UPPER(CONSTRAINT_NAME) = 'PK_VPX_STAT_INTERVAL_DEF')
 THEN
 ALTER TABLE VPX_STAT_INTERVAL_DEF
 ADD CONSTRAINT PK_VPX_STAT_INTERVAL_DEF PRIMARY KEY (INTERVAL_SEQ_NUM);
 END IF;
 END$$;
 /
 
 
 
 
 
 DELETE
 FROM VPX_TYPE_MAP
 WHERE (ARRAY_NUM IS NULL) OR (TYPE_NAME IS NULL);
 /
 
 DO
 $$
 BEGIN
 IF NOT EXISTS(
    SELECT 1 FROM information_schema.columns
       WHERE IS_NULLABLE = 'NO'
       AND UPPER(TABLE_NAME) = 'VPX_TYPE_MAP'
       AND UPPER(COLUMN_NAME) = 'TYPE_NAME')
 THEN
 ALTER TABLE VPX_TYPE_MAP ALTER COLUMN TYPE_NAME SET NOT NULL;
 END IF;
 END$$;
 /
 
 DO
 $$
 BEGIN
 IF NOT EXISTS(
    SELECT 1 FROM information_schema.columns
       WHERE IS_NULLABLE = 'NO'
       AND UPPER(TABLE_NAME) = 'VPX_TYPE_MAP'
       AND UPPER(COLUMN_NAME) = 'ARRAY_NUM')
 THEN
 ALTER TABLE VPX_TYPE_MAP ALTER COLUMN ARRAY_NUM SET NOT NULL;
 END IF;
 END$$;
 /
 DO
 $$
 BEGIN
 IF NOT EXISTS(
    SELECT 1 FROM information_schema.constraint_column_usage
    WHERE  UPPER(CONSTRAINT_NAME) = 'PK_VPX_TYPE_MAP')
 THEN
 ALTER TABLE VPX_TYPE_MAP
 ADD CONSTRAINT PK_VPX_TYPE_MAP PRIMARY KEY (TYPE_NAME, ARRAY_NUM);
 END IF;
 END$$;
 /
 
 
 
 
 
 DELETE
 FROM VPX_UPTIME
 WHERE (PROD_ID IS NULL) OR (TERM_ID IS NULL);
 /
 
 DO
 $$
 BEGIN
 IF NOT EXISTS(
    SELECT 1 FROM information_schema.columns
       WHERE IS_NULLABLE = 'NO'
       AND UPPER(TABLE_NAME) = 'VPX_UPTIME'
       AND UPPER(COLUMN_NAME) = 'PROD_ID')
 THEN
 ALTER TABLE VPX_UPTIME ALTER COLUMN PROD_ID SET NOT NULL;
 END IF;
 END$$;
 /
 
 DO
 $$
 BEGIN
 IF NOT EXISTS(
    SELECT 1 FROM information_schema.columns
       WHERE IS_NULLABLE = 'NO'
       AND UPPER(TABLE_NAME) = 'VPX_UPTIME'
       AND UPPER(COLUMN_NAME) = 'TERM_ID')
 THEN
 ALTER TABLE VPX_UPTIME ALTER COLUMN TERM_ID SET NOT NULL;
 END IF;
 END$$;
 /
 
 DO
 $$
 BEGIN
 IF NOT EXISTS(
    SELECT 1 FROM information_schema.constraint_column_usage
    WHERE  UPPER(CONSTRAINT_NAME) = 'PK_VPX_UPTIME')
 THEN
 ALTER TABLE VPX_UPTIME
 ADD CONSTRAINT PK_VPX_UPTIME primary key (PROD_ID,TERM_ID,SURR_KEY);
 END IF;
 END$$;
 /
 DO
 $$
 BEGIN
 IF NOT EXISTS(
    SELECT 1 FROM information_schema.constraint_column_usage
    WHERE  UPPER(CONSTRAINT_NAME) = 'FK_VPX_UPTIME_PRODID')
 THEN
 ALTER TABLE VPX_UPTIME
 ADD CONSTRAINT FK_VPX_UPTIME_PRODID FOREIGN KEY (PROD_ID)
          REFERENCES VPX_PRODUCT (PRODUCT_ID);
 END IF;
 END$$;
 /
 DO
 $$
 BEGIN
 IF NOT EXISTS(
    SELECT 1 FROM information_schema.constraint_column_usage
    WHERE  UPPER(CONSTRAINT_NAME) = 'FK_VPX_UPTIME_TERMID')
 THEN
 ALTER TABLE VPX_UPTIME
 ADD CONSTRAINT FK_VPX_UPTIME_TERMID FOREIGN KEY (TERM_ID)
          REFERENCES VPX_TERMINATION_REASON (TERMINATION_ID);
 END IF;
 END$$;
 /
 
 
 
 
 
 
 
 
 DROP TABLE IF EXISTS VPX_NEW_COUNTERS;
 /
 CREATE TABLE VPX_NEW_COUNTERS
 (COUNTER_ID INTEGER,
  AGGR_TYPE CHAR(1),
  AGGR_TO CHAR(1)
  );
 /
 
 DROP TABLE IF EXISTS VPX_OBJECT_HIERARCHY;
 /
 CREATE TABLE VPX_OBJECT_HIERARCHY
 (ENTITY_TYPE CHAR(1),
  STAT_ENTITY_ID INTEGER,
  PARENT_STAT_ENTITY_ID INTEGER
  );
 /
 
 DROP TABLE IF EXISTS VPX_POPULATED_COUNTERS;
 /
 CREATE TABLE VPX_POPULATED_COUNTERS(
 SC_COUNTER_ID NUMERIC(38),
 INSERTED_COUNTER_ID NUMERIC(38),
 SC_STAT_ID NUMERIC(38)
 );
 /
 
 
 
 
 
 
 
 
 
 
 
 
 
 DO
 $$
 BEGIN
 IF EXISTS (SELECT 1 FROM VPX_STAT_INTERVAL_DEF WHERE UPPER(INTERVAL_DEF_NAME) ='HISTORY.PASTDAY' AND STATS_LEVEL <> 1 ) THEN
    INSERT INTO VPX_NEW_COUNTERS
    SELECT ID,'V','A' 
    FROM VPX_STAT_DEF
    WHERE NAME = 'granted' AND GROUP_NAME = 'mem' AND ROLLUP_TYPE = 0;
 
    INSERT INTO VPX_NEW_COUNTERS
    SELECT ID,'V','A' 
    FROM VPX_STAT_DEF
    WHERE NAME = 'active' AND GROUP_NAME = 'mem' AND ROLLUP_TYPE = 0;
 
    INSERT INTO VPX_NEW_COUNTERS
    SELECT ID,'V','A' 
    FROM VPX_STAT_DEF
    WHERE NAME = 'swapped' AND GROUP_NAME = 'mem' AND ROLLUP_TYPE = 0;
 
    INSERT INTO VPX_NEW_COUNTERS
    SELECT ID,'V','A' 
    FROM VPX_STAT_DEF
    WHERE NAME = 'shared' AND GROUP_NAME = 'mem' AND ROLLUP_TYPE = 0;
 
    INSERT INTO VPX_NEW_COUNTERS
    SELECT ID,'V','A' 
    FROM VPX_STAT_DEF
    WHERE NAME = 'vmmemctl' AND GROUP_NAME = 'mem' AND ROLLUP_TYPE = 0;
 
    INSERT INTO VPX_NEW_COUNTERS
    SELECT ID,'V','A' 
    FROM VPX_STAT_DEF
    WHERE NAME = 'usagemhz' AND GROUP_NAME = 'cpu' AND ROLLUP_TYPE = 0;
 
    INSERT INTO VPX_NEW_COUNTERS
    SELECT ID,'V','A' 
    FROM VPX_STAT_DEF
    WHERE NAME = 'consumed' AND GROUP_NAME = 'mem' AND ROLLUP_TYPE = 0;
 ELSE
    INSERT INTO VPX_NEW_COUNTERS
    SELECT ID,'V','A' 
    FROM VPX_STAT_DEF
    WHERE NAME = 'usagemhz' AND GROUP_NAME = 'cpu' AND ROLLUP_TYPE = 0;
 
    INSERT INTO VPX_NEW_COUNTERS
    SELECT ID,'V','A' 
    FROM VPX_STAT_DEF
    WHERE NAME = 'consumed' AND GROUP_NAME = 'mem' AND ROLLUP_TYPE = 0;
 
 END IF;
 END$$;
 /
 
 CREATE OR REPLACE FUNCTION FN_HIERARCHY (PARENT INT)
 RETURNS SETOF VPX_ENTITY
 AS
 $$
 
     SELECT  FN_HIERARCHY(ID)
     FROM    VPX_ENTITY
     WHERE   PARENT_ID = $1
        AND TYPE_ID = 13
        AND NAME <> 'Resources'
     UNION ALL
     SELECT  VPX_ENTITY
     FROM    VPX_ENTITY
     WHERE   ID = $1
        AND TYPE_ID = 0
     UNION ALL
     SELECT  E2
     FROM VPX_VM V
        INNER JOIN VPX_ENTITY E
           ON E.ID = V.RESOURCE_GROUP_ID
        INNER JOIN  VPX_ENTITY E2
           ON E2.ID = V.ID
      WHERE   E.ID = $1
 
 $$
 LANGUAGE 'sql';
 /
 
 
 
 DO
 $$
 DECLARE r record;
 DECLARE sql_stmt varchar;
 BEGIN
   FOR r IN
     SELECT F.ID AS FID, SI.ID SIID
     FROM VPX_ENTITY F
     INNER JOIN VPX_STAT_ID SI
        ON 'resgroup-v' || CAST(F.ID AS VARCHAR) = SI.MOID
     LOOP
       sql_stmt = 'INSERT INTO VPX_OBJECT_HIERARCHY SELECT ''A'', SI2.ID,';
       sql_stmt = sql_stmt || r.SIID || ' FROM FN_HIERARCHY('|| r.FID ;
       sql_stmt = sql_stmt || ') F INNER JOIN VPX_STAT_ID SI2 ON ''vm-'' ||';
       sql_stmt = sql_stmt || ' F.ID = SI2.MOID';
       EXECUTE sql_stmt;
     END LOOP;
 END$$;
 /
 
 
 DO
 $$
 DECLARE r RECORD;
 DECLARE sql_stmt VARCHAR;
 
 BEGIN
    INSERT INTO VPX_STAT_COUNTER (COUNTER_ID,ENTITY_ID,STAT_ID, DEVICE_ID)
    SELECT (nextval('vpx_stat_counter_seq')),SI.ID, CAST(NEW_COUNTERS AS INTEGER),
        (SELECT DEVICE_ID FROM VPX_DEVICE WHERE DEVICE_NAME ='' OR  DEVICE_NAME =' ') AS DEVICE_ID
    FROM VPX_ENTITY E
    INNER JOIN VPX_STAT_ID SI
    CROSS JOIN (SELECT COUNTER_ID NEW_COUNTERS FROM VPX_NEW_COUNTERS WHERE AGGR_TO='A' ) NC
       ON SI.MOID = 'resgroup-v'|| E.ID
    WHERE TYPE_ID = 13 ;
 
    INSERT INTO VPX_POPULATED_COUNTERS
    SELECT SC.COUNTER_ID, INSERTED.COUNTER_ID, SC.STAT_ID
      FROM VPX_STAT_COUNTER SC
      JOIN VPX_DEVICE D
        ON SC.DEVICE_ID=D.DEVICE_ID
      JOIN VPX_OBJECT_HIERARCHY H
        ON SC.ENTITY_ID = H.STAT_ENTITY_ID
      JOIN (
             SELECT SC.ENTITY_ID, SC.COUNTER_ID,
                    CASE
                      WHEN SD49.NAME='swapused' AND SD49.GROUP_NAME='mem' AND SD49.ROLLUP_TYPE=0
                      THEN (SELECT ID
                              FROM VPX_STAT_DEF
                             WHERE NAME='swapped'
                               AND GROUP_NAME='mem'
                               AND ROLLUP_TYPE=0)
                      ELSE SC.STAT_ID
                    END MODSTAT_ID,
                    NC.AGGR_TO, NC.AGGR_TYPE
               FROM VPX_STAT_ID T
               JOIN VPX_STAT_COUNTER SC
                 ON SC.ENTITY_ID=T.ID
               JOIN VPX_NEW_COUNTERS NC
                 ON NC.COUNTER_ID = SC.STAT_ID
               JOIN VPX_STAT_DEF SD49
                 ON SD49.ID = SC.STAT_ID) INSERTED
        ON H.PARENT_STAT_ENTITY_ID=INSERTED.ENTITY_ID
             AND INSERTED.MODSTAT_ID=SC.STAT_ID
             AND (INSERTED.AGGR_TYPE=H.ENTITY_TYPE OR H.ENTITY_TYPE='A' )
             AND H.ENTITY_TYPE=INSERTED.AGGR_TO
     WHERE D.DEVICE_NAME='' OR D.DEVICE_NAME=' ';
 
 FOR r IN SELECT  table_name
          FROM information_schema.tables
 	 WHERE UPPER(table_name) LIKE 'VPX_HIST_STAT%'
 	   AND table_type = 'BASE TABLE'
    LOOP
       sql_stmt = 'INSERT INTO ' || r.table_name || ' SELECT  PC.INSERTED_COUNTER_ID,HS.TIME_ID,';
       sql_stmt = sql_stmt || 'SUM(HS.STAT_VAL) ';
       sql_stmt = sql_stmt || ' FROM ' || r.table_name || ' HS';
       sql_stmt = sql_stmt || ' JOIN VPX_POPULATED_COUNTERS PC ON HS.COUNTER_ID = PC.SC_COUNTER_ID  ';
       sql_stmt = sql_stmt || ' GROUP BY HS.TIME_ID,PC.SC_STAT_ID,PC.INSERTED_COUNTER_ID; ';
       EXECUTE sql_stmt;
    END LOOP;
 EXCEPTION WHEN OTHERS THEN
 NULL;
 END$$;
 /
 DROP TABLE IF EXISTS VPX_NEW_COUNTERS;
 /
 DROP TABLE IF EXISTS VPX_OBJECT_HIERARCHY;
 /
 DROP FUNCTION IF EXISTS FN_HIERARCHY (PARENT INT);
 /
 DROP TABLE IF EXISTS VPX_POPULATED_COUNTERS;
 /
 
 
 
 
 
 
 
 
 
 DO
 $$
 BEGIN
 IF NOT EXISTS (SELECT 1 FROM VPX_DUAL) THEN
    INSERT INTO VPX_DUAL (DUMMY) VALUES ('X');
 END IF;
 END$$;
 /
 
 
 
 
 CREATE INDEX VPX_STAT_COUNTER_M1 ON VPX_STAT_COUNTER(STAT_ID,COUNTER_ID);
 /
 
 TRUNCATE TABLE VPX_ACCESS;
 /
 
 DELETE FROM CIS_KV_KEYVALUE
  WHERE SURR_KEY IN (
                    SELECT SURR_KEY
                      FROM (SELECT surr_key,
                                   array_to_string(xpath('./principal/name/text()', kv_value::xml), ',') AS principal
                              FROM CIS_KV_KEYVALUE
                             WHERE kv_key LIKE '%\%3Avmomi\%3A%'
                               AND kv_key NOT LIKE '%\%3AInventoryServiceTag\%3A%'
                               AND kv_key NOT LIKE '%\%3AInventoryServiceCategory\%3A%'
 			      AND kv_key NOT LIKE '%\%3ADrRecoveryRecoveryPlan\%3A%'
 			      AND kv_key NOT LIKE '%\%3ADrServiceInstance\%3A%'
 			      )local_os_users
                     WHERE principal NOT LIKE '%@%'
                       AND principal NOT LIKE '%\\%');
 /
 
 INSERT INTO VPX_ACCESS (ID, PRINCIPAL, ROLE_ID, ENTITY_ID, FLAG)
 WITH perm_cte AS (
    SELECT
       (regexp_matches((string_to_array(kv_key, '%3A'))[4], '\d+'))[1]::int AS entity_id,
       array_to_string(xpath('./principal/name/text()', kv_value::xml), ',') AS principal,
       array_to_string(xpath('./roles/text()', kv_value::xml), ',')::int AS role_id,
       CASE WHEN array_to_string(xpath('./principal/group/text()', kv_value::xml), ',') = 'true'
          THEN '1'
          ELSE '0'
       END AS gr,
       CASE WHEN array_to_string(xpath('./propagate/text()', kv_value::xml), ',') = 'true'
          THEN '1'
          ELSE '0'
       END AS prop
    FROM CIS_KV_KEYVALUE
    WHERE kv_key LIKE '%\%3Avmomi\%3A%'
      AND kv_key NOT LIKE '%\%3AInventoryServiceTag\%3A%'
      AND kv_key NOT LIKE '%\%3AInventoryServiceCategory\%3A%'
      AND kv_key NOT LIKE '%\%3ADrRecoveryRecoveryPlan\%3A%'
      AND kv_key NOT LIKE '%\%3ADrServiceInstance\%3A%')
 SELECT
    nextval('vpx_access_seq'),
    principal::varchar(300),
    role_id::int,
    entity_id,
    ((gr || prop)::bit(2))::int
 FROM perm_cte
 WHERE entity_id IN (SELECT ID FROM VPX_ENTITY);
 /
 
 DELETE FROM CIS_KV_KEYVALUE
       WHERE kv_key LIKE '%\%3Avmomi\%3A%'
         AND kv_key NOT LIKE '%\%3AInventoryServiceTag\%3A%'
         AND kv_key NOT LIKE '%\%3AInventoryServiceCategory\%3A%'
         AND kv_key NOT LIKE '%\%3ADrRecoveryRecoveryPlan\%3A%'
 	AND kv_key NOT LIKE '%\%3ADrServiceInstance\%3A%';
 /
 
 
 
 
 
 UPDATE VPX_COMPUTE_RESOURCE
 SET EVC_MODE='amd-greyhound-no3dnow' WHERE EVC_MODE='amd-greyhound-no3dnow-vc50';
 /
 UPDATE VPX_COMPUTE_RESOURCE
 SET EVC_MODE='amd-greyhound' WHERE EVC_MODE='amd-greyhound-vc50';
 /
 
 
 
 
 ALTER TABLE VPX_DVS_VSPAN_SESSION ADD ENCAP_TYPE VARCHAR(50) null;
 /
 
 ALTER TABLE VPX_DVS_VSPAN_SESSION ADD ERSPAN_ID  INTEGER null;
 /
 
 ALTER TABLE VPX_DVS_VSPAN_SESSION ADD ERSPAN_COS INTEGER null;
 /
 
 ALTER TABLE VPX_DVS_VSPAN_SESSION ADD ERSPAN_GRA_NANOSEC NUMERIC(1) null;
 /
 
 
 
 
 
 CREATE TABLE VPX_INFRA_UPD_HA_CLSTR_CFG(
    CLUSTER_ID            INTEGER NOT NULL,
    IS_ENABLED            NUMERIC(1),
    BEHAVIOR              VARCHAR(56),
    MODERATE_REMEDIATION  VARCHAR(56),
    SEVERE_REMEDIATION    VARCHAR(56),
    CONSTRAINT PK_VPX_INFRA_UPD_HA_CLSTR_CFG PRIMARY KEY (CLUSTER_ID),
    CONSTRAINT FK_VPX_INFRA_UPD_HA_CLSTR_CFG FOREIGN KEY (CLUSTER_ID)
       REFERENCES VPX_COMPUTE_RESOURCE(ID) ON DELETE CASCADE
 );
 /
 
 
 
 
 
 CREATE TABLE VPX_INFRA_UPD_HA_PROVIDER(
    PROVIDER_ID    INTEGER NOT NULL,
    PROVIDER_UUID  CHAR(47),
    PROVIDER_NAME  VARCHAR(56),
    USER_NAME      VARCHAR(255),
    CONSTRAINT PK_VPX_INFRA_UPD_HA_PROVIDER PRIMARY KEY (PROVIDER_ID)
 );
 /
 
 
 
 
 
 CREATE TABLE VPX_INFRA_UPD_HA_P_H(
    PROVIDER_ID  INTEGER NOT NULL,
    HOST_ID      INTEGER NOT NULL,
    CONSTRAINT PK_VPX_INFRA_UPD_HA_P_H PRIMARY KEY (PROVIDER_ID, HOST_ID),
    CONSTRAINT FK_VPX_INFRA_UPD_HA_P_H_P FOREIGN KEY (PROVIDER_ID)
       REFERENCES VPX_INFRA_UPD_HA_PROVIDER(PROVIDER_ID) ON DELETE CASCADE,
    CONSTRAINT FK_VPX_INFRA_UPD_HA_P_H_H FOREIGN KEY (HOST_ID)
       REFERENCES VPX_HOST(ID) ON DELETE CASCADE
 );
 /
 
 CREATE INDEX VPXI_INFRA_UPD_HA_P_H_HOST ON VPX_INFRA_UPD_HA_P_H(HOST_ID);
 /
 
 
 
 
 
 CREATE TABLE VPX_INFRA_UPD_HA_CP(
    CLUSTER_ID  INTEGER NOT NULL,
    PROVIDER_ID INTEGER NOT NULL,
    CONSTRAINT PK_VPX_INFRA_UPD_HA_CP PRIMARY KEY (CLUSTER_ID, PROVIDER_ID),
    CONSTRAINT FK_VPX_INFRA_UPD_HA_CP_CID FOREIGN KEY (CLUSTER_ID)
       REFERENCES VPX_INFRA_UPD_HA_CLSTR_CFG(CLUSTER_ID) ON DELETE CASCADE,
    CONSTRAINT FK_VPX_INFRA_UPD_HA_CP_PID FOREIGN KEY (PROVIDER_ID)
       REFERENCES VPX_INFRA_UPD_HA_PROVIDER(PROVIDER_ID) ON DELETE CASCADE
 );
 /
 
 
 
 
 
 CREATE TABLE VPX_INFRA_UPD_HA_HU_INFO(
    HU_INFO_ID     INTEGER NOT NULL,
    PROVIDER_ID    INTEGER,
    NAME           VARCHAR(56),
    COMPONENT_TYPE VARCHAR(56),
    DESCRIPTION    VARCHAR(255),
    CONSTRAINT PK_VPX_INFRA_UPD_HA_HU_INFO PRIMARY KEY (HU_INFO_ID),
    CONSTRAINT FK_VPX_INFRA_UPD_HA_HU_INFO_P FOREIGN KEY (PROVIDER_ID)
       REFERENCES VPX_INFRA_UPD_HA_PROVIDER(PROVIDER_ID) ON DELETE CASCADE
 );
 /
 
 
 
 
 
 CREATE TABLE VPX_INFRA_UPD_HA_FILTER(
    FILTER_ID   INTEGER NOT NULL,
    PROVIDER_ID INTEGER,
    UUID        CHAR(47),
    NAME        VARCHAR(56),
    CONSTRAINT PK_VPX_INFRA_UPD_HA_FILTER PRIMARY KEY (FILTER_ID),
    CONSTRAINT FK_VPX_INFRA_UPD_HA_FILTER_P FOREIGN KEY (PROVIDER_ID)
       REFERENCES VPX_INFRA_UPD_HA_PROVIDER(PROVIDER_ID) ON DELETE CASCADE
 );
 /
 
 
 
 
 
 CREATE TABLE VPX_INFRA_UPD_HA_FLTR_INF(
    FILTER_ID   INTEGER NOT NULL,
    HU_INFO_ID  INTEGER NOT NULL,
    CONSTRAINT PK_VPX_INFRA_UPD_HA_FLTR_INF PRIMARY KEY (FILTER_ID, HU_INFO_ID),
    CONSTRAINT FK_VPX_INFRA_UPD_HA_FLTR_INF FOREIGN KEY (FILTER_ID)
       REFERENCES VPX_INFRA_UPD_HA_FILTER(FILTER_ID) ON DELETE CASCADE
 );
 /
 
 
 
 
 
 CREATE TABLE VPX_INFRA_UPD_HA_F_C_CFG(
    FILTER_ID   INTEGER NOT NULL,
    CLUSTER_ID  INTEGER NOT NULL,
    CONSTRAINT PK_VPX_INFRA_UPD_HA_F_C_CFG PRIMARY KEY (FILTER_ID, CLUSTER_ID),
    CONSTRAINT FK_VPX_INFRA_UPD_HA_F_C_CFG_F FOREIGN KEY (FILTER_ID)
       REFERENCES VPX_INFRA_UPD_HA_FILTER(FILTER_ID) ON DELETE CASCADE,
    CONSTRAINT FK_VPX_INFRA_UPD_HA_F_C_CFG_C FOREIGN KEY (CLUSTER_ID)
       REFERENCES VPX_COMPUTE_RESOURCE(ID) ON DELETE CASCADE
 );
 /
 
 CREATE INDEX VPXI_INFRA_UPD_HA_F_C_CFG_CLU ON VPX_INFRA_UPD_HA_F_C_CFG(CLUSTER_ID);
 /
 
 
 
 
 
 CREATE TABLE VPX_INFRA_UPD_HA_F_H_CFG(
    FILTER_ID   INTEGER NOT NULL,
    HOST_ID     INTEGER NOT NULL,
    CONSTRAINT PK_VPX_INFRA_UPD_HA_F_H_CFG PRIMARY KEY (FILTER_ID, HOST_ID),
    CONSTRAINT FK_VPX_INFRA_UPD_HA_F_H_CFG_F FOREIGN KEY (FILTER_ID)
       REFERENCES VPX_INFRA_UPD_HA_FILTER(FILTER_ID) ON DELETE CASCADE,
    CONSTRAINT FK_VPX_INFRA_UPD_HA_F_H_CFG_C FOREIGN KEY (HOST_ID)
       REFERENCES VPX_HOST(ID) ON DELETE CASCADE
 );
 /
 
 CREATE INDEX VPXI_INFRA_UPD_HA_F_H_CFG_HOST ON VPX_INFRA_UPD_HA_F_H_CFG(HOST_ID);
 /
 
 
 
 
 CREATE TABLE VPX_HOST_VFLASH (
    HOST_ID               INTEGER              not null,
    CAPACITY              VARCHAR(21)          null,
    USAGE                 VARCHAR(21)          null,
    CAPACITY_VMCACHE      VARCHAR(21)          null,
    FREE_VMCACHE          VARCHAR(21)          null,
    ACCESSIBLE            INTEGER              null,
    CONSTRAINT PK_VPX_HOST_VFLASH PRIMARY KEY (HOST_ID),
    CONSTRAINT FK_VPX_HOST_VFLASH FOREIGN KEY (HOST_ID)
       REFERENCES VPX_HOST (ID)
          ON DELETE CASCADE
 )
 ;
 /
 
 
 
 
 ALTER TABLE VPX_COMPUTE_RESOURCE ADD FAILOVER_RESOURCE_REDUCTION INTEGER;
 /
 ALTER TABLE VPX_COMPUTE_RESOURCE ADD FAILOVER_RESOURCE_AUTO_COMPUTE INTEGER;
 /
 
 
 
 
 
 CREATE TABLE VPX_PATCH_VERSION(
     INITIAL_VERSION VARCHAR(10) NOT NULL,
     CURRENT_VERSION VARCHAR(10) NULL);
 /
 
 INSERT INTO VPX_PATCH_VERSION (INITIAL_VERSION) VALUES ('65000');
 /
 
 
 
 
 
 
 
 CREATE TABLE VPX_VCHA_REPL_CHECK(
    REPL_CHECK_VALUE  INTEGER
 );
 /
 INSERT INTO VPX_VCHA_REPL_CHECK(REPL_CHECK_VALUE) VALUES (1);
 /
 
 
 
 
 ALTER TABLE VPX_NETWORK ADD OPAQUE_CAPABILITY TEXT null;
 /
 ALTER TABLE VPX_NETWORK ADD OPAQUE_EXTRA_CONFIG TEXT null;
 /
 
 
 
 
 ALTER TABLE VPX_COMPUTE_RESOURCE ADD PROACTIVE_DRS_ENABLED NUMERIC(1);
 /
 
 
 
 
 
 
 ALTER TABLE CIS_KV_KEYVALUE DROP CONSTRAINT IF EXISTS PK_CIS_KV_KEYVALUE;
 /
 
 ALTER TABLE CIS_KV_KEYVALUE ADD CONSTRAINT PK_CIS_KV_KEYVALUE
    PRIMARY KEY(KV_PROVIDER, SURR_KEY);
 /
 
 
 
 
 ALTER TABLE VPX_HOST ADD PMEM_CAPACITY_IN_MB BIGINT NULL;
 /
 ALTER TABLE VPX_HOST ADD CRYPTO_STATE INTEGER NULL;
 /
 ALTER TABLE VPX_HOST ADD CRYPTO_KEY_ID VARCHAR(255) NULL;
 /
 ALTER TABLE VPX_HOST ADD CRYPTO_KEY_PROVIDER_ID VARCHAR(255) NULL;
 /
 
 
 
 
 DO $$
 DECLARE r RECORD;
 DECLARE sql_stmt VARCHAR;
 
 BEGIN
    FOR r IN SELECT c.relname
             FROM pg_constraint con
             JOIN pg_class c
               ON con.conrelid = c.oid
             LEFT JOIN pg_index i
               ON con.conrelid = i.indrelid
               AND con.conindid = i.indexrelid
            WHERE UPPER(c.relname) LIKE 'VPX_HIST_STAT%'
               AND i.indisclustered='t'
     LOOP
       sql_stmt = 'ALTER TABLE '||  r.table_name ||' SET WITHOUT CLUSTER;';
       EXECUTE sql_stmt;
     END LOOP;
 EXCEPTION WHEN OTHERS THEN
 NULL;
 END$$;
 /
 
 
 
 
 DO $$
 DECLARE r RECORD;
 DECLARE sql_stmt VARCHAR;
 
 BEGIN
    ALTER TABLE VPX_USAGE_STAT SET WITHOUT CLUSTER;
 EXCEPTION WHEN OTHERS THEN
 NULL;
 END$$;
 
 
 
 
 DO $$
 DECLARE l_sn_vdevice_backing_seq int;
 DECLARE l_vdevice_backing_seq int;
 DECLARE sql_stmt VARCHAR;
 
 BEGIN
    SELECT COALESCE(MAX(backing_id), 0)
       INTO l_sn_vdevice_backing_seq
    FROM VPX_SN_VDEVICE_BACKING_REL;
 
    SELECT COALESCE(MAX(backing_id), 0)
       INTO l_vdevice_backing_seq
    FROM VPX_VDEVICE_BACKING_REL;
 
    IF l_sn_vdevice_backing_seq >= l_vdevice_backing_seq THEN
       l_sn_vdevice_backing_seq = l_sn_vdevice_backing_seq + 200;
       sql_stmt = 'ALTER SEQUENCE VPX_VDEVICE_BACKING_REL_SEQ RESTART WITH '
          || l_sn_vdevice_backing_seq || ';';
       EXECUTE sql_stmt;
    END IF;
 END$$;
 /
 
 
 
 
 ALTER TABLE VPX_HOST_VM_CONFIG_OPTION SET (autovacuum_vacuum_scale_factor = 0.05);
 ALTER TABLE VPX_HOST_VM_CONFIG_OPTION SET (toast.autovacuum_vacuum_scale_factor = 0.05);
 ALTER TABLE VPX_HOST_VM_CONFIG_OPTION SET (autovacuum_analyze_scale_factor = 0.05);
 ALTER TABLE VPX_HOST_VM_CONFIG_OPTION SET (autovacuum_vacuum_threshold = 25);
 ALTER TABLE VPX_HOST_VM_CONFIG_OPTION SET (toast.autovacuum_vacuum_threshold = 25);
 ALTER TABLE VPX_HOST_VM_CONFIG_OPTION SET (autovacuum_analyze_threshold = 25);
 ALTER TABLE VPX_HOST_VM_CONFIG_OPTION SET (autovacuum_vacuum_cost_delay = 10);
 ALTER TABLE VPX_HOST_VM_CONFIG_OPTION SET (toast.autovacuum_vacuum_cost_delay = 10);
 ALTER TABLE VPX_HOST_VM_CONFIG_OPTION SET (autovacuum_vacuum_cost_limit = 1000);
 ALTER TABLE VPX_HOST_VM_CONFIG_OPTION SET (toast.autovacuum_vacuum_cost_limit = 1000);
 /