'''
VCDB b2b constants
'''
from os import path


# log files
PATCH_OUT_LOG = "vcdb_patch.out"
PATCH_ERR_LOG = "vcdb_patch.err"
PRE_PATCH_OUT_LOG = "vcdb_pre_patch.out"
PRE_PATCH_ERR_LOG = "vcdb_pre_patch.err"

# get the __init__.py script folder
INIT_FOLDER = path.abspath(path.dirname(__file__))

DBC_UPGRADE_FOLDER = path.join(INIT_FOLDER, "dbupgrade")
DBC_UPGRADE_BINARY = path.join(DBC_UPGRADE_FOLDER, "dbcupgrade")

SRC_VC_CFG_HOME_LIN = "/etc/vmware-vpx"
SRC_VC_SSL_PATH_LIN = "/etc/vmware-vpx/ssl"

SRC_VC_CFG_HOME_LIN = "/etc/vmware-vpx"

XML_CFG_FILE = "/usr/lib/vmware-vpx/py/xmlcfg.py"
VPXD_CFG_FILE = path.join(SRC_VC_CFG_HOME_LIN, "vpxd.cfg")

PYTHON = "python"
OPEN_SSL = "openssl"
RUI_KEY_FILE = path.join(SRC_VC_SSL_PATH_LIN, "rui.key")
LIBODBC_SO_2 = path.join(DBC_UPGRADE_FOLDER, "libodbc.so.2")
LD_PATH = "%s:/usr/lib/vmware-vpx" % DBC_UPGRADE_FOLDER
FI_SQL_FILE = "/usr/lib/vmware-vpx/sql/VCDB_PostgreSQL.sql"
SYMKEY_FILE = "/etc/vmware-vpx/ssl/symkey.dat"
POSTG_BIN_DIR = "/opt/vmware/vpostgres/current/bin/"
PSQL = path.join(POSTG_BIN_DIR, "psql")
B2B_PATCH_FILE_7 = path.join(DBC_UPGRADE_FOLDER, "Upgrade-v2016-to-v2017/postgresql/b2b_PostgreSQL.sql")
B2B_PATCH_FILE_8 = path.join(DBC_UPGRADE_FOLDER, "Upgrade-v2017-to-v2018/postgresql/b2b_PostgreSQL.sql")

MIN_SUPPORTED_B2B = "650"
DB_VPX_VERSION_67 = "670"
