# Copyright 2017-2018 VMware, Inc. All rights reserved. -- VMware Confidential
"""
Patching the updatemgr-h5.properties file
"""
import logging
import os
import sys

curDir = os.path.abspath(os.path.dirname(__file__))
parentDir = os.path.join(curDir, "..")
sys.path.append(parentDir)
import utils

logger = logging.getLogger(__name__)

def removeFlexRegistration():
    """
    This will remove the flex registration.
    """
    lsPatcher = utils.LSPatch()

    # Unregister the flex endpoints.
    lsPatcher.unregister_flex_endpoints()

    # Cleanup
    lsPatcher.cleanup()

def doPatching(ctx):
    logger.info("Patch5_0: being executed %s", ctx)

    # Remove flex registration.
    removeFlexRegistration()
