"""
Copyright 2018 VMware, Inc.  All rights reserved. -- VMware Confidential
"""

import os
import logging
import sys

curDir = os.path.abspath(os.path.dirname(__file__))
parentDir = os.path.join(curDir, "..")
sys.path.append(parentDir)
import utils

logger = logging.getLogger(__name__)

# New elementes to be added
VAPI_LEVEL_TAG_PATH = 'level'
# Attrib key and value
VAPI_ATTRIB_KEY = 'id'
VAPI_ATTRIB_VALUE = 'vapi'
VUMVAPI_ATTRIB_KEY = 'id'
VUMVAPI_ATTRIB_VALUE = 'VumVapi'

def doPatching(ctx):
    logger.info("Patch4_0: being executed %s", ctx)
    patchIntegrityConfig()

def patchIntegrityConfig():
    # If VUM RPM in source and target build are from same build, then RPM
    # upgrade become a no-op and no new config files copies are generated. If no
    # new config files are present (implying VUM RPM is not updated), then will
    # not execute logic to update the package version.
    if not os.path.exists(utils.UPDATED_INTEGRITY_XML):
        logger.info('%s does not exist. Skip patching integrity config'
                    % utils.UPDATED_INTEGRITY_XML)
        return

    # Patch vci-integrity.xml from vci-integrity.xml.rpmnew
    xmlMerger = utils.XmlMerger(utils.INTEGRITY_XML, utils.UPDATED_INTEGRITY_XML)

    # Add <level id="vapi">
    xmlMerger.add(VAPI_LEVEL_TAG_PATH, \
                              VAPI_ATTRIB_KEY, \
                              VAPI_ATTRIB_VALUE)

    # Add <level id="VumVapi">
    xmlMerger.add(VAPI_LEVEL_TAG_PATH, \
                              VUMVAPI_ATTRIB_KEY, \
                              VUMVAPI_ATTRIB_VALUE)

    # Save changes into vci-integrity.xml
    xmlMerger.saveToFile()
