"""
Copyright 2016-2018 VMware, Inc.  All rights reserved. -- VMware Confidential
"""

import os
import logging
import sys

curDir = os.path.abspath(os.path.dirname(__file__))
parentDir = os.path.join(curDir, "..")
sys.path.append(parentDir)
import utils

logger = logging.getLogger(__name__)

# New elementes to be added
VCI_VAPI_TAG_PATH = "plugins/vci_vapi"
OUTPUT_TO_CONSOLE_TAG_PATH = "log/outputToConsole"
OUTPUT_TO_SYSLOG_TAG_PATH = "log/outputToSyslog"
SYSLOG_TAG_PATH = "log/syslog"

# Old elements to be deleted
VALM_TAG_PATH = "valm"
ESX_THIRD_PARTY_UPDATE_URL_TAG_PATH = "HostConfig/ESXThirdPartyUpdateUrl"
VA_UPGRADE_ENABLED_TAG_PATH = "contentSettings/vaUpgradeEnabled"

def doPatching(ctx):
    logger.info("Patch1_0: being executed %s", ctx)
    patchIntegrityConfig()

def patchIntegrityConfig():
    # If VUM RPM in source and target build are from same build, then RPM
    # upgrade become a no-op and no new config files copies are generated. If no
    # new config files are present (implying VUM RPM is not updated), then will
    # not execute logic to update the package version.
    if not os.path.exists(utils.UPDATED_INTEGRITY_XML):
        logger.info('%s does not exist. Skip patching integrity config'
                    % utils.UPDATED_INTEGRITY_XML)
        return

    # Patch vci-integrity.xml from vci-integrity.xml.rpmnew
    xmlMerger = utils.XmlMerger(utils.INTEGRITY_XML, utils.UPDATED_INTEGRITY_XML)

    xmlMerger.add(VCI_VAPI_TAG_PATH)
    xmlMerger.add(OUTPUT_TO_CONSOLE_TAG_PATH)
    xmlMerger.add(OUTPUT_TO_SYSLOG_TAG_PATH)
    xmlMerger.add(SYSLOG_TAG_PATH)

    xmlMerger.delete(VALM_TAG_PATH)
    xmlMerger.delete(ESX_THIRD_PARTY_UPDATE_URL_TAG_PATH)
    xmlMerger.delete(VA_UPGRADE_ENABLED_TAG_PATH)

    # Save changes into vci-integrity.xml
    xmlMerger.saveToFile()
