"""
Copyright 2021 VMware, Inc.  All rights reserved. -- VMware Confidential
"""

import logging
import os
import sys

curDir = os.path.abspath(os.path.dirname(__file__))
parentDir = os.path.join(curDir, "..")
sys.path.append(parentDir)
import utils

logger = logging.getLogger(__name__)

DB_PASSWORD_TAG_PATH = "database/password"

def doPatching(ctx):
    logger.info("Patch15_5: being executed %s", ctx)
    # If VUM RPM in source and target build are from same build, then RPM
    # upgrade become a no-op and no new config files copies are generated. If no
    # new config files are present (implying VUM RPM is not updated), then will
    # not execute logic to update the package version.
    if not os.path.exists(utils.UPDATED_INTEGRITY_XML):
        logger.info('%s does not exist. Skip patching integrity config'
                    % utils.UPDATED_INTEGRITY_XML)
        return

    # Patch vci-integrity.xml from vci-integrity.xml.rpmnew
    xmlMerger = utils.XmlMerger(utils.INTEGRITY_XML, \
                                utils.UPDATED_INTEGRITY_XML)

    # Delete <database/password>
    xmlMerger.delete(DB_PASSWORD_TAG_PATH)

    # Save changes into vci-integrity.xml
    xmlMerger.saveToFile()
