"""
Copyright 2021 VMware, Inc.  All rights reserved. -- VMware Confidential
"""

import os
import logging
import sys

curDir = os.path.abspath(os.path.dirname(__file__))
parentDir = os.path.join(curDir, "..")
sys.path.append(parentDir)
import utils

logger = logging.getLogger(__name__)

# Unsupported solutions path
UNSUPPORTED_SOLUTIONS_PATH = "plugins/vci_vapi/UnsupportedSolutions"

#vSAN witness software spec tag
VSAN_WITNESS_SOFTWARE_SPEC = "VsanWitnessSoftwareSpec"

#vSAN witness tag
VSAN_WITNESS = "VsanWitness"

def doPatching(ctx):
    logger.info("Patch13_0: being executed %s", ctx)
    # If VUM RPM in source and target build are from same build, then RPM
    # upgrade become a no-op and no new config files copies are generated. If no
    # new config files are present (implying VUM RPM is not updated), then will
    # not execute logic to update the package version.
    if not os.path.exists(utils.UPDATED_INTEGRITY_XML):
        logger.info('%s does not exist. Skip patching integrity config'
                    % utils.UPDATED_INTEGRITY_XML)
        return

    # Patch vci-integrity.xml from vci-integrity.xml.rpmnew
    xmlMerger = utils.XmlMerger(utils.INTEGRITY_XML, \
                                utils.UPDATED_INTEGRITY_XML)

    # Replace <UnsupportedSolutions>
    xmlMerger.replace(UNSUPPORTED_SOLUTIONS_PATH)

    # Remove vSAN witness software spec tag
    xmlMerger.delete(VSAN_WITNESS_SOFTWARE_SPEC)

    # Add vSAN witness tag
    xmlMerger.add(VSAN_WITNESS)

    # Save changes into vci-integrity.xml
    xmlMerger.saveToFile()
