"""
Copyright 2021 VMware, Inc.  All rights reserved. -- VMware Confidential
"""

import os
import logging
import sys

curDir = os.path.abspath(os.path.dirname(__file__))
parentDir = os.path.join(curDir, "..")
sys.path.append(parentDir)
import utils

logger = logging.getLogger(__name__)

# New elementes to be added
LOG_LEVEL_TAG_PATH = 'level'
# Attrib key and value
LOG_ATTRIB_KEY = 'id'
LOG_ATTRIB_VALUES = ['VapiPlugin', 'VcIntegrity', 'Diagnose', 'BaselineMgr',
'InventoryMonitor', 'InventoryTree', 'Database', 'JobDispatcher',
'ComplianceStatusMgr', 'SessionMgr', 'Activation', 'Activation.trace',
'ResponseFilter', 'lib.vdb.vdbStatement', 'lib.vdb.vdb', 'ScheduledTaskMgr',
'UpdateMgr', 'EmailAlertMgr', 'ConfigurationMgr', 'GAUpgrader',
'OfflineRemediateTask', 'SingleHostRemediateTask', 'SingleHostScanTask',
'SingleLinuxScanTask', 'SingleOnlineScanTask', 'SingleRemediateTask',
'SinngleVMToolsRemediateTask', 'VciOfflineScanTask', 'VciRemediateTask',
'VciConfigureToolsUpgradeTask', 'VciScanTask', 'VciSigUpdateTask',
'VciCleanupTask', 'InternalScheduledTasksMgr', 'SingleVMToolsRemediateTask', 
'DownloadMgr', 'VcTaskMonitor', 'VaCimClientXML', 'vixCommands', 'vixSupport',
'VADiscovery', 'VirtApplianceManager', 'HostUpgradeRemediate', 'HostUpgrade',
'HostUpgradeMetadata', 'HostStatusChecker', 'httpDownload', 'miscUtil']

LOG_COMPONENT_PATH = "log/components"

LOG_MAX_FILE_NUM = "log/maxFileNum"


#vSAN Witness Tag
VSAN_WITNESS_SOFTWARE_SPEC = 'VsanWitnessSoftwareSpec'


def doPatching(ctx):
    logger.info("Patch12_0: being executed %s", ctx)
    patchIntegrityConfig()

def patchIntegrityConfig():
    # If VUM RPM in source and target build are from same build, then RPM
    # upgrade become a no-op and no new config files copies are generated. If no
    # new config files are present (implying VUM RPM is not updated), then will
    # not execute logic to update the package version.
    if not os.path.exists(utils.UPDATED_INTEGRITY_XML):
        logger.info('%s does not exist. Skip patching integrity config'
                    % utils.UPDATED_INTEGRITY_XML)
        return

    # Patch vci-integrity.xml from vci-integrity.xml.rpmnew
    xmlMerger = utils.XmlMerger(utils.INTEGRITY_XML, utils.UPDATED_INTEGRITY_XML)

    # Add logger tag for components at root level
    for LOG_ATTRIB_VALUE in LOG_ATTRIB_VALUES:
       xmlMerger.add(LOG_LEVEL_TAG_PATH, \
                              LOG_ATTRIB_KEY, \
                              LOG_ATTRIB_VALUE)

    # Remove Logger tag from log level
    # except Activation.trace contains information about rest call invoke
    # logging
    for LOG_ATTRIB_VALUE in LOG_ATTRIB_VALUES:
       if LOG_ATTRIB_VALUE != 'Activation.trace':
          xmlMerger.delete(LOG_COMPONENT_PATH + '/' + LOG_ATTRIB_VALUE, force=True)

    #update max file number of log
    xmlMerger.update(LOG_MAX_FILE_NUM)

    # Add vSAN witness related tag
    xmlMerger.add(VSAN_WITNESS_SOFTWARE_SPEC);

    # Save changes into vci-integrity.xml
    xmlMerger.saveToFile()
