#!/usr/bin/env python

#
# Copyright 2016-2017 VMware, Inc.  All rights reserved. -- VMware Confidential
#
"""
Contains sample patch script that does nothing.

Patch scripts must be named "patch_*.py" and must define a unique sub-class of the
PatchBase abstract class. Patches will be sorted by version and will be applied incrementally.
"""

import logging

from ...patches.base import PatchBase
from l10n import localizedString, msgMetadata as _T
from distutils.version import LooseVersion

logger = logging.getLogger(__name__)


class PatchTest(PatchBase):
   """
   Sample patch class to illustrate the patch integration.
   """

   def __init__(self):
      """
      Constructor
      Set the patch version and summary.
      """

      version = LooseVersion("6.5.1.312")
      summary = localizedString(_T(
            "vapi.endpoint.patch_test.summary",
            "This is a sample patch to illustrate the work with the patching framework."))
      PatchBase.__init__(self, version, summary)

   def do_patching(self, patch_context):
      """
      Patch logic goes here.

      :param patch_context: Context given by the patch framework
      :type patch_context: PatchContext

      :raise UserError: Error that will be reported to the user.
      """
      logger.info('Test patch was applied')
