#!/usr/bin/env python

#
# Copyright 2020 VMware, Inc.  All rights reserved. -- VMware Confidential
#
"""
Patches vapi endpoint log4j properties file by adding configuration for the shim loggers
"""

import logging
from .. import properties_util
from .base import PatchBase
from l10n import localizedString, msgMetadata as _T
from distutils.version import LooseVersion

logger = logging.getLogger(__name__)


class Patch_1_0_0_5(PatchBase):
   def __init__(self):
      version = LooseVersion("1.0.0.5")
      summary = localizedString(_T(
            "vapi.endpoint.patch_1_0_0_5.summary",
            "Patch vapi endpoint log4j properties file"))
      PatchBase.__init__(self, version, summary)

   def do_patching(self, patch_context):
      """
      Patch logic goes here.

      :param patch_context: Context given by the patch framework
      :type patch_context: PatchContext

      :raise UserError: Error that will be reported to the user.
      """
      log4j_file = "/etc/vmware-vapi/endpoint-log4j.properties"
      properties_util.backup(log4j_file)

      properties_util.add(log4j_file, 'log4j.additivity.com.vmware.activity', 'false')
      properties_util.add(log4j_file, 'log4j.additivity.com.vmware.vcenter', 'false')
      properties_util.add(log4j_file, 'log4j.additivity.com.vmware.vsphere', 'false')
      properties_util.add(log4j_file, 'log4j.additivity.com.vmware.vsphereshim', 'false')
