#!/usr/bin/env python

#
# Copyright 2016 VMware, Inc.  All rights reserved. -- VMware Confidential
#
"""
Contains the base class for all patch scripts.
Copied from NGC:
//depot/vsphere-client-modules/
   vmkernel-main/assembler/patch/vsphere_client/patches/base.py
"""

from distutils.version import LooseVersion
from l10n import LocalizableMessage
from patch_errors import UserError


class PatchBase:
   """
   Abstract base class for all patches.
   """

   def __init__(self, version, summary):
      """
      Constructor

      :param version: Version of the patch
      :type version: LooseVersion

      :param summary: Patch description
      :type summary: LocalizableMessage
      """
      if not isinstance(version, LooseVersion):
         raise TypeError('Wrong type of version parameter')

      self.version = version
      self.summary = summary

   def get_version(self):
      """
      :return: Patch version
      :rtype: LooseVersion
      """
      return self.version

   def get_summary(self):
      """
      :return: Patch description string
      :rtype: LocalizableMessage
      """
      return self.summary

   def do_patching(self, patch_context):
      """
      Abstract method to be implemented in descendant classes.
      Perform incremental patching.

      :param patch_context: Context given by the patch framework
      :type patch_context: PatchContext

      :raise UserError: Error that will be reported to the user.
      """
      raise NotImplementedError()
