#!/usr/bin/env python

#
# Copyright 2019 VMware, Inc.  All rights reserved. -- VMware Confidential
#
"""
Patch script that does the following:
Adds trustmanagement.grpc.port property to trustmanagement.properties file, if not present

"""
import logging
import os
import sys

vmware_python_path = os.getenv('VMWARE_PYTHON_PATH')
if vmware_python_path and os.path.exists(vmware_python_path):
    sys.path.append(vmware_python_path)
TM_PATCHES_DIR = os.path.dirname(os.path.dirname(__file__))
sys.path.append(TM_PATCHES_DIR)

import patch_04
from fss_utils import getTargetFSS
from utils import update_patch_version

logger = logging.getLogger(__name__)

PATCH_VERSION = 6

def doPatching(ctx):
    if getTargetFSS("HybridVC_SyncaaS"):
        logger.info("TrustManagement patch for Sync-As-A-Service: %s", ctx)
        patch_04.doPatching(ctx)
        update_patch_version(PATCH_VERSION)
