#
# Copyright 2018-2021 VMware, Inc.  All rights reserved. -- VMware Confidential
#
"""PatchRunner integration hook for topologysvc Service

This module integrates topologysvc patching scripts with the
PatchRunner Framework.

"""
__author__ = 'VMware, Inc.'
__copyright__ = 'Copyright 2021 VMware, Inc. All rights reserved.'

import logging
from l10n import msgMetadata as _T, localizedString as _
from extensions import extend, Hook
import vcsa_utils

COMPONENT_NAME = "topologysvc"

logger = logging.getLogger(__name__)


@extend(Hook.Discovery)
def discover(patch_context):
    logger.info("Executing Discovery Hook for topologysvc Service")

    # uses log4j2 in the latest versions where the syntax is different
    replication_config = {"/lib/vmware-topologysvc/config/log4j.properties": None}

    return vcsa_utils.getComponentDiscoveryResult(COMPONENT_NAME,
                                                  displayName=_(
                                                  _T("topologysvc.displayName",
                                                  "Topology Service")),
                                                  replicationConfig=replication_config)

