#
# Copyright 2017-2021 VMware, Inc.  All rights reserved. -- VMware Confidential
#
"""PatchRunner integration hook for SvcAccountMgmt Service

This module integrates SvcAccountMgmt patching scripts with the
PatchRunner Framework.

"""
__author__ = 'VMware, Inc.'
__copyright__ = 'Copyright 2017-2021 VMware, Inc. All rights reserved.'

import logging
import os
import sys


vmware_python_path = os.getenv('VMWARE_PYTHON_PATH')
if vmware_python_path and os.path.exists(vmware_python_path):
    sys.path.append(vmware_python_path)

from extensions import extend, Hook
from l10n import msgMetadata as _T, localizedString as _
from patch_specs import ValidationResult, Question, Mismatch, Requirements, \
    PatchInfo, RequirementsResult

logger = logging.getLogger(__name__)


@extend(Hook.Discovery)
def discover(patch_context):
    pass


@extend(Hook.Patch)
def execute_patch(patch_context):
    # svcaccountmgmt registration with LookupService is handled during
    # firstboot. Since svcaccountmgmt service was introduced in 7.0x GA and
    # RDU is supported from M14, no verification is required as the service
    # will already be registered with LS.
    pass
